/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.Internal
public final class WinRunnerMediator {
    private static final Logger LOG = Logger.getInstance(WinRunnerMediator.class);
    private static final char IAC = '\u0005';
    private static final char BRK = '\u0003';
    private static final char C = '\u0005';
    private static final String RUNNERW = "runnerw.exe";
    private static final String IDEA_RUNNERW = "IDEA_RUNNERW";
    private static final Key<Boolean> MEDIATOR_KEY = Key.create((String)"KillableProcessHandler.Mediator.Process");

    private WinRunnerMediator() {
    }

    private static boolean sendCtrlEventThroughStream(@NotNull Process process, char event) {
        OutputStream os;
        if (process == null) {
            WinRunnerMediator.$$$reportNull$$$0(0);
        }
        if ((os = process.getOutputStream()) != null) {
            try {
                os.write(5);
                os.write(event);
                os.flush();
                return true;
            }
            catch (IOException e) {
                LOG.info("Cannot send \u0005+" + event + " to runnerw", (Throwable)e);
            }
        }
        return false;
    }

    @Nullable
    private static String getRunnerPath() {
        Path runnerw;
        if (!SystemInfo.isWindows) {
            throw new IllegalStateException("There is no need of runner under unix based OS");
        }
        String path = System.getenv(IDEA_RUNNERW);
        if (path != null) {
            if (new File(path).exists()) {
                return path;
            }
            LOG.warn("Cannot locate a runner at " + path + " (as told by IDEA_RUNNERW)");
        }
        if ((runnerw = PathManager.findBinFile((String)RUNNERW)) != null && Files.exists(runnerw, new LinkOption[0])) {
            return runnerw.toString();
        }
        LOG.warn("Cannot locate runnerw.exe in " + PathManager.getBinPath());
        return null;
    }

    static void injectRunnerCommand(@NotNull GeneralCommandLine commandLine, boolean showConsole) {
        if (commandLine == null) {
            WinRunnerMediator.$$$reportNull$$$0(1);
        }
        if (!SystemInfo.isWindows || WinRunnerMediator.isRunnerCommandInjected(commandLine)) {
            return;
        }
        String path = WinRunnerMediator.getRunnerPath();
        if (path != null) {
            commandLine.getParametersList().addAt(0, commandLine.getExePath());
            if (showConsole) {
                commandLine.getParametersList().addAt(0, "/C");
            }
            commandLine.setExePath(path);
            MEDIATOR_KEY.set((UserDataHolder)commandLine, (Object)true);
        }
    }

    static boolean isRunnerCommandInjected(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WinRunnerMediator.$$$reportNull$$$0(2);
        }
        return MEDIATOR_KEY.get((UserDataHolder)commandLine) == Boolean.TRUE;
    }

    static boolean destroyProcess(@NotNull Process process, boolean softKill) {
        if (process == null) {
            WinRunnerMediator.$$$reportNull$$$0(3);
        }
        if (SystemInfo.isWindows) {
            return WinRunnerMediator.sendCtrlEventThroughStream(process, softKill ? (char)'\u0005' : '\u0003');
        }
        return false;
    }

    public static void withExternalConsole(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WinRunnerMediator.$$$reportNull$$$0(4);
        }
        WinRunnerMediator.injectRunnerCommand(commandLine, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/process/WinRunnerMediator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "sendCtrlEventThroughStream";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "injectRunnerCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isRunnerCommandInjected";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "destroyProcess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "withExternalConsole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

