/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Access;
import com.intellij.util.lang.Xxh3Impl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.jetbrains.annotations.NotNull;

class InputStreamAccess
implements Access<InputStream> {
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private byte[] buffer = new byte[Xxh3Impl.getBlockLength()];
    private int currentBlock = -1;
    private final int totalStreamLength;
    private final int roundedUpTotalBlocks;
    private boolean isLatestBlockRead = false;
    private int zeroPositionOffset = 0;

    InputStreamAccess(int streamLength) {
        this.totalStreamLength = streamLength;
        this.roundedUpTotalBlocks = (int)Math.ceil((double)streamLength / (double)Xxh3Impl.getBlockLength());
    }

    @Override
    public long i64(InputStream input, int offset) {
        int positionInBuffer = this.actualizeBufferAndGetPosition(input, offset, 7);
        return LONG_HANDLE.get(this.buffer, positionInBuffer);
    }

    @Override
    public int i32(InputStream input, int offset) {
        int positionInBuffer = this.actualizeBufferAndGetPosition(input, offset, 3);
        return INT_HANDLE.get(this.buffer, positionInBuffer);
    }

    @Override
    public int i8(InputStream input, int offset) {
        int positionInBuffer = this.actualizeBufferAndGetPosition(input, offset, 0);
        return this.buffer[positionInBuffer];
    }

    private int actualizeBufferAndGetPosition(InputStream input, int offset, int align) {
        int blockLength = Xxh3Impl.getBlockLength();
        int requestedBlock = (offset + align) / blockLength;
        int positionInBuffer = offset % blockLength;
        if (this.isLatestBlockRead) {
            return offset - this.zeroPositionOffset;
        }
        if (requestedBlock == this.currentBlock) {
            return positionInBuffer;
        }
        if (requestedBlock > this.currentBlock) {
            try {
                if (requestedBlock + 2 == this.roundedUpTotalBlocks || requestedBlock + 1 == this.roundedUpTotalBlocks) {
                    int remainingBufferSize = this.totalStreamLength - requestedBlock * blockLength;
                    this.buffer = new byte[remainingBufferSize];
                    this.readDataFromStreamToBuffer(input);
                    this.zeroPositionOffset = requestedBlock * blockLength;
                    this.isLatestBlockRead = true;
                    ++this.currentBlock;
                    return positionInBuffer;
                }
                this.readDataFromStreamToBuffer(input);
                ++this.currentBlock;
                return positionInBuffer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Unexpected state at InputStream hashing");
    }

    private void readDataFromStreamToBuffer(@NotNull InputStream input) throws IOException {
        int bytesRead;
        if (input == null) {
            InputStreamAccess.$$$reportNull$$$0(0);
        }
        if ((bytesRead = input.readNBytes(this.buffer, 0, this.buffer.length)) < this.buffer.length) {
            throw new IOException("Unexpected end of stream (" + bytesRead + " bytes read; " + this.buffer.length + " expected; totalBlocks = " + this.roundedUpTotalBlocks + "; totalStreamLength = " + this.totalStreamLength + ")");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/util/lang/InputStreamAccess", "readDataFromStreamToBuffer"));
    }
}

