/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.features;

import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.CoreUtilsKt;
import com.intellij.ml.inline.completion.impl.postprocessing.features.SuggestionRepetitionFeatures;
import com.intellij.ml.inline.completion.impl.postprocessing.features.SuggestionSimilarityFeatures;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002\u001a<\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0017H\u0002\u001a\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002\u001a$\u0010\u001a\u001a\n\u0012\u0004\u0012\u0002H\u001b\u0018\u00010\u000e\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u000eH\u0002\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"getSuggestionSimilarityFeatures", "Lcom/intellij/ml/inline/completion/impl/postprocessing/features/SuggestionSimilarityFeatures;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "proposal", "Lcom/intellij/ml/inline/completion/impl/AnalyzedMLCompletionProposal;", "linesCount", "splitTokensRegex", "Lkotlin/text/Regex;", "getSuggestionRepetitionFeatures", "Lcom/intellij/ml/inline/completion/impl/postprocessing/features/SuggestionRepetitionFeatures;", "getLinesSimilarity", "", "", "lines", "", "suggestionLines", "getLines", "firstLineIdx", "maxLines", "nextIdxFunction", "Lkotlin/Function1;", "splitRepeated", "tokens", "longestRepeatedSubsequence", "T", "seq", "intellij.ml.inline.completion"})
@SourceDebugExtension(value={"SMAP\nAICompletionCommonFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AICompletionCommonFeatures.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/features/AICompletionCommonFeaturesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1557#2:110\n1628#2,3:111\n774#2:114\n865#2,2:115\n1567#2:118\n1598#2,3:119\n1567#2:122\n1598#2,4:123\n1601#2:127\n1#3:117\n*S KotlinDebug\n*F\n+ 1 AICompletionCommonFeatures.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/features/AICompletionCommonFeaturesKt\n*L\n13#1:110\n13#1:111,3\n35#1:114\n35#1:115,2\n45#1:118\n45#1:119,3\n47#1:122\n47#1:123,4\n45#1:127\n*E\n"})
public final class AICompletionCommonFeaturesKt {
    @NotNull
    private static final Regex splitTokensRegex = new Regex("\\s+");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SuggestionSimilarityFeatures getSuggestionSimilarityFeatures(@NotNull Document document, int offset, @NotNull AnalyzedMLCompletionProposal proposal, int linesCount) {
        Integer n;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        int lineNum = document.getLineNumber(offset);
        String string = document.getText(new TextRange(document.getLineStartOffset(lineNum), offset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String linePrefix = string;
        String wholeSuggestionText = ((Object)StringsKt.trim((CharSequence)(linePrefix + proposal.getSuggestion()))).toString();
        Iterable $this$map$iv = StringsKt.lines((CharSequence)wholeSuggestionText);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        List suggestionLines = (List)destination$iv$iv;
        List<Double> prevLinesSimilarity = AICompletionCommonFeaturesKt.getLinesSimilarity(AICompletionCommonFeaturesKt.getLines(document, lineNum, linesCount, (Function1<? super Integer, Integer>)((Function1)AICompletionCommonFeaturesKt::getSuggestionSimilarityFeatures$lambda$1)), suggestionLines);
        List<Double> nextLinesSimilarity = AICompletionCommonFeaturesKt.getLinesSimilarity(AICompletionCommonFeaturesKt.getLines(document, lineNum, linesCount, (Function1<? super Integer, Integer>)((Function1)arg_0 -> AICompletionCommonFeaturesKt.getSuggestionSimilarityFeatures$lambda$2(document, arg_0))), suggestionLines);
        Double maxSimilarity = CollectionsKt.maxOrNull((Iterable)CollectionsKt.plus((Collection)prevLinesSimilarity, (Iterable)nextLinesSimilarity));
        int maxPrevLineRelativePosition = CollectionsKt.indexOf(prevLinesSimilarity, (Object)maxSimilarity);
        int maxNextLineRelativePosition = CollectionsKt.indexOf(nextLinesSimilarity, (Object)maxSimilarity);
        Double d = maxSimilarity;
        if (d != null) {
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            n = maxNextLineRelativePosition != -1 && maxPrevLineRelativePosition != -1 ? (maxNextLineRelativePosition < maxPrevLineRelativePosition ? maxNextLineRelativePosition + 1 : -maxPrevLineRelativePosition - 1) : (maxNextLineRelativePosition != -1 ? maxNextLineRelativePosition + 1 : -maxPrevLineRelativePosition - 1);
        } else {
            n = null;
        }
        Integer maxSimilarityPosition = n;
        return new SuggestionSimilarityFeatures((Double)CollectionsKt.firstOrNull(prevLinesSimilarity), (Double)CollectionsKt.firstOrNull(nextLinesSimilarity), maxSimilarity, maxSimilarityPosition);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SuggestionRepetitionFeatures getSuggestionRepetitionFeatures(@NotNull AnalyzedMLCompletionProposal proposal) {
        Integer n;
        List<String> repeatedTokens;
        List<String> list;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        CharSequence charSequence = proposal.getSuggestion();
        Regex regex = splitTokensRegex;
        int n2 = 0;
        Iterable $this$filter$iv = regex.split(charSequence, n2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tokens = (List)destination$iv$iv;
        double distinctTokensRatio = (double)CollectionsKt.distinct((Iterable)tokens).size() / (double)tokens.size();
        List<String> list2 = AICompletionCommonFeaturesKt.longestRepeatedSubsequence(tokens);
        if (list2 != null) {
            List<String> it = list2;
            boolean bl = false;
            list = AICompletionCommonFeaturesKt.splitRepeated(it);
        } else {
            list = null;
        }
        List<String> list3 = repeatedTokens = list;
        Integer maxRepeatingTokensCount = list3 != null ? Integer.valueOf(((Collection)list3).size()) : null;
        List<String> list4 = repeatedTokens;
        if (list4 != null) {
            List<String> it = list4;
            boolean bl = false;
            String[] stringArray = new String[]{CollectionsKt.joinToString$default((Iterable)it, null, null, null, (int)0, null, null, (int)63, null)};
            n = StringsKt.split$default((CharSequence)CollectionsKt.joinToString$default((Iterable)tokens, null, null, null, (int)0, null, null, (int)63, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null).size() - 1;
        } else {
            n = null;
        }
        Integer substringRepetitionCount = n;
        return new SuggestionRepetitionFeatures(distinctTokensRatio, maxRepeatingTokensCount, substringRepetitionCount);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Double> getLinesSimilarity(List<String> lines, List<String> suggestionLines) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = lines;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv2;
            void $this$mapIndexed$iv2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = suggestionLines;
            boolean $i$f$mapIndexed2 = false;
            void var16_16 = $this$mapIndexed$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
            boolean $i$f$mapIndexedTo2 = false;
            int index$iv$iv2 = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                void suggestionIndex;
                void index;
                void it;
                void line;
                int n3;
                if ((n3 = index$iv$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv$iv2;
                int n4 = n3;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(CoreUtilsKt.calculateSimilarity((String)line, (String)it, index == false && (suggestionIndex == false || suggestionIndex == suggestionLines.size() - 1) ? 1.0 : 0.5));
            }
            collection.add(CollectionsKt.maxOrThrow((Iterable)((List)destination$iv$iv2)));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final List<String> getLines(Document document, int firstLineIdx, int maxLines, Function1<? super Integer, Integer> nextIdxFunction) {
        return SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.drop((Sequence)SequencesKt.generateSequence((Object)firstLineIdx, nextIdxFunction), (int)1), arg_0 -> AICompletionCommonFeaturesKt.getLines$lambda$9(document, arg_0)), AICompletionCommonFeaturesKt::getLines$lambda$10), (int)maxLines));
    }

    private static final List<String> splitRepeated(List<String> tokens) {
        int end;
        for (end = tokens.size(); end > 0 && end % 2 == 0 && Intrinsics.areEqual(tokens.subList(0, end / 2), tokens.subList(end / 2, end)); end /= 2) {
        }
        return tokens.subList(0, end);
    }

    private static final <T> List<T> longestRepeatedSubsequence(List<? extends T> seq) {
        int n = seq.size();
        int[] prev_mem = null;
        prev_mem = new int[n + 1];
        int[] mem = null;
        mem = new int[n + 1];
        int maxLength = 0;
        int endIndex = 0;
        int i = 1;
        if (i <= n) {
            while (true) {
                int[] nArray;
                int j;
                if ((j = i + 1) <= n) {
                    while (true) {
                        int n2 = mem[j] = Intrinsics.areEqual(seq.get(i - 1), seq.get(j - 1)) && prev_mem[j - 1] < j - i ? prev_mem[j - 1] + 1 : 0;
                        if (mem[j] > maxLength) {
                            maxLength = mem[j];
                            endIndex = Math.max(i, endIndex);
                        }
                        if (j == n) break;
                        ++j;
                    }
                }
                int[] it = nArray = mem;
                boolean bl = false;
                mem = prev_mem;
                prev_mem = nArray;
                if (i == n) break;
                ++i;
            }
        }
        return maxLength > 0 ? CollectionsKt.slice(seq, (IntRange)new IntRange(endIndex - maxLength, endIndex - 1)) : null;
    }

    private static final Integer getSuggestionSimilarityFeatures$lambda$1(int it) {
        return it <= 0 ? null : Integer.valueOf(it - 1);
    }

    private static final Integer getSuggestionSimilarityFeatures$lambda$2(Document $document, int it) {
        return it >= $document.getLineCount() - 1 ? null : Integer.valueOf(it + 1);
    }

    private static final String getLines$lambda$9(Document $document, int it) {
        String string = $document.getText(new TextRange($document.getLineStartOffset(it), $document.getLineEndOffset(it)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final boolean getLines$lambda$10(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }
}

