/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogUiBase;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.CompoundVisibleGraph;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcsLogUi
extends VcsLogUiBase
implements Disposable {
    private static final Logger LOG = Logger.getInstance(AbstractVcsLogUi.class);
    public static final ExtensionPointName<VcsLogHighlighterFactory> LOG_HIGHLIGHTER_FACTORY_EP = ExtensionPointName.create((String)"com.intellij.logHighlighterFactory");
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VcsLogColorManager myColorManager;
    @NotNull
    protected final VisiblePackChangeListener myVisiblePackChangeListener;
    @NotNull
    protected volatile VisiblePack myVisiblePack;

    public AbstractVcsLogUi(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull VisiblePackRefresher refresher) {
        if (id == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(2);
        }
        if (refresher == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(3);
        }
        super(id, logData, refresher);
        this.myVisiblePack = VisiblePack.EMPTY;
        this.myProject = logData.getProject();
        this.myColorManager = manager;
        this.myVisiblePackChangeListener = visiblePack -> UIUtil.invokeLaterIfNeeded(() -> {
            if (!this.myDisposableFlag.isDisposed()) {
                this.setVisiblePack(visiblePack);
            }
        });
        this.myRefresher.addVisiblePackChangeListener(this.myVisiblePackChangeListener);
    }

    public void setVisiblePack(@NotNull VisiblePack pack) {
        if (pack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        boolean permGraphChanged = pack.getVisibleGraph() instanceof CompoundVisibleGraph || this.myVisiblePack.getDataPack() != pack.getDataPack();
        this.myVisiblePack = pack;
        this.onVisiblePackUpdated(permGraphChanged);
        this.fireChangeEvent(this.myVisiblePack, permGraphChanged);
        this.getTable().repaint();
    }

    protected abstract void onVisiblePackUpdated(boolean var1);

    @NotNull
    public VcsLogColorManager getColorManager() {
        VcsLogColorManager vcsLogColorManager = this.myColorManager;
        if (vcsLogColorManager == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(5);
        }
        return vcsLogColorManager;
    }

    @Override
    @NotNull
    public abstract VcsLogGraphTable getTable();

    public void requestMore(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(6);
        }
        VcsLogUtil.requestToLoadMore(this, onLoaded);
        this.getTable().setPaintBusy(true);
    }

    @Override
    @NotNull
    public VisiblePack getDataPack() {
        VisiblePack visiblePack = this.myVisiblePack;
        if (visiblePack == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(7);
        }
        return visiblePack;
    }

    @Override
    @ApiStatus.Internal
    public <T> VcsLogUiEx.JumpResult jumpToSync(@NotNull T commitId, @NotNull BiFunction<? super VisiblePack, ? super T, Integer> rowGetter, boolean silently, boolean focus) {
        int result;
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(8);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(9);
        }
        if ((result = rowGetter.apply((VisiblePack)((VisiblePack)this.myVisiblePack), (VisiblePack)commitId).intValue()) >= 0) {
            this.getTable().jumpToRow(result, focus);
        }
        VcsLogUiEx.JumpResult jumpResult = VcsLogUiEx.JumpResult.fromInt(result);
        if (!silently && jumpResult != VcsLogUiEx.JumpResult.SUCCESS) {
            this.handleCommitNotFound(commitId, jumpResult == VcsLogUiEx.JumpResult.COMMIT_DOES_NOT_MATCH, rowGetter);
        }
        return jumpResult;
    }

    @Override
    public <T> void jumpTo(@NotNull T commitId, @NotNull BiFunction<? super VisiblePack, ? super T, Integer> rowGetter, @NotNull SettableFuture<VcsLogUiEx.JumpResult> future, boolean silently, boolean focus) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(10);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(11);
        }
        if (future == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(12);
        }
        if (!silently) {
            future.addListener(() -> {
                try {
                    VcsLogUiEx.JumpResult result = (VcsLogUiEx.JumpResult)((Object)((Object)future.get()));
                    if (result != VcsLogUiEx.JumpResult.SUCCESS) {
                        this.handleCommitNotFound(commitId, result == VcsLogUiEx.JumpResult.COMMIT_DOES_NOT_MATCH, rowGetter);
                    }
                }
                catch (InterruptedException | CancellationException | ExecutionException exception) {
                    // empty catch block
                }
            }, MoreExecutors.directExecutor());
        }
        this.tryJumpTo(commitId, rowGetter, future, focus);
    }

    public <T> void tryJumpTo(@NotNull T commitId, @NotNull BiFunction<? super VisiblePack, ? super T, Integer> rowGetter, @NotNull SettableFuture<VcsLogUiEx.JumpResult> future, boolean focus) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(13);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(14);
        }
        if (future == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(15);
        }
        if (future.isCancelled()) {
            return;
        }
        int result = rowGetter.apply((VisiblePack)((VisiblePack)this.myVisiblePack), (VisiblePack)commitId);
        if (result >= 0) {
            this.getTable().jumpToRow(result, focus);
            future.set((Object)VcsLogUiEx.JumpResult.SUCCESS);
        } else if (VcsLogUtil.canRequestMore(this.myVisiblePack)) {
            VcsLogUtil.requestToLoadMore(this, () -> this.tryJumpTo(commitId, rowGetter, future, focus));
        } else if (this.myLogData.getDataPack() != this.myVisiblePack.getDataPack() || this.myVisiblePack.canRequestMore() && VcsLogUtil.isMoreRequested(this.myVisiblePack).booleanValue()) {
            VcsLogUtil.invokeOnChange(this, () -> this.tryJumpTo(commitId, rowGetter, future, focus));
        } else if (this.myVisiblePack.getDataPack() instanceof DataPack.ErrorDataPack || this.myVisiblePack instanceof VisiblePack.ErrorVisiblePack) {
            future.set((Object)VcsLogUiEx.JumpResult.fromInt(result));
        } else if (!this.myVisiblePack.isFull()) {
            VcsLogUtil.invokeOnChange(this, () -> this.tryJumpTo(commitId, rowGetter, future, focus));
        } else {
            future.set((Object)VcsLogUiEx.JumpResult.fromInt(result));
        }
    }

    protected <T> void handleCommitNotFound(@NotNull T commitId, boolean commitExists, @NotNull BiFunction<? super VisiblePack, ? super T, Integer> rowGetter) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(16);
        }
        if (rowGetter == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(17);
        }
        String message = AbstractVcsLogUi.getCommitNotFoundMessage(commitId, commitExists);
        VcsNotifier.getInstance((Project)this.myProject).notifyWarning("vcs.log.commit.not.found", "", message);
    }

    @NotNull
    @Nls
    protected static <T> String getCommitNotFoundMessage(@NotNull T commitId, boolean exists) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(18);
        }
        String commitPresentation = AbstractVcsLogUi.getCommitPresentation(commitId);
        String string = exists ? VcsLogBundle.message("vcs.log.commit.does.not.match", commitPresentation) : VcsLogBundle.message("vcs.log.commit.not.found", commitPresentation);
        if (string == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    protected static <T> String getCommitPresentation(@NotNull T commitId) {
        String commitString;
        Hash hash;
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(20);
        }
        if ((hash = AbstractVcsLogUi.getCommitHash(commitId)) != null) {
            String string = VcsLogBundle.message("vcs.log.commit.prefix", hash.toShortString());
            if (string == null) {
                AbstractVcsLogUi.$$$reportNull$$$0(21);
            }
            return string;
        }
        if (commitId instanceof String && VcsLogUtil.HASH_PREFIX_REGEX.matcher(commitString = (String)commitId).matches()) {
            String string = VcsLogBundle.message("vcs.log.commit.or.reference.prefix", VcsLogUtil.getShortHash(commitString));
            if (string == null) {
                AbstractVcsLogUi.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = VcsLogBundle.message("vcs.log.commit.or.reference.prefix", commitId.toString());
        if (string == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    protected static <T> Hash getCommitHash(@NotNull T commitId) {
        if (commitId == null) {
            AbstractVcsLogUi.$$$reportNull$$$0(24);
        }
        if (commitId instanceof Hash) {
            Hash hash = (Hash)commitId;
            return hash;
        }
        if (commitId instanceof CommitId) {
            CommitId id = (CommitId)commitId;
            return id.getHash();
        }
        return null;
    }

    @Override
    public void dispose() {
        ThreadingAssertions.assertEventDispatchThread();
        LOG.debug("Disposing VcsLogUi '" + this.getId() + "'");
        this.myRefresher.removeVisiblePackChangeListener(this.myVisiblePackChangeListener);
        this.getTable().removeAllHighlighters();
        this.myVisiblePack = VisiblePack.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 19, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 5: 
            case 7: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/AbstractVcsLogUi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onLoaded";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/AbstractVcsLogUi";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPack";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitNotFoundMessage";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setVisiblePack";
                break;
            }
            case 5: 
            case 7: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "requestMore";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "jumpToSync";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "jumpTo";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryJumpTo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCommitNotFoundMessage";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCommitPresentation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCommitHash";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 19, 21, 22, 23 -> new IllegalStateException(string);
        };
    }
}

