/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.ide.ConsentOptionsProvider;
import com.intellij.internal.statistic.eventLog.EventLogInternalApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogInternalSendConfig;
import com.intellij.internal.statistic.eventLog.EventLogSendConfig;
import com.intellij.internal.statistic.eventLog.ExternalEventLogSettings;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.connection.EventLogSendListener;
import com.intellij.internal.statistic.eventLog.connection.EventLogStatisticsService;
import com.intellij.internal.statistic.eventLog.connection.EventLogUploadSettingsService;
import com.intellij.internal.statistic.eventLog.connection.StatisticsService;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.Strings;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatisticsUploadAssistant {
    private static final String IDEA_HEADLESS_ENABLE_STATISTICS = "idea.headless.enable.statistics";
    private static final String IDEA_SUPPRESS_REPORT_STATISTICS = "idea.suppress.statistics.report";
    private static final String ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT = "idea.local.statistics.without.report";
    private static final String USE_TEST_STATISTICS_SEND_ENDPOINT = "idea.use.test.statistics.send.endpoint";
    private static final String USE_TEST_STATISTICS_CONFIG = "idea.use.test.statistics.config";
    private static final String DISABLE_COLLECT_STATISTICS = "idea.disable.collect.statistics";

    private StatisticsUploadAssistant() {
    }

    public static boolean isSendAllowed() {
        if (StatisticsUploadAssistant.isSuppressStatisticsReport() || StatisticsUploadAssistant.isLocalStatisticsWithoutReport()) {
            return false;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return StatisticsUploadAssistant.isHeadlessStatisticsEnabled();
        }
        return StatisticsUploadAssistant.isAllowedByUserConsent();
    }

    public static boolean isCollectAllowed() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return StatisticsUploadAssistant.isHeadlessStatisticsEnabled();
        }
        return !StatisticsUploadAssistant.isDisableCollectStatistics() && !StatisticsUploadAssistant.isCollectionForceDisabled() && (StatisticsUploadAssistant.isAllowedByUserConsent() || StatisticsUploadAssistant.isLocalStatisticsWithoutReport());
    }

    public static boolean isAllowedByUserConsent() {
        UsageStatisticsPersistenceComponent settings = UsageStatisticsPersistenceComponent.getInstance();
        if (settings != null && settings.isAllowed()) {
            return true;
        }
        ConsentOptionsProvider consentsProvider = (ConsentOptionsProvider)ApplicationManager.getApplication().getService(ConsentOptionsProvider.class);
        return consentsProvider != null && consentsProvider.isActivatedWithFreeLicense();
    }

    private static boolean isForceCollectEnabled() {
        return StatisticsEventLogProviderUtil.forceLoggingAlwaysEnabled();
    }

    public static boolean isCollectAllowedOrForced() {
        return StatisticsUploadAssistant.isCollectAllowed() || StatisticsUploadAssistant.isForceCollectEnabled();
    }

    public static boolean isCollectionForceDisabled() {
        ExternalEventLogSettings externalEventLogSettings = StatisticsEventLogProviderUtil.getExternalEventLogSettings();
        return externalEventLogSettings != null && externalEventLogSettings.forceDisableCollectionConsent();
    }

    @NlsContexts.DetailedDescription
    @Nullable
    public static String getConsentWarning() {
        ExternalEventLogSettings externalEventLogSettings = StatisticsEventLogProviderUtil.getExternalEventLogSettings();
        return externalEventLogSettings == null ? null : externalEventLogSettings.getConsentWarning();
    }

    private static boolean isHeadlessStatisticsEnabled() {
        return Boolean.getBoolean(IDEA_HEADLESS_ENABLE_STATISTICS);
    }

    public static boolean isTestStatisticsEnabled() {
        return StatisticsUploadAssistant.isLocalStatisticsWithoutReport() || StatisticsUploadAssistant.isTeamcityDetected() || StatisticsUploadAssistant.isUseTestStatisticsSendEndpoint() || StatisticsUploadAssistant.isUseTestStatisticsConfig();
    }

    @NotNull
    public static StatisticsService getEventLogStatisticsService(final @NotNull String recorderId) {
        if (recorderId == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(0);
        }
        EventLogSendListener listener = new EventLogSendListener(){

            @Override
            public void onLogsSend(@NotNull List<String> successfullySentFiles, @NotNull List<Integer> errors, int totalLocalFiles) {
                if (successfullySentFiles == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (errors == null) {
                    1.$$$reportNull$$$0(1);
                }
                int success = successfullySentFiles.size();
                int failed = errors.size();
                StatisticsEventLogProviderUtil.getEventLogProvider(recorderId).getEventLogSystemLogger$intellij_platform_statistics().logFilesSend(totalLocalFiles, success, failed, false, successfullySentFiles, errors);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "successfullySentFiles";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "errors";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/statistic/utils/StatisticsUploadAssistant$1";
                objectArray[2] = "onLogsSend";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return new EventLogStatisticsService((EventLogSendConfig)EventLogInternalSendConfig.createByRecorder(recorderId, true), new EventLogInternalApplicationInfo(StatisticsUploadAssistant.isUseTestStatisticsConfig(), StatisticsUploadAssistant.isUseTestStatisticsSendEndpoint()), listener);
    }

    public static EventLogUploadSettingsService createExternalSettings(@NotNull String recorderId, boolean isTestConfig, boolean isTestSendEndpoint, long cacheTimeoutMs) {
        if (recorderId == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(1);
        }
        return new EventLogUploadSettingsService(recorderId, new EventLogInternalApplicationInfo(isTestConfig, isTestSendEndpoint), cacheTimeoutMs);
    }

    public static boolean isTeamcityDetected() {
        return Strings.isNotEmpty((String)System.getenv("TEAMCITY_VERSION"));
    }

    public static boolean isSuppressStatisticsReport() {
        return Boolean.getBoolean(IDEA_SUPPRESS_REPORT_STATISTICS);
    }

    public static boolean isLocalStatisticsWithoutReport() {
        return Boolean.getBoolean(ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT);
    }

    public static boolean isUseTestStatisticsSendEndpoint() {
        return Boolean.getBoolean(USE_TEST_STATISTICS_SEND_ENDPOINT);
    }

    public static boolean isUseTestStatisticsConfig() {
        return Boolean.getBoolean(USE_TEST_STATISTICS_CONFIG);
    }

    public static boolean isDisableCollectStatistics() {
        return Boolean.getBoolean(DISABLE_COLLECT_STATISTICS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "recorderId";
        objectArray2[1] = "com/intellij/internal/statistic/utils/StatisticsUploadAssistant";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getEventLogStatisticsService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createExternalSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

