/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.vcs.commit.CommitExceptionWithActions;
import com.intellij.vcs.commit.CommitNotification;
import com.intellij.vcs.commit.Committer;
import com.intellij.vcs.commit.CommitterResultHandler;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandlerKt;
import com.intellij.vcs.commit.VcsCommitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0002J\r\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0003J\r\u0010\u0012\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/commit/ShowNotificationCommitResultHandler;", "Lcom/intellij/vcs/commit/CommitterResultHandler;", "committer", "Lcom/intellij/vcs/commit/VcsCommitter;", "<init>", "(Lcom/intellij/vcs/commit/VcsCommitter;)V", "notifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/vcs/VcsNotifier;", "onSuccess", "", "onCancel", "onFailure", "reportResult", "getCommitSummary", "", "Lcom/intellij/openapi/util/NlsSafe;", "getFileSummaryReport", "Lorg/jetbrains/annotations/Nls;", "countChangesIgnoringChangeLists", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nShowNotificationCommitResultHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowNotificationCommitResultHandler.kt\ncom/intellij/vcs/commit/ShowNotificationCommitResultHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n808#2,11:101\n1368#2:112\n1454#2,5:113\n1863#2,2:118\n1557#2:120\n1628#2,3:121\n1557#2:124\n1628#2,3:125\n*S KotlinDebug\n*F\n+ 1 ShowNotificationCommitResultHandler.kt\ncom/intellij/vcs/commit/ShowNotificationCommitResultHandler\n*L\n43#1:101,11\n43#1:112\n43#1:113,5\n61#1:118,2\n78#1:120\n78#1:121,3\n83#1:124\n83#1:125,3\n*E\n"})
public final class ShowNotificationCommitResultHandler
implements CommitterResultHandler {
    @NotNull
    private final VcsCommitter committer;
    private final VcsNotifier notifier;

    public ShowNotificationCommitResultHandler(@NotNull VcsCommitter committer) {
        Intrinsics.checkNotNullParameter((Object)committer, (String)"committer");
        this.committer = committer;
        this.notifier = VcsNotifier.getInstance(this.committer.getProject());
    }

    @Override
    public void onSuccess() {
        this.reportResult();
    }

    @Override
    public void onCancel() {
        this.notifier.notifyMinorWarning("vcs.commit.canceled", "", VcsBundle.message((String)"vcs.commit.canceled", (Object[])new Object[0]));
    }

    @Override
    public void onFailure() {
        this.reportResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void reportResult() {
        Object object;
        String message = this.getCommitSummary();
        List<VcsException> allExceptions = this.committer.getExceptions();
        if (allExceptions.isEmpty()) {
            object = new CommitNotification(VcsNotifier.standardNotification().getDisplayId(), "", message, null, 8, null);
        } else {
            Object object2;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$filterIsInstanceTo$iv$iv;
            List<VcsException> errors = Committer.Companion.collectErrors(allExceptions);
            int errorsSize = errors.size();
            int warningsSize = allExceptions.size() - errorsSize;
            Iterable $this$filterIsInstance$iv = allExceptions;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CommitExceptionWithActions)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                CommitExceptionWithActions it = (CommitExceptionWithActions)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getActions();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List notificationActions = (List)destination$iv$iv;
            String title = null;
            String displayId = null;
            NotificationType notificationType = null;
            if (errorsSize > 0) {
                displayId = "vcs.commit.failed";
                object2 = new Object[]{errorsSize};
                title = VcsBundle.message((String)"message.text.commit.failed.with.error", (Object[])object2);
                notificationType = NotificationType.ERROR;
            } else {
                displayId = "vcs.commit.finished.with.warnings";
                object2 = new Object[]{warningsSize};
                title = VcsBundle.message((String)"message.text.commit.finished.with.warning", (Object[])object2);
                notificationType = NotificationType.WARNING;
            }
            Object $this$reportResult_u24lambda_u241 = object2 = new CommitNotification(VcsNotifier.importantNotification().getDisplayId(), title, message, notificationType);
            boolean bl = false;
            $this$reportResult_u24lambda_u241.setDisplayId(displayId);
            Iterable $this$forEach$iv = notificationActions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnAction p0 = (AnAction)element$iv;
                boolean bl2 = false;
                $this$reportResult_u24lambda_u241.addAction(p0);
            }
            VcsNotifier.addShowDetailsAction(this.committer.getProject(), (Notification)$this$reportResult_u24lambda_u241);
            object = object2;
        }
        Object notification = object;
        notification.expirePreviousAndNotify(this.committer.getProject());
    }

    /*
     * WARNING - void declaration
     */
    @NlsContexts.NotificationContent
    private final String getCommitSummary() {
        List<VcsException> exceptions;
        Collection<HtmlChunk> collection;
        Collection destination$iv$iv;
        HtmlBuilder htmlBuilder;
        HtmlChunk htmlChunk;
        Set<String> feedback;
        HtmlBuilder htmlBuilder2;
        HtmlBuilder $this$getCommitSummary_u24lambda_u243 = htmlBuilder2 = new HtmlBuilder();
        boolean bl = false;
        $this$getCommitSummary_u24lambda_u243.append(this.getFileSummaryReport());
        String commitMessage = this.committer.getCommitMessage();
        if (!StringUtil.isEmpty((String)commitMessage)) {
            $this$getCommitSummary_u24lambda_u243.append(": ").append(commitMessage);
        }
        if (!((Collection)(feedback = this.committer.getFeedback())).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$getCommitSummary_u24lambda_u243.br();
            Iterable iterable = feedback;
            htmlChunk = (HtmlChunk)HtmlChunk.br();
            htmlBuilder = $this$getCommitSummary_u24lambda_u243;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                boolean $i$f$getCommitSummary$lambda$3$stub_for_inlining = false;
                collection.add(HtmlChunk.text((String)p0));
            }
            collection = (List)destination$iv$iv;
            htmlBuilder.appendWithSeparators(htmlChunk, (Iterable)collection);
        }
        if (!ShowNotificationCommitResultHandlerKt.access$hasOnlyWarnings(exceptions = this.committer.getExceptions())) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$getCommitSummary_u24lambda_u243.br();
            Iterable $i$f$map = exceptions;
            htmlChunk = (HtmlChunk)HtmlChunk.br();
            htmlBuilder = $this$getCommitSummary_u24lambda_u243;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VcsException bl2 = (VcsException)((Object)item$iv$iv);
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(HtmlChunk.text((String)it.getMessage()));
            }
            collection = (List)destination$iv$iv2;
            htmlBuilder.appendWithSeparators(htmlChunk, (Iterable)collection);
        }
        String string = htmlBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getFileSummaryReport() {
        int failed = this.countChangesIgnoringChangeLists((Collection<? extends Change>)this.committer.getFailedToCommitChanges());
        int committed = this.countChangesIgnoringChangeLists((Collection<? extends Change>)this.committer.getChanges()) - failed;
        if (failed > 0) {
            Object[] objectArray = new Object[]{committed, failed};
            String string = VcsBundle.message((String)"vcs.commit.files.committed.and.files.failed.to.commit", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        Object[] objectArray = new Object[]{committed};
        String string = VcsBundle.message((String)"vcs.commit.files.committed", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final int countChangesIgnoringChangeLists(Collection<? extends Change> changes) {
        return new HashSet<Change>(changes).size();
    }
}

