/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.MainPassesRunner;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CodeSmellDetector;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.VcsErrorViewPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CodeSmellDetectorImpl
extends CodeSmellDetector {
    private static final Key<Boolean> CODE_SMELL_DETECTOR_KEY = new Key("CODE_SMELL_DETECTOR_KEY");
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(CodeSmellDetectorImpl.class);

    public CodeSmellDetectorImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void showCodeSmellErrors(@NotNull List<CodeSmellInfo> smellList) {
        if (smellList == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(0);
        }
        smellList.sort(Comparator.comparingInt(o -> o.getTextRange().getStartOffset()));
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (smellList.isEmpty()) {
                return;
            }
            VcsErrorViewPanel errorTreeView = new VcsErrorViewPanel(this.myProject);
            FileDocumentManager fileManager = FileDocumentManager.getInstance();
            for (CodeSmellInfo smellInfo : smellList) {
                VirtualFile file = fileManager.getFile(smellInfo.getDocument());
                if (file == null) continue;
                String presentableUrl = file.getPresentableUrl();
                OpenFileDescriptor navigatable = new OpenFileDescriptor(this.myProject, file, smellInfo.getStartLine(), smellInfo.getStartColumn());
                String exportPrefix = NewErrorTreeViewPanel.createExportPrefix((int)(smellInfo.getStartLine() + 1));
                String rendererPrefix = NewErrorTreeViewPanel.createRendererPrefix((int)(smellInfo.getStartLine() + 1), (int)(smellInfo.getStartColumn() + 1));
                if (smellInfo.getSeverity() == HighlightSeverity.ERROR) {
                    errorTreeView.addMessage(4, new String[]{smellInfo.getDescription()}, FileUtil.getLocationRelativeToUserHome((String)presentableUrl), (Navigatable)navigatable, exportPrefix, rendererPrefix, null);
                    continue;
                }
                errorTreeView.addMessage(5, new String[]{smellInfo.getDescription()}, FileUtil.getLocationRelativeToUserHome((String)presentableUrl), (Navigatable)navigatable, exportPrefix, rendererPrefix, null);
            }
            ToolWindow toolWindow = ProblemsView.getToolWindow((Project)this.myProject);
            if (toolWindow != null && toolWindow.isAvailable()) {
                toolWindow.activate(() -> {
                    ContentManager contentManager = toolWindow.getContentManager();
                    for (Content oldContent : contentManager.getContents()) {
                        if (oldContent.isPinned() || !Boolean.TRUE.equals(oldContent.getUserData(CODE_SMELL_DETECTOR_KEY))) continue;
                        contentManager.removeContent(oldContent, true);
                    }
                    ContentImpl content = new ContentImpl((JComponent)((Object)errorTreeView), VcsBundle.message((String)"code.smells.error.messages.tab.name", (Object[])new Object[0]), true);
                    content.putUserData(CODE_SMELL_DETECTOR_KEY, (Object)true);
                    contentManager.addContent((Content)content);
                    contentManager.setSelectedContent((Content)content, true);
                }, true, true);
            } else {
                AbstractVcsHelperImpl helper = (AbstractVcsHelperImpl)AbstractVcsHelper.getInstance((Project)this.myProject);
                helper.openMessagesView(errorTreeView, VcsBundle.message((String)"code.smells.error.messages.tab.name", (Object[])new Object[0]));
            }
        });
    }

    @Override
    @NotNull
    public List<CodeSmellInfo> findCodeSmells(@NotNull List<? extends VirtualFile> filesToCheck) throws ProcessCanceledException {
        if (filesToCheck == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(1);
        }
        MainPassesRunner runner = new MainPassesRunner(this.myProject, VcsBundle.message((String)"checking.code.smells.progress.title", (Object[])new Object[0]), this.getInspectionProfile());
        Map infos = runner.runMainPasses(filesToCheck, HighlightSeverity.WARNING);
        return this.convertErrorsAndWarnings(infos);
    }

    @Nullable
    private InspectionProfile getInspectionProfile() {
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        String codeSmellProfile = vcsConfiguration.CODE_SMELLS_PROFILE;
        InspectionProfileImpl currentProfile = codeSmellProfile != null ? (vcsConfiguration.CODE_SMELLS_PROFILE_LOCAL ? InspectionProfileManager.getInstance() : InspectionProjectProfileManager.getInstance((Project)this.myProject)).getProfile(codeSmellProfile) : null;
        return currentProfile;
    }

    @NotNull
    private List<CodeSmellInfo> convertErrorsAndWarnings(@NotNull Map<Document, List<HighlightInfo>> highlights) {
        if (highlights == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(2);
        }
        ArrayList<CodeSmellInfo> result2 = new ArrayList<CodeSmellInfo>();
        for (Map.Entry<Document, List<HighlightInfo>> e : highlights.entrySet()) {
            Document document = e.getKey();
            List<HighlightInfo> infos = e.getValue();
            for (HighlightInfo info : infos) {
                HighlightSeverity severity = info.getSeverity();
                if (SeverityRegistrar.getSeverityRegistrar((Project)this.myProject).compare(severity, HighlightSeverity.WARNING) < 0) continue;
                result2.add(new CodeSmellInfo(document, CodeSmellDetectorImpl.getDescription(info), new TextRange(info.startOffset, info.endOffset), severity));
            }
        }
        ArrayList<CodeSmellInfo> arrayList = result2;
        if (arrayList == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static String getDescription(@NotNull HighlightInfo highlightInfo) {
        if (highlightInfo == null) {
            CodeSmellDetectorImpl.$$$reportNull$$$0(4);
        }
        String description = highlightInfo.getDescription();
        HighlightInfoType type = highlightInfo.type;
        if (type instanceof HighlightInfoType.HighlightInfoTypeSeverityByKey) {
            HighlightDisplayKey severityKey = ((HighlightInfoType.HighlightInfoTypeSeverityByKey)type).getSeverityKey();
            String id = severityKey.getID();
            return "[" + id + "] " + description;
        }
        return description;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smellList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToCheck";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlights";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/CodeSmellDetectorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertErrorsAndWarnings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showCodeSmellErrors";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findCodeSmells";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertErrorsAndWarnings";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

