/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangesViewCommitPanelSplitterKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.ui.OnePixelSplitter;
import java.beans.PropertyChangeEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\tH\u0002J\b\u0010\u0017\u001a\u00020\u000eH\u0014J\b\u0010\u0018\u001a\u00020\u000eH\u0014J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewCommitPanelSplitter;", "Lcom/intellij/ui/OnePixelSplitter;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentManagerListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isVerticalProportionSet", "", "previousHeight", "", "verticalSecondHeight", "toolWindowMappingChanged", "", "doLayout", "doLayoutRetainingSecondHeight", "calculateInitialVerticalProportion", "getProportionForSecondHeight", "", "secondHeight", "canCalculateVerticalProportion", "isSplitterHeightChanged", "loadProportion", "saveProportion", "saveVerticalProportion", "value", "intellij.platform.vcs.impl"})
final class ChangesViewCommitPanelSplitter
extends OnePixelSplitter
implements ChangesViewContentManagerListener,
Disposable {
    @NotNull
    private final Project project;
    private boolean isVerticalProportionSet;
    private int previousHeight;
    private int verticalSecondHeight;

    public ChangesViewCommitPanelSplitter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(true, "", ChangesViewCommitPanelSplitterKt.access$getDefaultVerticalProportion(project));
        this.project = project;
        this.isVerticalProportionSet = this.isVerticalProportionSet();
        this.addPropertyChangeListener("orientation", arg_0 -> ChangesViewCommitPanelSplitter._init_$lambda$0(this, arg_0));
        this.project.getMessageBus().connect((Disposable)this).subscribe(ChangesViewContentManagerListener.TOPIC, (Object)this);
    }

    private final boolean isVerticalProportionSet() {
        return ChangesViewContentManagerKt.isCommitToolWindowShown(this.project) || ChangesViewCommitPanelSplitterKt.access$getPropertiesComponent().isValueSet(ChangesViewCommitPanelSplitterKt.access$getVerticalProportionKey(this.project));
    }

    @Override
    public void toolWindowMappingChanged() {
        this.isVerticalProportionSet = this.isVerticalProportionSet();
        this.revalidate();
        this.repaint();
    }

    public void doLayout() {
        if (ChangesViewContentManagerKt.isCommitToolWindowShown(this.project)) {
            super.doLayout();
        } else {
            this.calculateInitialVerticalProportion();
            this.doLayoutRetainingSecondHeight();
        }
    }

    private final void doLayoutRetainingSecondHeight() {
        if (this.isVerticalProportionSet && this.canCalculateVerticalProportion() && this.isSplitterHeightChanged()) {
            if (this.isVertical() && this.getSecondComponent().getHeight() > 0) {
                this.setProportion(this.getProportionForSecondHeight(this.getSecondComponent().getHeight()));
            } else if (!this.isVertical() && this.verticalSecondHeight > 0) {
                this.saveVerticalProportion(this.getProportionForSecondHeight(this.verticalSecondHeight));
            }
        }
        super.doLayout();
        this.previousHeight = this.getHeight();
        if (this.isVerticalProportionSet && this.isVertical() && this.canCalculateVerticalProportion()) {
            this.verticalSecondHeight = this.getSecondComponent().getHeight();
        }
    }

    private final void calculateInitialVerticalProportion() {
        if (this.isVerticalProportionSet || !this.isVertical() || !this.canCalculateVerticalProportion()) {
            return;
        }
        this.isVerticalProportionSet = true;
        this.setProportion(this.getProportionForSecondHeight(this.getSecondComponent().getPreferredSize().height));
    }

    private final float getProportionForSecondHeight(int secondHeight) {
        return RangesKt.coerceIn((float)this.getProportionForSecondSize(secondHeight, this.getHeight()), (float)0.05f, (float)0.95f);
    }

    private final boolean canCalculateVerticalProportion() {
        return this.getSecondComponent() != null && this.getHeight() > this.getDividerWidth();
    }

    private final boolean isSplitterHeightChanged() {
        return this.previousHeight != this.getHeight();
    }

    protected void loadProportion() {
        if (!this.isVertical()) {
            this.setProportion(ChangesViewCommitPanelSplitterKt.access$getPropertiesComponent().getFloat("ChangesViewManager.COMMIT_SPLITTER_PROPORTION.HORIZONTAL", 0.4f));
        } else if (this.isVerticalProportionSet) {
            this.setProportion(ChangesViewCommitPanelSplitterKt.access$getPropertiesComponent().getFloat(ChangesViewCommitPanelSplitterKt.access$getVerticalProportionKey(this.project), ChangesViewCommitPanelSplitterKt.access$getDefaultVerticalProportion(this.project)));
        }
    }

    protected void saveProportion() {
        if (!this.isVertical()) {
            ChangesViewCommitPanelSplitterKt.access$getPropertiesComponent().setValue("ChangesViewManager.COMMIT_SPLITTER_PROPORTION.HORIZONTAL", this.getProportion(), 0.4f);
        } else if (this.isVerticalProportionSet) {
            this.saveVerticalProportion(this.getProportion());
        }
    }

    private final void saveVerticalProportion(float value) {
        ChangesViewCommitPanelSplitterKt.access$getPropertiesComponent().setValue(ChangesViewCommitPanelSplitterKt.access$getVerticalProportionKey(this.project), value, ChangesViewCommitPanelSplitterKt.access$getDefaultVerticalProportion(this.project));
    }

    private static final void _init_$lambda$0(ChangesViewCommitPanelSplitter this$0, PropertyChangeEvent it) {
        this$0.loadProportion();
    }
}

