/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.google.common.collect.Ordering;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public enum ApplyPatchStatus {
    SUCCESS,
    PARTIAL,
    ALREADY_APPLIED,
    SKIP,
    FAILURE,
    ABORT;

    static final List<ApplyPatchStatus> ORDERED_TYPES;
    static final Set<ApplyPatchStatus> PARTIAL_ADDITIONAL_SET;
    private static final Ordering<ApplyPatchStatus> ORDERING;

    @Nullable
    @Contract(value="null, null -> null; !null, _ -> !null; _, !null -> !null")
    public static ApplyPatchStatus and(@Nullable ApplyPatchStatus lhs, @Nullable ApplyPatchStatus rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        HashSet statuses = ContainerUtil.newHashSet((Object[])new ApplyPatchStatus[]{lhs, rhs});
        if (PARTIAL_ADDITIONAL_SET.equals(statuses)) {
            return PARTIAL;
        }
        return (ApplyPatchStatus)((Object)ORDERING.max((Object)lhs, (Object)rhs));
    }

    static {
        ORDERED_TYPES = Arrays.asList(SKIP, SUCCESS, ALREADY_APPLIED, PARTIAL, FAILURE, ABORT);
        PARTIAL_ADDITIONAL_SET = ContainerUtil.newHashSet((Object[])new ApplyPatchStatus[]{SUCCESS, ALREADY_APPLIED});
        ORDERING = Ordering.explicit(ORDERED_TYPES).nullsFirst();
    }
}

