/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ActivityScopeKt;
import com.intellij.platform.lvcs.impl.ChangeSetActivityItem;
import com.intellij.platform.lvcs.impl.ChangeSetActivityItemKt;
import com.intellij.platform.lvcs.impl.ChangeSetSelection;
import com.intellij.platform.lvcs.impl.RevisionId;
import com.intellij.platform.lvcs.impl.diff.EntryDiffContentKt;
import com.intellij.platform.lvcs.impl.diff.PresentableFileDifference;
import com.intellij.util.text.DateFormatUtil;
import java.util.Objects;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u000234B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u001a\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u000bH\u0002J\u0017\u0010+\u001a\u00070\u001f\u00a2\u0006\u0002\b,2\b\u0010-\u001a\u0004\u0018\u00010\u0019H\u0004J\u0013\u0010.\u001a\u00020\u000b2\b\u0010/\u001a\u0004\u0018\u000100H\u0096\u0002J\b\u00101\u001a\u000202H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001b\u00a8\u00065"}, d2={"Lcom/intellij/platform/lvcs/impl/diff/DifferenceDiffRequestProducer;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "selection", "Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "isOldContentUsed", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/history/integration/IdeaGateway;Lcom/intellij/platform/lvcs/impl/ActivityScope;Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getGateway", "()Lcom/intellij/history/integration/IdeaGateway;", "getScope", "()Lcom/intellij/platform/lvcs/impl/ActivityScope;", "difference", "Lcom/intellij/history/core/revisions/Difference;", "getDifference", "()Lcom/intellij/history/core/revisions/Difference;", "leftItem", "Lcom/intellij/platform/lvcs/impl/ChangeSetActivityItem;", "getLeftItem", "()Lcom/intellij/platform/lvcs/impl/ChangeSetActivityItem;", "rightItem", "getRightItem", "getName", "", "process", "Lcom/intellij/diff/requests/DiffRequest;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createContent", "Lcom/intellij/diff/contents/DiffContent;", "entry", "Lcom/intellij/history/core/tree/Entry;", "isCurrent", "getTitle", "Lorg/jetbrains/annotations/Nls;", "item", "equals", "other", "", "hashCode", "", "WithDifferenceObject", "WithLazyDiff", "intellij.platform.lvcs.impl"})
public abstract class DifferenceDiffRequestProducer
implements DiffRequestProducer {
    @Nullable
    private final Project project;
    @NotNull
    private final IdeaGateway gateway;
    @NotNull
    private final ActivityScope scope;
    private final boolean isOldContentUsed;
    @Nullable
    private final ChangeSetActivityItem leftItem;
    @Nullable
    private final ChangeSetActivityItem rightItem;

    public DifferenceDiffRequestProducer(@Nullable Project project, @NotNull IdeaGateway gateway, @NotNull ActivityScope scope, @NotNull ChangeSetSelection selection, boolean isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        this.project = project;
        this.gateway = gateway;
        this.scope = scope;
        this.isOldContentUsed = isOldContentUsed;
        this.leftItem = selection.getLeftItem();
        this.rightItem = selection.getRightItem();
    }

    @Nullable
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final IdeaGateway getGateway() {
        return this.gateway;
    }

    @NotNull
    protected ActivityScope getScope() {
        return this.scope;
    }

    @NotNull
    protected abstract Difference getDifference();

    @Nullable
    protected final ChangeSetActivityItem getLeftItem() {
        return this.leftItem;
    }

    @Nullable
    protected final ChangeSetActivityItem getRightItem() {
        return this.rightItem;
    }

    @NotNull
    public String getName() {
        return ActivityScopeKt.getPresentableName(this.getScope());
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        DiffContent leftContent = this.createContent(this.getDifference().getLeft(), ChangeSetActivityItemKt.getRevisionId(this.leftItem) instanceof RevisionId.Current);
        DiffContent rightContent = this.createContent(this.getDifference().getRight(), ChangeSetActivityItemKt.getRevisionId(this.rightItem) instanceof RevisionId.Current);
        String leftContentTitle = this.getTitle(this.leftItem);
        String rightContentTitle = this.getTitle(this.rightItem);
        return (DiffRequest)new SimpleDiffRequest(this.getName(), leftContent, rightContent, leftContentTitle, rightContentTitle);
    }

    private final DiffContent createContent(Entry entry, boolean isCurrent) {
        if (entry == null) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"createEmpty(...)");
            return (DiffContent)emptyContent;
        }
        if (isCurrent) {
            return (DiffContent)ActionsKt.runReadAction(() -> DifferenceDiffRequestProducer.createContent$lambda$0(this, entry));
        }
        return EntryDiffContentKt.createDiffContent(this.project, this.gateway, entry);
    }

    @NotNull
    protected final String getTitle(@Nullable ChangeSetActivityItem item) {
        if (item == null) {
            String string = LocalHistoryBundle.message("current.revision", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        String string = DateFormatUtil.formatDateTime((long)item.getTimestamp());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDateTime(...)");
        String formattedTimestamp = string;
        if (this.isOldContentUsed) {
            Object[] objectArray = new Object[]{formattedTimestamp};
            String string2 = LocalHistoryBundle.message("activity.diff.content.title", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
        return formattedTimestamp;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DifferenceDiffRequestProducer)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getScope(), (Object)((DifferenceDiffRequestProducer)other).getScope())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.leftItem, (Object)((DifferenceDiffRequestProducer)other).leftItem)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rightItem, (Object)((DifferenceDiffRequestProducer)other).rightItem)) {
            return false;
        }
        return this.isOldContentUsed == ((DifferenceDiffRequestProducer)other).isOldContentUsed;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getScope(), this.leftItem, this.rightItem, this.isOldContentUsed};
        return Objects.hash(objectArray);
    }

    private static final DiffContent createContent$lambda$0(DifferenceDiffRequestProducer this$0, Entry $entry) {
        Project project = this$0.project;
        IdeaGateway ideaGateway = this$0.gateway;
        String string = $entry.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return EntryDiffContentKt.createCurrentDiffContent(project, ideaGateway, string);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B9\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\f0\u0019\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u001bH\u0097\u0001J\u0013\u0010\u001c\u001a\f0\u001d\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\b\u001bH\u0097\u0001R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/lvcs/impl/diff/DifferenceDiffRequestProducer$WithDifferenceObject;", "Lcom/intellij/platform/lvcs/impl/diff/DifferenceDiffRequestProducer;", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "Lcom/intellij/openapi/vcs/changes/ui/PresentableChange;", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "selection", "Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "fileDifference", "Lcom/intellij/platform/lvcs/impl/diff/PresentableFileDifference;", "isOldContentUsed", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/history/integration/IdeaGateway;Lcom/intellij/platform/lvcs/impl/ActivityScope;Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;Lcom/intellij/platform/lvcs/impl/diff/PresentableFileDifference;Z)V", "difference", "Lcom/intellij/history/core/revisions/Difference;", "getDifference", "()Lcom/intellij/history/core/revisions/Difference;", "getName", "", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "intellij.platform.lvcs.impl"})
    public static final class WithDifferenceObject
    extends DifferenceDiffRequestProducer
    implements ChangeDiffRequestChain.Producer,
    PresentableChange {
        @NotNull
        private final PresentableFileDifference fileDifference;

        public WithDifferenceObject(@Nullable Project project, @NotNull IdeaGateway gateway, @NotNull ActivityScope scope, @NotNull ChangeSetSelection selection, @NotNull PresentableFileDifference fileDifference, boolean isOldContentUsed) {
            Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)fileDifference, (String)"fileDifference");
            super(project, gateway, scope, selection, isOldContentUsed);
            this.fileDifference = fileDifference;
        }

        @Override
        @NotNull
        protected Difference getDifference() {
            return this.fileDifference.getDifference$intellij_platform_lvcs_impl();
        }

        @Override
        @NotNull
        public String getName() {
            Entry entry;
            Entry entry2 = this.getDifference().getLeft();
            if (entry2 == null) {
                entry2 = this.getDifference().getRight();
            }
            if ((entry = entry2) == null) {
                return ActivityScopeKt.getPresentableName(this.getScope());
            }
            String string = FileUtil.toSystemDependentName((String)entry.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
            return string;
        }

        @NotNull
        public FilePath getFilePath() {
            return this.fileDifference.getFilePath();
        }

        @NotNull
        public FileStatus getFileStatus() {
            return this.fileDifference.getFileStatus();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0010\u0018\u00002\u00020\u0001B?\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\f8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/lvcs/impl/diff/DifferenceDiffRequestProducer$WithLazyDiff;", "Lcom/intellij/platform/lvcs/impl/diff/DifferenceDiffRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "selection", "Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "loadDifference", "Lkotlin/Function0;", "Lcom/intellij/history/core/revisions/Difference;", "isOldContentUsed", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/history/integration/IdeaGateway;Lcom/intellij/platform/lvcs/impl/ActivityScope;Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;Lkotlin/jvm/functions/Function0;Z)V", "difference", "getDifference", "()Lcom/intellij/history/core/revisions/Difference;", "difference$delegate", "Lkotlin/Lazy;", "intellij.platform.lvcs.impl"})
    public static class WithLazyDiff
    extends DifferenceDiffRequestProducer {
        @NotNull
        private final Lazy difference$delegate;

        public WithLazyDiff(@Nullable Project project, @NotNull IdeaGateway gateway, @NotNull ActivityScope scope, @NotNull ChangeSetSelection selection, @NotNull Function0<Difference> loadDifference, boolean isOldContentUsed) {
            Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter(loadDifference, (String)"loadDifference");
            super(project, gateway, scope, selection, isOldContentUsed);
            this.difference$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, loadDifference);
        }

        @Override
        @NotNull
        protected Difference getDifference() {
            Lazy lazy = this.difference$delegate;
            return (Difference)lazy.getValue();
        }
    }
}

