/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.python.formatters.indents;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.python.formatters.indents.IndentFormatterState;
import org.jetbrains.completion.full.line.python.formatters.indents.PyIndentToScopeFormatterBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/completion/full/line/python/formatters/indents/PyIndentToScopeWithBlockEndFormatter;", "Lorg/jetbrains/completion/full/line/python/formatters/indents/PyIndentToScopeFormatterBase;", "scopeIn", "", "scopeOut", "blockEnd", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "twoLineBreaks", "formatIndents", "text", "state", "Lorg/jetbrains/completion/full/line/python/formatters/indents/IndentFormatterState;", "handleDedent", "", "handleLineBreakToken", "tokenText", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "keepOneLineBreak", "", "intellij.fullLine.python"})
public final class PyIndentToScopeWithBlockEndFormatter
extends PyIndentToScopeFormatterBase {
    @NotNull
    private final String blockEnd;
    @NotNull
    private final String twoLineBreaks;

    public PyIndentToScopeWithBlockEndFormatter(@NotNull String scopeIn, @NotNull String scopeOut, @NotNull String blockEnd) {
        Intrinsics.checkNotNullParameter((Object)scopeIn, (String)"scopeIn");
        Intrinsics.checkNotNullParameter((Object)scopeOut, (String)"scopeOut");
        Intrinsics.checkNotNullParameter((Object)blockEnd, (String)"blockEnd");
        super(scopeIn, scopeOut);
        this.blockEnd = blockEnd;
        this.twoLineBreaks = "\n\n";
    }

    @Override
    @NotNull
    public String formatIndents(@NotNull String text, @NotNull IndentFormatterState state) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.getLexer().start((CharSequence)(text + this.getTmpSuffix()));
        while (this.getLexer().getTokenType() != null) {
            IElementType tokenType = this.getLexer().getTokenType();
            if (Intrinsics.areEqual((Object)tokenType, (Object)PyTokenTypes.LINE_BREAK)) {
                Intrinsics.checkNotNullExpressionValue((Object)this.getLexer().getTokenText(), (String)"getTokenText(...)");
                this.getLexer().advance();
                if (Intrinsics.areEqual((Object)this.getLexer().getTokenType(), (Object)PyTokenTypes.INDENT)) {
                    this.handleToken(this.getScopeIn(), (IElementType)PyTokenTypes.INDENT, state);
                } else if (this.getLexer().getTokenType() != null) {
                    String lineBreakText;
                    this.handleLineBreakToken(lineBreakText, tokenType, state, true);
                    this.handleLexerToken(state);
                }
            } else {
                this.handleLexerToken(state);
            }
            this.getLexer().advance();
        }
        return state.tokensToString(this.getTmpSuffix());
    }

    @Override
    protected void handleDedent(@NotNull IndentFormatterState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        state.append(this.getScopeOut());
        this.getLexer().advance();
        if (Intrinsics.areEqual((Object)this.getLexer().getTokenType(), (Object)PyTokenTypes.LINE_BREAK)) {
            String string = this.getLexer().getTokenText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
            this.handleLineBreakToken(string, this.getLexer().getTokenType(), state, false);
        } else {
            this.handleLexerToken(state);
        }
    }

    private final void handleLineBreakToken(String tokenText, IElementType tokenType, IndentFormatterState state, boolean keepOneLineBreak) {
        if (StringsKt.startsWith$default((String)tokenText, (String)this.twoLineBreaks, (boolean)false, (int)2, null)) {
            this.handleToken(this.blockEnd, tokenType, state);
        } else if (keepOneLineBreak) {
            this.handleToken("\n", tokenType, state);
        }
    }
}

