/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.promo.page;

import com.intellij.llmInstaller.ui.promo.page.AIAssistantPromoPageEventLogger;
import com.intellij.openapi.components.Service;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\u0011J\u0006\u0010\n\u001a\u00020\u0011J\u0006\u0010\f\u001a\u00020\u0011J\b\u0010\u0019\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/llmInstaller/ui/promo/page/AIAPromoPageFUSSession;", "", "<init>", "()V", "featuresAmountPlayed", "", "featuresTimePlayedTotal", "bigVideoTime", "lastFeatureClicked", "", "scrolledUntilFeatures", "", "scrolledUntilEnable", "startTime", "", "Ljava/lang/Long;", "startSession", "", "endSession", "featuresTimePlayed", "time", "bigVideoTimePlayed", "featureClicked", "feature", "featurePlayed", "resetData", "intellij.llmInstaller"})
public final class AIAPromoPageFUSSession {
    private int featuresAmountPlayed;
    private int featuresTimePlayedTotal;
    private int bigVideoTime;
    @NotNull
    private String lastFeatureClicked = "";
    private boolean scrolledUntilFeatures;
    private boolean scrolledUntilEnable;
    @Nullable
    private Long startTime;

    public final void startSession() {
        this.resetData();
        this.startTime = System.currentTimeMillis();
        AIAssistantPromoPageEventLogger.Companion.logPageShown();
    }

    public final void endSession() {
        Long l = this.startTime;
        long displayTimeSec = (System.currentTimeMillis() - (l != null ? l : 0L)) / (long)1000;
        AIAssistantPromoPageEventLogger.Companion.logPageClosed(this.featuresAmountPlayed, this.featuresTimePlayedTotal, (int)displayTimeSec, this.bigVideoTime, this.lastFeatureClicked, this.scrolledUntilFeatures, this.scrolledUntilEnable);
        this.resetData();
    }

    public final void featuresTimePlayed(int time) {
        this.featuresTimePlayedTotal += time;
    }

    public final void bigVideoTimePlayed(int time) {
        this.bigVideoTime += time;
    }

    public final void featureClicked(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this.lastFeatureClicked = feature;
        int n = this.featuresAmountPlayed;
        this.featuresAmountPlayed = n + 1;
        AIAssistantPromoPageEventLogger.Companion.logFeatureExpanded(feature);
    }

    public final void featurePlayed() {
        int n = this.featuresAmountPlayed;
        this.featuresAmountPlayed = n + 1;
    }

    public final void scrolledUntilFeatures() {
        this.scrolledUntilFeatures = true;
    }

    public final void scrolledUntilEnable() {
        this.scrolledUntilEnable = true;
    }

    private final void resetData() {
        this.featuresAmountPlayed = 0;
        this.featuresTimePlayedTotal = 0;
        this.bigVideoTime = 0;
        this.lastFeatureClicked = "";
        this.scrolledUntilFeatures = false;
        this.scrolledUntilEnable = false;
        this.startTime = null;
    }
}

