/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller;

import com.intellij.ide.Prefs;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LicenseAiNonCommercialUtil {
    @NotNull
    private static final String AI_TERMS_ACCEPTED_PROPERTY_SUFFIX = "NonCommercialLicense.AiTermsAccepted";

    public static boolean isNonCommercialAiLicenseAvailable() {
        return "true".equals(System.getProperty("enable.non.commercial.ai.license"));
    }

    public static void storeAiNonCommercialTermsAcceptedState(@Nullable Boolean isAccepted) {
        if (isAccepted == null) {
            return;
        }
        Prefs.putBoolean((String)LicenseAiNonCommercialUtil.getAiTermsAcceptedKey(), (boolean)isAccepted);
    }

    @NotNull
    public static String getAiTermsAcceptedKey() {
        return LicenseAiNonCommercialUtil.getPerApplicationKey(AI_TERMS_ACCEPTED_PROPERTY_SUFFIX);
    }

    @NotNull
    private static String getPerApplicationKey(@NotNull String keySuffix) {
        if (keySuffix == null) {
            LicenseAiNonCommercialUtil.$$$reportNull$$$0(0);
        }
        ApplicationInfoEx info = LicenseAiNonCommercialUtil.getAppInfo();
        String productCode = info.getBuild().getProductCode();
        int baselineVersion = info.getBuild().getBaselineVersion();
        String string = String.format("Jetbrains.%s.%d.%s", productCode, baselineVersion, keySuffix);
        if (string == null) {
            LicenseAiNonCommercialUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static ApplicationInfoEx getAppInfo() {
        ApplicationInfo impl = null;
        if (ApplicationManager.getApplication() != null) {
            impl = ApplicationInfo.getInstance();
        }
        if (impl == null) {
            impl = ApplicationInfoImpl.getShadowInstance();
        }
        return (ApplicationInfoEx)impl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keySuffix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/llmInstaller/LicenseAiNonCommercialUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/llmInstaller/LicenseAiNonCommercialUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerApplicationKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPerApplicationKey";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

