/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.cell.JComboBoxCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.BasicCellRendererReader;
import org.assertj.swing.driver.CellRendererReader;
import org.assertj.swing.driver.ModelValueToString;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;

public class BasicJComboBoxCellReader
implements JComboBoxCellReader {
    private static final JList<?> REFERENCE_JLIST = BasicJComboBoxCellReader.newJList();
    private final CellRendererReader rendererReader;

    @Nonnull
    private static <T> JList<T> newJList() {
        JList result = (JList)GuiActionRunner.execute(new GuiQuery<JList<T>>(){

            @Override
            protected JList<T> executeInEDT() {
                return new JList();
            }
        });
        return (JList)Preconditions.checkNotNull((Object)result);
    }

    public BasicJComboBoxCellReader() {
        this(new BasicCellRendererReader());
    }

    public BasicJComboBoxCellReader(@Nonnull CellRendererReader rendererReader) {
        this.rendererReader = (CellRendererReader)Preconditions.checkNotNull((Object)rendererReader);
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public String valueAt(@Nonnull JComboBox<?> comboBox, int index) {
        String value;
        Component c = this.cellRendererComponent(comboBox, index);
        String string = value = c != null ? this.rendererReader.valueFrom(c) : null;
        if (value != null) {
            return value;
        }
        return ModelValueToString.asText(comboBox.getItemAt(index));
    }

    @Nullable
    @RunsInCurrentThread
    private Component cellRendererComponent(@Nonnull JComboBox comboBox, int index) {
        Object item = comboBox.getItemAt(index);
        ListCellRenderer<?> renderer = comboBox.getRenderer();
        return renderer.getListCellRendererComponent(REFERENCE_JLIST, item, index, true, true);
    }
}

