/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.language.EditorConfigLanguage;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.psi.reference.EditorConfigVirtualFileDescriptor;
import org.editorconfig.language.services.EditorConfigFileHierarchyService;
import org.editorconfig.language.services.EditorConfigServiceLoaded;
import org.editorconfig.language.services.EditorConfigServiceLoading;
import org.editorconfig.language.services.EditorConfigServiceResult;
import org.editorconfig.language.util.EditorConfigGlobUtilsKt;
import org.editorconfig.language.util.EditorConfigVfsUtil;
import org.editorconfig.language.util.core.EditorConfigPsiTreeUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JS\u0010\u0004\u001a\t\u0018\u0001H\u0005\u00a2\u0006\u0002\b\u0006\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u0007*\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\"\u0010\n\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\f0\u000b\"\n\u0012\u0006\b\u0001\u0012\u00020\u00070\fH\u0086\b\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u000e\u001a\u00020\t\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u0007*\u00020\u0007H\u0086\bJ\"\u0010\u000f\u001a\u0002H\u0005\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0086\b\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0007J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0015J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0015J9\u0010\u0018\u001a\u00020\u0019\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u00072\u0006\u0010\u0010\u001a\u0002H\u00052\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00190\u001bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ9\u0010\u001d\u001a\u00020\u0019\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u00072\u0006\u0010\u0010\u001a\u0002H\u00052\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00190\u001bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00142\u0006\u0010\"\u001a\u00020#J\u0018\u0010$\u001a\u0004\u0018\u00010\u00072\u0006\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020#J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020!0\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0002J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020!0\u00142\u0006\u0010\"\u001a\u00020!2\b\b\u0002\u0010+\u001a\u00020\tJ\u0010\u0010,\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020!J\u0015\u0010-\u001a\u0004\u0018\u00010!2\b\u0010.\u001a\u0004\u0018\u00010/H\u0082\u0010J\u0012\u0010$\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007J\u0013\u00100\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0086\u0010J(\u00101\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00072\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00190\u001bH\u0086\b\u00f8\u0001\u0000J&\u00103\u001a\u0004\u0018\u0001H\u0005\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020#2\b\u0010\"\u001a\u0004\u0018\u0001H\u0005H\u0086\b\u00a2\u0006\u0002\u00104\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00065"}, d2={"Lorg/editorconfig/language/util/EditorConfigPsiTreeUtil;", "", "<init>", "()V", "getParentOfType", "T", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/psi/PsiElement;", "strict", "", "stopAt", "", "Ljava/lang/Class;", "(Lcom/intellij/psi/PsiElement;Z[Ljava/lang/Class;)Lcom/intellij/psi/PsiElement;", "hasParentOfType", "getRequiredParent", "element", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "containsErrors", "findShadowingSections", "", "Lorg/editorconfig/language/psi/EditorConfigSection;", "section", "findShadowedSections", "iterateTypedSiblingsForward", "", "action", "Lkotlin/Function1;", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)V", "iterateTypedSiblingsBackward", "findRemovableRange", "Lkotlin/ranges/IntRange;", "findAllParentsFiles", "Lorg/editorconfig/language/psi/EditorConfigPsiFile;", "file", "Lcom/intellij/psi/PsiFile;", "findIdentifierUnderCaret", "editor", "Lcom/intellij/openapi/editor/Editor;", "findParentFilesUsingIndex", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findAllChildrenFiles", "honorRoot", "findOneParentFile", "findNextEditorConfigFile", "directory", "Lcom/intellij/psi/PsiDirectory;", "nextVisibleSibling", "iterateVisibleChildren", "acceptor", "getOriginalFile", "(Lcom/intellij/psi/PsiFile;)Lcom/intellij/psi/PsiFile;", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigPsiTreeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigPsiTreeUtil.kt\norg/editorconfig/language/util/EditorConfigPsiTreeUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,198:1\n23#1,2:199\n61#1:201\n67#1:227\n196#1:297\n196#1:307\n11483#2,9:202\n13409#2:211\n13410#2:213\n11492#2:214\n11483#2,9:228\n13409#2:237\n13410#2:239\n11492#2:240\n11483#2,9:250\n13409#2:259\n13410#2:261\n11492#2:262\n11483#2,9:275\n13409#2:284\n13410#2:286\n11492#2:287\n1310#2,2:330\n1#3:212\n1#3:238\n1#3:260\n1#3:285\n756#4,10:215\n1863#4,2:225\n967#4,7:241\n1863#4,2:248\n756#4,10:263\n1863#4,2:273\n967#4,7:288\n1863#4,2:295\n607#5:298\n209#5,8:299\n678#5:308\n708#5,4:309\n487#6,7:313\n535#6:320\n520#6,2:321\n522#6,4:326\n168#7,3:323\n*S KotlinDebug\n*F\n+ 1 EditorConfigPsiTreeUtil.kt\norg/editorconfig/language/util/EditorConfigPsiTreeUtil\n*L\n27#1:199,2\n37#1:201\n48#1:227\n78#1:297\n138#1:307\n37#1:202,9\n37#1:211\n37#1:213\n37#1:214\n48#1:228,9\n48#1:237\n48#1:239\n48#1:240\n61#1:250,9\n61#1:259\n61#1:261\n61#1:262\n67#1:275,9\n67#1:284\n67#1:286\n67#1:287\n169#1:330,2\n37#1:212\n48#1:238\n61#1:260\n67#1:285\n37#1:215,10\n37#1:225,2\n48#1:241,7\n48#1:248,2\n61#1:263,10\n61#1:273,2\n67#1:288,7\n67#1:295,2\n117#1:298\n120#1:299,8\n146#1:308\n146#1:309,4\n147#1:313,7\n151#1:320\n151#1:321,2\n151#1:326,4\n152#1:323,3\n*E\n"})
public final class EditorConfigPsiTreeUtil {
    @NotNull
    public static final EditorConfigPsiTreeUtil INSTANCE = new EditorConfigPsiTreeUtil();

    private EditorConfigPsiTreeUtil() {
    }

    public final /* synthetic */ <T extends PsiElement> T getParentOfType(PsiElement $this$getParentOfType, boolean strict, Class<? extends PsiElement> ... stopAt) {
        Intrinsics.checkNotNullParameter((Object)$this$getParentOfType, (String)"<this>");
        Intrinsics.checkNotNullParameter(stopAt, (String)"stopAt");
        boolean $i$f$getParentOfType = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType, PsiElement.class, (boolean)strict, (Class[])Arrays.copyOf(stopAt, stopAt.length));
    }

    public static /* synthetic */ PsiElement getParentOfType$default(EditorConfigPsiTreeUtil $this, PsiElement $receiver, boolean strict, Class[] stopAt, int n, Object object) {
        if ((n & 1) != 0) {
            strict = false;
        }
        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stopAt, (String)"stopAt");
        boolean $i$f$getParentOfType = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return PsiTreeUtil.getParentOfType((PsiElement)$receiver, PsiElement.class, (boolean)strict, (Class[])Arrays.copyOf(stopAt, stopAt.length));
    }

    public final /* synthetic */ <T extends PsiElement> boolean hasParentOfType(PsiElement $this$hasParentOfType) {
        Intrinsics.checkNotNullParameter((Object)$this$hasParentOfType, (String)"<this>");
        boolean $i$f$hasParentOfType = false;
        Class[] stopAt$iv = new Class[]{};
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return PsiTreeUtil.getParentOfType((PsiElement)$this$hasParentOfType, PsiElement.class, (boolean)strict$iv, (Class[])Arrays.copyOf(stopAt$iv, stopAt$iv.length)) != null;
    }

    public final /* synthetic */ <T extends PsiElement> T getRequiredParent(PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean $i$f$getRequiredParent = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)element, PsiElement.class, (boolean)false);
        if (psiElement == null) {
            throw new IllegalStateException();
        }
        return (T)psiElement;
    }

    public final boolean containsErrors(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return SyntaxTraverser.psiTraverser((PsiElement)element).traverse().filter(PsiErrorElement.class).isNotEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EditorConfigSection> findShadowingSections(@NotNull EditorConfigSection section) {
        void $this$dropWhile$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        Object[] objectArray = new EditorConfigSection[]{section};
        List result2 = CollectionsKt.mutableListOf((Object[])objectArray);
        EditorConfigPsiTreeUtil this_$iv = this;
        boolean $i$f$iterateTypedSiblingsForward = false;
        PsiElement[] psiElementArray = ((PsiElement)section).getParent().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object $this$mapNotNull$iv$iv = psiElementArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray2 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PsiElement it$iv$iv$iv;
            void element$iv$iv$iv$iv;
            void element$iv$iv$iv = element$iv$iv$iv$iv = $this$forEach$iv$iv$iv$iv[i];
            boolean bl = false;
            PsiElement it$iv = (PsiElement)element$iv$iv$iv;
            boolean bl2 = false;
            PsiElement psiElement = it$iv;
            if (!(psiElement instanceof EditorConfigSection)) {
                psiElement = null;
            }
            if ((PsiElement)((EditorConfigSection)psiElement) == null) continue;
            boolean bl3 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv$iv = false;
        ArrayList list$iv$iv = new ArrayList();
        for (Object item$iv$iv : $this$dropWhile$iv$iv) {
            if (yielding$iv$iv) {
                list$iv$iv.add(item$iv$iv);
                continue;
            }
            PsiElement it$iv = (PsiElement)item$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((PsiElement)section), (Object)it$iv)) continue;
            list$iv$iv.add(item$iv$iv);
            yielding$iv$iv = true;
        }
        Iterable $this$forEach$iv$iv = CollectionsKt.drop((Iterable)list$iv$iv, (int)1);
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            EditorConfigSection it = (EditorConfigSection)element$iv$iv;
            boolean bl = false;
            EditorConfigHeader editorConfigHeader = section.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"getHeader(...)");
            EditorConfigHeader editorConfigHeader2 = it.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader2, (String)"getHeader(...)");
            if (!EditorConfigGlobUtilsKt.isSubcaseOf(editorConfigHeader, editorConfigHeader2)) continue;
            result2.add(it);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EditorConfigSection> findShadowedSections(@NotNull EditorConfigSection section) {
        void $this$takeWhile$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        Object[] objectArray = new EditorConfigSection[]{section};
        List result2 = CollectionsKt.mutableListOf((Object[])objectArray);
        EditorConfigPsiTreeUtil this_$iv = this;
        boolean $i$f$iterateTypedSiblingsBackward = false;
        PsiElement[] psiElementArray = ((PsiElement)section).getParent().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object $this$mapNotNull$iv$iv = psiElementArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray2 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PsiElement it$iv$iv$iv;
            void element$iv$iv$iv$iv;
            void element$iv$iv$iv = element$iv$iv$iv$iv = $this$forEach$iv$iv$iv$iv[i];
            boolean bl = false;
            PsiElement it$iv = (PsiElement)element$iv$iv$iv;
            boolean bl2 = false;
            PsiElement psiElement = it$iv;
            if (!(psiElement instanceof EditorConfigSection)) {
                psiElement = null;
            }
            if ((PsiElement)((EditorConfigSection)psiElement) == null) continue;
            boolean bl3 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv$iv = new ArrayList();
        for (Object item$iv$iv : $this$takeWhile$iv$iv) {
            PsiElement it$iv = (PsiElement)item$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)((PsiElement)section), (Object)it$iv))) break;
            list$iv$iv.add(item$iv$iv);
        }
        Iterable $this$forEach$iv$iv = CollectionsKt.reversed((Iterable)list$iv$iv);
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            EditorConfigSection it = (EditorConfigSection)element$iv$iv;
            boolean bl = false;
            EditorConfigHeader editorConfigHeader = it.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader, (String)"getHeader(...)");
            EditorConfigHeader editorConfigHeader2 = section.getHeader();
            Intrinsics.checkNotNullExpressionValue((Object)editorConfigHeader2, (String)"getHeader(...)");
            if (!EditorConfigGlobUtilsKt.isSubcaseOf(editorConfigHeader, editorConfigHeader2)) continue;
            result2.add(it);
        }
        CollectionsKt.reverse((List)result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends PsiElement> void iterateTypedSiblingsForward(T element, Function1<? super T, Unit> action) {
        void $this$dropWhile$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$iterateTypedSiblingsForward = false;
        PsiElement[] psiElementArray = element.getParent().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object $this$mapNotNull$iv = psiElementArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PsiElement it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            if (it == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            PsiElement it = (PsiElement)item$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(element, (Object)it)) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)list$iv, (int)1);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            action.invoke(element$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends PsiElement> void iterateTypedSiblingsBackward(T element, Function1<? super T, Unit> action) {
        void $this$takeWhile$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$iterateTypedSiblingsBackward = false;
        PsiElement[] psiElementArray = element.getParent().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object $this$mapNotNull$iv = psiElementArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PsiElement it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            if (it == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            PsiElement it = (PsiElement)item$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(element, (Object)it))) break;
            list$iv.add(item$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)list$iv);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            action.invoke(element$iv);
        }
    }

    @NotNull
    public final IntRange findRemovableRange(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IntRange intRange = EditorConfigPsiTreeUtilCore.INSTANCE.findRemovableRangeBackward(element);
        if (intRange == null && (intRange = EditorConfigPsiTreeUtilCore.INSTANCE.findRemovableRangeForward(element)) == null) {
            intRange = RangesKt.until((int)element.getTextRange().getStartOffset(), (int)element.getTextRange().getEndOffset());
        }
        return intRange;
    }

    @NotNull
    public final List<EditorConfigPsiFile> findAllParentsFiles(@NotNull PsiFile file) {
        List<EditorConfigPsiFile> list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        EditorConfigPsiTreeUtil this_$iv = this;
        boolean $i$f$getOriginalFile = false;
        PsiFile psiFile = EditorConfigPsiTreeUtilCore.INSTANCE.getOriginalFile(file, Reflection.getOrCreateKotlinClass(PsiFile.class));
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile virtualFile = psiFile;
        if (EditorConfigRegistry.shouldStopAtProjectRoot()) {
            return this.findParentFilesUsingIndex(file, (VirtualFile)virtualFile);
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        EditorConfigFileHierarchyService service = EditorConfigFileHierarchyService.Companion.getInstance(project);
        EditorConfigServiceResult serviceResult = service.getParentEditorConfigFiles((VirtualFile)virtualFile);
        if (serviceResult instanceof EditorConfigServiceLoaded) {
            list = ((EditorConfigServiceLoaded)serviceResult).getList();
        } else if (serviceResult instanceof EditorConfigServiceLoading) {
            list = this.findParentFilesUsingIndex(file, (VirtualFile)virtualFile);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @Nullable
    public final PsiElement findIdentifierUnderCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        int previousIndex;
        PsiElement previousElement;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int caretOffset = editor.getCaretModel().getOffset();
        FileViewProvider fileViewProvider = file.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
        FileViewProvider viewProvider = fileViewProvider;
        PsiElement psiUnderCaret = viewProvider.findElementAt(caretOffset, (Language)EditorConfigLanguage.INSTANCE);
        PsiElement psiElement2 = psiUnderCaret;
        if (psiElement2 == null || (psiElement2 = psiElement2.getNode()) == null || (psiElement2 = psiElement2.getElementType()) == null) {
            return null;
        }
        PsiElement elementType = psiElement2;
        PsiElement psiElement3 = elementType;
        return Intrinsics.areEqual((Object)psiElement3, (Object)TokenType.WHITE_SPACE) || Intrinsics.areEqual((Object)psiElement3, (Object)EditorConfigElementTypes.DOT) ? (!Intrinsics.areEqual((Object)((psiElement = (previousElement = viewProvider.findElementAt(previousIndex = Math.max(0, caretOffset - 1)))) != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)EditorConfigElementTypes.IDENTIFIER) ? null : previousElement) : (Intrinsics.areEqual((Object)psiElement3, (Object)EditorConfigElementTypes.IDENTIFIER) ? psiUnderCaret : null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorConfigPsiFile> findParentFilesUsingIndex(PsiFile file, VirtualFile virtualFile) {
        int n;
        PsiManager manager;
        Sequence sortedParentFiles2;
        block3: {
            void $this$sortedBy$iv;
            EditorConfigVirtualFileDescriptor currentFileDescriptor = new EditorConfigVirtualFileDescriptor(virtualFile);
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)EditorConfigVfsUtil.INSTANCE.getEditorConfigFiles(project2)), (Function1)((Function1)new Function1<VirtualFile, Boolean>((Object)currentFileDescriptor){

                public final Boolean invoke(VirtualFile p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((EditorConfigVirtualFileDescriptor)this.receiver).isChildOf(p0);
                }
            }));
            boolean $i$f$sortedBy = false;
            sortedParentFiles2 = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(currentFileDescriptor){
                final /* synthetic */ EditorConfigVirtualFileDescriptor $receiver$inlined;
                {
                    this.$receiver$inlined = editorConfigVirtualFileDescriptor;
                }

                public final int compare(T a, T b) {
                    VirtualFile p0 = (VirtualFile)a;
                    boolean $i$f$findParentFilesUsingIndex$stub_for_inlining = false;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(this.$receiver$inlined.distanceToParent(p0));
                    p0 = (VirtualFile)b;
                    Comparable comparable2 = comparable;
                    $i$f$findParentFilesUsingIndex$stub_for_inlining = false;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$receiver$inlined.distanceToParent(p0)));
                }
            });
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
            manager = psiManager;
            Sequence $this$indexOfFirst$iv = sortedParentFiles2;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                EditorConfigPsiFile psiFile;
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                VirtualFile it = (VirtualFile)item$iv;
                boolean bl = false;
                PsiFile psiFile2 = manager.findFile(it);
                EditorConfigPsiFile editorConfigPsiFile = psiFile = psiFile2 instanceof EditorConfigPsiFile ? (EditorConfigPsiFile)psiFile2 : null;
                if (editorConfigPsiFile != null ? editorConfigPsiFile.getHasValidRootDeclaration() : false) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        int firstRoot = n;
        Sequence actualParentFiles = firstRoot < 0 ? sortedParentFiles2 : SequencesKt.take((Sequence)sortedParentFiles2, (int)(firstRoot + 1));
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)actualParentFiles, arg_0 -> EditorConfigPsiTreeUtil.findParentFilesUsingIndex$lambda$7(manager, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EditorConfigPsiFile> findAllChildrenFiles(@NotNull EditorConfigPsiFile file, boolean honorRoot) {
        void $this$filterTo$iv$iv;
        void $this$filterKeys$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        Map $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        EditorConfigPsiTreeUtil this_$iv = this;
        boolean $i$f$getOriginalFile = false;
        EditorConfigPsiFile editorConfigPsiFile = (EditorConfigPsiFile)EditorConfigPsiTreeUtilCore.INSTANCE.getOriginalFile((PsiFile)file, Reflection.getOrCreateKotlinClass(EditorConfigPsiFile.class));
        if (editorConfigPsiFile == null || (editorConfigPsiFile = editorConfigPsiFile.getVirtualFile()) == null) {
            return CollectionsKt.emptyList();
        }
        EditorConfigPsiFile virtualFile = editorConfigPsiFile;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager manager = psiManager;
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)EditorConfigVfsUtil.INSTANCE.getEditorConfigFiles(project2)), (Function1)((Function1)new Function1<VirtualFile, Boolean>((Object)new EditorConfigVirtualFileDescriptor((VirtualFile)virtualFile)){

            public final Boolean invoke(VirtualFile p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((EditorConfigVirtualFileDescriptor)this.receiver).isStrictParentOf(p0);
            }
        }));
        boolean $i$f$associateBy = false;
        void var9_10 = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean bl = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            object = (VirtualFile)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl2 = false;
            PsiFile psiFile = manager.findFile((VirtualFile)it);
            map.put(psiFile instanceof EditorConfigPsiFile ? (EditorConfigPsiFile)psiFile : null, element$iv$iv);
        }
        $this$associateBy$iv = destination$iv$iv;
        boolean $i$f$filterKeys = false;
        Map result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            EditorConfigPsiFile it = (EditorConfigPsiFile)((Object)entry.getKey());
            boolean bl3 = false;
            if (!(it != null)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        Map childFiles2 = result$iv;
        if (honorRoot) {
            return CollectionsKt.filterNotNull((Iterable)childFiles2.keySet());
        }
        Map $this$filter$iv = childFiles2;
        boolean $i$f$filter = false;
        result$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean bl4 = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            boolean bl5;
            block10: {
                object = element$iv$iv;
                boolean bl2 = false;
                VirtualFile virtualChildFile = (VirtualFile)object.getValue();
                Map $this$all$iv = childFiles2;
                boolean $i$f$all = false;
                if ($this$all$iv.isEmpty()) {
                    bl5 = true;
                } else {
                    Iterator iterator = $this$all$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        boolean bl6;
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = iterator.next();
                        boolean bl42 = false;
                        EditorConfigPsiFile otherChildFile = (EditorConfigPsiFile)((Object)entry.getKey());
                        VirtualFile virtualOtherChildFile = (VirtualFile)entry.getValue();
                        if (!VfsUtil.isAncestor((VirtualFile)virtualOtherChildFile, (VirtualFile)virtualChildFile, (boolean)false)) {
                            bl6 = true;
                        } else {
                            EditorConfigPsiFile editorConfigPsiFile2 = otherChildFile;
                            Intrinsics.checkNotNull((Object)((Object)editorConfigPsiFile2));
                            bl6 = !editorConfigPsiFile2.getHasValidRootDeclaration();
                        }
                        if (bl6) continue;
                        bl5 = false;
                        break block10;
                    }
                    bl5 = true;
                }
            }
            if (!bl5) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.filterNotNull((Iterable)destination$iv$iv.keySet());
    }

    public static /* synthetic */ List findAllChildrenFiles$default(EditorConfigPsiTreeUtil editorConfigPsiTreeUtil, EditorConfigPsiFile editorConfigPsiFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return editorConfigPsiTreeUtil.findAllChildrenFiles(editorConfigPsiFile, bl);
    }

    @Nullable
    public final EditorConfigPsiFile findOneParentFile(@NotNull EditorConfigPsiFile file) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        if (file.getHasValidRootDeclaration()) {
            return null;
        }
        PsiDirectory psiDirectory = file.getParent();
        return this.findNextEditorConfigFile((PsiDirectory)(psiDirectory != null ? psiDirectory.getParentDirectory() : null));
    }

    private final EditorConfigPsiFile findNextEditorConfigFile(PsiDirectory directory) {
        EditorConfigPsiFile editorConfigPsiFile;
        Object object = this;
        while (true) {
            EditorConfigPsiFile result2;
            Object object2;
            block3: {
                if (directory == null) {
                    return null;
                }
                PsiFile[] psiFileArray = directory.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFiles(...)");
                Object[] $this$firstOrNull$iv = psiFileArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiFile it = (PsiFile)element$iv;
                    boolean bl = false;
                    if (!(it instanceof EditorConfigPsiFile)) continue;
                    object2 = element$iv;
                    break block3;
                }
                object2 = null;
            }
            Object object3 = object2;
            editorConfigPsiFile = result2 = object3 instanceof EditorConfigPsiFile ? (EditorConfigPsiFile)((Object)object3) : null;
            if (editorConfigPsiFile != null) break;
            object3 = object;
            PsiDirectory psiDirectory = directory.getParentDirectory();
            object = object3;
            directory = psiDirectory;
        }
        return editorConfigPsiFile;
    }

    @Nullable
    public final PsiElement findIdentifierUnderCaret(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor(true);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        return this.findIdentifierUnderCaret(editor2, file);
    }

    @Nullable
    public final PsiElement nextVisibleSibling(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        EditorConfigPsiTreeUtil editorConfigPsiTreeUtil = this;
        while (element.getNextSibling() != null) {
            PsiElement next;
            if (!(next instanceof PsiWhiteSpace)) {
                return next;
            }
            EditorConfigPsiTreeUtil editorConfigPsiTreeUtil2 = editorConfigPsiTreeUtil;
            PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)next;
            editorConfigPsiTreeUtil = editorConfigPsiTreeUtil2;
            element = (PsiElement)psiWhiteSpace;
        }
        return null;
    }

    public final void iterateVisibleChildren(@NotNull PsiElement element, @NotNull Function1<? super PsiElement, Unit> acceptor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(acceptor, (String)"acceptor");
        boolean $i$f$iterateVisibleChildren = false;
        PsiElement child = element.getFirstChild();
        while (child != null) {
            acceptor.invoke((Object)child);
            child = this.nextVisibleSibling(child);
        }
    }

    public final /* synthetic */ <T extends PsiFile> T getOriginalFile(T file) {
        boolean $i$f$getOriginalFile = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return EditorConfigPsiTreeUtilCore.INSTANCE.getOriginalFile(file, Reflection.getOrCreateKotlinClass(PsiFile.class));
    }

    private static final EditorConfigPsiFile findParentFilesUsingIndex$lambda$7(PsiManager $manager, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiFile psiFile = $manager.findFile(it);
        return psiFile instanceof EditorConfigPsiFile ? (EditorConfigPsiFile)psiFile : null;
    }
}

