/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.impl.SharedIndexExtension;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.IndexInfrastructureVersionBase;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.InMemoryEnumerator;
import com.intellij.util.io.UnmodifiableEnumeratorWrapper;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubSharedIndexExtension
implements SharedIndexExtension<Integer, SerializedStubTree> {
    private static final Logger LOG = Logger.getInstance(StubSharedIndexExtension.class);
    private static final String STUB_INDEX_IDS_FILENAME_LEGACY = "stubIndexIds.txt";
    private static final String STUB_INDEX_IDS_FILENAME = "stubIndexIds.csv";
    private volatile StubUpdatingIndex myStubUpdatingIndex;
    private volatile SerializationManagerImpl mySerializationManager;
    private volatile UsageTrackingEnumerator<String> myIndexIdEnumerator;
    private volatile StubBuilderVersionFilter myStubBuilderVersionFilter;
    private volatile Path myStoreStubIndexKeysEnumeratorToPath;

    @Override
    public void openResources(@NotNull Path indexRoot, boolean readOnly, @NotNull SharedIndexInfrastructureVersion chunkVersion) {
        if (indexRoot == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(0);
        }
        if (chunkVersion == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(1);
        }
        this.mySerializationManager = new SerializationManagerImpl(StubSharedIndexExtension.getStubSerializerNamesStorageFile(indexRoot), readOnly);
        Path stubIndexIdsPath = indexRoot.resolve(STUB_INDEX_IDS_FILENAME);
        UsageTrackingEnumerator<String> stubIndexKeyEnumerator = StubSharedIndexExtension.tryLoadStubIndexKeyEnumerator(stubIndexIdsPath);
        if (stubIndexKeyEnumerator != null) {
            this.myStoreStubIndexKeysEnumeratorToPath = null;
            this.myIndexIdEnumerator = stubIndexKeyEnumerator;
        } else {
            this.myStoreStubIndexKeysEnumeratorToPath = stubIndexIdsPath;
            this.myIndexIdEnumerator = StubSharedIndexExtension.createFreshStubIndexKeyEnumerator();
        }
        this.myStubUpdatingIndex = new StubUpdatingIndex((StubForwardIndexExternalizer)new StubExternalizerToStableBinary((DataEnumerator<String>)this.myIndexIdEnumerator), (SerializationManagerEx)this.mySerializationManager);
        FileSystem fs = indexRoot.getFileSystem();
        boolean prebuilt = fs instanceof UncompressedZipFileSystem && ((UncompressedZipFileSystem)fs).isPrebuilt();
        this.myStubBuilderVersionFilter = readOnly ? new StubBuilderVersionFilter(chunkVersion, prebuilt) : null;
    }

    @Override
    public boolean acceptsInputFile(@NotNull IndexedFile file) {
        if (file == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(2);
        }
        return this.myStubBuilderVersionFilter.acceptsFileType(file.getFileType());
    }

    @Override
    public void closeResources() {
        Path storeStubIndexKeysEnumeratorToPath = this.myStoreStubIndexKeysEnumeratorToPath;
        if (storeStubIndexKeysEnumeratorToPath != null) {
            try {
                this.myIndexIdEnumerator.saveActuallyUsedValues(storeStubIndexKeysEnumeratorToPath);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't store stubIndexKey enumerator to " + storeStubIndexKeysEnumeratorToPath, e);
            }
        }
        Disposer.dispose((Disposable)this.mySerializationManager);
    }

    @Override
    @NotNull
    public FileBasedIndexExtension<Integer, SerializedStubTree> getFileBasedIndexExtension() {
        StubUpdatingIndex stubUpdatingIndex = this.myStubUpdatingIndex;
        if (stubUpdatingIndex == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(3);
        }
        return stubUpdatingIndex;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @NotNull
    private static Path getStubSerializerNamesStorageFile(@NotNull Path stubIndexesRoot) {
        if (stubIndexesRoot == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(4);
        }
        Path path = stubIndexesRoot.resolve("serializerNames").resolve("names");
        if (path == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(5);
        }
        return path;
    }

    private static UsageTrackingEnumerator<String> tryLoadStubIndexKeyEnumerator(@NotNull Path stubIndexIdsPath) {
        if (stubIndexIdsPath == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(6);
        }
        Path legacyStubIndexIdsPath = stubIndexIdsPath.getParent().resolve(STUB_INDEX_IDS_FILENAME_LEGACY);
        IOException legacyLoadException = null;
        if (Files.exists(legacyStubIndexIdsPath, new LinkOption[0])) {
            try {
                return UsageTrackingEnumerator.createFromLegacyTextFile(legacyStubIndexIdsPath);
            }
            catch (IOException e) {
                legacyLoadException = new IOException("Can't pre-initialize stubIndexIDs enumerator from " + legacyStubIndexIdsPath, e);
            }
        }
        if (Files.exists(stubIndexIdsPath, new LinkOption[0])) {
            try {
                return UsageTrackingEnumerator.createFromCsvFile(stubIndexIdsPath);
            }
            catch (IOException e) {
                UncheckedIOException exception = new UncheckedIOException("Can't pre-initialize stubIndexIDs enumerator from " + stubIndexIdsPath, e);
                if (legacyLoadException != null) {
                    exception.addSuppressed(legacyLoadException);
                }
                throw exception;
            }
        }
        return null;
    }

    @NotNull
    private static UsageTrackingEnumerator<String> createFreshStubIndexKeyEnumerator() {
        List<String> allStubIndexKeyNames = ID.getRegisteredIds().stream().filter(id -> id instanceof StubIndexKey).map(IndexId::getName).sorted().toList();
        UsageTrackingEnumerator<String> usageTrackingEnumerator = UsageTrackingEnumerator.createFromValues(allStubIndexKeyNames);
        if (usageTrackingEnumerator == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(7);
        }
        return usageTrackingEnumerator;
    }

    @Nullable
    public static IFileElementType getFileElementType(@NotNull FileType fileType) {
        ParserDefinition parserDefinition;
        if (fileType == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(8);
        }
        if (fileType instanceof LanguageFileType && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(((LanguageFileType)fileType).getLanguage())) != null) {
            return parserDefinition.getFileNodeType();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexesRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexIdsPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexExtension";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubSerializerNamesStorageFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFreshStubIndexKeyEnumerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openResources";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInputFile";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStubSerializerNamesStorageFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadStubIndexKeyEnumerator";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileElementType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7 -> new IllegalStateException(string);
        };
    }

    private static class UsageTrackingEnumerator<Data>
    implements DataEnumeratorEx<Data> {
        private final InMemoryEnumerator<Data> enumerator = new InMemoryEnumerator();
        private final UnmodifiableEnumeratorWrapper<Data> unmodifiableWrapper = new UnmodifiableEnumeratorWrapper(this.enumerator);
        private final IntSet actuallyUsedIds = new IntOpenHashSet();

        private UsageTrackingEnumerator(Iterable<Pair<Integer, Data>> idsAndValues) {
            for (Pair<Integer, Data> pair : idsAndValues) {
                int id = (Integer)pair.first;
                Object value = pair.second;
                this.enumerator.registerValueWithGivenId(id, value, false);
            }
        }

        public synchronized int enumerate(@Nullable Data value) throws IOException {
            int id = this.unmodifiableWrapper.tryEnumerate(value);
            this.actuallyUsedIds.add(id);
            return id;
        }

        public synchronized int tryEnumerate(@Nullable Data value) throws IOException {
            int id = this.unmodifiableWrapper.tryEnumerate(value);
            if (id != 0) {
                this.actuallyUsedIds.add(id);
            }
            return id;
        }

        @Nullable
        public synchronized Data valueOf(int id) throws IOException {
            return (Data)this.unmodifiableWrapper.valueOf(id);
        }

        public void saveActuallyUsedValues(@NotNull Path storeToCsv) throws IOException {
            if (storeToCsv == null) {
                UsageTrackingEnumerator.$$$reportNull$$$0(0);
            }
            List<String> csvLines = this.actuallyUsedIds.intStream().sorted().mapToObj(id -> id + "," + this.enumerator.valueOf(id)).toList();
            Files.write(storeToCsv, csvLines, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }

        public static UsageTrackingEnumerator<String> createFromLegacyTextFile(@NotNull Path stubIndexTxtPath) throws IOException {
            if (stubIndexTxtPath == null) {
                UsageTrackingEnumerator.$$$reportNull$$$0(1);
            }
            List<String> values = Files.readAllLines(stubIndexTxtPath);
            return UsageTrackingEnumerator.createFromValues(values);
        }

        public static UsageTrackingEnumerator<String> createFromCsvFile(@NotNull Path stubIndexCsvPath) throws IOException {
            if (stubIndexCsvPath == null) {
                UsageTrackingEnumerator.$$$reportNull$$$0(2);
            }
            List<String> values = Files.readAllLines(stubIndexCsvPath);
            List idsAndValues = ContainerUtil.map(values, line -> {
                int separatorIndex = line.indexOf(44);
                int id = Integer.parseInt(line.substring(0, separatorIndex));
                String value = line.substring(separatorIndex + 1);
                return new Pair((Object)id, (Object)value);
            });
            return new UsageTrackingEnumerator<String>(idsAndValues);
        }

        public static UsageTrackingEnumerator<String> createFromValues(@NotNull List<String> valuesKnownInAdvance) {
            if (valuesKnownInAdvance == null) {
                UsageTrackingEnumerator.$$$reportNull$$$0(3);
            }
            ArrayList idsAndValues = new ArrayList();
            int id = 1;
            for (String value : valuesKnownInAdvance) {
                idsAndValues.add(new Pair((Object)id, (Object)value));
                ++id;
            }
            return new UsageTrackingEnumerator<String>(idsAndValues);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storeToCsv";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stubIndexTxtPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stubIndexCsvPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valuesKnownInAdvance";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension$UsageTrackingEnumerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveActuallyUsedValues";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromLegacyTextFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromCsvFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromValues";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StubExternalizerToStableBinary
    extends StubForwardIndexExternalizer<Void> {
        @NotNull
        private final DataEnumerator<String> indexIdEnumerator;

        public StubExternalizerToStableBinary(@NotNull DataEnumerator<String> indexIdEnumerator) {
            if (indexIdEnumerator == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(0);
            }
            super(true);
            this.indexIdEnumerator = indexIdEnumerator;
        }

        protected void writeStubIndexKey(@NotNull DataOutput out, @NotNull StubIndexKey key, Void unused) throws IOException {
            if (out == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(1);
            }
            if (key == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(2);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.indexIdEnumerator.enumerate((Object)key.getName()));
        }

        protected ID<?, ?> readStubIndexKey(@NotNull DataInput input, Void unused) throws IOException {
            int indexId;
            String name;
            if (input == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(3);
            }
            if ((name = (String)this.indexIdEnumerator.valueOf(indexId = DataInputOutputUtil.readINT((DataInput)input))) == null) {
                throw new IOException("index name can't be found for indexId(=" + indexId + ")");
            }
            ID id = ID.findByName((String)name);
            if (!(id instanceof StubIndexKey)) {
                LOG.warn("id with name `" + name + "`, enumerated id " + indexId + " is not " + (id == null ? "found" : "a StubIndexKey"));
                return null;
            }
            return id;
        }

        protected Void createStubIndexKeySerializationState(@NotNull DataOutput out, @NotNull Set<StubIndexKey<?, ?>> set) {
            if (out == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(4);
            }
            if (set == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(5);
            }
            return null;
        }

        protected Void createStubIndexKeySerializationState(@NotNull DataInput input, int stubIndexKeyCount) {
            if (input == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(6);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexIdEnumerator";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension$StubExternalizerToStableBinary";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeStubIndexKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readStubIndexKey";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createStubIndexKeySerializationState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StubBuilderVersionFilter {
        @NotNull
        private final Map<String, String> myVersions;
        @NotNull
        private final Map<FileType, Boolean> myResolutionMap;
        @NotNull
        private final SortedMap<String, String> myBinaryStubFileBuilderVersions;
        private final boolean myPrebuilt;

        private StubBuilderVersionFilter(@NotNull SharedIndexInfrastructureVersion chunkVersion, boolean prebuilt) {
            if (chunkVersion == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(0);
            }
            this.myVersions = chunkVersion.getStubFileElementTypeVersions();
            this.myBinaryStubFileBuilderVersions = chunkVersion.getCompositeBinaryStubFileBuilderVersions();
            this.myPrebuilt = prebuilt;
            this.myResolutionMap = ConcurrentFactoryMap.createMap(this::doVersionsMatch);
        }

        private boolean doVersionsMatch(@NotNull FileType fileType) {
            if (fileType == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(1);
            }
            if (fileType instanceof LanguageFileType) {
                return this.doLanguageFileTypeVersionsMatch((LanguageFileType)fileType);
            }
            return this.doBinaryFileTypeVersionsMatch(fileType);
        }

        private boolean doLanguageFileTypeVersionsMatch(@NotNull LanguageFileType fileType) {
            if (fileType == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(2);
            }
            Language language = fileType.getLanguage();
            if (this.myPrebuilt && StubBuilderVersionFilter.isJsOrDialect(language)) {
                return true;
            }
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
            if (parserDefinition == null) {
                return true;
            }
            IFileElementType fileNodeType = parserDefinition.getFileNodeType();
            if (!(fileNodeType instanceof IStubFileElementType)) {
                return true;
            }
            String key = IndexInfrastructureVersionBase.getStubFileElementTypeKey((IStubFileElementType)((IStubFileElementType)fileNodeType));
            int version = IndexInfrastructureVersionBase.getStubFileElementBaseVersion((IStubFileElementType)((IStubFileElementType)fileNodeType));
            return String.valueOf(version).equals(this.myVersions.get(key));
        }

        private boolean doBinaryFileTypeVersionsMatch(@NotNull FileType fileType) {
            BinaryFileStubBuilder builder;
            if (fileType == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(3);
            }
            if (!((builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)) {
                return true;
            }
            String version = IndexInfrastructureVersionBase.getBinaryFileStubBuilderVersion((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder));
            return version.equals(this.myBinaryStubFileBuilderVersions.get(fileType.getName()));
        }

        boolean acceptsFileType(@NotNull FileType fileType) {
            if (fileType == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(4);
            }
            return this.myResolutionMap.get(fileType);
        }

        private static boolean isJsOrDialect(@NotNull Language language) {
            if (language == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(5);
            }
            while (language != null) {
                if (language.getID().equals("JavaScript")) {
                    return true;
                }
                language = language.getBaseLanguage();
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunkVersion";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension$StubBuilderVersionFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doVersionsMatch";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doLanguageFileTypeVersionsMatch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doBinaryFileTypeVersionsMatch";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptsFileType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isJsOrDialect";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

