/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language.identifier.detector;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.broker.ResourceDataBroker;

public class CommonWordsDetector {
    private static final Map<String, List<Language>> word2langs = Collections.synchronizedMap(new HashMap());
    private static final Pattern numberPattern = Pattern.compile("[0-9.,%-]+");
    private static final Language esLang = Languages.getLanguageForShortCode("es");
    private static final Language caLang = Languages.getLanguageForShortCode("ca");
    private static final Language ptLang = Languages.getLanguageForShortCode("pt");
    private static final Pattern spanishPattern = Pattern.compile("^[a-z\u00f1]+(\u00f3n|cion|aban|\u00e1bamos|\u00e1bais|\u00edamos|\u00edais|[\u00fa\u00ed]a[sn]?|\u00fae[ns]?)$");
    private static final Pattern notSpanishPattern = Pattern.compile("^[lmndts]['\u2019].*$|^.*(ns|[\u00e1\u00e9\u00f3].i[oa]s?)$|^.*(ss|[\u00e7\u00e0\u00e8\u00f2\u00ef\u00e2\u00ea\u00f4\u00e3\u00f5\u00ec\u00f9]|l\u00b7l).*$");
    private static final Pattern notCatalanPattern = Pattern.compile("^.*([\u00e1\u00e9\u00f3].i[oa]s?|d[oa]s)$|^.*[\u00e1\u00e2\u00ea\u00f4\u00e3\u00f5\u00ec\u00f9\u00f1].*$");
    private static final Pattern portuguesePattern = Pattern.compile("^.*([\u00e1\u00f3]ri[oa]|\u00e9rio)s?$");
    private static final Pattern PUNCT_PATTERN = Pattern.compile("[(),.:;!?\u201e\u201c\"\u00a1\u00bf\\s\\[\\]{}-\u00ab\u00bb\u201d]");
    private static final Pattern CHARS_PATTERN = Pattern.compile("\\p{L}+$");
    private static final Pattern SPACE_OR_HYPHEN_PATTERN = Pattern.compile("[ -]");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonWordsDetector() throws IOException {
        Map<String, List<Language>> map = word2langs;
        synchronized (map) {
            if (!word2langs.isEmpty()) return;
            for (Language lang : Languages.get()) {
                if (lang.isVariant() && !lang.getShortCode().equals("no")) continue;
                ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
                String path = lang.getCommonWordsPath();
                InputStream stream = null;
                try {
                    if (path != null) {
                        if (dataBroker.resourceExists(path)) {
                            stream = dataBroker.getFromResourceDirAsStream(path);
                        } else {
                            if (!new File(path).exists()) throw new IOException("Common words file not found for " + lang + ": " + path);
                            stream = new FileInputStream(path);
                        }
                    } else {
                        if (lang.getShortCode().matches("ja|km")) continue;
                        System.out.println("WARN: no common words file defined for " + lang + " - this language might not be correctly auto-detected");
                        continue;
                    }
                    Scanner scanner = new Scanner(stream, "utf-8");
                    Throwable throwable = null;
                    try {
                        while (scanner.hasNextLine()) {
                            String key2;
                            String line = scanner.nextLine();
                            if (line.isEmpty() || line.startsWith("#") || (key2 = line.toLowerCase()).length() == 1 && Character.isSpaceChar(key2.charAt(0))) continue;
                            List<Language> languages2 = word2langs.get(key2);
                            if (languages2 == null) {
                                List<Language> l = Collections.synchronizedList(new LinkedList());
                                l.add(lang);
                                word2langs.put(key2, l);
                                continue;
                            }
                            if (languages2.contains(lang)) continue;
                            languages2.add(lang);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (scanner == null) continue;
                        if (throwable != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        scanner.close();
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            return;
        }
    }

    public Map<Language, Integer> getKnownWordsPerLanguage(String text2) {
        String[] words2;
        HashMap<Language, Integer> result2 = new HashMap<Language, Integer>();
        String auxText = PUNCT_PATTERN.matcher(text2).replaceAll(" ");
        if (!auxText.endsWith(" ") && StringUtils.countMatches((CharSequence)auxText, (CharSequence)" ") > 0) {
            auxText = CHARS_PATTERN.matcher(auxText).replaceFirst("");
        }
        for (String word : words2 = SPACE_OR_HYPHEN_PATTERN.split(auxText)) {
            if (numberPattern.matcher(word).matches()) continue;
            String lcWord = word.toLowerCase();
            List<Language> languages2 = word2langs.get(lcWord);
            if (languages2 != null) {
                for (Language lang : languages2) {
                    result2.put(lang, result2.getOrDefault(lang, 0) + 1);
                }
            }
            if ((languages2 == null || !languages2.contains(ptLang)) && portuguesePattern.matcher(lcWord).matches()) {
                result2.put(ptLang, result2.getOrDefault(ptLang, 0) + 1);
            }
            if ((languages2 == null || !languages2.contains(esLang)) && spanishPattern.matcher(lcWord).matches()) {
                result2.put(esLang, result2.getOrDefault(esLang, 0) + 1);
            }
            if ((languages2 == null || !languages2.contains(esLang)) && notSpanishPattern.matcher(lcWord).matches()) {
                result2.put(esLang, result2.getOrDefault(esLang, 0) - 1);
            }
            if (languages2 != null && languages2.contains(caLang) || !notCatalanPattern.matcher(lcWord).matches()) continue;
            result2.put(caLang, result2.getOrDefault(caLang, 0) - 1);
        }
        return result2;
    }
}

