/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.document;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.ProtocolDocumentHost;
import com.jetbrains.rd.ide.model.DocumentExtension;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.ViewableMap;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.document.FrontendDocumentExtensionsProvider;
import com.jetbrains.rdclient.document.FrontendDocumentHostKt;
import com.jetbrains.rdclient.document.FrontendDocumentHostListener;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 32\u00020\u00012\u00020\u0002:\u000234B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bJ\u0006\u0010\u001c\u001a\u00020\u0018J\"\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J0\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J0\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0003\u001a\u00020\u0004H$J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\fH\u0016J\u001e\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H$J\u0010\u00100\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\fH\u0016J\u0010\u00101\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u0012\u00102\u001a\u0004\u0018\u00010'2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010)\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/jetbrains/rdclient/document/FrontendDocumentHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "Lcom/jetbrains/rd/ide/document/ProtocolDocumentHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "openedDocuments", "Lcom/jetbrains/rd/util/reactive/ViewableMap;", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "Lcom/intellij/openapi/editor/Document;", "getOpenedDocuments$annotations", "()V", "getOpenedDocuments", "()Lcom/jetbrains/rd/util/reactive/ViewableMap;", "recentlyClosedDocuments", "", "documentsOperationModel", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "getDocumentsOperationModel", "()Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "ensureProtocolSubscriptionsReady", "", "isRecentlyClosed", "", "documentId", "beforeRecoveryStarts", "getOrCreateIdeaDocument", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "viewDocumentModel", "documentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "ideaDocument", "createDocumentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "lifetime", "currentlyBindingDocument", "bindDocument", "createModel", "document", "extensions", "", "Lcom/jetbrains/rd/ide/model/DocumentExtension;", "createId", "unregisterDocument", "getSynchronizer", "Companion", "MyProtocolListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n68#2,4:215\n68#2,4:220\n68#2,4:225\n68#2,4:235\n14#2:241\n1#3:219\n66#4:224\n67#4,2:239\n1368#5:229\n1454#5,5:230\n*S KotlinDebug\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost\n*L\n102#1:215,4\n134#1:220,4\n172#1:225,4\n177#1:235,4\n38#1:241\n171#1:224\n171#1:239,2\n173#1:229\n173#1:230,5\n*E\n"})
public abstract class FrontendDocumentHost
extends LifetimedService
implements ProtocolDocumentHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final ViewableMap<RdDocumentId, Document> openedDocuments;
    @NotNull
    private final List<RdDocumentId> recentlyClosedDocuments;
    @Nullable
    private Document currentlyBindingDocument;
    @NotNull
    private static final Logger LOG;

    public FrontendDocumentHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.openedDocuments = new ViewableMap(null, 1, null);
        this.recentlyClosedDocuments = new ArrayList();
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    @NotNull
    protected final ViewableMap<RdDocumentId, Document> getOpenedDocuments() {
        return this.openedDocuments;
    }

    protected static /* synthetic */ void getOpenedDocuments$annotations() {
    }

    private final DocumentsOperationModel getDocumentsOperationModel() {
        return DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel((IProtocol)FrontendSessionsUtilKt.getProtocol(this.session));
    }

    public final void ensureProtocolSubscriptionsReady() {
        this.getDocumentsOperationModel();
    }

    public final boolean isRecentlyClosed(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return !((Map)this.openedDocuments).containsKey(documentId) && this.recentlyClosedDocuments.contains(documentId);
    }

    public final void beforeRecoveryStarts() {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Clear recentlyClosedDocuments before recovery starts.");
        }
        this.recentlyClosedDocuments.clear();
    }

    @Nullable
    protected Document getOrCreateIdeaDocument(@NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel, @NotNull IProtocol protocol) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Document document = this.currentlyBindingDocument;
        if (document != null) {
            Document it = document;
            boolean bl = false;
            return it;
        }
        document = (Document)this.openedDocuments.get((Object)documentId);
        if (document != null) {
            Document it = document;
            boolean bl = false;
            return it;
        }
        VirtualFile virtualFile = AppLevelIdeBackend.Companion.getInstance().tryCreateVirtualFile(documentId);
        if (virtualFile != null) {
            return FileDocumentManager.getInstance().getDocument(virtualFile);
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        boolean writeThreadOnlyAccess = documentModel.isWriteThreadOnly();
        EditorFactoryImpl editorFactoryImpl = editorFactory instanceof EditorFactoryImpl ? (EditorFactoryImpl)editorFactory : null;
        if (editorFactoryImpl == null || (editorFactoryImpl = editorFactoryImpl.createDocument(!writeThreadOnlyAccess)) == null) {
            Document document2;
            Document it = document2 = editorFactory.createDocument((CharSequence)"");
            boolean bl = false;
            LOG.warn("It is not possible to create a document with defined `forUseInNonAWTThread` field, because current EditorFactory is not an instance of EditorFactoryImpl class:editorFactory.class=" + editorFactory.getClass() + " documentId=" + documentId + " forUseInNonAWTThread=" + !writeThreadOnlyAccess);
            Document document3 = document2;
            editorFactoryImpl = document3;
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"also(...)");
        }
        return editorFactoryImpl;
    }

    protected void viewDocumentModel(@NotNull Lifetime documentLifetime, @NotNull RdDocumentId documentId, @NotNull Document ideaDocument, @NotNull RdDocumentModel documentModel, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)ideaDocument, (String)"ideaDocument");
        Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ThreadingAssertions.assertEventDispatchThread();
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("binding new document " + documentId + " with frontend document " + ideaDocument);
        }
        if (!(ideaDocument instanceof DocumentImpl)) {
            boolean $i$a$-require-FrontendDocumentHost$viewDocumentModel$32 = false;
            String $i$a$-require-FrontendDocumentHost$viewDocumentModel$32 = "ideaDocument is not a DocumentImpl";
            throw new IllegalArgumentException($i$a$-require-FrontendDocumentHost$viewDocumentModel$32.toString());
        }
        LOG.info("Subscribing for document changes.");
        RLifetimeKt.assertAlive((Lifetime)documentLifetime);
        DocumentSynchronizer documentSynchronizer = this.createDocumentSynchronizer(documentLifetime, documentId, ideaDocument, documentModel, session);
        DocumentExKt.putModel(ideaDocument, session, documentId, documentSynchronizer);
        FrontendDocumentHostKt.access$getBindingCounter(ideaDocument).incrementAndGet();
        ((Map)this.openedDocuments).put(documentId, ideaDocument);
        RLifetimeKt.plusAssign((Lifetime)documentLifetime, () -> FrontendDocumentHost.viewDocumentModel$lambda$6(documentId, this, ideaDocument, session));
        FrontendDocumentHostListener publisher = (FrontendDocumentHostListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendDocumentHostListener.Companion.getTOPIC());
        publisher.documentBound(documentLifetime, session, documentId, documentModel, ideaDocument);
    }

    @NotNull
    protected abstract DocumentSynchronizer createDocumentSynchronizer(@NotNull Lifetime var1, @NotNull RdDocumentId var2, @NotNull Document var3, @NotNull RdDocumentModel var4, @NotNull ClientAppSession var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public RdDocumentId bindDocument(@NotNull Document ideaDocument) {
        Intrinsics.checkNotNullParameter((Object)ideaDocument, (String)"ideaDocument");
        try {
            this.currentlyBindingDocument = ideaDocument;
            RdDocumentId documentId = this.createId(ideaDocument);
            IMutableViewableMap documents = this.getDocumentsOperationModel().getDocuments();
            Map $this$getOrCreate$iv = (Map)documents;
            boolean $i$f$getOrCreate = false;
            Object object = $this$getOrCreate$iv.get(documentId);
            if (object == null) {
                void $this$flatMapTo$iv$iv;
                Logger logger;
                RdDocumentId it = documentId;
                boolean bl = false;
                Logger $this$trace$iv = FrontendDocumentHost.LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl2 = false;
                    logger.trace("Creating model document. ee.Path: " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)documentId));
                }
                Iterable $this$flatMap$iv = FrontendDocumentExtensionsProvider.Companion.getEP_NAME().getExtensionList();
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    FrontendDocumentExtensionsProvider provider2 = (FrontendDocumentExtensionsProvider)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv = provider2.getExtensions(ideaDocument);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List extensions = (List)destination$iv$iv;
                RdDocumentModel rdDocumentModel = this.createModel(ideaDocument, extensions);
                Logger $this$trace$iv2 = FrontendDocumentHost.LOG;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    logger = $this$trace$iv2;
                    boolean bl4 = false;
                    logger.trace("Created model: " + rdDocumentModel + ", creation side:" + rdDocumentModel.getCreationSide());
                }
                RdDocumentModel it$iv = rdDocumentModel;
                boolean bl5 = false;
                $this$getOrCreate$iv.put(documentId, it$iv);
                object = it$iv;
            }
            LOG.info("finished registering document " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)documentId));
            RdDocumentId rdDocumentId = documentId;
            return rdDocumentId;
        }
        finally {
            this.currentlyBindingDocument = null;
        }
    }

    @NotNull
    protected abstract RdDocumentModel createModel(@NotNull Document var1, @NotNull List<? extends DocumentExtension> var2);

    @NotNull
    public RdDocumentId createId(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        RdDocumentId existingId = DocumentExKt.getDocumentId(document, this.session);
        if (existingId != null) {
            return existingId;
        }
        return super.createId(document);
    }

    public void unregisterDocument(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        ThreadingAssertions.assertEventDispatchThread();
        this.getDocumentsOperationModel().getDocuments().remove((Object)documentId);
    }

    @Nullable
    public DocumentSynchronizer getSynchronizer(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Document document = (Document)this.openedDocuments.get((Object)documentId);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        return DocumentExKt.getDocumentSynchronizer(document2, this.session);
    }

    private static final Unit viewDocumentModel$lambda$6(RdDocumentId $documentId, FrontendDocumentHost this$0, Document $ideaDocument, ClientAppSession $session) {
        LOG.info("Unbinding document " + $documentId);
        this$0.openedDocuments.remove((Object)$documentId);
        FrontendDocumentHostKt.access$getBindingCounter($ideaDocument).decrementAndGet();
        DocumentExKt.removeModel($ideaDocument, $session);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendDocumentHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/document/FrontendDocumentHost$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "tryGetInstance", "Lcom/jetbrains/rdclient/document/FrontendDocumentHost;", "project", "Lcom/intellij/openapi/project/Project;", "getInstance", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,214:1\n51#2:215\n31#2,2:216\n*S KotlinDebug\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$Companion\n*L\n44#1:215\n47#1:216,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        @Deprecated(message="Use an overload with client app session")
        @Nullable
        public final FrontendDocumentHost tryGetInstance(@Nullable Project project) {
            if (project == null || project.isDisposed()) {
                return null;
            }
            ClientProjectSession clientProjectSession = FrontendSessionsUtilKt.getFrontendProjectSessionOrNull(project);
            if (clientProjectSession == null) {
                return null;
            }
            ClientProjectSession session = clientProjectSession;
            ComponentManager $this$serviceOrNull$iv = (ComponentManager)session.getAppSession();
            boolean $i$f$serviceOrNull = false;
            return (FrontendDocumentHost)((Object)$this$serviceOrNull$iv.getService(FrontendDocumentHost.class));
        }

        @NotNull
        public final FrontendDocumentHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session;
            boolean $i$f$service = false;
            Class<FrontendDocumentHost> serviceClass$iv = FrontendDocumentHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendDocumentHost)((Object)object);
        }

        @Deprecated(message="Use an overload with client app session")
        @ApiStatus.Internal
        @NotNull
        public final FrontendDocumentHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project).getAppSession());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdclient/document/FrontendDocumentHost$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$MyProtocolListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,214:1\n68#2,4:215\n68#2,4:219\n68#2,4:223\n68#2,4:227\n*S KotlinDebug\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$MyProtocolListener\n*L\n64#1:215,4\n80#1:219,4\n71#1:223,4\n86#1:227,4\n*E\n"})
    public static final class MyProtocolListener
    implements RootExtListener<DocumentsOperationModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull DocumentsOperationModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Logger $this$trace$iv = Companion.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated: subscribe on `documents` model");
            }
            Companion.getLOG().assertTrue(model.getDocuments().isEmpty(), (Object)"Listener was created too last and the model was already obtained");
            model.getDocuments().view(lifetime, (arg_0, arg_1, arg_2) -> MyProtocolListener.extensionCreated$lambda$5(session, this, arg_0, arg_1, arg_2));
            model.getHostReleasedDocument().advise(lifetime, arg_0 -> MyProtocolListener.extensionCreated$lambda$7(session, arg_0));
        }

        private static final Unit extensionCreated$lambda$5$lambda$4(ClientAppSession $session, RdDocumentId $documentId) {
            Logger $this$trace$iv = Companion.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("document lifetime is terminating. Moving it's id to recentlyClosedDocuments: documentId=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)$documentId));
            }
            Companion.getInstance($session).recentlyClosedDocuments.add($documentId);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$5(ClientAppSession $session, MyProtocolListener this$0, Lifetime documentLifetime, RdDocumentId documentId, RdDocumentModel documentModel) {
            Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
            ThreadingAssertions.assertEventDispatchThread();
            Logger $this$trace$iv = Companion.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[file] MyProtocolListener$extensionCreated$solutions.view$documents.view before invokeLaterIfNeeded. document=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)documentId));
            }
            Document document = Companion.getInstance($session).getOrCreateIdeaDocument(documentId, documentModel, FrontendSessionsUtilKt.getProtocol($session));
            if (document == null) {
                MyProtocolListener $this$extensionCreated_u24lambda_u245_u24lambda_u242 = this$0;
                boolean bl = false;
                Companion.getLOG().warn("It's not possible to get or create a Document for " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)documentId));
                return Unit.INSTANCE;
            }
            Document document2 = document;
            Companion.getInstance($session).viewDocumentModel(documentLifetime, documentId, document2, documentModel, $session);
            documentLifetime.onTermination(() -> MyProtocolListener.extensionCreated$lambda$5$lambda$4($session, documentId));
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$7(ClientAppSession $session, RdDocumentId it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Logger $this$trace$iv = Companion.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("document was released on host. Remove it's id from recentlyClosedEditors: documentId=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)it) + " ");
            }
            Companion.getInstance($session).recentlyClosedDocuments.remove(it);
            return Unit.INSTANCE;
        }
    }
}

