/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.channels;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.ServerSocketChannelConfig;
import io.netty.util.NetUtil;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ServerSocketChannel;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\nH\u0017J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0012\u0010\u0011\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\nH\u0016J\u0012\u0010\u001d\u001a\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010 \u001a\u00020\u00022\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\nH\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010%\u001a\u00020\u0018H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\nH\u0016J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\nH\u0016J \u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/station/comms/common/netty/channels/NioDomainServerSocketChannelConfig;", "Lio/netty/channel/DefaultChannelConfig;", "Lio/netty/channel/socket/ServerSocketChannelConfig;", "ch", "Lio/netty/channel/Channel;", "serverSocketChannel", "Ljava/nio/channels/ServerSocketChannel;", "<init>", "(Lio/netty/channel/Channel;Ljava/nio/channels/ServerSocketChannel;)V", "backlog", "", "setConnectTimeoutMillis", "connectTimeoutMillis", "setMaxMessagesPerRead", "maxMessagesPerRead", "setWriteSpinCount", "writeSpinCount", "setAllocator", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "setRecvByteBufAllocator", "Lio/netty/channel/RecvByteBufAllocator;", "setAutoRead", "autoRead", "", "setWriteBufferHighWaterMark", "writeBufferHighWaterMark", "setWriteBufferLowWaterMark", "writeBufferLowWaterMark", "setMessageSizeEstimator", "estimator", "Lio/netty/channel/MessageSizeEstimator;", "setWriteBufferWaterMark", "writeBufferWaterMark", "Lio/netty/channel/WriteBufferWaterMark;", "getBacklog", "setBacklog", "isReuseAddress", "setReuseAddress", "reuseAddress", "getReceiveBufferSize", "setReceiveBufferSize", "receiveBufferSize", "setPerformancePreferences", "connectionTime", "latency", "bandwidth", "intellij.station.comms.common"})
public final class NioDomainServerSocketChannelConfig
extends DefaultChannelConfig
implements ServerSocketChannelConfig {
    @NotNull
    private final ServerSocketChannel serverSocketChannel;
    private int backlog;

    public NioDomainServerSocketChannelConfig(@NotNull Channel ch, @NotNull ServerSocketChannel serverSocketChannel) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        Intrinsics.checkNotNullParameter((Object)serverSocketChannel, (String)"serverSocketChannel");
        super(ch);
        this.serverSocketChannel = serverSocketChannel;
        this.backlog = NetUtil.SOMAXCONN;
    }

    @NotNull
    public ServerSocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        super.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    public ServerSocketChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        super.setMaxMessagesPerRead(maxMessagesPerRead);
        return this;
    }

    @NotNull
    public ServerSocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        super.setWriteSpinCount(writeSpinCount);
        return this;
    }

    @NotNull
    public ServerSocketChannelConfig setAllocator(@Nullable ByteBufAllocator allocator) {
        super.setAllocator(allocator);
        return this;
    }

    @NotNull
    public ServerSocketChannelConfig setRecvByteBufAllocator(@Nullable RecvByteBufAllocator allocator) {
        super.setRecvByteBufAllocator(allocator);
        return this;
    }

    @NotNull
    public ServerSocketChannelConfig setAutoRead(boolean autoRead) {
        super.setAutoRead(autoRead);
        return this;
    }

    @NotNull
    public ServerSocketChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        super.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        return this;
    }

    @NotNull
    public ServerSocketChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        super.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        return this;
    }

    @NotNull
    public ServerSocketChannelConfig setMessageSizeEstimator(@Nullable MessageSizeEstimator estimator) {
        super.setMessageSizeEstimator(estimator);
        return this;
    }

    @NotNull
    public ServerSocketChannelConfig setWriteBufferWaterMark(@Nullable WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    public int getBacklog() {
        return this.backlog;
    }

    @NotNull
    public ServerSocketChannelConfig setBacklog(int backlog) {
        if (backlog < 0) {
            throw new IllegalArgumentException("backlog must be >= 0");
        }
        this.backlog = backlog;
        return this;
    }

    public boolean isReuseAddress() {
        try {
            Boolean bl = this.serverSocketChannel.getOption(StandardSocketOptions.SO_REUSEADDR);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getOption(...)");
            return bl;
        }
        catch (SocketException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    @NotNull
    public ServerSocketChannelConfig setReuseAddress(boolean reuseAddress) {
        try {
            this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)reuseAddress);
            return this;
        }
        catch (SocketException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getReceiveBufferSize() {
        try {
            Integer n = this.serverSocketChannel.getOption(StandardSocketOptions.SO_RCVBUF);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOption(...)");
            return ((Number)n).intValue();
        }
        catch (SocketException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    @NotNull
    public ServerSocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        try {
            this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)receiveBufferSize);
            return this;
        }
        catch (SocketException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    @NotNull
    public ServerSocketChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        return this;
    }
}

