/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextbuffer.h>
    int _wxTextAttrDimension___nonzero__(wxTextAttrDimension* self)
    {
        return self->IsValid();
    }
    int _wxTextAttrDimension___bool__(wxTextAttrDimension* self)
    {
        return self->IsValid();
    }


PyDoc_STRVAR(doc_wxTextAttrDimension_Reset, "Reset() -> None\n"
"\n"
"Resets the dimension value and flags.");

extern "C" {static PyObject *meth_wxTextAttrDimension_Reset(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_Reset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Reset();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_Reset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_EqPartial, "EqPartial(dim, weakTest=True) -> bool\n"
"\n"
"Partial equality test.");

extern "C" {static PyObject *meth_wxTextAttrDimension_EqPartial(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_EqPartial(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension* dim;
        bool weakTest = 1;
        const ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dim,
            sipName_weakTest,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|b", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, sipType_wxTextAttrDimension, &dim, &weakTest))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EqPartial(*dim, weakTest);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_EqPartial, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_Apply, "Apply(dim, compareWith=None) -> bool\n"
"\n"
"Apply the dimension, but not those identical to compareWith if present.");

extern "C" {static PyObject *meth_wxTextAttrDimension_Apply(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_Apply(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension* dim;
        const ::wxTextAttrDimension* compareWith = 0;
        ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dim,
            sipName_compareWith,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|J8", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, sipType_wxTextAttrDimension, &dim, sipType_wxTextAttrDimension, &compareWith))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Apply(*dim, compareWith);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_Apply, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_CollectCommonAttributes, "CollectCommonAttributes(attr, clashingAttr, absentAttr) -> None\n"
"\n"
"Collects the attributes that are common to a range of content,\n"
"building up a note of which attributes are absent in some objects and\n"
"which clash in some objects.");

extern "C" {static PyObject *meth_wxTextAttrDimension_CollectCommonAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_CollectCommonAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension* attr;
        ::wxTextAttrDimension* clashingAttr;
        ::wxTextAttrDimension* absentAttr;
        ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attr,
            sipName_clashingAttr,
            sipName_absentAttr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9J9", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, sipType_wxTextAttrDimension, &attr, sipType_wxTextAttrDimension, &clashingAttr, sipType_wxTextAttrDimension, &absentAttr))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CollectCommonAttributes(*attr, *clashingAttr, *absentAttr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_CollectCommonAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_GetValue, "GetValue() -> int\n"
"\n"
"Returns the integer value of the dimension.");

extern "C" {static PyObject *meth_wxTextAttrDimension_GetValue(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_GetValue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetValue();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_GetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_GetValueMM, "GetValueMM() -> float\n"
"\n"
"Returns the floating-pointing value of the dimension in mm.");

extern "C" {static PyObject *meth_wxTextAttrDimension_GetValueMM(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_GetValueMM(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
            float sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetValueMM();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_GetValueMM, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_SetValueMM, "SetValueMM(value) -> None\n"
"\n"
"Sets the value of the dimension in mm.");

extern "C" {static PyObject *meth_wxTextAttrDimension_SetValueMM(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_SetValueMM(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float value;
        ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bf", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValueMM(value);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_SetValueMM, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_SetValue, "SetValue(value) -> None\n"
"SetValue(value, flags) -> None\n"
"SetValue(dim) -> None\n"
"\n"
"Sets the integer value of the dimension.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxTextAttrDimension_SetValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_SetValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int value;
        ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValue(value);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int value;
        ::wxTextAttrDimensionFlags flags;
        ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bit", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, &value, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValue(value, flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxTextAttrDimension* dim;
        ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dim,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, sipType_wxTextAttrDimension, &dim))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValue(*dim);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_SetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_GetUnits, "GetUnits() -> TextAttrUnits\n"
"\n"
"Gets the units of the dimension.");

extern "C" {static PyObject *meth_wxTextAttrDimension_GetUnits(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_GetUnits(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
            ::wxTextAttrUnits sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetUnits();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxTextAttrUnits);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_GetUnits, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_SetUnits, "SetUnits(units) -> None\n"
"\n"
"Sets the units of the dimension.");

extern "C" {static PyObject *meth_wxTextAttrDimension_SetUnits(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_SetUnits(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxTextAttrUnits units;
        ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_units,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, sipType_wxTextAttrUnits, &units))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetUnits(units);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_SetUnits, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_GetPosition, "GetPosition() -> TextBoxAttrPosition\n"
"\n"
"Gets the position flags.");

extern "C" {static PyObject *meth_wxTextAttrDimension_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
            ::wxTextBoxAttrPosition sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxTextBoxAttrPosition);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_GetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_SetPosition, "SetPosition(pos) -> None\n"
"\n"
"Sets the position flags.");

extern "C" {static PyObject *meth_wxTextAttrDimension_SetPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_SetPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxTextBoxAttrPosition pos;
        ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, sipType_wxTextBoxAttrPosition, &pos))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPosition(pos);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_SetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_IsValid, "IsValid() -> bool\n"
"\n"
"Returns true if the dimension is valid.");

extern "C" {static PyObject *meth_wxTextAttrDimension_IsValid(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_IsValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsValid();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_IsValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_SetValid, "SetValid(b) -> None\n"
"\n"
"Sets the valid flag.");

extern "C" {static PyObject *meth_wxTextAttrDimension_SetValid(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_SetValid(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool b;
        ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_b,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, &b))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValid(b);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_SetValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_GetFlags, "GetFlags() -> TextAttrDimensionFlags\n"
"\n"
"Gets the dimension flags.");

extern "C" {static PyObject *meth_wxTextAttrDimension_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
            ::wxTextAttrDimensionFlags sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_GetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension_SetFlags, "SetFlags(flags) -> None\n"
"\n"
"Sets the dimension flags.");

extern "C" {static PyObject *meth_wxTextAttrDimension_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxTextAttrDimensionFlags flags;
        ::wxTextAttrDimension *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bt", &sipSelf, sipType_wxTextAttrDimension, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName_SetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextAttrDimension___nonzero__, "__nonzero__() -> bool");

extern "C" {static PyObject *meth_wxTextAttrDimension___nonzero__(PyObject *, PyObject *);}
static PyObject *meth_wxTextAttrDimension___nonzero__(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxTextAttrDimension *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxTextAttrDimension, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxTextAttrDimension___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextAttrDimension, sipName___nonzero__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxTextAttrDimension___ne__(PyObject *, PyObject *);}
static PyObject *slot_wxTextAttrDimension___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTextAttrDimension));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension* dim;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTextAttrDimension, &dim))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = !sipCpp->::wxTextAttrDimension::operator==(*dim);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__richtext, ne_slot, sipType_wxTextAttrDimension, sipSelf, sipArg);
}


extern "C" {static int slot_wxTextAttrDimension___bool__(PyObject *);}
static int slot_wxTextAttrDimension___bool__(PyObject *sipSelf)
{
    ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTextAttrDimension));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxTextAttrDimension___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_wxTextAttrDimension___eq__(PyObject *, PyObject *);}
static PyObject *slot_wxTextAttrDimension___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxTextAttrDimension));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxTextAttrDimension* dim;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxTextAttrDimension, &dim))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxTextAttrDimension::operator==(*dim);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__richtext, eq_slot, sipType_wxTextAttrDimension, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTextAttrDimension(void *, int);}
static void release_wxTextAttrDimension(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxTextAttrDimension *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxTextAttrDimension(Py_ssize_t);}
static void *array_wxTextAttrDimension(Py_ssize_t sipNrElem)
{
    return new ::wxTextAttrDimension[sipNrElem];
}


extern "C" {static void array_delete_wxTextAttrDimension(void *);}
static void array_delete_wxTextAttrDimension(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxTextAttrDimension *>(sipCpp);
}


extern "C" {static void assign_wxTextAttrDimension(void *, Py_ssize_t, void *);}
static void assign_wxTextAttrDimension(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxTextAttrDimension *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxTextAttrDimension *>(sipSrc);
}


extern "C" {static void *copy_wxTextAttrDimension(const void *, Py_ssize_t);}
static void *copy_wxTextAttrDimension(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxTextAttrDimension(reinterpret_cast<const ::wxTextAttrDimension *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxTextAttrDimension(sipSimpleWrapper *);}
static void dealloc_wxTextAttrDimension(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTextAttrDimension(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxTextAttrDimension(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxTextAttrDimension(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxTextAttrDimension *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxTextAttrDimension();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        int value;
        ::wxTextAttrUnits units = wxTEXT_ATTR_UNITS_TENTHS_MM;

        static const char *sipKwdList[] = {
            sipName_value,
            sipName_units,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "i|E", &value, sipType_wxTextAttrUnits, &units))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxTextAttrDimension(value, units);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxTextAttrDimension* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxTextAttrDimension, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxTextAttrDimension(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxTextAttrDimension[] = {
    {(void *)slot_wxTextAttrDimension___ne__, ne_slot},
    {(void *)slot_wxTextAttrDimension___bool__, bool_slot},
    {(void *)slot_wxTextAttrDimension___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxTextAttrDimension[] = {
    {sipName_Apply, SIP_MLMETH_CAST(meth_wxTextAttrDimension_Apply), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimension_Apply},
    {sipName_CollectCommonAttributes, SIP_MLMETH_CAST(meth_wxTextAttrDimension_CollectCommonAttributes), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimension_CollectCommonAttributes},
    {sipName_EqPartial, SIP_MLMETH_CAST(meth_wxTextAttrDimension_EqPartial), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimension_EqPartial},
    {sipName_GetFlags, meth_wxTextAttrDimension_GetFlags, METH_VARARGS, doc_wxTextAttrDimension_GetFlags},
    {sipName_GetPosition, meth_wxTextAttrDimension_GetPosition, METH_VARARGS, doc_wxTextAttrDimension_GetPosition},
    {sipName_GetUnits, meth_wxTextAttrDimension_GetUnits, METH_VARARGS, doc_wxTextAttrDimension_GetUnits},
    {sipName_GetValue, meth_wxTextAttrDimension_GetValue, METH_VARARGS, doc_wxTextAttrDimension_GetValue},
    {sipName_GetValueMM, meth_wxTextAttrDimension_GetValueMM, METH_VARARGS, doc_wxTextAttrDimension_GetValueMM},
    {sipName_IsValid, meth_wxTextAttrDimension_IsValid, METH_VARARGS, doc_wxTextAttrDimension_IsValid},
    {sipName_Reset, meth_wxTextAttrDimension_Reset, METH_VARARGS, doc_wxTextAttrDimension_Reset},
    {sipName_SetFlags, SIP_MLMETH_CAST(meth_wxTextAttrDimension_SetFlags), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimension_SetFlags},
    {sipName_SetPosition, SIP_MLMETH_CAST(meth_wxTextAttrDimension_SetPosition), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimension_SetPosition},
    {sipName_SetUnits, SIP_MLMETH_CAST(meth_wxTextAttrDimension_SetUnits), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimension_SetUnits},
    {sipName_SetValid, SIP_MLMETH_CAST(meth_wxTextAttrDimension_SetValid), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimension_SetValid},
    {sipName_SetValue, SIP_MLMETH_CAST(meth_wxTextAttrDimension_SetValue), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimension_SetValue},
    {sipName_SetValueMM, SIP_MLMETH_CAST(meth_wxTextAttrDimension_SetValueMM), METH_VARARGS|METH_KEYWORDS, doc_wxTextAttrDimension_SetValueMM},
    {sipName___nonzero__, meth_wxTextAttrDimension___nonzero__, METH_VARARGS, doc_wxTextAttrDimension___nonzero__}
};


extern "C" {static PyObject *varget_wxTextAttrDimension_m_flags(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrDimension_m_flags(void *sipSelf, PyObject *, PyObject *)
{
    ::wxTextAttrDimensionFlags sipVal;
    ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipSelf);

    sipVal = sipCpp->m_flags;

    return PyLong_FromUnsignedLong(sipVal);
}


extern "C" {static int varset_wxTextAttrDimension_m_flags(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrDimension_m_flags(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::wxTextAttrDimensionFlags sipVal;
    ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipSelf);

    sipVal = sipLong_AsUnsignedShort(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_flags = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextAttrDimension_m_value(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextAttrDimension_m_value(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
    ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipSelf);

    sipVal = sipCpp->m_value;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_wxTextAttrDimension_m_value(void *, PyObject *, PyObject *);}
static int varset_wxTextAttrDimension_m_value(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::wxTextAttrDimension *sipCpp = reinterpret_cast< ::wxTextAttrDimension *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_value = sipVal;

    return 0;
}

sipVariableDef variables_wxTextAttrDimension[] = {
    {PropertyVariable, sipName_ValueMM, &methods_wxTextAttrDimension[7], &methods_wxTextAttrDimension[15], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Value, &methods_wxTextAttrDimension[6], &methods_wxTextAttrDimension[14], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Units, &methods_wxTextAttrDimension[5], &methods_wxTextAttrDimension[12], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Position, &methods_wxTextAttrDimension[4], &methods_wxTextAttrDimension[11], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Flags, &methods_wxTextAttrDimension[3], &methods_wxTextAttrDimension[10], SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_flags, (PyMethodDef *)varget_wxTextAttrDimension_m_flags, (PyMethodDef *)varset_wxTextAttrDimension_m_flags, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_value, (PyMethodDef *)varget_wxTextAttrDimension_m_value, (PyMethodDef *)varset_wxTextAttrDimension_m_value, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxTextAttrDimension, "TextAttrDimension() -> None\n"
"TextAttrDimension(value, units=TEXT_ATTR_UNITS_TENTHS_MM) -> None\n"
"\n"
"A class representing a rich text dimension, including units and\n"
"position.");


sipClassTypeDef sipTypeDef__richtext_wxTextAttrDimension = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxTextAttrDimension,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_TextAttrDimension,
        {0, 0, 1},
        17, methods_wxTextAttrDimension,
        0, SIP_NULLPTR,
        7, variables_wxTextAttrDimension,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxTextAttrDimension,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxTextAttrDimension,
    init_type_wxTextAttrDimension,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxTextAttrDimension,
    assign_wxTextAttrDimension,
    array_wxTextAttrDimension,
    copy_wxTextAttrDimension,
    release_wxTextAttrDimension,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxTextAttrDimension,
    sizeof (::wxTextAttrDimension),
};
