/* automatically generated by rust-bindgen 0.70.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::core::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::core::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::core::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::core::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::core::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const __GNUC_VA_LIST: u32 = 1;
pub const _SYS_TYPES_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __TIMESIZE: u32 = 64;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_60559_BFP__: u32 = 201404;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_IEC_60559_COMPLEX__: u32 = 201404;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 36;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __LDOUBLE_REDIRECTS_TO_FLOAT128_ABI: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __KERNEL_OLD_TIMEVAL_MATCHES_TIMEVAL64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _ENDIAN_H: u32 = 1;
pub const _BITS_ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const _BITS_ENDIANNESS_H: u32 = 1;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_UINTN_IDENTITY_H: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __sigset_t_defined: u32 = 1;
pub const __timeval_defined: u32 = 1;
pub const _STRUCT_TIMESPEC: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _BITS_PTHREADTYPES_COMMON_H: u32 = 1;
pub const _THREAD_SHARED_TYPES_H: u32 = 1;
pub const _BITS_PTHREADTYPES_ARCH_H: u32 = 1;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const _THREAD_MUTEX_INTERNAL_H: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __have_pthread_attr_t: u32 = 1;
pub const _STDINT_H: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const __BITS_PER_LONG: u32 = 64;
pub const __BITS_PER_LONG_LONG: u32 = 64;
pub const _IOC_NRBITS: u32 = 8;
pub const _IOC_TYPEBITS: u32 = 8;
pub const _IOC_SIZEBITS: u32 = 14;
pub const _IOC_DIRBITS: u32 = 2;
pub const _IOC_NRMASK: u32 = 255;
pub const _IOC_TYPEMASK: u32 = 255;
pub const _IOC_SIZEMASK: u32 = 16383;
pub const _IOC_DIRMASK: u32 = 3;
pub const _IOC_NRSHIFT: u32 = 0;
pub const _IOC_TYPESHIFT: u32 = 8;
pub const _IOC_SIZESHIFT: u32 = 16;
pub const _IOC_DIRSHIFT: u32 = 30;
pub const _IOC_NONE: u32 = 0;
pub const _IOC_WRITE: u32 = 1;
pub const _IOC_READ: u32 = 2;
pub const IOC_IN: u32 = 1073741824;
pub const IOC_OUT: u32 = 2147483648;
pub const IOC_INOUT: u32 = 3221225472;
pub const IOCSIZE_MASK: u32 = 1073676288;
pub const IOCSIZE_SHIFT: u32 = 16;
pub const DRM_NAME: &[u8; 4] = b"drm\0";
pub const DRM_MIN_ORDER: u32 = 5;
pub const DRM_MAX_ORDER: u32 = 22;
pub const DRM_RAM_PERCENT: u32 = 10;
pub const _DRM_LOCK_HELD: u32 = 2147483648;
pub const _DRM_LOCK_CONT: u32 = 1073741824;
pub const _DRM_VBLANK_HIGH_CRTC_SHIFT: u32 = 1;
pub const _DRM_PRE_MODESET: u32 = 1;
pub const _DRM_POST_MODESET: u32 = 2;
pub const DRM_CAP_DUMB_BUFFER: u32 = 1;
pub const DRM_CAP_VBLANK_HIGH_CRTC: u32 = 2;
pub const DRM_CAP_DUMB_PREFERRED_DEPTH: u32 = 3;
pub const DRM_CAP_DUMB_PREFER_SHADOW: u32 = 4;
pub const DRM_CAP_PRIME: u32 = 5;
pub const DRM_PRIME_CAP_IMPORT: u32 = 1;
pub const DRM_PRIME_CAP_EXPORT: u32 = 2;
pub const DRM_CAP_TIMESTAMP_MONOTONIC: u32 = 6;
pub const DRM_CAP_ASYNC_PAGE_FLIP: u32 = 7;
pub const DRM_CAP_CURSOR_WIDTH: u32 = 8;
pub const DRM_CAP_CURSOR_HEIGHT: u32 = 9;
pub const DRM_CAP_ADDFB2_MODIFIERS: u32 = 16;
pub const DRM_CAP_PAGE_FLIP_TARGET: u32 = 17;
pub const DRM_CAP_CRTC_IN_VBLANK_EVENT: u32 = 18;
pub const DRM_CAP_SYNCOBJ: u32 = 19;
pub const DRM_CAP_SYNCOBJ_TIMELINE: u32 = 20;
pub const DRM_CAP_ATOMIC_ASYNC_PAGE_FLIP: u32 = 21;
pub const DRM_CLIENT_CAP_STEREO_3D: u32 = 1;
pub const DRM_CLIENT_CAP_UNIVERSAL_PLANES: u32 = 2;
pub const DRM_CLIENT_CAP_ATOMIC: u32 = 3;
pub const DRM_CLIENT_CAP_ASPECT_RATIO: u32 = 4;
pub const DRM_CLIENT_CAP_WRITEBACK_CONNECTORS: u32 = 5;
pub const DRM_CLIENT_CAP_CURSOR_PLANE_HOTSPOT: u32 = 6;
pub const DRM_SYNCOBJ_CREATE_SIGNALED: u32 = 1;
pub const DRM_SYNCOBJ_FD_TO_HANDLE_FLAGS_IMPORT_SYNC_FILE: u32 = 1;
pub const DRM_SYNCOBJ_HANDLE_TO_FD_FLAGS_EXPORT_SYNC_FILE: u32 = 1;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_ALL: u32 = 1;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_FOR_SUBMIT: u32 = 2;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_AVAILABLE: u32 = 4;
pub const DRM_SYNCOBJ_WAIT_FLAGS_WAIT_DEADLINE: u32 = 8;
pub const DRM_SYNCOBJ_QUERY_FLAGS_LAST_SUBMITTED: u32 = 1;
pub const DRM_CRTC_SEQUENCE_RELATIVE: u32 = 1;
pub const DRM_CRTC_SEQUENCE_NEXT_ON_MISS: u32 = 2;
pub const DRM_CONNECTOR_NAME_LEN: u32 = 32;
pub const DRM_DISPLAY_MODE_LEN: u32 = 32;
pub const DRM_PROP_NAME_LEN: u32 = 32;
pub const DRM_MODE_TYPE_BUILTIN: u32 = 1;
pub const DRM_MODE_TYPE_CLOCK_C: u32 = 3;
pub const DRM_MODE_TYPE_CRTC_C: u32 = 5;
pub const DRM_MODE_TYPE_PREFERRED: u32 = 8;
pub const DRM_MODE_TYPE_DEFAULT: u32 = 16;
pub const DRM_MODE_TYPE_USERDEF: u32 = 32;
pub const DRM_MODE_TYPE_DRIVER: u32 = 64;
pub const DRM_MODE_TYPE_ALL: u32 = 104;
pub const DRM_MODE_FLAG_PHSYNC: u32 = 1;
pub const DRM_MODE_FLAG_NHSYNC: u32 = 2;
pub const DRM_MODE_FLAG_PVSYNC: u32 = 4;
pub const DRM_MODE_FLAG_NVSYNC: u32 = 8;
pub const DRM_MODE_FLAG_INTERLACE: u32 = 16;
pub const DRM_MODE_FLAG_DBLSCAN: u32 = 32;
pub const DRM_MODE_FLAG_CSYNC: u32 = 64;
pub const DRM_MODE_FLAG_PCSYNC: u32 = 128;
pub const DRM_MODE_FLAG_NCSYNC: u32 = 256;
pub const DRM_MODE_FLAG_HSKEW: u32 = 512;
pub const DRM_MODE_FLAG_BCAST: u32 = 1024;
pub const DRM_MODE_FLAG_PIXMUX: u32 = 2048;
pub const DRM_MODE_FLAG_DBLCLK: u32 = 4096;
pub const DRM_MODE_FLAG_CLKDIV2: u32 = 8192;
pub const DRM_MODE_FLAG_3D_MASK: u32 = 507904;
pub const DRM_MODE_FLAG_3D_NONE: u32 = 0;
pub const DRM_MODE_FLAG_3D_FRAME_PACKING: u32 = 16384;
pub const DRM_MODE_FLAG_3D_FIELD_ALTERNATIVE: u32 = 32768;
pub const DRM_MODE_FLAG_3D_LINE_ALTERNATIVE: u32 = 49152;
pub const DRM_MODE_FLAG_3D_SIDE_BY_SIDE_FULL: u32 = 65536;
pub const DRM_MODE_FLAG_3D_L_DEPTH: u32 = 81920;
pub const DRM_MODE_FLAG_3D_L_DEPTH_GFX_GFX_DEPTH: u32 = 98304;
pub const DRM_MODE_FLAG_3D_TOP_AND_BOTTOM: u32 = 114688;
pub const DRM_MODE_FLAG_3D_SIDE_BY_SIDE_HALF: u32 = 131072;
pub const DRM_MODE_PICTURE_ASPECT_NONE: u32 = 0;
pub const DRM_MODE_PICTURE_ASPECT_4_3: u32 = 1;
pub const DRM_MODE_PICTURE_ASPECT_16_9: u32 = 2;
pub const DRM_MODE_PICTURE_ASPECT_64_27: u32 = 3;
pub const DRM_MODE_PICTURE_ASPECT_256_135: u32 = 4;
pub const DRM_MODE_CONTENT_TYPE_NO_DATA: u32 = 0;
pub const DRM_MODE_CONTENT_TYPE_GRAPHICS: u32 = 1;
pub const DRM_MODE_CONTENT_TYPE_PHOTO: u32 = 2;
pub const DRM_MODE_CONTENT_TYPE_CINEMA: u32 = 3;
pub const DRM_MODE_CONTENT_TYPE_GAME: u32 = 4;
pub const DRM_MODE_FLAG_PIC_AR_MASK: u32 = 7864320;
pub const DRM_MODE_FLAG_PIC_AR_NONE: u32 = 0;
pub const DRM_MODE_FLAG_PIC_AR_4_3: u32 = 524288;
pub const DRM_MODE_FLAG_PIC_AR_16_9: u32 = 1048576;
pub const DRM_MODE_FLAG_PIC_AR_64_27: u32 = 1572864;
pub const DRM_MODE_FLAG_PIC_AR_256_135: u32 = 2097152;
pub const DRM_MODE_FLAG_ALL: u32 = 521215;
pub const DRM_MODE_DPMS_ON: u32 = 0;
pub const DRM_MODE_DPMS_STANDBY: u32 = 1;
pub const DRM_MODE_DPMS_SUSPEND: u32 = 2;
pub const DRM_MODE_DPMS_OFF: u32 = 3;
pub const DRM_MODE_SCALE_NONE: u32 = 0;
pub const DRM_MODE_SCALE_FULLSCREEN: u32 = 1;
pub const DRM_MODE_SCALE_CENTER: u32 = 2;
pub const DRM_MODE_SCALE_ASPECT: u32 = 3;
pub const DRM_MODE_DITHERING_OFF: u32 = 0;
pub const DRM_MODE_DITHERING_ON: u32 = 1;
pub const DRM_MODE_DITHERING_AUTO: u32 = 2;
pub const DRM_MODE_DIRTY_OFF: u32 = 0;
pub const DRM_MODE_DIRTY_ON: u32 = 1;
pub const DRM_MODE_DIRTY_ANNOTATE: u32 = 2;
pub const DRM_MODE_LINK_STATUS_GOOD: u32 = 0;
pub const DRM_MODE_LINK_STATUS_BAD: u32 = 1;
pub const DRM_MODE_ROTATE_0: u32 = 1;
pub const DRM_MODE_ROTATE_90: u32 = 2;
pub const DRM_MODE_ROTATE_180: u32 = 4;
pub const DRM_MODE_ROTATE_270: u32 = 8;
pub const DRM_MODE_ROTATE_MASK: u32 = 15;
pub const DRM_MODE_REFLECT_X: u32 = 16;
pub const DRM_MODE_REFLECT_Y: u32 = 32;
pub const DRM_MODE_REFLECT_MASK: u32 = 48;
pub const DRM_MODE_CONTENT_PROTECTION_UNDESIRED: u32 = 0;
pub const DRM_MODE_CONTENT_PROTECTION_DESIRED: u32 = 1;
pub const DRM_MODE_CONTENT_PROTECTION_ENABLED: u32 = 2;
pub const DRM_MODE_PRESENT_TOP_FIELD: u32 = 1;
pub const DRM_MODE_PRESENT_BOTTOM_FIELD: u32 = 2;
pub const DRM_MODE_ENCODER_NONE: u32 = 0;
pub const DRM_MODE_ENCODER_DAC: u32 = 1;
pub const DRM_MODE_ENCODER_TMDS: u32 = 2;
pub const DRM_MODE_ENCODER_LVDS: u32 = 3;
pub const DRM_MODE_ENCODER_TVDAC: u32 = 4;
pub const DRM_MODE_ENCODER_VIRTUAL: u32 = 5;
pub const DRM_MODE_ENCODER_DSI: u32 = 6;
pub const DRM_MODE_ENCODER_DPMST: u32 = 7;
pub const DRM_MODE_ENCODER_DPI: u32 = 8;
pub const DRM_MODE_CONNECTOR_Unknown: u32 = 0;
pub const DRM_MODE_CONNECTOR_VGA: u32 = 1;
pub const DRM_MODE_CONNECTOR_DVII: u32 = 2;
pub const DRM_MODE_CONNECTOR_DVID: u32 = 3;
pub const DRM_MODE_CONNECTOR_DVIA: u32 = 4;
pub const DRM_MODE_CONNECTOR_Composite: u32 = 5;
pub const DRM_MODE_CONNECTOR_SVIDEO: u32 = 6;
pub const DRM_MODE_CONNECTOR_LVDS: u32 = 7;
pub const DRM_MODE_CONNECTOR_Component: u32 = 8;
pub const DRM_MODE_CONNECTOR_9PinDIN: u32 = 9;
pub const DRM_MODE_CONNECTOR_DisplayPort: u32 = 10;
pub const DRM_MODE_CONNECTOR_HDMIA: u32 = 11;
pub const DRM_MODE_CONNECTOR_HDMIB: u32 = 12;
pub const DRM_MODE_CONNECTOR_TV: u32 = 13;
pub const DRM_MODE_CONNECTOR_eDP: u32 = 14;
pub const DRM_MODE_CONNECTOR_VIRTUAL: u32 = 15;
pub const DRM_MODE_CONNECTOR_DSI: u32 = 16;
pub const DRM_MODE_CONNECTOR_DPI: u32 = 17;
pub const DRM_MODE_CONNECTOR_WRITEBACK: u32 = 18;
pub const DRM_MODE_CONNECTOR_SPI: u32 = 19;
pub const DRM_MODE_CONNECTOR_USB: u32 = 20;
pub const DRM_MODE_PROP_PENDING: u32 = 1;
pub const DRM_MODE_PROP_RANGE: u32 = 2;
pub const DRM_MODE_PROP_IMMUTABLE: u32 = 4;
pub const DRM_MODE_PROP_ENUM: u32 = 8;
pub const DRM_MODE_PROP_BLOB: u32 = 16;
pub const DRM_MODE_PROP_BITMASK: u32 = 32;
pub const DRM_MODE_PROP_LEGACY_TYPE: u32 = 58;
pub const DRM_MODE_PROP_EXTENDED_TYPE: u32 = 65472;
pub const DRM_MODE_PROP_ATOMIC: u32 = 2147483648;
pub const DRM_MODE_OBJECT_CRTC: u32 = 3435973836;
pub const DRM_MODE_OBJECT_CONNECTOR: u32 = 3233857728;
pub const DRM_MODE_OBJECT_ENCODER: u32 = 3772834016;
pub const DRM_MODE_OBJECT_MODE: u32 = 3739147998;
pub const DRM_MODE_OBJECT_PROPERTY: u32 = 2964369584;
pub const DRM_MODE_OBJECT_FB: u32 = 4227595259;
pub const DRM_MODE_OBJECT_BLOB: u32 = 3149642683;
pub const DRM_MODE_OBJECT_PLANE: u32 = 4008636142;
pub const DRM_MODE_OBJECT_ANY: u32 = 0;
pub const DRM_MODE_FB_INTERLACED: u32 = 1;
pub const DRM_MODE_FB_MODIFIERS: u32 = 2;
pub const DRM_MODE_FB_DIRTY_ANNOTATE_COPY: u32 = 1;
pub const DRM_MODE_FB_DIRTY_ANNOTATE_FILL: u32 = 2;
pub const DRM_MODE_FB_DIRTY_FLAGS: u32 = 3;
pub const DRM_MODE_FB_DIRTY_MAX_CLIPS: u32 = 256;
pub const DRM_MODE_CURSOR_BO: u32 = 1;
pub const DRM_MODE_CURSOR_MOVE: u32 = 2;
pub const DRM_MODE_CURSOR_FLAGS: u32 = 3;
pub const DRM_MODE_PAGE_FLIP_EVENT: u32 = 1;
pub const DRM_MODE_PAGE_FLIP_ASYNC: u32 = 2;
pub const DRM_MODE_PAGE_FLIP_TARGET_ABSOLUTE: u32 = 4;
pub const DRM_MODE_PAGE_FLIP_TARGET_RELATIVE: u32 = 8;
pub const DRM_MODE_PAGE_FLIP_TARGET: u32 = 12;
pub const DRM_MODE_PAGE_FLIP_FLAGS: u32 = 15;
pub const DRM_MODE_ATOMIC_TEST_ONLY: u32 = 256;
pub const DRM_MODE_ATOMIC_NONBLOCK: u32 = 512;
pub const DRM_MODE_ATOMIC_ALLOW_MODESET: u32 = 1024;
pub const DRM_MODE_ATOMIC_FLAGS: u32 = 1795;
pub const FORMAT_BLOB_CURRENT: u32 = 1;
pub const DRM_IOCTL_BASE: u8 = 100u8;
pub const DRM_COMMAND_BASE: u32 = 64;
pub const DRM_COMMAND_END: u32 = 160;
pub const DRM_EVENT_VBLANK: u32 = 1;
pub const DRM_EVENT_FLIP_COMPLETE: u32 = 2;
pub const DRM_EVENT_CRTC_SEQUENCE: u32 = 3;
pub const DRM_MAX_MINOR: u32 = 64;
pub const DRM_IOC_VOID: u32 = 0;
pub const DRM_IOC_READ: u32 = 2;
pub const DRM_IOC_WRITE: u32 = 1;
pub const DRM_IOC_READWRITE: u32 = 3;
pub const DRM_DEV_UID: u32 = 0;
pub const DRM_DEV_GID: u32 = 0;
pub const DRM_DIR_NAME: &[u8; 9] = b"/dev/dri\0";
pub const DRM_PRIMARY_MINOR_NAME: &[u8; 5] = b"card\0";
pub const DRM_CONTROL_MINOR_NAME: &[u8; 9] = b"controlD\0";
pub const DRM_RENDER_MINOR_NAME: &[u8; 8] = b"renderD\0";
pub const DRM_PROC_NAME: &[u8; 11] = b"/proc/dri/\0";
pub const DRM_DEV_NAME: &[u8; 10] = b"%s/card%d\0";
pub const DRM_CONTROL_DEV_NAME: &[u8; 14] = b"%s/controlD%d\0";
pub const DRM_RENDER_DEV_NAME: &[u8; 13] = b"%s/renderD%d\0";
pub const DRM_ERR_NO_DEVICE: i32 = -1001;
pub const DRM_ERR_NO_ACCESS: i32 = -1002;
pub const DRM_ERR_NOT_ROOT: i32 = -1003;
pub const DRM_ERR_INVALID: i32 = -1004;
pub const DRM_ERR_NO_FD: i32 = -1005;
pub const DRM_AGP_NO_HANDLE: u32 = 0;
pub const DRM_VBLANK_HIGH_CRTC_SHIFT: u32 = 1;
pub const DRM_LOCK_HELD: u32 = 2147483648;
pub const DRM_LOCK_CONT: u32 = 1073741824;
pub const DRM_NODE_PRIMARY: u32 = 0;
pub const DRM_NODE_CONTROL: u32 = 1;
pub const DRM_NODE_RENDER: u32 = 2;
pub const DRM_NODE_MAX: u32 = 3;
pub const DRM_EVENT_CONTEXT_VERSION: u32 = 4;
pub const DRM_BUS_PCI: u32 = 0;
pub const DRM_BUS_USB: u32 = 1;
pub const DRM_BUS_PLATFORM: u32 = 2;
pub const DRM_BUS_HOST1X: u32 = 3;
pub const DRM_PLATFORM_DEVICE_NAME_LEN: u32 = 512;
pub const DRM_HOST1X_DEVICE_NAME_LEN: u32 = 512;
pub const DRM_DEVICE_GET_PCI_REVISION: u32 = 1;
pub const __bool_true_false_are_defined: u32 = 1;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const DRM_MODE_FEATURE_KMS: u32 = 1;
pub const DRM_MODE_FEATURE_DIRTYFB: u32 = 1;
pub const DRM_PLANE_TYPE_OVERLAY: u32 = 0;
pub const DRM_PLANE_TYPE_PRIMARY: u32 = 1;
pub const DRM_PLANE_TYPE_CURSOR: u32 = 2;
pub const AMDGPU_CS_MAX_IBS_PER_SUBMIT: u32 = 4;
pub const AMDGPU_TIMEOUT_INFINITE: i32 = -1;
pub const AMDGPU_QUERY_FENCE_TIMEOUT_IS_ABSOLUTE: u32 = 1;
pub const AMDGPU_VA_RANGE_32_BIT: u32 = 1;
pub const AMDGPU_VA_RANGE_HIGH: u32 = 2;
pub const AMDGPU_VA_RANGE_REPLAYABLE: u32 = 4;
pub const DRM_AMDGPU_GEM_CREATE: u32 = 0;
pub const DRM_AMDGPU_GEM_MMAP: u32 = 1;
pub const DRM_AMDGPU_CTX: u32 = 2;
pub const DRM_AMDGPU_BO_LIST: u32 = 3;
pub const DRM_AMDGPU_CS: u32 = 4;
pub const DRM_AMDGPU_INFO: u32 = 5;
pub const DRM_AMDGPU_GEM_METADATA: u32 = 6;
pub const DRM_AMDGPU_GEM_WAIT_IDLE: u32 = 7;
pub const DRM_AMDGPU_GEM_VA: u32 = 8;
pub const DRM_AMDGPU_WAIT_CS: u32 = 9;
pub const DRM_AMDGPU_GEM_OP: u32 = 16;
pub const DRM_AMDGPU_GEM_USERPTR: u32 = 17;
pub const DRM_AMDGPU_WAIT_FENCES: u32 = 18;
pub const DRM_AMDGPU_VM: u32 = 19;
pub const DRM_AMDGPU_FENCE_TO_HANDLE: u32 = 20;
pub const DRM_AMDGPU_SCHED: u32 = 21;
pub const AMDGPU_GEM_DOMAIN_CPU: u32 = 1;
pub const AMDGPU_GEM_DOMAIN_GTT: u32 = 2;
pub const AMDGPU_GEM_DOMAIN_VRAM: u32 = 4;
pub const AMDGPU_GEM_DOMAIN_GDS: u32 = 8;
pub const AMDGPU_GEM_DOMAIN_GWS: u32 = 16;
pub const AMDGPU_GEM_DOMAIN_OA: u32 = 32;
pub const AMDGPU_GEM_DOMAIN_DOORBELL: u32 = 64;
pub const AMDGPU_GEM_DOMAIN_MASK: u32 = 127;
pub const AMDGPU_GEM_CREATE_CPU_ACCESS_REQUIRED: u32 = 1;
pub const AMDGPU_GEM_CREATE_NO_CPU_ACCESS: u32 = 2;
pub const AMDGPU_GEM_CREATE_CPU_GTT_USWC: u32 = 4;
pub const AMDGPU_GEM_CREATE_VRAM_CLEARED: u32 = 8;
pub const AMDGPU_GEM_CREATE_VRAM_CONTIGUOUS: u32 = 32;
pub const AMDGPU_GEM_CREATE_VM_ALWAYS_VALID: u32 = 64;
pub const AMDGPU_GEM_CREATE_EXPLICIT_SYNC: u32 = 128;
pub const AMDGPU_GEM_CREATE_CP_MQD_GFX9: u32 = 256;
pub const AMDGPU_GEM_CREATE_VRAM_WIPE_ON_RELEASE: u32 = 512;
pub const AMDGPU_GEM_CREATE_ENCRYPTED: u32 = 1024;
pub const AMDGPU_GEM_CREATE_PREEMPTIBLE: u32 = 2048;
pub const AMDGPU_GEM_CREATE_DISCARDABLE: u32 = 4096;
pub const AMDGPU_GEM_CREATE_COHERENT: u32 = 8192;
pub const AMDGPU_GEM_CREATE_UNCACHED: u32 = 16384;
pub const AMDGPU_GEM_CREATE_EXT_COHERENT: u32 = 32768;
pub const AMDGPU_BO_LIST_OP_CREATE: u32 = 0;
pub const AMDGPU_BO_LIST_OP_DESTROY: u32 = 1;
pub const AMDGPU_BO_LIST_OP_UPDATE: u32 = 2;
pub const AMDGPU_CTX_OP_ALLOC_CTX: u32 = 1;
pub const AMDGPU_CTX_OP_FREE_CTX: u32 = 2;
pub const AMDGPU_CTX_OP_QUERY_STATE: u32 = 3;
pub const AMDGPU_CTX_OP_QUERY_STATE2: u32 = 4;
pub const AMDGPU_CTX_OP_GET_STABLE_PSTATE: u32 = 5;
pub const AMDGPU_CTX_OP_SET_STABLE_PSTATE: u32 = 6;
pub const AMDGPU_CTX_NO_RESET: u32 = 0;
pub const AMDGPU_CTX_GUILTY_RESET: u32 = 1;
pub const AMDGPU_CTX_INNOCENT_RESET: u32 = 2;
pub const AMDGPU_CTX_UNKNOWN_RESET: u32 = 3;
pub const AMDGPU_CTX_QUERY2_FLAGS_RESET: u32 = 1;
pub const AMDGPU_CTX_QUERY2_FLAGS_VRAMLOST: u32 = 2;
pub const AMDGPU_CTX_QUERY2_FLAGS_GUILTY: u32 = 4;
pub const AMDGPU_CTX_QUERY2_FLAGS_RAS_CE: u32 = 8;
pub const AMDGPU_CTX_QUERY2_FLAGS_RAS_UE: u32 = 16;
pub const AMDGPU_CTX_QUERY2_FLAGS_RESET_IN_PROGRESS: u32 = 32;
pub const AMDGPU_CTX_PRIORITY_UNSET: i32 = -2048;
pub const AMDGPU_CTX_PRIORITY_VERY_LOW: i32 = -1023;
pub const AMDGPU_CTX_PRIORITY_LOW: i32 = -512;
pub const AMDGPU_CTX_PRIORITY_NORMAL: u32 = 0;
pub const AMDGPU_CTX_PRIORITY_HIGH: u32 = 512;
pub const AMDGPU_CTX_PRIORITY_VERY_HIGH: u32 = 1023;
pub const AMDGPU_CTX_STABLE_PSTATE_FLAGS_MASK: u32 = 15;
pub const AMDGPU_CTX_STABLE_PSTATE_NONE: u32 = 0;
pub const AMDGPU_CTX_STABLE_PSTATE_STANDARD: u32 = 1;
pub const AMDGPU_CTX_STABLE_PSTATE_MIN_SCLK: u32 = 2;
pub const AMDGPU_CTX_STABLE_PSTATE_MIN_MCLK: u32 = 3;
pub const AMDGPU_CTX_STABLE_PSTATE_PEAK: u32 = 4;
pub const AMDGPU_VM_OP_RESERVE_VMID: u32 = 1;
pub const AMDGPU_VM_OP_UNRESERVE_VMID: u32 = 2;
pub const AMDGPU_SCHED_OP_PROCESS_PRIORITY_OVERRIDE: u32 = 1;
pub const AMDGPU_SCHED_OP_CONTEXT_PRIORITY_OVERRIDE: u32 = 2;
pub const AMDGPU_GEM_USERPTR_READONLY: u32 = 1;
pub const AMDGPU_GEM_USERPTR_ANONONLY: u32 = 2;
pub const AMDGPU_GEM_USERPTR_VALIDATE: u32 = 4;
pub const AMDGPU_GEM_USERPTR_REGISTER: u32 = 8;
pub const AMDGPU_TILING_ARRAY_MODE_SHIFT: u32 = 0;
pub const AMDGPU_TILING_ARRAY_MODE_MASK: u32 = 15;
pub const AMDGPU_TILING_PIPE_CONFIG_SHIFT: u32 = 4;
pub const AMDGPU_TILING_PIPE_CONFIG_MASK: u32 = 31;
pub const AMDGPU_TILING_TILE_SPLIT_SHIFT: u32 = 9;
pub const AMDGPU_TILING_TILE_SPLIT_MASK: u32 = 7;
pub const AMDGPU_TILING_MICRO_TILE_MODE_SHIFT: u32 = 12;
pub const AMDGPU_TILING_MICRO_TILE_MODE_MASK: u32 = 7;
pub const AMDGPU_TILING_BANK_WIDTH_SHIFT: u32 = 15;
pub const AMDGPU_TILING_BANK_WIDTH_MASK: u32 = 3;
pub const AMDGPU_TILING_BANK_HEIGHT_SHIFT: u32 = 17;
pub const AMDGPU_TILING_BANK_HEIGHT_MASK: u32 = 3;
pub const AMDGPU_TILING_MACRO_TILE_ASPECT_SHIFT: u32 = 19;
pub const AMDGPU_TILING_MACRO_TILE_ASPECT_MASK: u32 = 3;
pub const AMDGPU_TILING_NUM_BANKS_SHIFT: u32 = 21;
pub const AMDGPU_TILING_NUM_BANKS_MASK: u32 = 3;
pub const AMDGPU_TILING_SWIZZLE_MODE_SHIFT: u32 = 0;
pub const AMDGPU_TILING_SWIZZLE_MODE_MASK: u32 = 31;
pub const AMDGPU_TILING_DCC_OFFSET_256B_SHIFT: u32 = 5;
pub const AMDGPU_TILING_DCC_OFFSET_256B_MASK: u32 = 16777215;
pub const AMDGPU_TILING_DCC_PITCH_MAX_SHIFT: u32 = 29;
pub const AMDGPU_TILING_DCC_PITCH_MAX_MASK: u32 = 16383;
pub const AMDGPU_TILING_DCC_INDEPENDENT_64B_SHIFT: u32 = 43;
pub const AMDGPU_TILING_DCC_INDEPENDENT_64B_MASK: u32 = 1;
pub const AMDGPU_TILING_DCC_INDEPENDENT_128B_SHIFT: u32 = 44;
pub const AMDGPU_TILING_DCC_INDEPENDENT_128B_MASK: u32 = 1;
pub const AMDGPU_TILING_SCANOUT_SHIFT: u32 = 63;
pub const AMDGPU_TILING_SCANOUT_MASK: u32 = 1;
pub const AMDGPU_GEM_METADATA_OP_SET_METADATA: u32 = 1;
pub const AMDGPU_GEM_METADATA_OP_GET_METADATA: u32 = 2;
pub const AMDGPU_GEM_OP_GET_GEM_CREATE_INFO: u32 = 0;
pub const AMDGPU_GEM_OP_SET_PLACEMENT: u32 = 1;
pub const AMDGPU_VA_OP_MAP: u32 = 1;
pub const AMDGPU_VA_OP_UNMAP: u32 = 2;
pub const AMDGPU_VA_OP_CLEAR: u32 = 3;
pub const AMDGPU_VA_OP_REPLACE: u32 = 4;
pub const AMDGPU_VM_DELAY_UPDATE: u32 = 1;
pub const AMDGPU_VM_PAGE_READABLE: u32 = 2;
pub const AMDGPU_VM_PAGE_WRITEABLE: u32 = 4;
pub const AMDGPU_VM_PAGE_EXECUTABLE: u32 = 8;
pub const AMDGPU_VM_PAGE_PRT: u32 = 16;
pub const AMDGPU_VM_MTYPE_MASK: u32 = 480;
pub const AMDGPU_VM_MTYPE_DEFAULT: u32 = 0;
pub const AMDGPU_VM_MTYPE_NC: u32 = 32;
pub const AMDGPU_VM_MTYPE_WC: u32 = 64;
pub const AMDGPU_VM_MTYPE_CC: u32 = 96;
pub const AMDGPU_VM_MTYPE_UC: u32 = 128;
pub const AMDGPU_VM_MTYPE_RW: u32 = 160;
pub const AMDGPU_VM_PAGE_NOALLOC: u32 = 512;
pub const AMDGPU_HW_IP_GFX: u32 = 0;
pub const AMDGPU_HW_IP_COMPUTE: u32 = 1;
pub const AMDGPU_HW_IP_DMA: u32 = 2;
pub const AMDGPU_HW_IP_UVD: u32 = 3;
pub const AMDGPU_HW_IP_VCE: u32 = 4;
pub const AMDGPU_HW_IP_UVD_ENC: u32 = 5;
pub const AMDGPU_HW_IP_VCN_DEC: u32 = 6;
pub const AMDGPU_HW_IP_VCN_ENC: u32 = 7;
pub const AMDGPU_HW_IP_VCN_JPEG: u32 = 8;
pub const AMDGPU_HW_IP_VPE: u32 = 9;
pub const AMDGPU_HW_IP_NUM: u32 = 10;
pub const AMDGPU_HW_IP_INSTANCE_MAX_COUNT: u32 = 1;
pub const AMDGPU_CHUNK_ID_IB: u32 = 1;
pub const AMDGPU_CHUNK_ID_FENCE: u32 = 2;
pub const AMDGPU_CHUNK_ID_DEPENDENCIES: u32 = 3;
pub const AMDGPU_CHUNK_ID_SYNCOBJ_IN: u32 = 4;
pub const AMDGPU_CHUNK_ID_SYNCOBJ_OUT: u32 = 5;
pub const AMDGPU_CHUNK_ID_BO_HANDLES: u32 = 6;
pub const AMDGPU_CHUNK_ID_SCHEDULED_DEPENDENCIES: u32 = 7;
pub const AMDGPU_CHUNK_ID_SYNCOBJ_TIMELINE_WAIT: u32 = 8;
pub const AMDGPU_CHUNK_ID_SYNCOBJ_TIMELINE_SIGNAL: u32 = 9;
pub const AMDGPU_CHUNK_ID_CP_GFX_SHADOW: u32 = 10;
pub const AMDGPU_IB_FLAG_CE: u32 = 1;
pub const AMDGPU_IB_FLAG_PREAMBLE: u32 = 2;
pub const AMDGPU_IB_FLAG_PREEMPT: u32 = 4;
pub const AMDGPU_IB_FLAG_TC_WB_NOT_INVALIDATE: u32 = 8;
pub const AMDGPU_IB_FLAG_RESET_GDS_MAX_WAVE_ID: u32 = 16;
pub const AMDGPU_IB_FLAGS_SECURE: u32 = 32;
pub const AMDGPU_IB_FLAG_EMIT_MEM_SYNC: u32 = 64;
pub const AMDGPU_FENCE_TO_HANDLE_GET_SYNCOBJ: u32 = 0;
pub const AMDGPU_FENCE_TO_HANDLE_GET_SYNCOBJ_FD: u32 = 1;
pub const AMDGPU_FENCE_TO_HANDLE_GET_SYNC_FILE_FD: u32 = 2;
pub const AMDGPU_CS_CHUNK_CP_GFX_SHADOW_FLAGS_INIT_SHADOW: u32 = 1;
pub const AMDGPU_IDS_FLAGS_FUSION: u32 = 1;
pub const AMDGPU_IDS_FLAGS_PREEMPTION: u32 = 2;
pub const AMDGPU_IDS_FLAGS_TMZ: u32 = 4;
pub const AMDGPU_IDS_FLAGS_CONFORMANT_TRUNC_COORD: u32 = 8;
pub const AMDGPU_INFO_ACCEL_WORKING: u32 = 0;
pub const AMDGPU_INFO_CRTC_FROM_ID: u32 = 1;
pub const AMDGPU_INFO_HW_IP_INFO: u32 = 2;
pub const AMDGPU_INFO_HW_IP_COUNT: u32 = 3;
pub const AMDGPU_INFO_TIMESTAMP: u32 = 5;
pub const AMDGPU_INFO_FW_VERSION: u32 = 14;
pub const AMDGPU_INFO_FW_VCE: u32 = 1;
pub const AMDGPU_INFO_FW_UVD: u32 = 2;
pub const AMDGPU_INFO_FW_GMC: u32 = 3;
pub const AMDGPU_INFO_FW_GFX_ME: u32 = 4;
pub const AMDGPU_INFO_FW_GFX_PFP: u32 = 5;
pub const AMDGPU_INFO_FW_GFX_CE: u32 = 6;
pub const AMDGPU_INFO_FW_GFX_RLC: u32 = 7;
pub const AMDGPU_INFO_FW_GFX_MEC: u32 = 8;
pub const AMDGPU_INFO_FW_SMC: u32 = 10;
pub const AMDGPU_INFO_FW_SDMA: u32 = 11;
pub const AMDGPU_INFO_FW_SOS: u32 = 12;
pub const AMDGPU_INFO_FW_ASD: u32 = 13;
pub const AMDGPU_INFO_FW_VCN: u32 = 14;
pub const AMDGPU_INFO_FW_GFX_RLC_RESTORE_LIST_CNTL: u32 = 15;
pub const AMDGPU_INFO_FW_GFX_RLC_RESTORE_LIST_GPM_MEM: u32 = 16;
pub const AMDGPU_INFO_FW_GFX_RLC_RESTORE_LIST_SRM_MEM: u32 = 17;
pub const AMDGPU_INFO_FW_DMCU: u32 = 18;
pub const AMDGPU_INFO_FW_TA: u32 = 19;
pub const AMDGPU_INFO_FW_DMCUB: u32 = 20;
pub const AMDGPU_INFO_FW_TOC: u32 = 21;
pub const AMDGPU_INFO_FW_CAP: u32 = 22;
pub const AMDGPU_INFO_FW_GFX_RLCP: u32 = 23;
pub const AMDGPU_INFO_FW_GFX_RLCV: u32 = 24;
pub const AMDGPU_INFO_FW_MES_KIQ: u32 = 25;
pub const AMDGPU_INFO_FW_MES: u32 = 26;
pub const AMDGPU_INFO_FW_IMU: u32 = 27;
pub const AMDGPU_INFO_FW_VPE: u32 = 28;
pub const AMDGPU_INFO_NUM_BYTES_MOVED: u32 = 15;
pub const AMDGPU_INFO_VRAM_USAGE: u32 = 16;
pub const AMDGPU_INFO_GTT_USAGE: u32 = 17;
pub const AMDGPU_INFO_GDS_CONFIG: u32 = 19;
pub const AMDGPU_INFO_VRAM_GTT: u32 = 20;
pub const AMDGPU_INFO_READ_MMR_REG: u32 = 21;
pub const AMDGPU_INFO_DEV_INFO: u32 = 22;
pub const AMDGPU_INFO_VIS_VRAM_USAGE: u32 = 23;
pub const AMDGPU_INFO_NUM_EVICTIONS: u32 = 24;
pub const AMDGPU_INFO_MEMORY: u32 = 25;
pub const AMDGPU_INFO_VCE_CLOCK_TABLE: u32 = 26;
pub const AMDGPU_INFO_VBIOS: u32 = 27;
pub const AMDGPU_INFO_VBIOS_SIZE: u32 = 1;
pub const AMDGPU_INFO_VBIOS_IMAGE: u32 = 2;
pub const AMDGPU_INFO_VBIOS_INFO: u32 = 3;
pub const AMDGPU_INFO_NUM_HANDLES: u32 = 28;
pub const AMDGPU_INFO_SENSOR: u32 = 29;
pub const AMDGPU_INFO_SENSOR_GFX_SCLK: u32 = 1;
pub const AMDGPU_INFO_SENSOR_GFX_MCLK: u32 = 2;
pub const AMDGPU_INFO_SENSOR_GPU_TEMP: u32 = 3;
pub const AMDGPU_INFO_SENSOR_GPU_LOAD: u32 = 4;
pub const AMDGPU_INFO_SENSOR_GPU_AVG_POWER: u32 = 5;
pub const AMDGPU_INFO_SENSOR_VDDNB: u32 = 6;
pub const AMDGPU_INFO_SENSOR_VDDGFX: u32 = 7;
pub const AMDGPU_INFO_SENSOR_STABLE_PSTATE_GFX_SCLK: u32 = 8;
pub const AMDGPU_INFO_SENSOR_STABLE_PSTATE_GFX_MCLK: u32 = 9;
pub const AMDGPU_INFO_SENSOR_PEAK_PSTATE_GFX_SCLK: u32 = 10;
pub const AMDGPU_INFO_SENSOR_PEAK_PSTATE_GFX_MCLK: u32 = 11;
pub const AMDGPU_INFO_NUM_VRAM_CPU_PAGE_FAULTS: u32 = 30;
pub const AMDGPU_INFO_VRAM_LOST_COUNTER: u32 = 31;
pub const AMDGPU_INFO_RAS_ENABLED_FEATURES: u32 = 32;
pub const AMDGPU_INFO_RAS_ENABLED_UMC: u32 = 1;
pub const AMDGPU_INFO_RAS_ENABLED_SDMA: u32 = 2;
pub const AMDGPU_INFO_RAS_ENABLED_GFX: u32 = 4;
pub const AMDGPU_INFO_RAS_ENABLED_MMHUB: u32 = 8;
pub const AMDGPU_INFO_RAS_ENABLED_ATHUB: u32 = 16;
pub const AMDGPU_INFO_RAS_ENABLED_PCIE: u32 = 32;
pub const AMDGPU_INFO_RAS_ENABLED_HDP: u32 = 64;
pub const AMDGPU_INFO_RAS_ENABLED_XGMI: u32 = 128;
pub const AMDGPU_INFO_RAS_ENABLED_DF: u32 = 256;
pub const AMDGPU_INFO_RAS_ENABLED_SMN: u32 = 512;
pub const AMDGPU_INFO_RAS_ENABLED_SEM: u32 = 1024;
pub const AMDGPU_INFO_RAS_ENABLED_MP0: u32 = 2048;
pub const AMDGPU_INFO_RAS_ENABLED_MP1: u32 = 4096;
pub const AMDGPU_INFO_RAS_ENABLED_FUSE: u32 = 8192;
pub const AMDGPU_INFO_VIDEO_CAPS: u32 = 33;
pub const AMDGPU_INFO_VIDEO_CAPS_DECODE: u32 = 0;
pub const AMDGPU_INFO_VIDEO_CAPS_ENCODE: u32 = 1;
pub const AMDGPU_INFO_MAX_IBS: u32 = 34;
pub const AMDGPU_INFO_GPUVM_FAULT: u32 = 35;
pub const AMDGPU_INFO_MMR_SE_INDEX_SHIFT: u32 = 0;
pub const AMDGPU_INFO_MMR_SE_INDEX_MASK: u32 = 255;
pub const AMDGPU_INFO_MMR_SH_INDEX_SHIFT: u32 = 8;
pub const AMDGPU_INFO_MMR_SH_INDEX_MASK: u32 = 255;
pub const AMDGPU_VRAM_TYPE_UNKNOWN: u32 = 0;
pub const AMDGPU_VRAM_TYPE_GDDR1: u32 = 1;
pub const AMDGPU_VRAM_TYPE_DDR2: u32 = 2;
pub const AMDGPU_VRAM_TYPE_GDDR3: u32 = 3;
pub const AMDGPU_VRAM_TYPE_GDDR4: u32 = 4;
pub const AMDGPU_VRAM_TYPE_GDDR5: u32 = 5;
pub const AMDGPU_VRAM_TYPE_HBM: u32 = 6;
pub const AMDGPU_VRAM_TYPE_DDR3: u32 = 7;
pub const AMDGPU_VRAM_TYPE_DDR4: u32 = 8;
pub const AMDGPU_VRAM_TYPE_GDDR6: u32 = 9;
pub const AMDGPU_VRAM_TYPE_DDR5: u32 = 10;
pub const AMDGPU_VRAM_TYPE_LPDDR4: u32 = 11;
pub const AMDGPU_VRAM_TYPE_LPDDR5: u32 = 12;
pub const AMDGPU_VCE_CLOCK_TABLE_ENTRIES: u32 = 6;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_MPEG2: u32 = 0;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_MPEG4: u32 = 1;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_VC1: u32 = 2;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_MPEG4_AVC: u32 = 3;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_HEVC: u32 = 4;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_JPEG: u32 = 5;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_VP9: u32 = 6;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_AV1: u32 = 7;
pub const AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_COUNT: u32 = 8;
pub const AMDGPU_VMHUB_TYPE_MASK: u32 = 255;
pub const AMDGPU_VMHUB_TYPE_SHIFT: u32 = 0;
pub const AMDGPU_VMHUB_TYPE_GFX: u32 = 0;
pub const AMDGPU_VMHUB_TYPE_MM0: u32 = 1;
pub const AMDGPU_VMHUB_TYPE_MM1: u32 = 2;
pub const AMDGPU_VMHUB_IDX_MASK: u32 = 65280;
pub const AMDGPU_VMHUB_IDX_SHIFT: u32 = 8;
pub const AMDGPU_FAMILY_UNKNOWN: u32 = 0;
pub const AMDGPU_FAMILY_SI: u32 = 110;
pub const AMDGPU_FAMILY_CI: u32 = 120;
pub const AMDGPU_FAMILY_KV: u32 = 125;
pub const AMDGPU_FAMILY_VI: u32 = 130;
pub const AMDGPU_FAMILY_CZ: u32 = 135;
pub const AMDGPU_FAMILY_AI: u32 = 141;
pub const AMDGPU_FAMILY_RV: u32 = 142;
pub const AMDGPU_FAMILY_NV: u32 = 143;
pub const AMDGPU_FAMILY_VGH: u32 = 144;
pub const AMDGPU_FAMILY_GC_11_0_0: u32 = 145;
pub const AMDGPU_FAMILY_YC: u32 = 146;
pub const AMDGPU_FAMILY_GC_11_0_1: u32 = 148;
pub const AMDGPU_FAMILY_GC_10_3_6: u32 = 149;
pub const AMDGPU_FAMILY_GC_10_3_7: u32 = 151;
pub const AMDGPU_FAMILY_GC_11_5_0: u32 = 150;
pub const BIOS_ATOM_PREFIX: &[u8; 9] = b"ATOMBIOS\0";
pub const BIOS_VERSION_PREFIX: &[u8; 15] = b"ATOMBIOSBK-AMD\0";
pub const BIOS_STRING_LENGTH: u32 = 43;
pub const NUM_HBM_INSTANCES: u32 = 4;
pub const NUM_XGMI_LINKS: u32 = 8;
pub const MAX_GFX_CLKS: u32 = 8;
pub const MAX_CLKS: u32 = 4;
pub const NUM_VCN: u32 = 4;
pub const NUM_JPEG_ENG: u32 = 32;
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
pub type __u_char = ::core::ffi::c_uchar;
pub type __u_short = ::core::ffi::c_ushort;
pub type __u_int = ::core::ffi::c_uint;
pub type __u_long = ::core::ffi::c_ulong;
pub type __int8_t = ::core::ffi::c_schar;
pub type __uint8_t = ::core::ffi::c_uchar;
pub type __int16_t = ::core::ffi::c_short;
pub type __uint16_t = ::core::ffi::c_ushort;
pub type __int32_t = ::core::ffi::c_int;
pub type __uint32_t = ::core::ffi::c_uint;
pub type __int64_t = ::core::ffi::c_long;
pub type __uint64_t = ::core::ffi::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::core::ffi::c_long;
pub type __u_quad_t = ::core::ffi::c_ulong;
pub type __intmax_t = ::core::ffi::c_long;
pub type __uintmax_t = ::core::ffi::c_ulong;
pub type __dev_t = ::core::ffi::c_ulong;
pub type __uid_t = ::core::ffi::c_uint;
pub type __gid_t = ::core::ffi::c_uint;
pub type __ino_t = ::core::ffi::c_ulong;
pub type __ino64_t = ::core::ffi::c_ulong;
pub type __mode_t = ::core::ffi::c_uint;
pub type __nlink_t = ::core::ffi::c_ulong;
pub type __off_t = ::core::ffi::c_long;
pub type __off64_t = ::core::ffi::c_long;
pub type __pid_t = ::core::ffi::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::core::ffi::c_int; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __fsid_t"][::core::mem::size_of::<__fsid_t>() - 8usize];
    ["Alignment of __fsid_t"][::core::mem::align_of::<__fsid_t>() - 4usize];
    ["Offset of field: __fsid_t::__val"][::core::mem::offset_of!(__fsid_t, __val) - 0usize];
};
pub type __clock_t = ::core::ffi::c_long;
pub type __rlim_t = ::core::ffi::c_ulong;
pub type __rlim64_t = ::core::ffi::c_ulong;
pub type __id_t = ::core::ffi::c_uint;
pub type __time_t = ::core::ffi::c_long;
pub type __useconds_t = ::core::ffi::c_uint;
pub type __suseconds_t = ::core::ffi::c_long;
pub type __suseconds64_t = ::core::ffi::c_long;
pub type __daddr_t = ::core::ffi::c_int;
pub type __key_t = ::core::ffi::c_int;
pub type __clockid_t = ::core::ffi::c_int;
pub type __timer_t = *mut ::core::ffi::c_void;
pub type __blksize_t = ::core::ffi::c_long;
pub type __blkcnt_t = ::core::ffi::c_long;
pub type __blkcnt64_t = ::core::ffi::c_long;
pub type __fsblkcnt_t = ::core::ffi::c_ulong;
pub type __fsblkcnt64_t = ::core::ffi::c_ulong;
pub type __fsfilcnt_t = ::core::ffi::c_ulong;
pub type __fsfilcnt64_t = ::core::ffi::c_ulong;
pub type __fsword_t = ::core::ffi::c_long;
pub type __ssize_t = ::core::ffi::c_long;
pub type __syscall_slong_t = ::core::ffi::c_long;
pub type __syscall_ulong_t = ::core::ffi::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::core::ffi::c_char;
pub type __intptr_t = ::core::ffi::c_long;
pub type __socklen_t = ::core::ffi::c_uint;
pub type __sig_atomic_t = ::core::ffi::c_int;
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type off_t = __off_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type clockid_t = __clockid_t;
pub type time_t = __time_t;
pub type timer_t = __timer_t;
pub type ulong = ::core::ffi::c_ulong;
pub type ushort = ::core::ffi::c_ushort;
pub type uint = ::core::ffi::c_uint;
pub type u_int8_t = __uint8_t;
pub type u_int16_t = __uint16_t;
pub type u_int32_t = __uint32_t;
pub type u_int64_t = __uint64_t;
pub type register_t = ::core::ffi::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::core::ffi::c_ulong; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __sigset_t"][::core::mem::size_of::<__sigset_t>() - 128usize];
    ["Alignment of __sigset_t"][::core::mem::align_of::<__sigset_t>() - 8usize];
    ["Offset of field: __sigset_t::__val"][::core::mem::offset_of!(__sigset_t, __val) - 0usize];
};
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of timeval"][::core::mem::size_of::<timeval>() - 16usize];
    ["Alignment of timeval"][::core::mem::align_of::<timeval>() - 8usize];
    ["Offset of field: timeval::tv_sec"][::core::mem::offset_of!(timeval, tv_sec) - 0usize];
    ["Offset of field: timeval::tv_usec"][::core::mem::offset_of!(timeval, tv_usec) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of timespec"][::core::mem::size_of::<timespec>() - 16usize];
    ["Alignment of timespec"][::core::mem::align_of::<timespec>() - 8usize];
    ["Offset of field: timespec::tv_sec"][::core::mem::offset_of!(timespec, tv_sec) - 0usize];
    ["Offset of field: timespec::tv_nsec"][::core::mem::offset_of!(timespec, tv_nsec) - 8usize];
};
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::core::ffi::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of fd_set"][::core::mem::size_of::<fd_set>() - 128usize];
    ["Alignment of fd_set"][::core::mem::align_of::<fd_set>() - 8usize];
    ["Offset of field: fd_set::__fds_bits"][::core::mem::offset_of!(fd_set, __fds_bits) - 0usize];
};
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::core::ffi::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::core::ffi::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::core::ffi::c_int;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __atomic_wide_counter {
    pub __value64: ::core::ffi::c_ulonglong,
    pub __value32: __atomic_wide_counter__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __atomic_wide_counter__bindgen_ty_1 {
    pub __low: ::core::ffi::c_uint,
    pub __high: ::core::ffi::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __atomic_wide_counter__bindgen_ty_1"]
        [::core::mem::size_of::<__atomic_wide_counter__bindgen_ty_1>() - 8usize];
    ["Alignment of __atomic_wide_counter__bindgen_ty_1"]
        [::core::mem::align_of::<__atomic_wide_counter__bindgen_ty_1>() - 4usize];
    ["Offset of field: __atomic_wide_counter__bindgen_ty_1::__low"]
        [::core::mem::offset_of!(__atomic_wide_counter__bindgen_ty_1, __low) - 0usize];
    ["Offset of field: __atomic_wide_counter__bindgen_ty_1::__high"]
        [::core::mem::offset_of!(__atomic_wide_counter__bindgen_ty_1, __high) - 4usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __atomic_wide_counter"][::core::mem::size_of::<__atomic_wide_counter>() - 8usize];
    ["Alignment of __atomic_wide_counter"]
        [::core::mem::align_of::<__atomic_wide_counter>() - 8usize];
    ["Offset of field: __atomic_wide_counter::__value64"]
        [::core::mem::offset_of!(__atomic_wide_counter, __value64) - 0usize];
    ["Offset of field: __atomic_wide_counter::__value32"]
        [::core::mem::offset_of!(__atomic_wide_counter, __value32) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_internal_list"]
        [::core::mem::size_of::<__pthread_internal_list>() - 16usize];
    ["Alignment of __pthread_internal_list"]
        [::core::mem::align_of::<__pthread_internal_list>() - 8usize];
    ["Offset of field: __pthread_internal_list::__prev"]
        [::core::mem::offset_of!(__pthread_internal_list, __prev) - 0usize];
    ["Offset of field: __pthread_internal_list::__next"]
        [::core::mem::offset_of!(__pthread_internal_list, __next) - 8usize];
};
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_slist {
    pub __next: *mut __pthread_internal_slist,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_internal_slist"]
        [::core::mem::size_of::<__pthread_internal_slist>() - 8usize];
    ["Alignment of __pthread_internal_slist"]
        [::core::mem::align_of::<__pthread_internal_slist>() - 8usize];
    ["Offset of field: __pthread_internal_slist::__next"]
        [::core::mem::offset_of!(__pthread_internal_slist, __next) - 0usize];
};
pub type __pthread_slist_t = __pthread_internal_slist;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::core::ffi::c_int,
    pub __count: ::core::ffi::c_uint,
    pub __owner: ::core::ffi::c_int,
    pub __nusers: ::core::ffi::c_uint,
    pub __kind: ::core::ffi::c_int,
    pub __spins: ::core::ffi::c_short,
    pub __elision: ::core::ffi::c_short,
    pub __list: __pthread_list_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_mutex_s"][::core::mem::size_of::<__pthread_mutex_s>() - 40usize];
    ["Alignment of __pthread_mutex_s"][::core::mem::align_of::<__pthread_mutex_s>() - 8usize];
    ["Offset of field: __pthread_mutex_s::__lock"]
        [::core::mem::offset_of!(__pthread_mutex_s, __lock) - 0usize];
    ["Offset of field: __pthread_mutex_s::__count"]
        [::core::mem::offset_of!(__pthread_mutex_s, __count) - 4usize];
    ["Offset of field: __pthread_mutex_s::__owner"]
        [::core::mem::offset_of!(__pthread_mutex_s, __owner) - 8usize];
    ["Offset of field: __pthread_mutex_s::__nusers"]
        [::core::mem::offset_of!(__pthread_mutex_s, __nusers) - 12usize];
    ["Offset of field: __pthread_mutex_s::__kind"]
        [::core::mem::offset_of!(__pthread_mutex_s, __kind) - 16usize];
    ["Offset of field: __pthread_mutex_s::__spins"]
        [::core::mem::offset_of!(__pthread_mutex_s, __spins) - 20usize];
    ["Offset of field: __pthread_mutex_s::__elision"]
        [::core::mem::offset_of!(__pthread_mutex_s, __elision) - 22usize];
    ["Offset of field: __pthread_mutex_s::__list"]
        [::core::mem::offset_of!(__pthread_mutex_s, __list) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::core::ffi::c_uint,
    pub __writers: ::core::ffi::c_uint,
    pub __wrphase_futex: ::core::ffi::c_uint,
    pub __writers_futex: ::core::ffi::c_uint,
    pub __pad3: ::core::ffi::c_uint,
    pub __pad4: ::core::ffi::c_uint,
    pub __cur_writer: ::core::ffi::c_int,
    pub __shared: ::core::ffi::c_int,
    pub __rwelision: ::core::ffi::c_schar,
    pub __pad1: [::core::ffi::c_uchar; 7usize],
    pub __pad2: ::core::ffi::c_ulong,
    pub __flags: ::core::ffi::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_rwlock_arch_t"]
        [::core::mem::size_of::<__pthread_rwlock_arch_t>() - 56usize];
    ["Alignment of __pthread_rwlock_arch_t"]
        [::core::mem::align_of::<__pthread_rwlock_arch_t>() - 8usize];
    ["Offset of field: __pthread_rwlock_arch_t::__readers"]
        [::core::mem::offset_of!(__pthread_rwlock_arch_t, __readers) - 0usize];
    ["Offset of field: __pthread_rwlock_arch_t::__writers"]
        [::core::mem::offset_of!(__pthread_rwlock_arch_t, __writers) - 4usize];
    ["Offset of field: __pthread_rwlock_arch_t::__wrphase_futex"]
        [::core::mem::offset_of!(__pthread_rwlock_arch_t, __wrphase_futex) - 8usize];
    ["Offset of field: __pthread_rwlock_arch_t::__writers_futex"]
        [::core::mem::offset_of!(__pthread_rwlock_arch_t, __writers_futex) - 12usize];
    ["Offset of field: __pthread_rwlock_arch_t::__pad3"]
        [::core::mem::offset_of!(__pthread_rwlock_arch_t, __pad3) - 16usize];
    ["Offset of field: __pthread_rwlock_arch_t::__pad4"]
        [::core::mem::offset_of!(__pthread_rwlock_arch_t, __pad4) - 20usize];
    ["Offset of field: __pthread_rwlock_arch_t::__cur_writer"]
        [::core::mem::offset_of!(__pthread_rwlock_arch_t, __cur_writer) - 24usize];
    ["Offset of field: __pthread_rwlock_arch_t::__shared"]
        [::core::mem::offset_of!(__pthread_rwlock_arch_t, __shared) - 28usize];
    ["Offset of field: __pthread_rwlock_arch_t::__rwelision"]
        [::core::mem::offset_of!(__pthread_rwlock_arch_t, __rwelision) - 32usize];
    ["Offset of field: __pthread_rwlock_arch_t::__pad1"]
        [::core::mem::offset_of!(__pthread_rwlock_arch_t, __pad1) - 33usize];
    ["Offset of field: __pthread_rwlock_arch_t::__pad2"]
        [::core::mem::offset_of!(__pthread_rwlock_arch_t, __pad2) - 40usize];
    ["Offset of field: __pthread_rwlock_arch_t::__flags"]
        [::core::mem::offset_of!(__pthread_rwlock_arch_t, __flags) - 48usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __wseq: __atomic_wide_counter,
    pub __g1_start: __atomic_wide_counter,
    pub __g_refs: [::core::ffi::c_uint; 2usize],
    pub __g_size: [::core::ffi::c_uint; 2usize],
    pub __g1_orig_size: ::core::ffi::c_uint,
    pub __wrefs: ::core::ffi::c_uint,
    pub __g_signals: [::core::ffi::c_uint; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __pthread_cond_s"][::core::mem::size_of::<__pthread_cond_s>() - 48usize];
    ["Alignment of __pthread_cond_s"][::core::mem::align_of::<__pthread_cond_s>() - 8usize];
    ["Offset of field: __pthread_cond_s::__wseq"]
        [::core::mem::offset_of!(__pthread_cond_s, __wseq) - 0usize];
    ["Offset of field: __pthread_cond_s::__g1_start"]
        [::core::mem::offset_of!(__pthread_cond_s, __g1_start) - 8usize];
    ["Offset of field: __pthread_cond_s::__g_refs"]
        [::core::mem::offset_of!(__pthread_cond_s, __g_refs) - 16usize];
    ["Offset of field: __pthread_cond_s::__g_size"]
        [::core::mem::offset_of!(__pthread_cond_s, __g_size) - 24usize];
    ["Offset of field: __pthread_cond_s::__g1_orig_size"]
        [::core::mem::offset_of!(__pthread_cond_s, __g1_orig_size) - 32usize];
    ["Offset of field: __pthread_cond_s::__wrefs"]
        [::core::mem::offset_of!(__pthread_cond_s, __wrefs) - 36usize];
    ["Offset of field: __pthread_cond_s::__g_signals"]
        [::core::mem::offset_of!(__pthread_cond_s, __g_signals) - 40usize];
};
pub type __tss_t = ::core::ffi::c_uint;
pub type __thrd_t = ::core::ffi::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __once_flag {
    pub __data: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __once_flag"][::core::mem::size_of::<__once_flag>() - 4usize];
    ["Alignment of __once_flag"][::core::mem::align_of::<__once_flag>() - 4usize];
    ["Offset of field: __once_flag::__data"][::core::mem::offset_of!(__once_flag, __data) - 0usize];
};
pub type pthread_t = ::core::ffi::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::core::ffi::c_char; 4usize],
    pub __align: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of pthread_mutexattr_t"][::core::mem::size_of::<pthread_mutexattr_t>() - 4usize];
    ["Alignment of pthread_mutexattr_t"][::core::mem::align_of::<pthread_mutexattr_t>() - 4usize];
    ["Offset of field: pthread_mutexattr_t::__size"]
        [::core::mem::offset_of!(pthread_mutexattr_t, __size) - 0usize];
    ["Offset of field: pthread_mutexattr_t::__align"]
        [::core::mem::offset_of!(pthread_mutexattr_t, __align) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::core::ffi::c_char; 4usize],
    pub __align: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of pthread_condattr_t"][::core::mem::size_of::<pthread_condattr_t>() - 4usize];
    ["Alignment of pthread_condattr_t"][::core::mem::align_of::<pthread_condattr_t>() - 4usize];
    ["Offset of field: pthread_condattr_t::__size"]
        [::core::mem::offset_of!(pthread_condattr_t, __size) - 0usize];
    ["Offset of field: pthread_condattr_t::__align"]
        [::core::mem::offset_of!(pthread_condattr_t, __align) - 0usize];
};
pub type pthread_key_t = ::core::ffi::c_uint;
pub type pthread_once_t = ::core::ffi::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::core::ffi::c_char; 56usize],
    pub __align: ::core::ffi::c_long,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of pthread_attr_t"][::core::mem::size_of::<pthread_attr_t>() - 56usize];
    ["Alignment of pthread_attr_t"][::core::mem::align_of::<pthread_attr_t>() - 8usize];
    ["Offset of field: pthread_attr_t::__size"]
        [::core::mem::offset_of!(pthread_attr_t, __size) - 0usize];
    ["Offset of field: pthread_attr_t::__align"]
        [::core::mem::offset_of!(pthread_attr_t, __align) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::core::ffi::c_char; 40usize],
    pub __align: ::core::ffi::c_long,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of pthread_mutex_t"][::core::mem::size_of::<pthread_mutex_t>() - 40usize];
    ["Alignment of pthread_mutex_t"][::core::mem::align_of::<pthread_mutex_t>() - 8usize];
    ["Offset of field: pthread_mutex_t::__data"]
        [::core::mem::offset_of!(pthread_mutex_t, __data) - 0usize];
    ["Offset of field: pthread_mutex_t::__size"]
        [::core::mem::offset_of!(pthread_mutex_t, __size) - 0usize];
    ["Offset of field: pthread_mutex_t::__align"]
        [::core::mem::offset_of!(pthread_mutex_t, __align) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::core::ffi::c_char; 48usize],
    pub __align: ::core::ffi::c_longlong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of pthread_cond_t"][::core::mem::size_of::<pthread_cond_t>() - 48usize];
    ["Alignment of pthread_cond_t"][::core::mem::align_of::<pthread_cond_t>() - 8usize];
    ["Offset of field: pthread_cond_t::__data"]
        [::core::mem::offset_of!(pthread_cond_t, __data) - 0usize];
    ["Offset of field: pthread_cond_t::__size"]
        [::core::mem::offset_of!(pthread_cond_t, __size) - 0usize];
    ["Offset of field: pthread_cond_t::__align"]
        [::core::mem::offset_of!(pthread_cond_t, __align) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::core::ffi::c_char; 56usize],
    pub __align: ::core::ffi::c_long,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of pthread_rwlock_t"][::core::mem::size_of::<pthread_rwlock_t>() - 56usize];
    ["Alignment of pthread_rwlock_t"][::core::mem::align_of::<pthread_rwlock_t>() - 8usize];
    ["Offset of field: pthread_rwlock_t::__data"]
        [::core::mem::offset_of!(pthread_rwlock_t, __data) - 0usize];
    ["Offset of field: pthread_rwlock_t::__size"]
        [::core::mem::offset_of!(pthread_rwlock_t, __size) - 0usize];
    ["Offset of field: pthread_rwlock_t::__align"]
        [::core::mem::offset_of!(pthread_rwlock_t, __align) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::core::ffi::c_char; 8usize],
    pub __align: ::core::ffi::c_long,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of pthread_rwlockattr_t"][::core::mem::size_of::<pthread_rwlockattr_t>() - 8usize];
    ["Alignment of pthread_rwlockattr_t"][::core::mem::align_of::<pthread_rwlockattr_t>() - 8usize];
    ["Offset of field: pthread_rwlockattr_t::__size"]
        [::core::mem::offset_of!(pthread_rwlockattr_t, __size) - 0usize];
    ["Offset of field: pthread_rwlockattr_t::__align"]
        [::core::mem::offset_of!(pthread_rwlockattr_t, __align) - 0usize];
};
pub type pthread_spinlock_t = ::core::ffi::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::core::ffi::c_char; 32usize],
    pub __align: ::core::ffi::c_long,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of pthread_barrier_t"][::core::mem::size_of::<pthread_barrier_t>() - 32usize];
    ["Alignment of pthread_barrier_t"][::core::mem::align_of::<pthread_barrier_t>() - 8usize];
    ["Offset of field: pthread_barrier_t::__size"]
        [::core::mem::offset_of!(pthread_barrier_t, __size) - 0usize];
    ["Offset of field: pthread_barrier_t::__align"]
        [::core::mem::offset_of!(pthread_barrier_t, __align) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::core::ffi::c_char; 4usize],
    pub __align: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of pthread_barrierattr_t"][::core::mem::size_of::<pthread_barrierattr_t>() - 4usize];
    ["Alignment of pthread_barrierattr_t"]
        [::core::mem::align_of::<pthread_barrierattr_t>() - 4usize];
    ["Offset of field: pthread_barrierattr_t::__size"]
        [::core::mem::offset_of!(pthread_barrierattr_t, __size) - 0usize];
    ["Offset of field: pthread_barrierattr_t::__align"]
        [::core::mem::offset_of!(pthread_barrierattr_t, __align) - 0usize];
};
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::core::ffi::c_schar;
pub type int_fast16_t = ::core::ffi::c_long;
pub type int_fast32_t = ::core::ffi::c_long;
pub type int_fast64_t = ::core::ffi::c_long;
pub type uint_fast8_t = ::core::ffi::c_uchar;
pub type uint_fast16_t = ::core::ffi::c_ulong;
pub type uint_fast32_t = ::core::ffi::c_ulong;
pub type uint_fast64_t = ::core::ffi::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
pub type __s8 = ::core::ffi::c_schar;
pub type __u8 = ::core::ffi::c_uchar;
pub type __s16 = ::core::ffi::c_short;
pub type __u16 = ::core::ffi::c_ushort;
pub type __s32 = ::core::ffi::c_int;
pub type __u32 = ::core::ffi::c_uint;
pub type __s64 = ::core::ffi::c_longlong;
pub type __u64 = ::core::ffi::c_ulonglong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_fd_set {
    pub fds_bits: [::core::ffi::c_ulong; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __kernel_fd_set"][::core::mem::size_of::<__kernel_fd_set>() - 128usize];
    ["Alignment of __kernel_fd_set"][::core::mem::align_of::<__kernel_fd_set>() - 8usize];
    ["Offset of field: __kernel_fd_set::fds_bits"]
        [::core::mem::offset_of!(__kernel_fd_set, fds_bits) - 0usize];
};
pub type __kernel_sighandler_t =
    ::core::option::Option<unsafe extern "C" fn(arg1: ::core::ffi::c_int)>;
pub type __kernel_key_t = ::core::ffi::c_int;
pub type __kernel_mqd_t = ::core::ffi::c_int;
pub type __kernel_old_uid_t = ::core::ffi::c_ushort;
pub type __kernel_old_gid_t = ::core::ffi::c_ushort;
pub type __kernel_old_dev_t = ::core::ffi::c_ulong;
pub type __kernel_long_t = ::core::ffi::c_long;
pub type __kernel_ulong_t = ::core::ffi::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = ::core::ffi::c_uint;
pub type __kernel_pid_t = ::core::ffi::c_int;
pub type __kernel_ipc_pid_t = ::core::ffi::c_int;
pub type __kernel_uid_t = ::core::ffi::c_uint;
pub type __kernel_gid_t = ::core::ffi::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::core::ffi::c_int;
pub type __kernel_uid32_t = ::core::ffi::c_uint;
pub type __kernel_gid32_t = ::core::ffi::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __kernel_fsid_t {
    pub val: [::core::ffi::c_int; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __kernel_fsid_t"][::core::mem::size_of::<__kernel_fsid_t>() - 8usize];
    ["Alignment of __kernel_fsid_t"][::core::mem::align_of::<__kernel_fsid_t>() - 4usize];
    ["Offset of field: __kernel_fsid_t::val"]
        [::core::mem::offset_of!(__kernel_fsid_t, val) - 0usize];
};
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::core::ffi::c_longlong;
pub type __kernel_old_time_t = __kernel_long_t;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_time64_t = ::core::ffi::c_longlong;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::core::ffi::c_int;
pub type __kernel_clockid_t = ::core::ffi::c_int;
pub type __kernel_caddr_t = *mut ::core::ffi::c_char;
pub type __kernel_uid16_t = ::core::ffi::c_ushort;
pub type __kernel_gid16_t = ::core::ffi::c_ushort;
pub type __s128 = i128;
pub type __u128 = u128;
pub type __le16 = __u16;
pub type __be16 = __u16;
pub type __le32 = __u32;
pub type __be32 = __u32;
pub type __le64 = __u64;
pub type __be64 = __u64;
pub type __sum16 = __u16;
pub type __wsum = __u32;
pub type __poll_t = ::core::ffi::c_uint;
pub type drm_handle_t = ::core::ffi::c_uint;
pub type drm_context_t = ::core::ffi::c_uint;
pub type drm_drawable_t = ::core::ffi::c_uint;
pub type drm_magic_t = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_clip_rect {
    pub x1: ::core::ffi::c_ushort,
    pub y1: ::core::ffi::c_ushort,
    pub x2: ::core::ffi::c_ushort,
    pub y2: ::core::ffi::c_ushort,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_clip_rect"][::core::mem::size_of::<drm_clip_rect>() - 8usize];
    ["Alignment of drm_clip_rect"][::core::mem::align_of::<drm_clip_rect>() - 2usize];
    ["Offset of field: drm_clip_rect::x1"][::core::mem::offset_of!(drm_clip_rect, x1) - 0usize];
    ["Offset of field: drm_clip_rect::y1"][::core::mem::offset_of!(drm_clip_rect, y1) - 2usize];
    ["Offset of field: drm_clip_rect::x2"][::core::mem::offset_of!(drm_clip_rect, x2) - 4usize];
    ["Offset of field: drm_clip_rect::y2"][::core::mem::offset_of!(drm_clip_rect, y2) - 6usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_drawable_info {
    pub num_rects: ::core::ffi::c_uint,
    pub rects: *mut drm_clip_rect,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_drawable_info"][::core::mem::size_of::<drm_drawable_info>() - 16usize];
    ["Alignment of drm_drawable_info"][::core::mem::align_of::<drm_drawable_info>() - 8usize];
    ["Offset of field: drm_drawable_info::num_rects"]
        [::core::mem::offset_of!(drm_drawable_info, num_rects) - 0usize];
    ["Offset of field: drm_drawable_info::rects"]
        [::core::mem::offset_of!(drm_drawable_info, rects) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_tex_region {
    pub next: ::core::ffi::c_uchar,
    pub prev: ::core::ffi::c_uchar,
    pub in_use: ::core::ffi::c_uchar,
    pub padding: ::core::ffi::c_uchar,
    pub age: ::core::ffi::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_tex_region"][::core::mem::size_of::<drm_tex_region>() - 8usize];
    ["Alignment of drm_tex_region"][::core::mem::align_of::<drm_tex_region>() - 4usize];
    ["Offset of field: drm_tex_region::next"]
        [::core::mem::offset_of!(drm_tex_region, next) - 0usize];
    ["Offset of field: drm_tex_region::prev"]
        [::core::mem::offset_of!(drm_tex_region, prev) - 1usize];
    ["Offset of field: drm_tex_region::in_use"]
        [::core::mem::offset_of!(drm_tex_region, in_use) - 2usize];
    ["Offset of field: drm_tex_region::padding"]
        [::core::mem::offset_of!(drm_tex_region, padding) - 3usize];
    ["Offset of field: drm_tex_region::age"][::core::mem::offset_of!(drm_tex_region, age) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_hw_lock {
    pub lock: ::core::ffi::c_uint,
    pub padding: [::core::ffi::c_char; 60usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_hw_lock"][::core::mem::size_of::<drm_hw_lock>() - 64usize];
    ["Alignment of drm_hw_lock"][::core::mem::align_of::<drm_hw_lock>() - 4usize];
    ["Offset of field: drm_hw_lock::lock"][::core::mem::offset_of!(drm_hw_lock, lock) - 0usize];
    ["Offset of field: drm_hw_lock::padding"]
        [::core::mem::offset_of!(drm_hw_lock, padding) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_version {
    pub version_major: ::core::ffi::c_int,
    pub version_minor: ::core::ffi::c_int,
    pub version_patchlevel: ::core::ffi::c_int,
    pub name_len: __kernel_size_t,
    pub name: *mut ::core::ffi::c_char,
    pub date_len: __kernel_size_t,
    pub date: *mut ::core::ffi::c_char,
    pub desc_len: __kernel_size_t,
    pub desc: *mut ::core::ffi::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_version"][::core::mem::size_of::<drm_version>() - 64usize];
    ["Alignment of drm_version"][::core::mem::align_of::<drm_version>() - 8usize];
    ["Offset of field: drm_version::version_major"]
        [::core::mem::offset_of!(drm_version, version_major) - 0usize];
    ["Offset of field: drm_version::version_minor"]
        [::core::mem::offset_of!(drm_version, version_minor) - 4usize];
    ["Offset of field: drm_version::version_patchlevel"]
        [::core::mem::offset_of!(drm_version, version_patchlevel) - 8usize];
    ["Offset of field: drm_version::name_len"]
        [::core::mem::offset_of!(drm_version, name_len) - 16usize];
    ["Offset of field: drm_version::name"][::core::mem::offset_of!(drm_version, name) - 24usize];
    ["Offset of field: drm_version::date_len"]
        [::core::mem::offset_of!(drm_version, date_len) - 32usize];
    ["Offset of field: drm_version::date"][::core::mem::offset_of!(drm_version, date) - 40usize];
    ["Offset of field: drm_version::desc_len"]
        [::core::mem::offset_of!(drm_version, desc_len) - 48usize];
    ["Offset of field: drm_version::desc"][::core::mem::offset_of!(drm_version, desc) - 56usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_unique {
    pub unique_len: __kernel_size_t,
    pub unique: *mut ::core::ffi::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_unique"][::core::mem::size_of::<drm_unique>() - 16usize];
    ["Alignment of drm_unique"][::core::mem::align_of::<drm_unique>() - 8usize];
    ["Offset of field: drm_unique::unique_len"]
        [::core::mem::offset_of!(drm_unique, unique_len) - 0usize];
    ["Offset of field: drm_unique::unique"][::core::mem::offset_of!(drm_unique, unique) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_list {
    pub count: ::core::ffi::c_int,
    pub version: *mut drm_version,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_list"][::core::mem::size_of::<drm_list>() - 16usize];
    ["Alignment of drm_list"][::core::mem::align_of::<drm_list>() - 8usize];
    ["Offset of field: drm_list::count"][::core::mem::offset_of!(drm_list, count) - 0usize];
    ["Offset of field: drm_list::version"][::core::mem::offset_of!(drm_list, version) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_block {
    pub unused: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_block"][::core::mem::size_of::<drm_block>() - 4usize];
    ["Alignment of drm_block"][::core::mem::align_of::<drm_block>() - 4usize];
    ["Offset of field: drm_block::unused"][::core::mem::offset_of!(drm_block, unused) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_control {
    pub func: drm_control__bindgen_ty_1,
    pub irq: ::core::ffi::c_int,
}
pub const drm_control_DRM_ADD_COMMAND: drm_control__bindgen_ty_1 = 0;
pub const drm_control_DRM_RM_COMMAND: drm_control__bindgen_ty_1 = 1;
pub const drm_control_DRM_INST_HANDLER: drm_control__bindgen_ty_1 = 2;
pub const drm_control_DRM_UNINST_HANDLER: drm_control__bindgen_ty_1 = 3;
pub type drm_control__bindgen_ty_1 = ::core::ffi::c_uint;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_control"][::core::mem::size_of::<drm_control>() - 8usize];
    ["Alignment of drm_control"][::core::mem::align_of::<drm_control>() - 4usize];
    ["Offset of field: drm_control::func"][::core::mem::offset_of!(drm_control, func) - 0usize];
    ["Offset of field: drm_control::irq"][::core::mem::offset_of!(drm_control, irq) - 4usize];
};
pub const drm_map_type__DRM_FRAME_BUFFER: drm_map_type = 0;
pub const drm_map_type__DRM_REGISTERS: drm_map_type = 1;
pub const drm_map_type__DRM_SHM: drm_map_type = 2;
pub const drm_map_type__DRM_AGP: drm_map_type = 3;
pub const drm_map_type__DRM_SCATTER_GATHER: drm_map_type = 4;
pub const drm_map_type__DRM_CONSISTENT: drm_map_type = 5;
pub type drm_map_type = ::core::ffi::c_uint;
pub const drm_map_flags__DRM_RESTRICTED: drm_map_flags = 1;
pub const drm_map_flags__DRM_READ_ONLY: drm_map_flags = 2;
pub const drm_map_flags__DRM_LOCKED: drm_map_flags = 4;
pub const drm_map_flags__DRM_KERNEL: drm_map_flags = 8;
pub const drm_map_flags__DRM_WRITE_COMBINING: drm_map_flags = 16;
pub const drm_map_flags__DRM_CONTAINS_LOCK: drm_map_flags = 32;
pub const drm_map_flags__DRM_REMOVABLE: drm_map_flags = 64;
pub const drm_map_flags__DRM_DRIVER: drm_map_flags = 128;
pub type drm_map_flags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_ctx_priv_map {
    pub ctx_id: ::core::ffi::c_uint,
    pub handle: *mut ::core::ffi::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_ctx_priv_map"][::core::mem::size_of::<drm_ctx_priv_map>() - 16usize];
    ["Alignment of drm_ctx_priv_map"][::core::mem::align_of::<drm_ctx_priv_map>() - 8usize];
    ["Offset of field: drm_ctx_priv_map::ctx_id"]
        [::core::mem::offset_of!(drm_ctx_priv_map, ctx_id) - 0usize];
    ["Offset of field: drm_ctx_priv_map::handle"]
        [::core::mem::offset_of!(drm_ctx_priv_map, handle) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_map {
    pub offset: ::core::ffi::c_ulong,
    pub size: ::core::ffi::c_ulong,
    pub type_: drm_map_type,
    pub flags: drm_map_flags,
    pub handle: *mut ::core::ffi::c_void,
    pub mtrr: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_map"][::core::mem::size_of::<drm_map>() - 40usize];
    ["Alignment of drm_map"][::core::mem::align_of::<drm_map>() - 8usize];
    ["Offset of field: drm_map::offset"][::core::mem::offset_of!(drm_map, offset) - 0usize];
    ["Offset of field: drm_map::size"][::core::mem::offset_of!(drm_map, size) - 8usize];
    ["Offset of field: drm_map::type_"][::core::mem::offset_of!(drm_map, type_) - 16usize];
    ["Offset of field: drm_map::flags"][::core::mem::offset_of!(drm_map, flags) - 20usize];
    ["Offset of field: drm_map::handle"][::core::mem::offset_of!(drm_map, handle) - 24usize];
    ["Offset of field: drm_map::mtrr"][::core::mem::offset_of!(drm_map, mtrr) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_client {
    pub idx: ::core::ffi::c_int,
    pub auth: ::core::ffi::c_int,
    pub pid: ::core::ffi::c_ulong,
    pub uid: ::core::ffi::c_ulong,
    pub magic: ::core::ffi::c_ulong,
    pub iocs: ::core::ffi::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_client"][::core::mem::size_of::<drm_client>() - 40usize];
    ["Alignment of drm_client"][::core::mem::align_of::<drm_client>() - 8usize];
    ["Offset of field: drm_client::idx"][::core::mem::offset_of!(drm_client, idx) - 0usize];
    ["Offset of field: drm_client::auth"][::core::mem::offset_of!(drm_client, auth) - 4usize];
    ["Offset of field: drm_client::pid"][::core::mem::offset_of!(drm_client, pid) - 8usize];
    ["Offset of field: drm_client::uid"][::core::mem::offset_of!(drm_client, uid) - 16usize];
    ["Offset of field: drm_client::magic"][::core::mem::offset_of!(drm_client, magic) - 24usize];
    ["Offset of field: drm_client::iocs"][::core::mem::offset_of!(drm_client, iocs) - 32usize];
};
pub const drm_stat_type__DRM_STAT_LOCK: drm_stat_type = 0;
pub const drm_stat_type__DRM_STAT_OPENS: drm_stat_type = 1;
pub const drm_stat_type__DRM_STAT_CLOSES: drm_stat_type = 2;
pub const drm_stat_type__DRM_STAT_IOCTLS: drm_stat_type = 3;
pub const drm_stat_type__DRM_STAT_LOCKS: drm_stat_type = 4;
pub const drm_stat_type__DRM_STAT_UNLOCKS: drm_stat_type = 5;
pub const drm_stat_type__DRM_STAT_VALUE: drm_stat_type = 6;
pub const drm_stat_type__DRM_STAT_BYTE: drm_stat_type = 7;
pub const drm_stat_type__DRM_STAT_COUNT: drm_stat_type = 8;
pub const drm_stat_type__DRM_STAT_IRQ: drm_stat_type = 9;
pub const drm_stat_type__DRM_STAT_PRIMARY: drm_stat_type = 10;
pub const drm_stat_type__DRM_STAT_SECONDARY: drm_stat_type = 11;
pub const drm_stat_type__DRM_STAT_DMA: drm_stat_type = 12;
pub const drm_stat_type__DRM_STAT_SPECIAL: drm_stat_type = 13;
pub const drm_stat_type__DRM_STAT_MISSED: drm_stat_type = 14;
pub type drm_stat_type = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_stats {
    pub count: ::core::ffi::c_ulong,
    pub data: [drm_stats__bindgen_ty_1; 15usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_stats__bindgen_ty_1 {
    pub value: ::core::ffi::c_ulong,
    pub type_: drm_stat_type,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_stats__bindgen_ty_1"]
        [::core::mem::size_of::<drm_stats__bindgen_ty_1>() - 16usize];
    ["Alignment of drm_stats__bindgen_ty_1"]
        [::core::mem::align_of::<drm_stats__bindgen_ty_1>() - 8usize];
    ["Offset of field: drm_stats__bindgen_ty_1::value"]
        [::core::mem::offset_of!(drm_stats__bindgen_ty_1, value) - 0usize];
    ["Offset of field: drm_stats__bindgen_ty_1::type_"]
        [::core::mem::offset_of!(drm_stats__bindgen_ty_1, type_) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_stats"][::core::mem::size_of::<drm_stats>() - 248usize];
    ["Alignment of drm_stats"][::core::mem::align_of::<drm_stats>() - 8usize];
    ["Offset of field: drm_stats::count"][::core::mem::offset_of!(drm_stats, count) - 0usize];
    ["Offset of field: drm_stats::data"][::core::mem::offset_of!(drm_stats, data) - 8usize];
};
pub const drm_lock_flags__DRM_LOCK_READY: drm_lock_flags = 1;
pub const drm_lock_flags__DRM_LOCK_QUIESCENT: drm_lock_flags = 2;
pub const drm_lock_flags__DRM_LOCK_FLUSH: drm_lock_flags = 4;
pub const drm_lock_flags__DRM_LOCK_FLUSH_ALL: drm_lock_flags = 8;
pub const drm_lock_flags__DRM_HALT_ALL_QUEUES: drm_lock_flags = 16;
pub const drm_lock_flags__DRM_HALT_CUR_QUEUES: drm_lock_flags = 32;
pub type drm_lock_flags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_lock {
    pub context: ::core::ffi::c_int,
    pub flags: drm_lock_flags,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_lock"][::core::mem::size_of::<drm_lock>() - 8usize];
    ["Alignment of drm_lock"][::core::mem::align_of::<drm_lock>() - 4usize];
    ["Offset of field: drm_lock::context"][::core::mem::offset_of!(drm_lock, context) - 0usize];
    ["Offset of field: drm_lock::flags"][::core::mem::offset_of!(drm_lock, flags) - 4usize];
};
pub const drm_dma_flags__DRM_DMA_BLOCK: drm_dma_flags = 1;
pub const drm_dma_flags__DRM_DMA_WHILE_LOCKED: drm_dma_flags = 2;
pub const drm_dma_flags__DRM_DMA_PRIORITY: drm_dma_flags = 4;
pub const drm_dma_flags__DRM_DMA_WAIT: drm_dma_flags = 16;
pub const drm_dma_flags__DRM_DMA_SMALLER_OK: drm_dma_flags = 32;
pub const drm_dma_flags__DRM_DMA_LARGER_OK: drm_dma_flags = 64;
pub type drm_dma_flags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_desc {
    pub count: ::core::ffi::c_int,
    pub size: ::core::ffi::c_int,
    pub low_mark: ::core::ffi::c_int,
    pub high_mark: ::core::ffi::c_int,
    pub flags: drm_buf_desc__bindgen_ty_1,
    pub agp_start: ::core::ffi::c_ulong,
}
pub const drm_buf_desc__DRM_PAGE_ALIGN: drm_buf_desc__bindgen_ty_1 = 1;
pub const drm_buf_desc__DRM_AGP_BUFFER: drm_buf_desc__bindgen_ty_1 = 2;
pub const drm_buf_desc__DRM_SG_BUFFER: drm_buf_desc__bindgen_ty_1 = 4;
pub const drm_buf_desc__DRM_FB_BUFFER: drm_buf_desc__bindgen_ty_1 = 8;
pub const drm_buf_desc__DRM_PCI_BUFFER_RO: drm_buf_desc__bindgen_ty_1 = 16;
pub type drm_buf_desc__bindgen_ty_1 = ::core::ffi::c_uint;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_buf_desc"][::core::mem::size_of::<drm_buf_desc>() - 32usize];
    ["Alignment of drm_buf_desc"][::core::mem::align_of::<drm_buf_desc>() - 8usize];
    ["Offset of field: drm_buf_desc::count"][::core::mem::offset_of!(drm_buf_desc, count) - 0usize];
    ["Offset of field: drm_buf_desc::size"][::core::mem::offset_of!(drm_buf_desc, size) - 4usize];
    ["Offset of field: drm_buf_desc::low_mark"]
        [::core::mem::offset_of!(drm_buf_desc, low_mark) - 8usize];
    ["Offset of field: drm_buf_desc::high_mark"]
        [::core::mem::offset_of!(drm_buf_desc, high_mark) - 12usize];
    ["Offset of field: drm_buf_desc::flags"]
        [::core::mem::offset_of!(drm_buf_desc, flags) - 16usize];
    ["Offset of field: drm_buf_desc::agp_start"]
        [::core::mem::offset_of!(drm_buf_desc, agp_start) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_info {
    pub count: ::core::ffi::c_int,
    pub list: *mut drm_buf_desc,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_buf_info"][::core::mem::size_of::<drm_buf_info>() - 16usize];
    ["Alignment of drm_buf_info"][::core::mem::align_of::<drm_buf_info>() - 8usize];
    ["Offset of field: drm_buf_info::count"][::core::mem::offset_of!(drm_buf_info, count) - 0usize];
    ["Offset of field: drm_buf_info::list"][::core::mem::offset_of!(drm_buf_info, list) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_free {
    pub count: ::core::ffi::c_int,
    pub list: *mut ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_buf_free"][::core::mem::size_of::<drm_buf_free>() - 16usize];
    ["Alignment of drm_buf_free"][::core::mem::align_of::<drm_buf_free>() - 8usize];
    ["Offset of field: drm_buf_free::count"][::core::mem::offset_of!(drm_buf_free, count) - 0usize];
    ["Offset of field: drm_buf_free::list"][::core::mem::offset_of!(drm_buf_free, list) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_pub {
    pub idx: ::core::ffi::c_int,
    pub total: ::core::ffi::c_int,
    pub used: ::core::ffi::c_int,
    pub address: *mut ::core::ffi::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_buf_pub"][::core::mem::size_of::<drm_buf_pub>() - 24usize];
    ["Alignment of drm_buf_pub"][::core::mem::align_of::<drm_buf_pub>() - 8usize];
    ["Offset of field: drm_buf_pub::idx"][::core::mem::offset_of!(drm_buf_pub, idx) - 0usize];
    ["Offset of field: drm_buf_pub::total"][::core::mem::offset_of!(drm_buf_pub, total) - 4usize];
    ["Offset of field: drm_buf_pub::used"][::core::mem::offset_of!(drm_buf_pub, used) - 8usize];
    ["Offset of field: drm_buf_pub::address"]
        [::core::mem::offset_of!(drm_buf_pub, address) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_buf_map {
    pub count: ::core::ffi::c_int,
    pub virtual_: *mut ::core::ffi::c_void,
    pub list: *mut drm_buf_pub,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_buf_map"][::core::mem::size_of::<drm_buf_map>() - 24usize];
    ["Alignment of drm_buf_map"][::core::mem::align_of::<drm_buf_map>() - 8usize];
    ["Offset of field: drm_buf_map::count"][::core::mem::offset_of!(drm_buf_map, count) - 0usize];
    ["Offset of field: drm_buf_map::virtual_"]
        [::core::mem::offset_of!(drm_buf_map, virtual_) - 8usize];
    ["Offset of field: drm_buf_map::list"][::core::mem::offset_of!(drm_buf_map, list) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_dma {
    pub context: ::core::ffi::c_int,
    pub send_count: ::core::ffi::c_int,
    pub send_indices: *mut ::core::ffi::c_int,
    pub send_sizes: *mut ::core::ffi::c_int,
    pub flags: drm_dma_flags,
    pub request_count: ::core::ffi::c_int,
    pub request_size: ::core::ffi::c_int,
    pub request_indices: *mut ::core::ffi::c_int,
    pub request_sizes: *mut ::core::ffi::c_int,
    pub granted_count: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_dma"][::core::mem::size_of::<drm_dma>() - 64usize];
    ["Alignment of drm_dma"][::core::mem::align_of::<drm_dma>() - 8usize];
    ["Offset of field: drm_dma::context"][::core::mem::offset_of!(drm_dma, context) - 0usize];
    ["Offset of field: drm_dma::send_count"][::core::mem::offset_of!(drm_dma, send_count) - 4usize];
    ["Offset of field: drm_dma::send_indices"]
        [::core::mem::offset_of!(drm_dma, send_indices) - 8usize];
    ["Offset of field: drm_dma::send_sizes"]
        [::core::mem::offset_of!(drm_dma, send_sizes) - 16usize];
    ["Offset of field: drm_dma::flags"][::core::mem::offset_of!(drm_dma, flags) - 24usize];
    ["Offset of field: drm_dma::request_count"]
        [::core::mem::offset_of!(drm_dma, request_count) - 28usize];
    ["Offset of field: drm_dma::request_size"]
        [::core::mem::offset_of!(drm_dma, request_size) - 32usize];
    ["Offset of field: drm_dma::request_indices"]
        [::core::mem::offset_of!(drm_dma, request_indices) - 40usize];
    ["Offset of field: drm_dma::request_sizes"]
        [::core::mem::offset_of!(drm_dma, request_sizes) - 48usize];
    ["Offset of field: drm_dma::granted_count"]
        [::core::mem::offset_of!(drm_dma, granted_count) - 56usize];
};
pub const drm_ctx_flags__DRM_CONTEXT_PRESERVED: drm_ctx_flags = 1;
pub const drm_ctx_flags__DRM_CONTEXT_2DONLY: drm_ctx_flags = 2;
pub type drm_ctx_flags = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_ctx {
    pub handle: drm_context_t,
    pub flags: drm_ctx_flags,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_ctx"][::core::mem::size_of::<drm_ctx>() - 8usize];
    ["Alignment of drm_ctx"][::core::mem::align_of::<drm_ctx>() - 4usize];
    ["Offset of field: drm_ctx::handle"][::core::mem::offset_of!(drm_ctx, handle) - 0usize];
    ["Offset of field: drm_ctx::flags"][::core::mem::offset_of!(drm_ctx, flags) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_ctx_res {
    pub count: ::core::ffi::c_int,
    pub contexts: *mut drm_ctx,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_ctx_res"][::core::mem::size_of::<drm_ctx_res>() - 16usize];
    ["Alignment of drm_ctx_res"][::core::mem::align_of::<drm_ctx_res>() - 8usize];
    ["Offset of field: drm_ctx_res::count"][::core::mem::offset_of!(drm_ctx_res, count) - 0usize];
    ["Offset of field: drm_ctx_res::contexts"]
        [::core::mem::offset_of!(drm_ctx_res, contexts) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_draw {
    pub handle: drm_drawable_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_draw"][::core::mem::size_of::<drm_draw>() - 4usize];
    ["Alignment of drm_draw"][::core::mem::align_of::<drm_draw>() - 4usize];
    ["Offset of field: drm_draw::handle"][::core::mem::offset_of!(drm_draw, handle) - 0usize];
};
pub const drm_drawable_info_type_t_DRM_DRAWABLE_CLIPRECTS: drm_drawable_info_type_t = 0;
pub type drm_drawable_info_type_t = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_update_draw {
    pub handle: drm_drawable_t,
    pub type_: ::core::ffi::c_uint,
    pub num: ::core::ffi::c_uint,
    pub data: ::core::ffi::c_ulonglong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_update_draw"][::core::mem::size_of::<drm_update_draw>() - 24usize];
    ["Alignment of drm_update_draw"][::core::mem::align_of::<drm_update_draw>() - 8usize];
    ["Offset of field: drm_update_draw::handle"]
        [::core::mem::offset_of!(drm_update_draw, handle) - 0usize];
    ["Offset of field: drm_update_draw::type_"]
        [::core::mem::offset_of!(drm_update_draw, type_) - 4usize];
    ["Offset of field: drm_update_draw::num"]
        [::core::mem::offset_of!(drm_update_draw, num) - 8usize];
    ["Offset of field: drm_update_draw::data"]
        [::core::mem::offset_of!(drm_update_draw, data) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_auth {
    pub magic: drm_magic_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_auth"][::core::mem::size_of::<drm_auth>() - 4usize];
    ["Alignment of drm_auth"][::core::mem::align_of::<drm_auth>() - 4usize];
    ["Offset of field: drm_auth::magic"][::core::mem::offset_of!(drm_auth, magic) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_irq_busid {
    pub irq: ::core::ffi::c_int,
    pub busnum: ::core::ffi::c_int,
    pub devnum: ::core::ffi::c_int,
    pub funcnum: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_irq_busid"][::core::mem::size_of::<drm_irq_busid>() - 16usize];
    ["Alignment of drm_irq_busid"][::core::mem::align_of::<drm_irq_busid>() - 4usize];
    ["Offset of field: drm_irq_busid::irq"][::core::mem::offset_of!(drm_irq_busid, irq) - 0usize];
    ["Offset of field: drm_irq_busid::busnum"]
        [::core::mem::offset_of!(drm_irq_busid, busnum) - 4usize];
    ["Offset of field: drm_irq_busid::devnum"]
        [::core::mem::offset_of!(drm_irq_busid, devnum) - 8usize];
    ["Offset of field: drm_irq_busid::funcnum"]
        [::core::mem::offset_of!(drm_irq_busid, funcnum) - 12usize];
};
pub const drm_vblank_seq_type__DRM_VBLANK_ABSOLUTE: drm_vblank_seq_type = 0;
pub const drm_vblank_seq_type__DRM_VBLANK_RELATIVE: drm_vblank_seq_type = 1;
pub const drm_vblank_seq_type__DRM_VBLANK_HIGH_CRTC_MASK: drm_vblank_seq_type = 62;
pub const drm_vblank_seq_type__DRM_VBLANK_EVENT: drm_vblank_seq_type = 67108864;
pub const drm_vblank_seq_type__DRM_VBLANK_FLIP: drm_vblank_seq_type = 134217728;
pub const drm_vblank_seq_type__DRM_VBLANK_NEXTONMISS: drm_vblank_seq_type = 268435456;
pub const drm_vblank_seq_type__DRM_VBLANK_SECONDARY: drm_vblank_seq_type = 536870912;
pub const drm_vblank_seq_type__DRM_VBLANK_SIGNAL: drm_vblank_seq_type = 1073741824;
pub type drm_vblank_seq_type = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_wait_vblank_request {
    pub type_: drm_vblank_seq_type,
    pub sequence: ::core::ffi::c_uint,
    pub signal: ::core::ffi::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_wait_vblank_request"]
        [::core::mem::size_of::<drm_wait_vblank_request>() - 16usize];
    ["Alignment of drm_wait_vblank_request"]
        [::core::mem::align_of::<drm_wait_vblank_request>() - 8usize];
    ["Offset of field: drm_wait_vblank_request::type_"]
        [::core::mem::offset_of!(drm_wait_vblank_request, type_) - 0usize];
    ["Offset of field: drm_wait_vblank_request::sequence"]
        [::core::mem::offset_of!(drm_wait_vblank_request, sequence) - 4usize];
    ["Offset of field: drm_wait_vblank_request::signal"]
        [::core::mem::offset_of!(drm_wait_vblank_request, signal) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_wait_vblank_reply {
    pub type_: drm_vblank_seq_type,
    pub sequence: ::core::ffi::c_uint,
    pub tval_sec: ::core::ffi::c_long,
    pub tval_usec: ::core::ffi::c_long,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_wait_vblank_reply"][::core::mem::size_of::<drm_wait_vblank_reply>() - 24usize];
    ["Alignment of drm_wait_vblank_reply"]
        [::core::mem::align_of::<drm_wait_vblank_reply>() - 8usize];
    ["Offset of field: drm_wait_vblank_reply::type_"]
        [::core::mem::offset_of!(drm_wait_vblank_reply, type_) - 0usize];
    ["Offset of field: drm_wait_vblank_reply::sequence"]
        [::core::mem::offset_of!(drm_wait_vblank_reply, sequence) - 4usize];
    ["Offset of field: drm_wait_vblank_reply::tval_sec"]
        [::core::mem::offset_of!(drm_wait_vblank_reply, tval_sec) - 8usize];
    ["Offset of field: drm_wait_vblank_reply::tval_usec"]
        [::core::mem::offset_of!(drm_wait_vblank_reply, tval_usec) - 16usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_wait_vblank {
    pub request: drm_wait_vblank_request,
    pub reply: drm_wait_vblank_reply,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_wait_vblank"][::core::mem::size_of::<drm_wait_vblank>() - 24usize];
    ["Alignment of drm_wait_vblank"][::core::mem::align_of::<drm_wait_vblank>() - 8usize];
    ["Offset of field: drm_wait_vblank::request"]
        [::core::mem::offset_of!(drm_wait_vblank, request) - 0usize];
    ["Offset of field: drm_wait_vblank::reply"]
        [::core::mem::offset_of!(drm_wait_vblank, reply) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_modeset_ctl {
    pub crtc: __u32,
    pub cmd: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_modeset_ctl"][::core::mem::size_of::<drm_modeset_ctl>() - 8usize];
    ["Alignment of drm_modeset_ctl"][::core::mem::align_of::<drm_modeset_ctl>() - 4usize];
    ["Offset of field: drm_modeset_ctl::crtc"]
        [::core::mem::offset_of!(drm_modeset_ctl, crtc) - 0usize];
    ["Offset of field: drm_modeset_ctl::cmd"]
        [::core::mem::offset_of!(drm_modeset_ctl, cmd) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_agp_mode {
    pub mode: ::core::ffi::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_agp_mode"][::core::mem::size_of::<drm_agp_mode>() - 8usize];
    ["Alignment of drm_agp_mode"][::core::mem::align_of::<drm_agp_mode>() - 8usize];
    ["Offset of field: drm_agp_mode::mode"][::core::mem::offset_of!(drm_agp_mode, mode) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_agp_buffer {
    pub size: ::core::ffi::c_ulong,
    pub handle: ::core::ffi::c_ulong,
    pub type_: ::core::ffi::c_ulong,
    pub physical: ::core::ffi::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_agp_buffer"][::core::mem::size_of::<drm_agp_buffer>() - 32usize];
    ["Alignment of drm_agp_buffer"][::core::mem::align_of::<drm_agp_buffer>() - 8usize];
    ["Offset of field: drm_agp_buffer::size"]
        [::core::mem::offset_of!(drm_agp_buffer, size) - 0usize];
    ["Offset of field: drm_agp_buffer::handle"]
        [::core::mem::offset_of!(drm_agp_buffer, handle) - 8usize];
    ["Offset of field: drm_agp_buffer::type_"]
        [::core::mem::offset_of!(drm_agp_buffer, type_) - 16usize];
    ["Offset of field: drm_agp_buffer::physical"]
        [::core::mem::offset_of!(drm_agp_buffer, physical) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_agp_binding {
    pub handle: ::core::ffi::c_ulong,
    pub offset: ::core::ffi::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_agp_binding"][::core::mem::size_of::<drm_agp_binding>() - 16usize];
    ["Alignment of drm_agp_binding"][::core::mem::align_of::<drm_agp_binding>() - 8usize];
    ["Offset of field: drm_agp_binding::handle"]
        [::core::mem::offset_of!(drm_agp_binding, handle) - 0usize];
    ["Offset of field: drm_agp_binding::offset"]
        [::core::mem::offset_of!(drm_agp_binding, offset) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_agp_info {
    pub agp_version_major: ::core::ffi::c_int,
    pub agp_version_minor: ::core::ffi::c_int,
    pub mode: ::core::ffi::c_ulong,
    pub aperture_base: ::core::ffi::c_ulong,
    pub aperture_size: ::core::ffi::c_ulong,
    pub memory_allowed: ::core::ffi::c_ulong,
    pub memory_used: ::core::ffi::c_ulong,
    pub id_vendor: ::core::ffi::c_ushort,
    pub id_device: ::core::ffi::c_ushort,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_agp_info"][::core::mem::size_of::<drm_agp_info>() - 56usize];
    ["Alignment of drm_agp_info"][::core::mem::align_of::<drm_agp_info>() - 8usize];
    ["Offset of field: drm_agp_info::agp_version_major"]
        [::core::mem::offset_of!(drm_agp_info, agp_version_major) - 0usize];
    ["Offset of field: drm_agp_info::agp_version_minor"]
        [::core::mem::offset_of!(drm_agp_info, agp_version_minor) - 4usize];
    ["Offset of field: drm_agp_info::mode"][::core::mem::offset_of!(drm_agp_info, mode) - 8usize];
    ["Offset of field: drm_agp_info::aperture_base"]
        [::core::mem::offset_of!(drm_agp_info, aperture_base) - 16usize];
    ["Offset of field: drm_agp_info::aperture_size"]
        [::core::mem::offset_of!(drm_agp_info, aperture_size) - 24usize];
    ["Offset of field: drm_agp_info::memory_allowed"]
        [::core::mem::offset_of!(drm_agp_info, memory_allowed) - 32usize];
    ["Offset of field: drm_agp_info::memory_used"]
        [::core::mem::offset_of!(drm_agp_info, memory_used) - 40usize];
    ["Offset of field: drm_agp_info::id_vendor"]
        [::core::mem::offset_of!(drm_agp_info, id_vendor) - 48usize];
    ["Offset of field: drm_agp_info::id_device"]
        [::core::mem::offset_of!(drm_agp_info, id_device) - 50usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_scatter_gather {
    pub size: ::core::ffi::c_ulong,
    pub handle: ::core::ffi::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_scatter_gather"][::core::mem::size_of::<drm_scatter_gather>() - 16usize];
    ["Alignment of drm_scatter_gather"][::core::mem::align_of::<drm_scatter_gather>() - 8usize];
    ["Offset of field: drm_scatter_gather::size"]
        [::core::mem::offset_of!(drm_scatter_gather, size) - 0usize];
    ["Offset of field: drm_scatter_gather::handle"]
        [::core::mem::offset_of!(drm_scatter_gather, handle) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_set_version {
    pub drm_di_major: ::core::ffi::c_int,
    pub drm_di_minor: ::core::ffi::c_int,
    pub drm_dd_major: ::core::ffi::c_int,
    pub drm_dd_minor: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_set_version"][::core::mem::size_of::<drm_set_version>() - 16usize];
    ["Alignment of drm_set_version"][::core::mem::align_of::<drm_set_version>() - 4usize];
    ["Offset of field: drm_set_version::drm_di_major"]
        [::core::mem::offset_of!(drm_set_version, drm_di_major) - 0usize];
    ["Offset of field: drm_set_version::drm_di_minor"]
        [::core::mem::offset_of!(drm_set_version, drm_di_minor) - 4usize];
    ["Offset of field: drm_set_version::drm_dd_major"]
        [::core::mem::offset_of!(drm_set_version, drm_dd_major) - 8usize];
    ["Offset of field: drm_set_version::drm_dd_minor"]
        [::core::mem::offset_of!(drm_set_version, drm_dd_minor) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_gem_close {
    pub handle: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_gem_close"][::core::mem::size_of::<drm_gem_close>() - 8usize];
    ["Alignment of drm_gem_close"][::core::mem::align_of::<drm_gem_close>() - 4usize];
    ["Offset of field: drm_gem_close::handle"]
        [::core::mem::offset_of!(drm_gem_close, handle) - 0usize];
    ["Offset of field: drm_gem_close::pad"][::core::mem::offset_of!(drm_gem_close, pad) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_gem_flink {
    pub handle: __u32,
    pub name: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_gem_flink"][::core::mem::size_of::<drm_gem_flink>() - 8usize];
    ["Alignment of drm_gem_flink"][::core::mem::align_of::<drm_gem_flink>() - 4usize];
    ["Offset of field: drm_gem_flink::handle"]
        [::core::mem::offset_of!(drm_gem_flink, handle) - 0usize];
    ["Offset of field: drm_gem_flink::name"][::core::mem::offset_of!(drm_gem_flink, name) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_gem_open {
    pub name: __u32,
    pub handle: __u32,
    pub size: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_gem_open"][::core::mem::size_of::<drm_gem_open>() - 16usize];
    ["Alignment of drm_gem_open"][::core::mem::align_of::<drm_gem_open>() - 8usize];
    ["Offset of field: drm_gem_open::name"][::core::mem::offset_of!(drm_gem_open, name) - 0usize];
    ["Offset of field: drm_gem_open::handle"]
        [::core::mem::offset_of!(drm_gem_open, handle) - 4usize];
    ["Offset of field: drm_gem_open::size"][::core::mem::offset_of!(drm_gem_open, size) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_get_cap {
    pub capability: __u64,
    pub value: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_get_cap"][::core::mem::size_of::<drm_get_cap>() - 16usize];
    ["Alignment of drm_get_cap"][::core::mem::align_of::<drm_get_cap>() - 8usize];
    ["Offset of field: drm_get_cap::capability"]
        [::core::mem::offset_of!(drm_get_cap, capability) - 0usize];
    ["Offset of field: drm_get_cap::value"][::core::mem::offset_of!(drm_get_cap, value) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_set_client_cap {
    pub capability: __u64,
    pub value: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_set_client_cap"][::core::mem::size_of::<drm_set_client_cap>() - 16usize];
    ["Alignment of drm_set_client_cap"][::core::mem::align_of::<drm_set_client_cap>() - 8usize];
    ["Offset of field: drm_set_client_cap::capability"]
        [::core::mem::offset_of!(drm_set_client_cap, capability) - 0usize];
    ["Offset of field: drm_set_client_cap::value"]
        [::core::mem::offset_of!(drm_set_client_cap, value) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_prime_handle {
    pub handle: __u32,
    pub flags: __u32,
    pub fd: __s32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_prime_handle"][::core::mem::size_of::<drm_prime_handle>() - 12usize];
    ["Alignment of drm_prime_handle"][::core::mem::align_of::<drm_prime_handle>() - 4usize];
    ["Offset of field: drm_prime_handle::handle"]
        [::core::mem::offset_of!(drm_prime_handle, handle) - 0usize];
    ["Offset of field: drm_prime_handle::flags"]
        [::core::mem::offset_of!(drm_prime_handle, flags) - 4usize];
    ["Offset of field: drm_prime_handle::fd"]
        [::core::mem::offset_of!(drm_prime_handle, fd) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_create {
    pub handle: __u32,
    pub flags: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_create"][::core::mem::size_of::<drm_syncobj_create>() - 8usize];
    ["Alignment of drm_syncobj_create"][::core::mem::align_of::<drm_syncobj_create>() - 4usize];
    ["Offset of field: drm_syncobj_create::handle"]
        [::core::mem::offset_of!(drm_syncobj_create, handle) - 0usize];
    ["Offset of field: drm_syncobj_create::flags"]
        [::core::mem::offset_of!(drm_syncobj_create, flags) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_destroy {
    pub handle: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_destroy"][::core::mem::size_of::<drm_syncobj_destroy>() - 8usize];
    ["Alignment of drm_syncobj_destroy"][::core::mem::align_of::<drm_syncobj_destroy>() - 4usize];
    ["Offset of field: drm_syncobj_destroy::handle"]
        [::core::mem::offset_of!(drm_syncobj_destroy, handle) - 0usize];
    ["Offset of field: drm_syncobj_destroy::pad"]
        [::core::mem::offset_of!(drm_syncobj_destroy, pad) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_handle {
    pub handle: __u32,
    pub flags: __u32,
    pub fd: __s32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_handle"][::core::mem::size_of::<drm_syncobj_handle>() - 16usize];
    ["Alignment of drm_syncobj_handle"][::core::mem::align_of::<drm_syncobj_handle>() - 4usize];
    ["Offset of field: drm_syncobj_handle::handle"]
        [::core::mem::offset_of!(drm_syncobj_handle, handle) - 0usize];
    ["Offset of field: drm_syncobj_handle::flags"]
        [::core::mem::offset_of!(drm_syncobj_handle, flags) - 4usize];
    ["Offset of field: drm_syncobj_handle::fd"]
        [::core::mem::offset_of!(drm_syncobj_handle, fd) - 8usize];
    ["Offset of field: drm_syncobj_handle::pad"]
        [::core::mem::offset_of!(drm_syncobj_handle, pad) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_transfer {
    pub src_handle: __u32,
    pub dst_handle: __u32,
    pub src_point: __u64,
    pub dst_point: __u64,
    pub flags: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_transfer"][::core::mem::size_of::<drm_syncobj_transfer>() - 32usize];
    ["Alignment of drm_syncobj_transfer"][::core::mem::align_of::<drm_syncobj_transfer>() - 8usize];
    ["Offset of field: drm_syncobj_transfer::src_handle"]
        [::core::mem::offset_of!(drm_syncobj_transfer, src_handle) - 0usize];
    ["Offset of field: drm_syncobj_transfer::dst_handle"]
        [::core::mem::offset_of!(drm_syncobj_transfer, dst_handle) - 4usize];
    ["Offset of field: drm_syncobj_transfer::src_point"]
        [::core::mem::offset_of!(drm_syncobj_transfer, src_point) - 8usize];
    ["Offset of field: drm_syncobj_transfer::dst_point"]
        [::core::mem::offset_of!(drm_syncobj_transfer, dst_point) - 16usize];
    ["Offset of field: drm_syncobj_transfer::flags"]
        [::core::mem::offset_of!(drm_syncobj_transfer, flags) - 24usize];
    ["Offset of field: drm_syncobj_transfer::pad"]
        [::core::mem::offset_of!(drm_syncobj_transfer, pad) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_wait {
    pub handles: __u64,
    pub timeout_nsec: __s64,
    pub count_handles: __u32,
    pub flags: __u32,
    pub first_signaled: __u32,
    pub pad: __u32,
    pub deadline_nsec: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_wait"][::core::mem::size_of::<drm_syncobj_wait>() - 40usize];
    ["Alignment of drm_syncobj_wait"][::core::mem::align_of::<drm_syncobj_wait>() - 8usize];
    ["Offset of field: drm_syncobj_wait::handles"]
        [::core::mem::offset_of!(drm_syncobj_wait, handles) - 0usize];
    ["Offset of field: drm_syncobj_wait::timeout_nsec"]
        [::core::mem::offset_of!(drm_syncobj_wait, timeout_nsec) - 8usize];
    ["Offset of field: drm_syncobj_wait::count_handles"]
        [::core::mem::offset_of!(drm_syncobj_wait, count_handles) - 16usize];
    ["Offset of field: drm_syncobj_wait::flags"]
        [::core::mem::offset_of!(drm_syncobj_wait, flags) - 20usize];
    ["Offset of field: drm_syncobj_wait::first_signaled"]
        [::core::mem::offset_of!(drm_syncobj_wait, first_signaled) - 24usize];
    ["Offset of field: drm_syncobj_wait::pad"]
        [::core::mem::offset_of!(drm_syncobj_wait, pad) - 28usize];
    ["Offset of field: drm_syncobj_wait::deadline_nsec"]
        [::core::mem::offset_of!(drm_syncobj_wait, deadline_nsec) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_timeline_wait {
    pub handles: __u64,
    pub points: __u64,
    pub timeout_nsec: __s64,
    pub count_handles: __u32,
    pub flags: __u32,
    pub first_signaled: __u32,
    pub pad: __u32,
    pub deadline_nsec: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_timeline_wait"]
        [::core::mem::size_of::<drm_syncobj_timeline_wait>() - 48usize];
    ["Alignment of drm_syncobj_timeline_wait"]
        [::core::mem::align_of::<drm_syncobj_timeline_wait>() - 8usize];
    ["Offset of field: drm_syncobj_timeline_wait::handles"]
        [::core::mem::offset_of!(drm_syncobj_timeline_wait, handles) - 0usize];
    ["Offset of field: drm_syncobj_timeline_wait::points"]
        [::core::mem::offset_of!(drm_syncobj_timeline_wait, points) - 8usize];
    ["Offset of field: drm_syncobj_timeline_wait::timeout_nsec"]
        [::core::mem::offset_of!(drm_syncobj_timeline_wait, timeout_nsec) - 16usize];
    ["Offset of field: drm_syncobj_timeline_wait::count_handles"]
        [::core::mem::offset_of!(drm_syncobj_timeline_wait, count_handles) - 24usize];
    ["Offset of field: drm_syncobj_timeline_wait::flags"]
        [::core::mem::offset_of!(drm_syncobj_timeline_wait, flags) - 28usize];
    ["Offset of field: drm_syncobj_timeline_wait::first_signaled"]
        [::core::mem::offset_of!(drm_syncobj_timeline_wait, first_signaled) - 32usize];
    ["Offset of field: drm_syncobj_timeline_wait::pad"]
        [::core::mem::offset_of!(drm_syncobj_timeline_wait, pad) - 36usize];
    ["Offset of field: drm_syncobj_timeline_wait::deadline_nsec"]
        [::core::mem::offset_of!(drm_syncobj_timeline_wait, deadline_nsec) - 40usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_eventfd {
    pub handle: __u32,
    pub flags: __u32,
    pub point: __u64,
    pub fd: __s32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_eventfd"][::core::mem::size_of::<drm_syncobj_eventfd>() - 24usize];
    ["Alignment of drm_syncobj_eventfd"][::core::mem::align_of::<drm_syncobj_eventfd>() - 8usize];
    ["Offset of field: drm_syncobj_eventfd::handle"]
        [::core::mem::offset_of!(drm_syncobj_eventfd, handle) - 0usize];
    ["Offset of field: drm_syncobj_eventfd::flags"]
        [::core::mem::offset_of!(drm_syncobj_eventfd, flags) - 4usize];
    ["Offset of field: drm_syncobj_eventfd::point"]
        [::core::mem::offset_of!(drm_syncobj_eventfd, point) - 8usize];
    ["Offset of field: drm_syncobj_eventfd::fd"]
        [::core::mem::offset_of!(drm_syncobj_eventfd, fd) - 16usize];
    ["Offset of field: drm_syncobj_eventfd::pad"]
        [::core::mem::offset_of!(drm_syncobj_eventfd, pad) - 20usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_array {
    pub handles: __u64,
    pub count_handles: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_array"][::core::mem::size_of::<drm_syncobj_array>() - 16usize];
    ["Alignment of drm_syncobj_array"][::core::mem::align_of::<drm_syncobj_array>() - 8usize];
    ["Offset of field: drm_syncobj_array::handles"]
        [::core::mem::offset_of!(drm_syncobj_array, handles) - 0usize];
    ["Offset of field: drm_syncobj_array::count_handles"]
        [::core::mem::offset_of!(drm_syncobj_array, count_handles) - 8usize];
    ["Offset of field: drm_syncobj_array::pad"]
        [::core::mem::offset_of!(drm_syncobj_array, pad) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_syncobj_timeline_array {
    pub handles: __u64,
    pub points: __u64,
    pub count_handles: __u32,
    pub flags: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_syncobj_timeline_array"]
        [::core::mem::size_of::<drm_syncobj_timeline_array>() - 24usize];
    ["Alignment of drm_syncobj_timeline_array"]
        [::core::mem::align_of::<drm_syncobj_timeline_array>() - 8usize];
    ["Offset of field: drm_syncobj_timeline_array::handles"]
        [::core::mem::offset_of!(drm_syncobj_timeline_array, handles) - 0usize];
    ["Offset of field: drm_syncobj_timeline_array::points"]
        [::core::mem::offset_of!(drm_syncobj_timeline_array, points) - 8usize];
    ["Offset of field: drm_syncobj_timeline_array::count_handles"]
        [::core::mem::offset_of!(drm_syncobj_timeline_array, count_handles) - 16usize];
    ["Offset of field: drm_syncobj_timeline_array::flags"]
        [::core::mem::offset_of!(drm_syncobj_timeline_array, flags) - 20usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_crtc_get_sequence {
    pub crtc_id: __u32,
    pub active: __u32,
    pub sequence: __u64,
    pub sequence_ns: __s64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_crtc_get_sequence"][::core::mem::size_of::<drm_crtc_get_sequence>() - 24usize];
    ["Alignment of drm_crtc_get_sequence"]
        [::core::mem::align_of::<drm_crtc_get_sequence>() - 8usize];
    ["Offset of field: drm_crtc_get_sequence::crtc_id"]
        [::core::mem::offset_of!(drm_crtc_get_sequence, crtc_id) - 0usize];
    ["Offset of field: drm_crtc_get_sequence::active"]
        [::core::mem::offset_of!(drm_crtc_get_sequence, active) - 4usize];
    ["Offset of field: drm_crtc_get_sequence::sequence"]
        [::core::mem::offset_of!(drm_crtc_get_sequence, sequence) - 8usize];
    ["Offset of field: drm_crtc_get_sequence::sequence_ns"]
        [::core::mem::offset_of!(drm_crtc_get_sequence, sequence_ns) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_crtc_queue_sequence {
    pub crtc_id: __u32,
    pub flags: __u32,
    pub sequence: __u64,
    pub user_data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_crtc_queue_sequence"]
        [::core::mem::size_of::<drm_crtc_queue_sequence>() - 24usize];
    ["Alignment of drm_crtc_queue_sequence"]
        [::core::mem::align_of::<drm_crtc_queue_sequence>() - 8usize];
    ["Offset of field: drm_crtc_queue_sequence::crtc_id"]
        [::core::mem::offset_of!(drm_crtc_queue_sequence, crtc_id) - 0usize];
    ["Offset of field: drm_crtc_queue_sequence::flags"]
        [::core::mem::offset_of!(drm_crtc_queue_sequence, flags) - 4usize];
    ["Offset of field: drm_crtc_queue_sequence::sequence"]
        [::core::mem::offset_of!(drm_crtc_queue_sequence, sequence) - 8usize];
    ["Offset of field: drm_crtc_queue_sequence::user_data"]
        [::core::mem::offset_of!(drm_crtc_queue_sequence, user_data) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_modeinfo {
    pub clock: __u32,
    pub hdisplay: __u16,
    pub hsync_start: __u16,
    pub hsync_end: __u16,
    pub htotal: __u16,
    pub hskew: __u16,
    pub vdisplay: __u16,
    pub vsync_start: __u16,
    pub vsync_end: __u16,
    pub vtotal: __u16,
    pub vscan: __u16,
    pub vrefresh: __u32,
    pub flags: __u32,
    pub type_: __u32,
    pub name: [::core::ffi::c_char; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_modeinfo"][::core::mem::size_of::<drm_mode_modeinfo>() - 68usize];
    ["Alignment of drm_mode_modeinfo"][::core::mem::align_of::<drm_mode_modeinfo>() - 4usize];
    ["Offset of field: drm_mode_modeinfo::clock"]
        [::core::mem::offset_of!(drm_mode_modeinfo, clock) - 0usize];
    ["Offset of field: drm_mode_modeinfo::hdisplay"]
        [::core::mem::offset_of!(drm_mode_modeinfo, hdisplay) - 4usize];
    ["Offset of field: drm_mode_modeinfo::hsync_start"]
        [::core::mem::offset_of!(drm_mode_modeinfo, hsync_start) - 6usize];
    ["Offset of field: drm_mode_modeinfo::hsync_end"]
        [::core::mem::offset_of!(drm_mode_modeinfo, hsync_end) - 8usize];
    ["Offset of field: drm_mode_modeinfo::htotal"]
        [::core::mem::offset_of!(drm_mode_modeinfo, htotal) - 10usize];
    ["Offset of field: drm_mode_modeinfo::hskew"]
        [::core::mem::offset_of!(drm_mode_modeinfo, hskew) - 12usize];
    ["Offset of field: drm_mode_modeinfo::vdisplay"]
        [::core::mem::offset_of!(drm_mode_modeinfo, vdisplay) - 14usize];
    ["Offset of field: drm_mode_modeinfo::vsync_start"]
        [::core::mem::offset_of!(drm_mode_modeinfo, vsync_start) - 16usize];
    ["Offset of field: drm_mode_modeinfo::vsync_end"]
        [::core::mem::offset_of!(drm_mode_modeinfo, vsync_end) - 18usize];
    ["Offset of field: drm_mode_modeinfo::vtotal"]
        [::core::mem::offset_of!(drm_mode_modeinfo, vtotal) - 20usize];
    ["Offset of field: drm_mode_modeinfo::vscan"]
        [::core::mem::offset_of!(drm_mode_modeinfo, vscan) - 22usize];
    ["Offset of field: drm_mode_modeinfo::vrefresh"]
        [::core::mem::offset_of!(drm_mode_modeinfo, vrefresh) - 24usize];
    ["Offset of field: drm_mode_modeinfo::flags"]
        [::core::mem::offset_of!(drm_mode_modeinfo, flags) - 28usize];
    ["Offset of field: drm_mode_modeinfo::type_"]
        [::core::mem::offset_of!(drm_mode_modeinfo, type_) - 32usize];
    ["Offset of field: drm_mode_modeinfo::name"]
        [::core::mem::offset_of!(drm_mode_modeinfo, name) - 36usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_card_res {
    pub fb_id_ptr: __u64,
    pub crtc_id_ptr: __u64,
    pub connector_id_ptr: __u64,
    pub encoder_id_ptr: __u64,
    pub count_fbs: __u32,
    pub count_crtcs: __u32,
    pub count_connectors: __u32,
    pub count_encoders: __u32,
    pub min_width: __u32,
    pub max_width: __u32,
    pub min_height: __u32,
    pub max_height: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_card_res"][::core::mem::size_of::<drm_mode_card_res>() - 64usize];
    ["Alignment of drm_mode_card_res"][::core::mem::align_of::<drm_mode_card_res>() - 8usize];
    ["Offset of field: drm_mode_card_res::fb_id_ptr"]
        [::core::mem::offset_of!(drm_mode_card_res, fb_id_ptr) - 0usize];
    ["Offset of field: drm_mode_card_res::crtc_id_ptr"]
        [::core::mem::offset_of!(drm_mode_card_res, crtc_id_ptr) - 8usize];
    ["Offset of field: drm_mode_card_res::connector_id_ptr"]
        [::core::mem::offset_of!(drm_mode_card_res, connector_id_ptr) - 16usize];
    ["Offset of field: drm_mode_card_res::encoder_id_ptr"]
        [::core::mem::offset_of!(drm_mode_card_res, encoder_id_ptr) - 24usize];
    ["Offset of field: drm_mode_card_res::count_fbs"]
        [::core::mem::offset_of!(drm_mode_card_res, count_fbs) - 32usize];
    ["Offset of field: drm_mode_card_res::count_crtcs"]
        [::core::mem::offset_of!(drm_mode_card_res, count_crtcs) - 36usize];
    ["Offset of field: drm_mode_card_res::count_connectors"]
        [::core::mem::offset_of!(drm_mode_card_res, count_connectors) - 40usize];
    ["Offset of field: drm_mode_card_res::count_encoders"]
        [::core::mem::offset_of!(drm_mode_card_res, count_encoders) - 44usize];
    ["Offset of field: drm_mode_card_res::min_width"]
        [::core::mem::offset_of!(drm_mode_card_res, min_width) - 48usize];
    ["Offset of field: drm_mode_card_res::max_width"]
        [::core::mem::offset_of!(drm_mode_card_res, max_width) - 52usize];
    ["Offset of field: drm_mode_card_res::min_height"]
        [::core::mem::offset_of!(drm_mode_card_res, min_height) - 56usize];
    ["Offset of field: drm_mode_card_res::max_height"]
        [::core::mem::offset_of!(drm_mode_card_res, max_height) - 60usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_crtc {
    pub set_connectors_ptr: __u64,
    pub count_connectors: __u32,
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub x: __u32,
    pub y: __u32,
    pub gamma_size: __u32,
    pub mode_valid: __u32,
    pub mode: drm_mode_modeinfo,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_crtc"][::core::mem::size_of::<drm_mode_crtc>() - 104usize];
    ["Alignment of drm_mode_crtc"][::core::mem::align_of::<drm_mode_crtc>() - 8usize];
    ["Offset of field: drm_mode_crtc::set_connectors_ptr"]
        [::core::mem::offset_of!(drm_mode_crtc, set_connectors_ptr) - 0usize];
    ["Offset of field: drm_mode_crtc::count_connectors"]
        [::core::mem::offset_of!(drm_mode_crtc, count_connectors) - 8usize];
    ["Offset of field: drm_mode_crtc::crtc_id"]
        [::core::mem::offset_of!(drm_mode_crtc, crtc_id) - 12usize];
    ["Offset of field: drm_mode_crtc::fb_id"]
        [::core::mem::offset_of!(drm_mode_crtc, fb_id) - 16usize];
    ["Offset of field: drm_mode_crtc::x"][::core::mem::offset_of!(drm_mode_crtc, x) - 20usize];
    ["Offset of field: drm_mode_crtc::y"][::core::mem::offset_of!(drm_mode_crtc, y) - 24usize];
    ["Offset of field: drm_mode_crtc::gamma_size"]
        [::core::mem::offset_of!(drm_mode_crtc, gamma_size) - 28usize];
    ["Offset of field: drm_mode_crtc::mode_valid"]
        [::core::mem::offset_of!(drm_mode_crtc, mode_valid) - 32usize];
    ["Offset of field: drm_mode_crtc::mode"]
        [::core::mem::offset_of!(drm_mode_crtc, mode) - 36usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_set_plane {
    pub plane_id: __u32,
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub flags: __u32,
    pub crtc_x: __s32,
    pub crtc_y: __s32,
    pub crtc_w: __u32,
    pub crtc_h: __u32,
    pub src_x: __u32,
    pub src_y: __u32,
    pub src_h: __u32,
    pub src_w: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_set_plane"][::core::mem::size_of::<drm_mode_set_plane>() - 48usize];
    ["Alignment of drm_mode_set_plane"][::core::mem::align_of::<drm_mode_set_plane>() - 4usize];
    ["Offset of field: drm_mode_set_plane::plane_id"]
        [::core::mem::offset_of!(drm_mode_set_plane, plane_id) - 0usize];
    ["Offset of field: drm_mode_set_plane::crtc_id"]
        [::core::mem::offset_of!(drm_mode_set_plane, crtc_id) - 4usize];
    ["Offset of field: drm_mode_set_plane::fb_id"]
        [::core::mem::offset_of!(drm_mode_set_plane, fb_id) - 8usize];
    ["Offset of field: drm_mode_set_plane::flags"]
        [::core::mem::offset_of!(drm_mode_set_plane, flags) - 12usize];
    ["Offset of field: drm_mode_set_plane::crtc_x"]
        [::core::mem::offset_of!(drm_mode_set_plane, crtc_x) - 16usize];
    ["Offset of field: drm_mode_set_plane::crtc_y"]
        [::core::mem::offset_of!(drm_mode_set_plane, crtc_y) - 20usize];
    ["Offset of field: drm_mode_set_plane::crtc_w"]
        [::core::mem::offset_of!(drm_mode_set_plane, crtc_w) - 24usize];
    ["Offset of field: drm_mode_set_plane::crtc_h"]
        [::core::mem::offset_of!(drm_mode_set_plane, crtc_h) - 28usize];
    ["Offset of field: drm_mode_set_plane::src_x"]
        [::core::mem::offset_of!(drm_mode_set_plane, src_x) - 32usize];
    ["Offset of field: drm_mode_set_plane::src_y"]
        [::core::mem::offset_of!(drm_mode_set_plane, src_y) - 36usize];
    ["Offset of field: drm_mode_set_plane::src_h"]
        [::core::mem::offset_of!(drm_mode_set_plane, src_h) - 40usize];
    ["Offset of field: drm_mode_set_plane::src_w"]
        [::core::mem::offset_of!(drm_mode_set_plane, src_w) - 44usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_plane {
    pub plane_id: __u32,
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub possible_crtcs: __u32,
    pub gamma_size: __u32,
    pub count_format_types: __u32,
    pub format_type_ptr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_plane"][::core::mem::size_of::<drm_mode_get_plane>() - 32usize];
    ["Alignment of drm_mode_get_plane"][::core::mem::align_of::<drm_mode_get_plane>() - 8usize];
    ["Offset of field: drm_mode_get_plane::plane_id"]
        [::core::mem::offset_of!(drm_mode_get_plane, plane_id) - 0usize];
    ["Offset of field: drm_mode_get_plane::crtc_id"]
        [::core::mem::offset_of!(drm_mode_get_plane, crtc_id) - 4usize];
    ["Offset of field: drm_mode_get_plane::fb_id"]
        [::core::mem::offset_of!(drm_mode_get_plane, fb_id) - 8usize];
    ["Offset of field: drm_mode_get_plane::possible_crtcs"]
        [::core::mem::offset_of!(drm_mode_get_plane, possible_crtcs) - 12usize];
    ["Offset of field: drm_mode_get_plane::gamma_size"]
        [::core::mem::offset_of!(drm_mode_get_plane, gamma_size) - 16usize];
    ["Offset of field: drm_mode_get_plane::count_format_types"]
        [::core::mem::offset_of!(drm_mode_get_plane, count_format_types) - 20usize];
    ["Offset of field: drm_mode_get_plane::format_type_ptr"]
        [::core::mem::offset_of!(drm_mode_get_plane, format_type_ptr) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_plane_res {
    pub plane_id_ptr: __u64,
    pub count_planes: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_plane_res"][::core::mem::size_of::<drm_mode_get_plane_res>() - 16usize];
    ["Alignment of drm_mode_get_plane_res"]
        [::core::mem::align_of::<drm_mode_get_plane_res>() - 8usize];
    ["Offset of field: drm_mode_get_plane_res::plane_id_ptr"]
        [::core::mem::offset_of!(drm_mode_get_plane_res, plane_id_ptr) - 0usize];
    ["Offset of field: drm_mode_get_plane_res::count_planes"]
        [::core::mem::offset_of!(drm_mode_get_plane_res, count_planes) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_encoder {
    pub encoder_id: __u32,
    pub encoder_type: __u32,
    pub crtc_id: __u32,
    pub possible_crtcs: __u32,
    pub possible_clones: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_encoder"][::core::mem::size_of::<drm_mode_get_encoder>() - 20usize];
    ["Alignment of drm_mode_get_encoder"][::core::mem::align_of::<drm_mode_get_encoder>() - 4usize];
    ["Offset of field: drm_mode_get_encoder::encoder_id"]
        [::core::mem::offset_of!(drm_mode_get_encoder, encoder_id) - 0usize];
    ["Offset of field: drm_mode_get_encoder::encoder_type"]
        [::core::mem::offset_of!(drm_mode_get_encoder, encoder_type) - 4usize];
    ["Offset of field: drm_mode_get_encoder::crtc_id"]
        [::core::mem::offset_of!(drm_mode_get_encoder, crtc_id) - 8usize];
    ["Offset of field: drm_mode_get_encoder::possible_crtcs"]
        [::core::mem::offset_of!(drm_mode_get_encoder, possible_crtcs) - 12usize];
    ["Offset of field: drm_mode_get_encoder::possible_clones"]
        [::core::mem::offset_of!(drm_mode_get_encoder, possible_clones) - 16usize];
};
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_Automatic: drm_mode_subconnector = 0;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_Unknown: drm_mode_subconnector = 0;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_VGA: drm_mode_subconnector = 1;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_DVID: drm_mode_subconnector = 3;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_DVIA: drm_mode_subconnector = 4;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_Composite: drm_mode_subconnector = 5;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_SVIDEO: drm_mode_subconnector = 6;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_Component: drm_mode_subconnector = 8;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_SCART: drm_mode_subconnector = 9;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_DisplayPort: drm_mode_subconnector = 10;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_HDMIA: drm_mode_subconnector = 11;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_Native: drm_mode_subconnector = 15;
pub const drm_mode_subconnector_DRM_MODE_SUBCONNECTOR_Wireless: drm_mode_subconnector = 18;
pub type drm_mode_subconnector = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_connector {
    pub encoders_ptr: __u64,
    pub modes_ptr: __u64,
    pub props_ptr: __u64,
    pub prop_values_ptr: __u64,
    pub count_modes: __u32,
    pub count_props: __u32,
    pub count_encoders: __u32,
    pub encoder_id: __u32,
    pub connector_id: __u32,
    pub connector_type: __u32,
    pub connector_type_id: __u32,
    pub connection: __u32,
    pub mm_width: __u32,
    pub mm_height: __u32,
    pub subpixel: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_connector"][::core::mem::size_of::<drm_mode_get_connector>() - 80usize];
    ["Alignment of drm_mode_get_connector"]
        [::core::mem::align_of::<drm_mode_get_connector>() - 8usize];
    ["Offset of field: drm_mode_get_connector::encoders_ptr"]
        [::core::mem::offset_of!(drm_mode_get_connector, encoders_ptr) - 0usize];
    ["Offset of field: drm_mode_get_connector::modes_ptr"]
        [::core::mem::offset_of!(drm_mode_get_connector, modes_ptr) - 8usize];
    ["Offset of field: drm_mode_get_connector::props_ptr"]
        [::core::mem::offset_of!(drm_mode_get_connector, props_ptr) - 16usize];
    ["Offset of field: drm_mode_get_connector::prop_values_ptr"]
        [::core::mem::offset_of!(drm_mode_get_connector, prop_values_ptr) - 24usize];
    ["Offset of field: drm_mode_get_connector::count_modes"]
        [::core::mem::offset_of!(drm_mode_get_connector, count_modes) - 32usize];
    ["Offset of field: drm_mode_get_connector::count_props"]
        [::core::mem::offset_of!(drm_mode_get_connector, count_props) - 36usize];
    ["Offset of field: drm_mode_get_connector::count_encoders"]
        [::core::mem::offset_of!(drm_mode_get_connector, count_encoders) - 40usize];
    ["Offset of field: drm_mode_get_connector::encoder_id"]
        [::core::mem::offset_of!(drm_mode_get_connector, encoder_id) - 44usize];
    ["Offset of field: drm_mode_get_connector::connector_id"]
        [::core::mem::offset_of!(drm_mode_get_connector, connector_id) - 48usize];
    ["Offset of field: drm_mode_get_connector::connector_type"]
        [::core::mem::offset_of!(drm_mode_get_connector, connector_type) - 52usize];
    ["Offset of field: drm_mode_get_connector::connector_type_id"]
        [::core::mem::offset_of!(drm_mode_get_connector, connector_type_id) - 56usize];
    ["Offset of field: drm_mode_get_connector::connection"]
        [::core::mem::offset_of!(drm_mode_get_connector, connection) - 60usize];
    ["Offset of field: drm_mode_get_connector::mm_width"]
        [::core::mem::offset_of!(drm_mode_get_connector, mm_width) - 64usize];
    ["Offset of field: drm_mode_get_connector::mm_height"]
        [::core::mem::offset_of!(drm_mode_get_connector, mm_height) - 68usize];
    ["Offset of field: drm_mode_get_connector::subpixel"]
        [::core::mem::offset_of!(drm_mode_get_connector, subpixel) - 72usize];
    ["Offset of field: drm_mode_get_connector::pad"]
        [::core::mem::offset_of!(drm_mode_get_connector, pad) - 76usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_property_enum {
    pub value: __u64,
    pub name: [::core::ffi::c_char; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_property_enum"][::core::mem::size_of::<drm_mode_property_enum>() - 40usize];
    ["Alignment of drm_mode_property_enum"]
        [::core::mem::align_of::<drm_mode_property_enum>() - 8usize];
    ["Offset of field: drm_mode_property_enum::value"]
        [::core::mem::offset_of!(drm_mode_property_enum, value) - 0usize];
    ["Offset of field: drm_mode_property_enum::name"]
        [::core::mem::offset_of!(drm_mode_property_enum, name) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_property {
    pub values_ptr: __u64,
    pub enum_blob_ptr: __u64,
    pub prop_id: __u32,
    pub flags: __u32,
    pub name: [::core::ffi::c_char; 32usize],
    pub count_values: __u32,
    pub count_enum_blobs: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_property"][::core::mem::size_of::<drm_mode_get_property>() - 64usize];
    ["Alignment of drm_mode_get_property"]
        [::core::mem::align_of::<drm_mode_get_property>() - 8usize];
    ["Offset of field: drm_mode_get_property::values_ptr"]
        [::core::mem::offset_of!(drm_mode_get_property, values_ptr) - 0usize];
    ["Offset of field: drm_mode_get_property::enum_blob_ptr"]
        [::core::mem::offset_of!(drm_mode_get_property, enum_blob_ptr) - 8usize];
    ["Offset of field: drm_mode_get_property::prop_id"]
        [::core::mem::offset_of!(drm_mode_get_property, prop_id) - 16usize];
    ["Offset of field: drm_mode_get_property::flags"]
        [::core::mem::offset_of!(drm_mode_get_property, flags) - 20usize];
    ["Offset of field: drm_mode_get_property::name"]
        [::core::mem::offset_of!(drm_mode_get_property, name) - 24usize];
    ["Offset of field: drm_mode_get_property::count_values"]
        [::core::mem::offset_of!(drm_mode_get_property, count_values) - 56usize];
    ["Offset of field: drm_mode_get_property::count_enum_blobs"]
        [::core::mem::offset_of!(drm_mode_get_property, count_enum_blobs) - 60usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_connector_set_property {
    pub value: __u64,
    pub prop_id: __u32,
    pub connector_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_connector_set_property"]
        [::core::mem::size_of::<drm_mode_connector_set_property>() - 16usize];
    ["Alignment of drm_mode_connector_set_property"]
        [::core::mem::align_of::<drm_mode_connector_set_property>() - 8usize];
    ["Offset of field: drm_mode_connector_set_property::value"]
        [::core::mem::offset_of!(drm_mode_connector_set_property, value) - 0usize];
    ["Offset of field: drm_mode_connector_set_property::prop_id"]
        [::core::mem::offset_of!(drm_mode_connector_set_property, prop_id) - 8usize];
    ["Offset of field: drm_mode_connector_set_property::connector_id"]
        [::core::mem::offset_of!(drm_mode_connector_set_property, connector_id) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_obj_get_properties {
    pub props_ptr: __u64,
    pub prop_values_ptr: __u64,
    pub count_props: __u32,
    pub obj_id: __u32,
    pub obj_type: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_obj_get_properties"]
        [::core::mem::size_of::<drm_mode_obj_get_properties>() - 32usize];
    ["Alignment of drm_mode_obj_get_properties"]
        [::core::mem::align_of::<drm_mode_obj_get_properties>() - 8usize];
    ["Offset of field: drm_mode_obj_get_properties::props_ptr"]
        [::core::mem::offset_of!(drm_mode_obj_get_properties, props_ptr) - 0usize];
    ["Offset of field: drm_mode_obj_get_properties::prop_values_ptr"]
        [::core::mem::offset_of!(drm_mode_obj_get_properties, prop_values_ptr) - 8usize];
    ["Offset of field: drm_mode_obj_get_properties::count_props"]
        [::core::mem::offset_of!(drm_mode_obj_get_properties, count_props) - 16usize];
    ["Offset of field: drm_mode_obj_get_properties::obj_id"]
        [::core::mem::offset_of!(drm_mode_obj_get_properties, obj_id) - 20usize];
    ["Offset of field: drm_mode_obj_get_properties::obj_type"]
        [::core::mem::offset_of!(drm_mode_obj_get_properties, obj_type) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_obj_set_property {
    pub value: __u64,
    pub prop_id: __u32,
    pub obj_id: __u32,
    pub obj_type: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_obj_set_property"]
        [::core::mem::size_of::<drm_mode_obj_set_property>() - 24usize];
    ["Alignment of drm_mode_obj_set_property"]
        [::core::mem::align_of::<drm_mode_obj_set_property>() - 8usize];
    ["Offset of field: drm_mode_obj_set_property::value"]
        [::core::mem::offset_of!(drm_mode_obj_set_property, value) - 0usize];
    ["Offset of field: drm_mode_obj_set_property::prop_id"]
        [::core::mem::offset_of!(drm_mode_obj_set_property, prop_id) - 8usize];
    ["Offset of field: drm_mode_obj_set_property::obj_id"]
        [::core::mem::offset_of!(drm_mode_obj_set_property, obj_id) - 12usize];
    ["Offset of field: drm_mode_obj_set_property::obj_type"]
        [::core::mem::offset_of!(drm_mode_obj_set_property, obj_type) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_blob {
    pub blob_id: __u32,
    pub length: __u32,
    pub data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_blob"][::core::mem::size_of::<drm_mode_get_blob>() - 16usize];
    ["Alignment of drm_mode_get_blob"][::core::mem::align_of::<drm_mode_get_blob>() - 8usize];
    ["Offset of field: drm_mode_get_blob::blob_id"]
        [::core::mem::offset_of!(drm_mode_get_blob, blob_id) - 0usize];
    ["Offset of field: drm_mode_get_blob::length"]
        [::core::mem::offset_of!(drm_mode_get_blob, length) - 4usize];
    ["Offset of field: drm_mode_get_blob::data"]
        [::core::mem::offset_of!(drm_mode_get_blob, data) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_fb_cmd {
    pub fb_id: __u32,
    pub width: __u32,
    pub height: __u32,
    pub pitch: __u32,
    pub bpp: __u32,
    pub depth: __u32,
    pub handle: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_fb_cmd"][::core::mem::size_of::<drm_mode_fb_cmd>() - 28usize];
    ["Alignment of drm_mode_fb_cmd"][::core::mem::align_of::<drm_mode_fb_cmd>() - 4usize];
    ["Offset of field: drm_mode_fb_cmd::fb_id"]
        [::core::mem::offset_of!(drm_mode_fb_cmd, fb_id) - 0usize];
    ["Offset of field: drm_mode_fb_cmd::width"]
        [::core::mem::offset_of!(drm_mode_fb_cmd, width) - 4usize];
    ["Offset of field: drm_mode_fb_cmd::height"]
        [::core::mem::offset_of!(drm_mode_fb_cmd, height) - 8usize];
    ["Offset of field: drm_mode_fb_cmd::pitch"]
        [::core::mem::offset_of!(drm_mode_fb_cmd, pitch) - 12usize];
    ["Offset of field: drm_mode_fb_cmd::bpp"]
        [::core::mem::offset_of!(drm_mode_fb_cmd, bpp) - 16usize];
    ["Offset of field: drm_mode_fb_cmd::depth"]
        [::core::mem::offset_of!(drm_mode_fb_cmd, depth) - 20usize];
    ["Offset of field: drm_mode_fb_cmd::handle"]
        [::core::mem::offset_of!(drm_mode_fb_cmd, handle) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_fb_cmd2 {
    pub fb_id: __u32,
    pub width: __u32,
    pub height: __u32,
    pub pixel_format: __u32,
    pub flags: __u32,
    pub handles: [__u32; 4usize],
    pub pitches: [__u32; 4usize],
    pub offsets: [__u32; 4usize],
    pub modifier: [__u64; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_fb_cmd2"][::core::mem::size_of::<drm_mode_fb_cmd2>() - 104usize];
    ["Alignment of drm_mode_fb_cmd2"][::core::mem::align_of::<drm_mode_fb_cmd2>() - 8usize];
    ["Offset of field: drm_mode_fb_cmd2::fb_id"]
        [::core::mem::offset_of!(drm_mode_fb_cmd2, fb_id) - 0usize];
    ["Offset of field: drm_mode_fb_cmd2::width"]
        [::core::mem::offset_of!(drm_mode_fb_cmd2, width) - 4usize];
    ["Offset of field: drm_mode_fb_cmd2::height"]
        [::core::mem::offset_of!(drm_mode_fb_cmd2, height) - 8usize];
    ["Offset of field: drm_mode_fb_cmd2::pixel_format"]
        [::core::mem::offset_of!(drm_mode_fb_cmd2, pixel_format) - 12usize];
    ["Offset of field: drm_mode_fb_cmd2::flags"]
        [::core::mem::offset_of!(drm_mode_fb_cmd2, flags) - 16usize];
    ["Offset of field: drm_mode_fb_cmd2::handles"]
        [::core::mem::offset_of!(drm_mode_fb_cmd2, handles) - 20usize];
    ["Offset of field: drm_mode_fb_cmd2::pitches"]
        [::core::mem::offset_of!(drm_mode_fb_cmd2, pitches) - 36usize];
    ["Offset of field: drm_mode_fb_cmd2::offsets"]
        [::core::mem::offset_of!(drm_mode_fb_cmd2, offsets) - 52usize];
    ["Offset of field: drm_mode_fb_cmd2::modifier"]
        [::core::mem::offset_of!(drm_mode_fb_cmd2, modifier) - 72usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_fb_dirty_cmd {
    pub fb_id: __u32,
    pub flags: __u32,
    pub color: __u32,
    pub num_clips: __u32,
    pub clips_ptr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_fb_dirty_cmd"][::core::mem::size_of::<drm_mode_fb_dirty_cmd>() - 24usize];
    ["Alignment of drm_mode_fb_dirty_cmd"]
        [::core::mem::align_of::<drm_mode_fb_dirty_cmd>() - 8usize];
    ["Offset of field: drm_mode_fb_dirty_cmd::fb_id"]
        [::core::mem::offset_of!(drm_mode_fb_dirty_cmd, fb_id) - 0usize];
    ["Offset of field: drm_mode_fb_dirty_cmd::flags"]
        [::core::mem::offset_of!(drm_mode_fb_dirty_cmd, flags) - 4usize];
    ["Offset of field: drm_mode_fb_dirty_cmd::color"]
        [::core::mem::offset_of!(drm_mode_fb_dirty_cmd, color) - 8usize];
    ["Offset of field: drm_mode_fb_dirty_cmd::num_clips"]
        [::core::mem::offset_of!(drm_mode_fb_dirty_cmd, num_clips) - 12usize];
    ["Offset of field: drm_mode_fb_dirty_cmd::clips_ptr"]
        [::core::mem::offset_of!(drm_mode_fb_dirty_cmd, clips_ptr) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_mode_cmd {
    pub connector_id: __u32,
    pub mode: drm_mode_modeinfo,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_mode_cmd"][::core::mem::size_of::<drm_mode_mode_cmd>() - 72usize];
    ["Alignment of drm_mode_mode_cmd"][::core::mem::align_of::<drm_mode_mode_cmd>() - 4usize];
    ["Offset of field: drm_mode_mode_cmd::connector_id"]
        [::core::mem::offset_of!(drm_mode_mode_cmd, connector_id) - 0usize];
    ["Offset of field: drm_mode_mode_cmd::mode"]
        [::core::mem::offset_of!(drm_mode_mode_cmd, mode) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_cursor {
    pub flags: __u32,
    pub crtc_id: __u32,
    pub x: __s32,
    pub y: __s32,
    pub width: __u32,
    pub height: __u32,
    pub handle: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_cursor"][::core::mem::size_of::<drm_mode_cursor>() - 28usize];
    ["Alignment of drm_mode_cursor"][::core::mem::align_of::<drm_mode_cursor>() - 4usize];
    ["Offset of field: drm_mode_cursor::flags"]
        [::core::mem::offset_of!(drm_mode_cursor, flags) - 0usize];
    ["Offset of field: drm_mode_cursor::crtc_id"]
        [::core::mem::offset_of!(drm_mode_cursor, crtc_id) - 4usize];
    ["Offset of field: drm_mode_cursor::x"][::core::mem::offset_of!(drm_mode_cursor, x) - 8usize];
    ["Offset of field: drm_mode_cursor::y"][::core::mem::offset_of!(drm_mode_cursor, y) - 12usize];
    ["Offset of field: drm_mode_cursor::width"]
        [::core::mem::offset_of!(drm_mode_cursor, width) - 16usize];
    ["Offset of field: drm_mode_cursor::height"]
        [::core::mem::offset_of!(drm_mode_cursor, height) - 20usize];
    ["Offset of field: drm_mode_cursor::handle"]
        [::core::mem::offset_of!(drm_mode_cursor, handle) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_cursor2 {
    pub flags: __u32,
    pub crtc_id: __u32,
    pub x: __s32,
    pub y: __s32,
    pub width: __u32,
    pub height: __u32,
    pub handle: __u32,
    pub hot_x: __s32,
    pub hot_y: __s32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_cursor2"][::core::mem::size_of::<drm_mode_cursor2>() - 36usize];
    ["Alignment of drm_mode_cursor2"][::core::mem::align_of::<drm_mode_cursor2>() - 4usize];
    ["Offset of field: drm_mode_cursor2::flags"]
        [::core::mem::offset_of!(drm_mode_cursor2, flags) - 0usize];
    ["Offset of field: drm_mode_cursor2::crtc_id"]
        [::core::mem::offset_of!(drm_mode_cursor2, crtc_id) - 4usize];
    ["Offset of field: drm_mode_cursor2::x"][::core::mem::offset_of!(drm_mode_cursor2, x) - 8usize];
    ["Offset of field: drm_mode_cursor2::y"]
        [::core::mem::offset_of!(drm_mode_cursor2, y) - 12usize];
    ["Offset of field: drm_mode_cursor2::width"]
        [::core::mem::offset_of!(drm_mode_cursor2, width) - 16usize];
    ["Offset of field: drm_mode_cursor2::height"]
        [::core::mem::offset_of!(drm_mode_cursor2, height) - 20usize];
    ["Offset of field: drm_mode_cursor2::handle"]
        [::core::mem::offset_of!(drm_mode_cursor2, handle) - 24usize];
    ["Offset of field: drm_mode_cursor2::hot_x"]
        [::core::mem::offset_of!(drm_mode_cursor2, hot_x) - 28usize];
    ["Offset of field: drm_mode_cursor2::hot_y"]
        [::core::mem::offset_of!(drm_mode_cursor2, hot_y) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_crtc_lut {
    pub crtc_id: __u32,
    pub gamma_size: __u32,
    pub red: __u64,
    pub green: __u64,
    pub blue: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_crtc_lut"][::core::mem::size_of::<drm_mode_crtc_lut>() - 32usize];
    ["Alignment of drm_mode_crtc_lut"][::core::mem::align_of::<drm_mode_crtc_lut>() - 8usize];
    ["Offset of field: drm_mode_crtc_lut::crtc_id"]
        [::core::mem::offset_of!(drm_mode_crtc_lut, crtc_id) - 0usize];
    ["Offset of field: drm_mode_crtc_lut::gamma_size"]
        [::core::mem::offset_of!(drm_mode_crtc_lut, gamma_size) - 4usize];
    ["Offset of field: drm_mode_crtc_lut::red"]
        [::core::mem::offset_of!(drm_mode_crtc_lut, red) - 8usize];
    ["Offset of field: drm_mode_crtc_lut::green"]
        [::core::mem::offset_of!(drm_mode_crtc_lut, green) - 16usize];
    ["Offset of field: drm_mode_crtc_lut::blue"]
        [::core::mem::offset_of!(drm_mode_crtc_lut, blue) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_color_ctm {
    pub matrix: [__u64; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_color_ctm"][::core::mem::size_of::<drm_color_ctm>() - 72usize];
    ["Alignment of drm_color_ctm"][::core::mem::align_of::<drm_color_ctm>() - 8usize];
    ["Offset of field: drm_color_ctm::matrix"]
        [::core::mem::offset_of!(drm_color_ctm, matrix) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_color_lut {
    pub red: __u16,
    pub green: __u16,
    pub blue: __u16,
    pub reserved: __u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_color_lut"][::core::mem::size_of::<drm_color_lut>() - 8usize];
    ["Alignment of drm_color_lut"][::core::mem::align_of::<drm_color_lut>() - 2usize];
    ["Offset of field: drm_color_lut::red"][::core::mem::offset_of!(drm_color_lut, red) - 0usize];
    ["Offset of field: drm_color_lut::green"]
        [::core::mem::offset_of!(drm_color_lut, green) - 2usize];
    ["Offset of field: drm_color_lut::blue"][::core::mem::offset_of!(drm_color_lut, blue) - 4usize];
    ["Offset of field: drm_color_lut::reserved"]
        [::core::mem::offset_of!(drm_color_lut, reserved) - 6usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hdr_metadata_infoframe {
    pub eotf: __u8,
    pub metadata_type: __u8,
    pub display_primaries: [hdr_metadata_infoframe__bindgen_ty_1; 3usize],
    pub white_point: hdr_metadata_infoframe__bindgen_ty_2,
    pub max_display_mastering_luminance: __u16,
    pub min_display_mastering_luminance: __u16,
    pub max_cll: __u16,
    pub max_fall: __u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hdr_metadata_infoframe__bindgen_ty_1 {
    pub x: __u16,
    pub y: __u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hdr_metadata_infoframe__bindgen_ty_1"]
        [::core::mem::size_of::<hdr_metadata_infoframe__bindgen_ty_1>() - 4usize];
    ["Alignment of hdr_metadata_infoframe__bindgen_ty_1"]
        [::core::mem::align_of::<hdr_metadata_infoframe__bindgen_ty_1>() - 2usize];
    ["Offset of field: hdr_metadata_infoframe__bindgen_ty_1::x"]
        [::core::mem::offset_of!(hdr_metadata_infoframe__bindgen_ty_1, x) - 0usize];
    ["Offset of field: hdr_metadata_infoframe__bindgen_ty_1::y"]
        [::core::mem::offset_of!(hdr_metadata_infoframe__bindgen_ty_1, y) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hdr_metadata_infoframe__bindgen_ty_2 {
    pub x: __u16,
    pub y: __u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hdr_metadata_infoframe__bindgen_ty_2"]
        [::core::mem::size_of::<hdr_metadata_infoframe__bindgen_ty_2>() - 4usize];
    ["Alignment of hdr_metadata_infoframe__bindgen_ty_2"]
        [::core::mem::align_of::<hdr_metadata_infoframe__bindgen_ty_2>() - 2usize];
    ["Offset of field: hdr_metadata_infoframe__bindgen_ty_2::x"]
        [::core::mem::offset_of!(hdr_metadata_infoframe__bindgen_ty_2, x) - 0usize];
    ["Offset of field: hdr_metadata_infoframe__bindgen_ty_2::y"]
        [::core::mem::offset_of!(hdr_metadata_infoframe__bindgen_ty_2, y) - 2usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hdr_metadata_infoframe"][::core::mem::size_of::<hdr_metadata_infoframe>() - 26usize];
    ["Alignment of hdr_metadata_infoframe"]
        [::core::mem::align_of::<hdr_metadata_infoframe>() - 2usize];
    ["Offset of field: hdr_metadata_infoframe::eotf"]
        [::core::mem::offset_of!(hdr_metadata_infoframe, eotf) - 0usize];
    ["Offset of field: hdr_metadata_infoframe::metadata_type"]
        [::core::mem::offset_of!(hdr_metadata_infoframe, metadata_type) - 1usize];
    ["Offset of field: hdr_metadata_infoframe::display_primaries"]
        [::core::mem::offset_of!(hdr_metadata_infoframe, display_primaries) - 2usize];
    ["Offset of field: hdr_metadata_infoframe::white_point"]
        [::core::mem::offset_of!(hdr_metadata_infoframe, white_point) - 14usize];
    ["Offset of field: hdr_metadata_infoframe::max_display_mastering_luminance"][::core::mem::offset_of!(
        hdr_metadata_infoframe,
        max_display_mastering_luminance
    ) - 18usize];
    ["Offset of field: hdr_metadata_infoframe::min_display_mastering_luminance"][::core::mem::offset_of!(
        hdr_metadata_infoframe,
        min_display_mastering_luminance
    ) - 20usize];
    ["Offset of field: hdr_metadata_infoframe::max_cll"]
        [::core::mem::offset_of!(hdr_metadata_infoframe, max_cll) - 22usize];
    ["Offset of field: hdr_metadata_infoframe::max_fall"]
        [::core::mem::offset_of!(hdr_metadata_infoframe, max_fall) - 24usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hdr_output_metadata {
    pub metadata_type: __u32,
    pub __bindgen_anon_1: hdr_output_metadata__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hdr_output_metadata__bindgen_ty_1 {
    pub hdmi_metadata_type1: hdr_metadata_infoframe,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hdr_output_metadata__bindgen_ty_1"]
        [::core::mem::size_of::<hdr_output_metadata__bindgen_ty_1>() - 26usize];
    ["Alignment of hdr_output_metadata__bindgen_ty_1"]
        [::core::mem::align_of::<hdr_output_metadata__bindgen_ty_1>() - 2usize];
    ["Offset of field: hdr_output_metadata__bindgen_ty_1::hdmi_metadata_type1"]
        [::core::mem::offset_of!(hdr_output_metadata__bindgen_ty_1, hdmi_metadata_type1) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hdr_output_metadata"][::core::mem::size_of::<hdr_output_metadata>() - 32usize];
    ["Alignment of hdr_output_metadata"][::core::mem::align_of::<hdr_output_metadata>() - 4usize];
    ["Offset of field: hdr_output_metadata::metadata_type"]
        [::core::mem::offset_of!(hdr_output_metadata, metadata_type) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_crtc_page_flip {
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub flags: __u32,
    pub reserved: __u32,
    pub user_data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_crtc_page_flip"]
        [::core::mem::size_of::<drm_mode_crtc_page_flip>() - 24usize];
    ["Alignment of drm_mode_crtc_page_flip"]
        [::core::mem::align_of::<drm_mode_crtc_page_flip>() - 8usize];
    ["Offset of field: drm_mode_crtc_page_flip::crtc_id"]
        [::core::mem::offset_of!(drm_mode_crtc_page_flip, crtc_id) - 0usize];
    ["Offset of field: drm_mode_crtc_page_flip::fb_id"]
        [::core::mem::offset_of!(drm_mode_crtc_page_flip, fb_id) - 4usize];
    ["Offset of field: drm_mode_crtc_page_flip::flags"]
        [::core::mem::offset_of!(drm_mode_crtc_page_flip, flags) - 8usize];
    ["Offset of field: drm_mode_crtc_page_flip::reserved"]
        [::core::mem::offset_of!(drm_mode_crtc_page_flip, reserved) - 12usize];
    ["Offset of field: drm_mode_crtc_page_flip::user_data"]
        [::core::mem::offset_of!(drm_mode_crtc_page_flip, user_data) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_crtc_page_flip_target {
    pub crtc_id: __u32,
    pub fb_id: __u32,
    pub flags: __u32,
    pub sequence: __u32,
    pub user_data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_crtc_page_flip_target"]
        [::core::mem::size_of::<drm_mode_crtc_page_flip_target>() - 24usize];
    ["Alignment of drm_mode_crtc_page_flip_target"]
        [::core::mem::align_of::<drm_mode_crtc_page_flip_target>() - 8usize];
    ["Offset of field: drm_mode_crtc_page_flip_target::crtc_id"]
        [::core::mem::offset_of!(drm_mode_crtc_page_flip_target, crtc_id) - 0usize];
    ["Offset of field: drm_mode_crtc_page_flip_target::fb_id"]
        [::core::mem::offset_of!(drm_mode_crtc_page_flip_target, fb_id) - 4usize];
    ["Offset of field: drm_mode_crtc_page_flip_target::flags"]
        [::core::mem::offset_of!(drm_mode_crtc_page_flip_target, flags) - 8usize];
    ["Offset of field: drm_mode_crtc_page_flip_target::sequence"]
        [::core::mem::offset_of!(drm_mode_crtc_page_flip_target, sequence) - 12usize];
    ["Offset of field: drm_mode_crtc_page_flip_target::user_data"]
        [::core::mem::offset_of!(drm_mode_crtc_page_flip_target, user_data) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_create_dumb {
    pub height: __u32,
    pub width: __u32,
    pub bpp: __u32,
    pub flags: __u32,
    pub handle: __u32,
    pub pitch: __u32,
    pub size: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_create_dumb"][::core::mem::size_of::<drm_mode_create_dumb>() - 32usize];
    ["Alignment of drm_mode_create_dumb"][::core::mem::align_of::<drm_mode_create_dumb>() - 8usize];
    ["Offset of field: drm_mode_create_dumb::height"]
        [::core::mem::offset_of!(drm_mode_create_dumb, height) - 0usize];
    ["Offset of field: drm_mode_create_dumb::width"]
        [::core::mem::offset_of!(drm_mode_create_dumb, width) - 4usize];
    ["Offset of field: drm_mode_create_dumb::bpp"]
        [::core::mem::offset_of!(drm_mode_create_dumb, bpp) - 8usize];
    ["Offset of field: drm_mode_create_dumb::flags"]
        [::core::mem::offset_of!(drm_mode_create_dumb, flags) - 12usize];
    ["Offset of field: drm_mode_create_dumb::handle"]
        [::core::mem::offset_of!(drm_mode_create_dumb, handle) - 16usize];
    ["Offset of field: drm_mode_create_dumb::pitch"]
        [::core::mem::offset_of!(drm_mode_create_dumb, pitch) - 20usize];
    ["Offset of field: drm_mode_create_dumb::size"]
        [::core::mem::offset_of!(drm_mode_create_dumb, size) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_map_dumb {
    pub handle: __u32,
    pub pad: __u32,
    pub offset: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_map_dumb"][::core::mem::size_of::<drm_mode_map_dumb>() - 16usize];
    ["Alignment of drm_mode_map_dumb"][::core::mem::align_of::<drm_mode_map_dumb>() - 8usize];
    ["Offset of field: drm_mode_map_dumb::handle"]
        [::core::mem::offset_of!(drm_mode_map_dumb, handle) - 0usize];
    ["Offset of field: drm_mode_map_dumb::pad"]
        [::core::mem::offset_of!(drm_mode_map_dumb, pad) - 4usize];
    ["Offset of field: drm_mode_map_dumb::offset"]
        [::core::mem::offset_of!(drm_mode_map_dumb, offset) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_destroy_dumb {
    pub handle: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_destroy_dumb"][::core::mem::size_of::<drm_mode_destroy_dumb>() - 4usize];
    ["Alignment of drm_mode_destroy_dumb"]
        [::core::mem::align_of::<drm_mode_destroy_dumb>() - 4usize];
    ["Offset of field: drm_mode_destroy_dumb::handle"]
        [::core::mem::offset_of!(drm_mode_destroy_dumb, handle) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_atomic {
    pub flags: __u32,
    pub count_objs: __u32,
    pub objs_ptr: __u64,
    pub count_props_ptr: __u64,
    pub props_ptr: __u64,
    pub prop_values_ptr: __u64,
    pub reserved: __u64,
    pub user_data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_atomic"][::core::mem::size_of::<drm_mode_atomic>() - 56usize];
    ["Alignment of drm_mode_atomic"][::core::mem::align_of::<drm_mode_atomic>() - 8usize];
    ["Offset of field: drm_mode_atomic::flags"]
        [::core::mem::offset_of!(drm_mode_atomic, flags) - 0usize];
    ["Offset of field: drm_mode_atomic::count_objs"]
        [::core::mem::offset_of!(drm_mode_atomic, count_objs) - 4usize];
    ["Offset of field: drm_mode_atomic::objs_ptr"]
        [::core::mem::offset_of!(drm_mode_atomic, objs_ptr) - 8usize];
    ["Offset of field: drm_mode_atomic::count_props_ptr"]
        [::core::mem::offset_of!(drm_mode_atomic, count_props_ptr) - 16usize];
    ["Offset of field: drm_mode_atomic::props_ptr"]
        [::core::mem::offset_of!(drm_mode_atomic, props_ptr) - 24usize];
    ["Offset of field: drm_mode_atomic::prop_values_ptr"]
        [::core::mem::offset_of!(drm_mode_atomic, prop_values_ptr) - 32usize];
    ["Offset of field: drm_mode_atomic::reserved"]
        [::core::mem::offset_of!(drm_mode_atomic, reserved) - 40usize];
    ["Offset of field: drm_mode_atomic::user_data"]
        [::core::mem::offset_of!(drm_mode_atomic, user_data) - 48usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_format_modifier_blob {
    pub version: __u32,
    pub flags: __u32,
    pub count_formats: __u32,
    pub formats_offset: __u32,
    pub count_modifiers: __u32,
    pub modifiers_offset: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_format_modifier_blob"]
        [::core::mem::size_of::<drm_format_modifier_blob>() - 24usize];
    ["Alignment of drm_format_modifier_blob"]
        [::core::mem::align_of::<drm_format_modifier_blob>() - 4usize];
    ["Offset of field: drm_format_modifier_blob::version"]
        [::core::mem::offset_of!(drm_format_modifier_blob, version) - 0usize];
    ["Offset of field: drm_format_modifier_blob::flags"]
        [::core::mem::offset_of!(drm_format_modifier_blob, flags) - 4usize];
    ["Offset of field: drm_format_modifier_blob::count_formats"]
        [::core::mem::offset_of!(drm_format_modifier_blob, count_formats) - 8usize];
    ["Offset of field: drm_format_modifier_blob::formats_offset"]
        [::core::mem::offset_of!(drm_format_modifier_blob, formats_offset) - 12usize];
    ["Offset of field: drm_format_modifier_blob::count_modifiers"]
        [::core::mem::offset_of!(drm_format_modifier_blob, count_modifiers) - 16usize];
    ["Offset of field: drm_format_modifier_blob::modifiers_offset"]
        [::core::mem::offset_of!(drm_format_modifier_blob, modifiers_offset) - 20usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_format_modifier {
    pub formats: __u64,
    pub offset: __u32,
    pub pad: __u32,
    pub modifier: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_format_modifier"][::core::mem::size_of::<drm_format_modifier>() - 24usize];
    ["Alignment of drm_format_modifier"][::core::mem::align_of::<drm_format_modifier>() - 8usize];
    ["Offset of field: drm_format_modifier::formats"]
        [::core::mem::offset_of!(drm_format_modifier, formats) - 0usize];
    ["Offset of field: drm_format_modifier::offset"]
        [::core::mem::offset_of!(drm_format_modifier, offset) - 8usize];
    ["Offset of field: drm_format_modifier::pad"]
        [::core::mem::offset_of!(drm_format_modifier, pad) - 12usize];
    ["Offset of field: drm_format_modifier::modifier"]
        [::core::mem::offset_of!(drm_format_modifier, modifier) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_create_blob {
    pub data: __u64,
    pub length: __u32,
    pub blob_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_create_blob"][::core::mem::size_of::<drm_mode_create_blob>() - 16usize];
    ["Alignment of drm_mode_create_blob"][::core::mem::align_of::<drm_mode_create_blob>() - 8usize];
    ["Offset of field: drm_mode_create_blob::data"]
        [::core::mem::offset_of!(drm_mode_create_blob, data) - 0usize];
    ["Offset of field: drm_mode_create_blob::length"]
        [::core::mem::offset_of!(drm_mode_create_blob, length) - 8usize];
    ["Offset of field: drm_mode_create_blob::blob_id"]
        [::core::mem::offset_of!(drm_mode_create_blob, blob_id) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_destroy_blob {
    pub blob_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_destroy_blob"][::core::mem::size_of::<drm_mode_destroy_blob>() - 4usize];
    ["Alignment of drm_mode_destroy_blob"]
        [::core::mem::align_of::<drm_mode_destroy_blob>() - 4usize];
    ["Offset of field: drm_mode_destroy_blob::blob_id"]
        [::core::mem::offset_of!(drm_mode_destroy_blob, blob_id) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_create_lease {
    pub object_ids: __u64,
    pub object_count: __u32,
    pub flags: __u32,
    pub lessee_id: __u32,
    pub fd: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_create_lease"][::core::mem::size_of::<drm_mode_create_lease>() - 24usize];
    ["Alignment of drm_mode_create_lease"]
        [::core::mem::align_of::<drm_mode_create_lease>() - 8usize];
    ["Offset of field: drm_mode_create_lease::object_ids"]
        [::core::mem::offset_of!(drm_mode_create_lease, object_ids) - 0usize];
    ["Offset of field: drm_mode_create_lease::object_count"]
        [::core::mem::offset_of!(drm_mode_create_lease, object_count) - 8usize];
    ["Offset of field: drm_mode_create_lease::flags"]
        [::core::mem::offset_of!(drm_mode_create_lease, flags) - 12usize];
    ["Offset of field: drm_mode_create_lease::lessee_id"]
        [::core::mem::offset_of!(drm_mode_create_lease, lessee_id) - 16usize];
    ["Offset of field: drm_mode_create_lease::fd"]
        [::core::mem::offset_of!(drm_mode_create_lease, fd) - 20usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_list_lessees {
    pub count_lessees: __u32,
    pub pad: __u32,
    pub lessees_ptr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_list_lessees"][::core::mem::size_of::<drm_mode_list_lessees>() - 16usize];
    ["Alignment of drm_mode_list_lessees"]
        [::core::mem::align_of::<drm_mode_list_lessees>() - 8usize];
    ["Offset of field: drm_mode_list_lessees::count_lessees"]
        [::core::mem::offset_of!(drm_mode_list_lessees, count_lessees) - 0usize];
    ["Offset of field: drm_mode_list_lessees::pad"]
        [::core::mem::offset_of!(drm_mode_list_lessees, pad) - 4usize];
    ["Offset of field: drm_mode_list_lessees::lessees_ptr"]
        [::core::mem::offset_of!(drm_mode_list_lessees, lessees_ptr) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_get_lease {
    pub count_objects: __u32,
    pub pad: __u32,
    pub objects_ptr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_get_lease"][::core::mem::size_of::<drm_mode_get_lease>() - 16usize];
    ["Alignment of drm_mode_get_lease"][::core::mem::align_of::<drm_mode_get_lease>() - 8usize];
    ["Offset of field: drm_mode_get_lease::count_objects"]
        [::core::mem::offset_of!(drm_mode_get_lease, count_objects) - 0usize];
    ["Offset of field: drm_mode_get_lease::pad"]
        [::core::mem::offset_of!(drm_mode_get_lease, pad) - 4usize];
    ["Offset of field: drm_mode_get_lease::objects_ptr"]
        [::core::mem::offset_of!(drm_mode_get_lease, objects_ptr) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_revoke_lease {
    pub lessee_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_revoke_lease"][::core::mem::size_of::<drm_mode_revoke_lease>() - 4usize];
    ["Alignment of drm_mode_revoke_lease"]
        [::core::mem::align_of::<drm_mode_revoke_lease>() - 4usize];
    ["Offset of field: drm_mode_revoke_lease::lessee_id"]
        [::core::mem::offset_of!(drm_mode_revoke_lease, lessee_id) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_rect {
    pub x1: __s32,
    pub y1: __s32,
    pub x2: __s32,
    pub y2: __s32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_rect"][::core::mem::size_of::<drm_mode_rect>() - 16usize];
    ["Alignment of drm_mode_rect"][::core::mem::align_of::<drm_mode_rect>() - 4usize];
    ["Offset of field: drm_mode_rect::x1"][::core::mem::offset_of!(drm_mode_rect, x1) - 0usize];
    ["Offset of field: drm_mode_rect::y1"][::core::mem::offset_of!(drm_mode_rect, y1) - 4usize];
    ["Offset of field: drm_mode_rect::x2"][::core::mem::offset_of!(drm_mode_rect, x2) - 8usize];
    ["Offset of field: drm_mode_rect::y2"][::core::mem::offset_of!(drm_mode_rect, y2) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_mode_closefb {
    pub fb_id: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_mode_closefb"][::core::mem::size_of::<drm_mode_closefb>() - 8usize];
    ["Alignment of drm_mode_closefb"][::core::mem::align_of::<drm_mode_closefb>() - 4usize];
    ["Offset of field: drm_mode_closefb::fb_id"]
        [::core::mem::offset_of!(drm_mode_closefb, fb_id) - 0usize];
    ["Offset of field: drm_mode_closefb::pad"]
        [::core::mem::offset_of!(drm_mode_closefb, pad) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_event {
    pub type_: __u32,
    pub length: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_event"][::core::mem::size_of::<drm_event>() - 8usize];
    ["Alignment of drm_event"][::core::mem::align_of::<drm_event>() - 4usize];
    ["Offset of field: drm_event::type_"][::core::mem::offset_of!(drm_event, type_) - 0usize];
    ["Offset of field: drm_event::length"][::core::mem::offset_of!(drm_event, length) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_event_vblank {
    pub base: drm_event,
    pub user_data: __u64,
    pub tv_sec: __u32,
    pub tv_usec: __u32,
    pub sequence: __u32,
    pub crtc_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_event_vblank"][::core::mem::size_of::<drm_event_vblank>() - 32usize];
    ["Alignment of drm_event_vblank"][::core::mem::align_of::<drm_event_vblank>() - 8usize];
    ["Offset of field: drm_event_vblank::base"]
        [::core::mem::offset_of!(drm_event_vblank, base) - 0usize];
    ["Offset of field: drm_event_vblank::user_data"]
        [::core::mem::offset_of!(drm_event_vblank, user_data) - 8usize];
    ["Offset of field: drm_event_vblank::tv_sec"]
        [::core::mem::offset_of!(drm_event_vblank, tv_sec) - 16usize];
    ["Offset of field: drm_event_vblank::tv_usec"]
        [::core::mem::offset_of!(drm_event_vblank, tv_usec) - 20usize];
    ["Offset of field: drm_event_vblank::sequence"]
        [::core::mem::offset_of!(drm_event_vblank, sequence) - 24usize];
    ["Offset of field: drm_event_vblank::crtc_id"]
        [::core::mem::offset_of!(drm_event_vblank, crtc_id) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_event_crtc_sequence {
    pub base: drm_event,
    pub user_data: __u64,
    pub time_ns: __s64,
    pub sequence: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_event_crtc_sequence"]
        [::core::mem::size_of::<drm_event_crtc_sequence>() - 32usize];
    ["Alignment of drm_event_crtc_sequence"]
        [::core::mem::align_of::<drm_event_crtc_sequence>() - 8usize];
    ["Offset of field: drm_event_crtc_sequence::base"]
        [::core::mem::offset_of!(drm_event_crtc_sequence, base) - 0usize];
    ["Offset of field: drm_event_crtc_sequence::user_data"]
        [::core::mem::offset_of!(drm_event_crtc_sequence, user_data) - 8usize];
    ["Offset of field: drm_event_crtc_sequence::time_ns"]
        [::core::mem::offset_of!(drm_event_crtc_sequence, time_ns) - 16usize];
    ["Offset of field: drm_event_crtc_sequence::sequence"]
        [::core::mem::offset_of!(drm_event_crtc_sequence, sequence) - 24usize];
};
pub type drm_clip_rect_t = drm_clip_rect;
pub type drm_drawable_info_t = drm_drawable_info;
pub type drm_tex_region_t = drm_tex_region;
pub type drm_hw_lock_t = drm_hw_lock;
pub type drm_version_t = drm_version;
pub type drm_unique_t = drm_unique;
pub type drm_list_t = drm_list;
pub type drm_block_t = drm_block;
pub type drm_control_t = drm_control;
pub use self::drm_map_flags as drm_map_flags_t;
pub use self::drm_map_type as drm_map_type_t;
pub type drm_ctx_priv_map_t = drm_ctx_priv_map;
pub type drm_map_t = drm_map;
pub type drm_client_t = drm_client;
pub use self::drm_stat_type as drm_stat_type_t;
pub type drm_stats_t = drm_stats;
pub use self::drm_lock_flags as drm_lock_flags_t;
pub type drm_lock_t = drm_lock;
pub use self::drm_dma_flags as drm_dma_flags_t;
pub type drm_buf_desc_t = drm_buf_desc;
pub type drm_buf_info_t = drm_buf_info;
pub type drm_buf_free_t = drm_buf_free;
pub type drm_buf_pub_t = drm_buf_pub;
pub type drm_buf_map_t = drm_buf_map;
pub type drm_dma_t = drm_dma;
pub type drm_wait_vblank_t = drm_wait_vblank;
pub type drm_agp_mode_t = drm_agp_mode;
pub use self::drm_ctx_flags as drm_ctx_flags_t;
pub type drm_ctx_t = drm_ctx;
pub type drm_ctx_res_t = drm_ctx_res;
pub type drm_draw_t = drm_draw;
pub type drm_update_draw_t = drm_update_draw;
pub type drm_auth_t = drm_auth;
pub type drm_irq_busid_t = drm_irq_busid;
pub use self::drm_vblank_seq_type as drm_vblank_seq_type_t;
pub type drm_agp_buffer_t = drm_agp_buffer;
pub type drm_agp_binding_t = drm_agp_binding;
pub type drm_agp_info_t = drm_agp_info;
pub type drm_scatter_gather_t = drm_scatter_gather;
pub type drm_set_version_t = drm_set_version;
pub type drmSize = ::core::ffi::c_uint;
pub type drmSizePtr = *mut ::core::ffi::c_uint;
pub type drmAddress = *mut ::core::ffi::c_void;
pub type drmAddressPtr = *mut *mut ::core::ffi::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmServerInfo {
    pub debug_print: ::core::option::Option<
        unsafe extern "C" fn(
            format: *const ::core::ffi::c_char,
            ap: *mut __va_list_tag,
        ) -> ::core::ffi::c_int,
    >,
    pub load_module: ::core::option::Option<
        unsafe extern "C" fn(name: *const ::core::ffi::c_char) -> ::core::ffi::c_int,
    >,
    pub get_perms:
        ::core::option::Option<unsafe extern "C" fn(arg1: *mut gid_t, arg2: *mut mode_t)>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmServerInfo"][::core::mem::size_of::<_drmServerInfo>() - 24usize];
    ["Alignment of _drmServerInfo"][::core::mem::align_of::<_drmServerInfo>() - 8usize];
    ["Offset of field: _drmServerInfo::debug_print"]
        [::core::mem::offset_of!(_drmServerInfo, debug_print) - 0usize];
    ["Offset of field: _drmServerInfo::load_module"]
        [::core::mem::offset_of!(_drmServerInfo, load_module) - 8usize];
    ["Offset of field: _drmServerInfo::get_perms"]
        [::core::mem::offset_of!(_drmServerInfo, get_perms) - 16usize];
};
pub type drmServerInfo = _drmServerInfo;
pub type drmServerInfoPtr = *mut _drmServerInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drmHashEntry {
    pub fd: ::core::ffi::c_int,
    pub f: ::core::option::Option<
        unsafe extern "C" fn(
            arg1: ::core::ffi::c_int,
            arg2: *mut ::core::ffi::c_void,
            arg3: *mut ::core::ffi::c_void,
        ),
    >,
    pub tagTable: *mut ::core::ffi::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drmHashEntry"][::core::mem::size_of::<drmHashEntry>() - 24usize];
    ["Alignment of drmHashEntry"][::core::mem::align_of::<drmHashEntry>() - 8usize];
    ["Offset of field: drmHashEntry::fd"][::core::mem::offset_of!(drmHashEntry, fd) - 0usize];
    ["Offset of field: drmHashEntry::f"][::core::mem::offset_of!(drmHashEntry, f) - 8usize];
    ["Offset of field: drmHashEntry::tagTable"]
        [::core::mem::offset_of!(drmHashEntry, tagTable) - 16usize];
};
extern "C" {
    pub fn drmIoctl(
        fd: ::core::ffi::c_int,
        request: ::core::ffi::c_ulong,
        arg: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetHashTable() -> *mut ::core::ffi::c_void;
}
extern "C" {
    pub fn drmGetEntry(fd: ::core::ffi::c_int) -> *mut drmHashEntry;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmVersion {
    pub version_major: ::core::ffi::c_int,
    pub version_minor: ::core::ffi::c_int,
    pub version_patchlevel: ::core::ffi::c_int,
    pub name_len: ::core::ffi::c_int,
    pub name: *mut ::core::ffi::c_char,
    pub date_len: ::core::ffi::c_int,
    pub date: *mut ::core::ffi::c_char,
    pub desc_len: ::core::ffi::c_int,
    pub desc: *mut ::core::ffi::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmVersion"][::core::mem::size_of::<_drmVersion>() - 56usize];
    ["Alignment of _drmVersion"][::core::mem::align_of::<_drmVersion>() - 8usize];
    ["Offset of field: _drmVersion::version_major"]
        [::core::mem::offset_of!(_drmVersion, version_major) - 0usize];
    ["Offset of field: _drmVersion::version_minor"]
        [::core::mem::offset_of!(_drmVersion, version_minor) - 4usize];
    ["Offset of field: _drmVersion::version_patchlevel"]
        [::core::mem::offset_of!(_drmVersion, version_patchlevel) - 8usize];
    ["Offset of field: _drmVersion::name_len"]
        [::core::mem::offset_of!(_drmVersion, name_len) - 12usize];
    ["Offset of field: _drmVersion::name"][::core::mem::offset_of!(_drmVersion, name) - 16usize];
    ["Offset of field: _drmVersion::date_len"]
        [::core::mem::offset_of!(_drmVersion, date_len) - 24usize];
    ["Offset of field: _drmVersion::date"][::core::mem::offset_of!(_drmVersion, date) - 32usize];
    ["Offset of field: _drmVersion::desc_len"]
        [::core::mem::offset_of!(_drmVersion, desc_len) - 40usize];
    ["Offset of field: _drmVersion::desc"][::core::mem::offset_of!(_drmVersion, desc) - 48usize];
};
pub type drmVersion = _drmVersion;
pub type drmVersionPtr = *mut _drmVersion;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmStats {
    pub count: ::core::ffi::c_ulong,
    pub data: [_drmStats__bindgen_ty_1; 15usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmStats__bindgen_ty_1 {
    pub value: ::core::ffi::c_ulong,
    pub long_format: *const ::core::ffi::c_char,
    pub long_name: *const ::core::ffi::c_char,
    pub rate_format: *const ::core::ffi::c_char,
    pub rate_name: *const ::core::ffi::c_char,
    pub isvalue: ::core::ffi::c_int,
    pub mult_names: *const ::core::ffi::c_char,
    pub mult: ::core::ffi::c_int,
    pub verbose: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmStats__bindgen_ty_1"]
        [::core::mem::size_of::<_drmStats__bindgen_ty_1>() - 64usize];
    ["Alignment of _drmStats__bindgen_ty_1"]
        [::core::mem::align_of::<_drmStats__bindgen_ty_1>() - 8usize];
    ["Offset of field: _drmStats__bindgen_ty_1::value"]
        [::core::mem::offset_of!(_drmStats__bindgen_ty_1, value) - 0usize];
    ["Offset of field: _drmStats__bindgen_ty_1::long_format"]
        [::core::mem::offset_of!(_drmStats__bindgen_ty_1, long_format) - 8usize];
    ["Offset of field: _drmStats__bindgen_ty_1::long_name"]
        [::core::mem::offset_of!(_drmStats__bindgen_ty_1, long_name) - 16usize];
    ["Offset of field: _drmStats__bindgen_ty_1::rate_format"]
        [::core::mem::offset_of!(_drmStats__bindgen_ty_1, rate_format) - 24usize];
    ["Offset of field: _drmStats__bindgen_ty_1::rate_name"]
        [::core::mem::offset_of!(_drmStats__bindgen_ty_1, rate_name) - 32usize];
    ["Offset of field: _drmStats__bindgen_ty_1::isvalue"]
        [::core::mem::offset_of!(_drmStats__bindgen_ty_1, isvalue) - 40usize];
    ["Offset of field: _drmStats__bindgen_ty_1::mult_names"]
        [::core::mem::offset_of!(_drmStats__bindgen_ty_1, mult_names) - 48usize];
    ["Offset of field: _drmStats__bindgen_ty_1::mult"]
        [::core::mem::offset_of!(_drmStats__bindgen_ty_1, mult) - 56usize];
    ["Offset of field: _drmStats__bindgen_ty_1::verbose"]
        [::core::mem::offset_of!(_drmStats__bindgen_ty_1, verbose) - 60usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmStats"][::core::mem::size_of::<_drmStats>() - 968usize];
    ["Alignment of _drmStats"][::core::mem::align_of::<_drmStats>() - 8usize];
    ["Offset of field: _drmStats::count"][::core::mem::offset_of!(_drmStats, count) - 0usize];
    ["Offset of field: _drmStats::data"][::core::mem::offset_of!(_drmStats, data) - 8usize];
};
pub type drmStatsT = _drmStats;
pub const drmMapType_DRM_FRAME_BUFFER: drmMapType = 0;
pub const drmMapType_DRM_REGISTERS: drmMapType = 1;
pub const drmMapType_DRM_SHM: drmMapType = 2;
pub const drmMapType_DRM_AGP: drmMapType = 3;
pub const drmMapType_DRM_SCATTER_GATHER: drmMapType = 4;
pub const drmMapType_DRM_CONSISTENT: drmMapType = 5;
pub type drmMapType = ::core::ffi::c_uint;
pub const drmMapFlags_DRM_RESTRICTED: drmMapFlags = 1;
pub const drmMapFlags_DRM_READ_ONLY: drmMapFlags = 2;
pub const drmMapFlags_DRM_LOCKED: drmMapFlags = 4;
pub const drmMapFlags_DRM_KERNEL: drmMapFlags = 8;
pub const drmMapFlags_DRM_WRITE_COMBINING: drmMapFlags = 16;
pub const drmMapFlags_DRM_CONTAINS_LOCK: drmMapFlags = 32;
pub const drmMapFlags_DRM_REMOVABLE: drmMapFlags = 64;
pub type drmMapFlags = ::core::ffi::c_uint;
pub const drmDMAFlags_DRM_DMA_BLOCK: drmDMAFlags = 1;
pub const drmDMAFlags_DRM_DMA_WHILE_LOCKED: drmDMAFlags = 2;
pub const drmDMAFlags_DRM_DMA_PRIORITY: drmDMAFlags = 4;
pub const drmDMAFlags_DRM_DMA_WAIT: drmDMAFlags = 16;
pub const drmDMAFlags_DRM_DMA_SMALLER_OK: drmDMAFlags = 32;
pub const drmDMAFlags_DRM_DMA_LARGER_OK: drmDMAFlags = 64;
pub type drmDMAFlags = ::core::ffi::c_uint;
pub const drmBufDescFlags_DRM_PAGE_ALIGN: drmBufDescFlags = 1;
pub const drmBufDescFlags_DRM_AGP_BUFFER: drmBufDescFlags = 2;
pub const drmBufDescFlags_DRM_SG_BUFFER: drmBufDescFlags = 4;
pub const drmBufDescFlags_DRM_FB_BUFFER: drmBufDescFlags = 8;
pub const drmBufDescFlags_DRM_PCI_BUFFER_RO: drmBufDescFlags = 16;
pub type drmBufDescFlags = ::core::ffi::c_uint;
pub const drmLockFlags_DRM_LOCK_READY: drmLockFlags = 1;
pub const drmLockFlags_DRM_LOCK_QUIESCENT: drmLockFlags = 2;
pub const drmLockFlags_DRM_LOCK_FLUSH: drmLockFlags = 4;
pub const drmLockFlags_DRM_LOCK_FLUSH_ALL: drmLockFlags = 8;
pub const drmLockFlags_DRM_HALT_ALL_QUEUES: drmLockFlags = 16;
pub const drmLockFlags_DRM_HALT_CUR_QUEUES: drmLockFlags = 32;
pub type drmLockFlags = ::core::ffi::c_uint;
pub const drm_context_tFlags_DRM_CONTEXT_PRESERVED: drm_context_tFlags = 1;
pub const drm_context_tFlags_DRM_CONTEXT_2DONLY: drm_context_tFlags = 2;
pub type drm_context_tFlags = ::core::ffi::c_uint;
pub type drm_context_tFlagsPtr = *mut drm_context_tFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmBufDesc {
    pub count: ::core::ffi::c_int,
    pub size: ::core::ffi::c_int,
    pub low_mark: ::core::ffi::c_int,
    pub high_mark: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmBufDesc"][::core::mem::size_of::<_drmBufDesc>() - 16usize];
    ["Alignment of _drmBufDesc"][::core::mem::align_of::<_drmBufDesc>() - 4usize];
    ["Offset of field: _drmBufDesc::count"][::core::mem::offset_of!(_drmBufDesc, count) - 0usize];
    ["Offset of field: _drmBufDesc::size"][::core::mem::offset_of!(_drmBufDesc, size) - 4usize];
    ["Offset of field: _drmBufDesc::low_mark"]
        [::core::mem::offset_of!(_drmBufDesc, low_mark) - 8usize];
    ["Offset of field: _drmBufDesc::high_mark"]
        [::core::mem::offset_of!(_drmBufDesc, high_mark) - 12usize];
};
pub type drmBufDesc = _drmBufDesc;
pub type drmBufDescPtr = *mut _drmBufDesc;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmBufInfo {
    pub count: ::core::ffi::c_int,
    pub list: drmBufDescPtr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmBufInfo"][::core::mem::size_of::<_drmBufInfo>() - 16usize];
    ["Alignment of _drmBufInfo"][::core::mem::align_of::<_drmBufInfo>() - 8usize];
    ["Offset of field: _drmBufInfo::count"][::core::mem::offset_of!(_drmBufInfo, count) - 0usize];
    ["Offset of field: _drmBufInfo::list"][::core::mem::offset_of!(_drmBufInfo, list) - 8usize];
};
pub type drmBufInfo = _drmBufInfo;
pub type drmBufInfoPtr = *mut _drmBufInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmBuf {
    pub idx: ::core::ffi::c_int,
    pub total: ::core::ffi::c_int,
    pub used: ::core::ffi::c_int,
    pub address: drmAddress,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmBuf"][::core::mem::size_of::<_drmBuf>() - 24usize];
    ["Alignment of _drmBuf"][::core::mem::align_of::<_drmBuf>() - 8usize];
    ["Offset of field: _drmBuf::idx"][::core::mem::offset_of!(_drmBuf, idx) - 0usize];
    ["Offset of field: _drmBuf::total"][::core::mem::offset_of!(_drmBuf, total) - 4usize];
    ["Offset of field: _drmBuf::used"][::core::mem::offset_of!(_drmBuf, used) - 8usize];
    ["Offset of field: _drmBuf::address"][::core::mem::offset_of!(_drmBuf, address) - 16usize];
};
pub type drmBuf = _drmBuf;
pub type drmBufPtr = *mut _drmBuf;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmBufMap {
    pub count: ::core::ffi::c_int,
    pub list: drmBufPtr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmBufMap"][::core::mem::size_of::<_drmBufMap>() - 16usize];
    ["Alignment of _drmBufMap"][::core::mem::align_of::<_drmBufMap>() - 8usize];
    ["Offset of field: _drmBufMap::count"][::core::mem::offset_of!(_drmBufMap, count) - 0usize];
    ["Offset of field: _drmBufMap::list"][::core::mem::offset_of!(_drmBufMap, list) - 8usize];
};
pub type drmBufMap = _drmBufMap;
pub type drmBufMapPtr = *mut _drmBufMap;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmLock {
    pub lock: ::core::ffi::c_uint,
    pub padding: [::core::ffi::c_char; 60usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmLock"][::core::mem::size_of::<_drmLock>() - 64usize];
    ["Alignment of _drmLock"][::core::mem::align_of::<_drmLock>() - 4usize];
    ["Offset of field: _drmLock::lock"][::core::mem::offset_of!(_drmLock, lock) - 0usize];
    ["Offset of field: _drmLock::padding"][::core::mem::offset_of!(_drmLock, padding) - 4usize];
};
pub type drmLock = _drmLock;
pub type drmLockPtr = *mut _drmLock;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmDMAReq {
    pub context: drm_context_t,
    pub send_count: ::core::ffi::c_int,
    pub send_list: *mut ::core::ffi::c_int,
    pub send_sizes: *mut ::core::ffi::c_int,
    pub flags: drmDMAFlags,
    pub request_count: ::core::ffi::c_int,
    pub request_size: ::core::ffi::c_int,
    pub request_list: *mut ::core::ffi::c_int,
    pub request_sizes: *mut ::core::ffi::c_int,
    pub granted_count: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmDMAReq"][::core::mem::size_of::<_drmDMAReq>() - 64usize];
    ["Alignment of _drmDMAReq"][::core::mem::align_of::<_drmDMAReq>() - 8usize];
    ["Offset of field: _drmDMAReq::context"][::core::mem::offset_of!(_drmDMAReq, context) - 0usize];
    ["Offset of field: _drmDMAReq::send_count"]
        [::core::mem::offset_of!(_drmDMAReq, send_count) - 4usize];
    ["Offset of field: _drmDMAReq::send_list"]
        [::core::mem::offset_of!(_drmDMAReq, send_list) - 8usize];
    ["Offset of field: _drmDMAReq::send_sizes"]
        [::core::mem::offset_of!(_drmDMAReq, send_sizes) - 16usize];
    ["Offset of field: _drmDMAReq::flags"][::core::mem::offset_of!(_drmDMAReq, flags) - 24usize];
    ["Offset of field: _drmDMAReq::request_count"]
        [::core::mem::offset_of!(_drmDMAReq, request_count) - 28usize];
    ["Offset of field: _drmDMAReq::request_size"]
        [::core::mem::offset_of!(_drmDMAReq, request_size) - 32usize];
    ["Offset of field: _drmDMAReq::request_list"]
        [::core::mem::offset_of!(_drmDMAReq, request_list) - 40usize];
    ["Offset of field: _drmDMAReq::request_sizes"]
        [::core::mem::offset_of!(_drmDMAReq, request_sizes) - 48usize];
    ["Offset of field: _drmDMAReq::granted_count"]
        [::core::mem::offset_of!(_drmDMAReq, granted_count) - 56usize];
};
pub type drmDMAReq = _drmDMAReq;
pub type drmDMAReqPtr = *mut _drmDMAReq;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmRegion {
    pub handle: drm_handle_t,
    pub offset: ::core::ffi::c_uint,
    pub size: drmSize,
    pub map: drmAddress,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmRegion"][::core::mem::size_of::<_drmRegion>() - 24usize];
    ["Alignment of _drmRegion"][::core::mem::align_of::<_drmRegion>() - 8usize];
    ["Offset of field: _drmRegion::handle"][::core::mem::offset_of!(_drmRegion, handle) - 0usize];
    ["Offset of field: _drmRegion::offset"][::core::mem::offset_of!(_drmRegion, offset) - 4usize];
    ["Offset of field: _drmRegion::size"][::core::mem::offset_of!(_drmRegion, size) - 8usize];
    ["Offset of field: _drmRegion::map"][::core::mem::offset_of!(_drmRegion, map) - 16usize];
};
pub type drmRegion = _drmRegion;
pub type drmRegionPtr = *mut _drmRegion;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmTextureRegion {
    pub next: ::core::ffi::c_uchar,
    pub prev: ::core::ffi::c_uchar,
    pub in_use: ::core::ffi::c_uchar,
    pub padding: ::core::ffi::c_uchar,
    pub age: ::core::ffi::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmTextureRegion"][::core::mem::size_of::<_drmTextureRegion>() - 8usize];
    ["Alignment of _drmTextureRegion"][::core::mem::align_of::<_drmTextureRegion>() - 4usize];
    ["Offset of field: _drmTextureRegion::next"]
        [::core::mem::offset_of!(_drmTextureRegion, next) - 0usize];
    ["Offset of field: _drmTextureRegion::prev"]
        [::core::mem::offset_of!(_drmTextureRegion, prev) - 1usize];
    ["Offset of field: _drmTextureRegion::in_use"]
        [::core::mem::offset_of!(_drmTextureRegion, in_use) - 2usize];
    ["Offset of field: _drmTextureRegion::padding"]
        [::core::mem::offset_of!(_drmTextureRegion, padding) - 3usize];
    ["Offset of field: _drmTextureRegion::age"]
        [::core::mem::offset_of!(_drmTextureRegion, age) - 4usize];
};
pub type drmTextureRegion = _drmTextureRegion;
pub type drmTextureRegionPtr = *mut _drmTextureRegion;
pub const drmVBlankSeqType_DRM_VBLANK_ABSOLUTE: drmVBlankSeqType = 0;
pub const drmVBlankSeqType_DRM_VBLANK_RELATIVE: drmVBlankSeqType = 1;
pub const drmVBlankSeqType_DRM_VBLANK_HIGH_CRTC_MASK: drmVBlankSeqType = 62;
pub const drmVBlankSeqType_DRM_VBLANK_EVENT: drmVBlankSeqType = 67108864;
pub const drmVBlankSeqType_DRM_VBLANK_FLIP: drmVBlankSeqType = 134217728;
pub const drmVBlankSeqType_DRM_VBLANK_NEXTONMISS: drmVBlankSeqType = 268435456;
pub const drmVBlankSeqType_DRM_VBLANK_SECONDARY: drmVBlankSeqType = 536870912;
pub const drmVBlankSeqType_DRM_VBLANK_SIGNAL: drmVBlankSeqType = 1073741824;
pub type drmVBlankSeqType = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmVBlankReq {
    pub type_: drmVBlankSeqType,
    pub sequence: ::core::ffi::c_uint,
    pub signal: ::core::ffi::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmVBlankReq"][::core::mem::size_of::<_drmVBlankReq>() - 16usize];
    ["Alignment of _drmVBlankReq"][::core::mem::align_of::<_drmVBlankReq>() - 8usize];
    ["Offset of field: _drmVBlankReq::type_"]
        [::core::mem::offset_of!(_drmVBlankReq, type_) - 0usize];
    ["Offset of field: _drmVBlankReq::sequence"]
        [::core::mem::offset_of!(_drmVBlankReq, sequence) - 4usize];
    ["Offset of field: _drmVBlankReq::signal"]
        [::core::mem::offset_of!(_drmVBlankReq, signal) - 8usize];
};
pub type drmVBlankReq = _drmVBlankReq;
pub type drmVBlankReqPtr = *mut _drmVBlankReq;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmVBlankReply {
    pub type_: drmVBlankSeqType,
    pub sequence: ::core::ffi::c_uint,
    pub tval_sec: ::core::ffi::c_long,
    pub tval_usec: ::core::ffi::c_long,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmVBlankReply"][::core::mem::size_of::<_drmVBlankReply>() - 24usize];
    ["Alignment of _drmVBlankReply"][::core::mem::align_of::<_drmVBlankReply>() - 8usize];
    ["Offset of field: _drmVBlankReply::type_"]
        [::core::mem::offset_of!(_drmVBlankReply, type_) - 0usize];
    ["Offset of field: _drmVBlankReply::sequence"]
        [::core::mem::offset_of!(_drmVBlankReply, sequence) - 4usize];
    ["Offset of field: _drmVBlankReply::tval_sec"]
        [::core::mem::offset_of!(_drmVBlankReply, tval_sec) - 8usize];
    ["Offset of field: _drmVBlankReply::tval_usec"]
        [::core::mem::offset_of!(_drmVBlankReply, tval_usec) - 16usize];
};
pub type drmVBlankReply = _drmVBlankReply;
pub type drmVBlankReplyPtr = *mut _drmVBlankReply;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _drmVBlank {
    pub request: drmVBlankReq,
    pub reply: drmVBlankReply,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmVBlank"][::core::mem::size_of::<_drmVBlank>() - 24usize];
    ["Alignment of _drmVBlank"][::core::mem::align_of::<_drmVBlank>() - 8usize];
    ["Offset of field: _drmVBlank::request"][::core::mem::offset_of!(_drmVBlank, request) - 0usize];
    ["Offset of field: _drmVBlank::reply"][::core::mem::offset_of!(_drmVBlank, reply) - 0usize];
};
pub type drmVBlank = _drmVBlank;
pub type drmVBlankPtr = *mut _drmVBlank;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmSetVersion {
    pub drm_di_major: ::core::ffi::c_int,
    pub drm_di_minor: ::core::ffi::c_int,
    pub drm_dd_major: ::core::ffi::c_int,
    pub drm_dd_minor: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmSetVersion"][::core::mem::size_of::<_drmSetVersion>() - 16usize];
    ["Alignment of _drmSetVersion"][::core::mem::align_of::<_drmSetVersion>() - 4usize];
    ["Offset of field: _drmSetVersion::drm_di_major"]
        [::core::mem::offset_of!(_drmSetVersion, drm_di_major) - 0usize];
    ["Offset of field: _drmSetVersion::drm_di_minor"]
        [::core::mem::offset_of!(_drmSetVersion, drm_di_minor) - 4usize];
    ["Offset of field: _drmSetVersion::drm_dd_major"]
        [::core::mem::offset_of!(_drmSetVersion, drm_dd_major) - 8usize];
    ["Offset of field: _drmSetVersion::drm_dd_minor"]
        [::core::mem::offset_of!(_drmSetVersion, drm_dd_minor) - 12usize];
};
pub type drmSetVersion = _drmSetVersion;
pub type drmSetVersionPtr = *mut _drmSetVersion;
extern "C" {
    pub fn drmAvailable() -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmOpen(
        name: *const ::core::ffi::c_char,
        busid: *const ::core::ffi::c_char,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmOpenWithType(
        name: *const ::core::ffi::c_char,
        busid: *const ::core::ffi::c_char,
        type_: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmOpenControl(minor: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmOpenRender(minor: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmClose(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetVersion(fd: ::core::ffi::c_int) -> drmVersionPtr;
}
extern "C" {
    pub fn drmGetLibVersion(fd: ::core::ffi::c_int) -> drmVersionPtr;
}
extern "C" {
    pub fn drmGetCap(
        fd: ::core::ffi::c_int,
        capability: u64,
        value: *mut u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmFreeVersion(arg1: drmVersionPtr);
}
extern "C" {
    pub fn drmGetMagic(fd: ::core::ffi::c_int, magic: *mut drm_magic_t) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetBusid(fd: ::core::ffi::c_int) -> *mut ::core::ffi::c_char;
}
extern "C" {
    pub fn drmGetInterruptFromBusID(
        fd: ::core::ffi::c_int,
        busnum: ::core::ffi::c_int,
        devnum: ::core::ffi::c_int,
        funcnum: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetMap(
        fd: ::core::ffi::c_int,
        idx: ::core::ffi::c_int,
        offset: *mut drm_handle_t,
        size: *mut drmSize,
        type_: *mut drmMapType,
        flags: *mut drmMapFlags,
        handle: *mut drm_handle_t,
        mtrr: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetClient(
        fd: ::core::ffi::c_int,
        idx: ::core::ffi::c_int,
        auth: *mut ::core::ffi::c_int,
        pid: *mut ::core::ffi::c_int,
        uid: *mut ::core::ffi::c_int,
        magic: *mut ::core::ffi::c_ulong,
        iocs: *mut ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetStats(fd: ::core::ffi::c_int, stats: *mut drmStatsT) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSetInterfaceVersion(
        fd: ::core::ffi::c_int,
        version: *mut drmSetVersion,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCommandNone(
        fd: ::core::ffi::c_int,
        drmCommandIndex: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCommandRead(
        fd: ::core::ffi::c_int,
        drmCommandIndex: ::core::ffi::c_ulong,
        data: *mut ::core::ffi::c_void,
        size: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCommandWrite(
        fd: ::core::ffi::c_int,
        drmCommandIndex: ::core::ffi::c_ulong,
        data: *mut ::core::ffi::c_void,
        size: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCommandWriteRead(
        fd: ::core::ffi::c_int,
        drmCommandIndex: ::core::ffi::c_ulong,
        data: *mut ::core::ffi::c_void,
        size: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmFreeBusid(busid: *const ::core::ffi::c_char);
}
extern "C" {
    pub fn drmSetBusid(
        fd: ::core::ffi::c_int,
        busid: *const ::core::ffi::c_char,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAuthMagic(fd: ::core::ffi::c_int, magic: drm_magic_t) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAddMap(
        fd: ::core::ffi::c_int,
        offset: drm_handle_t,
        size: drmSize,
        type_: drmMapType,
        flags: drmMapFlags,
        handle: *mut drm_handle_t,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmRmMap(fd: ::core::ffi::c_int, handle: drm_handle_t) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAddContextPrivateMapping(
        fd: ::core::ffi::c_int,
        ctx_id: drm_context_t,
        handle: drm_handle_t,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAddBufs(
        fd: ::core::ffi::c_int,
        count: ::core::ffi::c_int,
        size: ::core::ffi::c_int,
        flags: drmBufDescFlags,
        agp_offset: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmMarkBufs(fd: ::core::ffi::c_int, low: f64, high: f64) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCreateContext(
        fd: ::core::ffi::c_int,
        handle: *mut drm_context_t,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSetContextFlags(
        fd: ::core::ffi::c_int,
        context: drm_context_t,
        flags: drm_context_tFlags,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetContextFlags(
        fd: ::core::ffi::c_int,
        context: drm_context_t,
        flags: drm_context_tFlagsPtr,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAddContextTag(
        fd: ::core::ffi::c_int,
        context: drm_context_t,
        tag: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmDelContextTag(fd: ::core::ffi::c_int, context: drm_context_t) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetContextTag(
        fd: ::core::ffi::c_int,
        context: drm_context_t,
    ) -> *mut ::core::ffi::c_void;
}
extern "C" {
    pub fn drmGetReservedContextList(
        fd: ::core::ffi::c_int,
        count: *mut ::core::ffi::c_int,
    ) -> *mut drm_context_t;
}
extern "C" {
    pub fn drmFreeReservedContextList(arg1: *mut drm_context_t);
}
extern "C" {
    pub fn drmSwitchToContext(fd: ::core::ffi::c_int, context: drm_context_t)
        -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmDestroyContext(fd: ::core::ffi::c_int, handle: drm_context_t) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCreateDrawable(
        fd: ::core::ffi::c_int,
        handle: *mut drm_drawable_t,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmDestroyDrawable(fd: ::core::ffi::c_int, handle: drm_drawable_t)
        -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmUpdateDrawableInfo(
        fd: ::core::ffi::c_int,
        handle: drm_drawable_t,
        type_: drm_drawable_info_type_t,
        num: ::core::ffi::c_uint,
        data: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCtlInstHandler(fd: ::core::ffi::c_int, irq: ::core::ffi::c_int)
        -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCtlUninstHandler(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSetClientCap(
        fd: ::core::ffi::c_int,
        capability: u64,
        value: u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCrtcGetSequence(
        fd: ::core::ffi::c_int,
        crtcId: u32,
        sequence: *mut u64,
        ns: *mut u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCrtcQueueSequence(
        fd: ::core::ffi::c_int,
        crtcId: u32,
        flags: u32,
        sequence: u64,
        sequence_queued: *mut u64,
        user_data: u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmMap(
        fd: ::core::ffi::c_int,
        handle: drm_handle_t,
        size: drmSize,
        address: drmAddressPtr,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmUnmap(address: drmAddress, size: drmSize) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetBufInfo(fd: ::core::ffi::c_int) -> drmBufInfoPtr;
}
extern "C" {
    pub fn drmMapBufs(fd: ::core::ffi::c_int) -> drmBufMapPtr;
}
extern "C" {
    pub fn drmUnmapBufs(bufs: drmBufMapPtr) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmDMA(fd: ::core::ffi::c_int, request: drmDMAReqPtr) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmFreeBufs(
        fd: ::core::ffi::c_int,
        count: ::core::ffi::c_int,
        list: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetLock(
        fd: ::core::ffi::c_int,
        context: drm_context_t,
        flags: drmLockFlags,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmUnlock(fd: ::core::ffi::c_int, context: drm_context_t) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmFinish(
        fd: ::core::ffi::c_int,
        context: ::core::ffi::c_int,
        flags: drmLockFlags,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetContextPrivateMapping(
        fd: ::core::ffi::c_int,
        ctx_id: drm_context_t,
        handle: *mut drm_handle_t,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAgpAcquire(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAgpRelease(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAgpEnable(fd: ::core::ffi::c_int, mode: ::core::ffi::c_ulong) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAgpAlloc(
        fd: ::core::ffi::c_int,
        size: ::core::ffi::c_ulong,
        type_: ::core::ffi::c_ulong,
        address: *mut ::core::ffi::c_ulong,
        handle: *mut drm_handle_t,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAgpFree(fd: ::core::ffi::c_int, handle: drm_handle_t) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAgpBind(
        fd: ::core::ffi::c_int,
        handle: drm_handle_t,
        offset: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAgpUnbind(fd: ::core::ffi::c_int, handle: drm_handle_t) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAgpVersionMajor(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAgpVersionMinor(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmAgpGetMode(fd: ::core::ffi::c_int) -> ::core::ffi::c_ulong;
}
extern "C" {
    pub fn drmAgpBase(fd: ::core::ffi::c_int) -> ::core::ffi::c_ulong;
}
extern "C" {
    pub fn drmAgpSize(fd: ::core::ffi::c_int) -> ::core::ffi::c_ulong;
}
extern "C" {
    pub fn drmAgpMemoryUsed(fd: ::core::ffi::c_int) -> ::core::ffi::c_ulong;
}
extern "C" {
    pub fn drmAgpMemoryAvail(fd: ::core::ffi::c_int) -> ::core::ffi::c_ulong;
}
extern "C" {
    pub fn drmAgpVendorId(fd: ::core::ffi::c_int) -> ::core::ffi::c_uint;
}
extern "C" {
    pub fn drmAgpDeviceId(fd: ::core::ffi::c_int) -> ::core::ffi::c_uint;
}
extern "C" {
    pub fn drmScatterGatherAlloc(
        fd: ::core::ffi::c_int,
        size: ::core::ffi::c_ulong,
        handle: *mut drm_handle_t,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmScatterGatherFree(fd: ::core::ffi::c_int, handle: drm_handle_t)
        -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmWaitVBlank(fd: ::core::ffi::c_int, vbl: drmVBlankPtr) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSetServerInfo(info: drmServerInfoPtr);
}
extern "C" {
    pub fn drmError(
        err: ::core::ffi::c_int,
        label: *const ::core::ffi::c_char,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmMalloc(size: ::core::ffi::c_int) -> *mut ::core::ffi::c_void;
}
extern "C" {
    pub fn drmFree(pt: *mut ::core::ffi::c_void);
}
extern "C" {
    pub fn drmHashCreate() -> *mut ::core::ffi::c_void;
}
extern "C" {
    pub fn drmHashDestroy(t: *mut ::core::ffi::c_void) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmHashLookup(
        t: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
        value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmHashInsert(
        t: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmHashDelete(
        t: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmHashFirst(
        t: *mut ::core::ffi::c_void,
        key: *mut ::core::ffi::c_ulong,
        value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmHashNext(
        t: *mut ::core::ffi::c_void,
        key: *mut ::core::ffi::c_ulong,
        value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmRandomCreate(seed: ::core::ffi::c_ulong) -> *mut ::core::ffi::c_void;
}
extern "C" {
    pub fn drmRandomDestroy(state: *mut ::core::ffi::c_void) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmRandom(state: *mut ::core::ffi::c_void) -> ::core::ffi::c_ulong;
}
extern "C" {
    pub fn drmRandomDouble(state: *mut ::core::ffi::c_void) -> f64;
}
extern "C" {
    pub fn drmSLCreate() -> *mut ::core::ffi::c_void;
}
extern "C" {
    pub fn drmSLDestroy(l: *mut ::core::ffi::c_void) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSLLookup(
        l: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
        value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSLInsert(
        l: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSLDelete(
        l: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSLNext(
        l: *mut ::core::ffi::c_void,
        key: *mut ::core::ffi::c_ulong,
        value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSLFirst(
        l: *mut ::core::ffi::c_void,
        key: *mut ::core::ffi::c_ulong,
        value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSLDump(l: *mut ::core::ffi::c_void);
}
extern "C" {
    pub fn drmSLLookupNeighbors(
        l: *mut ::core::ffi::c_void,
        key: ::core::ffi::c_ulong,
        prev_key: *mut ::core::ffi::c_ulong,
        prev_value: *mut *mut ::core::ffi::c_void,
        next_key: *mut ::core::ffi::c_ulong,
        next_value: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmOpenOnce(
        unused: *mut ::core::ffi::c_void,
        BusID: *const ::core::ffi::c_char,
        newlyopened: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmOpenOnceWithType(
        BusID: *const ::core::ffi::c_char,
        newlyopened: *mut ::core::ffi::c_int,
        type_: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCloseOnce(fd: ::core::ffi::c_int);
}
extern "C" {
    pub fn drmMsg(format: *const ::core::ffi::c_char, ...);
}
extern "C" {
    pub fn drmSetMaster(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmDropMaster(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmIsMaster(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmEventContext {
    pub version: ::core::ffi::c_int,
    pub vblank_handler: ::core::option::Option<
        unsafe extern "C" fn(
            fd: ::core::ffi::c_int,
            sequence: ::core::ffi::c_uint,
            tv_sec: ::core::ffi::c_uint,
            tv_usec: ::core::ffi::c_uint,
            user_data: *mut ::core::ffi::c_void,
        ),
    >,
    pub page_flip_handler: ::core::option::Option<
        unsafe extern "C" fn(
            fd: ::core::ffi::c_int,
            sequence: ::core::ffi::c_uint,
            tv_sec: ::core::ffi::c_uint,
            tv_usec: ::core::ffi::c_uint,
            user_data: *mut ::core::ffi::c_void,
        ),
    >,
    pub page_flip_handler2: ::core::option::Option<
        unsafe extern "C" fn(
            fd: ::core::ffi::c_int,
            sequence: ::core::ffi::c_uint,
            tv_sec: ::core::ffi::c_uint,
            tv_usec: ::core::ffi::c_uint,
            crtc_id: ::core::ffi::c_uint,
            user_data: *mut ::core::ffi::c_void,
        ),
    >,
    pub sequence_handler: ::core::option::Option<
        unsafe extern "C" fn(fd: ::core::ffi::c_int, sequence: u64, ns: u64, user_data: u64),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmEventContext"][::core::mem::size_of::<_drmEventContext>() - 40usize];
    ["Alignment of _drmEventContext"][::core::mem::align_of::<_drmEventContext>() - 8usize];
    ["Offset of field: _drmEventContext::version"]
        [::core::mem::offset_of!(_drmEventContext, version) - 0usize];
    ["Offset of field: _drmEventContext::vblank_handler"]
        [::core::mem::offset_of!(_drmEventContext, vblank_handler) - 8usize];
    ["Offset of field: _drmEventContext::page_flip_handler"]
        [::core::mem::offset_of!(_drmEventContext, page_flip_handler) - 16usize];
    ["Offset of field: _drmEventContext::page_flip_handler2"]
        [::core::mem::offset_of!(_drmEventContext, page_flip_handler2) - 24usize];
    ["Offset of field: _drmEventContext::sequence_handler"]
        [::core::mem::offset_of!(_drmEventContext, sequence_handler) - 32usize];
};
pub type drmEventContext = _drmEventContext;
pub type drmEventContextPtr = *mut _drmEventContext;
extern "C" {
    pub fn drmHandleEvent(fd: ::core::ffi::c_int, evctx: drmEventContextPtr) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetDeviceNameFromFd(fd: ::core::ffi::c_int) -> *mut ::core::ffi::c_char;
}
extern "C" {
    pub fn drmGetDeviceNameFromFd2(fd: ::core::ffi::c_int) -> *mut ::core::ffi::c_char;
}
extern "C" {
    pub fn drmGetNodeTypeFromFd(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmPrimeHandleToFD(
        fd: ::core::ffi::c_int,
        handle: u32,
        flags: u32,
        prime_fd: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmPrimeFDToHandle(
        fd: ::core::ffi::c_int,
        prime_fd: ::core::ffi::c_int,
        handle: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCloseBufferHandle(fd: ::core::ffi::c_int, handle: u32) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetPrimaryDeviceNameFromFd(fd: ::core::ffi::c_int) -> *mut ::core::ffi::c_char;
}
extern "C" {
    pub fn drmGetRenderDeviceNameFromFd(fd: ::core::ffi::c_int) -> *mut ::core::ffi::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmPciBusInfo {
    pub domain: u16,
    pub bus: u8,
    pub dev: u8,
    pub func: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmPciBusInfo"][::core::mem::size_of::<_drmPciBusInfo>() - 6usize];
    ["Alignment of _drmPciBusInfo"][::core::mem::align_of::<_drmPciBusInfo>() - 2usize];
    ["Offset of field: _drmPciBusInfo::domain"]
        [::core::mem::offset_of!(_drmPciBusInfo, domain) - 0usize];
    ["Offset of field: _drmPciBusInfo::bus"][::core::mem::offset_of!(_drmPciBusInfo, bus) - 2usize];
    ["Offset of field: _drmPciBusInfo::dev"][::core::mem::offset_of!(_drmPciBusInfo, dev) - 3usize];
    ["Offset of field: _drmPciBusInfo::func"]
        [::core::mem::offset_of!(_drmPciBusInfo, func) - 4usize];
};
pub type drmPciBusInfo = _drmPciBusInfo;
pub type drmPciBusInfoPtr = *mut _drmPciBusInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmPciDeviceInfo {
    pub vendor_id: u16,
    pub device_id: u16,
    pub subvendor_id: u16,
    pub subdevice_id: u16,
    pub revision_id: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmPciDeviceInfo"][::core::mem::size_of::<_drmPciDeviceInfo>() - 10usize];
    ["Alignment of _drmPciDeviceInfo"][::core::mem::align_of::<_drmPciDeviceInfo>() - 2usize];
    ["Offset of field: _drmPciDeviceInfo::vendor_id"]
        [::core::mem::offset_of!(_drmPciDeviceInfo, vendor_id) - 0usize];
    ["Offset of field: _drmPciDeviceInfo::device_id"]
        [::core::mem::offset_of!(_drmPciDeviceInfo, device_id) - 2usize];
    ["Offset of field: _drmPciDeviceInfo::subvendor_id"]
        [::core::mem::offset_of!(_drmPciDeviceInfo, subvendor_id) - 4usize];
    ["Offset of field: _drmPciDeviceInfo::subdevice_id"]
        [::core::mem::offset_of!(_drmPciDeviceInfo, subdevice_id) - 6usize];
    ["Offset of field: _drmPciDeviceInfo::revision_id"]
        [::core::mem::offset_of!(_drmPciDeviceInfo, revision_id) - 8usize];
};
pub type drmPciDeviceInfo = _drmPciDeviceInfo;
pub type drmPciDeviceInfoPtr = *mut _drmPciDeviceInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmUsbBusInfo {
    pub bus: u8,
    pub dev: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmUsbBusInfo"][::core::mem::size_of::<_drmUsbBusInfo>() - 2usize];
    ["Alignment of _drmUsbBusInfo"][::core::mem::align_of::<_drmUsbBusInfo>() - 1usize];
    ["Offset of field: _drmUsbBusInfo::bus"][::core::mem::offset_of!(_drmUsbBusInfo, bus) - 0usize];
    ["Offset of field: _drmUsbBusInfo::dev"][::core::mem::offset_of!(_drmUsbBusInfo, dev) - 1usize];
};
pub type drmUsbBusInfo = _drmUsbBusInfo;
pub type drmUsbBusInfoPtr = *mut _drmUsbBusInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmUsbDeviceInfo {
    pub vendor: u16,
    pub product: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmUsbDeviceInfo"][::core::mem::size_of::<_drmUsbDeviceInfo>() - 4usize];
    ["Alignment of _drmUsbDeviceInfo"][::core::mem::align_of::<_drmUsbDeviceInfo>() - 2usize];
    ["Offset of field: _drmUsbDeviceInfo::vendor"]
        [::core::mem::offset_of!(_drmUsbDeviceInfo, vendor) - 0usize];
    ["Offset of field: _drmUsbDeviceInfo::product"]
        [::core::mem::offset_of!(_drmUsbDeviceInfo, product) - 2usize];
};
pub type drmUsbDeviceInfo = _drmUsbDeviceInfo;
pub type drmUsbDeviceInfoPtr = *mut _drmUsbDeviceInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmPlatformBusInfo {
    pub fullname: [::core::ffi::c_char; 512usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmPlatformBusInfo"][::core::mem::size_of::<_drmPlatformBusInfo>() - 512usize];
    ["Alignment of _drmPlatformBusInfo"][::core::mem::align_of::<_drmPlatformBusInfo>() - 1usize];
    ["Offset of field: _drmPlatformBusInfo::fullname"]
        [::core::mem::offset_of!(_drmPlatformBusInfo, fullname) - 0usize];
};
pub type drmPlatformBusInfo = _drmPlatformBusInfo;
pub type drmPlatformBusInfoPtr = *mut _drmPlatformBusInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmPlatformDeviceInfo {
    pub compatible: *mut *mut ::core::ffi::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmPlatformDeviceInfo"][::core::mem::size_of::<_drmPlatformDeviceInfo>() - 8usize];
    ["Alignment of _drmPlatformDeviceInfo"]
        [::core::mem::align_of::<_drmPlatformDeviceInfo>() - 8usize];
    ["Offset of field: _drmPlatformDeviceInfo::compatible"]
        [::core::mem::offset_of!(_drmPlatformDeviceInfo, compatible) - 0usize];
};
pub type drmPlatformDeviceInfo = _drmPlatformDeviceInfo;
pub type drmPlatformDeviceInfoPtr = *mut _drmPlatformDeviceInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmHost1xBusInfo {
    pub fullname: [::core::ffi::c_char; 512usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmHost1xBusInfo"][::core::mem::size_of::<_drmHost1xBusInfo>() - 512usize];
    ["Alignment of _drmHost1xBusInfo"][::core::mem::align_of::<_drmHost1xBusInfo>() - 1usize];
    ["Offset of field: _drmHost1xBusInfo::fullname"]
        [::core::mem::offset_of!(_drmHost1xBusInfo, fullname) - 0usize];
};
pub type drmHost1xBusInfo = _drmHost1xBusInfo;
pub type drmHost1xBusInfoPtr = *mut _drmHost1xBusInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmHost1xDeviceInfo {
    pub compatible: *mut *mut ::core::ffi::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmHost1xDeviceInfo"][::core::mem::size_of::<_drmHost1xDeviceInfo>() - 8usize];
    ["Alignment of _drmHost1xDeviceInfo"][::core::mem::align_of::<_drmHost1xDeviceInfo>() - 8usize];
    ["Offset of field: _drmHost1xDeviceInfo::compatible"]
        [::core::mem::offset_of!(_drmHost1xDeviceInfo, compatible) - 0usize];
};
pub type drmHost1xDeviceInfo = _drmHost1xDeviceInfo;
pub type drmHost1xDeviceInfoPtr = *mut _drmHost1xDeviceInfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _drmDevice {
    pub nodes: *mut *mut ::core::ffi::c_char,
    pub available_nodes: ::core::ffi::c_int,
    pub bustype: ::core::ffi::c_int,
    pub businfo: _drmDevice__bindgen_ty_1,
    pub deviceinfo: _drmDevice__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _drmDevice__bindgen_ty_1 {
    pub pci: drmPciBusInfoPtr,
    pub usb: drmUsbBusInfoPtr,
    pub platform: drmPlatformBusInfoPtr,
    pub host1x: drmHost1xBusInfoPtr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmDevice__bindgen_ty_1"]
        [::core::mem::size_of::<_drmDevice__bindgen_ty_1>() - 8usize];
    ["Alignment of _drmDevice__bindgen_ty_1"]
        [::core::mem::align_of::<_drmDevice__bindgen_ty_1>() - 8usize];
    ["Offset of field: _drmDevice__bindgen_ty_1::pci"]
        [::core::mem::offset_of!(_drmDevice__bindgen_ty_1, pci) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_1::usb"]
        [::core::mem::offset_of!(_drmDevice__bindgen_ty_1, usb) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_1::platform"]
        [::core::mem::offset_of!(_drmDevice__bindgen_ty_1, platform) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_1::host1x"]
        [::core::mem::offset_of!(_drmDevice__bindgen_ty_1, host1x) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union _drmDevice__bindgen_ty_2 {
    pub pci: drmPciDeviceInfoPtr,
    pub usb: drmUsbDeviceInfoPtr,
    pub platform: drmPlatformDeviceInfoPtr,
    pub host1x: drmHost1xDeviceInfoPtr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmDevice__bindgen_ty_2"]
        [::core::mem::size_of::<_drmDevice__bindgen_ty_2>() - 8usize];
    ["Alignment of _drmDevice__bindgen_ty_2"]
        [::core::mem::align_of::<_drmDevice__bindgen_ty_2>() - 8usize];
    ["Offset of field: _drmDevice__bindgen_ty_2::pci"]
        [::core::mem::offset_of!(_drmDevice__bindgen_ty_2, pci) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_2::usb"]
        [::core::mem::offset_of!(_drmDevice__bindgen_ty_2, usb) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_2::platform"]
        [::core::mem::offset_of!(_drmDevice__bindgen_ty_2, platform) - 0usize];
    ["Offset of field: _drmDevice__bindgen_ty_2::host1x"]
        [::core::mem::offset_of!(_drmDevice__bindgen_ty_2, host1x) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmDevice"][::core::mem::size_of::<_drmDevice>() - 32usize];
    ["Alignment of _drmDevice"][::core::mem::align_of::<_drmDevice>() - 8usize];
    ["Offset of field: _drmDevice::nodes"][::core::mem::offset_of!(_drmDevice, nodes) - 0usize];
    ["Offset of field: _drmDevice::available_nodes"]
        [::core::mem::offset_of!(_drmDevice, available_nodes) - 8usize];
    ["Offset of field: _drmDevice::bustype"]
        [::core::mem::offset_of!(_drmDevice, bustype) - 12usize];
    ["Offset of field: _drmDevice::businfo"]
        [::core::mem::offset_of!(_drmDevice, businfo) - 16usize];
    ["Offset of field: _drmDevice::deviceinfo"]
        [::core::mem::offset_of!(_drmDevice, deviceinfo) - 24usize];
};
pub type drmDevice = _drmDevice;
pub type drmDevicePtr = *mut _drmDevice;
extern "C" {
    pub fn drmGetDevice(fd: ::core::ffi::c_int, device: *mut drmDevicePtr) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmFreeDevice(device: *mut drmDevicePtr);
}
extern "C" {
    pub fn drmGetDevices(
        devices: *mut drmDevicePtr,
        max_devices: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmFreeDevices(devices: *mut drmDevicePtr, count: ::core::ffi::c_int);
}
extern "C" {
    pub fn drmGetDevice2(
        fd: ::core::ffi::c_int,
        flags: u32,
        device: *mut drmDevicePtr,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetDevices2(
        flags: u32,
        devices: *mut drmDevicePtr,
        max_devices: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetDeviceFromDevId(
        dev_id: dev_t,
        flags: u32,
        device: *mut drmDevicePtr,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetNodeTypeFromDevId(devid: dev_t) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmDevicesEqual(a: drmDevicePtr, b: drmDevicePtr) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjCreate(
        fd: ::core::ffi::c_int,
        flags: u32,
        handle: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjDestroy(fd: ::core::ffi::c_int, handle: u32) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjHandleToFD(
        fd: ::core::ffi::c_int,
        handle: u32,
        obj_fd: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjFDToHandle(
        fd: ::core::ffi::c_int,
        obj_fd: ::core::ffi::c_int,
        handle: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjImportSyncFile(
        fd: ::core::ffi::c_int,
        handle: u32,
        sync_file_fd: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjExportSyncFile(
        fd: ::core::ffi::c_int,
        handle: u32,
        sync_file_fd: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjWait(
        fd: ::core::ffi::c_int,
        handles: *mut u32,
        num_handles: ::core::ffi::c_uint,
        timeout_nsec: i64,
        flags: ::core::ffi::c_uint,
        first_signaled: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjReset(
        fd: ::core::ffi::c_int,
        handles: *const u32,
        handle_count: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjSignal(
        fd: ::core::ffi::c_int,
        handles: *const u32,
        handle_count: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjTimelineSignal(
        fd: ::core::ffi::c_int,
        handles: *const u32,
        points: *mut u64,
        handle_count: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjTimelineWait(
        fd: ::core::ffi::c_int,
        handles: *mut u32,
        points: *mut u64,
        num_handles: ::core::ffi::c_uint,
        timeout_nsec: i64,
        flags: ::core::ffi::c_uint,
        first_signaled: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjQuery(
        fd: ::core::ffi::c_int,
        handles: *mut u32,
        points: *mut u64,
        handle_count: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjQuery2(
        fd: ::core::ffi::c_int,
        handles: *mut u32,
        points: *mut u64,
        handle_count: u32,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjTransfer(
        fd: ::core::ffi::c_int,
        dst_handle: u32,
        dst_point: u64,
        src_handle: u32,
        src_point: u64,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmSyncobjEventfd(
        fd: ::core::ffi::c_int,
        handle: u32,
        point: u64,
        ev_fd: ::core::ffi::c_int,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmGetFormatModifierVendor(modifier: u64) -> *mut ::core::ffi::c_char;
}
extern "C" {
    pub fn drmGetFormatModifierName(modifier: u64) -> *mut ::core::ffi::c_char;
}
extern "C" {
    pub fn drmGetFormatName(format: u32) -> *mut ::core::ffi::c_char;
}
pub type wchar_t = ::core::ffi::c_int;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::core::ffi::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of max_align_t"][::core::mem::size_of::<max_align_t>() - 32usize];
    ["Alignment of max_align_t"][::core::mem::align_of::<max_align_t>() - 16usize];
    ["Offset of field: max_align_t::__clang_max_align_nonce1"]
        [::core::mem::offset_of!(max_align_t, __clang_max_align_nonce1) - 0usize];
    ["Offset of field: max_align_t::__clang_max_align_nonce2"]
        [::core::mem::offset_of!(max_align_t, __clang_max_align_nonce2) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeRes {
    pub count_fbs: ::core::ffi::c_int,
    pub fbs: *mut u32,
    pub count_crtcs: ::core::ffi::c_int,
    pub crtcs: *mut u32,
    pub count_connectors: ::core::ffi::c_int,
    pub connectors: *mut u32,
    pub count_encoders: ::core::ffi::c_int,
    pub encoders: *mut u32,
    pub min_width: u32,
    pub max_width: u32,
    pub min_height: u32,
    pub max_height: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModeRes"][::core::mem::size_of::<_drmModeRes>() - 80usize];
    ["Alignment of _drmModeRes"][::core::mem::align_of::<_drmModeRes>() - 8usize];
    ["Offset of field: _drmModeRes::count_fbs"]
        [::core::mem::offset_of!(_drmModeRes, count_fbs) - 0usize];
    ["Offset of field: _drmModeRes::fbs"][::core::mem::offset_of!(_drmModeRes, fbs) - 8usize];
    ["Offset of field: _drmModeRes::count_crtcs"]
        [::core::mem::offset_of!(_drmModeRes, count_crtcs) - 16usize];
    ["Offset of field: _drmModeRes::crtcs"][::core::mem::offset_of!(_drmModeRes, crtcs) - 24usize];
    ["Offset of field: _drmModeRes::count_connectors"]
        [::core::mem::offset_of!(_drmModeRes, count_connectors) - 32usize];
    ["Offset of field: _drmModeRes::connectors"]
        [::core::mem::offset_of!(_drmModeRes, connectors) - 40usize];
    ["Offset of field: _drmModeRes::count_encoders"]
        [::core::mem::offset_of!(_drmModeRes, count_encoders) - 48usize];
    ["Offset of field: _drmModeRes::encoders"]
        [::core::mem::offset_of!(_drmModeRes, encoders) - 56usize];
    ["Offset of field: _drmModeRes::min_width"]
        [::core::mem::offset_of!(_drmModeRes, min_width) - 64usize];
    ["Offset of field: _drmModeRes::max_width"]
        [::core::mem::offset_of!(_drmModeRes, max_width) - 68usize];
    ["Offset of field: _drmModeRes::min_height"]
        [::core::mem::offset_of!(_drmModeRes, min_height) - 72usize];
    ["Offset of field: _drmModeRes::max_height"]
        [::core::mem::offset_of!(_drmModeRes, max_height) - 76usize];
};
pub type drmModeRes = _drmModeRes;
pub type drmModeResPtr = *mut _drmModeRes;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeModeInfo {
    pub clock: u32,
    pub hdisplay: u16,
    pub hsync_start: u16,
    pub hsync_end: u16,
    pub htotal: u16,
    pub hskew: u16,
    pub vdisplay: u16,
    pub vsync_start: u16,
    pub vsync_end: u16,
    pub vtotal: u16,
    pub vscan: u16,
    pub vrefresh: u32,
    pub flags: u32,
    pub type_: u32,
    pub name: [::core::ffi::c_char; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModeModeInfo"][::core::mem::size_of::<_drmModeModeInfo>() - 68usize];
    ["Alignment of _drmModeModeInfo"][::core::mem::align_of::<_drmModeModeInfo>() - 4usize];
    ["Offset of field: _drmModeModeInfo::clock"]
        [::core::mem::offset_of!(_drmModeModeInfo, clock) - 0usize];
    ["Offset of field: _drmModeModeInfo::hdisplay"]
        [::core::mem::offset_of!(_drmModeModeInfo, hdisplay) - 4usize];
    ["Offset of field: _drmModeModeInfo::hsync_start"]
        [::core::mem::offset_of!(_drmModeModeInfo, hsync_start) - 6usize];
    ["Offset of field: _drmModeModeInfo::hsync_end"]
        [::core::mem::offset_of!(_drmModeModeInfo, hsync_end) - 8usize];
    ["Offset of field: _drmModeModeInfo::htotal"]
        [::core::mem::offset_of!(_drmModeModeInfo, htotal) - 10usize];
    ["Offset of field: _drmModeModeInfo::hskew"]
        [::core::mem::offset_of!(_drmModeModeInfo, hskew) - 12usize];
    ["Offset of field: _drmModeModeInfo::vdisplay"]
        [::core::mem::offset_of!(_drmModeModeInfo, vdisplay) - 14usize];
    ["Offset of field: _drmModeModeInfo::vsync_start"]
        [::core::mem::offset_of!(_drmModeModeInfo, vsync_start) - 16usize];
    ["Offset of field: _drmModeModeInfo::vsync_end"]
        [::core::mem::offset_of!(_drmModeModeInfo, vsync_end) - 18usize];
    ["Offset of field: _drmModeModeInfo::vtotal"]
        [::core::mem::offset_of!(_drmModeModeInfo, vtotal) - 20usize];
    ["Offset of field: _drmModeModeInfo::vscan"]
        [::core::mem::offset_of!(_drmModeModeInfo, vscan) - 22usize];
    ["Offset of field: _drmModeModeInfo::vrefresh"]
        [::core::mem::offset_of!(_drmModeModeInfo, vrefresh) - 24usize];
    ["Offset of field: _drmModeModeInfo::flags"]
        [::core::mem::offset_of!(_drmModeModeInfo, flags) - 28usize];
    ["Offset of field: _drmModeModeInfo::type_"]
        [::core::mem::offset_of!(_drmModeModeInfo, type_) - 32usize];
    ["Offset of field: _drmModeModeInfo::name"]
        [::core::mem::offset_of!(_drmModeModeInfo, name) - 36usize];
};
pub type drmModeModeInfo = _drmModeModeInfo;
pub type drmModeModeInfoPtr = *mut _drmModeModeInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeFB {
    pub fb_id: u32,
    pub width: u32,
    pub height: u32,
    pub pitch: u32,
    pub bpp: u32,
    pub depth: u32,
    pub handle: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModeFB"][::core::mem::size_of::<_drmModeFB>() - 28usize];
    ["Alignment of _drmModeFB"][::core::mem::align_of::<_drmModeFB>() - 4usize];
    ["Offset of field: _drmModeFB::fb_id"][::core::mem::offset_of!(_drmModeFB, fb_id) - 0usize];
    ["Offset of field: _drmModeFB::width"][::core::mem::offset_of!(_drmModeFB, width) - 4usize];
    ["Offset of field: _drmModeFB::height"][::core::mem::offset_of!(_drmModeFB, height) - 8usize];
    ["Offset of field: _drmModeFB::pitch"][::core::mem::offset_of!(_drmModeFB, pitch) - 12usize];
    ["Offset of field: _drmModeFB::bpp"][::core::mem::offset_of!(_drmModeFB, bpp) - 16usize];
    ["Offset of field: _drmModeFB::depth"][::core::mem::offset_of!(_drmModeFB, depth) - 20usize];
    ["Offset of field: _drmModeFB::handle"][::core::mem::offset_of!(_drmModeFB, handle) - 24usize];
};
pub type drmModeFB = _drmModeFB;
pub type drmModeFBPtr = *mut _drmModeFB;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeFB2 {
    pub fb_id: u32,
    pub width: u32,
    pub height: u32,
    pub pixel_format: u32,
    pub modifier: u64,
    pub flags: u32,
    pub handles: [u32; 4usize],
    pub pitches: [u32; 4usize],
    pub offsets: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModeFB2"][::core::mem::size_of::<_drmModeFB2>() - 80usize];
    ["Alignment of _drmModeFB2"][::core::mem::align_of::<_drmModeFB2>() - 8usize];
    ["Offset of field: _drmModeFB2::fb_id"][::core::mem::offset_of!(_drmModeFB2, fb_id) - 0usize];
    ["Offset of field: _drmModeFB2::width"][::core::mem::offset_of!(_drmModeFB2, width) - 4usize];
    ["Offset of field: _drmModeFB2::height"][::core::mem::offset_of!(_drmModeFB2, height) - 8usize];
    ["Offset of field: _drmModeFB2::pixel_format"]
        [::core::mem::offset_of!(_drmModeFB2, pixel_format) - 12usize];
    ["Offset of field: _drmModeFB2::modifier"]
        [::core::mem::offset_of!(_drmModeFB2, modifier) - 16usize];
    ["Offset of field: _drmModeFB2::flags"][::core::mem::offset_of!(_drmModeFB2, flags) - 24usize];
    ["Offset of field: _drmModeFB2::handles"]
        [::core::mem::offset_of!(_drmModeFB2, handles) - 28usize];
    ["Offset of field: _drmModeFB2::pitches"]
        [::core::mem::offset_of!(_drmModeFB2, pitches) - 44usize];
    ["Offset of field: _drmModeFB2::offsets"]
        [::core::mem::offset_of!(_drmModeFB2, offsets) - 60usize];
};
pub type drmModeFB2 = _drmModeFB2;
pub type drmModeFB2Ptr = *mut _drmModeFB2;
pub type drmModeClip = drm_clip_rect;
pub type drmModeClipPtr = *mut drm_clip_rect;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModePropertyBlob {
    pub id: u32,
    pub length: u32,
    pub data: *mut ::core::ffi::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModePropertyBlob"][::core::mem::size_of::<_drmModePropertyBlob>() - 16usize];
    ["Alignment of _drmModePropertyBlob"][::core::mem::align_of::<_drmModePropertyBlob>() - 8usize];
    ["Offset of field: _drmModePropertyBlob::id"]
        [::core::mem::offset_of!(_drmModePropertyBlob, id) - 0usize];
    ["Offset of field: _drmModePropertyBlob::length"]
        [::core::mem::offset_of!(_drmModePropertyBlob, length) - 4usize];
    ["Offset of field: _drmModePropertyBlob::data"]
        [::core::mem::offset_of!(_drmModePropertyBlob, data) - 8usize];
};
pub type drmModePropertyBlobRes = _drmModePropertyBlob;
pub type drmModePropertyBlobPtr = *mut _drmModePropertyBlob;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeProperty {
    pub prop_id: u32,
    pub flags: u32,
    pub name: [::core::ffi::c_char; 32usize],
    pub count_values: ::core::ffi::c_int,
    pub values: *mut u64,
    pub count_enums: ::core::ffi::c_int,
    pub enums: *mut drm_mode_property_enum,
    pub count_blobs: ::core::ffi::c_int,
    pub blob_ids: *mut u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModeProperty"][::core::mem::size_of::<_drmModeProperty>() - 88usize];
    ["Alignment of _drmModeProperty"][::core::mem::align_of::<_drmModeProperty>() - 8usize];
    ["Offset of field: _drmModeProperty::prop_id"]
        [::core::mem::offset_of!(_drmModeProperty, prop_id) - 0usize];
    ["Offset of field: _drmModeProperty::flags"]
        [::core::mem::offset_of!(_drmModeProperty, flags) - 4usize];
    ["Offset of field: _drmModeProperty::name"]
        [::core::mem::offset_of!(_drmModeProperty, name) - 8usize];
    ["Offset of field: _drmModeProperty::count_values"]
        [::core::mem::offset_of!(_drmModeProperty, count_values) - 40usize];
    ["Offset of field: _drmModeProperty::values"]
        [::core::mem::offset_of!(_drmModeProperty, values) - 48usize];
    ["Offset of field: _drmModeProperty::count_enums"]
        [::core::mem::offset_of!(_drmModeProperty, count_enums) - 56usize];
    ["Offset of field: _drmModeProperty::enums"]
        [::core::mem::offset_of!(_drmModeProperty, enums) - 64usize];
    ["Offset of field: _drmModeProperty::count_blobs"]
        [::core::mem::offset_of!(_drmModeProperty, count_blobs) - 72usize];
    ["Offset of field: _drmModeProperty::blob_ids"]
        [::core::mem::offset_of!(_drmModeProperty, blob_ids) - 80usize];
};
pub type drmModePropertyRes = _drmModeProperty;
pub type drmModePropertyPtr = *mut _drmModeProperty;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeCrtc {
    pub crtc_id: u32,
    pub buffer_id: u32,
    pub x: u32,
    pub y: u32,
    pub width: u32,
    pub height: u32,
    pub mode_valid: ::core::ffi::c_int,
    pub mode: drmModeModeInfo,
    pub gamma_size: ::core::ffi::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModeCrtc"][::core::mem::size_of::<_drmModeCrtc>() - 100usize];
    ["Alignment of _drmModeCrtc"][::core::mem::align_of::<_drmModeCrtc>() - 4usize];
    ["Offset of field: _drmModeCrtc::crtc_id"]
        [::core::mem::offset_of!(_drmModeCrtc, crtc_id) - 0usize];
    ["Offset of field: _drmModeCrtc::buffer_id"]
        [::core::mem::offset_of!(_drmModeCrtc, buffer_id) - 4usize];
    ["Offset of field: _drmModeCrtc::x"][::core::mem::offset_of!(_drmModeCrtc, x) - 8usize];
    ["Offset of field: _drmModeCrtc::y"][::core::mem::offset_of!(_drmModeCrtc, y) - 12usize];
    ["Offset of field: _drmModeCrtc::width"]
        [::core::mem::offset_of!(_drmModeCrtc, width) - 16usize];
    ["Offset of field: _drmModeCrtc::height"]
        [::core::mem::offset_of!(_drmModeCrtc, height) - 20usize];
    ["Offset of field: _drmModeCrtc::mode_valid"]
        [::core::mem::offset_of!(_drmModeCrtc, mode_valid) - 24usize];
    ["Offset of field: _drmModeCrtc::mode"][::core::mem::offset_of!(_drmModeCrtc, mode) - 28usize];
    ["Offset of field: _drmModeCrtc::gamma_size"]
        [::core::mem::offset_of!(_drmModeCrtc, gamma_size) - 96usize];
};
pub type drmModeCrtc = _drmModeCrtc;
pub type drmModeCrtcPtr = *mut _drmModeCrtc;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeEncoder {
    pub encoder_id: u32,
    pub encoder_type: u32,
    pub crtc_id: u32,
    pub possible_crtcs: u32,
    pub possible_clones: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModeEncoder"][::core::mem::size_of::<_drmModeEncoder>() - 20usize];
    ["Alignment of _drmModeEncoder"][::core::mem::align_of::<_drmModeEncoder>() - 4usize];
    ["Offset of field: _drmModeEncoder::encoder_id"]
        [::core::mem::offset_of!(_drmModeEncoder, encoder_id) - 0usize];
    ["Offset of field: _drmModeEncoder::encoder_type"]
        [::core::mem::offset_of!(_drmModeEncoder, encoder_type) - 4usize];
    ["Offset of field: _drmModeEncoder::crtc_id"]
        [::core::mem::offset_of!(_drmModeEncoder, crtc_id) - 8usize];
    ["Offset of field: _drmModeEncoder::possible_crtcs"]
        [::core::mem::offset_of!(_drmModeEncoder, possible_crtcs) - 12usize];
    ["Offset of field: _drmModeEncoder::possible_clones"]
        [::core::mem::offset_of!(_drmModeEncoder, possible_clones) - 16usize];
};
pub type drmModeEncoder = _drmModeEncoder;
pub type drmModeEncoderPtr = *mut _drmModeEncoder;
pub const drmModeConnection_DRM_MODE_CONNECTED: drmModeConnection = 1;
pub const drmModeConnection_DRM_MODE_DISCONNECTED: drmModeConnection = 2;
pub const drmModeConnection_DRM_MODE_UNKNOWNCONNECTION: drmModeConnection = 3;
pub type drmModeConnection = ::core::ffi::c_uint;
pub const drmModeSubPixel_DRM_MODE_SUBPIXEL_UNKNOWN: drmModeSubPixel = 1;
pub const drmModeSubPixel_DRM_MODE_SUBPIXEL_HORIZONTAL_RGB: drmModeSubPixel = 2;
pub const drmModeSubPixel_DRM_MODE_SUBPIXEL_HORIZONTAL_BGR: drmModeSubPixel = 3;
pub const drmModeSubPixel_DRM_MODE_SUBPIXEL_VERTICAL_RGB: drmModeSubPixel = 4;
pub const drmModeSubPixel_DRM_MODE_SUBPIXEL_VERTICAL_BGR: drmModeSubPixel = 5;
pub const drmModeSubPixel_DRM_MODE_SUBPIXEL_NONE: drmModeSubPixel = 6;
pub type drmModeSubPixel = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeConnector {
    pub connector_id: u32,
    pub encoder_id: u32,
    pub connector_type: u32,
    pub connector_type_id: u32,
    pub connection: drmModeConnection,
    pub mmWidth: u32,
    pub mmHeight: u32,
    pub subpixel: drmModeSubPixel,
    pub count_modes: ::core::ffi::c_int,
    pub modes: drmModeModeInfoPtr,
    pub count_props: ::core::ffi::c_int,
    pub props: *mut u32,
    pub prop_values: *mut u64,
    pub count_encoders: ::core::ffi::c_int,
    pub encoders: *mut u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModeConnector"][::core::mem::size_of::<_drmModeConnector>() - 88usize];
    ["Alignment of _drmModeConnector"][::core::mem::align_of::<_drmModeConnector>() - 8usize];
    ["Offset of field: _drmModeConnector::connector_id"]
        [::core::mem::offset_of!(_drmModeConnector, connector_id) - 0usize];
    ["Offset of field: _drmModeConnector::encoder_id"]
        [::core::mem::offset_of!(_drmModeConnector, encoder_id) - 4usize];
    ["Offset of field: _drmModeConnector::connector_type"]
        [::core::mem::offset_of!(_drmModeConnector, connector_type) - 8usize];
    ["Offset of field: _drmModeConnector::connector_type_id"]
        [::core::mem::offset_of!(_drmModeConnector, connector_type_id) - 12usize];
    ["Offset of field: _drmModeConnector::connection"]
        [::core::mem::offset_of!(_drmModeConnector, connection) - 16usize];
    ["Offset of field: _drmModeConnector::mmWidth"]
        [::core::mem::offset_of!(_drmModeConnector, mmWidth) - 20usize];
    ["Offset of field: _drmModeConnector::mmHeight"]
        [::core::mem::offset_of!(_drmModeConnector, mmHeight) - 24usize];
    ["Offset of field: _drmModeConnector::subpixel"]
        [::core::mem::offset_of!(_drmModeConnector, subpixel) - 28usize];
    ["Offset of field: _drmModeConnector::count_modes"]
        [::core::mem::offset_of!(_drmModeConnector, count_modes) - 32usize];
    ["Offset of field: _drmModeConnector::modes"]
        [::core::mem::offset_of!(_drmModeConnector, modes) - 40usize];
    ["Offset of field: _drmModeConnector::count_props"]
        [::core::mem::offset_of!(_drmModeConnector, count_props) - 48usize];
    ["Offset of field: _drmModeConnector::props"]
        [::core::mem::offset_of!(_drmModeConnector, props) - 56usize];
    ["Offset of field: _drmModeConnector::prop_values"]
        [::core::mem::offset_of!(_drmModeConnector, prop_values) - 64usize];
    ["Offset of field: _drmModeConnector::count_encoders"]
        [::core::mem::offset_of!(_drmModeConnector, count_encoders) - 72usize];
    ["Offset of field: _drmModeConnector::encoders"]
        [::core::mem::offset_of!(_drmModeConnector, encoders) - 80usize];
};
pub type drmModeConnector = _drmModeConnector;
pub type drmModeConnectorPtr = *mut _drmModeConnector;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeObjectProperties {
    pub count_props: u32,
    pub props: *mut u32,
    pub prop_values: *mut u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModeObjectProperties"]
        [::core::mem::size_of::<_drmModeObjectProperties>() - 24usize];
    ["Alignment of _drmModeObjectProperties"]
        [::core::mem::align_of::<_drmModeObjectProperties>() - 8usize];
    ["Offset of field: _drmModeObjectProperties::count_props"]
        [::core::mem::offset_of!(_drmModeObjectProperties, count_props) - 0usize];
    ["Offset of field: _drmModeObjectProperties::props"]
        [::core::mem::offset_of!(_drmModeObjectProperties, props) - 8usize];
    ["Offset of field: _drmModeObjectProperties::prop_values"]
        [::core::mem::offset_of!(_drmModeObjectProperties, prop_values) - 16usize];
};
pub type drmModeObjectProperties = _drmModeObjectProperties;
pub type drmModeObjectPropertiesPtr = *mut _drmModeObjectProperties;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeFormatModifierIterator {
    pub fmt_idx: u32,
    pub mod_idx: u32,
    pub fmt: u32,
    pub mod_: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModeFormatModifierIterator"]
        [::core::mem::size_of::<_drmModeFormatModifierIterator>() - 24usize];
    ["Alignment of _drmModeFormatModifierIterator"]
        [::core::mem::align_of::<_drmModeFormatModifierIterator>() - 8usize];
    ["Offset of field: _drmModeFormatModifierIterator::fmt_idx"]
        [::core::mem::offset_of!(_drmModeFormatModifierIterator, fmt_idx) - 0usize];
    ["Offset of field: _drmModeFormatModifierIterator::mod_idx"]
        [::core::mem::offset_of!(_drmModeFormatModifierIterator, mod_idx) - 4usize];
    ["Offset of field: _drmModeFormatModifierIterator::fmt"]
        [::core::mem::offset_of!(_drmModeFormatModifierIterator, fmt) - 8usize];
    ["Offset of field: _drmModeFormatModifierIterator::mod_"]
        [::core::mem::offset_of!(_drmModeFormatModifierIterator, mod_) - 16usize];
};
pub type drmModeFormatModifierIterator = _drmModeFormatModifierIterator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModePlane {
    pub count_formats: u32,
    pub formats: *mut u32,
    pub plane_id: u32,
    pub crtc_id: u32,
    pub fb_id: u32,
    pub crtc_x: u32,
    pub crtc_y: u32,
    pub x: u32,
    pub y: u32,
    pub possible_crtcs: u32,
    pub gamma_size: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModePlane"][::core::mem::size_of::<_drmModePlane>() - 56usize];
    ["Alignment of _drmModePlane"][::core::mem::align_of::<_drmModePlane>() - 8usize];
    ["Offset of field: _drmModePlane::count_formats"]
        [::core::mem::offset_of!(_drmModePlane, count_formats) - 0usize];
    ["Offset of field: _drmModePlane::formats"]
        [::core::mem::offset_of!(_drmModePlane, formats) - 8usize];
    ["Offset of field: _drmModePlane::plane_id"]
        [::core::mem::offset_of!(_drmModePlane, plane_id) - 16usize];
    ["Offset of field: _drmModePlane::crtc_id"]
        [::core::mem::offset_of!(_drmModePlane, crtc_id) - 20usize];
    ["Offset of field: _drmModePlane::fb_id"]
        [::core::mem::offset_of!(_drmModePlane, fb_id) - 24usize];
    ["Offset of field: _drmModePlane::crtc_x"]
        [::core::mem::offset_of!(_drmModePlane, crtc_x) - 28usize];
    ["Offset of field: _drmModePlane::crtc_y"]
        [::core::mem::offset_of!(_drmModePlane, crtc_y) - 32usize];
    ["Offset of field: _drmModePlane::x"][::core::mem::offset_of!(_drmModePlane, x) - 36usize];
    ["Offset of field: _drmModePlane::y"][::core::mem::offset_of!(_drmModePlane, y) - 40usize];
    ["Offset of field: _drmModePlane::possible_crtcs"]
        [::core::mem::offset_of!(_drmModePlane, possible_crtcs) - 44usize];
    ["Offset of field: _drmModePlane::gamma_size"]
        [::core::mem::offset_of!(_drmModePlane, gamma_size) - 48usize];
};
pub type drmModePlane = _drmModePlane;
pub type drmModePlanePtr = *mut _drmModePlane;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModePlaneRes {
    pub count_planes: u32,
    pub planes: *mut u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _drmModePlaneRes"][::core::mem::size_of::<_drmModePlaneRes>() - 16usize];
    ["Alignment of _drmModePlaneRes"][::core::mem::align_of::<_drmModePlaneRes>() - 8usize];
    ["Offset of field: _drmModePlaneRes::count_planes"]
        [::core::mem::offset_of!(_drmModePlaneRes, count_planes) - 0usize];
    ["Offset of field: _drmModePlaneRes::planes"]
        [::core::mem::offset_of!(_drmModePlaneRes, planes) - 8usize];
};
pub type drmModePlaneRes = _drmModePlaneRes;
pub type drmModePlaneResPtr = *mut _drmModePlaneRes;
extern "C" {
    pub fn drmModeFreeModeInfo(ptr: drmModeModeInfoPtr);
}
extern "C" {
    pub fn drmModeFreeResources(ptr: drmModeResPtr);
}
extern "C" {
    pub fn drmModeFreeFB(ptr: drmModeFBPtr);
}
extern "C" {
    pub fn drmModeFreeFB2(ptr: drmModeFB2Ptr);
}
extern "C" {
    pub fn drmModeFreeCrtc(ptr: drmModeCrtcPtr);
}
extern "C" {
    pub fn drmModeFreeConnector(ptr: drmModeConnectorPtr);
}
extern "C" {
    pub fn drmModeFreeEncoder(ptr: drmModeEncoderPtr);
}
extern "C" {
    pub fn drmModeFreePlane(ptr: drmModePlanePtr);
}
extern "C" {
    pub fn drmModeFreePlaneResources(ptr: drmModePlaneResPtr);
}
extern "C" {
    pub fn drmIsKMS(fd: ::core::ffi::c_int) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeGetResources(fd: ::core::ffi::c_int) -> drmModeResPtr;
}
extern "C" {
    pub fn drmModeGetFB(fd: ::core::ffi::c_int, bufferId: u32) -> drmModeFBPtr;
}
extern "C" {
    pub fn drmModeGetFB2(fd: ::core::ffi::c_int, bufferId: u32) -> drmModeFB2Ptr;
}
extern "C" {
    pub fn drmModeAddFB(
        fd: ::core::ffi::c_int,
        width: u32,
        height: u32,
        depth: u8,
        bpp: u8,
        pitch: u32,
        bo_handle: u32,
        buf_id: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeAddFB2(
        fd: ::core::ffi::c_int,
        width: u32,
        height: u32,
        pixel_format: u32,
        bo_handles: *const u32,
        pitches: *const u32,
        offsets: *const u32,
        buf_id: *mut u32,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeAddFB2WithModifiers(
        fd: ::core::ffi::c_int,
        width: u32,
        height: u32,
        pixel_format: u32,
        bo_handles: *const u32,
        pitches: *const u32,
        offsets: *const u32,
        modifier: *const u64,
        buf_id: *mut u32,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeRmFB(fd: ::core::ffi::c_int, bufferId: u32) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeCloseFB(fd: ::core::ffi::c_int, buffer_id: u32) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeDirtyFB(
        fd: ::core::ffi::c_int,
        bufferId: u32,
        clips: drmModeClipPtr,
        num_clips: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeGetCrtc(fd: ::core::ffi::c_int, crtcId: u32) -> drmModeCrtcPtr;
}
extern "C" {
    pub fn drmModeSetCrtc(
        fd: ::core::ffi::c_int,
        crtcId: u32,
        bufferId: u32,
        x: u32,
        y: u32,
        connectors: *mut u32,
        count: ::core::ffi::c_int,
        mode: drmModeModeInfoPtr,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeSetCursor(
        fd: ::core::ffi::c_int,
        crtcId: u32,
        bo_handle: u32,
        width: u32,
        height: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeSetCursor2(
        fd: ::core::ffi::c_int,
        crtcId: u32,
        bo_handle: u32,
        width: u32,
        height: u32,
        hot_x: i32,
        hot_y: i32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeMoveCursor(
        fd: ::core::ffi::c_int,
        crtcId: u32,
        x: ::core::ffi::c_int,
        y: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeGetEncoder(fd: ::core::ffi::c_int, encoder_id: u32) -> drmModeEncoderPtr;
}
extern "C" {
    pub fn drmModeGetConnector(fd: ::core::ffi::c_int, connectorId: u32) -> drmModeConnectorPtr;
}
extern "C" {
    pub fn drmModeGetConnectorCurrent(
        fd: ::core::ffi::c_int,
        connector_id: u32,
    ) -> drmModeConnectorPtr;
}
extern "C" {
    pub fn drmModeConnectorGetPossibleCrtcs(
        fd: ::core::ffi::c_int,
        connector: *const drmModeConnector,
    ) -> u32;
}
extern "C" {
    pub fn drmModeAttachMode(
        fd: ::core::ffi::c_int,
        connectorId: u32,
        mode_info: drmModeModeInfoPtr,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeDetachMode(
        fd: ::core::ffi::c_int,
        connectorId: u32,
        mode_info: drmModeModeInfoPtr,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeGetProperty(fd: ::core::ffi::c_int, propertyId: u32) -> drmModePropertyPtr;
}
extern "C" {
    pub fn drmModeFreeProperty(ptr: drmModePropertyPtr);
}
extern "C" {
    pub fn drmModeGetPropertyBlob(fd: ::core::ffi::c_int, blob_id: u32) -> drmModePropertyBlobPtr;
}
extern "C" {
    pub fn drmModeFormatModifierBlobIterNext(
        blob: *const drmModePropertyBlobRes,
        iter: *mut drmModeFormatModifierIterator,
    ) -> bool;
}
extern "C" {
    pub fn drmModeFreePropertyBlob(ptr: drmModePropertyBlobPtr);
}
extern "C" {
    pub fn drmModeConnectorSetProperty(
        fd: ::core::ffi::c_int,
        connector_id: u32,
        property_id: u32,
        value: u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmCheckModesettingSupported(busid: *const ::core::ffi::c_char) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeCrtcSetGamma(
        fd: ::core::ffi::c_int,
        crtc_id: u32,
        size: u32,
        red: *const u16,
        green: *const u16,
        blue: *const u16,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeCrtcGetGamma(
        fd: ::core::ffi::c_int,
        crtc_id: u32,
        size: u32,
        red: *mut u16,
        green: *mut u16,
        blue: *mut u16,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModePageFlip(
        fd: ::core::ffi::c_int,
        crtc_id: u32,
        fb_id: u32,
        flags: u32,
        user_data: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModePageFlipTarget(
        fd: ::core::ffi::c_int,
        crtc_id: u32,
        fb_id: u32,
        flags: u32,
        user_data: *mut ::core::ffi::c_void,
        target_vblank: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeGetPlaneResources(fd: ::core::ffi::c_int) -> drmModePlaneResPtr;
}
extern "C" {
    pub fn drmModeGetPlane(fd: ::core::ffi::c_int, plane_id: u32) -> drmModePlanePtr;
}
extern "C" {
    pub fn drmModeSetPlane(
        fd: ::core::ffi::c_int,
        plane_id: u32,
        crtc_id: u32,
        fb_id: u32,
        flags: u32,
        crtc_x: i32,
        crtc_y: i32,
        crtc_w: u32,
        crtc_h: u32,
        src_x: u32,
        src_y: u32,
        src_w: u32,
        src_h: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeObjectGetProperties(
        fd: ::core::ffi::c_int,
        object_id: u32,
        object_type: u32,
    ) -> drmModeObjectPropertiesPtr;
}
extern "C" {
    pub fn drmModeFreeObjectProperties(ptr: drmModeObjectPropertiesPtr);
}
extern "C" {
    pub fn drmModeObjectSetProperty(
        fd: ::core::ffi::c_int,
        object_id: u32,
        object_type: u32,
        property_id: u32,
        value: u64,
    ) -> ::core::ffi::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _drmModeAtomicReq {
    _unused: [u8; 0],
}
pub type drmModeAtomicReq = _drmModeAtomicReq;
pub type drmModeAtomicReqPtr = *mut _drmModeAtomicReq;
extern "C" {
    pub fn drmModeAtomicAlloc() -> drmModeAtomicReqPtr;
}
extern "C" {
    pub fn drmModeAtomicDuplicate(req: drmModeAtomicReqPtr) -> drmModeAtomicReqPtr;
}
extern "C" {
    pub fn drmModeAtomicMerge(
        base: drmModeAtomicReqPtr,
        augment: drmModeAtomicReqPtr,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeAtomicFree(req: drmModeAtomicReqPtr);
}
extern "C" {
    pub fn drmModeAtomicGetCursor(req: drmModeAtomicReqPtr) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeAtomicSetCursor(req: drmModeAtomicReqPtr, cursor: ::core::ffi::c_int);
}
extern "C" {
    pub fn drmModeAtomicAddProperty(
        req: drmModeAtomicReqPtr,
        object_id: u32,
        property_id: u32,
        value: u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeAtomicCommit(
        fd: ::core::ffi::c_int,
        req: drmModeAtomicReqPtr,
        flags: u32,
        user_data: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeCreatePropertyBlob(
        fd: ::core::ffi::c_int,
        data: *const ::core::ffi::c_void,
        size: usize,
        id: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeDestroyPropertyBlob(fd: ::core::ffi::c_int, id: u32) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeCreateLease(
        fd: ::core::ffi::c_int,
        objects: *const u32,
        num_objects: ::core::ffi::c_int,
        flags: ::core::ffi::c_int,
        lessee_id: *mut u32,
    ) -> ::core::ffi::c_int;
}
#[repr(C)]
#[derive(Debug)]
pub struct drmModeLesseeList {
    pub count: u32,
    pub lessees: __IncompleteArrayField<u32>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drmModeLesseeList"][::core::mem::size_of::<drmModeLesseeList>() - 4usize];
    ["Alignment of drmModeLesseeList"][::core::mem::align_of::<drmModeLesseeList>() - 4usize];
    ["Offset of field: drmModeLesseeList::count"]
        [::core::mem::offset_of!(drmModeLesseeList, count) - 0usize];
    ["Offset of field: drmModeLesseeList::lessees"]
        [::core::mem::offset_of!(drmModeLesseeList, lessees) - 4usize];
};
pub type drmModeLesseeListRes = drmModeLesseeList;
pub type drmModeLesseeListPtr = *mut drmModeLesseeList;
extern "C" {
    pub fn drmModeListLessees(fd: ::core::ffi::c_int) -> drmModeLesseeListPtr;
}
#[repr(C)]
#[derive(Debug)]
pub struct drmModeObjectList {
    pub count: u32,
    pub objects: __IncompleteArrayField<u32>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drmModeObjectList"][::core::mem::size_of::<drmModeObjectList>() - 4usize];
    ["Alignment of drmModeObjectList"][::core::mem::align_of::<drmModeObjectList>() - 4usize];
    ["Offset of field: drmModeObjectList::count"]
        [::core::mem::offset_of!(drmModeObjectList, count) - 0usize];
    ["Offset of field: drmModeObjectList::objects"]
        [::core::mem::offset_of!(drmModeObjectList, objects) - 4usize];
};
pub type drmModeObjectListRes = drmModeObjectList;
pub type drmModeObjectListPtr = *mut drmModeObjectList;
extern "C" {
    pub fn drmModeGetLease(fd: ::core::ffi::c_int) -> drmModeObjectListPtr;
}
extern "C" {
    pub fn drmModeRevokeLease(fd: ::core::ffi::c_int, lessee_id: u32) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeGetConnectorTypeName(connector_type: u32) -> *const ::core::ffi::c_char;
}
extern "C" {
    pub fn drmModeCreateDumbBuffer(
        fd: ::core::ffi::c_int,
        width: u32,
        height: u32,
        bpp: u32,
        flags: u32,
        handle: *mut u32,
        pitch: *mut u32,
        size: *mut u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeDestroyDumbBuffer(fd: ::core::ffi::c_int, handle: u32) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn drmModeMapDumbBuffer(
        fd: ::core::ffi::c_int,
        handle: u32,
        offset: *mut u64,
    ) -> ::core::ffi::c_int;
}
pub const amdgpu_bo_handle_type_amdgpu_bo_handle_type_gem_flink_name: amdgpu_bo_handle_type = 0;
pub const amdgpu_bo_handle_type_amdgpu_bo_handle_type_kms: amdgpu_bo_handle_type = 1;
pub const amdgpu_bo_handle_type_amdgpu_bo_handle_type_dma_buf_fd: amdgpu_bo_handle_type = 2;
pub const amdgpu_bo_handle_type_amdgpu_bo_handle_type_kms_noimport: amdgpu_bo_handle_type = 3;
pub type amdgpu_bo_handle_type = ::core::ffi::c_uint;
pub const amdgpu_gpu_va_range_amdgpu_gpu_va_range_general: amdgpu_gpu_va_range = 0;
pub type amdgpu_gpu_va_range = ::core::ffi::c_uint;
pub const amdgpu_sw_info_amdgpu_sw_info_address32_hi: amdgpu_sw_info = 0;
pub type amdgpu_sw_info = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_device {
    _unused: [u8; 0],
}
pub type amdgpu_device_handle = *mut amdgpu_device;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_context {
    _unused: [u8; 0],
}
pub type amdgpu_context_handle = *mut amdgpu_context;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_bo {
    _unused: [u8; 0],
}
pub type amdgpu_bo_handle = *mut amdgpu_bo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_bo_list {
    _unused: [u8; 0],
}
pub type amdgpu_bo_list_handle = *mut amdgpu_bo_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_va {
    _unused: [u8; 0],
}
pub type amdgpu_va_handle = *mut amdgpu_va;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_semaphore {
    _unused: [u8; 0],
}
pub type amdgpu_semaphore_handle = *mut amdgpu_semaphore;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_bo_alloc_request {
    pub alloc_size: u64,
    pub phys_alignment: u64,
    pub preferred_heap: u32,
    pub flags: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amdgpu_bo_alloc_request"]
        [::core::mem::size_of::<amdgpu_bo_alloc_request>() - 32usize];
    ["Alignment of amdgpu_bo_alloc_request"]
        [::core::mem::align_of::<amdgpu_bo_alloc_request>() - 8usize];
    ["Offset of field: amdgpu_bo_alloc_request::alloc_size"]
        [::core::mem::offset_of!(amdgpu_bo_alloc_request, alloc_size) - 0usize];
    ["Offset of field: amdgpu_bo_alloc_request::phys_alignment"]
        [::core::mem::offset_of!(amdgpu_bo_alloc_request, phys_alignment) - 8usize];
    ["Offset of field: amdgpu_bo_alloc_request::preferred_heap"]
        [::core::mem::offset_of!(amdgpu_bo_alloc_request, preferred_heap) - 16usize];
    ["Offset of field: amdgpu_bo_alloc_request::flags"]
        [::core::mem::offset_of!(amdgpu_bo_alloc_request, flags) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_bo_metadata {
    pub flags: u64,
    pub tiling_info: u64,
    pub size_metadata: u32,
    pub umd_metadata: [u32; 64usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amdgpu_bo_metadata"][::core::mem::size_of::<amdgpu_bo_metadata>() - 280usize];
    ["Alignment of amdgpu_bo_metadata"][::core::mem::align_of::<amdgpu_bo_metadata>() - 8usize];
    ["Offset of field: amdgpu_bo_metadata::flags"]
        [::core::mem::offset_of!(amdgpu_bo_metadata, flags) - 0usize];
    ["Offset of field: amdgpu_bo_metadata::tiling_info"]
        [::core::mem::offset_of!(amdgpu_bo_metadata, tiling_info) - 8usize];
    ["Offset of field: amdgpu_bo_metadata::size_metadata"]
        [::core::mem::offset_of!(amdgpu_bo_metadata, size_metadata) - 16usize];
    ["Offset of field: amdgpu_bo_metadata::umd_metadata"]
        [::core::mem::offset_of!(amdgpu_bo_metadata, umd_metadata) - 20usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_bo_info {
    pub alloc_size: u64,
    pub phys_alignment: u64,
    pub preferred_heap: u32,
    pub alloc_flags: u64,
    pub metadata: amdgpu_bo_metadata,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amdgpu_bo_info"][::core::mem::size_of::<amdgpu_bo_info>() - 312usize];
    ["Alignment of amdgpu_bo_info"][::core::mem::align_of::<amdgpu_bo_info>() - 8usize];
    ["Offset of field: amdgpu_bo_info::alloc_size"]
        [::core::mem::offset_of!(amdgpu_bo_info, alloc_size) - 0usize];
    ["Offset of field: amdgpu_bo_info::phys_alignment"]
        [::core::mem::offset_of!(amdgpu_bo_info, phys_alignment) - 8usize];
    ["Offset of field: amdgpu_bo_info::preferred_heap"]
        [::core::mem::offset_of!(amdgpu_bo_info, preferred_heap) - 16usize];
    ["Offset of field: amdgpu_bo_info::alloc_flags"]
        [::core::mem::offset_of!(amdgpu_bo_info, alloc_flags) - 24usize];
    ["Offset of field: amdgpu_bo_info::metadata"]
        [::core::mem::offset_of!(amdgpu_bo_info, metadata) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_bo_import_result {
    pub buf_handle: amdgpu_bo_handle,
    pub alloc_size: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amdgpu_bo_import_result"]
        [::core::mem::size_of::<amdgpu_bo_import_result>() - 16usize];
    ["Alignment of amdgpu_bo_import_result"]
        [::core::mem::align_of::<amdgpu_bo_import_result>() - 8usize];
    ["Offset of field: amdgpu_bo_import_result::buf_handle"]
        [::core::mem::offset_of!(amdgpu_bo_import_result, buf_handle) - 0usize];
    ["Offset of field: amdgpu_bo_import_result::alloc_size"]
        [::core::mem::offset_of!(amdgpu_bo_import_result, alloc_size) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_gds_resource_info {
    pub gds_gfx_partition_size: u32,
    pub compute_partition_size: u32,
    pub gds_total_size: u32,
    pub gws_per_gfx_partition: u32,
    pub gws_per_compute_partition: u32,
    pub oa_per_gfx_partition: u32,
    pub oa_per_compute_partition: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amdgpu_gds_resource_info"]
        [::core::mem::size_of::<amdgpu_gds_resource_info>() - 28usize];
    ["Alignment of amdgpu_gds_resource_info"]
        [::core::mem::align_of::<amdgpu_gds_resource_info>() - 4usize];
    ["Offset of field: amdgpu_gds_resource_info::gds_gfx_partition_size"]
        [::core::mem::offset_of!(amdgpu_gds_resource_info, gds_gfx_partition_size) - 0usize];
    ["Offset of field: amdgpu_gds_resource_info::compute_partition_size"]
        [::core::mem::offset_of!(amdgpu_gds_resource_info, compute_partition_size) - 4usize];
    ["Offset of field: amdgpu_gds_resource_info::gds_total_size"]
        [::core::mem::offset_of!(amdgpu_gds_resource_info, gds_total_size) - 8usize];
    ["Offset of field: amdgpu_gds_resource_info::gws_per_gfx_partition"]
        [::core::mem::offset_of!(amdgpu_gds_resource_info, gws_per_gfx_partition) - 12usize];
    ["Offset of field: amdgpu_gds_resource_info::gws_per_compute_partition"]
        [::core::mem::offset_of!(amdgpu_gds_resource_info, gws_per_compute_partition) - 16usize];
    ["Offset of field: amdgpu_gds_resource_info::oa_per_gfx_partition"]
        [::core::mem::offset_of!(amdgpu_gds_resource_info, oa_per_gfx_partition) - 20usize];
    ["Offset of field: amdgpu_gds_resource_info::oa_per_compute_partition"]
        [::core::mem::offset_of!(amdgpu_gds_resource_info, oa_per_compute_partition) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_cs_fence {
    pub context: amdgpu_context_handle,
    pub ip_type: u32,
    pub ip_instance: u32,
    pub ring: u32,
    pub fence: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amdgpu_cs_fence"][::core::mem::size_of::<amdgpu_cs_fence>() - 32usize];
    ["Alignment of amdgpu_cs_fence"][::core::mem::align_of::<amdgpu_cs_fence>() - 8usize];
    ["Offset of field: amdgpu_cs_fence::context"]
        [::core::mem::offset_of!(amdgpu_cs_fence, context) - 0usize];
    ["Offset of field: amdgpu_cs_fence::ip_type"]
        [::core::mem::offset_of!(amdgpu_cs_fence, ip_type) - 8usize];
    ["Offset of field: amdgpu_cs_fence::ip_instance"]
        [::core::mem::offset_of!(amdgpu_cs_fence, ip_instance) - 12usize];
    ["Offset of field: amdgpu_cs_fence::ring"]
        [::core::mem::offset_of!(amdgpu_cs_fence, ring) - 16usize];
    ["Offset of field: amdgpu_cs_fence::fence"]
        [::core::mem::offset_of!(amdgpu_cs_fence, fence) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_cs_ib_info {
    pub flags: u64,
    pub ib_mc_address: u64,
    pub size: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amdgpu_cs_ib_info"][::core::mem::size_of::<amdgpu_cs_ib_info>() - 24usize];
    ["Alignment of amdgpu_cs_ib_info"][::core::mem::align_of::<amdgpu_cs_ib_info>() - 8usize];
    ["Offset of field: amdgpu_cs_ib_info::flags"]
        [::core::mem::offset_of!(amdgpu_cs_ib_info, flags) - 0usize];
    ["Offset of field: amdgpu_cs_ib_info::ib_mc_address"]
        [::core::mem::offset_of!(amdgpu_cs_ib_info, ib_mc_address) - 8usize];
    ["Offset of field: amdgpu_cs_ib_info::size"]
        [::core::mem::offset_of!(amdgpu_cs_ib_info, size) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_cs_fence_info {
    pub handle: amdgpu_bo_handle,
    pub offset: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amdgpu_cs_fence_info"][::core::mem::size_of::<amdgpu_cs_fence_info>() - 16usize];
    ["Alignment of amdgpu_cs_fence_info"][::core::mem::align_of::<amdgpu_cs_fence_info>() - 8usize];
    ["Offset of field: amdgpu_cs_fence_info::handle"]
        [::core::mem::offset_of!(amdgpu_cs_fence_info, handle) - 0usize];
    ["Offset of field: amdgpu_cs_fence_info::offset"]
        [::core::mem::offset_of!(amdgpu_cs_fence_info, offset) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_cs_request {
    pub flags: u64,
    pub ip_type: ::core::ffi::c_uint,
    pub ip_instance: ::core::ffi::c_uint,
    pub ring: u32,
    pub resources: amdgpu_bo_list_handle,
    pub number_of_dependencies: u32,
    pub dependencies: *mut amdgpu_cs_fence,
    pub number_of_ibs: u32,
    pub ibs: *mut amdgpu_cs_ib_info,
    pub seq_no: u64,
    pub fence_info: amdgpu_cs_fence_info,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amdgpu_cs_request"][::core::mem::size_of::<amdgpu_cs_request>() - 88usize];
    ["Alignment of amdgpu_cs_request"][::core::mem::align_of::<amdgpu_cs_request>() - 8usize];
    ["Offset of field: amdgpu_cs_request::flags"]
        [::core::mem::offset_of!(amdgpu_cs_request, flags) - 0usize];
    ["Offset of field: amdgpu_cs_request::ip_type"]
        [::core::mem::offset_of!(amdgpu_cs_request, ip_type) - 8usize];
    ["Offset of field: amdgpu_cs_request::ip_instance"]
        [::core::mem::offset_of!(amdgpu_cs_request, ip_instance) - 12usize];
    ["Offset of field: amdgpu_cs_request::ring"]
        [::core::mem::offset_of!(amdgpu_cs_request, ring) - 16usize];
    ["Offset of field: amdgpu_cs_request::resources"]
        [::core::mem::offset_of!(amdgpu_cs_request, resources) - 24usize];
    ["Offset of field: amdgpu_cs_request::number_of_dependencies"]
        [::core::mem::offset_of!(amdgpu_cs_request, number_of_dependencies) - 32usize];
    ["Offset of field: amdgpu_cs_request::dependencies"]
        [::core::mem::offset_of!(amdgpu_cs_request, dependencies) - 40usize];
    ["Offset of field: amdgpu_cs_request::number_of_ibs"]
        [::core::mem::offset_of!(amdgpu_cs_request, number_of_ibs) - 48usize];
    ["Offset of field: amdgpu_cs_request::ibs"]
        [::core::mem::offset_of!(amdgpu_cs_request, ibs) - 56usize];
    ["Offset of field: amdgpu_cs_request::seq_no"]
        [::core::mem::offset_of!(amdgpu_cs_request, seq_no) - 64usize];
    ["Offset of field: amdgpu_cs_request::fence_info"]
        [::core::mem::offset_of!(amdgpu_cs_request, fence_info) - 72usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_buffer_size_alignments {
    pub size_local: u64,
    pub size_remote: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amdgpu_buffer_size_alignments"]
        [::core::mem::size_of::<amdgpu_buffer_size_alignments>() - 16usize];
    ["Alignment of amdgpu_buffer_size_alignments"]
        [::core::mem::align_of::<amdgpu_buffer_size_alignments>() - 8usize];
    ["Offset of field: amdgpu_buffer_size_alignments::size_local"]
        [::core::mem::offset_of!(amdgpu_buffer_size_alignments, size_local) - 0usize];
    ["Offset of field: amdgpu_buffer_size_alignments::size_remote"]
        [::core::mem::offset_of!(amdgpu_buffer_size_alignments, size_remote) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_heap_info {
    pub heap_size: u64,
    pub heap_usage: u64,
    pub max_allocation: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amdgpu_heap_info"][::core::mem::size_of::<amdgpu_heap_info>() - 24usize];
    ["Alignment of amdgpu_heap_info"][::core::mem::align_of::<amdgpu_heap_info>() - 8usize];
    ["Offset of field: amdgpu_heap_info::heap_size"]
        [::core::mem::offset_of!(amdgpu_heap_info, heap_size) - 0usize];
    ["Offset of field: amdgpu_heap_info::heap_usage"]
        [::core::mem::offset_of!(amdgpu_heap_info, heap_usage) - 8usize];
    ["Offset of field: amdgpu_heap_info::max_allocation"]
        [::core::mem::offset_of!(amdgpu_heap_info, max_allocation) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amdgpu_gpu_info {
    pub asic_id: u32,
    pub chip_rev: u32,
    pub chip_external_rev: u32,
    pub family_id: u32,
    pub ids_flags: u64,
    pub max_engine_clk: u64,
    pub max_memory_clk: u64,
    pub num_shader_engines: u32,
    pub num_shader_arrays_per_engine: u32,
    pub avail_quad_shader_pipes: u32,
    pub max_quad_shader_pipes: u32,
    pub cache_entries_per_quad_pipe: u32,
    pub num_hw_gfx_contexts: u32,
    pub rb_pipes: u32,
    pub enabled_rb_pipes_mask: u32,
    pub gpu_counter_freq: u32,
    pub backend_disable: [u32; 4usize],
    pub mc_arb_ramcfg: u32,
    pub gb_addr_cfg: u32,
    pub gb_tile_mode: [u32; 32usize],
    pub gb_macro_tile_mode: [u32; 16usize],
    pub pa_sc_raster_cfg: [u32; 4usize],
    pub pa_sc_raster_cfg1: [u32; 4usize],
    pub cu_active_number: u32,
    pub cu_ao_mask: u32,
    pub cu_bitmap: [[u32; 4usize]; 4usize],
    pub vram_type: u32,
    pub vram_bit_width: u32,
    pub ce_ram_size: u32,
    pub vce_harvest_config: u32,
    pub pci_rev_id: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amdgpu_gpu_info"][::core::mem::size_of::<amdgpu_gpu_info>() - 416usize];
    ["Alignment of amdgpu_gpu_info"][::core::mem::align_of::<amdgpu_gpu_info>() - 8usize];
    ["Offset of field: amdgpu_gpu_info::asic_id"]
        [::core::mem::offset_of!(amdgpu_gpu_info, asic_id) - 0usize];
    ["Offset of field: amdgpu_gpu_info::chip_rev"]
        [::core::mem::offset_of!(amdgpu_gpu_info, chip_rev) - 4usize];
    ["Offset of field: amdgpu_gpu_info::chip_external_rev"]
        [::core::mem::offset_of!(amdgpu_gpu_info, chip_external_rev) - 8usize];
    ["Offset of field: amdgpu_gpu_info::family_id"]
        [::core::mem::offset_of!(amdgpu_gpu_info, family_id) - 12usize];
    ["Offset of field: amdgpu_gpu_info::ids_flags"]
        [::core::mem::offset_of!(amdgpu_gpu_info, ids_flags) - 16usize];
    ["Offset of field: amdgpu_gpu_info::max_engine_clk"]
        [::core::mem::offset_of!(amdgpu_gpu_info, max_engine_clk) - 24usize];
    ["Offset of field: amdgpu_gpu_info::max_memory_clk"]
        [::core::mem::offset_of!(amdgpu_gpu_info, max_memory_clk) - 32usize];
    ["Offset of field: amdgpu_gpu_info::num_shader_engines"]
        [::core::mem::offset_of!(amdgpu_gpu_info, num_shader_engines) - 40usize];
    ["Offset of field: amdgpu_gpu_info::num_shader_arrays_per_engine"]
        [::core::mem::offset_of!(amdgpu_gpu_info, num_shader_arrays_per_engine) - 44usize];
    ["Offset of field: amdgpu_gpu_info::avail_quad_shader_pipes"]
        [::core::mem::offset_of!(amdgpu_gpu_info, avail_quad_shader_pipes) - 48usize];
    ["Offset of field: amdgpu_gpu_info::max_quad_shader_pipes"]
        [::core::mem::offset_of!(amdgpu_gpu_info, max_quad_shader_pipes) - 52usize];
    ["Offset of field: amdgpu_gpu_info::cache_entries_per_quad_pipe"]
        [::core::mem::offset_of!(amdgpu_gpu_info, cache_entries_per_quad_pipe) - 56usize];
    ["Offset of field: amdgpu_gpu_info::num_hw_gfx_contexts"]
        [::core::mem::offset_of!(amdgpu_gpu_info, num_hw_gfx_contexts) - 60usize];
    ["Offset of field: amdgpu_gpu_info::rb_pipes"]
        [::core::mem::offset_of!(amdgpu_gpu_info, rb_pipes) - 64usize];
    ["Offset of field: amdgpu_gpu_info::enabled_rb_pipes_mask"]
        [::core::mem::offset_of!(amdgpu_gpu_info, enabled_rb_pipes_mask) - 68usize];
    ["Offset of field: amdgpu_gpu_info::gpu_counter_freq"]
        [::core::mem::offset_of!(amdgpu_gpu_info, gpu_counter_freq) - 72usize];
    ["Offset of field: amdgpu_gpu_info::backend_disable"]
        [::core::mem::offset_of!(amdgpu_gpu_info, backend_disable) - 76usize];
    ["Offset of field: amdgpu_gpu_info::mc_arb_ramcfg"]
        [::core::mem::offset_of!(amdgpu_gpu_info, mc_arb_ramcfg) - 92usize];
    ["Offset of field: amdgpu_gpu_info::gb_addr_cfg"]
        [::core::mem::offset_of!(amdgpu_gpu_info, gb_addr_cfg) - 96usize];
    ["Offset of field: amdgpu_gpu_info::gb_tile_mode"]
        [::core::mem::offset_of!(amdgpu_gpu_info, gb_tile_mode) - 100usize];
    ["Offset of field: amdgpu_gpu_info::gb_macro_tile_mode"]
        [::core::mem::offset_of!(amdgpu_gpu_info, gb_macro_tile_mode) - 228usize];
    ["Offset of field: amdgpu_gpu_info::pa_sc_raster_cfg"]
        [::core::mem::offset_of!(amdgpu_gpu_info, pa_sc_raster_cfg) - 292usize];
    ["Offset of field: amdgpu_gpu_info::pa_sc_raster_cfg1"]
        [::core::mem::offset_of!(amdgpu_gpu_info, pa_sc_raster_cfg1) - 308usize];
    ["Offset of field: amdgpu_gpu_info::cu_active_number"]
        [::core::mem::offset_of!(amdgpu_gpu_info, cu_active_number) - 324usize];
    ["Offset of field: amdgpu_gpu_info::cu_ao_mask"]
        [::core::mem::offset_of!(amdgpu_gpu_info, cu_ao_mask) - 328usize];
    ["Offset of field: amdgpu_gpu_info::cu_bitmap"]
        [::core::mem::offset_of!(amdgpu_gpu_info, cu_bitmap) - 332usize];
    ["Offset of field: amdgpu_gpu_info::vram_type"]
        [::core::mem::offset_of!(amdgpu_gpu_info, vram_type) - 396usize];
    ["Offset of field: amdgpu_gpu_info::vram_bit_width"]
        [::core::mem::offset_of!(amdgpu_gpu_info, vram_bit_width) - 400usize];
    ["Offset of field: amdgpu_gpu_info::ce_ram_size"]
        [::core::mem::offset_of!(amdgpu_gpu_info, ce_ram_size) - 404usize];
    ["Offset of field: amdgpu_gpu_info::vce_harvest_config"]
        [::core::mem::offset_of!(amdgpu_gpu_info, vce_harvest_config) - 408usize];
    ["Offset of field: amdgpu_gpu_info::pci_rev_id"]
        [::core::mem::offset_of!(amdgpu_gpu_info, pci_rev_id) - 412usize];
};
extern "C" {
    pub fn amdgpu_device_initialize(
        fd: ::core::ffi::c_int,
        major_version: *mut u32,
        minor_version: *mut u32,
        device_handle: *mut amdgpu_device_handle,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_device_deinitialize(device_handle: amdgpu_device_handle) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_alloc(
        dev: amdgpu_device_handle,
        alloc_buffer: *mut amdgpu_bo_alloc_request,
        buf_handle: *mut amdgpu_bo_handle,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_set_metadata(
        buf_handle: amdgpu_bo_handle,
        info: *mut amdgpu_bo_metadata,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_query_info(
        buf_handle: amdgpu_bo_handle,
        info: *mut amdgpu_bo_info,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_export(
        buf_handle: amdgpu_bo_handle,
        type_: amdgpu_bo_handle_type,
        shared_handle: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_import(
        dev: amdgpu_device_handle,
        type_: amdgpu_bo_handle_type,
        shared_handle: u32,
        output: *mut amdgpu_bo_import_result,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_create_bo_from_user_mem(
        dev: amdgpu_device_handle,
        cpu: *mut ::core::ffi::c_void,
        size: u64,
        buf_handle: *mut amdgpu_bo_handle,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_find_bo_by_cpu_mapping(
        dev: amdgpu_device_handle,
        cpu: *mut ::core::ffi::c_void,
        size: u64,
        buf_handle: *mut amdgpu_bo_handle,
        offset_in_bo: *mut u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_free(buf_handle: amdgpu_bo_handle) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_inc_ref(bo: amdgpu_bo_handle);
}
extern "C" {
    pub fn amdgpu_bo_cpu_map(
        buf_handle: amdgpu_bo_handle,
        cpu: *mut *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_cpu_unmap(buf_handle: amdgpu_bo_handle) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_wait_for_idle(
        buf_handle: amdgpu_bo_handle,
        timeout_ns: u64,
        buffer_busy: *mut bool,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_list_create_raw(
        dev: amdgpu_device_handle,
        number_of_buffers: u32,
        buffers: *mut drm_amdgpu_bo_list_entry,
        result: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_list_destroy_raw(
        dev: amdgpu_device_handle,
        bo_list: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_list_create(
        dev: amdgpu_device_handle,
        number_of_resources: u32,
        resources: *mut amdgpu_bo_handle,
        resource_prios: *mut u8,
        result: *mut amdgpu_bo_list_handle,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_list_destroy(handle: amdgpu_bo_list_handle) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_list_update(
        handle: amdgpu_bo_list_handle,
        number_of_resources: u32,
        resources: *mut amdgpu_bo_handle,
        resource_prios: *mut u8,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_ctx_create2(
        dev: amdgpu_device_handle,
        priority: u32,
        context: *mut amdgpu_context_handle,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_ctx_create(
        dev: amdgpu_device_handle,
        context: *mut amdgpu_context_handle,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_ctx_free(context: amdgpu_context_handle) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_ctx_override_priority(
        dev: amdgpu_device_handle,
        context: amdgpu_context_handle,
        master_fd: ::core::ffi::c_int,
        priority: ::core::ffi::c_uint,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_ctx_stable_pstate(
        context: amdgpu_context_handle,
        op: u32,
        flags: u32,
        out_flags: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_query_reset_state(
        context: amdgpu_context_handle,
        state: *mut u32,
        hangs: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_query_reset_state2(
        context: amdgpu_context_handle,
        flags: *mut u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_submit(
        context: amdgpu_context_handle,
        flags: u64,
        ibs_request: *mut amdgpu_cs_request,
        number_of_requests: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_query_fence_status(
        fence: *mut amdgpu_cs_fence,
        timeout_ns: u64,
        flags: u64,
        expired: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_wait_fences(
        fences: *mut amdgpu_cs_fence,
        fence_count: u32,
        wait_all: bool,
        timeout_ns: u64,
        status: *mut u32,
        first: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_buffer_size_alignment(
        dev: amdgpu_device_handle,
        info: *mut amdgpu_buffer_size_alignments,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_firmware_version(
        dev: amdgpu_device_handle,
        fw_type: ::core::ffi::c_uint,
        ip_instance: ::core::ffi::c_uint,
        index: ::core::ffi::c_uint,
        version: *mut u32,
        feature: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_hw_ip_count(
        dev: amdgpu_device_handle,
        type_: ::core::ffi::c_uint,
        count: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_hw_ip_info(
        dev: amdgpu_device_handle,
        type_: ::core::ffi::c_uint,
        ip_instance: ::core::ffi::c_uint,
        info: *mut drm_amdgpu_info_hw_ip,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_heap_info(
        dev: amdgpu_device_handle,
        heap: u32,
        flags: u32,
        info: *mut amdgpu_heap_info,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_crtc_from_id(
        dev: amdgpu_device_handle,
        id: ::core::ffi::c_uint,
        result: *mut i32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_gpu_info(
        dev: amdgpu_device_handle,
        info: *mut amdgpu_gpu_info,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_info(
        dev: amdgpu_device_handle,
        info_id: ::core::ffi::c_uint,
        size: ::core::ffi::c_uint,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_sw_info(
        dev: amdgpu_device_handle,
        info: amdgpu_sw_info,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_gds_info(
        dev: amdgpu_device_handle,
        gds_info: *mut amdgpu_gds_resource_info,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_sensor_info(
        dev: amdgpu_device_handle,
        sensor_type: ::core::ffi::c_uint,
        size: ::core::ffi::c_uint,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_video_caps_info(
        dev: amdgpu_device_handle,
        cap_type: ::core::ffi::c_uint,
        size: ::core::ffi::c_uint,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_query_gpuvm_fault_info(
        dev: amdgpu_device_handle,
        size: ::core::ffi::c_uint,
        value: *mut ::core::ffi::c_void,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_read_mm_registers(
        dev: amdgpu_device_handle,
        dword_offset: ::core::ffi::c_uint,
        count: ::core::ffi::c_uint,
        instance: u32,
        flags: u32,
        values: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_va_range_alloc(
        dev: amdgpu_device_handle,
        va_range_type: amdgpu_gpu_va_range,
        size: u64,
        va_base_alignment: u64,
        va_base_required: u64,
        va_base_allocated: *mut u64,
        va_range_handle: *mut amdgpu_va_handle,
        flags: u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_va_range_free(va_range_handle: amdgpu_va_handle) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_va_get_start_addr(va_handle: amdgpu_va_handle) -> u64;
}
extern "C" {
    pub fn amdgpu_va_range_query(
        dev: amdgpu_device_handle,
        type_: amdgpu_gpu_va_range,
        start: *mut u64,
        end: *mut u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_va_op(
        bo: amdgpu_bo_handle,
        offset: u64,
        size: u64,
        addr: u64,
        flags: u64,
        ops: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_bo_va_op_raw(
        dev: amdgpu_device_handle,
        bo: amdgpu_bo_handle,
        offset: u64,
        size: u64,
        addr: u64,
        flags: u64,
        ops: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_create_semaphore(sem: *mut amdgpu_semaphore_handle) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_signal_semaphore(
        ctx: amdgpu_context_handle,
        ip_type: u32,
        ip_instance: u32,
        ring: u32,
        sem: amdgpu_semaphore_handle,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_wait_semaphore(
        ctx: amdgpu_context_handle,
        ip_type: u32,
        ip_instance: u32,
        ring: u32,
        sem: amdgpu_semaphore_handle,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_destroy_semaphore(sem: amdgpu_semaphore_handle) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_get_marketing_name(dev: amdgpu_device_handle) -> *const ::core::ffi::c_char;
}
extern "C" {
    pub fn amdgpu_cs_create_syncobj2(
        dev: amdgpu_device_handle,
        flags: u32,
        syncobj: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_create_syncobj(
        dev: amdgpu_device_handle,
        syncobj: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_destroy_syncobj(dev: amdgpu_device_handle, syncobj: u32)
        -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_syncobj_reset(
        dev: amdgpu_device_handle,
        syncobjs: *const u32,
        syncobj_count: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_syncobj_signal(
        dev: amdgpu_device_handle,
        syncobjs: *const u32,
        syncobj_count: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_syncobj_timeline_signal(
        dev: amdgpu_device_handle,
        syncobjs: *const u32,
        points: *mut u64,
        syncobj_count: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_syncobj_wait(
        dev: amdgpu_device_handle,
        handles: *mut u32,
        num_handles: ::core::ffi::c_uint,
        timeout_nsec: i64,
        flags: ::core::ffi::c_uint,
        first_signaled: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_syncobj_timeline_wait(
        dev: amdgpu_device_handle,
        handles: *mut u32,
        points: *mut u64,
        num_handles: ::core::ffi::c_uint,
        timeout_nsec: i64,
        flags: ::core::ffi::c_uint,
        first_signaled: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_syncobj_query(
        dev: amdgpu_device_handle,
        handles: *mut u32,
        points: *mut u64,
        num_handles: ::core::ffi::c_uint,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_syncobj_query2(
        dev: amdgpu_device_handle,
        handles: *mut u32,
        points: *mut u64,
        num_handles: ::core::ffi::c_uint,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_export_syncobj(
        dev: amdgpu_device_handle,
        syncobj: u32,
        shared_fd: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_import_syncobj(
        dev: amdgpu_device_handle,
        shared_fd: ::core::ffi::c_int,
        syncobj: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_syncobj_export_sync_file(
        dev: amdgpu_device_handle,
        syncobj: u32,
        sync_file_fd: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_syncobj_import_sync_file(
        dev: amdgpu_device_handle,
        syncobj: u32,
        sync_file_fd: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_syncobj_export_sync_file2(
        dev: amdgpu_device_handle,
        syncobj: u32,
        point: u64,
        flags: u32,
        sync_file_fd: *mut ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_syncobj_import_sync_file2(
        dev: amdgpu_device_handle,
        syncobj: u32,
        point: u64,
        sync_file_fd: ::core::ffi::c_int,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_syncobj_transfer(
        dev: amdgpu_device_handle,
        dst_handle: u32,
        dst_point: u64,
        src_handle: u32,
        src_point: u64,
        flags: u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_fence_to_handle(
        dev: amdgpu_device_handle,
        fence: *mut amdgpu_cs_fence,
        what: u32,
        out_handle: *mut u32,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_submit_raw(
        dev: amdgpu_device_handle,
        context: amdgpu_context_handle,
        bo_list_handle: amdgpu_bo_list_handle,
        num_chunks: ::core::ffi::c_int,
        chunks: *mut drm_amdgpu_cs_chunk,
        seq_no: *mut u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_submit_raw2(
        dev: amdgpu_device_handle,
        context: amdgpu_context_handle,
        bo_list_handle: u32,
        num_chunks: ::core::ffi::c_int,
        chunks: *mut drm_amdgpu_cs_chunk,
        seq_no: *mut u64,
    ) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_cs_chunk_fence_to_dep(
        fence: *mut amdgpu_cs_fence,
        dep: *mut drm_amdgpu_cs_chunk_dep,
    );
}
extern "C" {
    pub fn amdgpu_cs_chunk_fence_info_to_data(
        fence_info: *mut amdgpu_cs_fence_info,
        data: *mut drm_amdgpu_cs_chunk_data,
    );
}
extern "C" {
    pub fn amdgpu_vm_reserve_vmid(dev: amdgpu_device_handle, flags: u32) -> ::core::ffi::c_int;
}
extern "C" {
    pub fn amdgpu_vm_unreserve_vmid(dev: amdgpu_device_handle, flags: u32) -> ::core::ffi::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_create_in {
    #[doc = " the requested memory size"]
    pub bo_size: __u64,
    #[doc = " physical start_addr alignment in bytes for some HW requirements"]
    pub alignment: __u64,
    #[doc = " the requested memory domains"]
    pub domains: __u64,
    #[doc = " allocation flags"]
    pub domain_flags: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_create_in"]
        [::core::mem::size_of::<drm_amdgpu_gem_create_in>() - 32usize];
    ["Alignment of drm_amdgpu_gem_create_in"]
        [::core::mem::align_of::<drm_amdgpu_gem_create_in>() - 8usize];
    ["Offset of field: drm_amdgpu_gem_create_in::bo_size"]
        [::core::mem::offset_of!(drm_amdgpu_gem_create_in, bo_size) - 0usize];
    ["Offset of field: drm_amdgpu_gem_create_in::alignment"]
        [::core::mem::offset_of!(drm_amdgpu_gem_create_in, alignment) - 8usize];
    ["Offset of field: drm_amdgpu_gem_create_in::domains"]
        [::core::mem::offset_of!(drm_amdgpu_gem_create_in, domains) - 16usize];
    ["Offset of field: drm_amdgpu_gem_create_in::domain_flags"]
        [::core::mem::offset_of!(drm_amdgpu_gem_create_in, domain_flags) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_create_out {
    #[doc = " returned GEM object handle"]
    pub handle: __u32,
    pub _pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_create_out"]
        [::core::mem::size_of::<drm_amdgpu_gem_create_out>() - 8usize];
    ["Alignment of drm_amdgpu_gem_create_out"]
        [::core::mem::align_of::<drm_amdgpu_gem_create_out>() - 4usize];
    ["Offset of field: drm_amdgpu_gem_create_out::handle"]
        [::core::mem::offset_of!(drm_amdgpu_gem_create_out, handle) - 0usize];
    ["Offset of field: drm_amdgpu_gem_create_out::_pad"]
        [::core::mem::offset_of!(drm_amdgpu_gem_create_out, _pad) - 4usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_gem_create {
    pub in_: drm_amdgpu_gem_create_in,
    pub out: drm_amdgpu_gem_create_out,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_create"][::core::mem::size_of::<drm_amdgpu_gem_create>() - 32usize];
    ["Alignment of drm_amdgpu_gem_create"]
        [::core::mem::align_of::<drm_amdgpu_gem_create>() - 8usize];
    ["Offset of field: drm_amdgpu_gem_create::in_"]
        [::core::mem::offset_of!(drm_amdgpu_gem_create, in_) - 0usize];
    ["Offset of field: drm_amdgpu_gem_create::out"]
        [::core::mem::offset_of!(drm_amdgpu_gem_create, out) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_bo_list_in {
    #[doc = " Type of operation"]
    pub operation: __u32,
    #[doc = " Handle of list or 0 if we want to create one"]
    pub list_handle: __u32,
    #[doc = " Number of BOs in list"]
    pub bo_number: __u32,
    #[doc = " Size of each element describing BO"]
    pub bo_info_size: __u32,
    #[doc = " Pointer to array describing BOs"]
    pub bo_info_ptr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_bo_list_in"][::core::mem::size_of::<drm_amdgpu_bo_list_in>() - 24usize];
    ["Alignment of drm_amdgpu_bo_list_in"]
        [::core::mem::align_of::<drm_amdgpu_bo_list_in>() - 8usize];
    ["Offset of field: drm_amdgpu_bo_list_in::operation"]
        [::core::mem::offset_of!(drm_amdgpu_bo_list_in, operation) - 0usize];
    ["Offset of field: drm_amdgpu_bo_list_in::list_handle"]
        [::core::mem::offset_of!(drm_amdgpu_bo_list_in, list_handle) - 4usize];
    ["Offset of field: drm_amdgpu_bo_list_in::bo_number"]
        [::core::mem::offset_of!(drm_amdgpu_bo_list_in, bo_number) - 8usize];
    ["Offset of field: drm_amdgpu_bo_list_in::bo_info_size"]
        [::core::mem::offset_of!(drm_amdgpu_bo_list_in, bo_info_size) - 12usize];
    ["Offset of field: drm_amdgpu_bo_list_in::bo_info_ptr"]
        [::core::mem::offset_of!(drm_amdgpu_bo_list_in, bo_info_ptr) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_bo_list_entry {
    #[doc = " Handle of BO"]
    pub bo_handle: __u32,
    #[doc = " New (if specified) BO priority to be used during migration"]
    pub bo_priority: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_bo_list_entry"]
        [::core::mem::size_of::<drm_amdgpu_bo_list_entry>() - 8usize];
    ["Alignment of drm_amdgpu_bo_list_entry"]
        [::core::mem::align_of::<drm_amdgpu_bo_list_entry>() - 4usize];
    ["Offset of field: drm_amdgpu_bo_list_entry::bo_handle"]
        [::core::mem::offset_of!(drm_amdgpu_bo_list_entry, bo_handle) - 0usize];
    ["Offset of field: drm_amdgpu_bo_list_entry::bo_priority"]
        [::core::mem::offset_of!(drm_amdgpu_bo_list_entry, bo_priority) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_bo_list_out {
    #[doc = " Handle of resource list"]
    pub list_handle: __u32,
    pub _pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_bo_list_out"][::core::mem::size_of::<drm_amdgpu_bo_list_out>() - 8usize];
    ["Alignment of drm_amdgpu_bo_list_out"]
        [::core::mem::align_of::<drm_amdgpu_bo_list_out>() - 4usize];
    ["Offset of field: drm_amdgpu_bo_list_out::list_handle"]
        [::core::mem::offset_of!(drm_amdgpu_bo_list_out, list_handle) - 0usize];
    ["Offset of field: drm_amdgpu_bo_list_out::_pad"]
        [::core::mem::offset_of!(drm_amdgpu_bo_list_out, _pad) - 4usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_bo_list {
    pub in_: drm_amdgpu_bo_list_in,
    pub out: drm_amdgpu_bo_list_out,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_bo_list"][::core::mem::size_of::<drm_amdgpu_bo_list>() - 24usize];
    ["Alignment of drm_amdgpu_bo_list"][::core::mem::align_of::<drm_amdgpu_bo_list>() - 8usize];
    ["Offset of field: drm_amdgpu_bo_list::in_"]
        [::core::mem::offset_of!(drm_amdgpu_bo_list, in_) - 0usize];
    ["Offset of field: drm_amdgpu_bo_list::out"]
        [::core::mem::offset_of!(drm_amdgpu_bo_list, out) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_ctx_in {
    #[doc = " AMDGPU_CTX_OP_*"]
    pub op: __u32,
    #[doc = " Flags"]
    pub flags: __u32,
    pub ctx_id: __u32,
    #[doc = " AMDGPU_CTX_PRIORITY_*"]
    pub priority: __s32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_ctx_in"][::core::mem::size_of::<drm_amdgpu_ctx_in>() - 16usize];
    ["Alignment of drm_amdgpu_ctx_in"][::core::mem::align_of::<drm_amdgpu_ctx_in>() - 4usize];
    ["Offset of field: drm_amdgpu_ctx_in::op"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_in, op) - 0usize];
    ["Offset of field: drm_amdgpu_ctx_in::flags"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_in, flags) - 4usize];
    ["Offset of field: drm_amdgpu_ctx_in::ctx_id"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_in, ctx_id) - 8usize];
    ["Offset of field: drm_amdgpu_ctx_in::priority"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_in, priority) - 12usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_ctx_out {
    pub alloc: drm_amdgpu_ctx_out__bindgen_ty_1,
    pub state: drm_amdgpu_ctx_out__bindgen_ty_2,
    pub pstate: drm_amdgpu_ctx_out__bindgen_ty_3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_ctx_out__bindgen_ty_1 {
    pub ctx_id: __u32,
    pub _pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_ctx_out__bindgen_ty_1"]
        [::core::mem::size_of::<drm_amdgpu_ctx_out__bindgen_ty_1>() - 8usize];
    ["Alignment of drm_amdgpu_ctx_out__bindgen_ty_1"]
        [::core::mem::align_of::<drm_amdgpu_ctx_out__bindgen_ty_1>() - 4usize];
    ["Offset of field: drm_amdgpu_ctx_out__bindgen_ty_1::ctx_id"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_out__bindgen_ty_1, ctx_id) - 0usize];
    ["Offset of field: drm_amdgpu_ctx_out__bindgen_ty_1::_pad"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_out__bindgen_ty_1, _pad) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_ctx_out__bindgen_ty_2 {
    #[doc = " For future use, no flags defined so far"]
    pub flags: __u64,
    #[doc = " Number of resets caused by this context so far."]
    pub hangs: __u32,
    #[doc = " Reset status since the last call of the ioctl."]
    pub reset_status: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_ctx_out__bindgen_ty_2"]
        [::core::mem::size_of::<drm_amdgpu_ctx_out__bindgen_ty_2>() - 16usize];
    ["Alignment of drm_amdgpu_ctx_out__bindgen_ty_2"]
        [::core::mem::align_of::<drm_amdgpu_ctx_out__bindgen_ty_2>() - 8usize];
    ["Offset of field: drm_amdgpu_ctx_out__bindgen_ty_2::flags"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_out__bindgen_ty_2, flags) - 0usize];
    ["Offset of field: drm_amdgpu_ctx_out__bindgen_ty_2::hangs"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_out__bindgen_ty_2, hangs) - 8usize];
    ["Offset of field: drm_amdgpu_ctx_out__bindgen_ty_2::reset_status"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_out__bindgen_ty_2, reset_status) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_ctx_out__bindgen_ty_3 {
    pub flags: __u32,
    pub _pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_ctx_out__bindgen_ty_3"]
        [::core::mem::size_of::<drm_amdgpu_ctx_out__bindgen_ty_3>() - 8usize];
    ["Alignment of drm_amdgpu_ctx_out__bindgen_ty_3"]
        [::core::mem::align_of::<drm_amdgpu_ctx_out__bindgen_ty_3>() - 4usize];
    ["Offset of field: drm_amdgpu_ctx_out__bindgen_ty_3::flags"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_out__bindgen_ty_3, flags) - 0usize];
    ["Offset of field: drm_amdgpu_ctx_out__bindgen_ty_3::_pad"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_out__bindgen_ty_3, _pad) - 4usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_ctx_out"][::core::mem::size_of::<drm_amdgpu_ctx_out>() - 16usize];
    ["Alignment of drm_amdgpu_ctx_out"][::core::mem::align_of::<drm_amdgpu_ctx_out>() - 8usize];
    ["Offset of field: drm_amdgpu_ctx_out::alloc"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_out, alloc) - 0usize];
    ["Offset of field: drm_amdgpu_ctx_out::state"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_out, state) - 0usize];
    ["Offset of field: drm_amdgpu_ctx_out::pstate"]
        [::core::mem::offset_of!(drm_amdgpu_ctx_out, pstate) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_ctx {
    pub in_: drm_amdgpu_ctx_in,
    pub out: drm_amdgpu_ctx_out,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_ctx"][::core::mem::size_of::<drm_amdgpu_ctx>() - 16usize];
    ["Alignment of drm_amdgpu_ctx"][::core::mem::align_of::<drm_amdgpu_ctx>() - 8usize];
    ["Offset of field: drm_amdgpu_ctx::in_"][::core::mem::offset_of!(drm_amdgpu_ctx, in_) - 0usize];
    ["Offset of field: drm_amdgpu_ctx::out"][::core::mem::offset_of!(drm_amdgpu_ctx, out) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_vm_in {
    #[doc = " AMDGPU_VM_OP_*"]
    pub op: __u32,
    pub flags: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_vm_in"][::core::mem::size_of::<drm_amdgpu_vm_in>() - 8usize];
    ["Alignment of drm_amdgpu_vm_in"][::core::mem::align_of::<drm_amdgpu_vm_in>() - 4usize];
    ["Offset of field: drm_amdgpu_vm_in::op"]
        [::core::mem::offset_of!(drm_amdgpu_vm_in, op) - 0usize];
    ["Offset of field: drm_amdgpu_vm_in::flags"]
        [::core::mem::offset_of!(drm_amdgpu_vm_in, flags) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_vm_out {
    #[doc = " For future use, no flags defined so far"]
    pub flags: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_vm_out"][::core::mem::size_of::<drm_amdgpu_vm_out>() - 8usize];
    ["Alignment of drm_amdgpu_vm_out"][::core::mem::align_of::<drm_amdgpu_vm_out>() - 8usize];
    ["Offset of field: drm_amdgpu_vm_out::flags"]
        [::core::mem::offset_of!(drm_amdgpu_vm_out, flags) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_vm {
    pub in_: drm_amdgpu_vm_in,
    pub out: drm_amdgpu_vm_out,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_vm"][::core::mem::size_of::<drm_amdgpu_vm>() - 8usize];
    ["Alignment of drm_amdgpu_vm"][::core::mem::align_of::<drm_amdgpu_vm>() - 8usize];
    ["Offset of field: drm_amdgpu_vm::in_"][::core::mem::offset_of!(drm_amdgpu_vm, in_) - 0usize];
    ["Offset of field: drm_amdgpu_vm::out"][::core::mem::offset_of!(drm_amdgpu_vm, out) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_sched_in {
    pub op: __u32,
    pub fd: __u32,
    #[doc = " AMDGPU_CTX_PRIORITY_*"]
    pub priority: __s32,
    pub ctx_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_sched_in"][::core::mem::size_of::<drm_amdgpu_sched_in>() - 16usize];
    ["Alignment of drm_amdgpu_sched_in"][::core::mem::align_of::<drm_amdgpu_sched_in>() - 4usize];
    ["Offset of field: drm_amdgpu_sched_in::op"]
        [::core::mem::offset_of!(drm_amdgpu_sched_in, op) - 0usize];
    ["Offset of field: drm_amdgpu_sched_in::fd"]
        [::core::mem::offset_of!(drm_amdgpu_sched_in, fd) - 4usize];
    ["Offset of field: drm_amdgpu_sched_in::priority"]
        [::core::mem::offset_of!(drm_amdgpu_sched_in, priority) - 8usize];
    ["Offset of field: drm_amdgpu_sched_in::ctx_id"]
        [::core::mem::offset_of!(drm_amdgpu_sched_in, ctx_id) - 12usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_sched {
    pub in_: drm_amdgpu_sched_in,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_sched"][::core::mem::size_of::<drm_amdgpu_sched>() - 16usize];
    ["Alignment of drm_amdgpu_sched"][::core::mem::align_of::<drm_amdgpu_sched>() - 4usize];
    ["Offset of field: drm_amdgpu_sched::in_"]
        [::core::mem::offset_of!(drm_amdgpu_sched, in_) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_userptr {
    pub addr: __u64,
    pub size: __u64,
    pub flags: __u32,
    pub handle: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_userptr"][::core::mem::size_of::<drm_amdgpu_gem_userptr>() - 24usize];
    ["Alignment of drm_amdgpu_gem_userptr"]
        [::core::mem::align_of::<drm_amdgpu_gem_userptr>() - 8usize];
    ["Offset of field: drm_amdgpu_gem_userptr::addr"]
        [::core::mem::offset_of!(drm_amdgpu_gem_userptr, addr) - 0usize];
    ["Offset of field: drm_amdgpu_gem_userptr::size"]
        [::core::mem::offset_of!(drm_amdgpu_gem_userptr, size) - 8usize];
    ["Offset of field: drm_amdgpu_gem_userptr::flags"]
        [::core::mem::offset_of!(drm_amdgpu_gem_userptr, flags) - 16usize];
    ["Offset of field: drm_amdgpu_gem_userptr::handle"]
        [::core::mem::offset_of!(drm_amdgpu_gem_userptr, handle) - 20usize];
};
#[doc = " The same structure is shared for input/output"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_metadata {
    #[doc = " GEM Object handle"]
    pub handle: __u32,
    #[doc = " Do we want get or set metadata"]
    pub op: __u32,
    pub data: drm_amdgpu_gem_metadata__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_metadata__bindgen_ty_1 {
    #[doc = " For future use, no flags defined so far"]
    pub flags: __u64,
    #[doc = " family specific tiling info"]
    pub tiling_info: __u64,
    pub data_size_bytes: __u32,
    pub data: [__u32; 64usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_metadata__bindgen_ty_1"]
        [::core::mem::size_of::<drm_amdgpu_gem_metadata__bindgen_ty_1>() - 280usize];
    ["Alignment of drm_amdgpu_gem_metadata__bindgen_ty_1"]
        [::core::mem::align_of::<drm_amdgpu_gem_metadata__bindgen_ty_1>() - 8usize];
    ["Offset of field: drm_amdgpu_gem_metadata__bindgen_ty_1::flags"]
        [::core::mem::offset_of!(drm_amdgpu_gem_metadata__bindgen_ty_1, flags) - 0usize];
    ["Offset of field: drm_amdgpu_gem_metadata__bindgen_ty_1::tiling_info"]
        [::core::mem::offset_of!(drm_amdgpu_gem_metadata__bindgen_ty_1, tiling_info) - 8usize];
    ["Offset of field: drm_amdgpu_gem_metadata__bindgen_ty_1::data_size_bytes"]
        [::core::mem::offset_of!(drm_amdgpu_gem_metadata__bindgen_ty_1, data_size_bytes) - 16usize];
    ["Offset of field: drm_amdgpu_gem_metadata__bindgen_ty_1::data"]
        [::core::mem::offset_of!(drm_amdgpu_gem_metadata__bindgen_ty_1, data) - 20usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_metadata"]
        [::core::mem::size_of::<drm_amdgpu_gem_metadata>() - 288usize];
    ["Alignment of drm_amdgpu_gem_metadata"]
        [::core::mem::align_of::<drm_amdgpu_gem_metadata>() - 8usize];
    ["Offset of field: drm_amdgpu_gem_metadata::handle"]
        [::core::mem::offset_of!(drm_amdgpu_gem_metadata, handle) - 0usize];
    ["Offset of field: drm_amdgpu_gem_metadata::op"]
        [::core::mem::offset_of!(drm_amdgpu_gem_metadata, op) - 4usize];
    ["Offset of field: drm_amdgpu_gem_metadata::data"]
        [::core::mem::offset_of!(drm_amdgpu_gem_metadata, data) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_mmap_in {
    #[doc = " the GEM object handle"]
    pub handle: __u32,
    pub _pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_mmap_in"][::core::mem::size_of::<drm_amdgpu_gem_mmap_in>() - 8usize];
    ["Alignment of drm_amdgpu_gem_mmap_in"]
        [::core::mem::align_of::<drm_amdgpu_gem_mmap_in>() - 4usize];
    ["Offset of field: drm_amdgpu_gem_mmap_in::handle"]
        [::core::mem::offset_of!(drm_amdgpu_gem_mmap_in, handle) - 0usize];
    ["Offset of field: drm_amdgpu_gem_mmap_in::_pad"]
        [::core::mem::offset_of!(drm_amdgpu_gem_mmap_in, _pad) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_mmap_out {
    #[doc = " mmap offset from the vma offset manager"]
    pub addr_ptr: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_mmap_out"][::core::mem::size_of::<drm_amdgpu_gem_mmap_out>() - 8usize];
    ["Alignment of drm_amdgpu_gem_mmap_out"]
        [::core::mem::align_of::<drm_amdgpu_gem_mmap_out>() - 8usize];
    ["Offset of field: drm_amdgpu_gem_mmap_out::addr_ptr"]
        [::core::mem::offset_of!(drm_amdgpu_gem_mmap_out, addr_ptr) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_gem_mmap {
    pub in_: drm_amdgpu_gem_mmap_in,
    pub out: drm_amdgpu_gem_mmap_out,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_mmap"][::core::mem::size_of::<drm_amdgpu_gem_mmap>() - 8usize];
    ["Alignment of drm_amdgpu_gem_mmap"][::core::mem::align_of::<drm_amdgpu_gem_mmap>() - 8usize];
    ["Offset of field: drm_amdgpu_gem_mmap::in_"]
        [::core::mem::offset_of!(drm_amdgpu_gem_mmap, in_) - 0usize];
    ["Offset of field: drm_amdgpu_gem_mmap::out"]
        [::core::mem::offset_of!(drm_amdgpu_gem_mmap, out) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_wait_idle_in {
    #[doc = " GEM object handle"]
    pub handle: __u32,
    #[doc = " For future use, no flags defined so far"]
    pub flags: __u32,
    #[doc = " Absolute timeout to wait"]
    pub timeout: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_wait_idle_in"]
        [::core::mem::size_of::<drm_amdgpu_gem_wait_idle_in>() - 16usize];
    ["Alignment of drm_amdgpu_gem_wait_idle_in"]
        [::core::mem::align_of::<drm_amdgpu_gem_wait_idle_in>() - 8usize];
    ["Offset of field: drm_amdgpu_gem_wait_idle_in::handle"]
        [::core::mem::offset_of!(drm_amdgpu_gem_wait_idle_in, handle) - 0usize];
    ["Offset of field: drm_amdgpu_gem_wait_idle_in::flags"]
        [::core::mem::offset_of!(drm_amdgpu_gem_wait_idle_in, flags) - 4usize];
    ["Offset of field: drm_amdgpu_gem_wait_idle_in::timeout"]
        [::core::mem::offset_of!(drm_amdgpu_gem_wait_idle_in, timeout) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_wait_idle_out {
    #[doc = " BO status:  0 - BO is idle, 1 - BO is busy"]
    pub status: __u32,
    #[doc = " Returned current memory domain"]
    pub domain: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_wait_idle_out"]
        [::core::mem::size_of::<drm_amdgpu_gem_wait_idle_out>() - 8usize];
    ["Alignment of drm_amdgpu_gem_wait_idle_out"]
        [::core::mem::align_of::<drm_amdgpu_gem_wait_idle_out>() - 4usize];
    ["Offset of field: drm_amdgpu_gem_wait_idle_out::status"]
        [::core::mem::offset_of!(drm_amdgpu_gem_wait_idle_out, status) - 0usize];
    ["Offset of field: drm_amdgpu_gem_wait_idle_out::domain"]
        [::core::mem::offset_of!(drm_amdgpu_gem_wait_idle_out, domain) - 4usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_gem_wait_idle {
    pub in_: drm_amdgpu_gem_wait_idle_in,
    pub out: drm_amdgpu_gem_wait_idle_out,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_wait_idle"]
        [::core::mem::size_of::<drm_amdgpu_gem_wait_idle>() - 16usize];
    ["Alignment of drm_amdgpu_gem_wait_idle"]
        [::core::mem::align_of::<drm_amdgpu_gem_wait_idle>() - 8usize];
    ["Offset of field: drm_amdgpu_gem_wait_idle::in_"]
        [::core::mem::offset_of!(drm_amdgpu_gem_wait_idle, in_) - 0usize];
    ["Offset of field: drm_amdgpu_gem_wait_idle::out"]
        [::core::mem::offset_of!(drm_amdgpu_gem_wait_idle, out) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_wait_cs_in {
    pub handle: __u64,
    #[doc = " Absolute timeout to wait"]
    pub timeout: __u64,
    pub ip_type: __u32,
    pub ip_instance: __u32,
    pub ring: __u32,
    pub ctx_id: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_wait_cs_in"][::core::mem::size_of::<drm_amdgpu_wait_cs_in>() - 32usize];
    ["Alignment of drm_amdgpu_wait_cs_in"]
        [::core::mem::align_of::<drm_amdgpu_wait_cs_in>() - 8usize];
    ["Offset of field: drm_amdgpu_wait_cs_in::handle"]
        [::core::mem::offset_of!(drm_amdgpu_wait_cs_in, handle) - 0usize];
    ["Offset of field: drm_amdgpu_wait_cs_in::timeout"]
        [::core::mem::offset_of!(drm_amdgpu_wait_cs_in, timeout) - 8usize];
    ["Offset of field: drm_amdgpu_wait_cs_in::ip_type"]
        [::core::mem::offset_of!(drm_amdgpu_wait_cs_in, ip_type) - 16usize];
    ["Offset of field: drm_amdgpu_wait_cs_in::ip_instance"]
        [::core::mem::offset_of!(drm_amdgpu_wait_cs_in, ip_instance) - 20usize];
    ["Offset of field: drm_amdgpu_wait_cs_in::ring"]
        [::core::mem::offset_of!(drm_amdgpu_wait_cs_in, ring) - 24usize];
    ["Offset of field: drm_amdgpu_wait_cs_in::ctx_id"]
        [::core::mem::offset_of!(drm_amdgpu_wait_cs_in, ctx_id) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_wait_cs_out {
    #[doc = " CS status:  0 - CS completed, 1 - CS still busy"]
    pub status: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_wait_cs_out"][::core::mem::size_of::<drm_amdgpu_wait_cs_out>() - 8usize];
    ["Alignment of drm_amdgpu_wait_cs_out"]
        [::core::mem::align_of::<drm_amdgpu_wait_cs_out>() - 8usize];
    ["Offset of field: drm_amdgpu_wait_cs_out::status"]
        [::core::mem::offset_of!(drm_amdgpu_wait_cs_out, status) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_wait_cs {
    pub in_: drm_amdgpu_wait_cs_in,
    pub out: drm_amdgpu_wait_cs_out,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_wait_cs"][::core::mem::size_of::<drm_amdgpu_wait_cs>() - 32usize];
    ["Alignment of drm_amdgpu_wait_cs"][::core::mem::align_of::<drm_amdgpu_wait_cs>() - 8usize];
    ["Offset of field: drm_amdgpu_wait_cs::in_"]
        [::core::mem::offset_of!(drm_amdgpu_wait_cs, in_) - 0usize];
    ["Offset of field: drm_amdgpu_wait_cs::out"]
        [::core::mem::offset_of!(drm_amdgpu_wait_cs, out) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_fence {
    pub ctx_id: __u32,
    pub ip_type: __u32,
    pub ip_instance: __u32,
    pub ring: __u32,
    pub seq_no: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_fence"][::core::mem::size_of::<drm_amdgpu_fence>() - 24usize];
    ["Alignment of drm_amdgpu_fence"][::core::mem::align_of::<drm_amdgpu_fence>() - 8usize];
    ["Offset of field: drm_amdgpu_fence::ctx_id"]
        [::core::mem::offset_of!(drm_amdgpu_fence, ctx_id) - 0usize];
    ["Offset of field: drm_amdgpu_fence::ip_type"]
        [::core::mem::offset_of!(drm_amdgpu_fence, ip_type) - 4usize];
    ["Offset of field: drm_amdgpu_fence::ip_instance"]
        [::core::mem::offset_of!(drm_amdgpu_fence, ip_instance) - 8usize];
    ["Offset of field: drm_amdgpu_fence::ring"]
        [::core::mem::offset_of!(drm_amdgpu_fence, ring) - 12usize];
    ["Offset of field: drm_amdgpu_fence::seq_no"]
        [::core::mem::offset_of!(drm_amdgpu_fence, seq_no) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_wait_fences_in {
    #[doc = " This points to uint64_t * which points to fences"]
    pub fences: __u64,
    pub fence_count: __u32,
    pub wait_all: __u32,
    pub timeout_ns: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_wait_fences_in"]
        [::core::mem::size_of::<drm_amdgpu_wait_fences_in>() - 24usize];
    ["Alignment of drm_amdgpu_wait_fences_in"]
        [::core::mem::align_of::<drm_amdgpu_wait_fences_in>() - 8usize];
    ["Offset of field: drm_amdgpu_wait_fences_in::fences"]
        [::core::mem::offset_of!(drm_amdgpu_wait_fences_in, fences) - 0usize];
    ["Offset of field: drm_amdgpu_wait_fences_in::fence_count"]
        [::core::mem::offset_of!(drm_amdgpu_wait_fences_in, fence_count) - 8usize];
    ["Offset of field: drm_amdgpu_wait_fences_in::wait_all"]
        [::core::mem::offset_of!(drm_amdgpu_wait_fences_in, wait_all) - 12usize];
    ["Offset of field: drm_amdgpu_wait_fences_in::timeout_ns"]
        [::core::mem::offset_of!(drm_amdgpu_wait_fences_in, timeout_ns) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_wait_fences_out {
    pub status: __u32,
    pub first_signaled: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_wait_fences_out"]
        [::core::mem::size_of::<drm_amdgpu_wait_fences_out>() - 8usize];
    ["Alignment of drm_amdgpu_wait_fences_out"]
        [::core::mem::align_of::<drm_amdgpu_wait_fences_out>() - 4usize];
    ["Offset of field: drm_amdgpu_wait_fences_out::status"]
        [::core::mem::offset_of!(drm_amdgpu_wait_fences_out, status) - 0usize];
    ["Offset of field: drm_amdgpu_wait_fences_out::first_signaled"]
        [::core::mem::offset_of!(drm_amdgpu_wait_fences_out, first_signaled) - 4usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_wait_fences {
    pub in_: drm_amdgpu_wait_fences_in,
    pub out: drm_amdgpu_wait_fences_out,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_wait_fences"][::core::mem::size_of::<drm_amdgpu_wait_fences>() - 24usize];
    ["Alignment of drm_amdgpu_wait_fences"]
        [::core::mem::align_of::<drm_amdgpu_wait_fences>() - 8usize];
    ["Offset of field: drm_amdgpu_wait_fences::in_"]
        [::core::mem::offset_of!(drm_amdgpu_wait_fences, in_) - 0usize];
    ["Offset of field: drm_amdgpu_wait_fences::out"]
        [::core::mem::offset_of!(drm_amdgpu_wait_fences, out) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_op {
    #[doc = " GEM object handle"]
    pub handle: __u32,
    #[doc = " AMDGPU_GEM_OP_*"]
    pub op: __u32,
    #[doc = " Input or return value"]
    pub value: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_op"][::core::mem::size_of::<drm_amdgpu_gem_op>() - 16usize];
    ["Alignment of drm_amdgpu_gem_op"][::core::mem::align_of::<drm_amdgpu_gem_op>() - 8usize];
    ["Offset of field: drm_amdgpu_gem_op::handle"]
        [::core::mem::offset_of!(drm_amdgpu_gem_op, handle) - 0usize];
    ["Offset of field: drm_amdgpu_gem_op::op"]
        [::core::mem::offset_of!(drm_amdgpu_gem_op, op) - 4usize];
    ["Offset of field: drm_amdgpu_gem_op::value"]
        [::core::mem::offset_of!(drm_amdgpu_gem_op, value) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_gem_va {
    #[doc = " GEM object handle"]
    pub handle: __u32,
    pub _pad: __u32,
    #[doc = " AMDGPU_VA_OP_*"]
    pub operation: __u32,
    #[doc = " AMDGPU_VM_PAGE_*"]
    pub flags: __u32,
    #[doc = " va address to assign . Must be correctly aligned."]
    pub va_address: __u64,
    #[doc = " Specify offset inside of BO to assign. Must be correctly aligned."]
    pub offset_in_bo: __u64,
    #[doc = " Specify mapping size. Must be correctly aligned."]
    pub map_size: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_gem_va"][::core::mem::size_of::<drm_amdgpu_gem_va>() - 40usize];
    ["Alignment of drm_amdgpu_gem_va"][::core::mem::align_of::<drm_amdgpu_gem_va>() - 8usize];
    ["Offset of field: drm_amdgpu_gem_va::handle"]
        [::core::mem::offset_of!(drm_amdgpu_gem_va, handle) - 0usize];
    ["Offset of field: drm_amdgpu_gem_va::_pad"]
        [::core::mem::offset_of!(drm_amdgpu_gem_va, _pad) - 4usize];
    ["Offset of field: drm_amdgpu_gem_va::operation"]
        [::core::mem::offset_of!(drm_amdgpu_gem_va, operation) - 8usize];
    ["Offset of field: drm_amdgpu_gem_va::flags"]
        [::core::mem::offset_of!(drm_amdgpu_gem_va, flags) - 12usize];
    ["Offset of field: drm_amdgpu_gem_va::va_address"]
        [::core::mem::offset_of!(drm_amdgpu_gem_va, va_address) - 16usize];
    ["Offset of field: drm_amdgpu_gem_va::offset_in_bo"]
        [::core::mem::offset_of!(drm_amdgpu_gem_va, offset_in_bo) - 24usize];
    ["Offset of field: drm_amdgpu_gem_va::map_size"]
        [::core::mem::offset_of!(drm_amdgpu_gem_va, map_size) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk {
    pub chunk_id: __u32,
    pub length_dw: __u32,
    pub chunk_data: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_cs_chunk"][::core::mem::size_of::<drm_amdgpu_cs_chunk>() - 16usize];
    ["Alignment of drm_amdgpu_cs_chunk"][::core::mem::align_of::<drm_amdgpu_cs_chunk>() - 8usize];
    ["Offset of field: drm_amdgpu_cs_chunk::chunk_id"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk, chunk_id) - 0usize];
    ["Offset of field: drm_amdgpu_cs_chunk::length_dw"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk, length_dw) - 4usize];
    ["Offset of field: drm_amdgpu_cs_chunk::chunk_data"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk, chunk_data) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_in {
    #[doc = " Rendering context id"]
    pub ctx_id: __u32,
    #[doc = "  Handle of resource list associated with CS"]
    pub bo_list_handle: __u32,
    pub num_chunks: __u32,
    pub flags: __u32,
    #[doc = " this points to __u64 * which point to cs chunks"]
    pub chunks: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_cs_in"][::core::mem::size_of::<drm_amdgpu_cs_in>() - 24usize];
    ["Alignment of drm_amdgpu_cs_in"][::core::mem::align_of::<drm_amdgpu_cs_in>() - 8usize];
    ["Offset of field: drm_amdgpu_cs_in::ctx_id"]
        [::core::mem::offset_of!(drm_amdgpu_cs_in, ctx_id) - 0usize];
    ["Offset of field: drm_amdgpu_cs_in::bo_list_handle"]
        [::core::mem::offset_of!(drm_amdgpu_cs_in, bo_list_handle) - 4usize];
    ["Offset of field: drm_amdgpu_cs_in::num_chunks"]
        [::core::mem::offset_of!(drm_amdgpu_cs_in, num_chunks) - 8usize];
    ["Offset of field: drm_amdgpu_cs_in::flags"]
        [::core::mem::offset_of!(drm_amdgpu_cs_in, flags) - 12usize];
    ["Offset of field: drm_amdgpu_cs_in::chunks"]
        [::core::mem::offset_of!(drm_amdgpu_cs_in, chunks) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_out {
    pub handle: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_cs_out"][::core::mem::size_of::<drm_amdgpu_cs_out>() - 8usize];
    ["Alignment of drm_amdgpu_cs_out"][::core::mem::align_of::<drm_amdgpu_cs_out>() - 8usize];
    ["Offset of field: drm_amdgpu_cs_out::handle"]
        [::core::mem::offset_of!(drm_amdgpu_cs_out, handle) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_cs {
    pub in_: drm_amdgpu_cs_in,
    pub out: drm_amdgpu_cs_out,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_cs"][::core::mem::size_of::<drm_amdgpu_cs>() - 24usize];
    ["Alignment of drm_amdgpu_cs"][::core::mem::align_of::<drm_amdgpu_cs>() - 8usize];
    ["Offset of field: drm_amdgpu_cs::in_"][::core::mem::offset_of!(drm_amdgpu_cs, in_) - 0usize];
    ["Offset of field: drm_amdgpu_cs::out"][::core::mem::offset_of!(drm_amdgpu_cs, out) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_ib {
    pub _pad: __u32,
    #[doc = " AMDGPU_IB_FLAG_*"]
    pub flags: __u32,
    #[doc = " Virtual address to begin IB execution"]
    pub va_start: __u64,
    #[doc = " Size of submission"]
    pub ib_bytes: __u32,
    #[doc = " HW IP to submit to"]
    pub ip_type: __u32,
    #[doc = " HW IP index of the same type to submit to"]
    pub ip_instance: __u32,
    #[doc = " Ring index to submit to"]
    pub ring: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_cs_chunk_ib"][::core::mem::size_of::<drm_amdgpu_cs_chunk_ib>() - 32usize];
    ["Alignment of drm_amdgpu_cs_chunk_ib"]
        [::core::mem::align_of::<drm_amdgpu_cs_chunk_ib>() - 8usize];
    ["Offset of field: drm_amdgpu_cs_chunk_ib::_pad"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_ib, _pad) - 0usize];
    ["Offset of field: drm_amdgpu_cs_chunk_ib::flags"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_ib, flags) - 4usize];
    ["Offset of field: drm_amdgpu_cs_chunk_ib::va_start"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_ib, va_start) - 8usize];
    ["Offset of field: drm_amdgpu_cs_chunk_ib::ib_bytes"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_ib, ib_bytes) - 16usize];
    ["Offset of field: drm_amdgpu_cs_chunk_ib::ip_type"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_ib, ip_type) - 20usize];
    ["Offset of field: drm_amdgpu_cs_chunk_ib::ip_instance"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_ib, ip_instance) - 24usize];
    ["Offset of field: drm_amdgpu_cs_chunk_ib::ring"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_ib, ring) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_dep {
    pub ip_type: __u32,
    pub ip_instance: __u32,
    pub ring: __u32,
    pub ctx_id: __u32,
    pub handle: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_cs_chunk_dep"]
        [::core::mem::size_of::<drm_amdgpu_cs_chunk_dep>() - 24usize];
    ["Alignment of drm_amdgpu_cs_chunk_dep"]
        [::core::mem::align_of::<drm_amdgpu_cs_chunk_dep>() - 8usize];
    ["Offset of field: drm_amdgpu_cs_chunk_dep::ip_type"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_dep, ip_type) - 0usize];
    ["Offset of field: drm_amdgpu_cs_chunk_dep::ip_instance"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_dep, ip_instance) - 4usize];
    ["Offset of field: drm_amdgpu_cs_chunk_dep::ring"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_dep, ring) - 8usize];
    ["Offset of field: drm_amdgpu_cs_chunk_dep::ctx_id"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_dep, ctx_id) - 12usize];
    ["Offset of field: drm_amdgpu_cs_chunk_dep::handle"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_dep, handle) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_fence {
    pub handle: __u32,
    pub offset: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_cs_chunk_fence"]
        [::core::mem::size_of::<drm_amdgpu_cs_chunk_fence>() - 8usize];
    ["Alignment of drm_amdgpu_cs_chunk_fence"]
        [::core::mem::align_of::<drm_amdgpu_cs_chunk_fence>() - 4usize];
    ["Offset of field: drm_amdgpu_cs_chunk_fence::handle"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_fence, handle) - 0usize];
    ["Offset of field: drm_amdgpu_cs_chunk_fence::offset"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_fence, offset) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_sem {
    pub handle: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_cs_chunk_sem"][::core::mem::size_of::<drm_amdgpu_cs_chunk_sem>() - 4usize];
    ["Alignment of drm_amdgpu_cs_chunk_sem"]
        [::core::mem::align_of::<drm_amdgpu_cs_chunk_sem>() - 4usize];
    ["Offset of field: drm_amdgpu_cs_chunk_sem::handle"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_sem, handle) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_syncobj {
    pub handle: __u32,
    pub flags: __u32,
    pub point: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_cs_chunk_syncobj"]
        [::core::mem::size_of::<drm_amdgpu_cs_chunk_syncobj>() - 16usize];
    ["Alignment of drm_amdgpu_cs_chunk_syncobj"]
        [::core::mem::align_of::<drm_amdgpu_cs_chunk_syncobj>() - 8usize];
    ["Offset of field: drm_amdgpu_cs_chunk_syncobj::handle"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_syncobj, handle) - 0usize];
    ["Offset of field: drm_amdgpu_cs_chunk_syncobj::flags"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_syncobj, flags) - 4usize];
    ["Offset of field: drm_amdgpu_cs_chunk_syncobj::point"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_syncobj, point) - 8usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_fence_to_handle {
    pub in_: drm_amdgpu_fence_to_handle__bindgen_ty_1,
    pub out: drm_amdgpu_fence_to_handle__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_fence_to_handle__bindgen_ty_1 {
    pub fence: drm_amdgpu_fence,
    pub what: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_fence_to_handle__bindgen_ty_1"]
        [::core::mem::size_of::<drm_amdgpu_fence_to_handle__bindgen_ty_1>() - 32usize];
    ["Alignment of drm_amdgpu_fence_to_handle__bindgen_ty_1"]
        [::core::mem::align_of::<drm_amdgpu_fence_to_handle__bindgen_ty_1>() - 8usize];
    ["Offset of field: drm_amdgpu_fence_to_handle__bindgen_ty_1::fence"]
        [::core::mem::offset_of!(drm_amdgpu_fence_to_handle__bindgen_ty_1, fence) - 0usize];
    ["Offset of field: drm_amdgpu_fence_to_handle__bindgen_ty_1::what"]
        [::core::mem::offset_of!(drm_amdgpu_fence_to_handle__bindgen_ty_1, what) - 24usize];
    ["Offset of field: drm_amdgpu_fence_to_handle__bindgen_ty_1::pad"]
        [::core::mem::offset_of!(drm_amdgpu_fence_to_handle__bindgen_ty_1, pad) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_fence_to_handle__bindgen_ty_2 {
    pub handle: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_fence_to_handle__bindgen_ty_2"]
        [::core::mem::size_of::<drm_amdgpu_fence_to_handle__bindgen_ty_2>() - 4usize];
    ["Alignment of drm_amdgpu_fence_to_handle__bindgen_ty_2"]
        [::core::mem::align_of::<drm_amdgpu_fence_to_handle__bindgen_ty_2>() - 4usize];
    ["Offset of field: drm_amdgpu_fence_to_handle__bindgen_ty_2::handle"]
        [::core::mem::offset_of!(drm_amdgpu_fence_to_handle__bindgen_ty_2, handle) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_fence_to_handle"]
        [::core::mem::size_of::<drm_amdgpu_fence_to_handle>() - 32usize];
    ["Alignment of drm_amdgpu_fence_to_handle"]
        [::core::mem::align_of::<drm_amdgpu_fence_to_handle>() - 8usize];
    ["Offset of field: drm_amdgpu_fence_to_handle::in_"]
        [::core::mem::offset_of!(drm_amdgpu_fence_to_handle, in_) - 0usize];
    ["Offset of field: drm_amdgpu_fence_to_handle::out"]
        [::core::mem::offset_of!(drm_amdgpu_fence_to_handle, out) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_data {
    pub __bindgen_anon_1: drm_amdgpu_cs_chunk_data__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_cs_chunk_data__bindgen_ty_1 {
    pub ib_data: drm_amdgpu_cs_chunk_ib,
    pub fence_data: drm_amdgpu_cs_chunk_fence,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_cs_chunk_data__bindgen_ty_1"]
        [::core::mem::size_of::<drm_amdgpu_cs_chunk_data__bindgen_ty_1>() - 32usize];
    ["Alignment of drm_amdgpu_cs_chunk_data__bindgen_ty_1"]
        [::core::mem::align_of::<drm_amdgpu_cs_chunk_data__bindgen_ty_1>() - 8usize];
    ["Offset of field: drm_amdgpu_cs_chunk_data__bindgen_ty_1::ib_data"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_data__bindgen_ty_1, ib_data) - 0usize];
    ["Offset of field: drm_amdgpu_cs_chunk_data__bindgen_ty_1::fence_data"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_data__bindgen_ty_1, fence_data) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_cs_chunk_data"]
        [::core::mem::size_of::<drm_amdgpu_cs_chunk_data>() - 32usize];
    ["Alignment of drm_amdgpu_cs_chunk_data"]
        [::core::mem::align_of::<drm_amdgpu_cs_chunk_data>() - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_cs_chunk_cp_gfx_shadow {
    pub shadow_va: __u64,
    pub csa_va: __u64,
    pub gds_va: __u64,
    pub flags: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_cs_chunk_cp_gfx_shadow"]
        [::core::mem::size_of::<drm_amdgpu_cs_chunk_cp_gfx_shadow>() - 32usize];
    ["Alignment of drm_amdgpu_cs_chunk_cp_gfx_shadow"]
        [::core::mem::align_of::<drm_amdgpu_cs_chunk_cp_gfx_shadow>() - 8usize];
    ["Offset of field: drm_amdgpu_cs_chunk_cp_gfx_shadow::shadow_va"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_cp_gfx_shadow, shadow_va) - 0usize];
    ["Offset of field: drm_amdgpu_cs_chunk_cp_gfx_shadow::csa_va"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_cp_gfx_shadow, csa_va) - 8usize];
    ["Offset of field: drm_amdgpu_cs_chunk_cp_gfx_shadow::gds_va"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_cp_gfx_shadow, gds_va) - 16usize];
    ["Offset of field: drm_amdgpu_cs_chunk_cp_gfx_shadow::flags"]
        [::core::mem::offset_of!(drm_amdgpu_cs_chunk_cp_gfx_shadow, flags) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_query_fw {
    #[doc = " AMDGPU_INFO_FW_*"]
    pub fw_type: __u32,
    #[doc = " Index of the IP if there are more IPs of\n the same type."]
    pub ip_instance: __u32,
    #[doc = " Index of the engine. Whether this is used depends\n on the firmware type. (e.g. MEC, SDMA)"]
    pub index: __u32,
    pub _pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_query_fw"][::core::mem::size_of::<drm_amdgpu_query_fw>() - 16usize];
    ["Alignment of drm_amdgpu_query_fw"][::core::mem::align_of::<drm_amdgpu_query_fw>() - 4usize];
    ["Offset of field: drm_amdgpu_query_fw::fw_type"]
        [::core::mem::offset_of!(drm_amdgpu_query_fw, fw_type) - 0usize];
    ["Offset of field: drm_amdgpu_query_fw::ip_instance"]
        [::core::mem::offset_of!(drm_amdgpu_query_fw, ip_instance) - 4usize];
    ["Offset of field: drm_amdgpu_query_fw::index"]
        [::core::mem::offset_of!(drm_amdgpu_query_fw, index) - 8usize];
    ["Offset of field: drm_amdgpu_query_fw::_pad"]
        [::core::mem::offset_of!(drm_amdgpu_query_fw, _pad) - 12usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct drm_amdgpu_info {
    pub return_pointer: __u64,
    pub return_size: __u32,
    pub query: __u32,
    pub __bindgen_anon_1: drm_amdgpu_info__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union drm_amdgpu_info__bindgen_ty_1 {
    pub mode_crtc: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_1,
    pub query_hw_ip: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_2,
    pub read_mmr_reg: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3,
    pub query_fw: drm_amdgpu_query_fw,
    pub vbios_info: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_4,
    pub sensor_info: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_5,
    pub video_cap: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_6,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info__bindgen_ty_1__bindgen_ty_1 {
    pub id: __u32,
    pub _pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info__bindgen_ty_1__bindgen_ty_1"]
        [::core::mem::size_of::<drm_amdgpu_info__bindgen_ty_1__bindgen_ty_1>() - 8usize];
    ["Alignment of drm_amdgpu_info__bindgen_ty_1__bindgen_ty_1"]
        [::core::mem::align_of::<drm_amdgpu_info__bindgen_ty_1__bindgen_ty_1>() - 4usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_1::id"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1__bindgen_ty_1, id) - 0usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_1::_pad"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1__bindgen_ty_1, _pad) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info__bindgen_ty_1__bindgen_ty_2 {
    #[doc = " AMDGPU_HW_IP_*"]
    pub type_: __u32,
    #[doc = " Index of the IP if there are more IPs of the same\n type. Ignored by AMDGPU_INFO_HW_IP_COUNT."]
    pub ip_instance: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info__bindgen_ty_1__bindgen_ty_2"]
        [::core::mem::size_of::<drm_amdgpu_info__bindgen_ty_1__bindgen_ty_2>() - 8usize];
    ["Alignment of drm_amdgpu_info__bindgen_ty_1__bindgen_ty_2"]
        [::core::mem::align_of::<drm_amdgpu_info__bindgen_ty_1__bindgen_ty_2>() - 4usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_2::type_"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1__bindgen_ty_2, type_) - 0usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_2::ip_instance"][::core::mem::offset_of!(
        drm_amdgpu_info__bindgen_ty_1__bindgen_ty_2,
        ip_instance
    ) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3 {
    pub dword_offset: __u32,
    #[doc = " number of registers to read"]
    pub count: __u32,
    pub instance: __u32,
    #[doc = " For future use, no flags defined so far"]
    pub flags: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3"]
        [::core::mem::size_of::<drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3>() - 16usize];
    ["Alignment of drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3"]
        [::core::mem::align_of::<drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3>() - 4usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3::dword_offset"][::core::mem::offset_of!(
        drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3,
        dword_offset
    ) - 0usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3::count"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3, count) - 4usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3::instance"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3, instance) - 8usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3::flags"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1__bindgen_ty_3, flags) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info__bindgen_ty_1__bindgen_ty_4 {
    pub type_: __u32,
    pub offset: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info__bindgen_ty_1__bindgen_ty_4"]
        [::core::mem::size_of::<drm_amdgpu_info__bindgen_ty_1__bindgen_ty_4>() - 8usize];
    ["Alignment of drm_amdgpu_info__bindgen_ty_1__bindgen_ty_4"]
        [::core::mem::align_of::<drm_amdgpu_info__bindgen_ty_1__bindgen_ty_4>() - 4usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_4::type_"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1__bindgen_ty_4, type_) - 0usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_4::offset"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1__bindgen_ty_4, offset) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info__bindgen_ty_1__bindgen_ty_5 {
    pub type_: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info__bindgen_ty_1__bindgen_ty_5"]
        [::core::mem::size_of::<drm_amdgpu_info__bindgen_ty_1__bindgen_ty_5>() - 4usize];
    ["Alignment of drm_amdgpu_info__bindgen_ty_1__bindgen_ty_5"]
        [::core::mem::align_of::<drm_amdgpu_info__bindgen_ty_1__bindgen_ty_5>() - 4usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_5::type_"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1__bindgen_ty_5, type_) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info__bindgen_ty_1__bindgen_ty_6 {
    pub type_: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info__bindgen_ty_1__bindgen_ty_6"]
        [::core::mem::size_of::<drm_amdgpu_info__bindgen_ty_1__bindgen_ty_6>() - 4usize];
    ["Alignment of drm_amdgpu_info__bindgen_ty_1__bindgen_ty_6"]
        [::core::mem::align_of::<drm_amdgpu_info__bindgen_ty_1__bindgen_ty_6>() - 4usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1__bindgen_ty_6::type_"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1__bindgen_ty_6, type_) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info__bindgen_ty_1"]
        [::core::mem::size_of::<drm_amdgpu_info__bindgen_ty_1>() - 16usize];
    ["Alignment of drm_amdgpu_info__bindgen_ty_1"]
        [::core::mem::align_of::<drm_amdgpu_info__bindgen_ty_1>() - 4usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1::mode_crtc"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1, mode_crtc) - 0usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1::query_hw_ip"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1, query_hw_ip) - 0usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1::read_mmr_reg"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1, read_mmr_reg) - 0usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1::query_fw"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1, query_fw) - 0usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1::vbios_info"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1, vbios_info) - 0usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1::sensor_info"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1, sensor_info) - 0usize];
    ["Offset of field: drm_amdgpu_info__bindgen_ty_1::video_cap"]
        [::core::mem::offset_of!(drm_amdgpu_info__bindgen_ty_1, video_cap) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info"][::core::mem::size_of::<drm_amdgpu_info>() - 32usize];
    ["Alignment of drm_amdgpu_info"][::core::mem::align_of::<drm_amdgpu_info>() - 8usize];
    ["Offset of field: drm_amdgpu_info::return_pointer"]
        [::core::mem::offset_of!(drm_amdgpu_info, return_pointer) - 0usize];
    ["Offset of field: drm_amdgpu_info::return_size"]
        [::core::mem::offset_of!(drm_amdgpu_info, return_size) - 8usize];
    ["Offset of field: drm_amdgpu_info::query"]
        [::core::mem::offset_of!(drm_amdgpu_info, query) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_gds {
    #[doc = " GDS GFX partition size"]
    pub gds_gfx_partition_size: __u32,
    #[doc = " GDS compute partition size"]
    pub compute_partition_size: __u32,
    #[doc = " total GDS memory size"]
    pub gds_total_size: __u32,
    #[doc = " GWS size per GFX partition"]
    pub gws_per_gfx_partition: __u32,
    #[doc = " GSW size per compute partition"]
    pub gws_per_compute_partition: __u32,
    #[doc = " OA size per GFX partition"]
    pub oa_per_gfx_partition: __u32,
    #[doc = " OA size per compute partition"]
    pub oa_per_compute_partition: __u32,
    pub _pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info_gds"][::core::mem::size_of::<drm_amdgpu_info_gds>() - 32usize];
    ["Alignment of drm_amdgpu_info_gds"][::core::mem::align_of::<drm_amdgpu_info_gds>() - 4usize];
    ["Offset of field: drm_amdgpu_info_gds::gds_gfx_partition_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_gds, gds_gfx_partition_size) - 0usize];
    ["Offset of field: drm_amdgpu_info_gds::compute_partition_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_gds, compute_partition_size) - 4usize];
    ["Offset of field: drm_amdgpu_info_gds::gds_total_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_gds, gds_total_size) - 8usize];
    ["Offset of field: drm_amdgpu_info_gds::gws_per_gfx_partition"]
        [::core::mem::offset_of!(drm_amdgpu_info_gds, gws_per_gfx_partition) - 12usize];
    ["Offset of field: drm_amdgpu_info_gds::gws_per_compute_partition"]
        [::core::mem::offset_of!(drm_amdgpu_info_gds, gws_per_compute_partition) - 16usize];
    ["Offset of field: drm_amdgpu_info_gds::oa_per_gfx_partition"]
        [::core::mem::offset_of!(drm_amdgpu_info_gds, oa_per_gfx_partition) - 20usize];
    ["Offset of field: drm_amdgpu_info_gds::oa_per_compute_partition"]
        [::core::mem::offset_of!(drm_amdgpu_info_gds, oa_per_compute_partition) - 24usize];
    ["Offset of field: drm_amdgpu_info_gds::_pad"]
        [::core::mem::offset_of!(drm_amdgpu_info_gds, _pad) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_vram_gtt {
    pub vram_size: __u64,
    pub vram_cpu_accessible_size: __u64,
    pub gtt_size: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info_vram_gtt"]
        [::core::mem::size_of::<drm_amdgpu_info_vram_gtt>() - 24usize];
    ["Alignment of drm_amdgpu_info_vram_gtt"]
        [::core::mem::align_of::<drm_amdgpu_info_vram_gtt>() - 8usize];
    ["Offset of field: drm_amdgpu_info_vram_gtt::vram_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_vram_gtt, vram_size) - 0usize];
    ["Offset of field: drm_amdgpu_info_vram_gtt::vram_cpu_accessible_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_vram_gtt, vram_cpu_accessible_size) - 8usize];
    ["Offset of field: drm_amdgpu_info_vram_gtt::gtt_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_vram_gtt, gtt_size) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_heap_info {
    #[doc = " max. physical memory"]
    pub total_heap_size: __u64,
    #[doc = " Theoretical max. available memory in the given heap"]
    pub usable_heap_size: __u64,
    #[doc = " Number of bytes allocated in the heap. This includes all processes\n and private allocations in the kernel. It changes when new buffers\n are allocated, freed, and moved. It cannot be larger than\n heap_size."]
    pub heap_usage: __u64,
    #[doc = " Theoretical possible max. size of buffer which\n could be allocated in the given heap"]
    pub max_allocation: __u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_heap_info"][::core::mem::size_of::<drm_amdgpu_heap_info>() - 32usize];
    ["Alignment of drm_amdgpu_heap_info"][::core::mem::align_of::<drm_amdgpu_heap_info>() - 8usize];
    ["Offset of field: drm_amdgpu_heap_info::total_heap_size"]
        [::core::mem::offset_of!(drm_amdgpu_heap_info, total_heap_size) - 0usize];
    ["Offset of field: drm_amdgpu_heap_info::usable_heap_size"]
        [::core::mem::offset_of!(drm_amdgpu_heap_info, usable_heap_size) - 8usize];
    ["Offset of field: drm_amdgpu_heap_info::heap_usage"]
        [::core::mem::offset_of!(drm_amdgpu_heap_info, heap_usage) - 16usize];
    ["Offset of field: drm_amdgpu_heap_info::max_allocation"]
        [::core::mem::offset_of!(drm_amdgpu_heap_info, max_allocation) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_memory_info {
    pub vram: drm_amdgpu_heap_info,
    pub cpu_accessible_vram: drm_amdgpu_heap_info,
    pub gtt: drm_amdgpu_heap_info,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_memory_info"][::core::mem::size_of::<drm_amdgpu_memory_info>() - 96usize];
    ["Alignment of drm_amdgpu_memory_info"]
        [::core::mem::align_of::<drm_amdgpu_memory_info>() - 8usize];
    ["Offset of field: drm_amdgpu_memory_info::vram"]
        [::core::mem::offset_of!(drm_amdgpu_memory_info, vram) - 0usize];
    ["Offset of field: drm_amdgpu_memory_info::cpu_accessible_vram"]
        [::core::mem::offset_of!(drm_amdgpu_memory_info, cpu_accessible_vram) - 32usize];
    ["Offset of field: drm_amdgpu_memory_info::gtt"]
        [::core::mem::offset_of!(drm_amdgpu_memory_info, gtt) - 64usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_firmware {
    pub ver: __u32,
    pub feature: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info_firmware"]
        [::core::mem::size_of::<drm_amdgpu_info_firmware>() - 8usize];
    ["Alignment of drm_amdgpu_info_firmware"]
        [::core::mem::align_of::<drm_amdgpu_info_firmware>() - 4usize];
    ["Offset of field: drm_amdgpu_info_firmware::ver"]
        [::core::mem::offset_of!(drm_amdgpu_info_firmware, ver) - 0usize];
    ["Offset of field: drm_amdgpu_info_firmware::feature"]
        [::core::mem::offset_of!(drm_amdgpu_info_firmware, feature) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_vbios {
    pub name: [__u8; 64usize],
    pub vbios_pn: [__u8; 64usize],
    pub version: __u32,
    pub pad: __u32,
    pub vbios_ver_str: [__u8; 32usize],
    pub date: [__u8; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info_vbios"][::core::mem::size_of::<drm_amdgpu_info_vbios>() - 200usize];
    ["Alignment of drm_amdgpu_info_vbios"]
        [::core::mem::align_of::<drm_amdgpu_info_vbios>() - 4usize];
    ["Offset of field: drm_amdgpu_info_vbios::name"]
        [::core::mem::offset_of!(drm_amdgpu_info_vbios, name) - 0usize];
    ["Offset of field: drm_amdgpu_info_vbios::vbios_pn"]
        [::core::mem::offset_of!(drm_amdgpu_info_vbios, vbios_pn) - 64usize];
    ["Offset of field: drm_amdgpu_info_vbios::version"]
        [::core::mem::offset_of!(drm_amdgpu_info_vbios, version) - 128usize];
    ["Offset of field: drm_amdgpu_info_vbios::pad"]
        [::core::mem::offset_of!(drm_amdgpu_info_vbios, pad) - 132usize];
    ["Offset of field: drm_amdgpu_info_vbios::vbios_ver_str"]
        [::core::mem::offset_of!(drm_amdgpu_info_vbios, vbios_ver_str) - 136usize];
    ["Offset of field: drm_amdgpu_info_vbios::date"]
        [::core::mem::offset_of!(drm_amdgpu_info_vbios, date) - 168usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_device {
    #[doc = " PCI Device ID"]
    pub device_id: __u32,
    #[doc = " Internal chip revision: A0, A1, etc.)"]
    pub chip_rev: __u32,
    pub external_rev: __u32,
    #[doc = " Revision id in PCI Config space"]
    pub pci_rev: __u32,
    pub family: __u32,
    pub num_shader_engines: __u32,
    pub num_shader_arrays_per_engine: __u32,
    pub gpu_counter_freq: __u32,
    pub max_engine_clock: __u64,
    pub max_memory_clock: __u64,
    pub cu_active_number: __u32,
    pub cu_ao_mask: __u32,
    pub cu_bitmap: [[__u32; 4usize]; 4usize],
    #[doc = " Render backend pipe mask. One render backend is CB+DB."]
    pub enabled_rb_pipes_mask: __u32,
    pub num_rb_pipes: __u32,
    pub num_hw_gfx_contexts: __u32,
    pub pcie_gen: __u32,
    pub ids_flags: __u64,
    #[doc = " Starting virtual address for UMDs."]
    pub virtual_address_offset: __u64,
    #[doc = " The maximum virtual address"]
    pub virtual_address_max: __u64,
    #[doc = " Required alignment of virtual addresses."]
    pub virtual_address_alignment: __u32,
    #[doc = " Page table entry - fragment size"]
    pub pte_fragment_size: __u32,
    pub gart_page_size: __u32,
    #[doc = " constant engine ram size"]
    pub ce_ram_size: __u32,
    #[doc = " video memory type info"]
    pub vram_type: __u32,
    #[doc = " video memory bit width"]
    pub vram_bit_width: __u32,
    pub vce_harvest_config: __u32,
    pub gc_double_offchip_lds_buf: __u32,
    pub prim_buf_gpu_addr: __u64,
    pub pos_buf_gpu_addr: __u64,
    pub cntl_sb_buf_gpu_addr: __u64,
    pub param_buf_gpu_addr: __u64,
    pub prim_buf_size: __u32,
    pub pos_buf_size: __u32,
    pub cntl_sb_buf_size: __u32,
    pub param_buf_size: __u32,
    pub wave_front_size: __u32,
    pub num_shader_visible_vgprs: __u32,
    pub num_cu_per_sh: __u32,
    pub num_tcc_blocks: __u32,
    pub gs_vgt_table_depth: __u32,
    pub gs_prim_buffer_depth: __u32,
    pub max_gs_waves_per_vgt: __u32,
    pub pcie_num_lanes: __u32,
    pub cu_ao_bitmap: [[__u32; 4usize]; 4usize],
    #[doc = " Starting high virtual address for UMDs."]
    pub high_va_offset: __u64,
    #[doc = " The maximum high virtual address"]
    pub high_va_max: __u64,
    pub pa_sc_tile_steering_override: __u32,
    pub tcc_disabled_mask: __u64,
    pub min_engine_clock: __u64,
    pub min_memory_clock: __u64,
    pub tcp_cache_size: __u32,
    pub num_sqc_per_wgp: __u32,
    pub sqc_data_cache_size: __u32,
    pub sqc_inst_cache_size: __u32,
    pub gl1c_cache_size: __u32,
    pub gl2c_cache_size: __u32,
    pub mall_size: __u64,
    pub enabled_rb_pipes_mask_hi: __u32,
    pub shadow_size: __u32,
    pub shadow_alignment: __u32,
    pub csa_size: __u32,
    pub csa_alignment: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info_device"][::core::mem::size_of::<drm_amdgpu_info_device>() - 440usize];
    ["Alignment of drm_amdgpu_info_device"]
        [::core::mem::align_of::<drm_amdgpu_info_device>() - 8usize];
    ["Offset of field: drm_amdgpu_info_device::device_id"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, device_id) - 0usize];
    ["Offset of field: drm_amdgpu_info_device::chip_rev"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, chip_rev) - 4usize];
    ["Offset of field: drm_amdgpu_info_device::external_rev"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, external_rev) - 8usize];
    ["Offset of field: drm_amdgpu_info_device::pci_rev"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, pci_rev) - 12usize];
    ["Offset of field: drm_amdgpu_info_device::family"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, family) - 16usize];
    ["Offset of field: drm_amdgpu_info_device::num_shader_engines"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, num_shader_engines) - 20usize];
    ["Offset of field: drm_amdgpu_info_device::num_shader_arrays_per_engine"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, num_shader_arrays_per_engine) - 24usize];
    ["Offset of field: drm_amdgpu_info_device::gpu_counter_freq"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, gpu_counter_freq) - 28usize];
    ["Offset of field: drm_amdgpu_info_device::max_engine_clock"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, max_engine_clock) - 32usize];
    ["Offset of field: drm_amdgpu_info_device::max_memory_clock"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, max_memory_clock) - 40usize];
    ["Offset of field: drm_amdgpu_info_device::cu_active_number"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, cu_active_number) - 48usize];
    ["Offset of field: drm_amdgpu_info_device::cu_ao_mask"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, cu_ao_mask) - 52usize];
    ["Offset of field: drm_amdgpu_info_device::cu_bitmap"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, cu_bitmap) - 56usize];
    ["Offset of field: drm_amdgpu_info_device::enabled_rb_pipes_mask"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, enabled_rb_pipes_mask) - 120usize];
    ["Offset of field: drm_amdgpu_info_device::num_rb_pipes"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, num_rb_pipes) - 124usize];
    ["Offset of field: drm_amdgpu_info_device::num_hw_gfx_contexts"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, num_hw_gfx_contexts) - 128usize];
    ["Offset of field: drm_amdgpu_info_device::pcie_gen"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, pcie_gen) - 132usize];
    ["Offset of field: drm_amdgpu_info_device::ids_flags"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, ids_flags) - 136usize];
    ["Offset of field: drm_amdgpu_info_device::virtual_address_offset"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, virtual_address_offset) - 144usize];
    ["Offset of field: drm_amdgpu_info_device::virtual_address_max"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, virtual_address_max) - 152usize];
    ["Offset of field: drm_amdgpu_info_device::virtual_address_alignment"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, virtual_address_alignment) - 160usize];
    ["Offset of field: drm_amdgpu_info_device::pte_fragment_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, pte_fragment_size) - 164usize];
    ["Offset of field: drm_amdgpu_info_device::gart_page_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, gart_page_size) - 168usize];
    ["Offset of field: drm_amdgpu_info_device::ce_ram_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, ce_ram_size) - 172usize];
    ["Offset of field: drm_amdgpu_info_device::vram_type"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, vram_type) - 176usize];
    ["Offset of field: drm_amdgpu_info_device::vram_bit_width"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, vram_bit_width) - 180usize];
    ["Offset of field: drm_amdgpu_info_device::vce_harvest_config"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, vce_harvest_config) - 184usize];
    ["Offset of field: drm_amdgpu_info_device::gc_double_offchip_lds_buf"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, gc_double_offchip_lds_buf) - 188usize];
    ["Offset of field: drm_amdgpu_info_device::prim_buf_gpu_addr"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, prim_buf_gpu_addr) - 192usize];
    ["Offset of field: drm_amdgpu_info_device::pos_buf_gpu_addr"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, pos_buf_gpu_addr) - 200usize];
    ["Offset of field: drm_amdgpu_info_device::cntl_sb_buf_gpu_addr"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, cntl_sb_buf_gpu_addr) - 208usize];
    ["Offset of field: drm_amdgpu_info_device::param_buf_gpu_addr"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, param_buf_gpu_addr) - 216usize];
    ["Offset of field: drm_amdgpu_info_device::prim_buf_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, prim_buf_size) - 224usize];
    ["Offset of field: drm_amdgpu_info_device::pos_buf_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, pos_buf_size) - 228usize];
    ["Offset of field: drm_amdgpu_info_device::cntl_sb_buf_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, cntl_sb_buf_size) - 232usize];
    ["Offset of field: drm_amdgpu_info_device::param_buf_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, param_buf_size) - 236usize];
    ["Offset of field: drm_amdgpu_info_device::wave_front_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, wave_front_size) - 240usize];
    ["Offset of field: drm_amdgpu_info_device::num_shader_visible_vgprs"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, num_shader_visible_vgprs) - 244usize];
    ["Offset of field: drm_amdgpu_info_device::num_cu_per_sh"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, num_cu_per_sh) - 248usize];
    ["Offset of field: drm_amdgpu_info_device::num_tcc_blocks"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, num_tcc_blocks) - 252usize];
    ["Offset of field: drm_amdgpu_info_device::gs_vgt_table_depth"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, gs_vgt_table_depth) - 256usize];
    ["Offset of field: drm_amdgpu_info_device::gs_prim_buffer_depth"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, gs_prim_buffer_depth) - 260usize];
    ["Offset of field: drm_amdgpu_info_device::max_gs_waves_per_vgt"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, max_gs_waves_per_vgt) - 264usize];
    ["Offset of field: drm_amdgpu_info_device::pcie_num_lanes"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, pcie_num_lanes) - 268usize];
    ["Offset of field: drm_amdgpu_info_device::cu_ao_bitmap"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, cu_ao_bitmap) - 272usize];
    ["Offset of field: drm_amdgpu_info_device::high_va_offset"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, high_va_offset) - 336usize];
    ["Offset of field: drm_amdgpu_info_device::high_va_max"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, high_va_max) - 344usize];
    ["Offset of field: drm_amdgpu_info_device::pa_sc_tile_steering_override"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, pa_sc_tile_steering_override) - 352usize];
    ["Offset of field: drm_amdgpu_info_device::tcc_disabled_mask"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, tcc_disabled_mask) - 360usize];
    ["Offset of field: drm_amdgpu_info_device::min_engine_clock"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, min_engine_clock) - 368usize];
    ["Offset of field: drm_amdgpu_info_device::min_memory_clock"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, min_memory_clock) - 376usize];
    ["Offset of field: drm_amdgpu_info_device::tcp_cache_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, tcp_cache_size) - 384usize];
    ["Offset of field: drm_amdgpu_info_device::num_sqc_per_wgp"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, num_sqc_per_wgp) - 388usize];
    ["Offset of field: drm_amdgpu_info_device::sqc_data_cache_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, sqc_data_cache_size) - 392usize];
    ["Offset of field: drm_amdgpu_info_device::sqc_inst_cache_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, sqc_inst_cache_size) - 396usize];
    ["Offset of field: drm_amdgpu_info_device::gl1c_cache_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, gl1c_cache_size) - 400usize];
    ["Offset of field: drm_amdgpu_info_device::gl2c_cache_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, gl2c_cache_size) - 404usize];
    ["Offset of field: drm_amdgpu_info_device::mall_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, mall_size) - 408usize];
    ["Offset of field: drm_amdgpu_info_device::enabled_rb_pipes_mask_hi"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, enabled_rb_pipes_mask_hi) - 416usize];
    ["Offset of field: drm_amdgpu_info_device::shadow_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, shadow_size) - 420usize];
    ["Offset of field: drm_amdgpu_info_device::shadow_alignment"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, shadow_alignment) - 424usize];
    ["Offset of field: drm_amdgpu_info_device::csa_size"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, csa_size) - 428usize];
    ["Offset of field: drm_amdgpu_info_device::csa_alignment"]
        [::core::mem::offset_of!(drm_amdgpu_info_device, csa_alignment) - 432usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_hw_ip {
    #[doc = " Version of h/w IP"]
    pub hw_ip_version_major: __u32,
    pub hw_ip_version_minor: __u32,
    #[doc = " Capabilities"]
    pub capabilities_flags: __u64,
    #[doc = " command buffer address start alignment"]
    pub ib_start_alignment: __u32,
    #[doc = " command buffer size alignment"]
    pub ib_size_alignment: __u32,
    #[doc = " Bitmask of available rings. Bit 0 means ring 0, etc."]
    pub available_rings: __u32,
    #[doc = " version info: bits 23:16 major, 15:8 minor, 7:0 revision"]
    pub ip_discovery_version: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info_hw_ip"][::core::mem::size_of::<drm_amdgpu_info_hw_ip>() - 32usize];
    ["Alignment of drm_amdgpu_info_hw_ip"]
        [::core::mem::align_of::<drm_amdgpu_info_hw_ip>() - 8usize];
    ["Offset of field: drm_amdgpu_info_hw_ip::hw_ip_version_major"]
        [::core::mem::offset_of!(drm_amdgpu_info_hw_ip, hw_ip_version_major) - 0usize];
    ["Offset of field: drm_amdgpu_info_hw_ip::hw_ip_version_minor"]
        [::core::mem::offset_of!(drm_amdgpu_info_hw_ip, hw_ip_version_minor) - 4usize];
    ["Offset of field: drm_amdgpu_info_hw_ip::capabilities_flags"]
        [::core::mem::offset_of!(drm_amdgpu_info_hw_ip, capabilities_flags) - 8usize];
    ["Offset of field: drm_amdgpu_info_hw_ip::ib_start_alignment"]
        [::core::mem::offset_of!(drm_amdgpu_info_hw_ip, ib_start_alignment) - 16usize];
    ["Offset of field: drm_amdgpu_info_hw_ip::ib_size_alignment"]
        [::core::mem::offset_of!(drm_amdgpu_info_hw_ip, ib_size_alignment) - 20usize];
    ["Offset of field: drm_amdgpu_info_hw_ip::available_rings"]
        [::core::mem::offset_of!(drm_amdgpu_info_hw_ip, available_rings) - 24usize];
    ["Offset of field: drm_amdgpu_info_hw_ip::ip_discovery_version"]
        [::core::mem::offset_of!(drm_amdgpu_info_hw_ip, ip_discovery_version) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_num_handles {
    #[doc = " Max handles as supported by firmware for UVD"]
    pub uvd_max_handles: __u32,
    #[doc = " Handles currently in use for UVD"]
    pub uvd_used_handles: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info_num_handles"]
        [::core::mem::size_of::<drm_amdgpu_info_num_handles>() - 8usize];
    ["Alignment of drm_amdgpu_info_num_handles"]
        [::core::mem::align_of::<drm_amdgpu_info_num_handles>() - 4usize];
    ["Offset of field: drm_amdgpu_info_num_handles::uvd_max_handles"]
        [::core::mem::offset_of!(drm_amdgpu_info_num_handles, uvd_max_handles) - 0usize];
    ["Offset of field: drm_amdgpu_info_num_handles::uvd_used_handles"]
        [::core::mem::offset_of!(drm_amdgpu_info_num_handles, uvd_used_handles) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_vce_clock_table_entry {
    #[doc = " System clock"]
    pub sclk: __u32,
    #[doc = " Memory clock"]
    pub mclk: __u32,
    #[doc = " VCE clock"]
    pub eclk: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info_vce_clock_table_entry"]
        [::core::mem::size_of::<drm_amdgpu_info_vce_clock_table_entry>() - 16usize];
    ["Alignment of drm_amdgpu_info_vce_clock_table_entry"]
        [::core::mem::align_of::<drm_amdgpu_info_vce_clock_table_entry>() - 4usize];
    ["Offset of field: drm_amdgpu_info_vce_clock_table_entry::sclk"]
        [::core::mem::offset_of!(drm_amdgpu_info_vce_clock_table_entry, sclk) - 0usize];
    ["Offset of field: drm_amdgpu_info_vce_clock_table_entry::mclk"]
        [::core::mem::offset_of!(drm_amdgpu_info_vce_clock_table_entry, mclk) - 4usize];
    ["Offset of field: drm_amdgpu_info_vce_clock_table_entry::eclk"]
        [::core::mem::offset_of!(drm_amdgpu_info_vce_clock_table_entry, eclk) - 8usize];
    ["Offset of field: drm_amdgpu_info_vce_clock_table_entry::pad"]
        [::core::mem::offset_of!(drm_amdgpu_info_vce_clock_table_entry, pad) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_vce_clock_table {
    pub entries: [drm_amdgpu_info_vce_clock_table_entry; 6usize],
    pub num_valid_entries: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info_vce_clock_table"]
        [::core::mem::size_of::<drm_amdgpu_info_vce_clock_table>() - 104usize];
    ["Alignment of drm_amdgpu_info_vce_clock_table"]
        [::core::mem::align_of::<drm_amdgpu_info_vce_clock_table>() - 4usize];
    ["Offset of field: drm_amdgpu_info_vce_clock_table::entries"]
        [::core::mem::offset_of!(drm_amdgpu_info_vce_clock_table, entries) - 0usize];
    ["Offset of field: drm_amdgpu_info_vce_clock_table::num_valid_entries"]
        [::core::mem::offset_of!(drm_amdgpu_info_vce_clock_table, num_valid_entries) - 96usize];
    ["Offset of field: drm_amdgpu_info_vce_clock_table::pad"]
        [::core::mem::offset_of!(drm_amdgpu_info_vce_clock_table, pad) - 100usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_video_codec_info {
    pub valid: __u32,
    pub max_width: __u32,
    pub max_height: __u32,
    pub max_pixels_per_frame: __u32,
    pub max_level: __u32,
    pub pad: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info_video_codec_info"]
        [::core::mem::size_of::<drm_amdgpu_info_video_codec_info>() - 24usize];
    ["Alignment of drm_amdgpu_info_video_codec_info"]
        [::core::mem::align_of::<drm_amdgpu_info_video_codec_info>() - 4usize];
    ["Offset of field: drm_amdgpu_info_video_codec_info::valid"]
        [::core::mem::offset_of!(drm_amdgpu_info_video_codec_info, valid) - 0usize];
    ["Offset of field: drm_amdgpu_info_video_codec_info::max_width"]
        [::core::mem::offset_of!(drm_amdgpu_info_video_codec_info, max_width) - 4usize];
    ["Offset of field: drm_amdgpu_info_video_codec_info::max_height"]
        [::core::mem::offset_of!(drm_amdgpu_info_video_codec_info, max_height) - 8usize];
    ["Offset of field: drm_amdgpu_info_video_codec_info::max_pixels_per_frame"]
        [::core::mem::offset_of!(drm_amdgpu_info_video_codec_info, max_pixels_per_frame) - 12usize];
    ["Offset of field: drm_amdgpu_info_video_codec_info::max_level"]
        [::core::mem::offset_of!(drm_amdgpu_info_video_codec_info, max_level) - 16usize];
    ["Offset of field: drm_amdgpu_info_video_codec_info::pad"]
        [::core::mem::offset_of!(drm_amdgpu_info_video_codec_info, pad) - 20usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_video_caps {
    pub codec_info: [drm_amdgpu_info_video_codec_info; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info_video_caps"]
        [::core::mem::size_of::<drm_amdgpu_info_video_caps>() - 192usize];
    ["Alignment of drm_amdgpu_info_video_caps"]
        [::core::mem::align_of::<drm_amdgpu_info_video_caps>() - 4usize];
    ["Offset of field: drm_amdgpu_info_video_caps::codec_info"]
        [::core::mem::offset_of!(drm_amdgpu_info_video_caps, codec_info) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct drm_amdgpu_info_gpuvm_fault {
    pub addr: __u64,
    pub status: __u32,
    pub vmhub: __u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of drm_amdgpu_info_gpuvm_fault"]
        [::core::mem::size_of::<drm_amdgpu_info_gpuvm_fault>() - 16usize];
    ["Alignment of drm_amdgpu_info_gpuvm_fault"]
        [::core::mem::align_of::<drm_amdgpu_info_gpuvm_fault>() - 8usize];
    ["Offset of field: drm_amdgpu_info_gpuvm_fault::addr"]
        [::core::mem::offset_of!(drm_amdgpu_info_gpuvm_fault, addr) - 0usize];
    ["Offset of field: drm_amdgpu_info_gpuvm_fault::status"]
        [::core::mem::offset_of!(drm_amdgpu_info_gpuvm_fault, status) - 8usize];
    ["Offset of field: drm_amdgpu_info_gpuvm_fault::vmhub"]
        [::core::mem::offset_of!(drm_amdgpu_info_gpuvm_fault, vmhub) - 12usize];
};
pub const atom_bios_header_version_def_ATOM_MAJOR_VERSION: atom_bios_header_version_def = 3;
pub const atom_bios_header_version_def_ATOM_MINOR_VERSION: atom_bios_header_version_def = 3;
pub type atom_bios_header_version_def = ::core::ffi::c_uint;
pub const atom_crtc_def_ATOM_CRTC1: atom_crtc_def = 0;
pub const atom_crtc_def_ATOM_CRTC2: atom_crtc_def = 1;
pub const atom_crtc_def_ATOM_CRTC3: atom_crtc_def = 2;
pub const atom_crtc_def_ATOM_CRTC4: atom_crtc_def = 3;
pub const atom_crtc_def_ATOM_CRTC5: atom_crtc_def = 4;
pub const atom_crtc_def_ATOM_CRTC6: atom_crtc_def = 5;
pub const atom_crtc_def_ATOM_CRTC_INVALID: atom_crtc_def = 255;
pub type atom_crtc_def = ::core::ffi::c_uint;
pub const atom_ppll_def_ATOM_PPLL0: atom_ppll_def = 2;
pub const atom_ppll_def_ATOM_GCK_DFS: atom_ppll_def = 8;
pub const atom_ppll_def_ATOM_FCH_CLK: atom_ppll_def = 9;
pub const atom_ppll_def_ATOM_DP_DTO: atom_ppll_def = 11;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL0: atom_ppll_def = 20;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL1: atom_ppll_def = 21;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL2: atom_ppll_def = 22;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL3: atom_ppll_def = 23;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL4: atom_ppll_def = 24;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL5: atom_ppll_def = 25;
pub const atom_ppll_def_ATOM_PPLL_INVALID: atom_ppll_def = 255;
pub type atom_ppll_def = ::core::ffi::c_uint;
pub const atom_dig_def_ASIC_INT_DIG1_ENCODER_ID: atom_dig_def = 3;
pub const atom_dig_def_ASIC_INT_DIG2_ENCODER_ID: atom_dig_def = 9;
pub const atom_dig_def_ASIC_INT_DIG3_ENCODER_ID: atom_dig_def = 10;
pub const atom_dig_def_ASIC_INT_DIG4_ENCODER_ID: atom_dig_def = 11;
pub const atom_dig_def_ASIC_INT_DIG5_ENCODER_ID: atom_dig_def = 12;
pub const atom_dig_def_ASIC_INT_DIG6_ENCODER_ID: atom_dig_def = 13;
pub const atom_dig_def_ASIC_INT_DIG7_ENCODER_ID: atom_dig_def = 14;
pub type atom_dig_def = ::core::ffi::c_uint;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP: atom_encode_mode_def = 0;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP_SST: atom_encode_mode_def = 0;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_LVDS: atom_encode_mode_def = 1;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DVI: atom_encode_mode_def = 2;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_HDMI: atom_encode_mode_def = 3;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP_AUDIO: atom_encode_mode_def = 5;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP_MST: atom_encode_mode_def = 5;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_CRT: atom_encode_mode_def = 15;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DVO: atom_encode_mode_def = 16;
pub type atom_encode_mode_def = ::core::ffi::c_uint;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_P1PLL: atom_encoder_refclk_src_def = 0;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_P2PLL: atom_encoder_refclk_src_def = 1;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_P3PLL: atom_encoder_refclk_src_def = 2;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_EXTCLK: atom_encoder_refclk_src_def = 3;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_INVALID: atom_encoder_refclk_src_def = 255;
pub type atom_encoder_refclk_src_def = ::core::ffi::c_uint;
pub const atom_scaler_def_ATOM_SCALER_DISABLE: atom_scaler_def = 0;
pub const atom_scaler_def_ATOM_SCALER_CENTER: atom_scaler_def = 1;
pub const atom_scaler_def_ATOM_SCALER_EXPANSION: atom_scaler_def = 2;
pub type atom_scaler_def = ::core::ffi::c_uint;
pub const atom_operation_def_ATOM_DISABLE: atom_operation_def = 0;
pub const atom_operation_def_ATOM_ENABLE: atom_operation_def = 1;
pub const atom_operation_def_ATOM_INIT: atom_operation_def = 7;
pub const atom_operation_def_ATOM_GET_STATUS: atom_operation_def = 8;
pub type atom_operation_def = ::core::ffi::c_uint;
pub const atom_embedded_display_op_def_ATOM_LCD_BL_OFF: atom_embedded_display_op_def = 2;
pub const atom_embedded_display_op_def_ATOM_LCD_BL_OM: atom_embedded_display_op_def = 3;
pub const atom_embedded_display_op_def_ATOM_LCD_BL_BRIGHTNESS_CONTROL:
    atom_embedded_display_op_def = 4;
pub const atom_embedded_display_op_def_ATOM_LCD_SELFTEST_START: atom_embedded_display_op_def = 5;
pub const atom_embedded_display_op_def_ATOM_LCD_SELFTEST_STOP: atom_embedded_display_op_def = 6;
pub type atom_embedded_display_op_def = ::core::ffi::c_uint;
pub const atom_spread_spectrum_mode_ATOM_SS_CENTER_OR_DOWN_MODE_MASK: atom_spread_spectrum_mode = 1;
pub const atom_spread_spectrum_mode_ATOM_SS_DOWN_SPREAD_MODE: atom_spread_spectrum_mode = 0;
pub const atom_spread_spectrum_mode_ATOM_SS_CENTRE_SPREAD_MODE: atom_spread_spectrum_mode = 1;
pub const atom_spread_spectrum_mode_ATOM_INT_OR_EXT_SS_MASK: atom_spread_spectrum_mode = 2;
pub const atom_spread_spectrum_mode_ATOM_INTERNAL_SS_MASK: atom_spread_spectrum_mode = 0;
pub const atom_spread_spectrum_mode_ATOM_EXTERNAL_SS_MASK: atom_spread_spectrum_mode = 2;
pub type atom_spread_spectrum_mode = ::core::ffi::c_uint;
pub const atom_panel_bit_per_color_PANEL_BPC_UNDEFINE: atom_panel_bit_per_color = 0;
pub const atom_panel_bit_per_color_PANEL_6BIT_PER_COLOR: atom_panel_bit_per_color = 1;
pub const atom_panel_bit_per_color_PANEL_8BIT_PER_COLOR: atom_panel_bit_per_color = 2;
pub const atom_panel_bit_per_color_PANEL_10BIT_PER_COLOR: atom_panel_bit_per_color = 3;
pub const atom_panel_bit_per_color_PANEL_12BIT_PER_COLOR: atom_panel_bit_per_color = 4;
pub const atom_panel_bit_per_color_PANEL_16BIT_PER_COLOR: atom_panel_bit_per_color = 5;
pub type atom_panel_bit_per_color = ::core::ffi::c_uint;
pub const atom_voltage_type_VOLTAGE_TYPE_VDDC: atom_voltage_type = 1;
pub const atom_voltage_type_VOLTAGE_TYPE_MVDDC: atom_voltage_type = 2;
pub const atom_voltage_type_VOLTAGE_TYPE_MVDDQ: atom_voltage_type = 3;
pub const atom_voltage_type_VOLTAGE_TYPE_VDDCI: atom_voltage_type = 4;
pub const atom_voltage_type_VOLTAGE_TYPE_VDDGFX: atom_voltage_type = 5;
pub const atom_voltage_type_VOLTAGE_TYPE_PCC: atom_voltage_type = 6;
pub const atom_voltage_type_VOLTAGE_TYPE_MVPP: atom_voltage_type = 7;
pub const atom_voltage_type_VOLTAGE_TYPE_LEDDPM: atom_voltage_type = 8;
pub const atom_voltage_type_VOLTAGE_TYPE_PCC_MVDD: atom_voltage_type = 9;
pub const atom_voltage_type_VOLTAGE_TYPE_PCIE_VDDC: atom_voltage_type = 10;
pub const atom_voltage_type_VOLTAGE_TYPE_PCIE_VDDR: atom_voltage_type = 11;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_1: atom_voltage_type = 17;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_2: atom_voltage_type = 18;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_3: atom_voltage_type = 19;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_4: atom_voltage_type = 20;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_5: atom_voltage_type = 21;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_6: atom_voltage_type = 22;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_7: atom_voltage_type = 23;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_8: atom_voltage_type = 24;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_9: atom_voltage_type = 25;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_10: atom_voltage_type = 26;
pub type atom_voltage_type = ::core::ffi::c_uint;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_GDDR5: atom_dgpu_vram_type = 80;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_HBM2: atom_dgpu_vram_type = 96;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_HBM2E: atom_dgpu_vram_type = 97;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_GDDR6: atom_dgpu_vram_type = 112;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_HBM3: atom_dgpu_vram_type = 128;
pub type atom_dgpu_vram_type = ::core::ffi::c_uint;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 0;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL1_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 1;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL2_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 2;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL3_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 3;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL1: atom_dp_vs_preemph_def = 8;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL1_PREEMPH_LEVEL1: atom_dp_vs_preemph_def = 9;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL2_PREEMPH_LEVEL1: atom_dp_vs_preemph_def = 10;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL2: atom_dp_vs_preemph_def = 16;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL1_PREEMPH_LEVEL2: atom_dp_vs_preemph_def = 17;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL3: atom_dp_vs_preemph_def = 24;
pub type atom_dp_vs_preemph_def = ::core::ffi::c_uint;
pub const atombios_image_offset_OFFSET_TO_ATOM_ROM_HEADER_POINTER: atombios_image_offset = 72;
pub const atombios_image_offset_OFFSET_TO_ATOM_ROM_IMAGE_SIZE: atombios_image_offset = 2;
pub const atombios_image_offset_OFFSET_TO_ATOMBIOS_ASIC_BUS_MEM_TYPE: atombios_image_offset = 148;
pub const atombios_image_offset_MAXSIZE_OF_ATOMBIOS_ASIC_BUS_MEM_TYPE: atombios_image_offset = 20;
pub const atombios_image_offset_OFFSET_TO_GET_ATOMBIOS_NUMBER_OF_STRINGS: atombios_image_offset =
    47;
pub const atombios_image_offset_OFFSET_TO_GET_ATOMBIOS_STRING_START: atombios_image_offset = 110;
pub const atombios_image_offset_OFFSET_TO_VBIOS_PART_NUMBER: atombios_image_offset = 128;
pub const atombios_image_offset_OFFSET_TO_VBIOS_DATE: atombios_image_offset = 80;
pub type atombios_image_offset = ::core::ffi::c_uint;
#[doc = " Common header for all tables (Data table, Command function).\n Every table pointed in _ATOM_MASTER_DATA_TABLE has this common header.\n And the pointer actually points to this header."]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_common_table_header {
    pub structuresize: u16,
    pub format_revision: u8,
    pub content_revision: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_common_table_header"]
        [::core::mem::size_of::<atom_common_table_header>() - 4usize];
    ["Alignment of atom_common_table_header"]
        [::core::mem::align_of::<atom_common_table_header>() - 1usize];
    ["Offset of field: atom_common_table_header::structuresize"]
        [::core::mem::offset_of!(atom_common_table_header, structuresize) - 0usize];
    ["Offset of field: atom_common_table_header::format_revision"]
        [::core::mem::offset_of!(atom_common_table_header, format_revision) - 2usize];
    ["Offset of field: atom_common_table_header::content_revision"]
        [::core::mem::offset_of!(atom_common_table_header, content_revision) - 3usize];
};
#[doc = " Structure stores the ROM header."]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_rom_header_v2_2 {
    pub table_header: atom_common_table_header,
    pub atom_bios_string: [u8; 4usize],
    pub bios_segment_address: u16,
    pub protectedmodeoffset: u16,
    pub configfilenameoffset: u16,
    pub crc_block_offset: u16,
    pub vbios_bootupmessageoffset: u16,
    pub int10_offset: u16,
    pub pcibusdevinitcode: u16,
    pub iobaseaddress: u16,
    pub subsystem_vendor_id: u16,
    pub subsystem_id: u16,
    pub pci_info_offset: u16,
    pub masterhwfunction_offset: u16,
    pub masterdatatable_offset: u16,
    pub reserved: u16,
    pub pspdirtableoffset: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_rom_header_v2_2"][::core::mem::size_of::<atom_rom_header_v2_2>() - 40usize];
    ["Alignment of atom_rom_header_v2_2"][::core::mem::align_of::<atom_rom_header_v2_2>() - 1usize];
    ["Offset of field: atom_rom_header_v2_2::table_header"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, table_header) - 0usize];
    ["Offset of field: atom_rom_header_v2_2::atom_bios_string"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, atom_bios_string) - 4usize];
    ["Offset of field: atom_rom_header_v2_2::bios_segment_address"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, bios_segment_address) - 8usize];
    ["Offset of field: atom_rom_header_v2_2::protectedmodeoffset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, protectedmodeoffset) - 10usize];
    ["Offset of field: atom_rom_header_v2_2::configfilenameoffset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, configfilenameoffset) - 12usize];
    ["Offset of field: atom_rom_header_v2_2::crc_block_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, crc_block_offset) - 14usize];
    ["Offset of field: atom_rom_header_v2_2::vbios_bootupmessageoffset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, vbios_bootupmessageoffset) - 16usize];
    ["Offset of field: atom_rom_header_v2_2::int10_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, int10_offset) - 18usize];
    ["Offset of field: atom_rom_header_v2_2::pcibusdevinitcode"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, pcibusdevinitcode) - 20usize];
    ["Offset of field: atom_rom_header_v2_2::iobaseaddress"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, iobaseaddress) - 22usize];
    ["Offset of field: atom_rom_header_v2_2::subsystem_vendor_id"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, subsystem_vendor_id) - 24usize];
    ["Offset of field: atom_rom_header_v2_2::subsystem_id"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, subsystem_id) - 26usize];
    ["Offset of field: atom_rom_header_v2_2::pci_info_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, pci_info_offset) - 28usize];
    ["Offset of field: atom_rom_header_v2_2::masterhwfunction_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, masterhwfunction_offset) - 30usize];
    ["Offset of field: atom_rom_header_v2_2::masterdatatable_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, masterdatatable_offset) - 32usize];
    ["Offset of field: atom_rom_header_v2_2::reserved"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, reserved) - 34usize];
    ["Offset of field: atom_rom_header_v2_2::pspdirtableoffset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, pspdirtableoffset) - 36usize];
};
#[doc = " Structures used in Command.mtb, each function name is not given here since those function could change from time to time\n The real functionality of each function is associated with the parameter structure version when defined\n For all internal cmd function definitions, please reference to atomstruct.h"]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_list_of_command_functions_v2_1 {
    pub asic_init: u16,
    pub cmd_function1: u16,
    pub cmd_function2: u16,
    pub cmd_function3: u16,
    pub digxencodercontrol: u16,
    pub cmd_function5: u16,
    pub cmd_function6: u16,
    pub cmd_function7: u16,
    pub cmd_function8: u16,
    pub cmd_function9: u16,
    pub setengineclock: u16,
    pub setmemoryclock: u16,
    pub setpixelclock: u16,
    pub enabledisppowergating: u16,
    pub cmd_function14: u16,
    pub cmd_function15: u16,
    pub cmd_function16: u16,
    pub cmd_function17: u16,
    pub cmd_function18: u16,
    pub cmd_function19: u16,
    pub cmd_function20: u16,
    pub cmd_function21: u16,
    pub cmd_function22: u16,
    pub cmd_function23: u16,
    pub cmd_function24: u16,
    pub cmd_function25: u16,
    pub cmd_function26: u16,
    pub cmd_function27: u16,
    pub cmd_function28: u16,
    pub cmd_function29: u16,
    pub cmd_function30: u16,
    pub cmd_function31: u16,
    pub cmd_function32: u16,
    pub cmd_function33: u16,
    pub blankcrtc: u16,
    pub enablecrtc: u16,
    pub cmd_function36: u16,
    pub cmd_function37: u16,
    pub cmd_function38: u16,
    pub cmd_function39: u16,
    pub cmd_function40: u16,
    pub getsmuclockinfo: u16,
    pub selectcrtc_source: u16,
    pub cmd_function43: u16,
    pub cmd_function44: u16,
    pub cmd_function45: u16,
    pub setdceclock: u16,
    pub getmemoryclock: u16,
    pub getengineclock: u16,
    pub setcrtc_usingdtdtiming: u16,
    pub externalencodercontrol: u16,
    pub cmd_function51: u16,
    pub cmd_function52: u16,
    pub cmd_function53: u16,
    pub processi2cchanneltransaction: u16,
    pub cmd_function55: u16,
    pub cmd_function56: u16,
    pub cmd_function57: u16,
    pub cmd_function58: u16,
    pub cmd_function59: u16,
    pub computegpuclockparam: u16,
    pub cmd_function61: u16,
    pub cmd_function62: u16,
    pub dynamicmemorysettings: u16,
    pub memorytraining: u16,
    pub cmd_function65: u16,
    pub cmd_function66: u16,
    pub setvoltage: u16,
    pub cmd_function68: u16,
    pub readefusevalue: u16,
    pub cmd_function70: u16,
    pub cmd_function71: u16,
    pub cmd_function72: u16,
    pub cmd_function73: u16,
    pub cmd_function74: u16,
    pub cmd_function75: u16,
    pub dig1transmittercontrol: u16,
    pub cmd_function77: u16,
    pub processauxchanneltransaction: u16,
    pub cmd_function79: u16,
    pub getvoltageinfo: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_master_list_of_command_functions_v2_1"]
        [::core::mem::size_of::<atom_master_list_of_command_functions_v2_1>() - 162usize];
    ["Alignment of atom_master_list_of_command_functions_v2_1"]
        [::core::mem::align_of::<atom_master_list_of_command_functions_v2_1>() - 1usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::asic_init"]
        [::core::mem::offset_of!(atom_master_list_of_command_functions_v2_1, asic_init) - 0usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function1"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function1
    ) - 2usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function2"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function2
    ) - 4usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function3"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function3
    ) - 6usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::digxencodercontrol"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        digxencodercontrol
    ) - 8usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function5"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function5
    ) - 10usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function6"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function6
    ) - 12usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function7"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function7
    ) - 14usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function8"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function8
    ) - 16usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function9"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function9
    ) - 18usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setengineclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setengineclock
    ) - 20usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setmemoryclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setmemoryclock
    ) - 22usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setpixelclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setpixelclock
    ) - 24usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::enabledisppowergating"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        enabledisppowergating
    )
        - 26usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function14"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function14
    ) - 28usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function15"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function15
    ) - 30usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function16"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function16
    ) - 32usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function17"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function17
    ) - 34usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function18"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function18
    ) - 36usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function19"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function19
    ) - 38usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function20"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function20
    ) - 40usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function21"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function21
    ) - 42usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function22"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function22
    ) - 44usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function23"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function23
    ) - 46usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function24"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function24
    ) - 48usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function25"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function25
    ) - 50usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function26"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function26
    ) - 52usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function27"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function27
    ) - 54usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function28"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function28
    ) - 56usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function29"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function29
    ) - 58usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function30"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function30
    ) - 60usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function31"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function31
    ) - 62usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function32"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function32
    ) - 64usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function33"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function33
    ) - 66usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::blankcrtc"]
        [::core::mem::offset_of!(atom_master_list_of_command_functions_v2_1, blankcrtc) - 68usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::enablecrtc"]
        [::core::mem::offset_of!(atom_master_list_of_command_functions_v2_1, enablecrtc) - 70usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function36"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function36
    ) - 72usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function37"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function37
    ) - 74usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function38"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function38
    ) - 76usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function39"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function39
    ) - 78usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function40"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function40
    ) - 80usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::getsmuclockinfo"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        getsmuclockinfo
    ) - 82usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::selectcrtc_source"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        selectcrtc_source
    ) - 84usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function43"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function43
    ) - 86usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function44"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function44
    ) - 88usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function45"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function45
    ) - 90usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setdceclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setdceclock
    ) - 92usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::getmemoryclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        getmemoryclock
    ) - 94usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::getengineclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        getengineclock
    ) - 96usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setcrtc_usingdtdtiming"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setcrtc_usingdtdtiming
    )
        - 98usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::externalencodercontrol"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        externalencodercontrol
    )
        - 100usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function51"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function51
    ) - 102usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function52"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function52
    ) - 104usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function53"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function53
    ) - 106usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::processi2cchanneltransaction"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        processi2cchanneltransaction
    )
        - 108usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function55"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function55
    ) - 110usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function56"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function56
    ) - 112usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function57"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function57
    ) - 114usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function58"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function58
    ) - 116usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function59"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function59
    ) - 118usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::computegpuclockparam"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        computegpuclockparam
    )
        - 120usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function61"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function61
    ) - 122usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function62"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function62
    ) - 124usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::dynamicmemorysettings"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        dynamicmemorysettings
    )
        - 126usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::memorytraining"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        memorytraining
    ) - 128usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function65"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function65
    ) - 130usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function66"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function66
    ) - 132usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setvoltage"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setvoltage
    ) - 134usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function68"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function68
    ) - 136usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::readefusevalue"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        readefusevalue
    ) - 138usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function70"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function70
    ) - 140usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function71"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function71
    ) - 142usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function72"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function72
    ) - 144usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function73"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function73
    ) - 146usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function74"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function74
    ) - 148usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function75"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function75
    ) - 150usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::dig1transmittercontrol"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        dig1transmittercontrol
    )
        - 152usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function77"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function77
    ) - 154usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::processauxchanneltransaction"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        processauxchanneltransaction
    )
        - 156usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function79"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function79
    ) - 158usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::getvoltageinfo"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        getvoltageinfo
    ) - 160usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_command_function_v2_1 {
    pub table_header: atom_common_table_header,
    pub listofcmdfunctions: atom_master_list_of_command_functions_v2_1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_master_command_function_v2_1"]
        [::core::mem::size_of::<atom_master_command_function_v2_1>() - 166usize];
    ["Alignment of atom_master_command_function_v2_1"]
        [::core::mem::align_of::<atom_master_command_function_v2_1>() - 1usize];
    ["Offset of field: atom_master_command_function_v2_1::table_header"]
        [::core::mem::offset_of!(atom_master_command_function_v2_1, table_header) - 0usize];
    ["Offset of field: atom_master_command_function_v2_1::listofcmdfunctions"]
        [::core::mem::offset_of!(atom_master_command_function_v2_1, listofcmdfunctions) - 4usize];
};
#[doc = " Structures used in every command function"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_function_attribute {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_function_attribute"][::core::mem::size_of::<atom_function_attribute>() - 2usize];
    ["Alignment of atom_function_attribute"]
        [::core::mem::align_of::<atom_function_attribute>() - 1usize];
};
impl atom_function_attribute {
    #[inline]
    pub fn ws_in_bytes(&self) -> u16 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u16) }
    }
    #[inline]
    pub fn set_ws_in_bytes(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn ps_in_bytes(&self) -> u16 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 7u8) as u16) }
    }
    #[inline]
    pub fn set_ps_in_bytes(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn updated_by_util(&self) -> u16 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_updated_by_util(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ws_in_bytes: u16,
        ps_in_bytes: u16,
        updated_by_util: u16,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let ws_in_bytes: u16 = unsafe { ::core::mem::transmute(ws_in_bytes) };
            ws_in_bytes as u64
        });
        __bindgen_bitfield_unit.set(8usize, 7u8, {
            let ps_in_bytes: u16 = unsafe { ::core::mem::transmute(ps_in_bytes) };
            ps_in_bytes as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let updated_by_util: u16 = unsafe { ::core::mem::transmute(updated_by_util) };
            updated_by_util as u64
        });
        __bindgen_bitfield_unit
    }
}
#[doc = " Common header for all hw functions.\n Every function pointed by _master_list_of_hw_function has this common header.\n And the pointer actually points to this header."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_rom_hw_function_header {
    pub func_header: atom_common_table_header,
    pub func_attrib: atom_function_attribute,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_rom_hw_function_header"]
        [::core::mem::size_of::<atom_rom_hw_function_header>() - 6usize];
    ["Alignment of atom_rom_hw_function_header"]
        [::core::mem::align_of::<atom_rom_hw_function_header>() - 1usize];
    ["Offset of field: atom_rom_hw_function_header::func_header"]
        [::core::mem::offset_of!(atom_rom_hw_function_header, func_header) - 0usize];
    ["Offset of field: atom_rom_hw_function_header::func_attrib"]
        [::core::mem::offset_of!(atom_rom_hw_function_header, func_attrib) - 4usize];
};
#[doc = " Structures used in data.mtb, each data table name is not given here since those data table could change from time to time\n The real name of each table is given when its data structure version is defined"]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_list_of_data_tables_v2_1 {
    pub utilitypipeline: u16,
    pub multimedia_info: u16,
    pub smc_dpm_info: u16,
    pub sw_datatable3: u16,
    pub firmwareinfo: u16,
    pub sw_datatable5: u16,
    pub lcd_info: u16,
    pub sw_datatable7: u16,
    pub smu_info: u16,
    pub sw_datatable9: u16,
    pub sw_datatable10: u16,
    pub vram_usagebyfirmware: u16,
    pub gpio_pin_lut: u16,
    pub sw_datatable13: u16,
    pub gfx_info: u16,
    pub powerplayinfo: u16,
    pub sw_datatable16: u16,
    pub sw_datatable17: u16,
    pub sw_datatable18: u16,
    pub sw_datatable19: u16,
    pub sw_datatable20: u16,
    pub sw_datatable21: u16,
    pub displayobjectinfo: u16,
    pub indirectioaccess: u16,
    pub umc_info: u16,
    pub sw_datatable25: u16,
    pub sw_datatable26: u16,
    pub dce_info: u16,
    pub vram_info: u16,
    pub sw_datatable29: u16,
    pub integratedsysteminfo: u16,
    pub asic_profiling_info: u16,
    pub voltageobject_info: u16,
    pub sw_datatable33: u16,
    pub sw_datatable34: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_master_list_of_data_tables_v2_1"]
        [::core::mem::size_of::<atom_master_list_of_data_tables_v2_1>() - 70usize];
    ["Alignment of atom_master_list_of_data_tables_v2_1"]
        [::core::mem::align_of::<atom_master_list_of_data_tables_v2_1>() - 1usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::utilitypipeline"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, utilitypipeline) - 0usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::multimedia_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, multimedia_info) - 2usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::smc_dpm_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, smc_dpm_info) - 4usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable3"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable3) - 6usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::firmwareinfo"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, firmwareinfo) - 8usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable5"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable5) - 10usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::lcd_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, lcd_info) - 12usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable7"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable7) - 14usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::smu_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, smu_info) - 16usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable9"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable9) - 18usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable10"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable10) - 20usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::vram_usagebyfirmware"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        vram_usagebyfirmware
    ) - 22usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::gpio_pin_lut"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, gpio_pin_lut) - 24usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable13"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable13) - 26usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::gfx_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, gfx_info) - 28usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::powerplayinfo"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, powerplayinfo) - 30usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable16"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable16) - 32usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable17"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable17) - 34usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable18"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable18) - 36usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable19"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable19) - 38usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable20"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable20) - 40usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable21"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable21) - 42usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::displayobjectinfo"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        displayobjectinfo
    ) - 44usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::indirectioaccess"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, indirectioaccess) - 46usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::umc_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, umc_info) - 48usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable25"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable25) - 50usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable26"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable26) - 52usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::dce_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, dce_info) - 54usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::vram_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, vram_info) - 56usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable29"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable29) - 58usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::integratedsysteminfo"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        integratedsysteminfo
    ) - 60usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::asic_profiling_info"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        asic_profiling_info
    ) - 62usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::voltageobject_info"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        voltageobject_info
    ) - 64usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable33"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable33) - 66usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable34"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable34) - 68usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_data_table_v2_1 {
    pub table_header: atom_common_table_header,
    pub listOfdatatables: atom_master_list_of_data_tables_v2_1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_master_data_table_v2_1"]
        [::core::mem::size_of::<atom_master_data_table_v2_1>() - 74usize];
    ["Alignment of atom_master_data_table_v2_1"]
        [::core::mem::align_of::<atom_master_data_table_v2_1>() - 1usize];
    ["Offset of field: atom_master_data_table_v2_1::table_header"]
        [::core::mem::offset_of!(atom_master_data_table_v2_1, table_header) - 0usize];
    ["Offset of field: atom_master_data_table_v2_1::listOfdatatables"]
        [::core::mem::offset_of!(atom_master_data_table_v2_1, listOfdatatables) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_dtd_format {
    pub pixclk: u16,
    pub h_active: u16,
    pub h_blanking_time: u16,
    pub v_active: u16,
    pub v_blanking_time: u16,
    pub h_sync_offset: u16,
    pub h_sync_width: u16,
    pub v_sync_offset: u16,
    pub v_syncwidth: u16,
    pub reserved: u16,
    pub reserved0: u16,
    pub h_border: u8,
    pub v_border: u8,
    pub miscinfo: u16,
    pub atom_mode_id: u8,
    pub refreshrate: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_dtd_format"][::core::mem::size_of::<atom_dtd_format>() - 28usize];
    ["Alignment of atom_dtd_format"][::core::mem::align_of::<atom_dtd_format>() - 1usize];
    ["Offset of field: atom_dtd_format::pixclk"]
        [::core::mem::offset_of!(atom_dtd_format, pixclk) - 0usize];
    ["Offset of field: atom_dtd_format::h_active"]
        [::core::mem::offset_of!(atom_dtd_format, h_active) - 2usize];
    ["Offset of field: atom_dtd_format::h_blanking_time"]
        [::core::mem::offset_of!(atom_dtd_format, h_blanking_time) - 4usize];
    ["Offset of field: atom_dtd_format::v_active"]
        [::core::mem::offset_of!(atom_dtd_format, v_active) - 6usize];
    ["Offset of field: atom_dtd_format::v_blanking_time"]
        [::core::mem::offset_of!(atom_dtd_format, v_blanking_time) - 8usize];
    ["Offset of field: atom_dtd_format::h_sync_offset"]
        [::core::mem::offset_of!(atom_dtd_format, h_sync_offset) - 10usize];
    ["Offset of field: atom_dtd_format::h_sync_width"]
        [::core::mem::offset_of!(atom_dtd_format, h_sync_width) - 12usize];
    ["Offset of field: atom_dtd_format::v_sync_offset"]
        [::core::mem::offset_of!(atom_dtd_format, v_sync_offset) - 14usize];
    ["Offset of field: atom_dtd_format::v_syncwidth"]
        [::core::mem::offset_of!(atom_dtd_format, v_syncwidth) - 16usize];
    ["Offset of field: atom_dtd_format::reserved"]
        [::core::mem::offset_of!(atom_dtd_format, reserved) - 18usize];
    ["Offset of field: atom_dtd_format::reserved0"]
        [::core::mem::offset_of!(atom_dtd_format, reserved0) - 20usize];
    ["Offset of field: atom_dtd_format::h_border"]
        [::core::mem::offset_of!(atom_dtd_format, h_border) - 22usize];
    ["Offset of field: atom_dtd_format::v_border"]
        [::core::mem::offset_of!(atom_dtd_format, v_border) - 23usize];
    ["Offset of field: atom_dtd_format::miscinfo"]
        [::core::mem::offset_of!(atom_dtd_format, miscinfo) - 24usize];
    ["Offset of field: atom_dtd_format::atom_mode_id"]
        [::core::mem::offset_of!(atom_dtd_format, atom_mode_id) - 26usize];
    ["Offset of field: atom_dtd_format::refreshrate"]
        [::core::mem::offset_of!(atom_dtd_format, refreshrate) - 27usize];
};
pub const atom_dtd_format_modemiscinfo_ATOM_HSYNC_POLARITY: atom_dtd_format_modemiscinfo = 2;
pub const atom_dtd_format_modemiscinfo_ATOM_VSYNC_POLARITY: atom_dtd_format_modemiscinfo = 4;
pub const atom_dtd_format_modemiscinfo_ATOM_H_REPLICATIONBY2: atom_dtd_format_modemiscinfo = 16;
pub const atom_dtd_format_modemiscinfo_ATOM_V_REPLICATIONBY2: atom_dtd_format_modemiscinfo = 32;
pub const atom_dtd_format_modemiscinfo_ATOM_INTERLACE: atom_dtd_format_modemiscinfo = 128;
pub const atom_dtd_format_modemiscinfo_ATOM_COMPOSITESYNC: atom_dtd_format_modemiscinfo = 64;
pub type atom_dtd_format_modemiscinfo = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_1 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub reserved2: [u32; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_firmware_info_v3_1"]
        [::core::mem::size_of::<atom_firmware_info_v3_1>() - 72usize];
    ["Alignment of atom_firmware_info_v3_1"]
        [::core::mem::align_of::<atom_firmware_info_v3_1>() - 1usize];
    ["Offset of field: atom_firmware_info_v3_1::table_header"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, table_header) - 0usize];
    ["Offset of field: atom_firmware_info_v3_1::firmware_revision"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, firmware_revision) - 4usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_sclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_sclk_in10khz) - 8usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_mclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_mclk_in10khz) - 12usize];
    ["Offset of field: atom_firmware_info_v3_1::firmware_capability"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, firmware_capability) - 16usize];
    ["Offset of field: atom_firmware_info_v3_1::main_call_parser_entry"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, main_call_parser_entry) - 20usize];
    ["Offset of field: atom_firmware_info_v3_1::bios_scratch_reg_startaddr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bios_scratch_reg_startaddr) - 24usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_vddc_mv) - 28usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_vddci_mv) - 30usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_mvddc_mv) - 32usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_vddgfx_mv) - 34usize];
    ["Offset of field: atom_firmware_info_v3_1::mem_module_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, mem_module_id) - 36usize];
    ["Offset of field: atom_firmware_info_v3_1::coolingsolution_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, coolingsolution_id) - 37usize];
    ["Offset of field: atom_firmware_info_v3_1::reserved1"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, reserved1) - 38usize];
    ["Offset of field: atom_firmware_info_v3_1::mc_baseaddr_high"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, mc_baseaddr_high) - 40usize];
    ["Offset of field: atom_firmware_info_v3_1::mc_baseaddr_low"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, mc_baseaddr_low) - 44usize];
    ["Offset of field: atom_firmware_info_v3_1::reserved2"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, reserved2) - 48usize];
};
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_FIRMWARE_POSTED:
    atombios_firmware_capability = 1;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_GPU_VIRTUALIZATION:
    atombios_firmware_capability = 2;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_WMI_SUPPORT: atombios_firmware_capability =
    64;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_HWEMU_ENABLE:
    atombios_firmware_capability = 128;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_HWEMU_UMC_CFG:
    atombios_firmware_capability = 256;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_SRAM_ECC: atombios_firmware_capability =
    512;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_ENABLE_2STAGE_BIST_TRAINING:
    atombios_firmware_capability = 1024;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_ENABLE_2ND_USB20PORT:
    atombios_firmware_capability = 32768;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_DYNAMIC_BOOT_CFG_ENABLE:
    atombios_firmware_capability = 131072;
pub type atombios_firmware_capability = ::core::ffi::c_uint;
pub const atom_cooling_solution_id_AIR_COOLING: atom_cooling_solution_id = 0;
pub const atom_cooling_solution_id_LIQUID_COOLING: atom_cooling_solution_id = 1;
pub type atom_cooling_solution_id = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_2 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub reserved3: u8,
    pub bootup_mvddq_mv: u16,
    pub bootup_mvpp_mv: u16,
    pub zfbstartaddrin16mb: u32,
    pub reserved2: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_firmware_info_v3_2"]
        [::core::mem::size_of::<atom_firmware_info_v3_2>() - 72usize];
    ["Alignment of atom_firmware_info_v3_2"]
        [::core::mem::align_of::<atom_firmware_info_v3_2>() - 1usize];
    ["Offset of field: atom_firmware_info_v3_2::table_header"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, table_header) - 0usize];
    ["Offset of field: atom_firmware_info_v3_2::firmware_revision"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, firmware_revision) - 4usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_sclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_sclk_in10khz) - 8usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_mclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_mclk_in10khz) - 12usize];
    ["Offset of field: atom_firmware_info_v3_2::firmware_capability"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, firmware_capability) - 16usize];
    ["Offset of field: atom_firmware_info_v3_2::main_call_parser_entry"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, main_call_parser_entry) - 20usize];
    ["Offset of field: atom_firmware_info_v3_2::bios_scratch_reg_startaddr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bios_scratch_reg_startaddr) - 24usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_vddc_mv) - 28usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_vddci_mv) - 30usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_mvddc_mv) - 32usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_vddgfx_mv) - 34usize];
    ["Offset of field: atom_firmware_info_v3_2::mem_module_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, mem_module_id) - 36usize];
    ["Offset of field: atom_firmware_info_v3_2::coolingsolution_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, coolingsolution_id) - 37usize];
    ["Offset of field: atom_firmware_info_v3_2::reserved1"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, reserved1) - 38usize];
    ["Offset of field: atom_firmware_info_v3_2::mc_baseaddr_high"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, mc_baseaddr_high) - 40usize];
    ["Offset of field: atom_firmware_info_v3_2::mc_baseaddr_low"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, mc_baseaddr_low) - 44usize];
    ["Offset of field: atom_firmware_info_v3_2::board_i2c_feature_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, board_i2c_feature_id) - 48usize];
    ["Offset of field: atom_firmware_info_v3_2::board_i2c_feature_gpio_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, board_i2c_feature_gpio_id) - 49usize];
    ["Offset of field: atom_firmware_info_v3_2::board_i2c_feature_slave_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, board_i2c_feature_slave_addr) - 50usize];
    ["Offset of field: atom_firmware_info_v3_2::reserved3"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, reserved3) - 51usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_mvddq_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_mvddq_mv) - 52usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_mvpp_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_mvpp_mv) - 54usize];
    ["Offset of field: atom_firmware_info_v3_2::zfbstartaddrin16mb"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, zfbstartaddrin16mb) - 56usize];
    ["Offset of field: atom_firmware_info_v3_2::reserved2"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, reserved2) - 60usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_3 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub reserved3: u8,
    pub bootup_mvddq_mv: u16,
    pub bootup_mvpp_mv: u16,
    pub zfbstartaddrin16mb: u32,
    pub pplib_pptable_id: u32,
    pub reserved2: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_firmware_info_v3_3"]
        [::core::mem::size_of::<atom_firmware_info_v3_3>() - 72usize];
    ["Alignment of atom_firmware_info_v3_3"]
        [::core::mem::align_of::<atom_firmware_info_v3_3>() - 1usize];
    ["Offset of field: atom_firmware_info_v3_3::table_header"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, table_header) - 0usize];
    ["Offset of field: atom_firmware_info_v3_3::firmware_revision"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, firmware_revision) - 4usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_sclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_sclk_in10khz) - 8usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_mclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_mclk_in10khz) - 12usize];
    ["Offset of field: atom_firmware_info_v3_3::firmware_capability"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, firmware_capability) - 16usize];
    ["Offset of field: atom_firmware_info_v3_3::main_call_parser_entry"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, main_call_parser_entry) - 20usize];
    ["Offset of field: atom_firmware_info_v3_3::bios_scratch_reg_startaddr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bios_scratch_reg_startaddr) - 24usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_vddc_mv) - 28usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_vddci_mv) - 30usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_mvddc_mv) - 32usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_vddgfx_mv) - 34usize];
    ["Offset of field: atom_firmware_info_v3_3::mem_module_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, mem_module_id) - 36usize];
    ["Offset of field: atom_firmware_info_v3_3::coolingsolution_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, coolingsolution_id) - 37usize];
    ["Offset of field: atom_firmware_info_v3_3::reserved1"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, reserved1) - 38usize];
    ["Offset of field: atom_firmware_info_v3_3::mc_baseaddr_high"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, mc_baseaddr_high) - 40usize];
    ["Offset of field: atom_firmware_info_v3_3::mc_baseaddr_low"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, mc_baseaddr_low) - 44usize];
    ["Offset of field: atom_firmware_info_v3_3::board_i2c_feature_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, board_i2c_feature_id) - 48usize];
    ["Offset of field: atom_firmware_info_v3_3::board_i2c_feature_gpio_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, board_i2c_feature_gpio_id) - 49usize];
    ["Offset of field: atom_firmware_info_v3_3::board_i2c_feature_slave_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, board_i2c_feature_slave_addr) - 50usize];
    ["Offset of field: atom_firmware_info_v3_3::reserved3"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, reserved3) - 51usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_mvddq_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_mvddq_mv) - 52usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_mvpp_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_mvpp_mv) - 54usize];
    ["Offset of field: atom_firmware_info_v3_3::zfbstartaddrin16mb"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, zfbstartaddrin16mb) - 56usize];
    ["Offset of field: atom_firmware_info_v3_3::pplib_pptable_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, pplib_pptable_id) - 60usize];
    ["Offset of field: atom_firmware_info_v3_3::reserved2"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, reserved2) - 64usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_4 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub ras_rom_i2c_slave_addr: u8,
    pub bootup_mvddq_mv: u16,
    pub bootup_mvpp_mv: u16,
    pub zfbstartaddrin16mb: u32,
    pub pplib_pptable_id: u32,
    pub mvdd_ratio: u32,
    pub hw_bootup_vddgfx_mv: u16,
    pub hw_bootup_vddc_mv: u16,
    pub hw_bootup_mvddc_mv: u16,
    pub hw_bootup_vddci_mv: u16,
    pub maco_pwrlimit_mw: u32,
    pub usb_pwrlimit_mw: u32,
    pub fw_reserved_size_in_kb: u32,
    pub pspbl_init_done_reg_addr: u32,
    pub pspbl_init_done_value: u32,
    pub pspbl_init_done_check_timeout: u32,
    pub reserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_firmware_info_v3_4"]
        [::core::mem::size_of::<atom_firmware_info_v3_4>() - 108usize];
    ["Alignment of atom_firmware_info_v3_4"]
        [::core::mem::align_of::<atom_firmware_info_v3_4>() - 1usize];
    ["Offset of field: atom_firmware_info_v3_4::table_header"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, table_header) - 0usize];
    ["Offset of field: atom_firmware_info_v3_4::firmware_revision"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, firmware_revision) - 4usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_sclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_sclk_in10khz) - 8usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_mclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_mclk_in10khz) - 12usize];
    ["Offset of field: atom_firmware_info_v3_4::firmware_capability"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, firmware_capability) - 16usize];
    ["Offset of field: atom_firmware_info_v3_4::main_call_parser_entry"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, main_call_parser_entry) - 20usize];
    ["Offset of field: atom_firmware_info_v3_4::bios_scratch_reg_startaddr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bios_scratch_reg_startaddr) - 24usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_vddc_mv) - 28usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_vddci_mv) - 30usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_mvddc_mv) - 32usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_vddgfx_mv) - 34usize];
    ["Offset of field: atom_firmware_info_v3_4::mem_module_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, mem_module_id) - 36usize];
    ["Offset of field: atom_firmware_info_v3_4::coolingsolution_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, coolingsolution_id) - 37usize];
    ["Offset of field: atom_firmware_info_v3_4::reserved1"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, reserved1) - 38usize];
    ["Offset of field: atom_firmware_info_v3_4::mc_baseaddr_high"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, mc_baseaddr_high) - 40usize];
    ["Offset of field: atom_firmware_info_v3_4::mc_baseaddr_low"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, mc_baseaddr_low) - 44usize];
    ["Offset of field: atom_firmware_info_v3_4::board_i2c_feature_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, board_i2c_feature_id) - 48usize];
    ["Offset of field: atom_firmware_info_v3_4::board_i2c_feature_gpio_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, board_i2c_feature_gpio_id) - 49usize];
    ["Offset of field: atom_firmware_info_v3_4::board_i2c_feature_slave_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, board_i2c_feature_slave_addr) - 50usize];
    ["Offset of field: atom_firmware_info_v3_4::ras_rom_i2c_slave_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, ras_rom_i2c_slave_addr) - 51usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_mvddq_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_mvddq_mv) - 52usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_mvpp_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_mvpp_mv) - 54usize];
    ["Offset of field: atom_firmware_info_v3_4::zfbstartaddrin16mb"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, zfbstartaddrin16mb) - 56usize];
    ["Offset of field: atom_firmware_info_v3_4::pplib_pptable_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, pplib_pptable_id) - 60usize];
    ["Offset of field: atom_firmware_info_v3_4::mvdd_ratio"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, mvdd_ratio) - 64usize];
    ["Offset of field: atom_firmware_info_v3_4::hw_bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, hw_bootup_vddgfx_mv) - 68usize];
    ["Offset of field: atom_firmware_info_v3_4::hw_bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, hw_bootup_vddc_mv) - 70usize];
    ["Offset of field: atom_firmware_info_v3_4::hw_bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, hw_bootup_mvddc_mv) - 72usize];
    ["Offset of field: atom_firmware_info_v3_4::hw_bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, hw_bootup_vddci_mv) - 74usize];
    ["Offset of field: atom_firmware_info_v3_4::maco_pwrlimit_mw"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, maco_pwrlimit_mw) - 76usize];
    ["Offset of field: atom_firmware_info_v3_4::usb_pwrlimit_mw"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, usb_pwrlimit_mw) - 80usize];
    ["Offset of field: atom_firmware_info_v3_4::fw_reserved_size_in_kb"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, fw_reserved_size_in_kb) - 84usize];
    ["Offset of field: atom_firmware_info_v3_4::pspbl_init_done_reg_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, pspbl_init_done_reg_addr) - 88usize];
    ["Offset of field: atom_firmware_info_v3_4::pspbl_init_done_value"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, pspbl_init_done_value) - 92usize];
    ["Offset of field: atom_firmware_info_v3_4::pspbl_init_done_check_timeout"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, pspbl_init_done_check_timeout) - 96usize];
    ["Offset of field: atom_firmware_info_v3_4::reserved"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, reserved) - 100usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct lcd_info_v2_1 {
    pub table_header: atom_common_table_header,
    pub lcd_timing: atom_dtd_format,
    pub backlight_pwm: u16,
    pub special_handle_cap: u16,
    pub panel_misc: u16,
    pub lvds_max_slink_pclk: u16,
    pub lvds_ss_percentage: u16,
    pub lvds_ss_rate_10hz: u16,
    pub pwr_on_digon_to_de: u8,
    pub pwr_on_de_to_vary_bl: u8,
    pub pwr_down_vary_bloff_to_de: u8,
    pub pwr_down_de_to_digoff: u8,
    pub pwr_off_delay: u8,
    pub pwr_on_vary_bl_to_blon: u8,
    pub pwr_down_bloff_to_vary_bloff: u8,
    pub panel_bpc: u8,
    pub dpcd_edp_config_cap: u8,
    pub dpcd_max_link_rate: u8,
    pub dpcd_max_lane_count: u8,
    pub dpcd_max_downspread: u8,
    pub min_allowed_bl_level: u8,
    pub max_allowed_bl_level: u8,
    pub bootup_bl_level: u8,
    pub dplvdsrxid: u8,
    pub reserved1: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of lcd_info_v2_1"][::core::mem::size_of::<lcd_info_v2_1>() - 92usize];
    ["Alignment of lcd_info_v2_1"][::core::mem::align_of::<lcd_info_v2_1>() - 1usize];
    ["Offset of field: lcd_info_v2_1::table_header"]
        [::core::mem::offset_of!(lcd_info_v2_1, table_header) - 0usize];
    ["Offset of field: lcd_info_v2_1::lcd_timing"]
        [::core::mem::offset_of!(lcd_info_v2_1, lcd_timing) - 4usize];
    ["Offset of field: lcd_info_v2_1::backlight_pwm"]
        [::core::mem::offset_of!(lcd_info_v2_1, backlight_pwm) - 32usize];
    ["Offset of field: lcd_info_v2_1::special_handle_cap"]
        [::core::mem::offset_of!(lcd_info_v2_1, special_handle_cap) - 34usize];
    ["Offset of field: lcd_info_v2_1::panel_misc"]
        [::core::mem::offset_of!(lcd_info_v2_1, panel_misc) - 36usize];
    ["Offset of field: lcd_info_v2_1::lvds_max_slink_pclk"]
        [::core::mem::offset_of!(lcd_info_v2_1, lvds_max_slink_pclk) - 38usize];
    ["Offset of field: lcd_info_v2_1::lvds_ss_percentage"]
        [::core::mem::offset_of!(lcd_info_v2_1, lvds_ss_percentage) - 40usize];
    ["Offset of field: lcd_info_v2_1::lvds_ss_rate_10hz"]
        [::core::mem::offset_of!(lcd_info_v2_1, lvds_ss_rate_10hz) - 42usize];
    ["Offset of field: lcd_info_v2_1::pwr_on_digon_to_de"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_on_digon_to_de) - 44usize];
    ["Offset of field: lcd_info_v2_1::pwr_on_de_to_vary_bl"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_on_de_to_vary_bl) - 45usize];
    ["Offset of field: lcd_info_v2_1::pwr_down_vary_bloff_to_de"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_down_vary_bloff_to_de) - 46usize];
    ["Offset of field: lcd_info_v2_1::pwr_down_de_to_digoff"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_down_de_to_digoff) - 47usize];
    ["Offset of field: lcd_info_v2_1::pwr_off_delay"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_off_delay) - 48usize];
    ["Offset of field: lcd_info_v2_1::pwr_on_vary_bl_to_blon"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_on_vary_bl_to_blon) - 49usize];
    ["Offset of field: lcd_info_v2_1::pwr_down_bloff_to_vary_bloff"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_down_bloff_to_vary_bloff) - 50usize];
    ["Offset of field: lcd_info_v2_1::panel_bpc"]
        [::core::mem::offset_of!(lcd_info_v2_1, panel_bpc) - 51usize];
    ["Offset of field: lcd_info_v2_1::dpcd_edp_config_cap"]
        [::core::mem::offset_of!(lcd_info_v2_1, dpcd_edp_config_cap) - 52usize];
    ["Offset of field: lcd_info_v2_1::dpcd_max_link_rate"]
        [::core::mem::offset_of!(lcd_info_v2_1, dpcd_max_link_rate) - 53usize];
    ["Offset of field: lcd_info_v2_1::dpcd_max_lane_count"]
        [::core::mem::offset_of!(lcd_info_v2_1, dpcd_max_lane_count) - 54usize];
    ["Offset of field: lcd_info_v2_1::dpcd_max_downspread"]
        [::core::mem::offset_of!(lcd_info_v2_1, dpcd_max_downspread) - 55usize];
    ["Offset of field: lcd_info_v2_1::min_allowed_bl_level"]
        [::core::mem::offset_of!(lcd_info_v2_1, min_allowed_bl_level) - 56usize];
    ["Offset of field: lcd_info_v2_1::max_allowed_bl_level"]
        [::core::mem::offset_of!(lcd_info_v2_1, max_allowed_bl_level) - 57usize];
    ["Offset of field: lcd_info_v2_1::bootup_bl_level"]
        [::core::mem::offset_of!(lcd_info_v2_1, bootup_bl_level) - 58usize];
    ["Offset of field: lcd_info_v2_1::dplvdsrxid"]
        [::core::mem::offset_of!(lcd_info_v2_1, dplvdsrxid) - 59usize];
    ["Offset of field: lcd_info_v2_1::reserved1"]
        [::core::mem::offset_of!(lcd_info_v2_1, reserved1) - 60usize];
};
pub const atom_lcd_info_panel_misc_ATOM_PANEL_MISC_FPDI: atom_lcd_info_panel_misc = 2;
pub type atom_lcd_info_panel_misc = ::core::ffi::c_uint;
pub const atom_lcd_info_dptolvds_rx_id_eDP_TO_LVDS_RX_DISABLE: atom_lcd_info_dptolvds_rx_id = 0;
pub const atom_lcd_info_dptolvds_rx_id_eDP_TO_LVDS_COMMON_ID: atom_lcd_info_dptolvds_rx_id = 1;
pub const atom_lcd_info_dptolvds_rx_id_eDP_TO_LVDS_REALTEK_ID: atom_lcd_info_dptolvds_rx_id = 2;
pub type atom_lcd_info_dptolvds_rx_id = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_pin_assignment {
    pub data_a_reg_index: u32,
    pub gpio_bitshift: u8,
    pub gpio_mask_bitshift: u8,
    pub gpio_id: u8,
    pub reserved: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gpio_pin_assignment"]
        [::core::mem::size_of::<atom_gpio_pin_assignment>() - 8usize];
    ["Alignment of atom_gpio_pin_assignment"]
        [::core::mem::align_of::<atom_gpio_pin_assignment>() - 1usize];
    ["Offset of field: atom_gpio_pin_assignment::data_a_reg_index"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, data_a_reg_index) - 0usize];
    ["Offset of field: atom_gpio_pin_assignment::gpio_bitshift"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, gpio_bitshift) - 4usize];
    ["Offset of field: atom_gpio_pin_assignment::gpio_mask_bitshift"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, gpio_mask_bitshift) - 5usize];
    ["Offset of field: atom_gpio_pin_assignment::gpio_id"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, gpio_id) - 6usize];
    ["Offset of field: atom_gpio_pin_assignment::reserved"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, reserved) - 7usize];
};
pub const atom_gpio_pin_assignment_gpio_id_I2C_HW_LANE_MUX: atom_gpio_pin_assignment_gpio_id = 15;
pub const atom_gpio_pin_assignment_gpio_id_I2C_HW_ENGINE_ID_MASK: atom_gpio_pin_assignment_gpio_id =
    112;
pub const atom_gpio_pin_assignment_gpio_id_I2C_HW_CAP: atom_gpio_pin_assignment_gpio_id = 128;
pub const atom_gpio_pin_assignment_gpio_id_PCIE_VDDC_CONTROL_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 56;
pub const atom_gpio_pin_assignment_gpio_id_PP_AC_DC_SWITCH_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 60;
pub const atom_gpio_pin_assignment_gpio_id_VDDC_VRHOT_GPIO_PINID: atom_gpio_pin_assignment_gpio_id =
    61;
pub const atom_gpio_pin_assignment_gpio_id_VDDC_PCC_GPIO_PINID: atom_gpio_pin_assignment_gpio_id =
    62;
pub const atom_gpio_pin_assignment_gpio_id_EFUSE_CUT_ENABLE_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 63;
pub const atom_gpio_pin_assignment_gpio_id_DRAM_SELF_REFRESH_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 64;
pub const atom_gpio_pin_assignment_gpio_id_THERMAL_INT_OUTPUT_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 65;
pub type atom_gpio_pin_assignment_gpio_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_pin_lut_v2_1 {
    pub table_header: atom_common_table_header,
    pub gpio_pin: [atom_gpio_pin_assignment; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gpio_pin_lut_v2_1"][::core::mem::size_of::<atom_gpio_pin_lut_v2_1>() - 68usize];
    ["Alignment of atom_gpio_pin_lut_v2_1"]
        [::core::mem::align_of::<atom_gpio_pin_lut_v2_1>() - 1usize];
    ["Offset of field: atom_gpio_pin_lut_v2_1::table_header"]
        [::core::mem::offset_of!(atom_gpio_pin_lut_v2_1, table_header) - 0usize];
    ["Offset of field: atom_gpio_pin_lut_v2_1::gpio_pin"]
        [::core::mem::offset_of!(atom_gpio_pin_lut_v2_1, gpio_pin) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct vram_usagebyfirmware_v2_1 {
    pub table_header: atom_common_table_header,
    pub start_address_in_kb: u32,
    pub used_by_firmware_in_kb: u16,
    pub used_by_driver_in_kb: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vram_usagebyfirmware_v2_1"]
        [::core::mem::size_of::<vram_usagebyfirmware_v2_1>() - 12usize];
    ["Alignment of vram_usagebyfirmware_v2_1"]
        [::core::mem::align_of::<vram_usagebyfirmware_v2_1>() - 1usize];
    ["Offset of field: vram_usagebyfirmware_v2_1::table_header"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_1, table_header) - 0usize];
    ["Offset of field: vram_usagebyfirmware_v2_1::start_address_in_kb"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_1, start_address_in_kb) - 4usize];
    ["Offset of field: vram_usagebyfirmware_v2_1::used_by_firmware_in_kb"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_1, used_by_firmware_in_kb) - 8usize];
    ["Offset of field: vram_usagebyfirmware_v2_1::used_by_driver_in_kb"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_1, used_by_driver_in_kb) - 10usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct vram_usagebyfirmware_v2_2 {
    pub table_header: atom_common_table_header,
    pub fw_region_start_address_in_kb: u32,
    pub used_by_firmware_in_kb: u16,
    pub reserved: u16,
    pub driver_region0_start_address_in_kb: u32,
    pub used_by_driver_region0_in_kb: u32,
    pub reserved32: [u32; 7usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vram_usagebyfirmware_v2_2"]
        [::core::mem::size_of::<vram_usagebyfirmware_v2_2>() - 48usize];
    ["Alignment of vram_usagebyfirmware_v2_2"]
        [::core::mem::align_of::<vram_usagebyfirmware_v2_2>() - 1usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::table_header"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_2, table_header) - 0usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::fw_region_start_address_in_kb"][::core::mem::offset_of!(
        vram_usagebyfirmware_v2_2,
        fw_region_start_address_in_kb
    ) - 4usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::used_by_firmware_in_kb"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_2, used_by_firmware_in_kb) - 8usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::reserved"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_2, reserved) - 10usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::driver_region0_start_address_in_kb"][::core::mem::offset_of!(
        vram_usagebyfirmware_v2_2,
        driver_region0_start_address_in_kb
    ) - 12usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::used_by_driver_region0_in_kb"][::core::mem::offset_of!(
        vram_usagebyfirmware_v2_2,
        used_by_driver_region0_in_kb
    ) - 16usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::reserved32"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_2, reserved32) - 20usize];
};
pub const atom_object_record_type_id_ATOM_I2C_RECORD_TYPE: atom_object_record_type_id = 1;
pub const atom_object_record_type_id_ATOM_HPD_INT_RECORD_TYPE: atom_object_record_type_id = 2;
pub const atom_object_record_type_id_ATOM_CONNECTOR_CAP_RECORD_TYPE: atom_object_record_type_id = 3;
pub const atom_object_record_type_id_ATOM_CONNECTOR_SPEED_UPTO: atom_object_record_type_id = 4;
pub const atom_object_record_type_id_ATOM_OBJECT_GPIO_CNTL_RECORD_TYPE: atom_object_record_type_id =
    9;
pub const atom_object_record_type_id_ATOM_CONNECTOR_HPDPIN_LUT_RECORD_TYPE:
    atom_object_record_type_id = 16;
pub const atom_object_record_type_id_ATOM_CONNECTOR_AUXDDC_LUT_RECORD_TYPE:
    atom_object_record_type_id = 17;
pub const atom_object_record_type_id_ATOM_ENCODER_CAP_RECORD_TYPE: atom_object_record_type_id = 20;
pub const atom_object_record_type_id_ATOM_BRACKET_LAYOUT_RECORD_TYPE: atom_object_record_type_id =
    21;
pub const atom_object_record_type_id_ATOM_CONNECTOR_FORCED_TMDS_CAP_RECORD_TYPE:
    atom_object_record_type_id = 22;
pub const atom_object_record_type_id_ATOM_DISP_CONNECTOR_CAPS_RECORD_TYPE:
    atom_object_record_type_id = 23;
pub const atom_object_record_type_id_ATOM_BRACKET_LAYOUT_V2_RECORD_TYPE:
    atom_object_record_type_id = 25;
pub const atom_object_record_type_id_ATOM_RECORD_END_TYPE: atom_object_record_type_id = 255;
pub type atom_object_record_type_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_common_record_header {
    pub record_type: u8,
    pub record_size: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_common_record_header"]
        [::core::mem::size_of::<atom_common_record_header>() - 2usize];
    ["Alignment of atom_common_record_header"]
        [::core::mem::align_of::<atom_common_record_header>() - 1usize];
    ["Offset of field: atom_common_record_header::record_type"]
        [::core::mem::offset_of!(atom_common_record_header, record_type) - 0usize];
    ["Offset of field: atom_common_record_header::record_size"]
        [::core::mem::offset_of!(atom_common_record_header, record_size) - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_record {
    pub record_header: atom_common_record_header,
    pub i2c_id: u8,
    pub i2c_slave_addr: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_i2c_record"][::core::mem::size_of::<atom_i2c_record>() - 4usize];
    ["Alignment of atom_i2c_record"][::core::mem::align_of::<atom_i2c_record>() - 1usize];
    ["Offset of field: atom_i2c_record::record_header"]
        [::core::mem::offset_of!(atom_i2c_record, record_header) - 0usize];
    ["Offset of field: atom_i2c_record::i2c_id"]
        [::core::mem::offset_of!(atom_i2c_record, i2c_id) - 2usize];
    ["Offset of field: atom_i2c_record::i2c_slave_addr"]
        [::core::mem::offset_of!(atom_i2c_record, i2c_slave_addr) - 3usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_hpd_int_record {
    pub record_header: atom_common_record_header,
    pub pin_id: u8,
    pub plugin_pin_state: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_hpd_int_record"][::core::mem::size_of::<atom_hpd_int_record>() - 4usize];
    ["Alignment of atom_hpd_int_record"][::core::mem::align_of::<atom_hpd_int_record>() - 1usize];
    ["Offset of field: atom_hpd_int_record::record_header"]
        [::core::mem::offset_of!(atom_hpd_int_record, record_header) - 0usize];
    ["Offset of field: atom_hpd_int_record::pin_id"]
        [::core::mem::offset_of!(atom_hpd_int_record, pin_id) - 2usize];
    ["Offset of field: atom_hpd_int_record::plugin_pin_state"]
        [::core::mem::offset_of!(atom_hpd_int_record, plugin_pin_state) - 3usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_caps_record {
    pub record_header: atom_common_record_header,
    pub connector_caps: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_caps_record"]
        [::core::mem::size_of::<atom_connector_caps_record>() - 4usize];
    ["Alignment of atom_connector_caps_record"]
        [::core::mem::align_of::<atom_connector_caps_record>() - 1usize];
    ["Offset of field: atom_connector_caps_record::record_header"]
        [::core::mem::offset_of!(atom_connector_caps_record, record_header) - 0usize];
    ["Offset of field: atom_connector_caps_record::connector_caps"]
        [::core::mem::offset_of!(atom_connector_caps_record, connector_caps) - 2usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_speed_record {
    pub record_header: atom_common_record_header,
    pub connector_max_speed: u32,
    pub reserved: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_speed_record"]
        [::core::mem::size_of::<atom_connector_speed_record>() - 8usize];
    ["Alignment of atom_connector_speed_record"]
        [::core::mem::align_of::<atom_connector_speed_record>() - 1usize];
    ["Offset of field: atom_connector_speed_record::record_header"]
        [::core::mem::offset_of!(atom_connector_speed_record, record_header) - 0usize];
    ["Offset of field: atom_connector_speed_record::connector_max_speed"]
        [::core::mem::offset_of!(atom_connector_speed_record, connector_max_speed) - 2usize];
    ["Offset of field: atom_connector_speed_record::reserved"]
        [::core::mem::offset_of!(atom_connector_speed_record, reserved) - 6usize];
};
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HBR2: atom_encoder_caps_def = 1;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_MST_EN: atom_encoder_caps_def = 1;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HBR2_EN: atom_encoder_caps_def = 2;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HDMI6Gbps_EN: atom_encoder_caps_def = 4;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HBR3_EN: atom_encoder_caps_def = 8;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_DP2: atom_encoder_caps_def = 16;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_UHBR10_EN: atom_encoder_caps_def = 32;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_UHBR13_5_EN: atom_encoder_caps_def = 64;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_UHBR20_EN: atom_encoder_caps_def = 128;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_USB_C_TYPE: atom_encoder_caps_def = 256;
pub type atom_encoder_caps_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_encoder_caps_record {
    pub record_header: atom_common_record_header,
    pub encodercaps: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_encoder_caps_record"]
        [::core::mem::size_of::<atom_encoder_caps_record>() - 6usize];
    ["Alignment of atom_encoder_caps_record"]
        [::core::mem::align_of::<atom_encoder_caps_record>() - 1usize];
    ["Offset of field: atom_encoder_caps_record::record_header"]
        [::core::mem::offset_of!(atom_encoder_caps_record, record_header) - 0usize];
    ["Offset of field: atom_encoder_caps_record::encodercaps"]
        [::core::mem::offset_of!(atom_encoder_caps_record, encodercaps) - 2usize];
};
pub const atom_connector_caps_def_ATOM_CONNECTOR_CAP_INTERNAL_DISPLAY: atom_connector_caps_def = 1;
pub const atom_connector_caps_def_ATOM_CONNECTOR_CAP_INTERNAL_DISPLAY_BL: atom_connector_caps_def =
    2;
pub type atom_connector_caps_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_disp_connector_caps_record {
    pub record_header: atom_common_record_header,
    pub connectcaps: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_disp_connector_caps_record"]
        [::core::mem::size_of::<atom_disp_connector_caps_record>() - 6usize];
    ["Alignment of atom_disp_connector_caps_record"]
        [::core::mem::align_of::<atom_disp_connector_caps_record>() - 1usize];
    ["Offset of field: atom_disp_connector_caps_record::record_header"]
        [::core::mem::offset_of!(atom_disp_connector_caps_record, record_header) - 0usize];
    ["Offset of field: atom_disp_connector_caps_record::connectcaps"]
        [::core::mem::offset_of!(atom_disp_connector_caps_record, connectcaps) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_pin_control_pair {
    pub gpio_id: u8,
    pub gpio_pinstate: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gpio_pin_control_pair"]
        [::core::mem::size_of::<atom_gpio_pin_control_pair>() - 2usize];
    ["Alignment of atom_gpio_pin_control_pair"]
        [::core::mem::align_of::<atom_gpio_pin_control_pair>() - 1usize];
    ["Offset of field: atom_gpio_pin_control_pair::gpio_id"]
        [::core::mem::offset_of!(atom_gpio_pin_control_pair, gpio_id) - 0usize];
    ["Offset of field: atom_gpio_pin_control_pair::gpio_pinstate"]
        [::core::mem::offset_of!(atom_gpio_pin_control_pair, gpio_pinstate) - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_object_gpio_cntl_record {
    pub record_header: atom_common_record_header,
    pub flag: u8,
    pub number_of_pins: u8,
    pub gpio: [atom_gpio_pin_control_pair; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_object_gpio_cntl_record"]
        [::core::mem::size_of::<atom_object_gpio_cntl_record>() - 6usize];
    ["Alignment of atom_object_gpio_cntl_record"]
        [::core::mem::align_of::<atom_object_gpio_cntl_record>() - 1usize];
    ["Offset of field: atom_object_gpio_cntl_record::record_header"]
        [::core::mem::offset_of!(atom_object_gpio_cntl_record, record_header) - 0usize];
    ["Offset of field: atom_object_gpio_cntl_record::flag"]
        [::core::mem::offset_of!(atom_object_gpio_cntl_record, flag) - 2usize];
    ["Offset of field: atom_object_gpio_cntl_record::number_of_pins"]
        [::core::mem::offset_of!(atom_object_gpio_cntl_record, number_of_pins) - 3usize];
    ["Offset of field: atom_object_gpio_cntl_record::gpio"]
        [::core::mem::offset_of!(atom_object_gpio_cntl_record, gpio) - 4usize];
};
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_TYPE_INPUT:
    atom_gpio_pin_control_pinstate_def = 0;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_TYPE_OUTPUT:
    atom_gpio_pin_control_pinstate_def = 16;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_TYPE_HW_CONTROL:
    atom_gpio_pin_control_pinstate_def = 32;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_OUTPUT_STATE_MASK:
    atom_gpio_pin_control_pinstate_def = 1;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_OUTPUT_STATE_SHIFT:
    atom_gpio_pin_control_pinstate_def = 0;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_STATE_ACTIVE_LOW:
    atom_gpio_pin_control_pinstate_def = 0;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_STATE_ACTIVE_HIGH:
    atom_gpio_pin_control_pinstate_def = 1;
pub type atom_gpio_pin_control_pinstate_def = ::core::ffi::c_uint;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_REFCLK:
    atom_glsync_record_gpio_index_def = 0;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_HSYNC:
    atom_glsync_record_gpio_index_def = 1;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_VSYNC:
    atom_glsync_record_gpio_index_def = 2;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_REQ:
    atom_glsync_record_gpio_index_def = 3;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_GNT:
    atom_glsync_record_gpio_index_def = 4;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_INTERRUPT:
    atom_glsync_record_gpio_index_def = 5;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_V_RESET:
    atom_glsync_record_gpio_index_def = 6;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_CNTL:
    atom_glsync_record_gpio_index_def = 7;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_SEL:
    atom_glsync_record_gpio_index_def = 8;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_MAX:
    atom_glsync_record_gpio_index_def = 9;
pub type atom_glsync_record_gpio_index_def = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_hpdpin_lut_record {
    pub record_header: atom_common_record_header,
    pub hpd_pin_map: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_hpdpin_lut_record"]
        [::core::mem::size_of::<atom_connector_hpdpin_lut_record>() - 10usize];
    ["Alignment of atom_connector_hpdpin_lut_record"]
        [::core::mem::align_of::<atom_connector_hpdpin_lut_record>() - 1usize];
    ["Offset of field: atom_connector_hpdpin_lut_record::record_header"]
        [::core::mem::offset_of!(atom_connector_hpdpin_lut_record, record_header) - 0usize];
    ["Offset of field: atom_connector_hpdpin_lut_record::hpd_pin_map"]
        [::core::mem::offset_of!(atom_connector_hpdpin_lut_record, hpd_pin_map) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_auxddc_lut_record {
    pub record_header: atom_common_record_header,
    pub aux_ddc_map: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_auxddc_lut_record"]
        [::core::mem::size_of::<atom_connector_auxddc_lut_record>() - 10usize];
    ["Alignment of atom_connector_auxddc_lut_record"]
        [::core::mem::align_of::<atom_connector_auxddc_lut_record>() - 1usize];
    ["Offset of field: atom_connector_auxddc_lut_record::record_header"]
        [::core::mem::offset_of!(atom_connector_auxddc_lut_record, record_header) - 0usize];
    ["Offset of field: atom_connector_auxddc_lut_record::aux_ddc_map"]
        [::core::mem::offset_of!(atom_connector_auxddc_lut_record, aux_ddc_map) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_forced_tmds_cap_record {
    pub record_header: atom_common_record_header,
    pub maxtmdsclkrate_in2_5mhz: u8,
    pub reserved: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_forced_tmds_cap_record"]
        [::core::mem::size_of::<atom_connector_forced_tmds_cap_record>() - 4usize];
    ["Alignment of atom_connector_forced_tmds_cap_record"]
        [::core::mem::align_of::<atom_connector_forced_tmds_cap_record>() - 1usize];
    ["Offset of field: atom_connector_forced_tmds_cap_record::record_header"]
        [::core::mem::offset_of!(atom_connector_forced_tmds_cap_record, record_header) - 0usize];
    ["Offset of field: atom_connector_forced_tmds_cap_record::maxtmdsclkrate_in2_5mhz"][::core::mem::offset_of!(
        atom_connector_forced_tmds_cap_record,
        maxtmdsclkrate_in2_5mhz
    ) - 2usize];
    ["Offset of field: atom_connector_forced_tmds_cap_record::reserved"]
        [::core::mem::offset_of!(atom_connector_forced_tmds_cap_record, reserved) - 3usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_layout_info {
    pub connectorobjid: u16,
    pub connector_type: u8,
    pub position: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_layout_info"]
        [::core::mem::size_of::<atom_connector_layout_info>() - 4usize];
    ["Alignment of atom_connector_layout_info"]
        [::core::mem::align_of::<atom_connector_layout_info>() - 1usize];
    ["Offset of field: atom_connector_layout_info::connectorobjid"]
        [::core::mem::offset_of!(atom_connector_layout_info, connectorobjid) - 0usize];
    ["Offset of field: atom_connector_layout_info::connector_type"]
        [::core::mem::offset_of!(atom_connector_layout_info, connector_type) - 2usize];
    ["Offset of field: atom_connector_layout_info::position"]
        [::core::mem::offset_of!(atom_connector_layout_info, position) - 3usize];
};
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_DVI_D:
    atom_connector_layout_info_connector_type_def = 1;
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_HDMI:
    atom_connector_layout_info_connector_type_def = 4;
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_DISPLAY_PORT:
    atom_connector_layout_info_connector_type_def = 5;
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_MINI_DISPLAY_PORT:
    atom_connector_layout_info_connector_type_def = 6;
pub type atom_connector_layout_info_connector_type_def = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_bracket_layout_record {
    pub record_header: atom_common_record_header,
    pub bracketlen: u8,
    pub bracketwidth: u8,
    pub conn_num: u8,
    pub reserved: u8,
    pub conn_info: [atom_connector_layout_info; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_bracket_layout_record"]
        [::core::mem::size_of::<atom_bracket_layout_record>() - 10usize];
    ["Alignment of atom_bracket_layout_record"]
        [::core::mem::align_of::<atom_bracket_layout_record>() - 1usize];
    ["Offset of field: atom_bracket_layout_record::record_header"]
        [::core::mem::offset_of!(atom_bracket_layout_record, record_header) - 0usize];
    ["Offset of field: atom_bracket_layout_record::bracketlen"]
        [::core::mem::offset_of!(atom_bracket_layout_record, bracketlen) - 2usize];
    ["Offset of field: atom_bracket_layout_record::bracketwidth"]
        [::core::mem::offset_of!(atom_bracket_layout_record, bracketwidth) - 3usize];
    ["Offset of field: atom_bracket_layout_record::conn_num"]
        [::core::mem::offset_of!(atom_bracket_layout_record, conn_num) - 4usize];
    ["Offset of field: atom_bracket_layout_record::reserved"]
        [::core::mem::offset_of!(atom_bracket_layout_record, reserved) - 5usize];
    ["Offset of field: atom_bracket_layout_record::conn_info"]
        [::core::mem::offset_of!(atom_bracket_layout_record, conn_info) - 6usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_bracket_layout_record_v2 {
    pub record_header: atom_common_record_header,
    pub bracketlen: u8,
    pub bracketwidth: u8,
    pub conn_num: u8,
    pub mini_type: u8,
    pub reserved1: u8,
    pub reserved2: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_bracket_layout_record_v2"]
        [::core::mem::size_of::<atom_bracket_layout_record_v2>() - 8usize];
    ["Alignment of atom_bracket_layout_record_v2"]
        [::core::mem::align_of::<atom_bracket_layout_record_v2>() - 1usize];
    ["Offset of field: atom_bracket_layout_record_v2::record_header"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, record_header) - 0usize];
    ["Offset of field: atom_bracket_layout_record_v2::bracketlen"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, bracketlen) - 2usize];
    ["Offset of field: atom_bracket_layout_record_v2::bracketwidth"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, bracketwidth) - 3usize];
    ["Offset of field: atom_bracket_layout_record_v2::conn_num"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, conn_num) - 4usize];
    ["Offset of field: atom_bracket_layout_record_v2::mini_type"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, mini_type) - 5usize];
    ["Offset of field: atom_bracket_layout_record_v2::reserved1"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, reserved1) - 6usize];
    ["Offset of field: atom_bracket_layout_record_v2::reserved2"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, reserved2) - 7usize];
};
pub const atom_connector_layout_info_mini_type_def_MINI_TYPE_NORMAL:
    atom_connector_layout_info_mini_type_def = 0;
pub const atom_connector_layout_info_mini_type_def_MINI_TYPE_MINI:
    atom_connector_layout_info_mini_type_def = 1;
pub type atom_connector_layout_info_mini_type_def = ::core::ffi::c_uint;
pub const atom_display_device_tag_def_ATOM_DISPLAY_LCD1_SUPPORT: atom_display_device_tag_def = 2;
pub const atom_display_device_tag_def_ATOM_DISPLAY_LCD2_SUPPORT: atom_display_device_tag_def = 32;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP1_SUPPORT: atom_display_device_tag_def = 8;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP2_SUPPORT: atom_display_device_tag_def = 128;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP3_SUPPORT: atom_display_device_tag_def = 512;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP4_SUPPORT: atom_display_device_tag_def = 1024;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP5_SUPPORT: atom_display_device_tag_def = 2048;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP6_SUPPORT: atom_display_device_tag_def = 64;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFPx_SUPPORT: atom_display_device_tag_def = 3784;
pub type atom_display_device_tag_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_object_path_v2 {
    pub display_objid: u16,
    pub disp_recordoffset: u16,
    pub encoderobjid: u16,
    pub extencoderobjid: u16,
    pub encoder_recordoffset: u16,
    pub extencoder_recordoffset: u16,
    pub device_tag: u16,
    pub priority_id: u8,
    pub reserved: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_object_path_v2"]
        [::core::mem::size_of::<atom_display_object_path_v2>() - 16usize];
    ["Alignment of atom_display_object_path_v2"]
        [::core::mem::align_of::<atom_display_object_path_v2>() - 1usize];
    ["Offset of field: atom_display_object_path_v2::display_objid"]
        [::core::mem::offset_of!(atom_display_object_path_v2, display_objid) - 0usize];
    ["Offset of field: atom_display_object_path_v2::disp_recordoffset"]
        [::core::mem::offset_of!(atom_display_object_path_v2, disp_recordoffset) - 2usize];
    ["Offset of field: atom_display_object_path_v2::encoderobjid"]
        [::core::mem::offset_of!(atom_display_object_path_v2, encoderobjid) - 4usize];
    ["Offset of field: atom_display_object_path_v2::extencoderobjid"]
        [::core::mem::offset_of!(atom_display_object_path_v2, extencoderobjid) - 6usize];
    ["Offset of field: atom_display_object_path_v2::encoder_recordoffset"]
        [::core::mem::offset_of!(atom_display_object_path_v2, encoder_recordoffset) - 8usize];
    ["Offset of field: atom_display_object_path_v2::extencoder_recordoffset"]
        [::core::mem::offset_of!(atom_display_object_path_v2, extencoder_recordoffset) - 10usize];
    ["Offset of field: atom_display_object_path_v2::device_tag"]
        [::core::mem::offset_of!(atom_display_object_path_v2, device_tag) - 12usize];
    ["Offset of field: atom_display_object_path_v2::priority_id"]
        [::core::mem::offset_of!(atom_display_object_path_v2, priority_id) - 14usize];
    ["Offset of field: atom_display_object_path_v2::reserved"]
        [::core::mem::offset_of!(atom_display_object_path_v2, reserved) - 15usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_object_path_v3 {
    pub display_objid: u16,
    pub disp_recordoffset: u16,
    pub encoderobjid: u16,
    pub reserved1: u16,
    pub reserved2: u16,
    pub reserved3: u16,
    pub device_tag: u16,
    pub reserved4: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_object_path_v3"]
        [::core::mem::size_of::<atom_display_object_path_v3>() - 16usize];
    ["Alignment of atom_display_object_path_v3"]
        [::core::mem::align_of::<atom_display_object_path_v3>() - 1usize];
    ["Offset of field: atom_display_object_path_v3::display_objid"]
        [::core::mem::offset_of!(atom_display_object_path_v3, display_objid) - 0usize];
    ["Offset of field: atom_display_object_path_v3::disp_recordoffset"]
        [::core::mem::offset_of!(atom_display_object_path_v3, disp_recordoffset) - 2usize];
    ["Offset of field: atom_display_object_path_v3::encoderobjid"]
        [::core::mem::offset_of!(atom_display_object_path_v3, encoderobjid) - 4usize];
    ["Offset of field: atom_display_object_path_v3::reserved1"]
        [::core::mem::offset_of!(atom_display_object_path_v3, reserved1) - 6usize];
    ["Offset of field: atom_display_object_path_v3::reserved2"]
        [::core::mem::offset_of!(atom_display_object_path_v3, reserved2) - 8usize];
    ["Offset of field: atom_display_object_path_v3::reserved3"]
        [::core::mem::offset_of!(atom_display_object_path_v3, reserved3) - 10usize];
    ["Offset of field: atom_display_object_path_v3::device_tag"]
        [::core::mem::offset_of!(atom_display_object_path_v3, device_tag) - 12usize];
    ["Offset of field: atom_display_object_path_v3::reserved4"]
        [::core::mem::offset_of!(atom_display_object_path_v3, reserved4) - 14usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct display_object_info_table_v1_4 {
    pub table_header: atom_common_table_header,
    pub supporteddevices: u16,
    pub number_of_path: u8,
    pub reserved: u8,
    pub display_path: [atom_display_object_path_v2; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of display_object_info_table_v1_4"]
        [::core::mem::size_of::<display_object_info_table_v1_4>() - 136usize];
    ["Alignment of display_object_info_table_v1_4"]
        [::core::mem::align_of::<display_object_info_table_v1_4>() - 1usize];
    ["Offset of field: display_object_info_table_v1_4::table_header"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, table_header) - 0usize];
    ["Offset of field: display_object_info_table_v1_4::supporteddevices"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, supporteddevices) - 4usize];
    ["Offset of field: display_object_info_table_v1_4::number_of_path"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, number_of_path) - 6usize];
    ["Offset of field: display_object_info_table_v1_4::reserved"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, reserved) - 7usize];
    ["Offset of field: display_object_info_table_v1_4::display_path"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, display_path) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct display_object_info_table_v1_5 {
    pub table_header: atom_common_table_header,
    pub supporteddevices: u16,
    pub number_of_path: u8,
    pub reserved: u8,
    pub display_path: [atom_display_object_path_v3; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of display_object_info_table_v1_5"]
        [::core::mem::size_of::<display_object_info_table_v1_5>() - 136usize];
    ["Alignment of display_object_info_table_v1_5"]
        [::core::mem::align_of::<display_object_info_table_v1_5>() - 1usize];
    ["Offset of field: display_object_info_table_v1_5::table_header"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, table_header) - 0usize];
    ["Offset of field: display_object_info_table_v1_5::supporteddevices"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, supporteddevices) - 4usize];
    ["Offset of field: display_object_info_table_v1_5::number_of_path"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, number_of_path) - 6usize];
    ["Offset of field: display_object_info_table_v1_5::reserved"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, reserved) - 7usize];
    ["Offset of field: display_object_info_table_v1_5::display_path"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, display_path) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub hardcode_mode_num: u8,
    pub reserved1: [u8; 3usize],
    pub dpphy_refclk_10khz: u16,
    pub reserved2: u16,
    pub dceip_min_ver: u8,
    pub dceip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub reserved3: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_1"]
        [::core::mem::size_of::<atom_display_controller_info_v4_1>() - 56usize];
    ["Alignment of atom_display_controller_info_v4_1"]
        [::core::mem::align_of::<atom_display_controller_info_v4_1>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_1::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_1::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_1::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_1::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_1::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_1,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_1::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_1::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_1::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_1::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_1::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_1::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_1::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_1::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_1::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_1::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_1::hardcode_mode_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, hardcode_mode_num) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_1::reserved1"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, reserved1) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_1::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_1::reserved2"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, reserved2) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_1::dceip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dceip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_1::dceip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dceip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_vbios_active_disp_pipe_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_1,
        max_vbios_active_disp_pipe_num
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_1::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_1::reserved3"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, reserved3) - 48usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_2 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub reserved2: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub reserved3: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_2"]
        [::core::mem::size_of::<atom_display_controller_info_v4_2>() - 56usize];
    ["Alignment of atom_display_controller_info_v4_2"]
        [::core::mem::align_of::<atom_display_controller_info_v4_2>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_2::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_2::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_2::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_2::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_2::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_2::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_2::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_2::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_2::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_2::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_2::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_2::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_2::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_2::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_2::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_2::dfp_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        dfp_hardcode_mode_num
    ) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_2::dfp_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        dfp_hardcode_refreshrate
    ) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_2::vga_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        vga_hardcode_mode_num
    ) - 34usize];
    ["Offset of field: atom_display_controller_info_v4_2::vga_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        vga_hardcode_refreshrate
    ) - 35usize];
    ["Offset of field: atom_display_controller_info_v4_2::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_2::reserved2"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, reserved2) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_2::dcnip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dcnip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_2::dcnip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dcnip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_vbios_active_disp_pipe_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        max_vbios_active_disp_pipe_num
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_2::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_2::reserved3"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, reserved3) - 48usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_3 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub reserved2: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub reserved3: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_3"]
        [::core::mem::size_of::<atom_display_controller_info_v4_3>() - 56usize];
    ["Alignment of atom_display_controller_info_v4_3"]
        [::core::mem::align_of::<atom_display_controller_info_v4_3>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_3::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_3::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_3::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_3::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_3::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_3::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_3::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_3::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_3::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_3::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_3::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_3::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_3::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_3::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_3::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_3::dfp_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        dfp_hardcode_mode_num
    ) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_3::dfp_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        dfp_hardcode_refreshrate
    ) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_3::vga_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        vga_hardcode_mode_num
    ) - 34usize];
    ["Offset of field: atom_display_controller_info_v4_3::vga_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        vga_hardcode_refreshrate
    ) - 35usize];
    ["Offset of field: atom_display_controller_info_v4_3::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_3::reserved2"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, reserved2) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_3::dcnip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dcnip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_3::dcnip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dcnip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_vbios_active_disp_pipe_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        max_vbios_active_disp_pipe_num
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_3::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_3::reserved3"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, reserved3) - 48usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_4 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub hw_chip_id: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipum: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub dispclk_pll_vco_freq: u32,
    pub dp_ref_clk_freq: u32,
    pub max_mclk_chg_lat: u32,
    pub max_sr_exit_lat: u32,
    pub max_sr_enter_exit_lat: u32,
    pub dc_golden_table_offset: u16,
    pub dc_golden_table_ver: u16,
    pub reserved3: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_4"]
        [::core::mem::size_of::<atom_display_controller_info_v4_4>() - 84usize];
    ["Alignment of atom_display_controller_info_v4_4"]
        [::core::mem::align_of::<atom_display_controller_info_v4_4>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_4::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_4::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_4::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_4::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_4::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_4::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_4::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_4::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_4::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_4::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_4::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_4::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_4::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_4::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_4::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_4::dfp_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        dfp_hardcode_mode_num
    ) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_4::dfp_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        dfp_hardcode_refreshrate
    ) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_4::vga_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        vga_hardcode_mode_num
    ) - 34usize];
    ["Offset of field: atom_display_controller_info_v4_4::vga_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        vga_hardcode_refreshrate
    ) - 35usize];
    ["Offset of field: atom_display_controller_info_v4_4::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_4::hw_chip_id"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, hw_chip_id) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_4::dcnip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dcnip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_4::dcnip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dcnip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_vbios_active_disp_pipum"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        max_vbios_active_disp_pipum
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_4::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_4::dispclk_pll_vco_freq"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        dispclk_pll_vco_freq
    ) - 48usize];
    ["Offset of field: atom_display_controller_info_v4_4::dp_ref_clk_freq"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dp_ref_clk_freq) - 52usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_mclk_chg_lat"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_mclk_chg_lat) - 56usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_sr_exit_lat"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_sr_exit_lat) - 60usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_sr_enter_exit_lat"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        max_sr_enter_exit_lat
    ) - 64usize];
    ["Offset of field: atom_display_controller_info_v4_4::dc_golden_table_offset"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        dc_golden_table_offset
    ) - 68usize];
    ["Offset of field: atom_display_controller_info_v4_4::dc_golden_table_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dc_golden_table_ver) - 70usize];
    ["Offset of field: atom_display_controller_info_v4_4::reserved3"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, reserved3) - 72usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_dc_golden_table_v1 {
    pub aux_dphy_rx_control0_val: u32,
    pub aux_dphy_tx_control_val: u32,
    pub aux_dphy_rx_control1_val: u32,
    pub dc_gpio_aux_ctrl_0_val: u32,
    pub dc_gpio_aux_ctrl_1_val: u32,
    pub dc_gpio_aux_ctrl_2_val: u32,
    pub dc_gpio_aux_ctrl_3_val: u32,
    pub dc_gpio_aux_ctrl_4_val: u32,
    pub dc_gpio_aux_ctrl_5_val: u32,
    pub reserved: [u32; 23usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_dc_golden_table_v1"]
        [::core::mem::size_of::<atom_dc_golden_table_v1>() - 128usize];
    ["Alignment of atom_dc_golden_table_v1"]
        [::core::mem::align_of::<atom_dc_golden_table_v1>() - 1usize];
    ["Offset of field: atom_dc_golden_table_v1::aux_dphy_rx_control0_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, aux_dphy_rx_control0_val) - 0usize];
    ["Offset of field: atom_dc_golden_table_v1::aux_dphy_tx_control_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, aux_dphy_tx_control_val) - 4usize];
    ["Offset of field: atom_dc_golden_table_v1::aux_dphy_rx_control1_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, aux_dphy_rx_control1_val) - 8usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_0_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_0_val) - 12usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_1_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_1_val) - 16usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_2_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_2_val) - 20usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_3_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_3_val) - 24usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_4_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_4_val) - 28usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_5_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_5_val) - 32usize];
    ["Offset of field: atom_dc_golden_table_v1::reserved"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, reserved) - 36usize];
};
pub const dce_info_caps_def_DCE_INFO_CAPS_FORCE_DISPDEV_CONNECTED: dce_info_caps_def = 2;
pub const dce_info_caps_def_DCE_INFO_CAPS_DISABLE_DFP_DP_HBR2: dce_info_caps_def = 4;
pub const dce_info_caps_def_DCE_INFO_CAPS_ENABLE_INTERLAC_TIMING: dce_info_caps_def = 8;
pub const dce_info_caps_def_DCE_INFO_CAPS_LTTPR_SUPPORT_ENABLE: dce_info_caps_def = 32;
pub const dce_info_caps_def_DCE_INFO_CAPS_VBIOS_LTTPR_TRANSPARENT_ENABLE: dce_info_caps_def = 64;
pub type dce_info_caps_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_5 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub hw_chip_id: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub dispclk_pll_vco_freq: u32,
    pub dp_ref_clk_freq: u32,
    pub max_mclk_chg_lat: u32,
    pub max_sr_exit_lat: u32,
    pub max_sr_enter_exit_lat: u32,
    pub dc_golden_table_offset: u16,
    pub dc_golden_table_ver: u16,
    pub aux_dphy_rx_control0_val: u32,
    pub aux_dphy_tx_control_val: u32,
    pub aux_dphy_rx_control1_val: u32,
    pub dc_gpio_aux_ctrl_0_val: u32,
    pub dc_gpio_aux_ctrl_1_val: u32,
    pub dc_gpio_aux_ctrl_2_val: u32,
    pub dc_gpio_aux_ctrl_3_val: u32,
    pub dc_gpio_aux_ctrl_4_val: u32,
    pub dc_gpio_aux_ctrl_5_val: u32,
    pub reserved: [u32; 26usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_5"]
        [::core::mem::size_of::<atom_display_controller_info_v4_5>() - 212usize];
    ["Alignment of atom_display_controller_info_v4_5"]
        [::core::mem::align_of::<atom_display_controller_info_v4_5>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_5::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_5::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_5::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_5::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_5::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_5::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_5::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_5::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_5::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_5::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_5::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_5::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_5::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_5::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_5::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_5::dfp_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dfp_hardcode_mode_num
    ) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_5::dfp_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dfp_hardcode_refreshrate
    ) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_5::vga_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        vga_hardcode_mode_num
    ) - 34usize];
    ["Offset of field: atom_display_controller_info_v4_5::vga_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        vga_hardcode_refreshrate
    ) - 35usize];
    ["Offset of field: atom_display_controller_info_v4_5::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_5::hw_chip_id"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, hw_chip_id) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_5::dcnip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dcnip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_5::dcnip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dcnip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_vbios_active_disp_pipe_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        max_vbios_active_disp_pipe_num
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_5::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_5::dispclk_pll_vco_freq"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dispclk_pll_vco_freq
    ) - 48usize];
    ["Offset of field: atom_display_controller_info_v4_5::dp_ref_clk_freq"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dp_ref_clk_freq) - 52usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_mclk_chg_lat"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_mclk_chg_lat) - 56usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_sr_exit_lat"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_sr_exit_lat) - 60usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_sr_enter_exit_lat"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        max_sr_enter_exit_lat
    ) - 64usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_golden_table_offset"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_golden_table_offset
    ) - 68usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_golden_table_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dc_golden_table_ver) - 70usize];
    ["Offset of field: atom_display_controller_info_v4_5::aux_dphy_rx_control0_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        aux_dphy_rx_control0_val
    ) - 72usize];
    ["Offset of field: atom_display_controller_info_v4_5::aux_dphy_tx_control_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        aux_dphy_tx_control_val
    ) - 76usize];
    ["Offset of field: atom_display_controller_info_v4_5::aux_dphy_rx_control1_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        aux_dphy_rx_control1_val
    ) - 80usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_0_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_0_val
    ) - 84usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_1_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_1_val
    ) - 88usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_2_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_2_val
    ) - 92usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_3_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_3_val
    ) - 96usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_4_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_4_val
    ) - 100usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_5_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_5_val
    ) - 104usize];
    ["Offset of field: atom_display_controller_info_v4_5::reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, reserved) - 108usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_ext_display_path {
    pub device_tag: u16,
    pub device_acpi_enum: u16,
    pub connectorobjid: u16,
    pub auxddclut_index: u8,
    pub hpdlut_index: u8,
    pub ext_encoder_objid: u16,
    pub channelmapping: u8,
    pub chpninvert: u8,
    pub caps: u16,
    pub reserved: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_ext_display_path"][::core::mem::size_of::<atom_ext_display_path>() - 16usize];
    ["Alignment of atom_ext_display_path"]
        [::core::mem::align_of::<atom_ext_display_path>() - 1usize];
    ["Offset of field: atom_ext_display_path::device_tag"]
        [::core::mem::offset_of!(atom_ext_display_path, device_tag) - 0usize];
    ["Offset of field: atom_ext_display_path::device_acpi_enum"]
        [::core::mem::offset_of!(atom_ext_display_path, device_acpi_enum) - 2usize];
    ["Offset of field: atom_ext_display_path::connectorobjid"]
        [::core::mem::offset_of!(atom_ext_display_path, connectorobjid) - 4usize];
    ["Offset of field: atom_ext_display_path::auxddclut_index"]
        [::core::mem::offset_of!(atom_ext_display_path, auxddclut_index) - 6usize];
    ["Offset of field: atom_ext_display_path::hpdlut_index"]
        [::core::mem::offset_of!(atom_ext_display_path, hpdlut_index) - 7usize];
    ["Offset of field: atom_ext_display_path::ext_encoder_objid"]
        [::core::mem::offset_of!(atom_ext_display_path, ext_encoder_objid) - 8usize];
    ["Offset of field: atom_ext_display_path::channelmapping"]
        [::core::mem::offset_of!(atom_ext_display_path, channelmapping) - 10usize];
    ["Offset of field: atom_ext_display_path::chpninvert"]
        [::core::mem::offset_of!(atom_ext_display_path, chpninvert) - 11usize];
    ["Offset of field: atom_ext_display_path::caps"]
        [::core::mem::offset_of!(atom_ext_display_path, caps) - 12usize];
    ["Offset of field: atom_ext_display_path::reserved"]
        [::core::mem::offset_of!(atom_ext_display_path, reserved) - 14usize];
};
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HBR2_DISABLE: ext_display_path_cap_def =
    1;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__DP_FIXED_VS_EN: ext_display_path_cap_def =
    2;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__EXT_CHIP_MASK: ext_display_path_cap_def =
    124;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HDMI20_PI3EQX1204:
    ext_display_path_cap_def = 4;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HDMI20_TISN65DP159RSBT:
    ext_display_path_cap_def = 8;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HDMI20_PARADE_PS175:
    ext_display_path_cap_def = 12;
pub type ext_display_path_cap_def = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_external_display_connection_info {
    pub table_header: atom_common_table_header,
    pub guid: [u8; 16usize],
    pub path: [atom_ext_display_path; 7usize],
    pub checksum: u8,
    pub stereopinid: u8,
    pub remotedisplayconfig: u8,
    pub edptolvdsrxid: u8,
    pub fixdpvoltageswing: u8,
    pub reserved: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_external_display_connection_info"]
        [::core::mem::size_of::<atom_external_display_connection_info>() - 140usize];
    ["Alignment of atom_external_display_connection_info"]
        [::core::mem::align_of::<atom_external_display_connection_info>() - 1usize];
    ["Offset of field: atom_external_display_connection_info::table_header"]
        [::core::mem::offset_of!(atom_external_display_connection_info, table_header) - 0usize];
    ["Offset of field: atom_external_display_connection_info::guid"]
        [::core::mem::offset_of!(atom_external_display_connection_info, guid) - 4usize];
    ["Offset of field: atom_external_display_connection_info::path"]
        [::core::mem::offset_of!(atom_external_display_connection_info, path) - 20usize];
    ["Offset of field: atom_external_display_connection_info::checksum"]
        [::core::mem::offset_of!(atom_external_display_connection_info, checksum) - 132usize];
    ["Offset of field: atom_external_display_connection_info::stereopinid"]
        [::core::mem::offset_of!(atom_external_display_connection_info, stereopinid) - 133usize];
    ["Offset of field: atom_external_display_connection_info::remotedisplayconfig"][::core::mem::offset_of!(
        atom_external_display_connection_info,
        remotedisplayconfig
    ) - 134usize];
    ["Offset of field: atom_external_display_connection_info::edptolvdsrxid"]
        [::core::mem::offset_of!(atom_external_display_connection_info, edptolvdsrxid) - 135usize];
    ["Offset of field: atom_external_display_connection_info::fixdpvoltageswing"][::core::mem::offset_of!(
        atom_external_display_connection_info,
        fixdpvoltageswing
    ) - 136usize];
    ["Offset of field: atom_external_display_connection_info::reserved"]
        [::core::mem::offset_of!(atom_external_display_connection_info, reserved) - 137usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_dphy_timing_param {
    pub profile_id: u8,
    pub param: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_dphy_timing_param"]
        [::core::mem::size_of::<atom_camera_dphy_timing_param>() - 5usize];
    ["Alignment of atom_camera_dphy_timing_param"]
        [::core::mem::align_of::<atom_camera_dphy_timing_param>() - 1usize];
    ["Offset of field: atom_camera_dphy_timing_param::profile_id"]
        [::core::mem::offset_of!(atom_camera_dphy_timing_param, profile_id) - 0usize];
    ["Offset of field: atom_camera_dphy_timing_param::param"]
        [::core::mem::offset_of!(atom_camera_dphy_timing_param, param) - 1usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_dphy_elec_param {
    pub param: [u16; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_dphy_elec_param"]
        [::core::mem::size_of::<atom_camera_dphy_elec_param>() - 6usize];
    ["Alignment of atom_camera_dphy_elec_param"]
        [::core::mem::align_of::<atom_camera_dphy_elec_param>() - 1usize];
    ["Offset of field: atom_camera_dphy_elec_param::param"]
        [::core::mem::offset_of!(atom_camera_dphy_elec_param, param) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_module_info {
    pub module_id: u8,
    pub module_name: [u8; 8usize],
    pub timingparam: [atom_camera_dphy_timing_param; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_module_info"]
        [::core::mem::size_of::<atom_camera_module_info>() - 39usize];
    ["Alignment of atom_camera_module_info"]
        [::core::mem::align_of::<atom_camera_module_info>() - 1usize];
    ["Offset of field: atom_camera_module_info::module_id"]
        [::core::mem::offset_of!(atom_camera_module_info, module_id) - 0usize];
    ["Offset of field: atom_camera_module_info::module_name"]
        [::core::mem::offset_of!(atom_camera_module_info, module_name) - 1usize];
    ["Offset of field: atom_camera_module_info::timingparam"]
        [::core::mem::offset_of!(atom_camera_module_info, timingparam) - 9usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_flashlight_info {
    pub flashlight_id: u8,
    pub name: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_flashlight_info"]
        [::core::mem::size_of::<atom_camera_flashlight_info>() - 9usize];
    ["Alignment of atom_camera_flashlight_info"]
        [::core::mem::align_of::<atom_camera_flashlight_info>() - 1usize];
    ["Offset of field: atom_camera_flashlight_info::flashlight_id"]
        [::core::mem::offset_of!(atom_camera_flashlight_info, flashlight_id) - 0usize];
    ["Offset of field: atom_camera_flashlight_info::name"]
        [::core::mem::offset_of!(atom_camera_flashlight_info, name) - 1usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_data {
    pub versionCode: u32,
    pub cameraInfo: [atom_camera_module_info; 3usize],
    pub flashInfo: atom_camera_flashlight_info,
    pub dphy_param: atom_camera_dphy_elec_param,
    pub crc_val: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_data"][::core::mem::size_of::<atom_camera_data>() - 140usize];
    ["Alignment of atom_camera_data"][::core::mem::align_of::<atom_camera_data>() - 1usize];
    ["Offset of field: atom_camera_data::versionCode"]
        [::core::mem::offset_of!(atom_camera_data, versionCode) - 0usize];
    ["Offset of field: atom_camera_data::cameraInfo"]
        [::core::mem::offset_of!(atom_camera_data, cameraInfo) - 4usize];
    ["Offset of field: atom_camera_data::flashInfo"]
        [::core::mem::offset_of!(atom_camera_data, flashInfo) - 121usize];
    ["Offset of field: atom_camera_data::dphy_param"]
        [::core::mem::offset_of!(atom_camera_data, dphy_param) - 130usize];
    ["Offset of field: atom_camera_data::crc_val"]
        [::core::mem::offset_of!(atom_camera_data, crc_val) - 136usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dpphy_dvihdmi_tuningset {
    pub max_symclk_in10khz: u32,
    pub encoder_mode: u8,
    pub phy_sel: u8,
    pub margindeemph: u16,
    pub deemph_6db_4: u8,
    pub boostadj: u8,
    pub tx_driver_fifty_ohms: u8,
    pub deemph_sel: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_dpphy_dvihdmi_tuningset"]
        [::core::mem::size_of::<atom_14nm_dpphy_dvihdmi_tuningset>() - 12usize];
    ["Alignment of atom_14nm_dpphy_dvihdmi_tuningset"]
        [::core::mem::align_of::<atom_14nm_dpphy_dvihdmi_tuningset>() - 1usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::max_symclk_in10khz"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, max_symclk_in10khz) - 0usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::encoder_mode"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, encoder_mode) - 4usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::phy_sel"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, phy_sel) - 5usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::margindeemph"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, margindeemph) - 6usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::deemph_6db_4"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, deemph_6db_4) - 8usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::boostadj"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, boostadj) - 9usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::tx_driver_fifty_ohms"][::core::mem::offset_of!(
        atom_14nm_dpphy_dvihdmi_tuningset,
        tx_driver_fifty_ohms
    ) - 10usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::deemph_sel"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, deemph_sel) - 11usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dpphy_dp_setting {
    pub dp_vs_pemph_level: u8,
    pub margindeemph: u16,
    pub deemph_6db_4: u8,
    pub boostadj: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_dpphy_dp_setting"]
        [::core::mem::size_of::<atom_14nm_dpphy_dp_setting>() - 5usize];
    ["Alignment of atom_14nm_dpphy_dp_setting"]
        [::core::mem::align_of::<atom_14nm_dpphy_dp_setting>() - 1usize];
    ["Offset of field: atom_14nm_dpphy_dp_setting::dp_vs_pemph_level"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_setting, dp_vs_pemph_level) - 0usize];
    ["Offset of field: atom_14nm_dpphy_dp_setting::margindeemph"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_setting, margindeemph) - 1usize];
    ["Offset of field: atom_14nm_dpphy_dp_setting::deemph_6db_4"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_setting, deemph_6db_4) - 3usize];
    ["Offset of field: atom_14nm_dpphy_dp_setting::boostadj"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_setting, boostadj) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dpphy_dp_tuningset {
    pub phy_sel: u8,
    pub version: u8,
    pub table_size: u16,
    pub reserved: u16,
    pub dptuning: [atom_14nm_dpphy_dp_setting; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_dpphy_dp_tuningset"]
        [::core::mem::size_of::<atom_14nm_dpphy_dp_tuningset>() - 56usize];
    ["Alignment of atom_14nm_dpphy_dp_tuningset"]
        [::core::mem::align_of::<atom_14nm_dpphy_dp_tuningset>() - 1usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::phy_sel"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, phy_sel) - 0usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::version"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, version) - 1usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::table_size"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, table_size) - 2usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::reserved"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, reserved) - 4usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::dptuning"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, dptuning) - 6usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dig_transmitter_info_header_v4_0 {
    pub table_header: atom_common_table_header,
    pub pcie_phy_tmds_hdmi_macro_settings_offset: u16,
    pub uniphy_vs_emph_lookup_table_offset: u16,
    pub uniphy_xbar_settings_table_offset: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_dig_transmitter_info_header_v4_0"]
        [::core::mem::size_of::<atom_14nm_dig_transmitter_info_header_v4_0>() - 10usize];
    ["Alignment of atom_14nm_dig_transmitter_info_header_v4_0"]
        [::core::mem::align_of::<atom_14nm_dig_transmitter_info_header_v4_0>() - 1usize];
    ["Offset of field: atom_14nm_dig_transmitter_info_header_v4_0::table_header"][::core::mem::offset_of!(
        atom_14nm_dig_transmitter_info_header_v4_0,
        table_header
    ) - 0usize];
    ["Offset of field: atom_14nm_dig_transmitter_info_header_v4_0::pcie_phy_tmds_hdmi_macro_settings_offset"] [:: core :: mem :: offset_of ! (atom_14nm_dig_transmitter_info_header_v4_0 , pcie_phy_tmds_hdmi_macro_settings_offset) - 4usize] ;
    ["Offset of field: atom_14nm_dig_transmitter_info_header_v4_0::uniphy_vs_emph_lookup_table_offset"] [:: core :: mem :: offset_of ! (atom_14nm_dig_transmitter_info_header_v4_0 , uniphy_vs_emph_lookup_table_offset) - 6usize] ;
    ["Offset of field: atom_14nm_dig_transmitter_info_header_v4_0::uniphy_xbar_settings_table_offset"] [:: core :: mem :: offset_of ! (atom_14nm_dig_transmitter_info_header_v4_0 , uniphy_xbar_settings_table_offset) - 8usize] ;
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_combphy_tmds_vs_set {
    pub sym_clk: u8,
    pub dig_mode: u8,
    pub phy_sel: u8,
    pub common_mar_deemph_nom__margin_deemph_val: u16,
    pub common_seldeemph60__deemph_6db_4_val: u8,
    pub cmd_bus_global_for_tx_lane0__boostadj_val: u8,
    pub common_zcalcode_ctrl__tx_driver_fifty_ohms_val: u8,
    pub margin_deemph_lane0__deemph_sel_val: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_combphy_tmds_vs_set"]
        [::core::mem::size_of::<atom_14nm_combphy_tmds_vs_set>() - 9usize];
    ["Alignment of atom_14nm_combphy_tmds_vs_set"]
        [::core::mem::align_of::<atom_14nm_combphy_tmds_vs_set>() - 1usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::sym_clk"]
        [::core::mem::offset_of!(atom_14nm_combphy_tmds_vs_set, sym_clk) - 0usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::dig_mode"]
        [::core::mem::offset_of!(atom_14nm_combphy_tmds_vs_set, dig_mode) - 1usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::phy_sel"]
        [::core::mem::offset_of!(atom_14nm_combphy_tmds_vs_set, phy_sel) - 2usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::common_mar_deemph_nom__margin_deemph_val"][::core::mem::offset_of!(
        atom_14nm_combphy_tmds_vs_set,
        common_mar_deemph_nom__margin_deemph_val
    )
        - 3usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::common_seldeemph60__deemph_6db_4_val"][::core::mem::offset_of!(
        atom_14nm_combphy_tmds_vs_set,
        common_seldeemph60__deemph_6db_4_val
    )
        - 5usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::cmd_bus_global_for_tx_lane0__boostadj_val"][::core::mem::offset_of!(
        atom_14nm_combphy_tmds_vs_set,
        cmd_bus_global_for_tx_lane0__boostadj_val
    )
        - 6usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::common_zcalcode_ctrl__tx_driver_fifty_ohms_val"] [:: core :: mem :: offset_of ! (atom_14nm_combphy_tmds_vs_set , common_zcalcode_ctrl__tx_driver_fifty_ohms_val) - 7usize] ;
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::margin_deemph_lane0__deemph_sel_val"][::core::mem::offset_of!(
        atom_14nm_combphy_tmds_vs_set,
        margin_deemph_lane0__deemph_sel_val
    )
        - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_DCN_dpphy_dvihdmi_tuningset {
    pub max_symclk_in10khz: u32,
    pub encoder_mode: u8,
    pub phy_sel: u8,
    pub tx_eq_main: u8,
    pub tx_eq_pre: u8,
    pub tx_eq_post: u8,
    pub reserved1: u8,
    pub tx_vboost_lvl: u8,
    pub reserved2: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_DCN_dpphy_dvihdmi_tuningset"]
        [::core::mem::size_of::<atom_DCN_dpphy_dvihdmi_tuningset>() - 12usize];
    ["Alignment of atom_DCN_dpphy_dvihdmi_tuningset"]
        [::core::mem::align_of::<atom_DCN_dpphy_dvihdmi_tuningset>() - 1usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::max_symclk_in10khz"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, max_symclk_in10khz) - 0usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::encoder_mode"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, encoder_mode) - 4usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::phy_sel"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, phy_sel) - 5usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::tx_eq_main"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, tx_eq_main) - 6usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::tx_eq_pre"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, tx_eq_pre) - 7usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::tx_eq_post"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, tx_eq_post) - 8usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::reserved1"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, reserved1) - 9usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::tx_vboost_lvl"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, tx_vboost_lvl) - 10usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::reserved2"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, reserved2) - 11usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_DCN_dpphy_dp_setting {
    pub dp_vs_pemph_level: u8,
    pub tx_eq_main: u8,
    pub tx_eq_pre: u8,
    pub tx_eq_post: u8,
    pub tx_vboost_lvl: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_DCN_dpphy_dp_setting"]
        [::core::mem::size_of::<atom_DCN_dpphy_dp_setting>() - 5usize];
    ["Alignment of atom_DCN_dpphy_dp_setting"]
        [::core::mem::align_of::<atom_DCN_dpphy_dp_setting>() - 1usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::dp_vs_pemph_level"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, dp_vs_pemph_level) - 0usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::tx_eq_main"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, tx_eq_main) - 1usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::tx_eq_pre"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, tx_eq_pre) - 2usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::tx_eq_post"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, tx_eq_post) - 3usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::tx_vboost_lvl"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, tx_vboost_lvl) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_DCN_dpphy_dp_tuningset {
    pub phy_sel: u8,
    pub version: u8,
    pub table_size: u16,
    pub reserved: u16,
    pub dptunings: [atom_DCN_dpphy_dp_setting; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_DCN_dpphy_dp_tuningset"]
        [::core::mem::size_of::<atom_DCN_dpphy_dp_tuningset>() - 56usize];
    ["Alignment of atom_DCN_dpphy_dp_tuningset"]
        [::core::mem::align_of::<atom_DCN_dpphy_dp_tuningset>() - 1usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::phy_sel"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, phy_sel) - 0usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::version"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, version) - 1usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::table_size"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, table_size) - 2usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::reserved"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, reserved) - 4usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::dptunings"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, dptunings) - 6usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_reg_info {
    pub ucI2cRegIndex: u8,
    pub ucI2cRegVal: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_i2c_reg_info"][::core::mem::size_of::<atom_i2c_reg_info>() - 2usize];
    ["Alignment of atom_i2c_reg_info"][::core::mem::align_of::<atom_i2c_reg_info>() - 1usize];
    ["Offset of field: atom_i2c_reg_info::ucI2cRegIndex"]
        [::core::mem::offset_of!(atom_i2c_reg_info, ucI2cRegIndex) - 0usize];
    ["Offset of field: atom_i2c_reg_info::ucI2cRegVal"]
        [::core::mem::offset_of!(atom_i2c_reg_info, ucI2cRegVal) - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_hdmi_retimer_redriver_set {
    pub HdmiSlvAddr: u8,
    pub HdmiRegNum: u8,
    pub Hdmi6GRegNum: u8,
    pub HdmiRegSetting: [atom_i2c_reg_info; 9usize],
    pub Hdmi6GhzRegSetting: [atom_i2c_reg_info; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_hdmi_retimer_redriver_set"]
        [::core::mem::size_of::<atom_hdmi_retimer_redriver_set>() - 27usize];
    ["Alignment of atom_hdmi_retimer_redriver_set"]
        [::core::mem::align_of::<atom_hdmi_retimer_redriver_set>() - 1usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::HdmiSlvAddr"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, HdmiSlvAddr) - 0usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::HdmiRegNum"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, HdmiRegNum) - 1usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::Hdmi6GRegNum"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, Hdmi6GRegNum) - 2usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::HdmiRegSetting"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, HdmiRegSetting) - 3usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::Hdmi6GhzRegSetting"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, Hdmi6GhzRegSetting) - 21usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v1_11 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub lvds_ss_percentage: u16,
    pub lvds_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub dpphy_override: u16,
    pub lvds_misc: u16,
    pub backlight_pwm_hz: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub pwr_on_digon_to_de: u8,
    pub pwr_on_de_to_vary_bl: u8,
    pub pwr_down_vary_bloff_to_de: u8,
    pub pwr_down_de_to_digoff: u8,
    pub pwr_off_delay: u8,
    pub pwr_on_vary_bl_to_blon: u8,
    pub pwr_down_bloff_to_vary_bloff: u8,
    pub min_allowed_bl_level: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub extdispconninfo: atom_external_display_connection_info,
    pub dvi_tuningset: atom_14nm_dpphy_dvihdmi_tuningset,
    pub hdmi_tuningset: atom_14nm_dpphy_dvihdmi_tuningset,
    pub hdmi6g_tuningset: atom_14nm_dpphy_dvihdmi_tuningset,
    pub dp_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub dp_hbr3_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub camera_info: atom_camera_data,
    pub dp0_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp1_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp2_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp3_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp_hbr_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub dp_hbr2_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub edp_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub reserved: [u32; 66usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_integrated_system_info_v1_11"]
        [::core::mem::size_of::<atom_integrated_system_info_v1_11>() - 1024usize];
    ["Alignment of atom_integrated_system_info_v1_11"]
        [::core::mem::align_of::<atom_integrated_system_info_v1_11>() - 1usize];
    ["Offset of field: atom_integrated_system_info_v1_11::table_header"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, table_header) - 0usize];
    ["Offset of field: atom_integrated_system_info_v1_11::vbios_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, vbios_misc) - 4usize];
    ["Offset of field: atom_integrated_system_info_v1_11::gpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, gpucapinfo) - 8usize];
    ["Offset of field: atom_integrated_system_info_v1_11::system_config"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, system_config) - 12usize];
    ["Offset of field: atom_integrated_system_info_v1_11::cpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, cpucapinfo) - 16usize];
    ["Offset of field: atom_integrated_system_info_v1_11::gpuclk_ss_percentage"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        gpuclk_ss_percentage
    ) - 20usize];
    ["Offset of field: atom_integrated_system_info_v1_11::gpuclk_ss_type"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, gpuclk_ss_type) - 22usize];
    ["Offset of field: atom_integrated_system_info_v1_11::lvds_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, lvds_ss_percentage) - 24usize];
    ["Offset of field: atom_integrated_system_info_v1_11::lvds_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, lvds_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_integrated_system_info_v1_11::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, hdmi_ss_percentage) - 28usize];
    ["Offset of field: atom_integrated_system_info_v1_11::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, hdmi_ss_rate_10hz) - 30usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dvi_ss_percentage) - 32usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dvi_ss_rate_10hz) - 34usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dpphy_override"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dpphy_override) - 36usize];
    ["Offset of field: atom_integrated_system_info_v1_11::lvds_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, lvds_misc) - 38usize];
    ["Offset of field: atom_integrated_system_info_v1_11::backlight_pwm_hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, backlight_pwm_hz) - 40usize];
    ["Offset of field: atom_integrated_system_info_v1_11::memorytype"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, memorytype) - 42usize];
    ["Offset of field: atom_integrated_system_info_v1_11::umachannelnumber"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, umachannelnumber) - 43usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_on_digon_to_de"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, pwr_on_digon_to_de) - 44usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_on_de_to_vary_bl"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_on_de_to_vary_bl
    ) - 45usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_down_vary_bloff_to_de"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_down_vary_bloff_to_de
    ) - 46usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_down_de_to_digoff"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_down_de_to_digoff
    ) - 47usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_off_delay"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, pwr_off_delay) - 48usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_on_vary_bl_to_blon"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_on_vary_bl_to_blon
    ) - 49usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_down_bloff_to_vary_bloff"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_down_bloff_to_vary_bloff
    )
        - 50usize];
    ["Offset of field: atom_integrated_system_info_v1_11::min_allowed_bl_level"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        min_allowed_bl_level
    ) - 51usize];
    ["Offset of field: atom_integrated_system_info_v1_11::htc_hyst_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, htc_hyst_limit) - 52usize];
    ["Offset of field: atom_integrated_system_info_v1_11::htc_tmp_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, htc_tmp_limit) - 53usize];
    ["Offset of field: atom_integrated_system_info_v1_11::reserved1"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, reserved1) - 54usize];
    ["Offset of field: atom_integrated_system_info_v1_11::reserved2"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, reserved2) - 55usize];
    ["Offset of field: atom_integrated_system_info_v1_11::extdispconninfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, extdispconninfo) - 56usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dvi_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dvi_tuningset) - 196usize];
    ["Offset of field: atom_integrated_system_info_v1_11::hdmi_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, hdmi_tuningset) - 208usize];
    ["Offset of field: atom_integrated_system_info_v1_11::hdmi6g_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, hdmi6g_tuningset) - 220usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp_tuningset) - 232usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp_hbr3_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp_hbr3_tuningset) - 288usize];
    ["Offset of field: atom_integrated_system_info_v1_11::camera_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, camera_info) - 344usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp0_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp0_retimer_set) - 484usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp1_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp1_retimer_set) - 511usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp2_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp2_retimer_set) - 538usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp3_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp3_retimer_set) - 565usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp_hbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp_hbr_tuningset) - 592usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp_hbr2_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp_hbr2_tuningset) - 648usize];
    ["Offset of field: atom_integrated_system_info_v1_11::edp_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, edp_tuningset) - 704usize];
    ["Offset of field: atom_integrated_system_info_v1_11::reserved"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, reserved) - 760usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v1_12 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub lvds_ss_percentage: u16,
    pub lvds_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub dpphy_override: u16,
    pub lvds_misc: u16,
    pub backlight_pwm_hz: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub pwr_on_digon_to_de: u8,
    pub pwr_on_de_to_vary_bl: u8,
    pub pwr_down_vary_bloff_to_de: u8,
    pub pwr_down_de_to_digoff: u8,
    pub pwr_off_delay: u8,
    pub pwr_on_vary_bl_to_blon: u8,
    pub pwr_down_bloff_to_vary_bloff: u8,
    pub min_allowed_bl_level: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub extdispconninfo: atom_external_display_connection_info,
    pub TMDS_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK5_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK8_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub rbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr3_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub camera_info: atom_camera_data,
    pub dp0_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp1_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp2_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp3_retimer_set: atom_hdmi_retimer_redriver_set,
    pub hbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr2_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub edp_tunings: atom_DCN_dpphy_dp_tuningset,
    pub hdmiCLK6_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub reserved: [u32; 63usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_integrated_system_info_v1_12"]
        [::core::mem::size_of::<atom_integrated_system_info_v1_12>() - 1024usize];
    ["Alignment of atom_integrated_system_info_v1_12"]
        [::core::mem::align_of::<atom_integrated_system_info_v1_12>() - 1usize];
    ["Offset of field: atom_integrated_system_info_v1_12::table_header"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, table_header) - 0usize];
    ["Offset of field: atom_integrated_system_info_v1_12::vbios_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, vbios_misc) - 4usize];
    ["Offset of field: atom_integrated_system_info_v1_12::gpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, gpucapinfo) - 8usize];
    ["Offset of field: atom_integrated_system_info_v1_12::system_config"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, system_config) - 12usize];
    ["Offset of field: atom_integrated_system_info_v1_12::cpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, cpucapinfo) - 16usize];
    ["Offset of field: atom_integrated_system_info_v1_12::gpuclk_ss_percentage"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        gpuclk_ss_percentage
    ) - 20usize];
    ["Offset of field: atom_integrated_system_info_v1_12::gpuclk_ss_type"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, gpuclk_ss_type) - 22usize];
    ["Offset of field: atom_integrated_system_info_v1_12::lvds_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, lvds_ss_percentage) - 24usize];
    ["Offset of field: atom_integrated_system_info_v1_12::lvds_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, lvds_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmi_ss_percentage) - 28usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmi_ss_rate_10hz) - 30usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dvi_ss_percentage) - 32usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dvi_ss_rate_10hz) - 34usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dpphy_override"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dpphy_override) - 36usize];
    ["Offset of field: atom_integrated_system_info_v1_12::lvds_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, lvds_misc) - 38usize];
    ["Offset of field: atom_integrated_system_info_v1_12::backlight_pwm_hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, backlight_pwm_hz) - 40usize];
    ["Offset of field: atom_integrated_system_info_v1_12::memorytype"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, memorytype) - 42usize];
    ["Offset of field: atom_integrated_system_info_v1_12::umachannelnumber"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, umachannelnumber) - 43usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_on_digon_to_de"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, pwr_on_digon_to_de) - 44usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_on_de_to_vary_bl"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_on_de_to_vary_bl
    ) - 45usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_down_vary_bloff_to_de"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_down_vary_bloff_to_de
    ) - 46usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_down_de_to_digoff"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_down_de_to_digoff
    ) - 47usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_off_delay"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, pwr_off_delay) - 48usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_on_vary_bl_to_blon"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_on_vary_bl_to_blon
    ) - 49usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_down_bloff_to_vary_bloff"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_down_bloff_to_vary_bloff
    )
        - 50usize];
    ["Offset of field: atom_integrated_system_info_v1_12::min_allowed_bl_level"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        min_allowed_bl_level
    ) - 51usize];
    ["Offset of field: atom_integrated_system_info_v1_12::htc_hyst_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, htc_hyst_limit) - 52usize];
    ["Offset of field: atom_integrated_system_info_v1_12::htc_tmp_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, htc_tmp_limit) - 53usize];
    ["Offset of field: atom_integrated_system_info_v1_12::reserved1"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, reserved1) - 54usize];
    ["Offset of field: atom_integrated_system_info_v1_12::reserved2"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, reserved2) - 55usize];
    ["Offset of field: atom_integrated_system_info_v1_12::extdispconninfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, extdispconninfo) - 56usize];
    ["Offset of field: atom_integrated_system_info_v1_12::TMDS_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, TMDS_tuningset) - 196usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmiCLK5_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmiCLK5_tuningset) - 208usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmiCLK8_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmiCLK8_tuningset) - 220usize];
    ["Offset of field: atom_integrated_system_info_v1_12::rbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, rbr_tuningset) - 232usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hbr3_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hbr3_tuningset) - 288usize];
    ["Offset of field: atom_integrated_system_info_v1_12::camera_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, camera_info) - 344usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dp0_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dp0_retimer_set) - 484usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dp1_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dp1_retimer_set) - 511usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dp2_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dp2_retimer_set) - 538usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dp3_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dp3_retimer_set) - 565usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hbr_tuningset) - 592usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hbr2_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hbr2_tuningset) - 648usize];
    ["Offset of field: atom_integrated_system_info_v1_12::edp_tunings"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, edp_tunings) - 704usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmiCLK6_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmiCLK6_tuningset) - 760usize];
    ["Offset of field: atom_integrated_system_info_v1_12::reserved"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, reserved) - 772usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct edp_info_table {
    pub edp_backlight_pwm_hz: u16,
    pub edp_ss_percentage: u16,
    pub edp_ss_rate_10hz: u16,
    pub reserved1: u16,
    pub reserved2: u32,
    pub edp_pwr_on_off_delay: u8,
    pub edp_pwr_on_vary_bl_to_blon: u8,
    pub edp_pwr_down_bloff_to_vary_bloff: u8,
    pub edp_panel_bpc: u8,
    pub edp_bootup_bl_level: u8,
    pub reserved3: [u8; 3usize],
    pub reserved4: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of edp_info_table"][::core::mem::size_of::<edp_info_table>() - 32usize];
    ["Alignment of edp_info_table"][::core::mem::align_of::<edp_info_table>() - 1usize];
    ["Offset of field: edp_info_table::edp_backlight_pwm_hz"]
        [::core::mem::offset_of!(edp_info_table, edp_backlight_pwm_hz) - 0usize];
    ["Offset of field: edp_info_table::edp_ss_percentage"]
        [::core::mem::offset_of!(edp_info_table, edp_ss_percentage) - 2usize];
    ["Offset of field: edp_info_table::edp_ss_rate_10hz"]
        [::core::mem::offset_of!(edp_info_table, edp_ss_rate_10hz) - 4usize];
    ["Offset of field: edp_info_table::reserved1"]
        [::core::mem::offset_of!(edp_info_table, reserved1) - 6usize];
    ["Offset of field: edp_info_table::reserved2"]
        [::core::mem::offset_of!(edp_info_table, reserved2) - 8usize];
    ["Offset of field: edp_info_table::edp_pwr_on_off_delay"]
        [::core::mem::offset_of!(edp_info_table, edp_pwr_on_off_delay) - 12usize];
    ["Offset of field: edp_info_table::edp_pwr_on_vary_bl_to_blon"]
        [::core::mem::offset_of!(edp_info_table, edp_pwr_on_vary_bl_to_blon) - 13usize];
    ["Offset of field: edp_info_table::edp_pwr_down_bloff_to_vary_bloff"]
        [::core::mem::offset_of!(edp_info_table, edp_pwr_down_bloff_to_vary_bloff) - 14usize];
    ["Offset of field: edp_info_table::edp_panel_bpc"]
        [::core::mem::offset_of!(edp_info_table, edp_panel_bpc) - 15usize];
    ["Offset of field: edp_info_table::edp_bootup_bl_level"]
        [::core::mem::offset_of!(edp_info_table, edp_bootup_bl_level) - 16usize];
    ["Offset of field: edp_info_table::reserved3"]
        [::core::mem::offset_of!(edp_info_table, reserved3) - 17usize];
    ["Offset of field: edp_info_table::reserved4"]
        [::core::mem::offset_of!(edp_info_table, reserved4) - 20usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v2_1 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub dpphy_override: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub edp1_info: edp_info_table,
    pub edp2_info: edp_info_table,
    pub reserved3: [u32; 8usize],
    pub extdispconninfo: atom_external_display_connection_info,
    pub TMDS_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK5_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK6_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK8_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub reserved4: [u32; 6usize],
    pub rbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr2_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr3_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub edp_tunings: atom_DCN_dpphy_dp_tuningset,
    pub reserved5: [u32; 28usize],
    pub dp0_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp1_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp2_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp3_retimer_set: atom_hdmi_retimer_redriver_set,
    pub reserved6: [u32; 30usize],
    pub reserved7: [u32; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_integrated_system_info_v2_1"]
        [::core::mem::size_of::<atom_integrated_system_info_v2_1>() - 1088usize];
    ["Alignment of atom_integrated_system_info_v2_1"]
        [::core::mem::align_of::<atom_integrated_system_info_v2_1>() - 1usize];
    ["Offset of field: atom_integrated_system_info_v2_1::table_header"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, table_header) - 0usize];
    ["Offset of field: atom_integrated_system_info_v2_1::vbios_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, vbios_misc) - 4usize];
    ["Offset of field: atom_integrated_system_info_v2_1::gpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, gpucapinfo) - 8usize];
    ["Offset of field: atom_integrated_system_info_v2_1::system_config"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, system_config) - 12usize];
    ["Offset of field: atom_integrated_system_info_v2_1::cpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, cpucapinfo) - 16usize];
    ["Offset of field: atom_integrated_system_info_v2_1::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, gpuclk_ss_percentage) - 20usize];
    ["Offset of field: atom_integrated_system_info_v2_1::gpuclk_ss_type"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, gpuclk_ss_type) - 22usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dpphy_override"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dpphy_override) - 24usize];
    ["Offset of field: atom_integrated_system_info_v2_1::memorytype"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, memorytype) - 26usize];
    ["Offset of field: atom_integrated_system_info_v2_1::umachannelnumber"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, umachannelnumber) - 27usize];
    ["Offset of field: atom_integrated_system_info_v2_1::htc_hyst_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, htc_hyst_limit) - 28usize];
    ["Offset of field: atom_integrated_system_info_v2_1::htc_tmp_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, htc_tmp_limit) - 29usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved1"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved1) - 30usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved2"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved2) - 31usize];
    ["Offset of field: atom_integrated_system_info_v2_1::edp1_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, edp1_info) - 32usize];
    ["Offset of field: atom_integrated_system_info_v2_1::edp2_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, edp2_info) - 64usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved3"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved3) - 96usize];
    ["Offset of field: atom_integrated_system_info_v2_1::extdispconninfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, extdispconninfo) - 128usize];
    ["Offset of field: atom_integrated_system_info_v2_1::TMDS_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, TMDS_tuningset) - 268usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hdmiCLK5_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hdmiCLK5_tuningset) - 280usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hdmiCLK6_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hdmiCLK6_tuningset) - 292usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hdmiCLK8_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hdmiCLK8_tuningset) - 304usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved4"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved4) - 316usize];
    ["Offset of field: atom_integrated_system_info_v2_1::rbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, rbr_tuningset) - 340usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hbr_tuningset) - 396usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hbr2_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hbr2_tuningset) - 452usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hbr3_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hbr3_tuningset) - 508usize];
    ["Offset of field: atom_integrated_system_info_v2_1::edp_tunings"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, edp_tunings) - 564usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved5"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved5) - 620usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dp0_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dp0_retimer_set) - 732usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dp1_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dp1_retimer_set) - 759usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dp2_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dp2_retimer_set) - 786usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dp3_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dp3_retimer_set) - 813usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved6"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved6) - 840usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved7"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved7) - 960usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_n6_display_phy_tuning_set {
    pub display_signal_type: u8,
    pub phy_sel: u8,
    pub preset_level: u8,
    pub reserved1: u8,
    pub reserved2: u32,
    pub speed_upto: u32,
    pub tx_vboost_level: u8,
    pub tx_vreg_v2i: u8,
    pub tx_vregdrv_byp: u8,
    pub tx_term_cntl: u8,
    pub tx_peak_level: u8,
    pub tx_slew_en: u8,
    pub tx_eq_pre: u8,
    pub tx_eq_main: u8,
    pub tx_eq_post: u8,
    pub tx_en_inv_pre: u8,
    pub tx_en_inv_post: u8,
    pub reserved3: u8,
    pub reserved4: u32,
    pub reserved5: u32,
    pub reserved6: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_n6_display_phy_tuning_set"]
        [::core::mem::size_of::<atom_n6_display_phy_tuning_set>() - 36usize];
    ["Alignment of atom_n6_display_phy_tuning_set"]
        [::core::mem::align_of::<atom_n6_display_phy_tuning_set>() - 1usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::display_signal_type"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, display_signal_type) - 0usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::phy_sel"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, phy_sel) - 1usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::preset_level"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, preset_level) - 2usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved1"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved1) - 3usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved2"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved2) - 4usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::speed_upto"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, speed_upto) - 8usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_vboost_level"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_vboost_level) - 12usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_vreg_v2i"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_vreg_v2i) - 13usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_vregdrv_byp"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_vregdrv_byp) - 14usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_term_cntl"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_term_cntl) - 15usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_peak_level"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_peak_level) - 16usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_slew_en"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_slew_en) - 17usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_eq_pre"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_eq_pre) - 18usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_eq_main"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_eq_main) - 19usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_eq_post"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_eq_post) - 20usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_en_inv_pre"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_en_inv_pre) - 21usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_en_inv_post"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_en_inv_post) - 22usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved3"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved3) - 23usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved4"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved4) - 24usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved5"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved5) - 28usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved6"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved6) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_phy_tuning_info {
    pub table_header: atom_common_table_header,
    pub disp_phy_tuning: [atom_n6_display_phy_tuning_set; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_phy_tuning_info"]
        [::core::mem::size_of::<atom_display_phy_tuning_info>() - 40usize];
    ["Alignment of atom_display_phy_tuning_info"]
        [::core::mem::align_of::<atom_display_phy_tuning_info>() - 1usize];
    ["Offset of field: atom_display_phy_tuning_info::table_header"]
        [::core::mem::offset_of!(atom_display_phy_tuning_info, table_header) - 0usize];
    ["Offset of field: atom_display_phy_tuning_info::disp_phy_tuning"]
        [::core::mem::offset_of!(atom_display_phy_tuning_info, disp_phy_tuning) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v2_2 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub dpphy_override: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub edp1_info: edp_info_table,
    pub edp2_info: edp_info_table,
    pub reserved3: [u32; 8usize],
    pub extdispconninfo: atom_external_display_connection_info,
    pub reserved4: [u32; 189usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_integrated_system_info_v2_2"]
        [::core::mem::size_of::<atom_integrated_system_info_v2_2>() - 1024usize];
    ["Alignment of atom_integrated_system_info_v2_2"]
        [::core::mem::align_of::<atom_integrated_system_info_v2_2>() - 1usize];
    ["Offset of field: atom_integrated_system_info_v2_2::table_header"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, table_header) - 0usize];
    ["Offset of field: atom_integrated_system_info_v2_2::vbios_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, vbios_misc) - 4usize];
    ["Offset of field: atom_integrated_system_info_v2_2::gpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, gpucapinfo) - 8usize];
    ["Offset of field: atom_integrated_system_info_v2_2::system_config"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, system_config) - 12usize];
    ["Offset of field: atom_integrated_system_info_v2_2::cpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, cpucapinfo) - 16usize];
    ["Offset of field: atom_integrated_system_info_v2_2::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, gpuclk_ss_percentage) - 20usize];
    ["Offset of field: atom_integrated_system_info_v2_2::gpuclk_ss_type"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, gpuclk_ss_type) - 22usize];
    ["Offset of field: atom_integrated_system_info_v2_2::dpphy_override"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, dpphy_override) - 24usize];
    ["Offset of field: atom_integrated_system_info_v2_2::memorytype"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, memorytype) - 26usize];
    ["Offset of field: atom_integrated_system_info_v2_2::umachannelnumber"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, umachannelnumber) - 27usize];
    ["Offset of field: atom_integrated_system_info_v2_2::htc_hyst_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, htc_hyst_limit) - 28usize];
    ["Offset of field: atom_integrated_system_info_v2_2::htc_tmp_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, htc_tmp_limit) - 29usize];
    ["Offset of field: atom_integrated_system_info_v2_2::reserved1"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, reserved1) - 30usize];
    ["Offset of field: atom_integrated_system_info_v2_2::reserved2"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, reserved2) - 31usize];
    ["Offset of field: atom_integrated_system_info_v2_2::edp1_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, edp1_info) - 32usize];
    ["Offset of field: atom_integrated_system_info_v2_2::edp2_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, edp2_info) - 64usize];
    ["Offset of field: atom_integrated_system_info_v2_2::reserved3"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, reserved3) - 96usize];
    ["Offset of field: atom_integrated_system_info_v2_2::extdispconninfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, extdispconninfo) - 128usize];
    ["Offset of field: atom_integrated_system_info_v2_2::reserved4"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, reserved4) - 268usize];
};
pub const atom_system_vbiosmisc_def_INTEGRATED_SYSTEM_INFO__GET_EDID_CALLBACK_FUNC_SUPPORT:
    atom_system_vbiosmisc_def = 1;
pub type atom_system_vbiosmisc_def = ::core::ffi::c_uint;
pub const atom_system_gpucapinf_def_SYS_INFO_GPUCAPS__ENABEL_DFS_BYPASS: atom_system_gpucapinf_def =
    16;
pub type atom_system_gpucapinf_def = ::core::ffi::c_uint;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_DVI_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 1;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_HDMI_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 2;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_HDMI6G_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 4;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_DP_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 8;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_DP_HBR3_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 16;
pub type atom_sysinfo_dpphy_override_def = ::core::ffi::c_uint;
pub const atom_sys_info_lvds_misc_def_SYS_INFO_LVDS_MISC_888_FPDI_MODE:
    atom_sys_info_lvds_misc_def = 1;
pub const atom_sys_info_lvds_misc_def_SYS_INFO_LVDS_MISC_888_BPC_MODE: atom_sys_info_lvds_misc_def =
    4;
pub const atom_sys_info_lvds_misc_def_SYS_INFO_LVDS_MISC_OVERRIDE_EN: atom_sys_info_lvds_misc_def =
    8;
pub type atom_sys_info_lvds_misc_def = ::core::ffi::c_uint;
#[doc = "< Assign 01 to Other"]
pub const atom_dmi_t17_mem_type_def_OtherMemType: atom_dmi_t17_mem_type_def = 1;
#[doc = "< Assign 02 to Unknown"]
pub const atom_dmi_t17_mem_type_def_UnknownMemType: atom_dmi_t17_mem_type_def = 2;
#[doc = "< Assign 03 to DRAM"]
pub const atom_dmi_t17_mem_type_def_DramMemType: atom_dmi_t17_mem_type_def = 3;
#[doc = "< Assign 04 to EDRAM"]
pub const atom_dmi_t17_mem_type_def_EdramMemType: atom_dmi_t17_mem_type_def = 4;
#[doc = "< Assign 05 to VRAM"]
pub const atom_dmi_t17_mem_type_def_VramMemType: atom_dmi_t17_mem_type_def = 5;
#[doc = "< Assign 06 to SRAM"]
pub const atom_dmi_t17_mem_type_def_SramMemType: atom_dmi_t17_mem_type_def = 6;
#[doc = "< Assign 07 to RAM"]
pub const atom_dmi_t17_mem_type_def_RamMemType: atom_dmi_t17_mem_type_def = 7;
#[doc = "< Assign 08 to ROM"]
pub const atom_dmi_t17_mem_type_def_RomMemType: atom_dmi_t17_mem_type_def = 8;
#[doc = "< Assign 09 to Flash"]
pub const atom_dmi_t17_mem_type_def_FlashMemType: atom_dmi_t17_mem_type_def = 9;
#[doc = "< Assign 10 to EEPROM"]
pub const atom_dmi_t17_mem_type_def_EepromMemType: atom_dmi_t17_mem_type_def = 10;
#[doc = "< Assign 11 to FEPROM"]
pub const atom_dmi_t17_mem_type_def_FepromMemType: atom_dmi_t17_mem_type_def = 11;
#[doc = "< Assign 12 to EPROM"]
pub const atom_dmi_t17_mem_type_def_EpromMemType: atom_dmi_t17_mem_type_def = 12;
#[doc = "< Assign 13 to CDRAM"]
pub const atom_dmi_t17_mem_type_def_CdramMemType: atom_dmi_t17_mem_type_def = 13;
#[doc = "< Assign 14 to 3DRAM"]
pub const atom_dmi_t17_mem_type_def_ThreeDramMemType: atom_dmi_t17_mem_type_def = 14;
#[doc = "< Assign 15 to SDRAM"]
pub const atom_dmi_t17_mem_type_def_SdramMemType: atom_dmi_t17_mem_type_def = 15;
#[doc = "< Assign 16 to SGRAM"]
pub const atom_dmi_t17_mem_type_def_SgramMemType: atom_dmi_t17_mem_type_def = 16;
#[doc = "< Assign 17 to RDRAM"]
pub const atom_dmi_t17_mem_type_def_RdramMemType: atom_dmi_t17_mem_type_def = 17;
#[doc = "< Assign 18 to DDR"]
pub const atom_dmi_t17_mem_type_def_DdrMemType: atom_dmi_t17_mem_type_def = 18;
#[doc = "< Assign 19 to DDR2"]
pub const atom_dmi_t17_mem_type_def_Ddr2MemType: atom_dmi_t17_mem_type_def = 19;
#[doc = "< Assign 20 to DDR2 FB-DIMM"]
pub const atom_dmi_t17_mem_type_def_Ddr2FbdimmMemType: atom_dmi_t17_mem_type_def = 20;
#[doc = "< Assign 24 to DDR3"]
pub const atom_dmi_t17_mem_type_def_Ddr3MemType: atom_dmi_t17_mem_type_def = 24;
#[doc = "< Assign 25 to FBD2"]
pub const atom_dmi_t17_mem_type_def_Fbd2MemType: atom_dmi_t17_mem_type_def = 25;
#[doc = "< Assign 26 to DDR4"]
pub const atom_dmi_t17_mem_type_def_Ddr4MemType: atom_dmi_t17_mem_type_def = 26;
#[doc = "< Assign 27 to LPDDR"]
pub const atom_dmi_t17_mem_type_def_LpDdrMemType: atom_dmi_t17_mem_type_def = 27;
#[doc = "< Assign 28 to LPDDR2"]
pub const atom_dmi_t17_mem_type_def_LpDdr2MemType: atom_dmi_t17_mem_type_def = 28;
#[doc = "< Assign 29 to LPDDR3"]
pub const atom_dmi_t17_mem_type_def_LpDdr3MemType: atom_dmi_t17_mem_type_def = 29;
#[doc = "< Assign 30 to LPDDR4"]
pub const atom_dmi_t17_mem_type_def_LpDdr4MemType: atom_dmi_t17_mem_type_def = 30;
#[doc = "< Assign 31 to GDDR6"]
pub const atom_dmi_t17_mem_type_def_GDdr6MemType: atom_dmi_t17_mem_type_def = 31;
#[doc = "< Assign 32 to HBM"]
pub const atom_dmi_t17_mem_type_def_HbmMemType: atom_dmi_t17_mem_type_def = 32;
#[doc = "< Assign 33 to HBM2"]
pub const atom_dmi_t17_mem_type_def_Hbm2MemType: atom_dmi_t17_mem_type_def = 33;
#[doc = "< Assign 34 to DDR5"]
pub const atom_dmi_t17_mem_type_def_Ddr5MemType: atom_dmi_t17_mem_type_def = 34;
#[doc = "< Assign 35 to LPDDR5"]
pub const atom_dmi_t17_mem_type_def_LpDdr5MemType: atom_dmi_t17_mem_type_def = 35;
pub type atom_dmi_t17_mem_type_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_fusion_system_info_v4 {
    pub sysinfo: atom_integrated_system_info_v1_11,
    pub powerplayinfo: [u32; 256usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_fusion_system_info_v4"]
        [::core::mem::size_of::<atom_fusion_system_info_v4>() - 2048usize];
    ["Alignment of atom_fusion_system_info_v4"]
        [::core::mem::align_of::<atom_fusion_system_info_v4>() - 1usize];
    ["Offset of field: atom_fusion_system_info_v4::sysinfo"]
        [::core::mem::offset_of!(atom_fusion_system_info_v4, sysinfo) - 0usize];
    ["Offset of field: atom_fusion_system_info_v4::powerplayinfo"]
        [::core::mem::offset_of!(atom_fusion_system_info_v4, powerplayinfo) - 1024usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_2 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub max_tile_pipes: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v2_2"][::core::mem::size_of::<atom_gfx_info_v2_2>() - 44usize];
    ["Alignment of atom_gfx_info_v2_2"][::core::mem::align_of::<atom_gfx_info_v2_2>() - 1usize];
    ["Offset of field: atom_gfx_info_v2_2::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v2_2::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v2_2::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v2_2::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v2_2::max_tile_pipes"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_tile_pipes) - 7usize];
    ["Offset of field: atom_gfx_info_v2_2::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v2_2::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v2_2::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v2_2::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_src_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_src_addr) - 12usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_src_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_src_addr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_dst_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_dst_addr) - 20usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_dst_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_dst_addr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_status"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_status) - 32usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_rlc_gpu_clock_32"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_rlc_gpu_clock_32) - 36usize];
    ["Offset of field: atom_gfx_info_v2_2::rlc_gpu_timer_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, rlc_gpu_timer_refclk) - 40usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_3 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub max_tile_pipes: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
    pub active_cu_per_sh: u8,
    pub active_rb_per_se: u8,
    pub gcgoldenoffset: u16,
    pub rm21_sram_vmin_value: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v2_3"][::core::mem::size_of::<atom_gfx_info_v2_3>() - 52usize];
    ["Alignment of atom_gfx_info_v2_3"][::core::mem::align_of::<atom_gfx_info_v2_3>() - 1usize];
    ["Offset of field: atom_gfx_info_v2_3::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v2_3::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v2_3::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v2_3::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v2_3::max_tile_pipes"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_tile_pipes) - 7usize];
    ["Offset of field: atom_gfx_info_v2_3::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v2_3::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v2_3::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v2_3::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_src_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_src_addr) - 12usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_src_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_src_addr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_dst_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_dst_addr) - 20usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_dst_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_dst_addr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_status"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_status) - 32usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_rlc_gpu_clock_32"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_rlc_gpu_clock_32) - 36usize];
    ["Offset of field: atom_gfx_info_v2_3::rlc_gpu_timer_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, rlc_gpu_timer_refclk) - 40usize];
    ["Offset of field: atom_gfx_info_v2_3::active_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, active_cu_per_sh) - 44usize];
    ["Offset of field: atom_gfx_info_v2_3::active_rb_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, active_rb_per_se) - 45usize];
    ["Offset of field: atom_gfx_info_v2_3::gcgoldenoffset"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, gcgoldenoffset) - 46usize];
    ["Offset of field: atom_gfx_info_v2_3::rm21_sram_vmin_value"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, rm21_sram_vmin_value) - 48usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_4 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub reserved: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
    pub active_cu_per_sh: u8,
    pub active_rb_per_se: u8,
    pub gcgoldenoffset: u16,
    pub gc_num_gprs: u16,
    pub gc_gsprim_buff_depth: u16,
    pub gc_parameter_cache_depth: u16,
    pub gc_wave_size: u16,
    pub gc_max_waves_per_simd: u16,
    pub gc_lds_size: u16,
    pub gc_num_max_gs_thds: u8,
    pub gc_gs_table_depth: u8,
    pub gc_double_offchip_lds_buffer: u8,
    pub gc_max_scratch_slots_per_cu: u8,
    pub sram_rm_fuses_val: u32,
    pub sram_custom_rm_fuses_val: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v2_4"][::core::mem::size_of::<atom_gfx_info_v2_4>() - 72usize];
    ["Alignment of atom_gfx_info_v2_4"][::core::mem::align_of::<atom_gfx_info_v2_4>() - 1usize];
    ["Offset of field: atom_gfx_info_v2_4::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v2_4::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v2_4::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v2_4::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v2_4::reserved"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, reserved) - 7usize];
    ["Offset of field: atom_gfx_info_v2_4::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v2_4::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v2_4::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v2_4::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_src_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_src_addr) - 12usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_src_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_src_addr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_dst_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_dst_addr) - 20usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_dst_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_dst_addr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_status"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_status) - 32usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_rlc_gpu_clock_32"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_rlc_gpu_clock_32) - 36usize];
    ["Offset of field: atom_gfx_info_v2_4::rlc_gpu_timer_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, rlc_gpu_timer_refclk) - 40usize];
    ["Offset of field: atom_gfx_info_v2_4::active_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, active_cu_per_sh) - 44usize];
    ["Offset of field: atom_gfx_info_v2_4::active_rb_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, active_rb_per_se) - 45usize];
    ["Offset of field: atom_gfx_info_v2_4::gcgoldenoffset"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gcgoldenoffset) - 46usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_num_gprs"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_num_gprs) - 48usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_gsprim_buff_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_gsprim_buff_depth) - 50usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_parameter_cache_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_parameter_cache_depth) - 52usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_wave_size"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_wave_size) - 54usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_max_waves_per_simd"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_max_waves_per_simd) - 56usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_lds_size"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_lds_size) - 58usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_num_max_gs_thds"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_num_max_gs_thds) - 60usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_gs_table_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_gs_table_depth) - 61usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_double_offchip_lds_buffer"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_double_offchip_lds_buffer) - 62usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_max_scratch_slots_per_cu"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_max_scratch_slots_per_cu) - 63usize];
    ["Offset of field: atom_gfx_info_v2_4::sram_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, sram_rm_fuses_val) - 64usize];
    ["Offset of field: atom_gfx_info_v2_4::sram_custom_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, sram_custom_rm_fuses_val) - 68usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_7 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub reserved: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
    pub active_cu_per_sh: u8,
    pub active_rb_per_se: u8,
    pub gcgoldenoffset: u16,
    pub gc_num_gprs: u16,
    pub gc_gsprim_buff_depth: u16,
    pub gc_parameter_cache_depth: u16,
    pub gc_wave_size: u16,
    pub gc_max_waves_per_simd: u16,
    pub gc_lds_size: u16,
    pub gc_num_max_gs_thds: u8,
    pub gc_gs_table_depth: u8,
    pub gc_double_offchip_lds_buffer: u8,
    pub gc_max_scratch_slots_per_cu: u8,
    pub sram_rm_fuses_val: u32,
    pub sram_custom_rm_fuses_val: u32,
    pub cut_cu: u8,
    pub active_cu_total: u8,
    pub cu_reserved: [u8; 2usize],
    pub gc_config: u32,
    pub inactive_cu_per_se: [u8; 8usize],
    pub reserved2: [u32; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v2_7"][::core::mem::size_of::<atom_gfx_info_v2_7>() - 112usize];
    ["Alignment of atom_gfx_info_v2_7"][::core::mem::align_of::<atom_gfx_info_v2_7>() - 1usize];
    ["Offset of field: atom_gfx_info_v2_7::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v2_7::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v2_7::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v2_7::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v2_7::reserved"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, reserved) - 7usize];
    ["Offset of field: atom_gfx_info_v2_7::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v2_7::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v2_7::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v2_7::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_src_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_src_addr) - 12usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_src_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_src_addr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_dst_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_dst_addr) - 20usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_dst_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_dst_addr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_status"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_status) - 32usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_rlc_gpu_clock_32"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_rlc_gpu_clock_32) - 36usize];
    ["Offset of field: atom_gfx_info_v2_7::rlc_gpu_timer_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, rlc_gpu_timer_refclk) - 40usize];
    ["Offset of field: atom_gfx_info_v2_7::active_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, active_cu_per_sh) - 44usize];
    ["Offset of field: atom_gfx_info_v2_7::active_rb_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, active_rb_per_se) - 45usize];
    ["Offset of field: atom_gfx_info_v2_7::gcgoldenoffset"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gcgoldenoffset) - 46usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_num_gprs"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_num_gprs) - 48usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_gsprim_buff_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_gsprim_buff_depth) - 50usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_parameter_cache_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_parameter_cache_depth) - 52usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_wave_size"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_wave_size) - 54usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_max_waves_per_simd"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_max_waves_per_simd) - 56usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_lds_size"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_lds_size) - 58usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_num_max_gs_thds"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_num_max_gs_thds) - 60usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_gs_table_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_gs_table_depth) - 61usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_double_offchip_lds_buffer"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_double_offchip_lds_buffer) - 62usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_max_scratch_slots_per_cu"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_max_scratch_slots_per_cu) - 63usize];
    ["Offset of field: atom_gfx_info_v2_7::sram_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, sram_rm_fuses_val) - 64usize];
    ["Offset of field: atom_gfx_info_v2_7::sram_custom_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, sram_custom_rm_fuses_val) - 68usize];
    ["Offset of field: atom_gfx_info_v2_7::cut_cu"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, cut_cu) - 72usize];
    ["Offset of field: atom_gfx_info_v2_7::active_cu_total"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, active_cu_total) - 73usize];
    ["Offset of field: atom_gfx_info_v2_7::cu_reserved"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, cu_reserved) - 74usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_config"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_config) - 76usize];
    ["Offset of field: atom_gfx_info_v2_7::inactive_cu_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, inactive_cu_per_se) - 80usize];
    ["Offset of field: atom_gfx_info_v2_7::reserved2"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, reserved2) - 88usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v3_0 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub max_tile_pipes: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_lsdma_queue0_rb_rptr: u32,
    pub regaddr_lsdma_queue0_rb_rptr_hi: u32,
    pub regaddr_lsdma_queue0_rb_wptr: u32,
    pub regaddr_lsdma_queue0_rb_wptr_hi: u32,
    pub regaddr_lsdma_command: u32,
    pub regaddr_lsdma_status: u32,
    pub regaddr_golden_tsc_count_lower: u32,
    pub golden_tsc_count_lower_refclk: u32,
    pub active_wgp_per_se: u8,
    pub active_rb_per_se: u8,
    pub active_se: u8,
    pub reserved1: u8,
    pub sram_rm_fuses_val: u32,
    pub sram_custom_rm_fuses_val: u32,
    pub inactive_sa_mask: u32,
    pub gc_config: u32,
    pub inactive_wgp: [u8; 16usize],
    pub inactive_rb: [u8; 16usize],
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub reserved: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v3_0"][::core::mem::size_of::<atom_gfx_info_v3_0>() - 136usize];
    ["Alignment of atom_gfx_info_v3_0"][::core::mem::align_of::<atom_gfx_info_v3_0>() - 1usize];
    ["Offset of field: atom_gfx_info_v3_0::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v3_0::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v3_0::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v3_0::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v3_0::max_tile_pipes"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_tile_pipes) - 7usize];
    ["Offset of field: atom_gfx_info_v3_0::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v3_0::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v3_0::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v3_0::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_queue0_rb_rptr"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_queue0_rb_rptr) - 12usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_queue0_rb_rptr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_queue0_rb_rptr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_queue0_rb_wptr"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_queue0_rb_wptr) - 20usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_queue0_rb_wptr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_queue0_rb_wptr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_status"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_status) - 32usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_golden_tsc_count_lower"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_golden_tsc_count_lower) - 36usize];
    ["Offset of field: atom_gfx_info_v3_0::golden_tsc_count_lower_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, golden_tsc_count_lower_refclk) - 40usize];
    ["Offset of field: atom_gfx_info_v3_0::active_wgp_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, active_wgp_per_se) - 44usize];
    ["Offset of field: atom_gfx_info_v3_0::active_rb_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, active_rb_per_se) - 45usize];
    ["Offset of field: atom_gfx_info_v3_0::active_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, active_se) - 46usize];
    ["Offset of field: atom_gfx_info_v3_0::reserved1"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, reserved1) - 47usize];
    ["Offset of field: atom_gfx_info_v3_0::sram_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, sram_rm_fuses_val) - 48usize];
    ["Offset of field: atom_gfx_info_v3_0::sram_custom_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, sram_custom_rm_fuses_val) - 52usize];
    ["Offset of field: atom_gfx_info_v3_0::inactive_sa_mask"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, inactive_sa_mask) - 56usize];
    ["Offset of field: atom_gfx_info_v3_0::gc_config"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gc_config) - 60usize];
    ["Offset of field: atom_gfx_info_v3_0::inactive_wgp"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, inactive_wgp) - 64usize];
    ["Offset of field: atom_gfx_info_v3_0::inactive_rb"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, inactive_rb) - 80usize];
    ["Offset of field: atom_gfx_info_v3_0::gdfll_as_wait_ctrl_val"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gdfll_as_wait_ctrl_val) - 96usize];
    ["Offset of field: atom_gfx_info_v3_0::gdfll_as_step_ctrl_val"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gdfll_as_step_ctrl_val) - 100usize];
    ["Offset of field: atom_gfx_info_v3_0::reserved"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, reserved) - 104usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_1 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub smu_rsd1: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub ac_dc_gpio_bit: u8,
    pub ac_dc_polarity: u8,
    pub vr0hot_gpio_bit: u8,
    pub vr0hot_polarity: u8,
    pub vr1hot_gpio_bit: u8,
    pub vr1hot_polarity: u8,
    pub fw_ctf_gpio_bit: u8,
    pub fw_ctf_polarity: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_1"][::core::mem::size_of::<atom_smu_info_v3_1>() - 28usize];
    ["Alignment of atom_smu_info_v3_1"][::core::mem::align_of::<atom_smu_info_v3_1>() - 1usize];
    ["Offset of field: atom_smu_info_v3_1::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_1::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_1::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_1::smu_rsd1"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, smu_rsd1) - 6usize];
    ["Offset of field: atom_smu_info_v3_1::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_1::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_1::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_1::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_1::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_1::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_1::ac_dc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, ac_dc_gpio_bit) - 20usize];
    ["Offset of field: atom_smu_info_v3_1::ac_dc_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, ac_dc_polarity) - 21usize];
    ["Offset of field: atom_smu_info_v3_1::vr0hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, vr0hot_gpio_bit) - 22usize];
    ["Offset of field: atom_smu_info_v3_1::vr0hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, vr0hot_polarity) - 23usize];
    ["Offset of field: atom_smu_info_v3_1::vr1hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, vr1hot_gpio_bit) - 24usize];
    ["Offset of field: atom_smu_info_v3_1::vr1hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, vr1hot_polarity) - 25usize];
    ["Offset of field: atom_smu_info_v3_1::fw_ctf_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, fw_ctf_gpio_bit) - 26usize];
    ["Offset of field: atom_smu_info_v3_1::fw_ctf_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, fw_ctf_polarity) - 27usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_2 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub smu_rsd1: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub ac_dc_gpio_bit: u8,
    pub ac_dc_polarity: u8,
    pub vr0hot_gpio_bit: u8,
    pub vr0hot_polarity: u8,
    pub vr1hot_gpio_bit: u8,
    pub vr1hot_polarity: u8,
    pub fw_ctf_gpio_bit: u8,
    pub fw_ctf_polarity: u8,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub gpupll_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub reserved: [u32; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_2"][::core::mem::size_of::<atom_smu_info_v3_2>() - 84usize];
    ["Alignment of atom_smu_info_v3_2"][::core::mem::align_of::<atom_smu_info_v3_2>() - 1usize];
    ["Offset of field: atom_smu_info_v3_2::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_2::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_2::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_2::smu_rsd1"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, smu_rsd1) - 6usize];
    ["Offset of field: atom_smu_info_v3_2::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_2::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_2::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_2::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_2::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_2::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_2::ac_dc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, ac_dc_gpio_bit) - 20usize];
    ["Offset of field: atom_smu_info_v3_2::ac_dc_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, ac_dc_polarity) - 21usize];
    ["Offset of field: atom_smu_info_v3_2::vr0hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, vr0hot_gpio_bit) - 22usize];
    ["Offset of field: atom_smu_info_v3_2::vr0hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, vr0hot_polarity) - 23usize];
    ["Offset of field: atom_smu_info_v3_2::vr1hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, vr1hot_gpio_bit) - 24usize];
    ["Offset of field: atom_smu_info_v3_2::vr1hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, vr1hot_polarity) - 25usize];
    ["Offset of field: atom_smu_info_v3_2::fw_ctf_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, fw_ctf_gpio_bit) - 26usize];
    ["Offset of field: atom_smu_info_v3_2::fw_ctf_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, fw_ctf_polarity) - 27usize];
    ["Offset of field: atom_smu_info_v3_2::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v3_2::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v3_2::smugoldenoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, smugoldenoffset) - 30usize];
    ["Offset of field: atom_smu_info_v3_2::gpupll_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, gpupll_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_dcefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_dcefclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v3_2::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v3_2::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, reserved) - 64usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_3 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub waflclk_ss_mode: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub ac_dc_gpio_bit: u8,
    pub ac_dc_polarity: u8,
    pub vr0hot_gpio_bit: u8,
    pub vr0hot_polarity: u8,
    pub vr1hot_gpio_bit: u8,
    pub vr1hot_polarity: u8,
    pub fw_ctf_gpio_bit: u8,
    pub fw_ctf_polarity: u8,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub gpupll_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_0_vco_freq_10khz: u32,
    pub syspll3_1_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_3"][::core::mem::size_of::<atom_smu_info_v3_3>() - 92usize];
    ["Alignment of atom_smu_info_v3_3"][::core::mem::align_of::<atom_smu_info_v3_3>() - 1usize];
    ["Offset of field: atom_smu_info_v3_3::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_3::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_3::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_3::waflclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, waflclk_ss_mode) - 6usize];
    ["Offset of field: atom_smu_info_v3_3::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_3::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_3::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_3::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_3::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_3::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_3::ac_dc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, ac_dc_gpio_bit) - 20usize];
    ["Offset of field: atom_smu_info_v3_3::ac_dc_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, ac_dc_polarity) - 21usize];
    ["Offset of field: atom_smu_info_v3_3::vr0hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, vr0hot_gpio_bit) - 22usize];
    ["Offset of field: atom_smu_info_v3_3::vr0hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, vr0hot_polarity) - 23usize];
    ["Offset of field: atom_smu_info_v3_3::vr1hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, vr1hot_gpio_bit) - 24usize];
    ["Offset of field: atom_smu_info_v3_3::vr1hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, vr1hot_polarity) - 25usize];
    ["Offset of field: atom_smu_info_v3_3::fw_ctf_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, fw_ctf_gpio_bit) - 26usize];
    ["Offset of field: atom_smu_info_v3_3::fw_ctf_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, fw_ctf_polarity) - 27usize];
    ["Offset of field: atom_smu_info_v3_3::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v3_3::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v3_3::smugoldenoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smugoldenoffset) - 30usize];
    ["Offset of field: atom_smu_info_v3_3::gpupll_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, gpupll_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_dcefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_dcefclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v3_3::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v3_3::syspll3_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, syspll3_0_vco_freq_10khz) - 64usize];
    ["Offset of field: atom_smu_info_v3_3::syspll3_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, syspll3_1_vco_freq_10khz) - 68usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_fclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_fclk_10khz) - 72usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_waflclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_waflclk_10khz) - 76usize];
    ["Offset of field: atom_smu_info_v3_3::smu_info_caps"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smu_info_caps) - 80usize];
    ["Offset of field: atom_smu_info_v3_3::waflclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, waflclk_ss_percentage) - 84usize];
    ["Offset of field: atom_smu_info_v3_3::smuinitoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smuinitoffset) - 86usize];
    ["Offset of field: atom_smu_info_v3_3::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, reserved) - 88usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_5 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub waflclk_ss_mode: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub syspll0_1_vco_freq_10khz: u32,
    pub syspll0_2_vco_freq_10khz: u32,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub syspll0_0_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_0_vco_freq_10khz: u32,
    pub syspll3_1_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub bootup_dprefclk_10khz: u32,
    pub bootup_usbclk_10khz: u32,
    pub smb_slave_address: u32,
    pub cg_fdo_ctrl0_val: u32,
    pub cg_fdo_ctrl1_val: u32,
    pub cg_fdo_ctrl2_val: u32,
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub bootup_dtbclk_10khz: u32,
    pub fclk_syspll_refclk_10khz: u32,
    pub smusvi_svc0_val: u32,
    pub smusvi_svc1_val: u32,
    pub smusvi_svd0_val: u32,
    pub smusvi_svd1_val: u32,
    pub smusvi_svt0_val: u32,
    pub smusvi_svt1_val: u32,
    pub cg_tach_ctrl_val: u32,
    pub cg_pump_ctrl1_val: u32,
    pub cg_pump_tach_ctrl_val: u32,
    pub thm_ctf_delay_val: u32,
    pub thm_thermal_int_ctrl_val: u32,
    pub thm_tmon_config_val: u32,
    pub reserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_5"][::core::mem::size_of::<atom_smu_info_v3_5>() - 240usize];
    ["Alignment of atom_smu_info_v3_5"][::core::mem::align_of::<atom_smu_info_v3_5>() - 1usize];
    ["Offset of field: atom_smu_info_v3_5::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_5::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_5::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_5::waflclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, waflclk_ss_mode) - 6usize];
    ["Offset of field: atom_smu_info_v3_5::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_5::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_5::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_5::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_5::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_5::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_5::syspll0_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll0_1_vco_freq_10khz) - 20usize];
    ["Offset of field: atom_smu_info_v3_5::syspll0_2_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll0_2_vco_freq_10khz) - 24usize];
    ["Offset of field: atom_smu_info_v3_5::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v3_5::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v3_5::smugoldenoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smugoldenoffset) - 30usize];
    ["Offset of field: atom_smu_info_v3_5::syspll0_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll0_0_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_dcefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_dcefclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v3_5::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v3_5::syspll3_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll3_0_vco_freq_10khz) - 64usize];
    ["Offset of field: atom_smu_info_v3_5::syspll3_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll3_1_vco_freq_10khz) - 68usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_fclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_fclk_10khz) - 72usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_waflclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_waflclk_10khz) - 76usize];
    ["Offset of field: atom_smu_info_v3_5::smu_info_caps"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smu_info_caps) - 80usize];
    ["Offset of field: atom_smu_info_v3_5::waflclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, waflclk_ss_percentage) - 84usize];
    ["Offset of field: atom_smu_info_v3_5::smuinitoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smuinitoffset) - 86usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_dprefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_dprefclk_10khz) - 88usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_usbclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_usbclk_10khz) - 92usize];
    ["Offset of field: atom_smu_info_v3_5::smb_slave_address"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smb_slave_address) - 96usize];
    ["Offset of field: atom_smu_info_v3_5::cg_fdo_ctrl0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_fdo_ctrl0_val) - 100usize];
    ["Offset of field: atom_smu_info_v3_5::cg_fdo_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_fdo_ctrl1_val) - 104usize];
    ["Offset of field: atom_smu_info_v3_5::cg_fdo_ctrl2_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_fdo_ctrl2_val) - 108usize];
    ["Offset of field: atom_smu_info_v3_5::gdfll_as_wait_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gdfll_as_wait_ctrl_val) - 112usize];
    ["Offset of field: atom_smu_info_v3_5::gdfll_as_step_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gdfll_as_step_ctrl_val) - 116usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_dtbclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_dtbclk_10khz) - 120usize];
    ["Offset of field: atom_smu_info_v3_5::fclk_syspll_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, fclk_syspll_refclk_10khz) - 124usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svc0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svc0_val) - 128usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svc1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svc1_val) - 132usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svd0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svd0_val) - 136usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svd1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svd1_val) - 140usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svt0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svt0_val) - 144usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svt1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svt1_val) - 148usize];
    ["Offset of field: atom_smu_info_v3_5::cg_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_tach_ctrl_val) - 152usize];
    ["Offset of field: atom_smu_info_v3_5::cg_pump_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_pump_ctrl1_val) - 156usize];
    ["Offset of field: atom_smu_info_v3_5::cg_pump_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_pump_tach_ctrl_val) - 160usize];
    ["Offset of field: atom_smu_info_v3_5::thm_ctf_delay_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, thm_ctf_delay_val) - 164usize];
    ["Offset of field: atom_smu_info_v3_5::thm_thermal_int_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, thm_thermal_int_ctrl_val) - 168usize];
    ["Offset of field: atom_smu_info_v3_5::thm_tmon_config_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, thm_tmon_config_val) - 172usize];
    ["Offset of field: atom_smu_info_v3_5::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, reserved) - 176usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_6 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub waflclk_ss_mode: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub syspll0_1_vco_freq_10khz: u32,
    pub syspll0_2_vco_freq_10khz: u32,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub syspll0_0_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dxioclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_0_vco_freq_10khz: u32,
    pub syspll3_1_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub bootup_gfxavsclk_10khz: u32,
    pub bootup_mpioclk_10khz: u32,
    pub smb_slave_address: u32,
    pub cg_fdo_ctrl0_val: u32,
    pub cg_fdo_ctrl1_val: u32,
    pub cg_fdo_ctrl2_val: u32,
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub reserved_clk: u32,
    pub fclk_syspll_refclk_10khz: u32,
    pub smusvi_svc0_val: u32,
    pub smusvi_svc1_val: u32,
    pub smusvi_svd0_val: u32,
    pub smusvi_svd1_val: u32,
    pub smusvi_svt0_val: u32,
    pub smusvi_svt1_val: u32,
    pub cg_tach_ctrl_val: u32,
    pub cg_pump_ctrl1_val: u32,
    pub cg_pump_tach_ctrl_val: u32,
    pub thm_ctf_delay_val: u32,
    pub thm_thermal_int_ctrl_val: u32,
    pub thm_tmon_config_val: u32,
    pub bootup_vclk_10khz: u32,
    pub bootup_dclk_10khz: u32,
    pub smu_gpiopad_pu_en_val: u32,
    pub smu_gpiopad_pd_en_val: u32,
    pub reserved: [u32; 12usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_6"][::core::mem::size_of::<atom_smu_info_v3_6>() - 240usize];
    ["Alignment of atom_smu_info_v3_6"][::core::mem::align_of::<atom_smu_info_v3_6>() - 1usize];
    ["Offset of field: atom_smu_info_v3_6::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_6::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_6::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_6::waflclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, waflclk_ss_mode) - 6usize];
    ["Offset of field: atom_smu_info_v3_6::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_6::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_6::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_6::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_6::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_6::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_6::syspll0_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll0_1_vco_freq_10khz) - 20usize];
    ["Offset of field: atom_smu_info_v3_6::syspll0_2_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll0_2_vco_freq_10khz) - 24usize];
    ["Offset of field: atom_smu_info_v3_6::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v3_6::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v3_6::smugoldenoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smugoldenoffset) - 30usize];
    ["Offset of field: atom_smu_info_v3_6::syspll0_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll0_0_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_dxioclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_dxioclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v3_6::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v3_6::syspll3_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll3_0_vco_freq_10khz) - 64usize];
    ["Offset of field: atom_smu_info_v3_6::syspll3_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll3_1_vco_freq_10khz) - 68usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_fclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_fclk_10khz) - 72usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_waflclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_waflclk_10khz) - 76usize];
    ["Offset of field: atom_smu_info_v3_6::smu_info_caps"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smu_info_caps) - 80usize];
    ["Offset of field: atom_smu_info_v3_6::waflclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, waflclk_ss_percentage) - 84usize];
    ["Offset of field: atom_smu_info_v3_6::smuinitoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smuinitoffset) - 86usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_gfxavsclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_gfxavsclk_10khz) - 88usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_mpioclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_mpioclk_10khz) - 92usize];
    ["Offset of field: atom_smu_info_v3_6::smb_slave_address"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smb_slave_address) - 96usize];
    ["Offset of field: atom_smu_info_v3_6::cg_fdo_ctrl0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_fdo_ctrl0_val) - 100usize];
    ["Offset of field: atom_smu_info_v3_6::cg_fdo_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_fdo_ctrl1_val) - 104usize];
    ["Offset of field: atom_smu_info_v3_6::cg_fdo_ctrl2_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_fdo_ctrl2_val) - 108usize];
    ["Offset of field: atom_smu_info_v3_6::gdfll_as_wait_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gdfll_as_wait_ctrl_val) - 112usize];
    ["Offset of field: atom_smu_info_v3_6::gdfll_as_step_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gdfll_as_step_ctrl_val) - 116usize];
    ["Offset of field: atom_smu_info_v3_6::reserved_clk"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, reserved_clk) - 120usize];
    ["Offset of field: atom_smu_info_v3_6::fclk_syspll_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, fclk_syspll_refclk_10khz) - 124usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svc0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svc0_val) - 128usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svc1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svc1_val) - 132usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svd0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svd0_val) - 136usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svd1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svd1_val) - 140usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svt0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svt0_val) - 144usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svt1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svt1_val) - 148usize];
    ["Offset of field: atom_smu_info_v3_6::cg_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_tach_ctrl_val) - 152usize];
    ["Offset of field: atom_smu_info_v3_6::cg_pump_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_pump_ctrl1_val) - 156usize];
    ["Offset of field: atom_smu_info_v3_6::cg_pump_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_pump_tach_ctrl_val) - 160usize];
    ["Offset of field: atom_smu_info_v3_6::thm_ctf_delay_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, thm_ctf_delay_val) - 164usize];
    ["Offset of field: atom_smu_info_v3_6::thm_thermal_int_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, thm_thermal_int_ctrl_val) - 168usize];
    ["Offset of field: atom_smu_info_v3_6::thm_tmon_config_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, thm_tmon_config_val) - 172usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_vclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_vclk_10khz) - 176usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_dclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_dclk_10khz) - 180usize];
    ["Offset of field: atom_smu_info_v3_6::smu_gpiopad_pu_en_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smu_gpiopad_pu_en_val) - 184usize];
    ["Offset of field: atom_smu_info_v3_6::smu_gpiopad_pd_en_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smu_gpiopad_pd_en_val) - 188usize];
    ["Offset of field: atom_smu_info_v3_6::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, reserved) - 192usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v4_0 {
    pub table_header: atom_common_table_header,
    pub bootup_gfxclk_bypass_10khz: u32,
    pub bootup_usrclk_10khz: u32,
    pub bootup_csrclk_10khz: u32,
    pub core_refclk_10khz: u32,
    pub syspll1_vco_freq_10khz: u32,
    pub syspll2_vco_freq_10khz: u32,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub bootup_vddusr_mv: u16,
    pub syspll0_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_vco_freq_10khz: u32,
    pub mm_syspll_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub bootup_dprefclk_10khz: u32,
    pub bootup_usbclk_10khz: u32,
    pub smb_slave_address: u32,
    pub cg_fdo_ctrl0_val: u32,
    pub cg_fdo_ctrl1_val: u32,
    pub cg_fdo_ctrl2_val: u32,
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub bootup_dtbclk_10khz: u32,
    pub fclk_syspll_refclk_10khz: u32,
    pub smusvi_svc0_val: u32,
    pub smusvi_svc1_val: u32,
    pub smusvi_svd0_val: u32,
    pub smusvi_svd1_val: u32,
    pub smusvi_svt0_val: u32,
    pub smusvi_svt1_val: u32,
    pub cg_tach_ctrl_val: u32,
    pub cg_pump_ctrl1_val: u32,
    pub cg_pump_tach_ctrl_val: u32,
    pub thm_ctf_delay_val: u32,
    pub thm_thermal_int_ctrl_val: u32,
    pub thm_tmon_config_val: u32,
    pub smbus_timing_cntrl0_val: u32,
    pub smbus_timing_cntrl1_val: u32,
    pub smbus_timing_cntrl2_val: u32,
    pub pwr_disp_timer_global_control_val: u32,
    pub bootup_mpioclk_10khz: u32,
    pub bootup_dclk0_10khz: u32,
    pub bootup_vclk0_10khz: u32,
    pub bootup_dclk1_10khz: u32,
    pub bootup_vclk1_10khz: u32,
    pub bootup_baco400clk_10khz: u32,
    pub bootup_baco1200clk_bypass_10khz: u32,
    pub bootup_baco700clk_bypass_10khz: u32,
    pub reserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v4_0"][::core::mem::size_of::<atom_smu_info_v4_0>() - 288usize];
    ["Alignment of atom_smu_info_v4_0"][::core::mem::align_of::<atom_smu_info_v4_0>() - 1usize];
    ["Offset of field: atom_smu_info_v4_0::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_gfxclk_bypass_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_gfxclk_bypass_10khz) - 4usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_usrclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_usrclk_10khz) - 8usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_csrclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_csrclk_10khz) - 12usize];
    ["Offset of field: atom_smu_info_v4_0::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v4_0::syspll1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, syspll1_vco_freq_10khz) - 20usize];
    ["Offset of field: atom_smu_info_v4_0::syspll2_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, syspll2_vco_freq_10khz) - 24usize];
    ["Offset of field: atom_smu_info_v4_0::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v4_0::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_vddusr_mv"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_vddusr_mv) - 30usize];
    ["Offset of field: atom_smu_info_v4_0::syspll0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, syspll0_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dcefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dcefclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v4_0::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v4_0::syspll3_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, syspll3_vco_freq_10khz) - 64usize];
    ["Offset of field: atom_smu_info_v4_0::mm_syspll_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, mm_syspll_vco_freq_10khz) - 68usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_fclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_fclk_10khz) - 72usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_waflclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_waflclk_10khz) - 76usize];
    ["Offset of field: atom_smu_info_v4_0::smu_info_caps"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smu_info_caps) - 80usize];
    ["Offset of field: atom_smu_info_v4_0::waflclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, waflclk_ss_percentage) - 84usize];
    ["Offset of field: atom_smu_info_v4_0::smuinitoffset"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smuinitoffset) - 86usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dprefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dprefclk_10khz) - 88usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_usbclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_usbclk_10khz) - 92usize];
    ["Offset of field: atom_smu_info_v4_0::smb_slave_address"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smb_slave_address) - 96usize];
    ["Offset of field: atom_smu_info_v4_0::cg_fdo_ctrl0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_fdo_ctrl0_val) - 100usize];
    ["Offset of field: atom_smu_info_v4_0::cg_fdo_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_fdo_ctrl1_val) - 104usize];
    ["Offset of field: atom_smu_info_v4_0::cg_fdo_ctrl2_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_fdo_ctrl2_val) - 108usize];
    ["Offset of field: atom_smu_info_v4_0::gdfll_as_wait_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, gdfll_as_wait_ctrl_val) - 112usize];
    ["Offset of field: atom_smu_info_v4_0::gdfll_as_step_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, gdfll_as_step_ctrl_val) - 116usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dtbclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dtbclk_10khz) - 120usize];
    ["Offset of field: atom_smu_info_v4_0::fclk_syspll_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, fclk_syspll_refclk_10khz) - 124usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svc0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svc0_val) - 128usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svc1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svc1_val) - 132usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svd0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svd0_val) - 136usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svd1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svd1_val) - 140usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svt0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svt0_val) - 144usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svt1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svt1_val) - 148usize];
    ["Offset of field: atom_smu_info_v4_0::cg_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_tach_ctrl_val) - 152usize];
    ["Offset of field: atom_smu_info_v4_0::cg_pump_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_pump_ctrl1_val) - 156usize];
    ["Offset of field: atom_smu_info_v4_0::cg_pump_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_pump_tach_ctrl_val) - 160usize];
    ["Offset of field: atom_smu_info_v4_0::thm_ctf_delay_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, thm_ctf_delay_val) - 164usize];
    ["Offset of field: atom_smu_info_v4_0::thm_thermal_int_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, thm_thermal_int_ctrl_val) - 168usize];
    ["Offset of field: atom_smu_info_v4_0::thm_tmon_config_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, thm_tmon_config_val) - 172usize];
    ["Offset of field: atom_smu_info_v4_0::smbus_timing_cntrl0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smbus_timing_cntrl0_val) - 176usize];
    ["Offset of field: atom_smu_info_v4_0::smbus_timing_cntrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smbus_timing_cntrl1_val) - 180usize];
    ["Offset of field: atom_smu_info_v4_0::smbus_timing_cntrl2_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smbus_timing_cntrl2_val) - 184usize];
    ["Offset of field: atom_smu_info_v4_0::pwr_disp_timer_global_control_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, pwr_disp_timer_global_control_val) - 188usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_mpioclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_mpioclk_10khz) - 192usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dclk0_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dclk0_10khz) - 196usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_vclk0_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_vclk0_10khz) - 200usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dclk1_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dclk1_10khz) - 204usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_vclk1_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_vclk1_10khz) - 208usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_baco400clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_baco400clk_10khz) - 212usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_baco1200clk_bypass_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_baco1200clk_bypass_10khz) - 216usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_baco700clk_bypass_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_baco700clk_bypass_10khz) - 220usize];
    ["Offset of field: atom_smu_info_v4_0::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, reserved) - 224usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub liquid1_i2c_address: u8,
    pub liquid2_i2c_address: u8,
    pub vr_i2c_address: u8,
    pub plx_i2c_address: u8,
    pub liquid_i2c_linescl: u8,
    pub liquid_i2c_linesda: u8,
    pub vr_i2c_linescl: u8,
    pub vr_i2c_linesda: u8,
    pub plx_i2c_linescl: u8,
    pub plx_i2c_linesda: u8,
    pub vrsensorpresent: u8,
    pub liquidsensorpresent: u8,
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmem0vrmapping: u8,
    pub vddmem1vrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub soculvphasesheddingmask: u8,
    pub padding8_v: [u8; 2usize],
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub mem0maxcurrent: u16,
    pub mem0offset: u8,
    pub padding_telemetrymem0: u8,
    pub mem1maxcurrent: u16,
    pub mem1offset: u8,
    pub padding_telemetrymem1: u8,
    pub acdcgpio: u8,
    pub acdcpolarity: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub padding1: u8,
    pub padding2: u8,
    pub ledpin0: u8,
    pub ledpin1: u8,
    pub ledpin2: u8,
    pub padding8_4: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub socclkspreadenabled: u8,
    pub socclkspreadpercent: u8,
    pub socclkspreadfreq: u16,
    pub acggfxclkspreadenabled: u8,
    pub acggfxclkspreadpercent: u8,
    pub acggfxclkspreadfreq: u16,
    pub Vr2_I2C_address: u8,
    pub padding_vr2: [u8; 3usize],
    pub boardreserved: [u32; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_1"][::core::mem::size_of::<atom_smc_dpm_info_v4_1>() - 112usize];
    ["Alignment of atom_smc_dpm_info_v4_1"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_1>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquid1_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquid1_i2c_address) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquid2_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquid2_i2c_address) - 5usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr_i2c_address) - 6usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::plx_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, plx_i2c_address) - 7usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquid_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquid_i2c_linescl) - 8usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquid_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquid_i2c_linesda) - 9usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr_i2c_linescl) - 10usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr_i2c_linesda) - 11usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::plx_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, plx_i2c_linescl) - 12usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::plx_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, plx_i2c_linesda) - 13usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vrsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vrsensorpresent) - 14usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquidsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquidsensorpresent) - 15usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::maxvoltagestepgfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, maxvoltagestepgfx) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::maxvoltagestepsoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, maxvoltagestepsoc) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vddgfxvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vddgfxvrmapping) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vddsocvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vddsocvrmapping) - 21usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vddmem0vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vddmem0vrmapping) - 22usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vddmem1vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vddmem1vrmapping) - 23usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::gfxulvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, gfxulvphasesheddingmask) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::soculvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, soculvphasesheddingmask) - 25usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding8_v"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding8_v) - 26usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::gfxmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, gfxmaxcurrent) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::gfxoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, gfxoffset) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_telemetrygfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_telemetrygfx) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socmaxcurrent) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socoffset) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_telemetrysoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_telemetrysoc) - 35usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::mem0maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, mem0maxcurrent) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::mem0offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, mem0offset) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_telemetrymem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_telemetrymem0) - 39usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::mem1maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, mem1maxcurrent) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::mem1offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, mem1offset) - 42usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_telemetrymem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_telemetrymem1) - 43usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acdcgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acdcgpio) - 44usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acdcpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acdcpolarity) - 45usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr0hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr0hotgpio) - 46usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr0hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr0hotpolarity) - 47usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr1hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr1hotgpio) - 48usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr1hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr1hotpolarity) - 49usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding1) - 50usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding2) - 51usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::ledpin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, ledpin0) - 52usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::ledpin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, ledpin1) - 53usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::ledpin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, ledpin2) - 54usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding8_4) - 55usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::pllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, pllgfxclkspreadenabled) - 56usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::pllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, pllgfxclkspreadpercent) - 57usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::pllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, pllgfxclkspreadfreq) - 58usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::uclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, uclkspreadenabled) - 60usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::uclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, uclkspreadpercent) - 61usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::uclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, uclkspreadfreq) - 62usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socclkspreadenabled) - 64usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socclkspreadpercent) - 65usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socclkspreadfreq) - 66usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acggfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acggfxclkspreadenabled) - 68usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acggfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acggfxclkspreadpercent) - 69usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acggfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acggfxclkspreadfreq) - 70usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::Vr2_I2C_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, Vr2_I2C_address) - 72usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_vr2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_vr2) - 73usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::boardreserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, boardreserved) - 76usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_3 {
    pub table_header: atom_common_table_header,
    pub liquid1_i2c_address: u8,
    pub liquid2_i2c_address: u8,
    pub vr_i2c_address: u8,
    pub plx_i2c_address: u8,
    pub liquid_i2c_linescl: u8,
    pub liquid_i2c_linesda: u8,
    pub vr_i2c_linescl: u8,
    pub vr_i2c_linesda: u8,
    pub plx_i2c_linescl: u8,
    pub plx_i2c_linesda: u8,
    pub vrsensorpresent: u8,
    pub liquidsensorpresent: u8,
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmem0vrmapping: u8,
    pub vddmem1vrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub soculvphasesheddingmask: u8,
    pub externalsensorpresent: u8,
    pub padding8_v: u8,
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub mem0maxcurrent: u16,
    pub mem0offset: u8,
    pub padding_telemetrymem0: u8,
    pub mem1maxcurrent: u16,
    pub mem1offset: u8,
    pub padding_telemetrymem1: u8,
    pub acdcgpio: u8,
    pub acdcpolarity: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub padding1: u8,
    pub padding2: u8,
    pub ledpin0: u8,
    pub ledpin1: u8,
    pub ledpin2: u8,
    pub padding8_4: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub fclkspreadenabled: u8,
    pub fclkspreadpercent: u8,
    pub fclkspreadfreq: u16,
    pub fllgfxclkspreadenabled: u8,
    pub fllgfxclkspreadpercent: u8,
    pub fllgfxclkspreadfreq: u16,
    pub boardreserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_3"][::core::mem::size_of::<atom_smc_dpm_info_v4_3>() - 112usize];
    ["Alignment of atom_smc_dpm_info_v4_3"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_3>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquid1_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquid1_i2c_address) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquid2_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquid2_i2c_address) - 5usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr_i2c_address) - 6usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::plx_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, plx_i2c_address) - 7usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquid_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquid_i2c_linescl) - 8usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquid_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquid_i2c_linesda) - 9usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr_i2c_linescl) - 10usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr_i2c_linesda) - 11usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::plx_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, plx_i2c_linescl) - 12usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::plx_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, plx_i2c_linesda) - 13usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vrsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vrsensorpresent) - 14usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquidsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquidsensorpresent) - 15usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::maxvoltagestepgfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, maxvoltagestepgfx) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::maxvoltagestepsoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, maxvoltagestepsoc) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vddgfxvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vddgfxvrmapping) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vddsocvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vddsocvrmapping) - 21usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vddmem0vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vddmem0vrmapping) - 22usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vddmem1vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vddmem1vrmapping) - 23usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::gfxulvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, gfxulvphasesheddingmask) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::soculvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, soculvphasesheddingmask) - 25usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::externalsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, externalsensorpresent) - 26usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding8_v"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding8_v) - 27usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::gfxmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, gfxmaxcurrent) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::gfxoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, gfxoffset) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding_telemetrygfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding_telemetrygfx) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::socmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, socmaxcurrent) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::socoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, socoffset) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding_telemetrysoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding_telemetrysoc) - 35usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::mem0maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, mem0maxcurrent) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::mem0offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, mem0offset) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding_telemetrymem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding_telemetrymem0) - 39usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::mem1maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, mem1maxcurrent) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::mem1offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, mem1offset) - 42usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding_telemetrymem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding_telemetrymem1) - 43usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::acdcgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, acdcgpio) - 44usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::acdcpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, acdcpolarity) - 45usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr0hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr0hotgpio) - 46usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr0hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr0hotpolarity) - 47usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr1hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr1hotgpio) - 48usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr1hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr1hotpolarity) - 49usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding1) - 50usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding2) - 51usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::ledpin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, ledpin0) - 52usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::ledpin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, ledpin1) - 53usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::ledpin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, ledpin2) - 54usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding8_4) - 55usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::pllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, pllgfxclkspreadenabled) - 56usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::pllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, pllgfxclkspreadpercent) - 57usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::pllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, pllgfxclkspreadfreq) - 58usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::uclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, uclkspreadenabled) - 60usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::uclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, uclkspreadpercent) - 61usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::uclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, uclkspreadfreq) - 62usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fclkspreadenabled) - 64usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fclkspreadpercent) - 65usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fclkspreadfreq) - 66usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fllgfxclkspreadenabled) - 68usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fllgfxclkspreadpercent) - 69usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fllgfxclkspreadfreq) - 70usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::boardreserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, boardreserved) - 72usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smudpm_i2ccontrollerconfig_t {
    pub enabled: u32,
    pub slaveaddress: u32,
    pub controllerport: u32,
    pub controllername: u32,
    pub thermalthrottler: u32,
    pub i2cprotocol: u32,
    pub i2cspeed: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smudpm_i2ccontrollerconfig_t"]
        [::core::mem::size_of::<smudpm_i2ccontrollerconfig_t>() - 28usize];
    ["Alignment of smudpm_i2ccontrollerconfig_t"]
        [::core::mem::align_of::<smudpm_i2ccontrollerconfig_t>() - 1usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::enabled"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, enabled) - 0usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::slaveaddress"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, slaveaddress) - 4usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::controllerport"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, controllerport) - 8usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::controllername"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, controllername) - 12usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::thermalthrottler"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, thermalthrottler) - 16usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::i2cprotocol"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, i2cprotocol) - 20usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::i2cspeed"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, i2cspeed) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_4 {
    pub table_header: atom_common_table_header,
    pub i2c_padding: [u32; 3usize],
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmem0vrmapping: u8,
    pub vddmem1vrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub soculvphasesheddingmask: u8,
    pub externalsensorpresent: u8,
    pub padding8_v: u8,
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub mem0maxcurrent: u16,
    pub mem0offset: u8,
    pub padding_telemetrymem0: u8,
    pub mem1maxcurrent: u16,
    pub mem1offset: u8,
    pub padding_telemetrymem1: u8,
    pub acdcgpio: u8,
    pub acdcpolarity: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub padding1: u8,
    pub padding2: u8,
    pub ledpin0: u8,
    pub ledpin1: u8,
    pub ledpin2: u8,
    pub padding8_4: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub fclkspreadenabled: u8,
    pub fclkspreadpercent: u8,
    pub fclkspreadfreq: u16,
    pub fllgfxclkspreadenabled: u8,
    pub fllgfxclkspreadpercent: u8,
    pub fllgfxclkspreadfreq: u16,
    pub i2ccontrollers: [smudpm_i2ccontrollerconfig_t; 7usize],
    pub boardreserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_4"][::core::mem::size_of::<atom_smc_dpm_info_v4_4>() - 308usize];
    ["Alignment of atom_smc_dpm_info_v4_4"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_4>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::i2c_padding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, i2c_padding) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::maxvoltagestepgfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, maxvoltagestepgfx) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::maxvoltagestepsoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, maxvoltagestepsoc) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vddgfxvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vddgfxvrmapping) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vddsocvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vddsocvrmapping) - 21usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vddmem0vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vddmem0vrmapping) - 22usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vddmem1vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vddmem1vrmapping) - 23usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::gfxulvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, gfxulvphasesheddingmask) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::soculvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, soculvphasesheddingmask) - 25usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::externalsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, externalsensorpresent) - 26usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding8_v"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding8_v) - 27usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::gfxmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, gfxmaxcurrent) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::gfxoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, gfxoffset) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding_telemetrygfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding_telemetrygfx) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::socmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, socmaxcurrent) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::socoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, socoffset) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding_telemetrysoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding_telemetrysoc) - 35usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::mem0maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, mem0maxcurrent) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::mem0offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, mem0offset) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding_telemetrymem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding_telemetrymem0) - 39usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::mem1maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, mem1maxcurrent) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::mem1offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, mem1offset) - 42usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding_telemetrymem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding_telemetrymem1) - 43usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::acdcgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, acdcgpio) - 44usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::acdcpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, acdcpolarity) - 45usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vr0hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vr0hotgpio) - 46usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vr0hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vr0hotpolarity) - 47usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vr1hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vr1hotgpio) - 48usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vr1hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vr1hotpolarity) - 49usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding1) - 50usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding2) - 51usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::ledpin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, ledpin0) - 52usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::ledpin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, ledpin1) - 53usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::ledpin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, ledpin2) - 54usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding8_4) - 55usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::pllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, pllgfxclkspreadenabled) - 56usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::pllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, pllgfxclkspreadpercent) - 57usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::pllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, pllgfxclkspreadfreq) - 58usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::uclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, uclkspreadenabled) - 60usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::uclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, uclkspreadpercent) - 61usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::uclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, uclkspreadfreq) - 62usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fclkspreadenabled) - 64usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fclkspreadpercent) - 65usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fclkspreadfreq) - 66usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fllgfxclkspreadenabled) - 68usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fllgfxclkspreadpercent) - 69usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fllgfxclkspreadfreq) - 70usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::i2ccontrollers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, i2ccontrollers) - 72usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::boardreserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, boardreserved) - 268usize];
};
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_GFX:
    smudpm_v4_5_i2ccontrollername_e = 0;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_SOC:
    smudpm_v4_5_i2ccontrollername_e = 1;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_VDDCI:
    smudpm_v4_5_i2ccontrollername_e = 2;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_MVDD:
    smudpm_v4_5_i2ccontrollername_e = 3;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_LIQUID0:
    smudpm_v4_5_i2ccontrollername_e = 4;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_LIQUID1:
    smudpm_v4_5_i2ccontrollername_e = 5;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_PLX:
    smudpm_v4_5_i2ccontrollername_e = 6;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_SPARE:
    smudpm_v4_5_i2ccontrollername_e = 7;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_COUNT:
    smudpm_v4_5_i2ccontrollername_e = 8;
pub type smudpm_v4_5_i2ccontrollername_e = ::core::ffi::c_uint;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_TYPE_NONE:
    smudpm_v4_5_i2ccontrollerthrottler_e = 0;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_GFX:
    smudpm_v4_5_i2ccontrollerthrottler_e = 1;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_SOC:
    smudpm_v4_5_i2ccontrollerthrottler_e = 2;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_VDDCI:
    smudpm_v4_5_i2ccontrollerthrottler_e = 3;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_MVDD:
    smudpm_v4_5_i2ccontrollerthrottler_e = 4;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_LIQUID0:
    smudpm_v4_5_i2ccontrollerthrottler_e = 5;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_LIQUID1:
    smudpm_v4_5_i2ccontrollerthrottler_e = 6;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_PLX:
    smudpm_v4_5_i2ccontrollerthrottler_e = 7;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_COUNT:
    smudpm_v4_5_i2ccontrollerthrottler_e = 8;
pub type smudpm_v4_5_i2ccontrollerthrottler_e = ::core::ffi::c_uint;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_VR_0:
    smudpm_v4_5_i2ccontrollerprotocol_e = 0;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_VR_1:
    smudpm_v4_5_i2ccontrollerprotocol_e = 1;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_TMP_0:
    smudpm_v4_5_i2ccontrollerprotocol_e = 2;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_TMP_1:
    smudpm_v4_5_i2ccontrollerprotocol_e = 3;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_SPARE_0:
    smudpm_v4_5_i2ccontrollerprotocol_e = 4;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_SPARE_1:
    smudpm_v4_5_i2ccontrollerprotocol_e = 5;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_COUNT:
    smudpm_v4_5_i2ccontrollerprotocol_e = 6;
pub type smudpm_v4_5_i2ccontrollerprotocol_e = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smudpm_i2c_controller_config_v2 {
    pub Enabled: u8,
    pub Speed: u8,
    pub Padding: [u8; 2usize],
    pub SlaveAddress: u32,
    pub ControllerPort: u8,
    pub ControllerName: u8,
    pub ThermalThrotter: u8,
    pub I2cProtocol: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smudpm_i2c_controller_config_v2"]
        [::core::mem::size_of::<smudpm_i2c_controller_config_v2>() - 12usize];
    ["Alignment of smudpm_i2c_controller_config_v2"]
        [::core::mem::align_of::<smudpm_i2c_controller_config_v2>() - 1usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::Enabled"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, Enabled) - 0usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::Speed"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, Speed) - 1usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::Padding"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, Padding) - 2usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::SlaveAddress"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, SlaveAddress) - 4usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::ControllerPort"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, ControllerPort) - 8usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::ControllerName"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, ControllerName) - 9usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::ThermalThrotter"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, ThermalThrotter) - 10usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::I2cProtocol"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, I2cProtocol) - 11usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_5 {
    pub table_header: atom_common_table_header,
    pub I2cControllers: [smudpm_i2c_controller_config_v2; 8usize],
    pub MaxVoltageStepGfx: u16,
    pub MaxVoltageStepSoc: u16,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub ExternalSensorPresent: u8,
    pub Padding8_V: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: u8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: u8,
    pub Padding_TelemetryMem1: u8,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub padding8_4: u8,
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub SoclkSpreadEnabled: u8,
    pub SocclkSpreadPercent: u8,
    pub SocclkSpreadFreq: u16,
    pub TotalBoardPower: u16,
    pub BoardPadding: u16,
    pub MvddRatio: u32,
    pub BoardReserved: [u32; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_5"][::core::mem::size_of::<atom_smc_dpm_info_v4_5>() - 200usize];
    ["Alignment of atom_smc_dpm_info_v4_5"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_5>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::I2cControllers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, I2cControllers) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::MaxVoltageStepGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, MaxVoltageStepGfx) - 100usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::MaxVoltageStepSoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, MaxVoltageStepSoc) - 102usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VddGfxVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VddGfxVrMapping) - 104usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VddSocVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VddSocVrMapping) - 105usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VddMem0VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VddMem0VrMapping) - 106usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VddMem1VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VddMem1VrMapping) - 107usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GfxUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GfxUlvPhaseSheddingMask) - 108usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocUlvPhaseSheddingMask) - 109usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::ExternalSensorPresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, ExternalSensorPresent) - 110usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding8_V"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding8_V) - 111usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GfxMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GfxMaxCurrent) - 112usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GfxOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GfxOffset) - 114usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding_TelemetryGfx) - 115usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocMaxCurrent) - 116usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocOffset) - 118usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding_TelemetrySoc) - 119usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Mem0MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Mem0MaxCurrent) - 120usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Mem0Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Mem0Offset) - 122usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding_TelemetryMem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding_TelemetryMem0) - 123usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Mem1MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Mem1MaxCurrent) - 124usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Mem1Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Mem1Offset) - 126usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding_TelemetryMem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding_TelemetryMem1) - 127usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::AcDcGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, AcDcGpio) - 128usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::AcDcPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, AcDcPolarity) - 129usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VR0HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VR0HotGpio) - 130usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VR0HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VR0HotPolarity) - 131usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VR1HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VR1HotGpio) - 132usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VR1HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VR1HotPolarity) - 133usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GthrGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GthrGpio) - 134usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GthrPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GthrPolarity) - 135usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::LedPin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, LedPin0) - 136usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::LedPin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, LedPin1) - 137usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::LedPin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, LedPin2) - 138usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, padding8_4) - 139usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::PllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, PllGfxclkSpreadEnabled) - 140usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::PllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, PllGfxclkSpreadPercent) - 141usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::PllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, PllGfxclkSpreadFreq) - 142usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::DfllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, DfllGfxclkSpreadEnabled) - 144usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::DfllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, DfllGfxclkSpreadPercent) - 145usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::DfllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, DfllGfxclkSpreadFreq) - 146usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::UclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, UclkSpreadEnabled) - 148usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::UclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, UclkSpreadPercent) - 149usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::UclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, UclkSpreadFreq) - 150usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SoclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SoclkSpreadEnabled) - 152usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocclkSpreadPercent) - 153usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocclkSpreadFreq) - 154usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::TotalBoardPower"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, TotalBoardPower) - 156usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::BoardPadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, BoardPadding) - 158usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::MvddRatio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, MvddRatio) - 160usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::BoardReserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, BoardReserved) - 164usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_6 {
    pub table_header: atom_common_table_header,
    pub i2c_padding: [u32; 3usize],
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmemvrmapping: u8,
    pub boardvrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub externalsensorpresent: u8,
    pub padding8_v: [u8; 2usize],
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub memmaxcurrent: u16,
    pub memoffset: u8,
    pub padding_telemetrymem: u8,
    pub boardmaxcurrent: u16,
    pub boardoffset: u8,
    pub padding_telemetryboardinput: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub fclkspreadenabled: u8,
    pub fclkspreadpercent: u8,
    pub fclkspreadfreq: u16,
    pub fllgfxclkspreadenabled: u8,
    pub fllgfxclkspreadpercent: u8,
    pub fllgfxclkspreadfreq: u16,
    pub i2ccontrollers: [smudpm_i2c_controller_config_v2; 8usize],
    pub memorychannelenabled: u32,
    pub drambitwidth: u8,
    pub paddingmem: [u8; 3usize],
    pub totalboardpower: u16,
    pub boardpadding: u16,
    pub xgmilinkspeed: [u8; 4usize],
    pub xgmilinkwidth: [u8; 4usize],
    pub xgmifclkfreq: [u16; 4usize],
    pub xgmisocvoltage: [u16; 4usize],
    pub boardreserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_6"][::core::mem::size_of::<atom_smc_dpm_info_v4_6>() - 236usize];
    ["Alignment of atom_smc_dpm_info_v4_6"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_6>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::i2c_padding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, i2c_padding) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::maxvoltagestepgfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, maxvoltagestepgfx) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::maxvoltagestepsoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, maxvoltagestepsoc) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vddgfxvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vddgfxvrmapping) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vddsocvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vddsocvrmapping) - 21usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vddmemvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vddmemvrmapping) - 22usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardvrmapping) - 23usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::gfxulvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, gfxulvphasesheddingmask) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::externalsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, externalsensorpresent) - 25usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding8_v"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding8_v) - 26usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::gfxmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, gfxmaxcurrent) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::gfxoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, gfxoffset) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding_telemetrygfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding_telemetrygfx) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::socmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, socmaxcurrent) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::socoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, socoffset) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding_telemetrysoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding_telemetrysoc) - 35usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::memmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, memmaxcurrent) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::memoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, memoffset) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding_telemetrymem"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding_telemetrymem) - 39usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardmaxcurrent) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardoffset) - 42usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding_telemetryboardinput"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding_telemetryboardinput) - 43usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vr0hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vr0hotgpio) - 44usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vr0hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vr0hotpolarity) - 45usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vr1hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vr1hotgpio) - 46usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vr1hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vr1hotpolarity) - 47usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::pllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, pllgfxclkspreadenabled) - 48usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::pllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, pllgfxclkspreadpercent) - 49usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::pllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, pllgfxclkspreadfreq) - 50usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::uclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, uclkspreadenabled) - 52usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::uclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, uclkspreadpercent) - 53usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::uclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, uclkspreadfreq) - 54usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fclkspreadenabled) - 56usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fclkspreadpercent) - 57usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fclkspreadfreq) - 58usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fllgfxclkspreadenabled) - 60usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fllgfxclkspreadpercent) - 61usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fllgfxclkspreadfreq) - 62usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::i2ccontrollers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, i2ccontrollers) - 64usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::memorychannelenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, memorychannelenabled) - 160usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::drambitwidth"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, drambitwidth) - 164usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::paddingmem"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, paddingmem) - 165usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::totalboardpower"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, totalboardpower) - 168usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardpadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardpadding) - 170usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::xgmilinkspeed"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, xgmilinkspeed) - 172usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::xgmilinkwidth"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, xgmilinkwidth) - 176usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::xgmifclkfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, xgmifclkfreq) - 180usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::xgmisocvoltage"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, xgmisocvoltage) - 188usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardreserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardreserved) - 196usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_7 {
    pub table_header: atom_common_table_header,
    pub I2cControllers: [smudpm_i2c_controller_config_v2; 8usize],
    pub MaxVoltageStepGfx: u16,
    pub MaxVoltageStepSoc: u16,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub ExternalSensorPresent: u8,
    pub Padding8_V: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: u8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: u8,
    pub Padding_TelemetryMem1: u8,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub padding8_4: u8,
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub SoclkSpreadEnabled: u8,
    pub SocclkSpreadPercent: u8,
    pub SocclkSpreadFreq: u16,
    pub TotalBoardPower: u16,
    pub BoardPadding: u16,
    pub MvddRatio: u32,
    pub GpioI2cScl: u8,
    pub GpioI2cSda: u8,
    pub GpioPadding: u16,
    pub LedPin3: u8,
    pub LedPin4: u8,
    pub LedEnableMask: u16,
    pub PowerLimitScalar: [u8; 4usize],
    pub MvddUlvPhaseSheddingMask: u8,
    pub VddciUlvPhaseSheddingMask: u8,
    pub Padding8_Psi1: u8,
    pub Padding8_Psi2: u8,
    pub BoardReserved: [u32; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_7"][::core::mem::size_of::<atom_smc_dpm_info_v4_7>() - 200usize];
    ["Alignment of atom_smc_dpm_info_v4_7"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_7>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::I2cControllers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, I2cControllers) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::MaxVoltageStepGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, MaxVoltageStepGfx) - 100usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::MaxVoltageStepSoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, MaxVoltageStepSoc) - 102usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddGfxVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddGfxVrMapping) - 104usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddSocVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddSocVrMapping) - 105usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddMem0VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddMem0VrMapping) - 106usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddMem1VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddMem1VrMapping) - 107usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GfxUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GfxUlvPhaseSheddingMask) - 108usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocUlvPhaseSheddingMask) - 109usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::ExternalSensorPresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, ExternalSensorPresent) - 110usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding8_V"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding8_V) - 111usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GfxMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GfxMaxCurrent) - 112usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GfxOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GfxOffset) - 114usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding_TelemetryGfx) - 115usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocMaxCurrent) - 116usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocOffset) - 118usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding_TelemetrySoc) - 119usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Mem0MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Mem0MaxCurrent) - 120usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Mem0Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Mem0Offset) - 122usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding_TelemetryMem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding_TelemetryMem0) - 123usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Mem1MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Mem1MaxCurrent) - 124usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Mem1Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Mem1Offset) - 126usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding_TelemetryMem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding_TelemetryMem1) - 127usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::AcDcGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, AcDcGpio) - 128usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::AcDcPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, AcDcPolarity) - 129usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VR0HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VR0HotGpio) - 130usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VR0HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VR0HotPolarity) - 131usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VR1HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VR1HotGpio) - 132usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VR1HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VR1HotPolarity) - 133usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GthrGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GthrGpio) - 134usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GthrPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GthrPolarity) - 135usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin0) - 136usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin1) - 137usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin2) - 138usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, padding8_4) - 139usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::PllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, PllGfxclkSpreadEnabled) - 140usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::PllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, PllGfxclkSpreadPercent) - 141usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::PllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, PllGfxclkSpreadFreq) - 142usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::DfllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, DfllGfxclkSpreadEnabled) - 144usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::DfllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, DfllGfxclkSpreadPercent) - 145usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::DfllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, DfllGfxclkSpreadFreq) - 146usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::UclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, UclkSpreadEnabled) - 148usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::UclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, UclkSpreadPercent) - 149usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::UclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, UclkSpreadFreq) - 150usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SoclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SoclkSpreadEnabled) - 152usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocclkSpreadPercent) - 153usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocclkSpreadFreq) - 154usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::TotalBoardPower"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, TotalBoardPower) - 156usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::BoardPadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, BoardPadding) - 158usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::MvddRatio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, MvddRatio) - 160usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GpioI2cScl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GpioI2cScl) - 164usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GpioI2cSda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GpioI2cSda) - 165usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GpioPadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GpioPadding) - 166usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin3"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin3) - 168usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin4) - 169usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedEnableMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedEnableMask) - 170usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::PowerLimitScalar"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, PowerLimitScalar) - 172usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::MvddUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, MvddUlvPhaseSheddingMask) - 176usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddciUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddciUlvPhaseSheddingMask) - 177usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding8_Psi1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding8_Psi1) - 178usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding8_Psi2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding8_Psi2) - 179usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::BoardReserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, BoardReserved) - 180usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct smudpm_i2c_controller_config_v3 {
    pub Enabled: u8,
    pub Speed: u8,
    pub SlaveAddress: u8,
    pub ControllerPort: u8,
    pub ControllerName: u8,
    pub ThermalThrotter: u8,
    pub I2cProtocol: u8,
    pub PaddingConfig: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smudpm_i2c_controller_config_v3"]
        [::core::mem::size_of::<smudpm_i2c_controller_config_v3>() - 8usize];
    ["Alignment of smudpm_i2c_controller_config_v3"]
        [::core::mem::align_of::<smudpm_i2c_controller_config_v3>() - 1usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::Enabled"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, Enabled) - 0usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::Speed"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, Speed) - 1usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::SlaveAddress"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, SlaveAddress) - 2usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::ControllerPort"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, ControllerPort) - 3usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::ControllerName"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, ControllerName) - 4usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::ThermalThrotter"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, ThermalThrotter) - 5usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::I2cProtocol"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, I2cProtocol) - 6usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::PaddingConfig"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, PaddingConfig) - 7usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_9 {
    pub table_header: atom_common_table_header,
    pub I2cControllers: [smudpm_i2c_controller_config_v3; 16usize],
    pub GpioScl: u8,
    pub GpioSda: u8,
    pub FchUsbPdSlaveAddr: u8,
    pub I2cSpare: u8,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub VddciUlvPhaseSheddingMask: u8,
    pub MvddUlvPhaseSheddingMask: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: u8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: u8,
    pub Padding_TelemetryMem1: u8,
    pub MvddRatio: u32,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub LedEnableMask: u8,
    pub LedPcie: u8,
    pub LedError: u8,
    pub LedSpare1: [u8; 2usize],
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub FclkSpreadEnabled: u8,
    pub FclkSpreadPercent: u8,
    pub FclkSpreadFreq: u16,
    pub MemoryChannelEnabled: u32,
    pub DramBitWidth: u8,
    pub PaddingMem1: [u8; 3usize],
    pub TotalBoardPower: u16,
    pub BoardPowerPadding: u16,
    pub XgmiLinkSpeed: [u8; 4usize],
    pub XgmiLinkWidth: [u8; 4usize],
    pub XgmiFclkFreq: [u16; 4usize],
    pub XgmiSocVoltage: [u16; 4usize],
    pub BoardReserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_9"][::core::mem::size_of::<atom_smc_dpm_info_v4_9>() - 296usize];
    ["Alignment of atom_smc_dpm_info_v4_9"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_9>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::I2cControllers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, I2cControllers) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GpioScl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GpioScl) - 132usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GpioSda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GpioSda) - 133usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::FchUsbPdSlaveAddr"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, FchUsbPdSlaveAddr) - 134usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::I2cSpare"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, I2cSpare) - 135usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddGfxVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddGfxVrMapping) - 136usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddSocVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddSocVrMapping) - 137usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddMem0VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddMem0VrMapping) - 138usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddMem1VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddMem1VrMapping) - 139usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GfxUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GfxUlvPhaseSheddingMask) - 140usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::SocUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, SocUlvPhaseSheddingMask) - 141usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddciUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddciUlvPhaseSheddingMask) - 142usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::MvddUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, MvddUlvPhaseSheddingMask) - 143usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GfxMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GfxMaxCurrent) - 144usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GfxOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GfxOffset) - 146usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Padding_TelemetryGfx) - 147usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::SocMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, SocMaxCurrent) - 148usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::SocOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, SocOffset) - 150usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Padding_TelemetrySoc) - 151usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Mem0MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Mem0MaxCurrent) - 152usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Mem0Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Mem0Offset) - 154usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Padding_TelemetryMem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Padding_TelemetryMem0) - 155usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Mem1MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Mem1MaxCurrent) - 156usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Mem1Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Mem1Offset) - 158usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Padding_TelemetryMem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Padding_TelemetryMem1) - 159usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::MvddRatio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, MvddRatio) - 160usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::AcDcGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, AcDcGpio) - 164usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::AcDcPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, AcDcPolarity) - 165usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VR0HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VR0HotGpio) - 166usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VR0HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VR0HotPolarity) - 167usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VR1HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VR1HotGpio) - 168usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VR1HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VR1HotPolarity) - 169usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GthrGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GthrGpio) - 170usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GthrPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GthrPolarity) - 171usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedPin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedPin0) - 172usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedPin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedPin1) - 173usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedPin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedPin2) - 174usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedEnableMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedEnableMask) - 175usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedPcie"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedPcie) - 176usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedError"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedError) - 177usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedSpare1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedSpare1) - 178usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::PllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, PllGfxclkSpreadEnabled) - 180usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::PllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, PllGfxclkSpreadPercent) - 181usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::PllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, PllGfxclkSpreadFreq) - 182usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::DfllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, DfllGfxclkSpreadEnabled) - 184usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::DfllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, DfllGfxclkSpreadPercent) - 185usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::DfllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, DfllGfxclkSpreadFreq) - 186usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::UclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, UclkSpreadEnabled) - 188usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::UclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, UclkSpreadPercent) - 189usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::UclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, UclkSpreadFreq) - 190usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::FclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, FclkSpreadEnabled) - 192usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::FclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, FclkSpreadPercent) - 193usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::FclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, FclkSpreadFreq) - 194usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::MemoryChannelEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, MemoryChannelEnabled) - 196usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::DramBitWidth"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, DramBitWidth) - 200usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::PaddingMem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, PaddingMem1) - 201usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::TotalBoardPower"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, TotalBoardPower) - 204usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::BoardPowerPadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, BoardPowerPadding) - 206usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::XgmiLinkSpeed"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, XgmiLinkSpeed) - 208usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::XgmiLinkWidth"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, XgmiLinkWidth) - 212usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::XgmiFclkFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, XgmiFclkFreq) - 216usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::XgmiSocVoltage"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, XgmiSocVoltage) - 224usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::BoardReserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, BoardReserved) - 232usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_10 {
    pub table_header: atom_common_table_header,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub MemMaxCurrent: u16,
    pub MemOffset: u8,
    pub Padding_TelemetryMem: u8,
    pub BoardMaxCurrent: u16,
    pub BoardOffset: u8,
    pub Padding_TelemetryBoardInput: u8,
    pub BoardVoltageCoeffA: u32,
    pub BoardVoltageCoeffB: u32,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub FclkSpreadEnabled: u8,
    pub FclkSpreadPercent: u8,
    pub FclkSpreadFreq: u16,
    pub I2cControllers: [smudpm_i2c_controller_config_v3; 8usize],
    pub GpioI2cScl: u8,
    pub GpioI2cSda: u8,
    pub spare5: u16,
    pub reserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_10"]
        [::core::mem::size_of::<atom_smc_dpm_info_v4_10>() - 172usize];
    ["Alignment of atom_smc_dpm_info_v4_10"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_10>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::GfxMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, GfxMaxCurrent) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::GfxOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, GfxOffset) - 6usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, Padding_TelemetryGfx) - 7usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::SocMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, SocMaxCurrent) - 8usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::SocOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, SocOffset) - 10usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, Padding_TelemetrySoc) - 11usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::MemMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, MemMaxCurrent) - 12usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::MemOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, MemOffset) - 14usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::Padding_TelemetryMem"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, Padding_TelemetryMem) - 15usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::BoardMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, BoardMaxCurrent) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::BoardOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, BoardOffset) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::Padding_TelemetryBoardInput"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, Padding_TelemetryBoardInput) - 19usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::BoardVoltageCoeffA"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, BoardVoltageCoeffA) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::BoardVoltageCoeffB"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, BoardVoltageCoeffB) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::VR0HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, VR0HotGpio) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::VR0HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, VR0HotPolarity) - 29usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::VR1HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, VR1HotGpio) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::VR1HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, VR1HotPolarity) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::UclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, UclkSpreadEnabled) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::UclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, UclkSpreadPercent) - 33usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::UclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, UclkSpreadFreq) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::FclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, FclkSpreadEnabled) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::FclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, FclkSpreadPercent) - 37usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::FclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, FclkSpreadFreq) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::I2cControllers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, I2cControllers) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::GpioI2cScl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, GpioI2cScl) - 104usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::GpioI2cSda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, GpioI2cSda) - 105usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::spare5"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, spare5) - 106usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::reserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, reserved) - 108usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_asic_profiling_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub maxvddc: u32,
    pub minvddc: u32,
    pub avfs_meannsigma_acontant0: u32,
    pub avfs_meannsigma_acontant1: u32,
    pub avfs_meannsigma_acontant2: u32,
    pub avfs_meannsigma_dc_tol_sigma: u16,
    pub avfs_meannsigma_platform_mean: u16,
    pub avfs_meannsigma_platform_sigma: u16,
    pub gb_vdroop_table_cksoff_a0: u32,
    pub gb_vdroop_table_cksoff_a1: u32,
    pub gb_vdroop_table_cksoff_a2: u32,
    pub gb_vdroop_table_ckson_a0: u32,
    pub gb_vdroop_table_ckson_a1: u32,
    pub gb_vdroop_table_ckson_a2: u32,
    pub avfsgb_fuse_table_cksoff_m1: u32,
    pub avfsgb_fuse_table_cksoff_m2: u32,
    pub avfsgb_fuse_table_cksoff_b: u32,
    pub avfsgb_fuse_table_ckson_m1: u32,
    pub avfsgb_fuse_table_ckson_m2: u32,
    pub avfsgb_fuse_table_ckson_b: u32,
    pub max_voltage_0_25mv: u16,
    pub enable_gb_vdroop_table_cksoff: u8,
    pub enable_gb_vdroop_table_ckson: u8,
    pub enable_gb_fuse_table_cksoff: u8,
    pub enable_gb_fuse_table_ckson: u8,
    pub psm_age_comfactor: u16,
    pub enable_apply_avfs_cksoff_voltage: u8,
    pub reserved: u8,
    pub dispclk2gfxclk_a: u32,
    pub dispclk2gfxclk_b: u32,
    pub dispclk2gfxclk_c: u32,
    pub pixclk2gfxclk_a: u32,
    pub pixclk2gfxclk_b: u32,
    pub pixclk2gfxclk_c: u32,
    pub dcefclk2gfxclk_a: u32,
    pub dcefclk2gfxclk_b: u32,
    pub dcefclk2gfxclk_c: u32,
    pub phyclk2gfxclk_a: u32,
    pub phyclk2gfxclk_b: u32,
    pub phyclk2gfxclk_c: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_asic_profiling_info_v4_1"]
        [::core::mem::size_of::<atom_asic_profiling_info_v4_1>() - 136usize];
    ["Alignment of atom_asic_profiling_info_v4_1"]
        [::core::mem::align_of::<atom_asic_profiling_info_v4_1>() - 1usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::table_header"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, table_header) - 0usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::maxvddc"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, maxvddc) - 4usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::minvddc"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, minvddc) - 8usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_acontant0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_acontant0
    ) - 12usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_acontant1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_acontant1
    ) - 16usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_acontant2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_acontant2
    ) - 20usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_dc_tol_sigma"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_dc_tol_sigma
    ) - 24usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_platform_mean"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_platform_mean
    ) - 26usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_platform_sigma"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_platform_sigma
    ) - 28usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_cksoff_a0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_cksoff_a0
    ) - 30usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_cksoff_a1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_cksoff_a1
    ) - 34usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_cksoff_a2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_cksoff_a2
    ) - 38usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_ckson_a0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_ckson_a0
    ) - 42usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_ckson_a1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_ckson_a1
    ) - 46usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_ckson_a2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_ckson_a2
    ) - 50usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_cksoff_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_cksoff_m1
    ) - 54usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_cksoff_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_cksoff_m2
    ) - 58usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_cksoff_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_cksoff_b
    ) - 62usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_ckson_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_ckson_m1
    ) - 66usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_ckson_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_ckson_m2
    ) - 70usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_ckson_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_ckson_b
    ) - 74usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::max_voltage_0_25mv"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, max_voltage_0_25mv) - 78usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_gb_vdroop_table_cksoff"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_gb_vdroop_table_cksoff
    ) - 80usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_gb_vdroop_table_ckson"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_gb_vdroop_table_ckson
    ) - 81usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_gb_fuse_table_cksoff"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_gb_fuse_table_cksoff
    ) - 82usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_gb_fuse_table_ckson"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_gb_fuse_table_ckson
    ) - 83usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::psm_age_comfactor"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, psm_age_comfactor) - 84usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_apply_avfs_cksoff_voltage"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_apply_avfs_cksoff_voltage
    )
        - 86usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::reserved"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, reserved) - 87usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dispclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dispclk2gfxclk_a) - 88usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dispclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dispclk2gfxclk_b) - 92usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dispclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dispclk2gfxclk_c) - 96usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::pixclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, pixclk2gfxclk_a) - 100usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::pixclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, pixclk2gfxclk_b) - 104usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::pixclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, pixclk2gfxclk_c) - 108usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dcefclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dcefclk2gfxclk_a) - 112usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dcefclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dcefclk2gfxclk_b) - 116usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dcefclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dcefclk2gfxclk_c) - 120usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::phyclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, phyclk2gfxclk_a) - 124usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::phyclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, phyclk2gfxclk_b) - 128usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::phyclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, phyclk2gfxclk_c) - 132usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_asic_profiling_info_v4_2 {
    pub table_header: atom_common_table_header,
    pub maxvddc: u32,
    pub minvddc: u32,
    pub avfs_meannsigma_acontant0: u32,
    pub avfs_meannsigma_acontant1: u32,
    pub avfs_meannsigma_acontant2: u32,
    pub avfs_meannsigma_dc_tol_sigma: u16,
    pub avfs_meannsigma_platform_mean: u16,
    pub avfs_meannsigma_platform_sigma: u16,
    pub gb_vdroop_table_cksoff_a0: u32,
    pub gb_vdroop_table_cksoff_a1: u32,
    pub gb_vdroop_table_cksoff_a2: u32,
    pub gb_vdroop_table_ckson_a0: u32,
    pub gb_vdroop_table_ckson_a1: u32,
    pub gb_vdroop_table_ckson_a2: u32,
    pub avfsgb_fuse_table_cksoff_m1: u32,
    pub avfsgb_fuse_table_cksoff_m2: u32,
    pub avfsgb_fuse_table_cksoff_b: u32,
    pub avfsgb_fuse_table_ckson_m1: u32,
    pub avfsgb_fuse_table_ckson_m2: u32,
    pub avfsgb_fuse_table_ckson_b: u32,
    pub max_voltage_0_25mv: u16,
    pub enable_gb_vdroop_table_cksoff: u8,
    pub enable_gb_vdroop_table_ckson: u8,
    pub enable_gb_fuse_table_cksoff: u8,
    pub enable_gb_fuse_table_ckson: u8,
    pub psm_age_comfactor: u16,
    pub enable_apply_avfs_cksoff_voltage: u8,
    pub reserved: u8,
    pub dispclk2gfxclk_a: u32,
    pub dispclk2gfxclk_b: u32,
    pub dispclk2gfxclk_c: u32,
    pub pixclk2gfxclk_a: u32,
    pub pixclk2gfxclk_b: u32,
    pub pixclk2gfxclk_c: u32,
    pub dcefclk2gfxclk_a: u32,
    pub dcefclk2gfxclk_b: u32,
    pub dcefclk2gfxclk_c: u32,
    pub phyclk2gfxclk_a: u32,
    pub phyclk2gfxclk_b: u32,
    pub phyclk2gfxclk_c: u32,
    pub acg_gb_vdroop_table_a0: u32,
    pub acg_gb_vdroop_table_a1: u32,
    pub acg_gb_vdroop_table_a2: u32,
    pub acg_avfsgb_fuse_table_m1: u32,
    pub acg_avfsgb_fuse_table_m2: u32,
    pub acg_avfsgb_fuse_table_b: u32,
    pub enable_acg_gb_vdroop_table: u8,
    pub enable_acg_gb_fuse_table: u8,
    pub acg_dispclk2gfxclk_a: u32,
    pub acg_dispclk2gfxclk_b: u32,
    pub acg_dispclk2gfxclk_c: u32,
    pub acg_pixclk2gfxclk_a: u32,
    pub acg_pixclk2gfxclk_b: u32,
    pub acg_pixclk2gfxclk_c: u32,
    pub acg_dcefclk2gfxclk_a: u32,
    pub acg_dcefclk2gfxclk_b: u32,
    pub acg_dcefclk2gfxclk_c: u32,
    pub acg_phyclk2gfxclk_a: u32,
    pub acg_phyclk2gfxclk_b: u32,
    pub acg_phyclk2gfxclk_c: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_asic_profiling_info_v4_2"]
        [::core::mem::size_of::<atom_asic_profiling_info_v4_2>() - 210usize];
    ["Alignment of atom_asic_profiling_info_v4_2"]
        [::core::mem::align_of::<atom_asic_profiling_info_v4_2>() - 1usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::table_header"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, table_header) - 0usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::maxvddc"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, maxvddc) - 4usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::minvddc"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, minvddc) - 8usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_acontant0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_acontant0
    ) - 12usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_acontant1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_acontant1
    ) - 16usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_acontant2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_acontant2
    ) - 20usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_dc_tol_sigma"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_dc_tol_sigma
    ) - 24usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_platform_mean"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_platform_mean
    ) - 26usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_platform_sigma"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_platform_sigma
    ) - 28usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_cksoff_a0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_cksoff_a0
    ) - 30usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_cksoff_a1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_cksoff_a1
    ) - 34usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_cksoff_a2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_cksoff_a2
    ) - 38usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_ckson_a0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_ckson_a0
    ) - 42usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_ckson_a1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_ckson_a1
    ) - 46usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_ckson_a2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_ckson_a2
    ) - 50usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_cksoff_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_cksoff_m1
    ) - 54usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_cksoff_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_cksoff_m2
    ) - 58usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_cksoff_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_cksoff_b
    ) - 62usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_ckson_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_ckson_m1
    ) - 66usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_ckson_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_ckson_m2
    ) - 70usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_ckson_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_ckson_b
    ) - 74usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::max_voltage_0_25mv"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, max_voltage_0_25mv) - 78usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_gb_vdroop_table_cksoff"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_gb_vdroop_table_cksoff
    ) - 80usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_gb_vdroop_table_ckson"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_gb_vdroop_table_ckson
    ) - 81usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_gb_fuse_table_cksoff"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_gb_fuse_table_cksoff
    ) - 82usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_gb_fuse_table_ckson"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_gb_fuse_table_ckson
    ) - 83usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::psm_age_comfactor"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, psm_age_comfactor) - 84usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_apply_avfs_cksoff_voltage"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_apply_avfs_cksoff_voltage
    )
        - 86usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::reserved"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, reserved) - 87usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dispclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dispclk2gfxclk_a) - 88usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dispclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dispclk2gfxclk_b) - 92usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dispclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dispclk2gfxclk_c) - 96usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::pixclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, pixclk2gfxclk_a) - 100usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::pixclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, pixclk2gfxclk_b) - 104usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::pixclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, pixclk2gfxclk_c) - 108usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dcefclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dcefclk2gfxclk_a) - 112usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dcefclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dcefclk2gfxclk_b) - 116usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dcefclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dcefclk2gfxclk_c) - 120usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::phyclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, phyclk2gfxclk_a) - 124usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::phyclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, phyclk2gfxclk_b) - 128usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::phyclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, phyclk2gfxclk_c) - 132usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_gb_vdroop_table_a0"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_gb_vdroop_table_a0) - 136usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_gb_vdroop_table_a1"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_gb_vdroop_table_a1) - 140usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_gb_vdroop_table_a2"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_gb_vdroop_table_a2) - 144usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_avfsgb_fuse_table_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        acg_avfsgb_fuse_table_m1
    ) - 148usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_avfsgb_fuse_table_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        acg_avfsgb_fuse_table_m2
    ) - 152usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_avfsgb_fuse_table_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        acg_avfsgb_fuse_table_b
    ) - 156usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_acg_gb_vdroop_table"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_acg_gb_vdroop_table
    ) - 160usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_acg_gb_fuse_table"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_acg_gb_fuse_table
    ) - 161usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dispclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dispclk2gfxclk_a) - 162usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dispclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dispclk2gfxclk_b) - 166usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dispclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dispclk2gfxclk_c) - 170usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_pixclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_pixclk2gfxclk_a) - 174usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_pixclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_pixclk2gfxclk_b) - 178usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_pixclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_pixclk2gfxclk_c) - 182usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dcefclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dcefclk2gfxclk_a) - 186usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dcefclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dcefclk2gfxclk_b) - 190usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dcefclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dcefclk2gfxclk_c) - 194usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_phyclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_phyclk2gfxclk_a) - 198usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_phyclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_phyclk2gfxclk_b) - 202usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_phyclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_phyclk2gfxclk_c) - 206usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_multimedia_info_v2_1 {
    pub table_header: atom_common_table_header,
    pub uvdip_min_ver: u8,
    pub uvdip_max_ver: u8,
    pub vceip_min_ver: u8,
    pub vceip_max_ver: u8,
    pub uvd_enc_max_input_width_pixels: u16,
    pub uvd_enc_max_input_height_pixels: u16,
    pub vce_enc_max_input_width_pixels: u16,
    pub vce_enc_max_input_height_pixels: u16,
    pub uvd_enc_max_bandwidth: u32,
    pub vce_enc_max_bandwidth: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_multimedia_info_v2_1"]
        [::core::mem::size_of::<atom_multimedia_info_v2_1>() - 24usize];
    ["Alignment of atom_multimedia_info_v2_1"]
        [::core::mem::align_of::<atom_multimedia_info_v2_1>() - 1usize];
    ["Offset of field: atom_multimedia_info_v2_1::table_header"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, table_header) - 0usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvdip_min_ver"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, uvdip_min_ver) - 4usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvdip_max_ver"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, uvdip_max_ver) - 5usize];
    ["Offset of field: atom_multimedia_info_v2_1::vceip_min_ver"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, vceip_min_ver) - 6usize];
    ["Offset of field: atom_multimedia_info_v2_1::vceip_max_ver"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, vceip_max_ver) - 7usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvd_enc_max_input_width_pixels"][::core::mem::offset_of!(
        atom_multimedia_info_v2_1,
        uvd_enc_max_input_width_pixels
    ) - 8usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvd_enc_max_input_height_pixels"][::core::mem::offset_of!(
        atom_multimedia_info_v2_1,
        uvd_enc_max_input_height_pixels
    ) - 10usize];
    ["Offset of field: atom_multimedia_info_v2_1::vce_enc_max_input_width_pixels"][::core::mem::offset_of!(
        atom_multimedia_info_v2_1,
        vce_enc_max_input_width_pixels
    ) - 12usize];
    ["Offset of field: atom_multimedia_info_v2_1::vce_enc_max_input_height_pixels"][::core::mem::offset_of!(
        atom_multimedia_info_v2_1,
        vce_enc_max_input_height_pixels
    ) - 14usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvd_enc_max_bandwidth"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, uvd_enc_max_bandwidth) - 16usize];
    ["Offset of field: atom_multimedia_info_v2_1::vce_enc_max_bandwidth"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, vce_enc_max_bandwidth) - 20usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v3_1 {
    pub table_header: atom_common_table_header,
    pub ucode_version: u32,
    pub ucode_rom_startaddr: u32,
    pub ucode_length: u32,
    pub umc_reg_init_offset: u16,
    pub customer_ucode_name_offset: u16,
    pub mclk_ss_percentage: u16,
    pub mclk_ss_rate_10hz: u16,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_info_v3_1"][::core::mem::size_of::<atom_umc_info_v3_1>() - 32usize];
    ["Alignment of atom_umc_info_v3_1"][::core::mem::align_of::<atom_umc_info_v3_1>() - 1usize];
    ["Offset of field: atom_umc_info_v3_1::table_header"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, table_header) - 0usize];
    ["Offset of field: atom_umc_info_v3_1::ucode_version"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, ucode_version) - 4usize];
    ["Offset of field: atom_umc_info_v3_1::ucode_rom_startaddr"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, ucode_rom_startaddr) - 8usize];
    ["Offset of field: atom_umc_info_v3_1::ucode_length"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, ucode_length) - 12usize];
    ["Offset of field: atom_umc_info_v3_1::umc_reg_init_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, umc_reg_init_offset) - 16usize];
    ["Offset of field: atom_umc_info_v3_1::customer_ucode_name_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, customer_ucode_name_offset) - 18usize];
    ["Offset of field: atom_umc_info_v3_1::mclk_ss_percentage"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, mclk_ss_percentage) - 20usize];
    ["Offset of field: atom_umc_info_v3_1::mclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, mclk_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_umc_info_v3_1::umcip_min_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, umcip_min_ver) - 24usize];
    ["Offset of field: atom_umc_info_v3_1::umcip_max_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, umcip_max_ver) - 25usize];
    ["Offset of field: atom_umc_info_v3_1::vram_type"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, vram_type) - 26usize];
    ["Offset of field: atom_umc_info_v3_1::umc_config"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, umc_config) - 27usize];
    ["Offset of field: atom_umc_info_v3_1::mem_refclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, mem_refclk_10khz) - 28usize];
};
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_1KB_INTERLEAVE_MODE: atom_umc_config_def = 1;
pub const atom_umc_config_def_UMC_CONFIG__DEFAULT_MEM_ECC_ENABLE: atom_umc_config_def = 2;
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_HBM_LANE_REPAIR: atom_umc_config_def = 4;
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_BANK_HARVESTING: atom_umc_config_def = 8;
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_PHY_REINIT: atom_umc_config_def = 16;
pub const atom_umc_config_def_UMC_CONFIG__DISABLE_UCODE_CHKSTATUS: atom_umc_config_def = 32;
pub type atom_umc_config_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v3_2 {
    pub table_header: atom_common_table_header,
    pub ucode_version: u32,
    pub ucode_rom_startaddr: u32,
    pub ucode_length: u32,
    pub umc_reg_init_offset: u16,
    pub customer_ucode_name_offset: u16,
    pub mclk_ss_percentage: u16,
    pub mclk_ss_rate_10hz: u16,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
    pub pstate_uclk_10khz: [u32; 4usize],
    pub umcgoldenoffset: u16,
    pub densitygoldenoffset: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_info_v3_2"][::core::mem::size_of::<atom_umc_info_v3_2>() - 52usize];
    ["Alignment of atom_umc_info_v3_2"][::core::mem::align_of::<atom_umc_info_v3_2>() - 1usize];
    ["Offset of field: atom_umc_info_v3_2::table_header"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, table_header) - 0usize];
    ["Offset of field: atom_umc_info_v3_2::ucode_version"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, ucode_version) - 4usize];
    ["Offset of field: atom_umc_info_v3_2::ucode_rom_startaddr"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, ucode_rom_startaddr) - 8usize];
    ["Offset of field: atom_umc_info_v3_2::ucode_length"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, ucode_length) - 12usize];
    ["Offset of field: atom_umc_info_v3_2::umc_reg_init_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umc_reg_init_offset) - 16usize];
    ["Offset of field: atom_umc_info_v3_2::customer_ucode_name_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, customer_ucode_name_offset) - 18usize];
    ["Offset of field: atom_umc_info_v3_2::mclk_ss_percentage"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, mclk_ss_percentage) - 20usize];
    ["Offset of field: atom_umc_info_v3_2::mclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, mclk_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_umc_info_v3_2::umcip_min_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umcip_min_ver) - 24usize];
    ["Offset of field: atom_umc_info_v3_2::umcip_max_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umcip_max_ver) - 25usize];
    ["Offset of field: atom_umc_info_v3_2::vram_type"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, vram_type) - 26usize];
    ["Offset of field: atom_umc_info_v3_2::umc_config"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umc_config) - 27usize];
    ["Offset of field: atom_umc_info_v3_2::mem_refclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, mem_refclk_10khz) - 28usize];
    ["Offset of field: atom_umc_info_v3_2::pstate_uclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, pstate_uclk_10khz) - 32usize];
    ["Offset of field: atom_umc_info_v3_2::umcgoldenoffset"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umcgoldenoffset) - 48usize];
    ["Offset of field: atom_umc_info_v3_2::densitygoldenoffset"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, densitygoldenoffset) - 50usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v3_3 {
    pub table_header: atom_common_table_header,
    pub ucode_reserved: u32,
    pub ucode_rom_startaddr: u32,
    pub ucode_length: u32,
    pub umc_reg_init_offset: u16,
    pub customer_ucode_name_offset: u16,
    pub mclk_ss_percentage: u16,
    pub mclk_ss_rate_10hz: u16,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
    pub pstate_uclk_10khz: [u32; 4usize],
    pub umcgoldenoffset: u16,
    pub densitygoldenoffset: u16,
    pub umc_config1: u32,
    pub bist_data_startaddr: u32,
    pub reserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_info_v3_3"][::core::mem::size_of::<atom_umc_info_v3_3>() - 68usize];
    ["Alignment of atom_umc_info_v3_3"][::core::mem::align_of::<atom_umc_info_v3_3>() - 1usize];
    ["Offset of field: atom_umc_info_v3_3::table_header"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, table_header) - 0usize];
    ["Offset of field: atom_umc_info_v3_3::ucode_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, ucode_reserved) - 4usize];
    ["Offset of field: atom_umc_info_v3_3::ucode_rom_startaddr"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, ucode_rom_startaddr) - 8usize];
    ["Offset of field: atom_umc_info_v3_3::ucode_length"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, ucode_length) - 12usize];
    ["Offset of field: atom_umc_info_v3_3::umc_reg_init_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umc_reg_init_offset) - 16usize];
    ["Offset of field: atom_umc_info_v3_3::customer_ucode_name_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, customer_ucode_name_offset) - 18usize];
    ["Offset of field: atom_umc_info_v3_3::mclk_ss_percentage"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, mclk_ss_percentage) - 20usize];
    ["Offset of field: atom_umc_info_v3_3::mclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, mclk_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_umc_info_v3_3::umcip_min_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umcip_min_ver) - 24usize];
    ["Offset of field: atom_umc_info_v3_3::umcip_max_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umcip_max_ver) - 25usize];
    ["Offset of field: atom_umc_info_v3_3::vram_type"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, vram_type) - 26usize];
    ["Offset of field: atom_umc_info_v3_3::umc_config"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umc_config) - 27usize];
    ["Offset of field: atom_umc_info_v3_3::mem_refclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, mem_refclk_10khz) - 28usize];
    ["Offset of field: atom_umc_info_v3_3::pstate_uclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, pstate_uclk_10khz) - 32usize];
    ["Offset of field: atom_umc_info_v3_3::umcgoldenoffset"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umcgoldenoffset) - 48usize];
    ["Offset of field: atom_umc_info_v3_3::densitygoldenoffset"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, densitygoldenoffset) - 50usize];
    ["Offset of field: atom_umc_info_v3_3::umc_config1"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umc_config1) - 52usize];
    ["Offset of field: atom_umc_info_v3_3::bist_data_startaddr"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, bist_data_startaddr) - 56usize];
    ["Offset of field: atom_umc_info_v3_3::reserved"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, reserved) - 60usize];
};
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_PSTATE_PHASE_STORE_TRAIN: atom_umc_config1_def =
    1;
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_AUTO_FRAMING: atom_umc_config1_def = 2;
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_RESTORE_BIST_DATA: atom_umc_config1_def = 4;
pub const atom_umc_config1_def_UMC_CONFIG1__DISABLE_STROBE_MODE: atom_umc_config1_def = 8;
pub const atom_umc_config1_def_UMC_CONFIG1__DEBUG_DATA_PARITY_EN: atom_umc_config1_def = 16;
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_ECC_CAPABLE: atom_umc_config1_def = 65536;
pub type atom_umc_config1_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v4_0 {
    pub table_header: atom_common_table_header,
    pub ucode_reserved: [u32; 5usize],
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
    pub clk_reserved: [u32; 4usize],
    pub golden_reserved: u32,
    pub umc_config1: u32,
    pub reserved: [u32; 2usize],
    pub channel_num: u8,
    pub channel_width: u8,
    pub channel_reserve: [u8; 2usize],
    pub umc_info_reserved: [u8; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_info_v4_0"][::core::mem::size_of::<atom_umc_info_v4_0>() - 84usize];
    ["Alignment of atom_umc_info_v4_0"][::core::mem::align_of::<atom_umc_info_v4_0>() - 1usize];
    ["Offset of field: atom_umc_info_v4_0::table_header"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, table_header) - 0usize];
    ["Offset of field: atom_umc_info_v4_0::ucode_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, ucode_reserved) - 4usize];
    ["Offset of field: atom_umc_info_v4_0::umcip_min_ver"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umcip_min_ver) - 24usize];
    ["Offset of field: atom_umc_info_v4_0::umcip_max_ver"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umcip_max_ver) - 25usize];
    ["Offset of field: atom_umc_info_v4_0::vram_type"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, vram_type) - 26usize];
    ["Offset of field: atom_umc_info_v4_0::umc_config"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umc_config) - 27usize];
    ["Offset of field: atom_umc_info_v4_0::mem_refclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, mem_refclk_10khz) - 28usize];
    ["Offset of field: atom_umc_info_v4_0::clk_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, clk_reserved) - 32usize];
    ["Offset of field: atom_umc_info_v4_0::golden_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, golden_reserved) - 48usize];
    ["Offset of field: atom_umc_info_v4_0::umc_config1"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umc_config1) - 52usize];
    ["Offset of field: atom_umc_info_v4_0::reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, reserved) - 56usize];
    ["Offset of field: atom_umc_info_v4_0::channel_num"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, channel_num) - 64usize];
    ["Offset of field: atom_umc_info_v4_0::channel_width"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, channel_width) - 65usize];
    ["Offset of field: atom_umc_info_v4_0::channel_reserve"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, channel_reserve) - 66usize];
    ["Offset of field: atom_umc_info_v4_0::umc_info_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umc_info_reserved) - 68usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v9 {
    pub memory_size: u32,
    pub channel_enable: u32,
    pub max_mem_clk: u32,
    pub reserved: [u16; 3usize],
    pub mem_voltage: u16,
    pub vram_module_size: u16,
    pub ext_memory_id: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub density: u8,
    pub tunningset_id: u8,
    pub vender_rev_id: u8,
    pub refreshrate: u8,
    pub hbm_ven_rev_id: u8,
    pub vram_rsd2: u8,
    pub dram_pnstring: [::core::ffi::c_char; 20usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_module_v9"][::core::mem::size_of::<atom_vram_module_v9>() - 52usize];
    ["Alignment of atom_vram_module_v9"][::core::mem::align_of::<atom_vram_module_v9>() - 1usize];
    ["Offset of field: atom_vram_module_v9::memory_size"]
        [::core::mem::offset_of!(atom_vram_module_v9, memory_size) - 0usize];
    ["Offset of field: atom_vram_module_v9::channel_enable"]
        [::core::mem::offset_of!(atom_vram_module_v9, channel_enable) - 4usize];
    ["Offset of field: atom_vram_module_v9::max_mem_clk"]
        [::core::mem::offset_of!(atom_vram_module_v9, max_mem_clk) - 8usize];
    ["Offset of field: atom_vram_module_v9::reserved"]
        [::core::mem::offset_of!(atom_vram_module_v9, reserved) - 12usize];
    ["Offset of field: atom_vram_module_v9::mem_voltage"]
        [::core::mem::offset_of!(atom_vram_module_v9, mem_voltage) - 18usize];
    ["Offset of field: atom_vram_module_v9::vram_module_size"]
        [::core::mem::offset_of!(atom_vram_module_v9, vram_module_size) - 20usize];
    ["Offset of field: atom_vram_module_v9::ext_memory_id"]
        [::core::mem::offset_of!(atom_vram_module_v9, ext_memory_id) - 22usize];
    ["Offset of field: atom_vram_module_v9::memory_type"]
        [::core::mem::offset_of!(atom_vram_module_v9, memory_type) - 23usize];
    ["Offset of field: atom_vram_module_v9::channel_num"]
        [::core::mem::offset_of!(atom_vram_module_v9, channel_num) - 24usize];
    ["Offset of field: atom_vram_module_v9::channel_width"]
        [::core::mem::offset_of!(atom_vram_module_v9, channel_width) - 25usize];
    ["Offset of field: atom_vram_module_v9::density"]
        [::core::mem::offset_of!(atom_vram_module_v9, density) - 26usize];
    ["Offset of field: atom_vram_module_v9::tunningset_id"]
        [::core::mem::offset_of!(atom_vram_module_v9, tunningset_id) - 27usize];
    ["Offset of field: atom_vram_module_v9::vender_rev_id"]
        [::core::mem::offset_of!(atom_vram_module_v9, vender_rev_id) - 28usize];
    ["Offset of field: atom_vram_module_v9::refreshrate"]
        [::core::mem::offset_of!(atom_vram_module_v9, refreshrate) - 29usize];
    ["Offset of field: atom_vram_module_v9::hbm_ven_rev_id"]
        [::core::mem::offset_of!(atom_vram_module_v9, hbm_ven_rev_id) - 30usize];
    ["Offset of field: atom_vram_module_v9::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_module_v9, vram_rsd2) - 31usize];
    ["Offset of field: atom_vram_module_v9::dram_pnstring"]
        [::core::mem::offset_of!(atom_vram_module_v9, dram_pnstring) - 32usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_3 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub mem_clk_patch_tbloffset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub tmrs_seq_offset: u16,
    pub post_ucode_init_offset: u16,
    pub vram_rsd2: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v9; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v2_3"]
        [::core::mem::size_of::<atom_vram_info_header_v2_3>() - 856usize];
    ["Alignment of atom_vram_info_header_v2_3"]
        [::core::mem::align_of::<atom_vram_info_header_v2_3>() - 1usize];
    ["Offset of field: atom_vram_info_header_v2_3::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v2_3::mem_adjust_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mem_adjust_tbloffset) - 4usize];
    ["Offset of field: atom_vram_info_header_v2_3::mem_clk_patch_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mem_clk_patch_tbloffset) - 6usize];
    ["Offset of field: atom_vram_info_header_v2_3::mc_adjust_pertile_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mc_adjust_pertile_tbloffset) - 8usize];
    ["Offset of field: atom_vram_info_header_v2_3::mc_phyinit_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mc_phyinit_tbloffset) - 10usize];
    ["Offset of field: atom_vram_info_header_v2_3::dram_data_remap_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, dram_data_remap_tbloffset) - 12usize];
    ["Offset of field: atom_vram_info_header_v2_3::tmrs_seq_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, tmrs_seq_offset) - 14usize];
    ["Offset of field: atom_vram_info_header_v2_3::post_ucode_init_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, post_ucode_init_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v2_3::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, vram_rsd2) - 18usize];
    ["Offset of field: atom_vram_info_header_v2_3::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v2_3::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v2_3::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v2_3::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v2_3::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, vram_module) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v3_0 {
    pub density: u8,
    pub tunningset_id: u8,
    pub ext_memory_id: u8,
    pub dram_vendor_id: u8,
    pub dram_info_offset: u16,
    pub mem_tuning_offset: u16,
    pub tmrs_seq_offset: u16,
    pub reserved1: u16,
    pub dram_size_per_ch: u32,
    pub reserved: [u32; 3usize],
    pub dram_pnstring: [::core::ffi::c_char; 40usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_module_v3_0"][::core::mem::size_of::<atom_vram_module_v3_0>() - 68usize];
    ["Alignment of atom_vram_module_v3_0"]
        [::core::mem::align_of::<atom_vram_module_v3_0>() - 1usize];
    ["Offset of field: atom_vram_module_v3_0::density"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, density) - 0usize];
    ["Offset of field: atom_vram_module_v3_0::tunningset_id"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, tunningset_id) - 1usize];
    ["Offset of field: atom_vram_module_v3_0::ext_memory_id"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, ext_memory_id) - 2usize];
    ["Offset of field: atom_vram_module_v3_0::dram_vendor_id"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, dram_vendor_id) - 3usize];
    ["Offset of field: atom_vram_module_v3_0::dram_info_offset"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, dram_info_offset) - 4usize];
    ["Offset of field: atom_vram_module_v3_0::mem_tuning_offset"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, mem_tuning_offset) - 6usize];
    ["Offset of field: atom_vram_module_v3_0::tmrs_seq_offset"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, tmrs_seq_offset) - 8usize];
    ["Offset of field: atom_vram_module_v3_0::reserved1"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, reserved1) - 10usize];
    ["Offset of field: atom_vram_module_v3_0::dram_size_per_ch"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, dram_size_per_ch) - 12usize];
    ["Offset of field: atom_vram_module_v3_0::reserved"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, reserved) - 16usize];
    ["Offset of field: atom_vram_module_v3_0::dram_pnstring"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, dram_pnstring) - 28usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v3_0 {
    pub table_header: atom_common_table_header,
    pub mem_tuning_table_offset: u16,
    pub dram_info_table_offset: u16,
    pub tmrs_table_offset: u16,
    pub mc_init_table_offset: u16,
    pub dram_data_remap_table_offset: u16,
    pub umc_emuinittable_offset: u16,
    pub reserved_sub_table_offset: [u16; 2usize],
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub reserved1: u8,
    pub channel_enable: u32,
    pub channel1_enable: u32,
    pub feature_enable: u32,
    pub feature1_enable: u32,
    pub hardcode_mem_size: u32,
    pub reserved4: [u32; 4usize],
    pub vram_module: [atom_vram_module_v3_0; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v3_0"]
        [::core::mem::size_of::<atom_vram_info_header_v3_0>() - 608usize];
    ["Alignment of atom_vram_info_header_v3_0"]
        [::core::mem::align_of::<atom_vram_info_header_v3_0>() - 1usize];
    ["Offset of field: atom_vram_info_header_v3_0::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v3_0::mem_tuning_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, mem_tuning_table_offset) - 4usize];
    ["Offset of field: atom_vram_info_header_v3_0::dram_info_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, dram_info_table_offset) - 6usize];
    ["Offset of field: atom_vram_info_header_v3_0::tmrs_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, tmrs_table_offset) - 8usize];
    ["Offset of field: atom_vram_info_header_v3_0::mc_init_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, mc_init_table_offset) - 10usize];
    ["Offset of field: atom_vram_info_header_v3_0::dram_data_remap_table_offset"][::core::mem::offset_of!(
        atom_vram_info_header_v3_0,
        dram_data_remap_table_offset
    ) - 12usize];
    ["Offset of field: atom_vram_info_header_v3_0::umc_emuinittable_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, umc_emuinittable_offset) - 14usize];
    ["Offset of field: atom_vram_info_header_v3_0::reserved_sub_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, reserved_sub_table_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v3_0::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v3_0::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v3_0::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v3_0::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v3_0::memory_type"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, memory_type) - 24usize];
    ["Offset of field: atom_vram_info_header_v3_0::channel_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, channel_num) - 25usize];
    ["Offset of field: atom_vram_info_header_v3_0::channel_width"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, channel_width) - 26usize];
    ["Offset of field: atom_vram_info_header_v3_0::reserved1"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, reserved1) - 27usize];
    ["Offset of field: atom_vram_info_header_v3_0::channel_enable"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, channel_enable) - 28usize];
    ["Offset of field: atom_vram_info_header_v3_0::channel1_enable"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, channel1_enable) - 32usize];
    ["Offset of field: atom_vram_info_header_v3_0::feature_enable"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, feature_enable) - 36usize];
    ["Offset of field: atom_vram_info_header_v3_0::feature1_enable"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, feature1_enable) - 40usize];
    ["Offset of field: atom_vram_info_header_v3_0::hardcode_mem_size"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, hardcode_mem_size) - 44usize];
    ["Offset of field: atom_vram_info_header_v3_0::reserved4"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, reserved4) - 48usize];
    ["Offset of field: atom_vram_info_header_v3_0::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, vram_module) - 64usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_register_addr_info {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_register_addr_info"]
        [::core::mem::size_of::<atom_umc_register_addr_info>() - 4usize];
    ["Alignment of atom_umc_register_addr_info"]
        [::core::mem::align_of::<atom_umc_register_addr_info>() - 1usize];
};
impl atom_umc_register_addr_info {
    #[inline]
    pub fn umc_register_addr(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_umc_register_addr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn umc_reg_type_ind(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_umc_reg_type_ind(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn umc_reg_rsvd(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(25usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_umc_reg_rsvd(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(25usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        umc_register_addr: u32,
        umc_reg_type_ind: u32,
        umc_reg_rsvd: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let umc_register_addr: u32 = unsafe { ::core::mem::transmute(umc_register_addr) };
            umc_register_addr as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let umc_reg_type_ind: u32 = unsafe { ::core::mem::transmute(umc_reg_type_ind) };
            umc_reg_type_ind as u64
        });
        __bindgen_bitfield_unit.set(25usize, 7u8, {
            let umc_reg_rsvd: u32 = unsafe { ::core::mem::transmute(umc_reg_rsvd) };
            umc_reg_rsvd as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const atom_umc_register_addr_info_flag_b3ATOM_UMC_REG_ADD_INFO_INDIRECT_ACCESS:
    atom_umc_register_addr_info_flag = 1;
pub type atom_umc_register_addr_info_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union atom_umc_register_addr_info_access {
    pub umc_reg_addr: atom_umc_register_addr_info,
    pub u32umc_reg_addr: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_register_addr_info_access"]
        [::core::mem::size_of::<atom_umc_register_addr_info_access>() - 4usize];
    ["Alignment of atom_umc_register_addr_info_access"]
        [::core::mem::align_of::<atom_umc_register_addr_info_access>() - 1usize];
    ["Offset of field: atom_umc_register_addr_info_access::umc_reg_addr"]
        [::core::mem::offset_of!(atom_umc_register_addr_info_access, umc_reg_addr) - 0usize];
    ["Offset of field: atom_umc_register_addr_info_access::u32umc_reg_addr"]
        [::core::mem::offset_of!(atom_umc_register_addr_info_access, u32umc_reg_addr) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_reg_setting_id_config {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_reg_setting_id_config"]
        [::core::mem::size_of::<atom_umc_reg_setting_id_config>() - 4usize];
    ["Alignment of atom_umc_reg_setting_id_config"]
        [::core::mem::align_of::<atom_umc_reg_setting_id_config>() - 1usize];
};
impl atom_umc_reg_setting_id_config {
    #[inline]
    pub fn memclockrange(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_memclockrange(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn mem_blk_id(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_mem_blk_id(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        memclockrange: u32,
        mem_blk_id: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let memclockrange: u32 = unsafe { ::core::mem::transmute(memclockrange) };
            memclockrange as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let mem_blk_id: u32 = unsafe { ::core::mem::transmute(mem_blk_id) };
            mem_blk_id as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union atom_umc_reg_setting_id_config_access {
    pub umc_id_access: atom_umc_reg_setting_id_config,
    pub u32umc_id_access: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_reg_setting_id_config_access"]
        [::core::mem::size_of::<atom_umc_reg_setting_id_config_access>() - 4usize];
    ["Alignment of atom_umc_reg_setting_id_config_access"]
        [::core::mem::align_of::<atom_umc_reg_setting_id_config_access>() - 1usize];
    ["Offset of field: atom_umc_reg_setting_id_config_access::umc_id_access"]
        [::core::mem::offset_of!(atom_umc_reg_setting_id_config_access, umc_id_access) - 0usize];
    ["Offset of field: atom_umc_reg_setting_id_config_access::u32umc_id_access"]
        [::core::mem::offset_of!(atom_umc_reg_setting_id_config_access, u32umc_id_access) - 0usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct atom_umc_reg_setting_data_block {
    pub block_id: atom_umc_reg_setting_id_config_access,
    pub u32umc_reg_data: [u32; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_reg_setting_data_block"]
        [::core::mem::size_of::<atom_umc_reg_setting_data_block>() - 8usize];
    ["Alignment of atom_umc_reg_setting_data_block"]
        [::core::mem::align_of::<atom_umc_reg_setting_data_block>() - 1usize];
    ["Offset of field: atom_umc_reg_setting_data_block::block_id"]
        [::core::mem::offset_of!(atom_umc_reg_setting_data_block, block_id) - 0usize];
    ["Offset of field: atom_umc_reg_setting_data_block::u32umc_reg_data"]
        [::core::mem::offset_of!(atom_umc_reg_setting_data_block, u32umc_reg_data) - 4usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct atom_umc_init_reg_block {
    pub umc_reg_num: u16,
    pub reserved: u16,
    pub umc_reg_list: [atom_umc_register_addr_info_access; 1usize],
    pub umc_reg_setting_list: [atom_umc_reg_setting_data_block; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_init_reg_block"]
        [::core::mem::size_of::<atom_umc_init_reg_block>() - 16usize];
    ["Alignment of atom_umc_init_reg_block"]
        [::core::mem::align_of::<atom_umc_init_reg_block>() - 1usize];
    ["Offset of field: atom_umc_init_reg_block::umc_reg_num"]
        [::core::mem::offset_of!(atom_umc_init_reg_block, umc_reg_num) - 0usize];
    ["Offset of field: atom_umc_init_reg_block::reserved"]
        [::core::mem::offset_of!(atom_umc_init_reg_block, reserved) - 2usize];
    ["Offset of field: atom_umc_init_reg_block::umc_reg_list"]
        [::core::mem::offset_of!(atom_umc_init_reg_block, umc_reg_list) - 4usize];
    ["Offset of field: atom_umc_init_reg_block::umc_reg_setting_list"]
        [::core::mem::offset_of!(atom_umc_init_reg_block, umc_reg_setting_list) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v10 {
    pub memory_size: u32,
    pub channel_enable: u32,
    pub max_mem_clk: u32,
    pub reserved: [u16; 3usize],
    pub mem_voltage: u16,
    pub vram_module_size: u16,
    pub ext_memory_id: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub density: u8,
    pub tunningset_id: u8,
    pub vender_rev_id: u8,
    pub refreshrate: u8,
    pub vram_flags: u8,
    pub vram_rsd2: u8,
    pub gddr6_mr10: u16,
    pub gddr6_mr1: u16,
    pub gddr6_mr2: u16,
    pub gddr6_mr7: u16,
    pub dram_pnstring: [::core::ffi::c_char; 20usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_module_v10"][::core::mem::size_of::<atom_vram_module_v10>() - 60usize];
    ["Alignment of atom_vram_module_v10"][::core::mem::align_of::<atom_vram_module_v10>() - 1usize];
    ["Offset of field: atom_vram_module_v10::memory_size"]
        [::core::mem::offset_of!(atom_vram_module_v10, memory_size) - 0usize];
    ["Offset of field: atom_vram_module_v10::channel_enable"]
        [::core::mem::offset_of!(atom_vram_module_v10, channel_enable) - 4usize];
    ["Offset of field: atom_vram_module_v10::max_mem_clk"]
        [::core::mem::offset_of!(atom_vram_module_v10, max_mem_clk) - 8usize];
    ["Offset of field: atom_vram_module_v10::reserved"]
        [::core::mem::offset_of!(atom_vram_module_v10, reserved) - 12usize];
    ["Offset of field: atom_vram_module_v10::mem_voltage"]
        [::core::mem::offset_of!(atom_vram_module_v10, mem_voltage) - 18usize];
    ["Offset of field: atom_vram_module_v10::vram_module_size"]
        [::core::mem::offset_of!(atom_vram_module_v10, vram_module_size) - 20usize];
    ["Offset of field: atom_vram_module_v10::ext_memory_id"]
        [::core::mem::offset_of!(atom_vram_module_v10, ext_memory_id) - 22usize];
    ["Offset of field: atom_vram_module_v10::memory_type"]
        [::core::mem::offset_of!(atom_vram_module_v10, memory_type) - 23usize];
    ["Offset of field: atom_vram_module_v10::channel_num"]
        [::core::mem::offset_of!(atom_vram_module_v10, channel_num) - 24usize];
    ["Offset of field: atom_vram_module_v10::channel_width"]
        [::core::mem::offset_of!(atom_vram_module_v10, channel_width) - 25usize];
    ["Offset of field: atom_vram_module_v10::density"]
        [::core::mem::offset_of!(atom_vram_module_v10, density) - 26usize];
    ["Offset of field: atom_vram_module_v10::tunningset_id"]
        [::core::mem::offset_of!(atom_vram_module_v10, tunningset_id) - 27usize];
    ["Offset of field: atom_vram_module_v10::vender_rev_id"]
        [::core::mem::offset_of!(atom_vram_module_v10, vender_rev_id) - 28usize];
    ["Offset of field: atom_vram_module_v10::refreshrate"]
        [::core::mem::offset_of!(atom_vram_module_v10, refreshrate) - 29usize];
    ["Offset of field: atom_vram_module_v10::vram_flags"]
        [::core::mem::offset_of!(atom_vram_module_v10, vram_flags) - 30usize];
    ["Offset of field: atom_vram_module_v10::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_module_v10, vram_rsd2) - 31usize];
    ["Offset of field: atom_vram_module_v10::gddr6_mr10"]
        [::core::mem::offset_of!(atom_vram_module_v10, gddr6_mr10) - 32usize];
    ["Offset of field: atom_vram_module_v10::gddr6_mr1"]
        [::core::mem::offset_of!(atom_vram_module_v10, gddr6_mr1) - 34usize];
    ["Offset of field: atom_vram_module_v10::gddr6_mr2"]
        [::core::mem::offset_of!(atom_vram_module_v10, gddr6_mr2) - 36usize];
    ["Offset of field: atom_vram_module_v10::gddr6_mr7"]
        [::core::mem::offset_of!(atom_vram_module_v10, gddr6_mr7) - 38usize];
    ["Offset of field: atom_vram_module_v10::dram_pnstring"]
        [::core::mem::offset_of!(atom_vram_module_v10, dram_pnstring) - 40usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_4 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub mem_clk_patch_tbloffset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub reserved: u16,
    pub post_ucode_init_offset: u16,
    pub vram_rsd2: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v10; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v2_4"]
        [::core::mem::size_of::<atom_vram_info_header_v2_4>() - 984usize];
    ["Alignment of atom_vram_info_header_v2_4"]
        [::core::mem::align_of::<atom_vram_info_header_v2_4>() - 1usize];
    ["Offset of field: atom_vram_info_header_v2_4::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v2_4::mem_adjust_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mem_adjust_tbloffset) - 4usize];
    ["Offset of field: atom_vram_info_header_v2_4::mem_clk_patch_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mem_clk_patch_tbloffset) - 6usize];
    ["Offset of field: atom_vram_info_header_v2_4::mc_adjust_pertile_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mc_adjust_pertile_tbloffset) - 8usize];
    ["Offset of field: atom_vram_info_header_v2_4::mc_phyinit_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mc_phyinit_tbloffset) - 10usize];
    ["Offset of field: atom_vram_info_header_v2_4::dram_data_remap_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, dram_data_remap_tbloffset) - 12usize];
    ["Offset of field: atom_vram_info_header_v2_4::reserved"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, reserved) - 14usize];
    ["Offset of field: atom_vram_info_header_v2_4::post_ucode_init_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, post_ucode_init_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v2_4::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, vram_rsd2) - 18usize];
    ["Offset of field: atom_vram_info_header_v2_4::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v2_4::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v2_4::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v2_4::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v2_4::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, vram_module) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v11 {
    pub memory_size: u32,
    pub channel_enable: u32,
    pub mem_voltage: u16,
    pub vram_module_size: u16,
    pub ext_memory_id: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub density: u8,
    pub tunningset_id: u8,
    pub reserved: [u16; 4usize],
    pub vender_rev_id: u8,
    pub refreshrate: u8,
    pub vram_flags: u8,
    pub vram_rsd2: u8,
    pub gddr6_mr10: u16,
    pub gddr6_mr0: u16,
    pub gddr6_mr1: u16,
    pub gddr6_mr2: u16,
    pub gddr6_mr4: u16,
    pub gddr6_mr7: u16,
    pub gddr6_mr8: u16,
    pub dram_pnstring: [::core::ffi::c_char; 40usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_module_v11"][::core::mem::size_of::<atom_vram_module_v11>() - 84usize];
    ["Alignment of atom_vram_module_v11"][::core::mem::align_of::<atom_vram_module_v11>() - 1usize];
    ["Offset of field: atom_vram_module_v11::memory_size"]
        [::core::mem::offset_of!(atom_vram_module_v11, memory_size) - 0usize];
    ["Offset of field: atom_vram_module_v11::channel_enable"]
        [::core::mem::offset_of!(atom_vram_module_v11, channel_enable) - 4usize];
    ["Offset of field: atom_vram_module_v11::mem_voltage"]
        [::core::mem::offset_of!(atom_vram_module_v11, mem_voltage) - 8usize];
    ["Offset of field: atom_vram_module_v11::vram_module_size"]
        [::core::mem::offset_of!(atom_vram_module_v11, vram_module_size) - 10usize];
    ["Offset of field: atom_vram_module_v11::ext_memory_id"]
        [::core::mem::offset_of!(atom_vram_module_v11, ext_memory_id) - 12usize];
    ["Offset of field: atom_vram_module_v11::memory_type"]
        [::core::mem::offset_of!(atom_vram_module_v11, memory_type) - 13usize];
    ["Offset of field: atom_vram_module_v11::channel_num"]
        [::core::mem::offset_of!(atom_vram_module_v11, channel_num) - 14usize];
    ["Offset of field: atom_vram_module_v11::channel_width"]
        [::core::mem::offset_of!(atom_vram_module_v11, channel_width) - 15usize];
    ["Offset of field: atom_vram_module_v11::density"]
        [::core::mem::offset_of!(atom_vram_module_v11, density) - 16usize];
    ["Offset of field: atom_vram_module_v11::tunningset_id"]
        [::core::mem::offset_of!(atom_vram_module_v11, tunningset_id) - 17usize];
    ["Offset of field: atom_vram_module_v11::reserved"]
        [::core::mem::offset_of!(atom_vram_module_v11, reserved) - 18usize];
    ["Offset of field: atom_vram_module_v11::vender_rev_id"]
        [::core::mem::offset_of!(atom_vram_module_v11, vender_rev_id) - 26usize];
    ["Offset of field: atom_vram_module_v11::refreshrate"]
        [::core::mem::offset_of!(atom_vram_module_v11, refreshrate) - 27usize];
    ["Offset of field: atom_vram_module_v11::vram_flags"]
        [::core::mem::offset_of!(atom_vram_module_v11, vram_flags) - 28usize];
    ["Offset of field: atom_vram_module_v11::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_module_v11, vram_rsd2) - 29usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr10"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr10) - 30usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr0"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr0) - 32usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr1"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr1) - 34usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr2"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr2) - 36usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr4"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr4) - 38usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr7"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr7) - 40usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr8"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr8) - 42usize];
    ["Offset of field: atom_vram_module_v11::dram_pnstring"]
        [::core::mem::offset_of!(atom_vram_module_v11, dram_pnstring) - 44usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gddr6_ac_timing_v2_5 {
    pub u32umc_id_access: u32,
    pub RL: u8,
    pub WL: u8,
    pub tRAS: u8,
    pub tRC: u8,
    pub tREFI: u16,
    pub tRFC: u8,
    pub tRFCpb: u8,
    pub tRREFD: u8,
    pub tRCDRD: u8,
    pub tRCDWR: u8,
    pub tRP: u8,
    pub tRRDS: u8,
    pub tRRDL: u8,
    pub tWR: u8,
    pub tWTRS: u8,
    pub tWTRL: u8,
    pub tFAW: u8,
    pub tCCDS: u8,
    pub tCCDL: u8,
    pub tCRCRL: u8,
    pub tCRCWL: u8,
    pub tCKE: u8,
    pub tCKSRE: u8,
    pub tCKSRX: u8,
    pub tRTPS: u8,
    pub tRTPL: u8,
    pub tMRD: u8,
    pub tMOD: u8,
    pub tXS: u8,
    pub tXHP: u8,
    pub tXSMRS: u8,
    pub tXSH: u32,
    pub tPD: u8,
    pub tXP: u8,
    pub tCPDED: u8,
    pub tACTPDE: u8,
    pub tPREPDE: u8,
    pub tREFPDE: u8,
    pub tMRSPDEN: u8,
    pub tRDSRE: u8,
    pub tWRSRE: u8,
    pub tPPD: u8,
    pub tCCDMW: u8,
    pub tWTRTR: u8,
    pub tLTLTR: u8,
    pub tREFTR: u8,
    pub VNDR: u8,
    pub reserved: [u8; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gddr6_ac_timing_v2_5"]
        [::core::mem::size_of::<atom_gddr6_ac_timing_v2_5>() - 64usize];
    ["Alignment of atom_gddr6_ac_timing_v2_5"]
        [::core::mem::align_of::<atom_gddr6_ac_timing_v2_5>() - 1usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::u32umc_id_access"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, u32umc_id_access) - 0usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::RL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, RL) - 4usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::WL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, WL) - 5usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRAS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRAS) - 6usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRC"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRC) - 7usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tREFI"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tREFI) - 8usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRFC"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRFC) - 10usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRFCpb"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRFCpb) - 11usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRREFD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRREFD) - 12usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRCDRD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRCDRD) - 13usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRCDWR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRCDWR) - 14usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRP"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRP) - 15usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRRDS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRRDS) - 16usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRRDL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRRDL) - 17usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWR) - 18usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWTRS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWTRS) - 19usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWTRL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWTRL) - 20usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tFAW"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tFAW) - 21usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCCDS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCCDS) - 22usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCCDL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCCDL) - 23usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCRCRL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCRCRL) - 24usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCRCWL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCRCWL) - 25usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCKE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCKE) - 26usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCKSRE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCKSRE) - 27usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCKSRX"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCKSRX) - 28usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRTPS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRTPS) - 29usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRTPL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRTPL) - 30usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tMRD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tMRD) - 31usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tMOD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tMOD) - 32usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXS) - 33usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXHP"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXHP) - 34usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXSMRS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXSMRS) - 35usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXSH"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXSH) - 36usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tPD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tPD) - 40usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXP"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXP) - 41usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCPDED"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCPDED) - 42usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tACTPDE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tACTPDE) - 43usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tPREPDE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tPREPDE) - 44usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tREFPDE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tREFPDE) - 45usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tMRSPDEN"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tMRSPDEN) - 46usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRDSRE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRDSRE) - 47usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWRSRE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWRSRE) - 48usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tPPD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tPPD) - 49usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCCDMW"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCCDMW) - 50usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWTRTR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWTRTR) - 51usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tLTLTR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tLTLTR) - 52usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tREFTR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tREFTR) - 53usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::VNDR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, VNDR) - 54usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::reserved"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, reserved) - 55usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gddr6_bit_byte_remap {
    pub dphy_byteremap: u32,
    pub dphy_bitremap0: u32,
    pub dphy_bitremap1: u32,
    pub dphy_bitremap2: u32,
    pub aphy_bitremap0: u32,
    pub aphy_bitremap1: u32,
    pub phy_dram: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gddr6_bit_byte_remap"]
        [::core::mem::size_of::<atom_gddr6_bit_byte_remap>() - 28usize];
    ["Alignment of atom_gddr6_bit_byte_remap"]
        [::core::mem::align_of::<atom_gddr6_bit_byte_remap>() - 1usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::dphy_byteremap"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, dphy_byteremap) - 0usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::dphy_bitremap0"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, dphy_bitremap0) - 4usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::dphy_bitremap1"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, dphy_bitremap1) - 8usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::dphy_bitremap2"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, dphy_bitremap2) - 12usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::aphy_bitremap0"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, aphy_bitremap0) - 16usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::aphy_bitremap1"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, aphy_bitremap1) - 20usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::phy_dram"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, phy_dram) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gddr6_dram_data_remap {
    pub table_size: u32,
    pub phyintf_ck_inverted: [u8; 8usize],
    pub bit_byte_remap: [atom_gddr6_bit_byte_remap; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gddr6_dram_data_remap"]
        [::core::mem::size_of::<atom_gddr6_dram_data_remap>() - 460usize];
    ["Alignment of atom_gddr6_dram_data_remap"]
        [::core::mem::align_of::<atom_gddr6_dram_data_remap>() - 1usize];
    ["Offset of field: atom_gddr6_dram_data_remap::table_size"]
        [::core::mem::offset_of!(atom_gddr6_dram_data_remap, table_size) - 0usize];
    ["Offset of field: atom_gddr6_dram_data_remap::phyintf_ck_inverted"]
        [::core::mem::offset_of!(atom_gddr6_dram_data_remap, phyintf_ck_inverted) - 4usize];
    ["Offset of field: atom_gddr6_dram_data_remap::bit_byte_remap"]
        [::core::mem::offset_of!(atom_gddr6_dram_data_remap, bit_byte_remap) - 12usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_5 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub gddr6_ac_timing_offset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub reserved: u16,
    pub post_ucode_init_offset: u16,
    pub strobe_mode_patch_tbloffset: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v11; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v2_5"]
        [::core::mem::size_of::<atom_vram_info_header_v2_5>() - 1368usize];
    ["Alignment of atom_vram_info_header_v2_5"]
        [::core::mem::align_of::<atom_vram_info_header_v2_5>() - 1usize];
    ["Offset of field: atom_vram_info_header_v2_5::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v2_5::mem_adjust_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, mem_adjust_tbloffset) - 4usize];
    ["Offset of field: atom_vram_info_header_v2_5::gddr6_ac_timing_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, gddr6_ac_timing_offset) - 6usize];
    ["Offset of field: atom_vram_info_header_v2_5::mc_adjust_pertile_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, mc_adjust_pertile_tbloffset) - 8usize];
    ["Offset of field: atom_vram_info_header_v2_5::mc_phyinit_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, mc_phyinit_tbloffset) - 10usize];
    ["Offset of field: atom_vram_info_header_v2_5::dram_data_remap_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, dram_data_remap_tbloffset) - 12usize];
    ["Offset of field: atom_vram_info_header_v2_5::reserved"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, reserved) - 14usize];
    ["Offset of field: atom_vram_info_header_v2_5::post_ucode_init_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, post_ucode_init_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v2_5::strobe_mode_patch_tbloffset"][::core::mem::offset_of!(
        atom_vram_info_header_v2_5,
        strobe_mode_patch_tbloffset
    ) - 18usize];
    ["Offset of field: atom_vram_info_header_v2_5::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v2_5::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v2_5::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v2_5::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v2_5::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, vram_module) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_6 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub mem_clk_patch_tbloffset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub tmrs_seq_offset: u16,
    pub post_ucode_init_offset: u16,
    pub vram_rsd2: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v9; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v2_6"]
        [::core::mem::size_of::<atom_vram_info_header_v2_6>() - 856usize];
    ["Alignment of atom_vram_info_header_v2_6"]
        [::core::mem::align_of::<atom_vram_info_header_v2_6>() - 1usize];
    ["Offset of field: atom_vram_info_header_v2_6::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v2_6::mem_adjust_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mem_adjust_tbloffset) - 4usize];
    ["Offset of field: atom_vram_info_header_v2_6::mem_clk_patch_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mem_clk_patch_tbloffset) - 6usize];
    ["Offset of field: atom_vram_info_header_v2_6::mc_adjust_pertile_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mc_adjust_pertile_tbloffset) - 8usize];
    ["Offset of field: atom_vram_info_header_v2_6::mc_phyinit_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mc_phyinit_tbloffset) - 10usize];
    ["Offset of field: atom_vram_info_header_v2_6::dram_data_remap_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, dram_data_remap_tbloffset) - 12usize];
    ["Offset of field: atom_vram_info_header_v2_6::tmrs_seq_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, tmrs_seq_offset) - 14usize];
    ["Offset of field: atom_vram_info_header_v2_6::post_ucode_init_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, post_ucode_init_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v2_6::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, vram_rsd2) - 18usize];
    ["Offset of field: atom_vram_info_header_v2_6::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v2_6::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v2_6::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v2_6::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v2_6::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, vram_module) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_data_entry {
    pub i2c_reg_index: u16,
    pub i2c_reg_data: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_i2c_data_entry"][::core::mem::size_of::<atom_i2c_data_entry>() - 4usize];
    ["Alignment of atom_i2c_data_entry"][::core::mem::align_of::<atom_i2c_data_entry>() - 1usize];
    ["Offset of field: atom_i2c_data_entry::i2c_reg_index"]
        [::core::mem::offset_of!(atom_i2c_data_entry, i2c_reg_index) - 0usize];
    ["Offset of field: atom_i2c_data_entry::i2c_reg_data"]
        [::core::mem::offset_of!(atom_i2c_data_entry, i2c_reg_data) - 2usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_voltage_object_header_v4 {
    pub voltage_type: u8,
    pub voltage_mode: u8,
    pub object_size: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_voltage_object_header_v4"]
        [::core::mem::size_of::<atom_voltage_object_header_v4>() - 4usize];
    ["Alignment of atom_voltage_object_header_v4"]
        [::core::mem::align_of::<atom_voltage_object_header_v4>() - 1usize];
    ["Offset of field: atom_voltage_object_header_v4::voltage_type"]
        [::core::mem::offset_of!(atom_voltage_object_header_v4, voltage_type) - 0usize];
    ["Offset of field: atom_voltage_object_header_v4::voltage_mode"]
        [::core::mem::offset_of!(atom_voltage_object_header_v4, voltage_mode) - 1usize];
    ["Offset of field: atom_voltage_object_header_v4::object_size"]
        [::core::mem::offset_of!(atom_voltage_object_header_v4, object_size) - 2usize];
};
pub const atom_voltage_object_mode_VOLTAGE_OBJ_GPIO_LUT: atom_voltage_object_mode = 0;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_VR_I2C_INIT_SEQ: atom_voltage_object_mode = 3;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_PHASE_LUT: atom_voltage_object_mode = 4;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_SVID2: atom_voltage_object_mode = 7;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_EVV: atom_voltage_object_mode = 8;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_MERGED_POWER: atom_voltage_object_mode = 9;
pub type atom_voltage_object_mode = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub regulator_id: u8,
    pub i2c_id: u8,
    pub i2c_slave_addr: u8,
    pub i2c_control_offset: u8,
    pub i2c_flag: u8,
    pub i2c_speed: u8,
    pub reserved: [u8; 2usize],
    pub i2cdatalut: [atom_i2c_data_entry; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_i2c_voltage_object_v4"]
        [::core::mem::size_of::<atom_i2c_voltage_object_v4>() - 16usize];
    ["Alignment of atom_i2c_voltage_object_v4"]
        [::core::mem::align_of::<atom_i2c_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_i2c_voltage_object_v4::header"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, header) - 0usize];
    ["Offset of field: atom_i2c_voltage_object_v4::regulator_id"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, regulator_id) - 4usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_id"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_id) - 5usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_slave_addr"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_slave_addr) - 6usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_control_offset"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_control_offset) - 7usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_flag"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_flag) - 8usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_speed"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_speed) - 9usize];
    ["Offset of field: atom_i2c_voltage_object_v4::reserved"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, reserved) - 10usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2cdatalut"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2cdatalut) - 12usize];
};
pub const atom_i2c_voltage_control_flag_VOLTAGE_DATA_ONE_BYTE: atom_i2c_voltage_control_flag = 0;
pub const atom_i2c_voltage_control_flag_VOLTAGE_DATA_TWO_BYTE: atom_i2c_voltage_control_flag = 1;
pub type atom_i2c_voltage_control_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_voltage_gpio_map_lut {
    pub voltage_gpio_reg_val: u32,
    pub voltage_level_mv: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_voltage_gpio_map_lut"]
        [::core::mem::size_of::<atom_voltage_gpio_map_lut>() - 6usize];
    ["Alignment of atom_voltage_gpio_map_lut"]
        [::core::mem::align_of::<atom_voltage_gpio_map_lut>() - 1usize];
    ["Offset of field: atom_voltage_gpio_map_lut::voltage_gpio_reg_val"]
        [::core::mem::offset_of!(atom_voltage_gpio_map_lut, voltage_gpio_reg_val) - 0usize];
    ["Offset of field: atom_voltage_gpio_map_lut::voltage_level_mv"]
        [::core::mem::offset_of!(atom_voltage_gpio_map_lut, voltage_level_mv) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub gpio_control_id: u8,
    pub gpio_entry_num: u8,
    pub phase_delay_us: u8,
    pub reserved: u8,
    pub gpio_mask_val: u32,
    pub voltage_gpio_lut: [atom_voltage_gpio_map_lut; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gpio_voltage_object_v4"]
        [::core::mem::size_of::<atom_gpio_voltage_object_v4>() - 18usize];
    ["Alignment of atom_gpio_voltage_object_v4"]
        [::core::mem::align_of::<atom_gpio_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_gpio_voltage_object_v4::header"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, header) - 0usize];
    ["Offset of field: atom_gpio_voltage_object_v4::gpio_control_id"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, gpio_control_id) - 4usize];
    ["Offset of field: atom_gpio_voltage_object_v4::gpio_entry_num"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, gpio_entry_num) - 5usize];
    ["Offset of field: atom_gpio_voltage_object_v4::phase_delay_us"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, phase_delay_us) - 6usize];
    ["Offset of field: atom_gpio_voltage_object_v4::reserved"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, reserved) - 7usize];
    ["Offset of field: atom_gpio_voltage_object_v4::gpio_mask_val"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, gpio_mask_val) - 8usize];
    ["Offset of field: atom_gpio_voltage_object_v4::voltage_gpio_lut"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, voltage_gpio_lut) - 12usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_svid2_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub loadline_psi1: u8,
    pub psi0_l_vid_thresd: u8,
    pub psi0_enable: u8,
    pub maxvstep: u8,
    pub telemetry_offset: u8,
    pub telemetry_gain: u8,
    pub reserved1: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_svid2_voltage_object_v4"]
        [::core::mem::size_of::<atom_svid2_voltage_object_v4>() - 12usize];
    ["Alignment of atom_svid2_voltage_object_v4"]
        [::core::mem::align_of::<atom_svid2_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_svid2_voltage_object_v4::header"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, header) - 0usize];
    ["Offset of field: atom_svid2_voltage_object_v4::loadline_psi1"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, loadline_psi1) - 4usize];
    ["Offset of field: atom_svid2_voltage_object_v4::psi0_l_vid_thresd"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, psi0_l_vid_thresd) - 5usize];
    ["Offset of field: atom_svid2_voltage_object_v4::psi0_enable"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, psi0_enable) - 6usize];
    ["Offset of field: atom_svid2_voltage_object_v4::maxvstep"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, maxvstep) - 7usize];
    ["Offset of field: atom_svid2_voltage_object_v4::telemetry_offset"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, telemetry_offset) - 8usize];
    ["Offset of field: atom_svid2_voltage_object_v4::telemetry_gain"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, telemetry_gain) - 9usize];
    ["Offset of field: atom_svid2_voltage_object_v4::reserved1"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, reserved1) - 10usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_merged_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub merged_powerrail_type: u8,
    pub reserved: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_merged_voltage_object_v4"]
        [::core::mem::size_of::<atom_merged_voltage_object_v4>() - 8usize];
    ["Alignment of atom_merged_voltage_object_v4"]
        [::core::mem::align_of::<atom_merged_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_merged_voltage_object_v4::header"]
        [::core::mem::offset_of!(atom_merged_voltage_object_v4, header) - 0usize];
    ["Offset of field: atom_merged_voltage_object_v4::merged_powerrail_type"]
        [::core::mem::offset_of!(atom_merged_voltage_object_v4, merged_powerrail_type) - 4usize];
    ["Offset of field: atom_merged_voltage_object_v4::reserved"]
        [::core::mem::offset_of!(atom_merged_voltage_object_v4, reserved) - 5usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union atom_voltage_object_v4 {
    pub gpio_voltage_obj: atom_gpio_voltage_object_v4,
    pub i2c_voltage_obj: atom_i2c_voltage_object_v4,
    pub svid2_voltage_obj: atom_svid2_voltage_object_v4,
    pub merged_voltage_obj: atom_merged_voltage_object_v4,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_voltage_object_v4"][::core::mem::size_of::<atom_voltage_object_v4>() - 18usize];
    ["Alignment of atom_voltage_object_v4"]
        [::core::mem::align_of::<atom_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_voltage_object_v4::gpio_voltage_obj"]
        [::core::mem::offset_of!(atom_voltage_object_v4, gpio_voltage_obj) - 0usize];
    ["Offset of field: atom_voltage_object_v4::i2c_voltage_obj"]
        [::core::mem::offset_of!(atom_voltage_object_v4, i2c_voltage_obj) - 0usize];
    ["Offset of field: atom_voltage_object_v4::svid2_voltage_obj"]
        [::core::mem::offset_of!(atom_voltage_object_v4, svid2_voltage_obj) - 0usize];
    ["Offset of field: atom_voltage_object_v4::merged_voltage_obj"]
        [::core::mem::offset_of!(atom_voltage_object_v4, merged_voltage_obj) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct atom_voltage_objects_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub voltage_object: [atom_voltage_object_v4; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_voltage_objects_info_v4_1"]
        [::core::mem::size_of::<atom_voltage_objects_info_v4_1>() - 22usize];
    ["Alignment of atom_voltage_objects_info_v4_1"]
        [::core::mem::align_of::<atom_voltage_objects_info_v4_1>() - 1usize];
    ["Offset of field: atom_voltage_objects_info_v4_1::table_header"]
        [::core::mem::offset_of!(atom_voltage_objects_info_v4_1, table_header) - 0usize];
    ["Offset of field: atom_voltage_objects_info_v4_1::voltage_object"]
        [::core::mem::offset_of!(atom_voltage_objects_info_v4_1, voltage_object) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_engine_parameters {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of asic_init_engine_parameters"]
        [::core::mem::size_of::<asic_init_engine_parameters>() - 4usize];
    ["Alignment of asic_init_engine_parameters"]
        [::core::mem::align_of::<asic_init_engine_parameters>() - 1usize];
};
impl asic_init_engine_parameters {
    #[inline]
    pub fn sclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_sclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn engineflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_engineflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sclkfreqin10khz: u32,
        engineflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let sclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(sclkfreqin10khz) };
            sclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let engineflag: u32 = unsafe { ::core::mem::transmute(engineflag) };
            engineflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_mem_parameters {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of asic_init_mem_parameters"]
        [::core::mem::size_of::<asic_init_mem_parameters>() - 4usize];
    ["Alignment of asic_init_mem_parameters"]
        [::core::mem::align_of::<asic_init_mem_parameters>() - 1usize];
};
impl asic_init_mem_parameters {
    #[inline]
    pub fn mclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_mclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn memflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_memflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mclkfreqin10khz: u32,
        memflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let mclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(mclkfreqin10khz) };
            mclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let memflag: u32 = unsafe { ::core::mem::transmute(memflag) };
            memflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_parameters_v2_1 {
    pub engineparam: asic_init_engine_parameters,
    pub memparam: asic_init_mem_parameters,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of asic_init_parameters_v2_1"]
        [::core::mem::size_of::<asic_init_parameters_v2_1>() - 8usize];
    ["Alignment of asic_init_parameters_v2_1"]
        [::core::mem::align_of::<asic_init_parameters_v2_1>() - 1usize];
    ["Offset of field: asic_init_parameters_v2_1::engineparam"]
        [::core::mem::offset_of!(asic_init_parameters_v2_1, engineparam) - 0usize];
    ["Offset of field: asic_init_parameters_v2_1::memparam"]
        [::core::mem::offset_of!(asic_init_parameters_v2_1, memparam) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_ps_allocation_v2_1 {
    pub param: asic_init_parameters_v2_1,
    pub reserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of asic_init_ps_allocation_v2_1"]
        [::core::mem::size_of::<asic_init_ps_allocation_v2_1>() - 72usize];
    ["Alignment of asic_init_ps_allocation_v2_1"]
        [::core::mem::align_of::<asic_init_ps_allocation_v2_1>() - 1usize];
    ["Offset of field: asic_init_ps_allocation_v2_1::param"]
        [::core::mem::offset_of!(asic_init_ps_allocation_v2_1, param) - 0usize];
    ["Offset of field: asic_init_ps_allocation_v2_1::reserved"]
        [::core::mem::offset_of!(asic_init_ps_allocation_v2_1, reserved) - 8usize];
};
pub const atom_asic_init_engine_flag_b3NORMAL_ENGINE_INIT: atom_asic_init_engine_flag = 0;
pub const atom_asic_init_engine_flag_b3SRIOV_SKIP_ASIC_INIT: atom_asic_init_engine_flag = 2;
pub const atom_asic_init_engine_flag_b3SRIOV_LOAD_UCODE: atom_asic_init_engine_flag = 64;
pub type atom_asic_init_engine_flag = ::core::ffi::c_uint;
pub const atom_asic_init_mem_flag_b3NORMAL_MEM_INIT: atom_asic_init_mem_flag = 0;
pub const atom_asic_init_mem_flag_b3DRAM_SELF_REFRESH_EXIT: atom_asic_init_mem_flag = 32;
pub type atom_asic_init_mem_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_engine_clock_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_engine_clock_parameters_v2_1"]
        [::core::mem::size_of::<set_engine_clock_parameters_v2_1>() - 44usize];
    ["Alignment of set_engine_clock_parameters_v2_1"]
        [::core::mem::align_of::<set_engine_clock_parameters_v2_1>() - 1usize];
    ["Offset of field: set_engine_clock_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(set_engine_clock_parameters_v2_1, reserved) - 4usize];
};
impl set_engine_clock_parameters_v2_1 {
    #[inline]
    pub fn sclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_sclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn sclkflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_sclkflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sclkfreqin10khz: u32,
        sclkflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let sclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(sclkfreqin10khz) };
            sclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let sclkflag: u32 = unsafe { ::core::mem::transmute(sclkflag) };
            sclkflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_engine_clock_ps_allocation_v2_1 {
    pub clockinfo: set_engine_clock_parameters_v2_1,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_engine_clock_ps_allocation_v2_1"]
        [::core::mem::size_of::<set_engine_clock_ps_allocation_v2_1>() - 84usize];
    ["Alignment of set_engine_clock_ps_allocation_v2_1"]
        [::core::mem::align_of::<set_engine_clock_ps_allocation_v2_1>() - 1usize];
    ["Offset of field: set_engine_clock_ps_allocation_v2_1::clockinfo"]
        [::core::mem::offset_of!(set_engine_clock_ps_allocation_v2_1, clockinfo) - 0usize];
    ["Offset of field: set_engine_clock_ps_allocation_v2_1::reserved"]
        [::core::mem::offset_of!(set_engine_clock_ps_allocation_v2_1, reserved) - 44usize];
};
pub const atom_set_engine_mem_clock_flag_b3NORMAL_CHANGE_CLOCK: atom_set_engine_mem_clock_flag = 0;
pub const atom_set_engine_mem_clock_flag_b3FIRST_TIME_CHANGE_CLOCK: atom_set_engine_mem_clock_flag =
    8;
pub const atom_set_engine_mem_clock_flag_b3STORE_DPM_TRAINGING: atom_set_engine_mem_clock_flag = 64;
pub type atom_set_engine_mem_clock_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct get_engine_clock_parameter {
    pub sclk_10khz: u32,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of get_engine_clock_parameter"]
        [::core::mem::size_of::<get_engine_clock_parameter>() - 8usize];
    ["Alignment of get_engine_clock_parameter"]
        [::core::mem::align_of::<get_engine_clock_parameter>() - 1usize];
    ["Offset of field: get_engine_clock_parameter::sclk_10khz"]
        [::core::mem::offset_of!(get_engine_clock_parameter, sclk_10khz) - 0usize];
    ["Offset of field: get_engine_clock_parameter::reserved"]
        [::core::mem::offset_of!(get_engine_clock_parameter, reserved) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_memory_clock_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_memory_clock_parameters_v2_1"]
        [::core::mem::size_of::<set_memory_clock_parameters_v2_1>() - 44usize];
    ["Alignment of set_memory_clock_parameters_v2_1"]
        [::core::mem::align_of::<set_memory_clock_parameters_v2_1>() - 1usize];
    ["Offset of field: set_memory_clock_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(set_memory_clock_parameters_v2_1, reserved) - 4usize];
};
impl set_memory_clock_parameters_v2_1 {
    #[inline]
    pub fn mclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_mclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn mclkflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_mclkflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mclkfreqin10khz: u32,
        mclkflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let mclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(mclkfreqin10khz) };
            mclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let mclkflag: u32 = unsafe { ::core::mem::transmute(mclkflag) };
            mclkflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_memory_clock_ps_allocation_v2_1 {
    pub clockinfo: set_memory_clock_parameters_v2_1,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_memory_clock_ps_allocation_v2_1"]
        [::core::mem::size_of::<set_memory_clock_ps_allocation_v2_1>() - 84usize];
    ["Alignment of set_memory_clock_ps_allocation_v2_1"]
        [::core::mem::align_of::<set_memory_clock_ps_allocation_v2_1>() - 1usize];
    ["Offset of field: set_memory_clock_ps_allocation_v2_1::clockinfo"]
        [::core::mem::offset_of!(set_memory_clock_ps_allocation_v2_1, clockinfo) - 0usize];
    ["Offset of field: set_memory_clock_ps_allocation_v2_1::reserved"]
        [::core::mem::offset_of!(set_memory_clock_ps_allocation_v2_1, reserved) - 44usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct get_memory_clock_parameter {
    pub mclk_10khz: u32,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of get_memory_clock_parameter"]
        [::core::mem::size_of::<get_memory_clock_parameter>() - 8usize];
    ["Alignment of get_memory_clock_parameter"]
        [::core::mem::align_of::<get_memory_clock_parameter>() - 1usize];
    ["Offset of field: get_memory_clock_parameter::mclk_10khz"]
        [::core::mem::offset_of!(get_memory_clock_parameter, mclk_10khz) - 0usize];
    ["Offset of field: get_memory_clock_parameter::reserved"]
        [::core::mem::offset_of!(get_memory_clock_parameter, reserved) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_voltage_parameters_v1_4 {
    pub voltagetype: u8,
    pub command: u8,
    pub vlevel_mv: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_voltage_parameters_v1_4"]
        [::core::mem::size_of::<set_voltage_parameters_v1_4>() - 4usize];
    ["Alignment of set_voltage_parameters_v1_4"]
        [::core::mem::align_of::<set_voltage_parameters_v1_4>() - 1usize];
    ["Offset of field: set_voltage_parameters_v1_4::voltagetype"]
        [::core::mem::offset_of!(set_voltage_parameters_v1_4, voltagetype) - 0usize];
    ["Offset of field: set_voltage_parameters_v1_4::command"]
        [::core::mem::offset_of!(set_voltage_parameters_v1_4, command) - 1usize];
    ["Offset of field: set_voltage_parameters_v1_4::vlevel_mv"]
        [::core::mem::offset_of!(set_voltage_parameters_v1_4, vlevel_mv) - 2usize];
};
pub const atom_set_voltage_command_ATOM_SET_VOLTAGE: atom_set_voltage_command = 0;
pub const atom_set_voltage_command_ATOM_INIT_VOLTAGE_REGULATOR: atom_set_voltage_command = 3;
pub const atom_set_voltage_command_ATOM_SET_VOLTAGE_PHASE: atom_set_voltage_command = 4;
pub const atom_set_voltage_command_ATOM_GET_LEAKAGE_ID: atom_set_voltage_command = 8;
pub type atom_set_voltage_command = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_voltage_ps_allocation_v1_4 {
    pub setvoltageparam: set_voltage_parameters_v1_4,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_voltage_ps_allocation_v1_4"]
        [::core::mem::size_of::<set_voltage_ps_allocation_v1_4>() - 44usize];
    ["Alignment of set_voltage_ps_allocation_v1_4"]
        [::core::mem::align_of::<set_voltage_ps_allocation_v1_4>() - 1usize];
    ["Offset of field: set_voltage_ps_allocation_v1_4::setvoltageparam"]
        [::core::mem::offset_of!(set_voltage_ps_allocation_v1_4, setvoltageparam) - 0usize];
    ["Offset of field: set_voltage_ps_allocation_v1_4::reserved"]
        [::core::mem::offset_of!(set_voltage_ps_allocation_v1_4, reserved) - 4usize];
};
pub const atom_gpu_clock_type_COMPUTE_GPUCLK_INPUT_FLAG_DEFAULT_GPUCLK: atom_gpu_clock_type = 0;
pub const atom_gpu_clock_type_COMPUTE_GPUCLK_INPUT_FLAG_GFXCLK: atom_gpu_clock_type = 1;
pub const atom_gpu_clock_type_COMPUTE_GPUCLK_INPUT_FLAG_UCLK: atom_gpu_clock_type = 2;
pub type atom_gpu_clock_type = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct compute_gpu_clock_input_parameter_v1_8 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: [u32; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of compute_gpu_clock_input_parameter_v1_8"]
        [::core::mem::size_of::<compute_gpu_clock_input_parameter_v1_8>() - 24usize];
    ["Alignment of compute_gpu_clock_input_parameter_v1_8"]
        [::core::mem::align_of::<compute_gpu_clock_input_parameter_v1_8>() - 1usize];
    ["Offset of field: compute_gpu_clock_input_parameter_v1_8::reserved"]
        [::core::mem::offset_of!(compute_gpu_clock_input_parameter_v1_8, reserved) - 4usize];
};
impl compute_gpu_clock_input_parameter_v1_8 {
    #[inline]
    pub fn gpuclock_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_gpuclock_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn gpu_clock_type(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_gpu_clock_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        gpuclock_10khz: u32,
        gpu_clock_type: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let gpuclock_10khz: u32 = unsafe { ::core::mem::transmute(gpuclock_10khz) };
            gpuclock_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let gpu_clock_type: u32 = unsafe { ::core::mem::transmute(gpu_clock_type) };
            gpu_clock_type as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct compute_gpu_clock_output_parameter_v1_8 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub pll_fb_mult: u32,
    pub pll_ss_fbsmult: u32,
    pub pll_ss_slew_frac: u16,
    pub pll_ss_enable: u8,
    pub reserved: u8,
    pub reserved1: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of compute_gpu_clock_output_parameter_v1_8"]
        [::core::mem::size_of::<compute_gpu_clock_output_parameter_v1_8>() - 24usize];
    ["Alignment of compute_gpu_clock_output_parameter_v1_8"]
        [::core::mem::align_of::<compute_gpu_clock_output_parameter_v1_8>() - 1usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::pll_fb_mult"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, pll_fb_mult) - 4usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::pll_ss_fbsmult"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, pll_ss_fbsmult) - 8usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::pll_ss_slew_frac"][::core::mem::offset_of!(
        compute_gpu_clock_output_parameter_v1_8,
        pll_ss_slew_frac
    ) - 12usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::pll_ss_enable"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, pll_ss_enable) - 14usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::reserved"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, reserved) - 15usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::reserved1"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, reserved1) - 16usize];
};
impl compute_gpu_clock_output_parameter_v1_8 {
    #[inline]
    pub fn gpuclock_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_gpuclock_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn dfs_did(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_dfs_did(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        gpuclock_10khz: u32,
        dfs_did: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let gpuclock_10khz: u32 = unsafe { ::core::mem::transmute(gpuclock_10khz) };
            gpuclock_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let dfs_did: u32 = unsafe { ::core::mem::transmute(dfs_did) };
            dfs_did as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct read_efuse_input_parameters_v3_1 {
    pub efuse_start_index: u16,
    pub reserved: u8,
    pub bitslen: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of read_efuse_input_parameters_v3_1"]
        [::core::mem::size_of::<read_efuse_input_parameters_v3_1>() - 4usize];
    ["Alignment of read_efuse_input_parameters_v3_1"]
        [::core::mem::align_of::<read_efuse_input_parameters_v3_1>() - 1usize];
    ["Offset of field: read_efuse_input_parameters_v3_1::efuse_start_index"]
        [::core::mem::offset_of!(read_efuse_input_parameters_v3_1, efuse_start_index) - 0usize];
    ["Offset of field: read_efuse_input_parameters_v3_1::reserved"]
        [::core::mem::offset_of!(read_efuse_input_parameters_v3_1, reserved) - 2usize];
    ["Offset of field: read_efuse_input_parameters_v3_1::bitslen"]
        [::core::mem::offset_of!(read_efuse_input_parameters_v3_1, bitslen) - 3usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union read_efuse_value_parameters_v3_1 {
    pub efuse_info: read_efuse_input_parameters_v3_1,
    pub efusevalue: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of read_efuse_value_parameters_v3_1"]
        [::core::mem::size_of::<read_efuse_value_parameters_v3_1>() - 4usize];
    ["Alignment of read_efuse_value_parameters_v3_1"]
        [::core::mem::align_of::<read_efuse_value_parameters_v3_1>() - 1usize];
    ["Offset of field: read_efuse_value_parameters_v3_1::efuse_info"]
        [::core::mem::offset_of!(read_efuse_value_parameters_v3_1, efuse_info) - 0usize];
    ["Offset of field: read_efuse_value_parameters_v3_1::efusevalue"]
        [::core::mem::offset_of!(read_efuse_value_parameters_v3_1, efusevalue) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_get_smu_clock_info_parameters_v3_1 {
    pub syspll_id: u8,
    pub clk_id: u8,
    pub command: u8,
    pub dfsdid: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_get_smu_clock_info_parameters_v3_1"]
        [::core::mem::size_of::<atom_get_smu_clock_info_parameters_v3_1>() - 4usize];
    ["Alignment of atom_get_smu_clock_info_parameters_v3_1"]
        [::core::mem::align_of::<atom_get_smu_clock_info_parameters_v3_1>() - 1usize];
    ["Offset of field: atom_get_smu_clock_info_parameters_v3_1::syspll_id"]
        [::core::mem::offset_of!(atom_get_smu_clock_info_parameters_v3_1, syspll_id) - 0usize];
    ["Offset of field: atom_get_smu_clock_info_parameters_v3_1::clk_id"]
        [::core::mem::offset_of!(atom_get_smu_clock_info_parameters_v3_1, clk_id) - 1usize];
    ["Offset of field: atom_get_smu_clock_info_parameters_v3_1::command"]
        [::core::mem::offset_of!(atom_get_smu_clock_info_parameters_v3_1, command) - 2usize];
    ["Offset of field: atom_get_smu_clock_info_parameters_v3_1::dfsdid"]
        [::core::mem::offset_of!(atom_get_smu_clock_info_parameters_v3_1, dfsdid) - 3usize];
};
pub const atom_get_smu_clock_info_command_GET_SMU_CLOCK_INFO_V3_1_GET_CLOCK_FREQ:
    atom_get_smu_clock_info_command = 0;
pub const atom_get_smu_clock_info_command_GET_SMU_CLOCK_INFO_V3_1_GET_PLLVCO_FREQ:
    atom_get_smu_clock_info_command = 1;
pub const atom_get_smu_clock_info_command_GET_SMU_CLOCK_INFO_V3_1_GET_PLLREFCLK_FREQ:
    atom_get_smu_clock_info_command = 2;
pub type atom_get_smu_clock_info_command = ::core::ffi::c_uint;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_SMNCLK_ID: atom_smu9_syspll0_clock_id = 0;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_SOCCLK_ID: atom_smu9_syspll0_clock_id = 1;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_MP0CLK_ID: atom_smu9_syspll0_clock_id = 2;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_MP1CLK_ID: atom_smu9_syspll0_clock_id = 3;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_LCLK_ID: atom_smu9_syspll0_clock_id = 4;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DCLK_ID: atom_smu9_syspll0_clock_id = 5;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_VCLK_ID: atom_smu9_syspll0_clock_id = 6;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_ECLK_ID: atom_smu9_syspll0_clock_id = 7;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DCEFCLK_ID: atom_smu9_syspll0_clock_id = 8;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DPREFCLK_ID: atom_smu9_syspll0_clock_id = 10;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DISPCLK_ID: atom_smu9_syspll0_clock_id = 11;
pub type atom_smu9_syspll0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll_id_SMU11_SYSPLL0_ID: atom_smu11_syspll_id = 0;
pub const atom_smu11_syspll_id_SMU11_SYSPLL1_0_ID: atom_smu11_syspll_id = 1;
pub const atom_smu11_syspll_id_SMU11_SYSPLL1_1_ID: atom_smu11_syspll_id = 2;
pub const atom_smu11_syspll_id_SMU11_SYSPLL1_2_ID: atom_smu11_syspll_id = 3;
pub const atom_smu11_syspll_id_SMU11_SYSPLL2_ID: atom_smu11_syspll_id = 4;
pub const atom_smu11_syspll_id_SMU11_SYSPLL3_0_ID: atom_smu11_syspll_id = 5;
pub const atom_smu11_syspll_id_SMU11_SYSPLL3_1_ID: atom_smu11_syspll_id = 6;
pub type atom_smu11_syspll_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_ECLK_ID: atom_smu11_syspll0_clock_id = 0;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_SOCCLK_ID: atom_smu11_syspll0_clock_id = 1;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_MP0CLK_ID: atom_smu11_syspll0_clock_id = 2;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_DCLK_ID: atom_smu11_syspll0_clock_id = 3;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_VCLK_ID: atom_smu11_syspll0_clock_id = 4;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_DCEFCLK_ID: atom_smu11_syspll0_clock_id = 5;
pub type atom_smu11_syspll0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll1_0_clock_id_SMU11_SYSPLL1_0_UCLKA_ID: atom_smu11_syspll1_0_clock_id = 0;
pub type atom_smu11_syspll1_0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll1_1_clock_id_SMU11_SYSPLL1_0_UCLKB_ID: atom_smu11_syspll1_1_clock_id = 0;
pub type atom_smu11_syspll1_1_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll1_2_clock_id_SMU11_SYSPLL1_0_FCLK_ID: atom_smu11_syspll1_2_clock_id = 0;
pub type atom_smu11_syspll1_2_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll2_clock_id_SMU11_SYSPLL2_GFXCLK_ID: atom_smu11_syspll2_clock_id = 0;
pub type atom_smu11_syspll2_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll3_0_clock_id_SMU11_SYSPLL3_0_WAFCLK_ID: atom_smu11_syspll3_0_clock_id =
    0;
pub const atom_smu11_syspll3_0_clock_id_SMU11_SYSPLL3_0_DISPCLK_ID: atom_smu11_syspll3_0_clock_id =
    1;
pub const atom_smu11_syspll3_0_clock_id_SMU11_SYSPLL3_0_DPREFCLK_ID: atom_smu11_syspll3_0_clock_id =
    2;
pub type atom_smu11_syspll3_0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll3_1_clock_id_SMU11_SYSPLL3_1_MP1CLK_ID: atom_smu11_syspll3_1_clock_id =
    0;
pub const atom_smu11_syspll3_1_clock_id_SMU11_SYSPLL3_1_SMNCLK_ID: atom_smu11_syspll3_1_clock_id =
    1;
pub const atom_smu11_syspll3_1_clock_id_SMU11_SYSPLL3_1_LCLK_ID: atom_smu11_syspll3_1_clock_id = 2;
pub type atom_smu11_syspll3_1_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll_id_SMU12_SYSPLL0_ID: atom_smu12_syspll_id = 0;
pub const atom_smu12_syspll_id_SMU12_SYSPLL1_ID: atom_smu12_syspll_id = 1;
pub const atom_smu12_syspll_id_SMU12_SYSPLL2_ID: atom_smu12_syspll_id = 2;
pub const atom_smu12_syspll_id_SMU12_SYSPLL3_0_ID: atom_smu12_syspll_id = 3;
pub const atom_smu12_syspll_id_SMU12_SYSPLL3_1_ID: atom_smu12_syspll_id = 4;
pub type atom_smu12_syspll_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_SMNCLK_ID: atom_smu12_syspll0_clock_id = 0;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_SOCCLK_ID: atom_smu12_syspll0_clock_id = 1;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_MP0CLK_ID: atom_smu12_syspll0_clock_id = 2;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_MP1CLK_ID: atom_smu12_syspll0_clock_id = 3;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_MP2CLK_ID: atom_smu12_syspll0_clock_id = 4;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_VCLK_ID: atom_smu12_syspll0_clock_id = 5;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_LCLK_ID: atom_smu12_syspll0_clock_id = 6;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_DCLK_ID: atom_smu12_syspll0_clock_id = 7;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_ACLK_ID: atom_smu12_syspll0_clock_id = 8;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_ISPCLK_ID: atom_smu12_syspll0_clock_id = 9;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_SHUBCLK_ID: atom_smu12_syspll0_clock_id = 10;
pub type atom_smu12_syspll0_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DISPCLK_ID: atom_smu12_syspll1_clock_id = 0;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DPPCLK_ID: atom_smu12_syspll1_clock_id = 1;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DPREFCLK_ID: atom_smu12_syspll1_clock_id = 2;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DCFCLK_ID: atom_smu12_syspll1_clock_id = 3;
pub type atom_smu12_syspll1_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll2_clock_id_SMU12_SYSPLL2_Pre_GFXCLK_ID: atom_smu12_syspll2_clock_id = 0;
pub type atom_smu12_syspll2_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll3_0_clock_id_SMU12_SYSPLL3_0_FCLK_ID: atom_smu12_syspll3_0_clock_id = 0;
pub type atom_smu12_syspll3_0_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll3_1_clock_id_SMU12_SYSPLL3_1_UMCCLK_ID: atom_smu12_syspll3_1_clock_id =
    0;
pub type atom_smu12_syspll3_1_clock_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct atom_get_smu_clock_info_output_parameters_v3_1 {
    pub atom_smu_outputclkfreq: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 {
    pub smu_clock_freq_hz: u32,
    pub syspllvcofreq_10khz: u32,
    pub sysspllrefclk_10khz: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1"][::core::mem::size_of::<
        atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1,
    >() - 4usize];
    ["Alignment of atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1"]
        [::core::mem::align_of::<atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1>()
            - 1usize];
    ["Offset of field: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1::smu_clock_freq_hz"] [:: core :: mem :: offset_of ! (atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 , smu_clock_freq_hz) - 0usize] ;
    ["Offset of field: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1::syspllvcofreq_10khz"] [:: core :: mem :: offset_of ! (atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 , syspllvcofreq_10khz) - 0usize] ;
    ["Offset of field: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1::sysspllrefclk_10khz"] [:: core :: mem :: offset_of ! (atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 , sysspllrefclk_10khz) - 0usize] ;
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_get_smu_clock_info_output_parameters_v3_1"]
        [::core::mem::size_of::<atom_get_smu_clock_info_output_parameters_v3_1>() - 4usize];
    ["Alignment of atom_get_smu_clock_info_output_parameters_v3_1"]
        [::core::mem::align_of::<atom_get_smu_clock_info_output_parameters_v3_1>() - 1usize];
    ["Offset of field: atom_get_smu_clock_info_output_parameters_v3_1::atom_smu_outputclkfreq"][::core::mem::offset_of!(
        atom_get_smu_clock_info_output_parameters_v3_1,
        atom_smu_outputclkfreq
    )
        - 0usize];
};
pub const atom_dynamic_memory_setting_command_COMPUTE_MEMORY_PLL_PARAM:
    atom_dynamic_memory_setting_command = 1;
pub const atom_dynamic_memory_setting_command_COMPUTE_ENGINE_PLL_PARAM:
    atom_dynamic_memory_setting_command = 2;
pub const atom_dynamic_memory_setting_command_ADJUST_MC_SETTING_PARAM:
    atom_dynamic_memory_setting_command = 3;
pub type atom_dynamic_memory_setting_command = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dynamic_mclk_settings_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dynamic_mclk_settings_parameters_v2_1"]
        [::core::mem::size_of::<dynamic_mclk_settings_parameters_v2_1>() - 8usize];
    ["Alignment of dynamic_mclk_settings_parameters_v2_1"]
        [::core::mem::align_of::<dynamic_mclk_settings_parameters_v2_1>() - 1usize];
    ["Offset of field: dynamic_mclk_settings_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(dynamic_mclk_settings_parameters_v2_1, reserved) - 4usize];
};
impl dynamic_mclk_settings_parameters_v2_1 {
    #[inline]
    pub fn mclk_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_mclk_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn command(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_command(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(mclk_10khz: u32, command: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let mclk_10khz: u32 = unsafe { ::core::mem::transmute(mclk_10khz) };
            mclk_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let command: u32 = unsafe { ::core::mem::transmute(command) };
            command as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dynamic_sclk_settings_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub mclk_10khz: u32,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dynamic_sclk_settings_parameters_v2_1"]
        [::core::mem::size_of::<dynamic_sclk_settings_parameters_v2_1>() - 12usize];
    ["Alignment of dynamic_sclk_settings_parameters_v2_1"]
        [::core::mem::align_of::<dynamic_sclk_settings_parameters_v2_1>() - 1usize];
    ["Offset of field: dynamic_sclk_settings_parameters_v2_1::mclk_10khz"]
        [::core::mem::offset_of!(dynamic_sclk_settings_parameters_v2_1, mclk_10khz) - 4usize];
    ["Offset of field: dynamic_sclk_settings_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(dynamic_sclk_settings_parameters_v2_1, reserved) - 8usize];
};
impl dynamic_sclk_settings_parameters_v2_1 {
    #[inline]
    pub fn sclk_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_sclk_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn command(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_command(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(sclk_10khz: u32, command: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let sclk_10khz: u32 = unsafe { ::core::mem::transmute(sclk_10khz) };
            sclk_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let command: u32 = unsafe { ::core::mem::transmute(command) };
            command as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union dynamic_memory_settings_parameters_v2_1 {
    pub mclk_setting: dynamic_mclk_settings_parameters_v2_1,
    pub sclk_setting: dynamic_sclk_settings_parameters_v2_1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dynamic_memory_settings_parameters_v2_1"]
        [::core::mem::size_of::<dynamic_memory_settings_parameters_v2_1>() - 12usize];
    ["Alignment of dynamic_memory_settings_parameters_v2_1"]
        [::core::mem::align_of::<dynamic_memory_settings_parameters_v2_1>() - 1usize];
    ["Offset of field: dynamic_memory_settings_parameters_v2_1::mclk_setting"]
        [::core::mem::offset_of!(dynamic_memory_settings_parameters_v2_1, mclk_setting) - 0usize];
    ["Offset of field: dynamic_memory_settings_parameters_v2_1::sclk_setting"]
        [::core::mem::offset_of!(dynamic_memory_settings_parameters_v2_1, sclk_setting) - 0usize];
};
pub const atom_umc6_0_ucode_function_call_enum_id_UMC60_UCODE_FUNC_ID_REINIT:
    atom_umc6_0_ucode_function_call_enum_id = 0;
pub const atom_umc6_0_ucode_function_call_enum_id_UMC60_UCODE_FUNC_ID_ENTER_SELFREFRESH:
    atom_umc6_0_ucode_function_call_enum_id = 1;
pub const atom_umc6_0_ucode_function_call_enum_id_UMC60_UCODE_FUNC_ID_EXIT_SELFREFRESH:
    atom_umc6_0_ucode_function_call_enum_id = 2;
pub type atom_umc6_0_ucode_function_call_enum_id = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct memory_training_parameters_v2_1 {
    pub ucode_func_id: u8,
    pub ucode_reserved: [u8; 3usize],
    pub reserved: [u32; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of memory_training_parameters_v2_1"]
        [::core::mem::size_of::<memory_training_parameters_v2_1>() - 24usize];
    ["Alignment of memory_training_parameters_v2_1"]
        [::core::mem::align_of::<memory_training_parameters_v2_1>() - 1usize];
    ["Offset of field: memory_training_parameters_v2_1::ucode_func_id"]
        [::core::mem::offset_of!(memory_training_parameters_v2_1, ucode_func_id) - 0usize];
    ["Offset of field: memory_training_parameters_v2_1::ucode_reserved"]
        [::core::mem::offset_of!(memory_training_parameters_v2_1, ucode_reserved) - 1usize];
    ["Offset of field: memory_training_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(memory_training_parameters_v2_1, reserved) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_pixel_clock_parameter_v1_7 {
    pub pixclk_100hz: u32,
    pub pll_id: u8,
    pub encoderobjid: u8,
    pub encoder_mode: u8,
    pub miscinfo: u8,
    pub crtc_id: u8,
    pub deep_color_ratio: u8,
    pub reserved1: [u8; 2usize],
    pub reserved2: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_pixel_clock_parameter_v1_7"]
        [::core::mem::size_of::<set_pixel_clock_parameter_v1_7>() - 16usize];
    ["Alignment of set_pixel_clock_parameter_v1_7"]
        [::core::mem::align_of::<set_pixel_clock_parameter_v1_7>() - 1usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::pixclk_100hz"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, pixclk_100hz) - 0usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::pll_id"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, pll_id) - 4usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::encoderobjid"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, encoderobjid) - 5usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::encoder_mode"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, encoder_mode) - 6usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::miscinfo"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, miscinfo) - 7usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::crtc_id"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, crtc_id) - 8usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::deep_color_ratio"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, deep_color_ratio) - 9usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::reserved1"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, reserved1) - 10usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::reserved2"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, reserved2) - 12usize];
};
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_FORCE_PROG_PPLL:
    atom_set_pixel_clock_v1_7_misc_info = 1;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_PROG_PHYPLL:
    atom_set_pixel_clock_v1_7_misc_info = 2;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_YUV420_MODE:
    atom_set_pixel_clock_v1_7_misc_info = 4;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_DVI_DUALLINK_EN:
    atom_set_pixel_clock_v1_7_misc_info = 8;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC:
    atom_set_pixel_clock_v1_7_misc_info = 48;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_XTALIN:
    atom_set_pixel_clock_v1_7_misc_info = 0;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_PCIE:
    atom_set_pixel_clock_v1_7_misc_info = 16;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_GENLK:
    atom_set_pixel_clock_v1_7_misc_info = 32;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_REFPAD:
    atom_set_pixel_clock_v1_7_misc_info = 48;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_ATOMIC_UPDATE:
    atom_set_pixel_clock_v1_7_misc_info = 64;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_FORCE_SS_DIS:
    atom_set_pixel_clock_v1_7_misc_info = 128;
pub type atom_set_pixel_clock_v1_7_misc_info = ::core::ffi::c_uint;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_DIS:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 0;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_5_4:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 1;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_3_2:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 2;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_2_1:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 3;
pub type atom_set_pixel_clock_v1_7_deepcolor_ratio = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_dce_clock_parameters_v2_1 {
    pub dceclk_10khz: u32,
    pub dceclktype: u8,
    pub dceclksrc: u8,
    pub dceclkflag: u8,
    pub crtc_id: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_dce_clock_parameters_v2_1"]
        [::core::mem::size_of::<set_dce_clock_parameters_v2_1>() - 8usize];
    ["Alignment of set_dce_clock_parameters_v2_1"]
        [::core::mem::align_of::<set_dce_clock_parameters_v2_1>() - 1usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::dceclk_10khz"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, dceclk_10khz) - 0usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::dceclktype"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, dceclktype) - 4usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::dceclksrc"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, dceclksrc) - 5usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::dceclkflag"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, dceclkflag) - 6usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::crtc_id"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, crtc_id) - 7usize];
};
pub const atom_set_dce_clock_clock_type_DCE_CLOCK_TYPE_DISPCLK: atom_set_dce_clock_clock_type = 0;
pub const atom_set_dce_clock_clock_type_DCE_CLOCK_TYPE_DPREFCLK: atom_set_dce_clock_clock_type = 1;
pub const atom_set_dce_clock_clock_type_DCE_CLOCK_TYPE_PIXELCLK: atom_set_dce_clock_clock_type = 2;
pub type atom_set_dce_clock_clock_type = ::core::ffi::c_uint;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_MASK:
    atom_set_dce_clock_dprefclk_flag = 3;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_GENERICA:
    atom_set_dce_clock_dprefclk_flag = 0;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_GENLK:
    atom_set_dce_clock_dprefclk_flag = 1;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_PCIE:
    atom_set_dce_clock_dprefclk_flag = 2;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_XTALIN:
    atom_set_dce_clock_dprefclk_flag = 3;
pub type atom_set_dce_clock_dprefclk_flag = ::core::ffi::c_uint;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_MASK:
    atom_set_dce_clock_pixclk_flag = 3;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_DIS:
    atom_set_dce_clock_pixclk_flag = 0;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_5_4:
    atom_set_dce_clock_pixclk_flag = 1;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_3_2:
    atom_set_dce_clock_pixclk_flag = 2;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_2_1:
    atom_set_dce_clock_pixclk_flag = 3;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PIXCLK_YUV420_MODE:
    atom_set_dce_clock_pixclk_flag = 4;
pub type atom_set_dce_clock_pixclk_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_dce_clock_ps_allocation_v2_1 {
    pub param: set_dce_clock_parameters_v2_1,
    pub ulReserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_dce_clock_ps_allocation_v2_1"]
        [::core::mem::size_of::<set_dce_clock_ps_allocation_v2_1>() - 16usize];
    ["Alignment of set_dce_clock_ps_allocation_v2_1"]
        [::core::mem::align_of::<set_dce_clock_ps_allocation_v2_1>() - 1usize];
    ["Offset of field: set_dce_clock_ps_allocation_v2_1::param"]
        [::core::mem::offset_of!(set_dce_clock_ps_allocation_v2_1, param) - 0usize];
    ["Offset of field: set_dce_clock_ps_allocation_v2_1::ulReserved"]
        [::core::mem::offset_of!(set_dce_clock_ps_allocation_v2_1, ulReserved) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct blank_crtc_parameters {
    pub crtc_id: u8,
    pub blanking: u8,
    pub reserved: u16,
    pub reserved1: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of blank_crtc_parameters"][::core::mem::size_of::<blank_crtc_parameters>() - 8usize];
    ["Alignment of blank_crtc_parameters"]
        [::core::mem::align_of::<blank_crtc_parameters>() - 1usize];
    ["Offset of field: blank_crtc_parameters::crtc_id"]
        [::core::mem::offset_of!(blank_crtc_parameters, crtc_id) - 0usize];
    ["Offset of field: blank_crtc_parameters::blanking"]
        [::core::mem::offset_of!(blank_crtc_parameters, blanking) - 1usize];
    ["Offset of field: blank_crtc_parameters::reserved"]
        [::core::mem::offset_of!(blank_crtc_parameters, reserved) - 2usize];
    ["Offset of field: blank_crtc_parameters::reserved1"]
        [::core::mem::offset_of!(blank_crtc_parameters, reserved1) - 4usize];
};
pub const atom_blank_crtc_command_ATOM_BLANKING: atom_blank_crtc_command = 1;
pub const atom_blank_crtc_command_ATOM_BLANKING_OFF: atom_blank_crtc_command = 0;
pub type atom_blank_crtc_command = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct enable_crtc_parameters {
    pub crtc_id: u8,
    pub enable: u8,
    pub padding: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of enable_crtc_parameters"][::core::mem::size_of::<enable_crtc_parameters>() - 4usize];
    ["Alignment of enable_crtc_parameters"]
        [::core::mem::align_of::<enable_crtc_parameters>() - 1usize];
    ["Offset of field: enable_crtc_parameters::crtc_id"]
        [::core::mem::offset_of!(enable_crtc_parameters, crtc_id) - 0usize];
    ["Offset of field: enable_crtc_parameters::enable"]
        [::core::mem::offset_of!(enable_crtc_parameters, enable) - 1usize];
    ["Offset of field: enable_crtc_parameters::padding"]
        [::core::mem::offset_of!(enable_crtc_parameters, padding) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct enable_disp_power_gating_parameters_v2_1 {
    pub disp_pipe_id: u8,
    pub enable: u8,
    pub padding: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of enable_disp_power_gating_parameters_v2_1"]
        [::core::mem::size_of::<enable_disp_power_gating_parameters_v2_1>() - 4usize];
    ["Alignment of enable_disp_power_gating_parameters_v2_1"]
        [::core::mem::align_of::<enable_disp_power_gating_parameters_v2_1>() - 1usize];
    ["Offset of field: enable_disp_power_gating_parameters_v2_1::disp_pipe_id"]
        [::core::mem::offset_of!(enable_disp_power_gating_parameters_v2_1, disp_pipe_id) - 0usize];
    ["Offset of field: enable_disp_power_gating_parameters_v2_1::enable"]
        [::core::mem::offset_of!(enable_disp_power_gating_parameters_v2_1, enable) - 1usize];
    ["Offset of field: enable_disp_power_gating_parameters_v2_1::padding"]
        [::core::mem::offset_of!(enable_disp_power_gating_parameters_v2_1, padding) - 2usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct enable_disp_power_gating_ps_allocation {
    pub param: enable_disp_power_gating_parameters_v2_1,
    pub ulReserved: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of enable_disp_power_gating_ps_allocation"]
        [::core::mem::size_of::<enable_disp_power_gating_ps_allocation>() - 20usize];
    ["Alignment of enable_disp_power_gating_ps_allocation"]
        [::core::mem::align_of::<enable_disp_power_gating_ps_allocation>() - 1usize];
    ["Offset of field: enable_disp_power_gating_ps_allocation::param"]
        [::core::mem::offset_of!(enable_disp_power_gating_ps_allocation, param) - 0usize];
    ["Offset of field: enable_disp_power_gating_ps_allocation::ulReserved"]
        [::core::mem::offset_of!(enable_disp_power_gating_ps_allocation, ulReserved) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_crtc_using_dtd_timing_parameters {
    pub h_size: u16,
    pub h_blanking_time: u16,
    pub v_size: u16,
    pub v_blanking_time: u16,
    pub h_syncoffset: u16,
    pub h_syncwidth: u16,
    pub v_syncoffset: u16,
    pub v_syncwidth: u16,
    pub modemiscinfo: u16,
    pub h_border: u8,
    pub v_border: u8,
    pub crtc_id: u8,
    pub encoder_mode: u8,
    pub padding: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_crtc_using_dtd_timing_parameters"]
        [::core::mem::size_of::<set_crtc_using_dtd_timing_parameters>() - 24usize];
    ["Alignment of set_crtc_using_dtd_timing_parameters"]
        [::core::mem::align_of::<set_crtc_using_dtd_timing_parameters>() - 1usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_size"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_size) - 0usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_blanking_time"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_blanking_time) - 2usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_size"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_size) - 4usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_blanking_time"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_blanking_time) - 6usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_syncoffset"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_syncoffset) - 8usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_syncwidth"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_syncwidth) - 10usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_syncoffset"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_syncoffset) - 12usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_syncwidth"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_syncwidth) - 14usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::modemiscinfo"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, modemiscinfo) - 16usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_border"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_border) - 18usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_border"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_border) - 19usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::crtc_id"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, crtc_id) - 20usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::encoder_mode"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, encoder_mode) - 21usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::padding"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, padding) - 22usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct process_i2c_channel_transaction_parameters {
    pub i2cspeed_khz: u8,
    pub regind_status: process_i2c_channel_transaction_parameters__bindgen_ty_1,
    pub i2c_data_out: u16,
    pub flag: u8,
    pub trans_bytes: u8,
    pub slave_addr: u8,
    pub i2c_id: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union process_i2c_channel_transaction_parameters__bindgen_ty_1 {
    pub regindex: u8,
    pub status: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of process_i2c_channel_transaction_parameters__bindgen_ty_1"][::core::mem::size_of::<
        process_i2c_channel_transaction_parameters__bindgen_ty_1,
    >() - 1usize];
    ["Alignment of process_i2c_channel_transaction_parameters__bindgen_ty_1"][::core::mem::align_of::<
        process_i2c_channel_transaction_parameters__bindgen_ty_1,
    >() - 1usize];
    ["Offset of field: process_i2c_channel_transaction_parameters__bindgen_ty_1::regindex"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters__bindgen_ty_1,
        regindex
    )
        - 0usize];
    ["Offset of field: process_i2c_channel_transaction_parameters__bindgen_ty_1::status"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters__bindgen_ty_1,
        status
    )
        - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of process_i2c_channel_transaction_parameters"]
        [::core::mem::size_of::<process_i2c_channel_transaction_parameters>() - 8usize];
    ["Alignment of process_i2c_channel_transaction_parameters"]
        [::core::mem::align_of::<process_i2c_channel_transaction_parameters>() - 1usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::i2cspeed_khz"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters,
        i2cspeed_khz
    ) - 0usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::regind_status"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters,
        regind_status
    ) - 1usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::i2c_data_out"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters,
        i2c_data_out
    ) - 2usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::flag"]
        [::core::mem::offset_of!(process_i2c_channel_transaction_parameters, flag) - 4usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::trans_bytes"]
        [::core::mem::offset_of!(process_i2c_channel_transaction_parameters, trans_bytes) - 5usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::slave_addr"]
        [::core::mem::offset_of!(process_i2c_channel_transaction_parameters, slave_addr) - 6usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::i2c_id"]
        [::core::mem::offset_of!(process_i2c_channel_transaction_parameters, i2c_id) - 7usize];
};
pub const atom_process_i2c_flag_HW_I2C_WRITE: atom_process_i2c_flag = 1;
pub const atom_process_i2c_flag_HW_I2C_READ: atom_process_i2c_flag = 0;
pub const atom_process_i2c_flag_I2C_2BYTE_ADDR: atom_process_i2c_flag = 2;
pub const atom_process_i2c_flag_HW_I2C_SMBUS_BYTE_WR: atom_process_i2c_flag = 4;
pub type atom_process_i2c_flag = ::core::ffi::c_uint;
pub const atom_process_i2c_status_HW_ASSISTED_I2C_STATUS_FAILURE: atom_process_i2c_status = 2;
pub const atom_process_i2c_status_HW_ASSISTED_I2C_STATUS_SUCCESS: atom_process_i2c_status = 1;
pub type atom_process_i2c_status = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct process_aux_channel_transaction_parameters_v1_2 {
    pub aux_request: u16,
    pub dataout: u16,
    pub channelid: u8,
    pub aux_status_delay: process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1,
    pub dataout_len: u8,
    pub hpd_id: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1 {
    pub reply_status: u8,
    pub aux_delay: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1"][::core::mem::size_of::<
        process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1,
    >() - 1usize];
    ["Alignment of process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1"]
        [::core::mem::align_of::<process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1>()
            - 1usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1::reply_status"] [:: core :: mem :: offset_of ! (process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1 , reply_status) - 0usize] ;
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1::aux_delay"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1,
        aux_delay
    )
        - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of process_aux_channel_transaction_parameters_v1_2"]
        [::core::mem::size_of::<process_aux_channel_transaction_parameters_v1_2>() - 8usize];
    ["Alignment of process_aux_channel_transaction_parameters_v1_2"]
        [::core::mem::align_of::<process_aux_channel_transaction_parameters_v1_2>() - 1usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::aux_request"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        aux_request
    ) - 0usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::dataout"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        dataout
    ) - 2usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::channelid"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        channelid
    ) - 4usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::aux_status_delay"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        aux_status_delay
    )
        - 5usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::dataout_len"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        dataout_len
    ) - 6usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::hpd_id"]
        [::core::mem::offset_of!(process_aux_channel_transaction_parameters_v1_2, hpd_id) - 7usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct select_crtc_source_parameters_v2_3 {
    pub crtc_id: u8,
    pub encoder_id: u8,
    pub encode_mode: u8,
    pub dst_bpc: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of select_crtc_source_parameters_v2_3"]
        [::core::mem::size_of::<select_crtc_source_parameters_v2_3>() - 4usize];
    ["Alignment of select_crtc_source_parameters_v2_3"]
        [::core::mem::align_of::<select_crtc_source_parameters_v2_3>() - 1usize];
    ["Offset of field: select_crtc_source_parameters_v2_3::crtc_id"]
        [::core::mem::offset_of!(select_crtc_source_parameters_v2_3, crtc_id) - 0usize];
    ["Offset of field: select_crtc_source_parameters_v2_3::encoder_id"]
        [::core::mem::offset_of!(select_crtc_source_parameters_v2_3, encoder_id) - 1usize];
    ["Offset of field: select_crtc_source_parameters_v2_3::encode_mode"]
        [::core::mem::offset_of!(select_crtc_source_parameters_v2_3, encode_mode) - 2usize];
    ["Offset of field: select_crtc_source_parameters_v2_3::dst_bpc"]
        [::core::mem::offset_of!(select_crtc_source_parameters_v2_3, dst_bpc) - 3usize];
};
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DISABLE_DIG:
    atom_dig_encoder_control_action = 0;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_ENABLE_DIG:
    atom_dig_encoder_control_action = 1;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_START:
    atom_dig_encoder_control_action = 8;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN1:
    atom_dig_encoder_control_action = 9;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN2:
    atom_dig_encoder_control_action = 10;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN3:
    atom_dig_encoder_control_action = 19;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_COMPLETE:
    atom_dig_encoder_control_action = 11;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_VIDEO_OFF:
    atom_dig_encoder_control_action = 12;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_VIDEO_ON:
    atom_dig_encoder_control_action = 13;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_SETUP_PANEL_MODE:
    atom_dig_encoder_control_action = 16;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN4:
    atom_dig_encoder_control_action = 20;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_STREAM_SETUP:
    atom_dig_encoder_control_action = 15;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_LINK_SETUP:
    atom_dig_encoder_control_action = 17;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_ENCODER_BLANK:
    atom_dig_encoder_control_action = 18;
pub type atom_dig_encoder_control_action = ::core::ffi::c_uint;
pub const atom_dig_encoder_control_panelmode_DP_PANEL_MODE_DISABLE:
    atom_dig_encoder_control_panelmode = 0;
pub const atom_dig_encoder_control_panelmode_DP_PANEL_MODE_ENABLE_eDP_MODE:
    atom_dig_encoder_control_panelmode = 1;
pub const atom_dig_encoder_control_panelmode_DP_PANEL_MODE_ENABLE_LVLINK_MODE:
    atom_dig_encoder_control_panelmode = 17;
pub type atom_dig_encoder_control_panelmode = ::core::ffi::c_uint;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG0_ENCODER:
    atom_dig_encoder_control_v5_digid = 0;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG1_ENCODER:
    atom_dig_encoder_control_v5_digid = 1;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG2_ENCODER:
    atom_dig_encoder_control_v5_digid = 2;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG3_ENCODER:
    atom_dig_encoder_control_v5_digid = 3;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG4_ENCODER:
    atom_dig_encoder_control_v5_digid = 4;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG5_ENCODER:
    atom_dig_encoder_control_v5_digid = 5;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG6_ENCODER:
    atom_dig_encoder_control_v5_digid = 6;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG7_ENCODER:
    atom_dig_encoder_control_v5_digid = 7;
pub type atom_dig_encoder_control_v5_digid = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dig_encoder_stream_setup_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub digmode: u8,
    pub lanenum: u8,
    pub pclk_10khz: u32,
    pub bitpercolor: u8,
    pub dplinkrate_270mhz: u8,
    pub reserved: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_encoder_stream_setup_parameters_v1_5"]
        [::core::mem::size_of::<dig_encoder_stream_setup_parameters_v1_5>() - 12usize];
    ["Alignment of dig_encoder_stream_setup_parameters_v1_5"]
        [::core::mem::align_of::<dig_encoder_stream_setup_parameters_v1_5>() - 1usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::digid"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, digid) - 0usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::action"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, action) - 1usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::digmode"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, digmode) - 2usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::lanenum"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, lanenum) - 3usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::pclk_10khz"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, pclk_10khz) - 4usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::bitpercolor"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, bitpercolor) - 8usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::dplinkrate_270mhz"][::core::mem::offset_of!(
        dig_encoder_stream_setup_parameters_v1_5,
        dplinkrate_270mhz
    ) - 9usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::reserved"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, reserved) - 10usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dig_encoder_link_setup_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub digmode: u8,
    pub lanenum: u8,
    pub symclk_10khz: u8,
    pub hpd_sel: u8,
    pub digfe_sel: u8,
    pub reserved: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_encoder_link_setup_parameters_v1_5"]
        [::core::mem::size_of::<dig_encoder_link_setup_parameters_v1_5>() - 9usize];
    ["Alignment of dig_encoder_link_setup_parameters_v1_5"]
        [::core::mem::align_of::<dig_encoder_link_setup_parameters_v1_5>() - 1usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::digid"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, digid) - 0usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::action"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, action) - 1usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::digmode"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, digmode) - 2usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::lanenum"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, lanenum) - 3usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::symclk_10khz"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, symclk_10khz) - 4usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::hpd_sel"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, hpd_sel) - 5usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::digfe_sel"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, digfe_sel) - 6usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::reserved"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, reserved) - 7usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dp_panel_mode_set_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub panelmode: u8,
    pub reserved1: u8,
    pub reserved2: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dp_panel_mode_set_parameters_v1_5"]
        [::core::mem::size_of::<dp_panel_mode_set_parameters_v1_5>() - 12usize];
    ["Alignment of dp_panel_mode_set_parameters_v1_5"]
        [::core::mem::align_of::<dp_panel_mode_set_parameters_v1_5>() - 1usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::digid"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, digid) - 0usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::action"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, action) - 1usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::panelmode"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, panelmode) - 2usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::reserved1"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, reserved1) - 3usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::reserved2"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, reserved2) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dig_encoder_generic_cmd_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub reserved1: [u8; 2usize],
    pub reserved2: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_encoder_generic_cmd_parameters_v1_5"]
        [::core::mem::size_of::<dig_encoder_generic_cmd_parameters_v1_5>() - 12usize];
    ["Alignment of dig_encoder_generic_cmd_parameters_v1_5"]
        [::core::mem::align_of::<dig_encoder_generic_cmd_parameters_v1_5>() - 1usize];
    ["Offset of field: dig_encoder_generic_cmd_parameters_v1_5::digid"]
        [::core::mem::offset_of!(dig_encoder_generic_cmd_parameters_v1_5, digid) - 0usize];
    ["Offset of field: dig_encoder_generic_cmd_parameters_v1_5::action"]
        [::core::mem::offset_of!(dig_encoder_generic_cmd_parameters_v1_5, action) - 1usize];
    ["Offset of field: dig_encoder_generic_cmd_parameters_v1_5::reserved1"]
        [::core::mem::offset_of!(dig_encoder_generic_cmd_parameters_v1_5, reserved1) - 2usize];
    ["Offset of field: dig_encoder_generic_cmd_parameters_v1_5::reserved2"]
        [::core::mem::offset_of!(dig_encoder_generic_cmd_parameters_v1_5, reserved2) - 4usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union dig_encoder_control_parameters_v1_5 {
    pub cmd_param: dig_encoder_generic_cmd_parameters_v1_5,
    pub stream_param: dig_encoder_stream_setup_parameters_v1_5,
    pub link_param: dig_encoder_link_setup_parameters_v1_5,
    pub dppanel_param: dp_panel_mode_set_parameters_v1_5,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_encoder_control_parameters_v1_5"]
        [::core::mem::size_of::<dig_encoder_control_parameters_v1_5>() - 12usize];
    ["Alignment of dig_encoder_control_parameters_v1_5"]
        [::core::mem::align_of::<dig_encoder_control_parameters_v1_5>() - 1usize];
    ["Offset of field: dig_encoder_control_parameters_v1_5::cmd_param"]
        [::core::mem::offset_of!(dig_encoder_control_parameters_v1_5, cmd_param) - 0usize];
    ["Offset of field: dig_encoder_control_parameters_v1_5::stream_param"]
        [::core::mem::offset_of!(dig_encoder_control_parameters_v1_5, stream_param) - 0usize];
    ["Offset of field: dig_encoder_control_parameters_v1_5::link_param"]
        [::core::mem::offset_of!(dig_encoder_control_parameters_v1_5, link_param) - 0usize];
    ["Offset of field: dig_encoder_control_parameters_v1_5::dppanel_param"]
        [::core::mem::offset_of!(dig_encoder_control_parameters_v1_5, dppanel_param) - 0usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct dig_transmitter_control_parameters_v1_6 {
    pub phyid: u8,
    pub action: u8,
    pub mode_laneset: dig_transmitter_control_parameters_v1_6__bindgen_ty_1,
    pub lanenum: u8,
    pub symclk_10khz: u32,
    pub hpdsel: u8,
    pub digfe_sel: u8,
    pub connobj_id: u8,
    pub reserved: u8,
    pub reserved1: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union dig_transmitter_control_parameters_v1_6__bindgen_ty_1 {
    pub digmode: u8,
    pub dplaneset: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_transmitter_control_parameters_v1_6__bindgen_ty_1"]
        [::core::mem::size_of::<dig_transmitter_control_parameters_v1_6__bindgen_ty_1>() - 1usize];
    ["Alignment of dig_transmitter_control_parameters_v1_6__bindgen_ty_1"]
        [::core::mem::align_of::<dig_transmitter_control_parameters_v1_6__bindgen_ty_1>() - 1usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6__bindgen_ty_1::digmode"][::core::mem::offset_of!(
        dig_transmitter_control_parameters_v1_6__bindgen_ty_1,
        digmode
    ) - 0usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6__bindgen_ty_1::dplaneset"][::core::mem::offset_of!(
        dig_transmitter_control_parameters_v1_6__bindgen_ty_1,
        dplaneset
    )
        - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_transmitter_control_parameters_v1_6"]
        [::core::mem::size_of::<dig_transmitter_control_parameters_v1_6>() - 16usize];
    ["Alignment of dig_transmitter_control_parameters_v1_6"]
        [::core::mem::align_of::<dig_transmitter_control_parameters_v1_6>() - 1usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::phyid"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, phyid) - 0usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::action"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, action) - 1usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::mode_laneset"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, mode_laneset) - 2usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::lanenum"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, lanenum) - 3usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::symclk_10khz"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, symclk_10khz) - 4usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::hpdsel"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, hpdsel) - 8usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::digfe_sel"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, digfe_sel) - 9usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::connobj_id"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, connobj_id) - 10usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::reserved"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, reserved) - 11usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::reserved1"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, reserved1) - 12usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct dig_transmitter_control_ps_allocation_v1_6 {
    pub param: dig_transmitter_control_parameters_v1_6,
    pub reserved: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_transmitter_control_ps_allocation_v1_6"]
        [::core::mem::size_of::<dig_transmitter_control_ps_allocation_v1_6>() - 32usize];
    ["Alignment of dig_transmitter_control_ps_allocation_v1_6"]
        [::core::mem::align_of::<dig_transmitter_control_ps_allocation_v1_6>() - 1usize];
    ["Offset of field: dig_transmitter_control_ps_allocation_v1_6::param"]
        [::core::mem::offset_of!(dig_transmitter_control_ps_allocation_v1_6, param) - 0usize];
    ["Offset of field: dig_transmitter_control_ps_allocation_v1_6::reserved"]
        [::core::mem::offset_of!(dig_transmitter_control_ps_allocation_v1_6, reserved) - 16usize];
};
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_DISABLE:
    atom_dig_transmitter_control_action = 0;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_ENABLE:
    atom_dig_transmitter_control_action = 1;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_BLOFF:
    atom_dig_transmitter_control_action = 2;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_BLON:
    atom_dig_transmitter_control_action = 3;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_BL_BRIGHTNESS_CONTROL:
    atom_dig_transmitter_control_action = 4;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_SELFTEST_START:
    atom_dig_transmitter_control_action = 5;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_SELFTEST_STOP:
    atom_dig_transmitter_control_action = 6;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_INIT:
    atom_dig_transmitter_control_action = 7;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_DISABLE_OUTPUT:
    atom_dig_transmitter_control_action = 8;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_ENABLE_OUTPUT:
    atom_dig_transmitter_control_action = 9;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_SETUP:
    atom_dig_transmitter_control_action = 10;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_SETUP_VSEMPH:
    atom_dig_transmitter_control_action = 11;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_POWER_ON:
    atom_dig_transmitter_control_action = 12;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_POWER_OFF:
    atom_dig_transmitter_control_action = 13;
pub type atom_dig_transmitter_control_action = ::core::ffi::c_uint;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGA_SEL:
    atom_dig_transmitter_control_digfe_sel = 1;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGB_SEL:
    atom_dig_transmitter_control_digfe_sel = 2;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGC_SEL:
    atom_dig_transmitter_control_digfe_sel = 4;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGD_SEL:
    atom_dig_transmitter_control_digfe_sel = 8;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGE_SEL:
    atom_dig_transmitter_control_digfe_sel = 16;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGF_SEL:
    atom_dig_transmitter_control_digfe_sel = 32;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGG_SEL:
    atom_dig_transmitter_control_digfe_sel = 64;
pub type atom_dig_transmitter_control_digfe_sel = ::core::ffi::c_uint;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_NO_HPD_SEL:
    atom_dig_transmitter_control_hpd_sel = 0;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD1_SEL:
    atom_dig_transmitter_control_hpd_sel = 1;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD2_SEL:
    atom_dig_transmitter_control_hpd_sel = 2;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD3_SEL:
    atom_dig_transmitter_control_hpd_sel = 3;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD4_SEL:
    atom_dig_transmitter_control_hpd_sel = 4;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD5_SEL:
    atom_dig_transmitter_control_hpd_sel = 5;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD6_SEL:
    atom_dig_transmitter_control_hpd_sel = 6;
pub type atom_dig_transmitter_control_hpd_sel = ::core::ffi::c_uint;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 0;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_0_6V:
    atom_dig_transmitter_control_dplaneset = 1;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_0_8V:
    atom_dig_transmitter_control_dplaneset = 2;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_1_2V:
    atom_dig_transmitter_control_dplaneset = 3;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__3_5DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 8;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__3_5DB_0_6V:
    atom_dig_transmitter_control_dplaneset = 9;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__3_5DB_0_8V:
    atom_dig_transmitter_control_dplaneset = 10;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__6DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 16;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__6DB_0_6V:
    atom_dig_transmitter_control_dplaneset = 17;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__9_5DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 24;
pub type atom_dig_transmitter_control_dplaneset = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct external_encoder_control_parameters_v2_4 {
    pub pixelclock_10khz: u16,
    pub config: u8,
    pub action: u8,
    pub encodermode: u8,
    pub lanenum: u8,
    pub bitpercolor: u8,
    pub hpd_id: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of external_encoder_control_parameters_v2_4"]
        [::core::mem::size_of::<external_encoder_control_parameters_v2_4>() - 8usize];
    ["Alignment of external_encoder_control_parameters_v2_4"]
        [::core::mem::align_of::<external_encoder_control_parameters_v2_4>() - 1usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::pixelclock_10khz"][::core::mem::offset_of!(
        external_encoder_control_parameters_v2_4,
        pixelclock_10khz
    ) - 0usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::config"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, config) - 2usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::action"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, action) - 3usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::encodermode"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, encodermode) - 4usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::lanenum"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, lanenum) - 5usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::bitpercolor"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, bitpercolor) - 6usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::hpd_id"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, hpd_id) - 7usize];
};
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_DISABLE_OUTPUT:
    external_encoder_control_action_def = 0;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENABLE_OUTPUT:
    external_encoder_control_action_def = 1;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_INIT:
    external_encoder_control_action_def = 7;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_SETUP:
    external_encoder_control_action_def = 15;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_BLANKING_OFF:
    external_encoder_control_action_def = 16;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_BLANKING:
    external_encoder_control_action_def = 17;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_DACLOAD_DETECTION:
    external_encoder_control_action_def = 18;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_DDC_SETUP:
    external_encoder_control_action_def = 20;
pub type external_encoder_control_action_def = ::core::ffi::c_uint;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_MASK:
    external_encoder_control_v2_4_config_def = 3;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_1_62GHZ:
    external_encoder_control_v2_4_config_def = 0;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_2_70GHZ:
    external_encoder_control_v2_4_config_def = 1;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_5_40GHZ:
    external_encoder_control_v2_4_config_def = 2;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_3_24GHZ:
    external_encoder_control_v2_4_config_def = 3;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER_SEL_MAKS:
    external_encoder_control_v2_4_config_def = 112;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER1:
    external_encoder_control_v2_4_config_def = 0;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER2:
    external_encoder_control_v2_4_config_def = 16;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER3:
    external_encoder_control_v2_4_config_def = 32;
pub type external_encoder_control_v2_4_config_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct external_encoder_control_ps_allocation_v2_4 {
    pub sExtEncoder: external_encoder_control_parameters_v2_4,
    pub reserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of external_encoder_control_ps_allocation_v2_4"]
        [::core::mem::size_of::<external_encoder_control_ps_allocation_v2_4>() - 16usize];
    ["Alignment of external_encoder_control_ps_allocation_v2_4"]
        [::core::mem::align_of::<external_encoder_control_ps_allocation_v2_4>() - 1usize];
    ["Offset of field: external_encoder_control_ps_allocation_v2_4::sExtEncoder"][::core::mem::offset_of!(
        external_encoder_control_ps_allocation_v2_4,
        sExtEncoder
    ) - 0usize];
    ["Offset of field: external_encoder_control_ps_allocation_v2_4::reserved"]
        [::core::mem::offset_of!(external_encoder_control_ps_allocation_v2_4, reserved) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct amd_acpi_description_header {
    pub signature: u32,
    pub tableLength: u32,
    pub revision: u8,
    pub checksum: u8,
    pub oemId: [u8; 6usize],
    pub oemTableId: [u8; 8usize],
    pub oemRevision: u32,
    pub creatorId: u32,
    pub creatorRevision: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amd_acpi_description_header"]
        [::core::mem::size_of::<amd_acpi_description_header>() - 36usize];
    ["Alignment of amd_acpi_description_header"]
        [::core::mem::align_of::<amd_acpi_description_header>() - 1usize];
    ["Offset of field: amd_acpi_description_header::signature"]
        [::core::mem::offset_of!(amd_acpi_description_header, signature) - 0usize];
    ["Offset of field: amd_acpi_description_header::tableLength"]
        [::core::mem::offset_of!(amd_acpi_description_header, tableLength) - 4usize];
    ["Offset of field: amd_acpi_description_header::revision"]
        [::core::mem::offset_of!(amd_acpi_description_header, revision) - 8usize];
    ["Offset of field: amd_acpi_description_header::checksum"]
        [::core::mem::offset_of!(amd_acpi_description_header, checksum) - 9usize];
    ["Offset of field: amd_acpi_description_header::oemId"]
        [::core::mem::offset_of!(amd_acpi_description_header, oemId) - 10usize];
    ["Offset of field: amd_acpi_description_header::oemTableId"]
        [::core::mem::offset_of!(amd_acpi_description_header, oemTableId) - 16usize];
    ["Offset of field: amd_acpi_description_header::oemRevision"]
        [::core::mem::offset_of!(amd_acpi_description_header, oemRevision) - 24usize];
    ["Offset of field: amd_acpi_description_header::creatorId"]
        [::core::mem::offset_of!(amd_acpi_description_header, creatorId) - 28usize];
    ["Offset of field: amd_acpi_description_header::creatorRevision"]
        [::core::mem::offset_of!(amd_acpi_description_header, creatorRevision) - 32usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct uefi_acpi_vfct {
    pub sheader: amd_acpi_description_header,
    pub tableUUID: [u8; 16usize],
    pub vbiosimageoffset: u32,
    pub lib1Imageoffset: u32,
    pub reserved: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of uefi_acpi_vfct"][::core::mem::size_of::<uefi_acpi_vfct>() - 76usize];
    ["Alignment of uefi_acpi_vfct"][::core::mem::align_of::<uefi_acpi_vfct>() - 1usize];
    ["Offset of field: uefi_acpi_vfct::sheader"]
        [::core::mem::offset_of!(uefi_acpi_vfct, sheader) - 0usize];
    ["Offset of field: uefi_acpi_vfct::tableUUID"]
        [::core::mem::offset_of!(uefi_acpi_vfct, tableUUID) - 36usize];
    ["Offset of field: uefi_acpi_vfct::vbiosimageoffset"]
        [::core::mem::offset_of!(uefi_acpi_vfct, vbiosimageoffset) - 52usize];
    ["Offset of field: uefi_acpi_vfct::lib1Imageoffset"]
        [::core::mem::offset_of!(uefi_acpi_vfct, lib1Imageoffset) - 56usize];
    ["Offset of field: uefi_acpi_vfct::reserved"]
        [::core::mem::offset_of!(uefi_acpi_vfct, reserved) - 60usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct vfct_image_header {
    pub pcibus: u32,
    pub pcidevice: u32,
    pub pcifunction: u32,
    pub vendorid: u16,
    pub deviceid: u16,
    pub ssvid: u16,
    pub ssid: u16,
    pub revision: u32,
    pub imagelength: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vfct_image_header"][::core::mem::size_of::<vfct_image_header>() - 28usize];
    ["Alignment of vfct_image_header"][::core::mem::align_of::<vfct_image_header>() - 1usize];
    ["Offset of field: vfct_image_header::pcibus"]
        [::core::mem::offset_of!(vfct_image_header, pcibus) - 0usize];
    ["Offset of field: vfct_image_header::pcidevice"]
        [::core::mem::offset_of!(vfct_image_header, pcidevice) - 4usize];
    ["Offset of field: vfct_image_header::pcifunction"]
        [::core::mem::offset_of!(vfct_image_header, pcifunction) - 8usize];
    ["Offset of field: vfct_image_header::vendorid"]
        [::core::mem::offset_of!(vfct_image_header, vendorid) - 12usize];
    ["Offset of field: vfct_image_header::deviceid"]
        [::core::mem::offset_of!(vfct_image_header, deviceid) - 14usize];
    ["Offset of field: vfct_image_header::ssvid"]
        [::core::mem::offset_of!(vfct_image_header, ssvid) - 16usize];
    ["Offset of field: vfct_image_header::ssid"]
        [::core::mem::offset_of!(vfct_image_header, ssid) - 18usize];
    ["Offset of field: vfct_image_header::revision"]
        [::core::mem::offset_of!(vfct_image_header, revision) - 20usize];
    ["Offset of field: vfct_image_header::imagelength"]
        [::core::mem::offset_of!(vfct_image_header, imagelength) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gop_vbios_content {
    pub vbiosheader: vfct_image_header,
    pub vbioscontent: [u8; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of gop_vbios_content"][::core::mem::size_of::<gop_vbios_content>() - 29usize];
    ["Alignment of gop_vbios_content"][::core::mem::align_of::<gop_vbios_content>() - 1usize];
    ["Offset of field: gop_vbios_content::vbiosheader"]
        [::core::mem::offset_of!(gop_vbios_content, vbiosheader) - 0usize];
    ["Offset of field: gop_vbios_content::vbioscontent"]
        [::core::mem::offset_of!(gop_vbios_content, vbioscontent) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gop_lib1_content {
    pub lib1header: vfct_image_header,
    pub lib1content: [u8; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of gop_lib1_content"][::core::mem::size_of::<gop_lib1_content>() - 29usize];
    ["Alignment of gop_lib1_content"][::core::mem::align_of::<gop_lib1_content>() - 1usize];
    ["Offset of field: gop_lib1_content::lib1header"]
        [::core::mem::offset_of!(gop_lib1_content, lib1header) - 0usize];
    ["Offset of field: gop_lib1_content::lib1content"]
        [::core::mem::offset_of!(gop_lib1_content, lib1content) - 28usize];
};
pub const scratch_register_def_ATOM_DEVICE_CONNECT_INFO_DEF: scratch_register_def = 0;
pub const scratch_register_def_ATOM_BL_BRI_LEVEL_INFO_DEF: scratch_register_def = 2;
pub const scratch_register_def_ATOM_ACTIVE_INFO_DEF: scratch_register_def = 3;
pub const scratch_register_def_ATOM_LCD_INFO_DEF: scratch_register_def = 4;
pub const scratch_register_def_ATOM_DEVICE_REQ_INFO_DEF: scratch_register_def = 5;
pub const scratch_register_def_ATOM_ACC_CHANGE_INFO_DEF: scratch_register_def = 6;
pub const scratch_register_def_ATOM_PRE_OS_MODE_INFO_DEF: scratch_register_def = 7;
pub const scratch_register_def_ATOM_PRE_OS_ASSERTION_DEF: scratch_register_def = 8;
pub const scratch_register_def_ATOM_INTERNAL_TIMER_INFO_DEF: scratch_register_def = 10;
pub type scratch_register_def = ::core::ffi::c_uint;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_LCD1_CONNECT:
    scratch_device_connect_info_bit_def = 2;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP1_CONNECT:
    scratch_device_connect_info_bit_def = 8;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP2_CONNECT:
    scratch_device_connect_info_bit_def = 128;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP3_CONNECT:
    scratch_device_connect_info_bit_def = 512;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP4_CONNECT:
    scratch_device_connect_info_bit_def = 1024;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP5_CONNECT:
    scratch_device_connect_info_bit_def = 2048;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP6_CONNECT:
    scratch_device_connect_info_bit_def = 64;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFPx_CONNECT:
    scratch_device_connect_info_bit_def = 3784;
pub const scratch_device_connect_info_bit_def_ATOM_CONNECT_INFO_DEVICE_MASK:
    scratch_device_connect_info_bit_def = 4095;
pub type scratch_device_connect_info_bit_def = ::core::ffi::c_uint;
pub const scratch_bl_bri_level_info_bit_def_ATOM_CURRENT_BL_LEVEL_SHIFT:
    scratch_bl_bri_level_info_bit_def = 8;
pub const scratch_bl_bri_level_info_bit_def_ATOM_CURRENT_BL_LEVEL_MASK:
    scratch_bl_bri_level_info_bit_def = 65280;
pub const scratch_bl_bri_level_info_bit_def_ATOM_DEVICE_DPMS_STATE:
    scratch_bl_bri_level_info_bit_def = 65536;
pub type scratch_bl_bri_level_info_bit_def = ::core::ffi::c_uint;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_LCD1_ACTIVE: scratch_active_info_bits_def = 2;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP1_ACTIVE: scratch_active_info_bits_def = 8;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP2_ACTIVE: scratch_active_info_bits_def = 128;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP3_ACTIVE: scratch_active_info_bits_def = 512;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP4_ACTIVE: scratch_active_info_bits_def =
    1024;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP5_ACTIVE: scratch_active_info_bits_def =
    2048;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP6_ACTIVE: scratch_active_info_bits_def = 64;
pub const scratch_active_info_bits_def_ATOM_ACTIVE_INFO_DEVICE_MASK: scratch_active_info_bits_def =
    4095;
pub type scratch_active_info_bits_def = ::core::ffi::c_uint;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_LCD1_REQ: scratch_device_req_info_bits_def =
    2;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP1_REQ: scratch_device_req_info_bits_def =
    8;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP2_REQ: scratch_device_req_info_bits_def =
    128;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP3_REQ: scratch_device_req_info_bits_def =
    512;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP4_REQ: scratch_device_req_info_bits_def =
    1024;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP5_REQ: scratch_device_req_info_bits_def =
    2048;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP6_REQ: scratch_device_req_info_bits_def =
    64;
pub const scratch_device_req_info_bits_def_ATOM_REQ_INFO_DEVICE_MASK:
    scratch_device_req_info_bits_def = 4095;
pub type scratch_device_req_info_bits_def = ::core::ffi::c_uint;
pub const scratch_acc_change_info_bitshift_def_ATOM_ACC_CHANGE_ACC_MODE_SHIFT:
    scratch_acc_change_info_bitshift_def = 4;
pub const scratch_acc_change_info_bitshift_def_ATOM_ACC_CHANGE_LID_STATUS_SHIFT:
    scratch_acc_change_info_bitshift_def = 6;
pub type scratch_acc_change_info_bitshift_def = ::core::ffi::c_uint;
pub const scratch_acc_change_info_bits_def_ATOM_ACC_CHANGE_ACC_MODE:
    scratch_acc_change_info_bits_def = 16;
pub const scratch_acc_change_info_bits_def_ATOM_ACC_CHANGE_LID_STATUS:
    scratch_acc_change_info_bits_def = 64;
pub type scratch_acc_change_info_bits_def = ::core::ffi::c_uint;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_MASK:
    scratch_pre_os_mode_info_bits_def = 3;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_VGA:
    scratch_pre_os_mode_info_bits_def = 0;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_VESA:
    scratch_pre_os_mode_info_bits_def = 1;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_GOP:
    scratch_pre_os_mode_info_bits_def = 2;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_PIXEL_DEPTH:
    scratch_pre_os_mode_info_bits_def = 12;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_PIXEL_FORMAT_MASK:
    scratch_pre_os_mode_info_bits_def = 240;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_8BIT_PAL_EN:
    scratch_pre_os_mode_info_bits_def = 256;
pub const scratch_pre_os_mode_info_bits_def_ATOM_ASIC_INIT_COMPLETE:
    scratch_pre_os_mode_info_bits_def = 512;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_NUMBER_MASK:
    scratch_pre_os_mode_info_bits_def = 4294901760;
pub type scratch_pre_os_mode_info_bits_def = ::core::ffi::c_uint;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__UTILITY_PIPELINE: atom_master_data_table_id =
    0;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__MULTIMEDIA_INF: atom_master_data_table_id =
    1;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__FIRMWARE_INF: atom_master_data_table_id = 2;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__LCD_INF: atom_master_data_table_id = 3;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__SMU_INF: atom_master_data_table_id = 4;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__VRAM_USAGE_BY_FIRMWARE:
    atom_master_data_table_id = 5;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__GPIO_PIN_LUT: atom_master_data_table_id = 6;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__GFX_INF: atom_master_data_table_id = 7;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__POWER_PLAY_INF: atom_master_data_table_id =
    8;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__DISPLAY_OBJECT_INF:
    atom_master_data_table_id = 9;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__INDIRECT_IO_ACCESS:
    atom_master_data_table_id = 10;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__UMC_INF: atom_master_data_table_id = 11;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__DCE_INF: atom_master_data_table_id = 12;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__VRAM_INF: atom_master_data_table_id = 13;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__INTEGRATED_SYS_INF:
    atom_master_data_table_id = 14;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__ASIC_PROFILING_INF:
    atom_master_data_table_id = 15;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__VOLTAGE_OBJ_INF: atom_master_data_table_id =
    16;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__UNDEFINED: atom_master_data_table_id = 17;
pub type atom_master_data_table_id = ::core::ffi::c_uint;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__ASIC_INIT: atom_master_command_table_id =
    0;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__DIGX_ENCODER_CONTROL:
    atom_master_command_table_id = 1;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_ENGINE_CLOCK:
    atom_master_command_table_id = 2;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_MEMORY_CLOCK:
    atom_master_command_table_id = 3;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_PIXEL_CLOCK:
    atom_master_command_table_id = 4;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__ENABLE_DISP_POWER_GATING:
    atom_master_command_table_id = 5;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__BLANK_CRTC: atom_master_command_table_id =
    6;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__ENABLE_CRTC: atom_master_command_table_id =
    7;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_SMU_CLOCK_INFO:
    atom_master_command_table_id = 8;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SELECT_CRTC_SOURCE:
    atom_master_command_table_id = 9;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_DCE_CLOCK:
    atom_master_command_table_id = 10;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_MEMORY_CLOCK:
    atom_master_command_table_id = 11;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_ENGINE_CLOCK:
    atom_master_command_table_id = 12;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_CRTC_USING_DTD_TIMING:
    atom_master_command_table_id = 13;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__EXTENAL_ENCODER_CONTROL:
    atom_master_command_table_id = 14;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__PROCESS_I2C_CHANNEL_TRANSACTION:
    atom_master_command_table_id = 15;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__COMPUTE_GPU_CLOCK_PARAM:
    atom_master_command_table_id = 16;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__DYNAMIC_MEMORY_SETTINGS:
    atom_master_command_table_id = 17;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__MEMORY_TRAINING:
    atom_master_command_table_id = 18;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_VOLTAGE: atom_master_command_table_id =
    19;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__DIG1_TRANSMITTER_CONTROL:
    atom_master_command_table_id = 20;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__PROCESS_AUX_CHANNEL_TRANSACTION:
    atom_master_command_table_id = 21;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_VOLTAGE_INF:
    atom_master_command_table_id = 22;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__UNDEFINED: atom_master_command_table_id =
    23;
pub type atom_master_command_table_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct metrics_table_header {
    pub structure_size: u16,
    pub format_revision: u8,
    pub content_revision: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of metrics_table_header"][::core::mem::size_of::<metrics_table_header>() - 4usize];
    ["Alignment of metrics_table_header"][::core::mem::align_of::<metrics_table_header>() - 2usize];
    ["Offset of field: metrics_table_header::structure_size"]
        [::core::mem::offset_of!(metrics_table_header, structure_size) - 0usize];
    ["Offset of field: metrics_table_header::format_revision"]
        [::core::mem::offset_of!(metrics_table_header, format_revision) - 2usize];
    ["Offset of field: metrics_table_header::content_revision"]
        [::core::mem::offset_of!(metrics_table_header, content_revision) - 3usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v1_0 {
    pub common_header: metrics_table_header,
    pub system_clock_counter: u64,
    pub temperature_edge: u16,
    pub temperature_hotspot: u16,
    pub temperature_mem: u16,
    pub temperature_vrgfx: u16,
    pub temperature_vrsoc: u16,
    pub temperature_vrmem: u16,
    pub average_gfx_activity: u16,
    pub average_umc_activity: u16,
    pub average_mm_activity: u16,
    pub average_socket_power: u16,
    pub energy_accumulator: u32,
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_vclk0_frequency: u16,
    pub average_dclk0_frequency: u16,
    pub average_vclk1_frequency: u16,
    pub average_dclk1_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_vclk0: u16,
    pub current_dclk0: u16,
    pub current_vclk1: u16,
    pub current_dclk1: u16,
    pub throttle_status: u32,
    pub current_fan_speed: u16,
    pub pcie_link_width: u8,
    pub pcie_link_speed: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of gpu_metrics_v1_0"][::core::mem::size_of::<gpu_metrics_v1_0>() - 80usize];
    ["Alignment of gpu_metrics_v1_0"][::core::mem::align_of::<gpu_metrics_v1_0>() - 8usize];
    ["Offset of field: gpu_metrics_v1_0::common_header"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, common_header) - 0usize];
    ["Offset of field: gpu_metrics_v1_0::system_clock_counter"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, system_clock_counter) - 8usize];
    ["Offset of field: gpu_metrics_v1_0::temperature_edge"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, temperature_edge) - 16usize];
    ["Offset of field: gpu_metrics_v1_0::temperature_hotspot"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, temperature_hotspot) - 18usize];
    ["Offset of field: gpu_metrics_v1_0::temperature_mem"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, temperature_mem) - 20usize];
    ["Offset of field: gpu_metrics_v1_0::temperature_vrgfx"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, temperature_vrgfx) - 22usize];
    ["Offset of field: gpu_metrics_v1_0::temperature_vrsoc"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, temperature_vrsoc) - 24usize];
    ["Offset of field: gpu_metrics_v1_0::temperature_vrmem"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, temperature_vrmem) - 26usize];
    ["Offset of field: gpu_metrics_v1_0::average_gfx_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, average_gfx_activity) - 28usize];
    ["Offset of field: gpu_metrics_v1_0::average_umc_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, average_umc_activity) - 30usize];
    ["Offset of field: gpu_metrics_v1_0::average_mm_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, average_mm_activity) - 32usize];
    ["Offset of field: gpu_metrics_v1_0::average_socket_power"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, average_socket_power) - 34usize];
    ["Offset of field: gpu_metrics_v1_0::energy_accumulator"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, energy_accumulator) - 36usize];
    ["Offset of field: gpu_metrics_v1_0::average_gfxclk_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, average_gfxclk_frequency) - 40usize];
    ["Offset of field: gpu_metrics_v1_0::average_socclk_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, average_socclk_frequency) - 42usize];
    ["Offset of field: gpu_metrics_v1_0::average_uclk_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, average_uclk_frequency) - 44usize];
    ["Offset of field: gpu_metrics_v1_0::average_vclk0_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, average_vclk0_frequency) - 46usize];
    ["Offset of field: gpu_metrics_v1_0::average_dclk0_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, average_dclk0_frequency) - 48usize];
    ["Offset of field: gpu_metrics_v1_0::average_vclk1_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, average_vclk1_frequency) - 50usize];
    ["Offset of field: gpu_metrics_v1_0::average_dclk1_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, average_dclk1_frequency) - 52usize];
    ["Offset of field: gpu_metrics_v1_0::current_gfxclk"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, current_gfxclk) - 54usize];
    ["Offset of field: gpu_metrics_v1_0::current_socclk"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, current_socclk) - 56usize];
    ["Offset of field: gpu_metrics_v1_0::current_uclk"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, current_uclk) - 58usize];
    ["Offset of field: gpu_metrics_v1_0::current_vclk0"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, current_vclk0) - 60usize];
    ["Offset of field: gpu_metrics_v1_0::current_dclk0"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, current_dclk0) - 62usize];
    ["Offset of field: gpu_metrics_v1_0::current_vclk1"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, current_vclk1) - 64usize];
    ["Offset of field: gpu_metrics_v1_0::current_dclk1"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, current_dclk1) - 66usize];
    ["Offset of field: gpu_metrics_v1_0::throttle_status"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, throttle_status) - 68usize];
    ["Offset of field: gpu_metrics_v1_0::current_fan_speed"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, current_fan_speed) - 72usize];
    ["Offset of field: gpu_metrics_v1_0::pcie_link_width"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, pcie_link_width) - 74usize];
    ["Offset of field: gpu_metrics_v1_0::pcie_link_speed"]
        [::core::mem::offset_of!(gpu_metrics_v1_0, pcie_link_speed) - 75usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v1_1 {
    pub common_header: metrics_table_header,
    pub temperature_edge: u16,
    pub temperature_hotspot: u16,
    pub temperature_mem: u16,
    pub temperature_vrgfx: u16,
    pub temperature_vrsoc: u16,
    pub temperature_vrmem: u16,
    pub average_gfx_activity: u16,
    pub average_umc_activity: u16,
    pub average_mm_activity: u16,
    pub average_socket_power: u16,
    pub energy_accumulator: u64,
    pub system_clock_counter: u64,
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_vclk0_frequency: u16,
    pub average_dclk0_frequency: u16,
    pub average_vclk1_frequency: u16,
    pub average_dclk1_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_vclk0: u16,
    pub current_dclk0: u16,
    pub current_vclk1: u16,
    pub current_dclk1: u16,
    pub throttle_status: u32,
    pub current_fan_speed: u16,
    pub pcie_link_width: u16,
    pub pcie_link_speed: u16,
    pub padding: u16,
    pub gfx_activity_acc: u32,
    pub mem_activity_acc: u32,
    pub temperature_hbm: [u16; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of gpu_metrics_v1_1"][::core::mem::size_of::<gpu_metrics_v1_1>() - 96usize];
    ["Alignment of gpu_metrics_v1_1"][::core::mem::align_of::<gpu_metrics_v1_1>() - 8usize];
    ["Offset of field: gpu_metrics_v1_1::common_header"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, common_header) - 0usize];
    ["Offset of field: gpu_metrics_v1_1::temperature_edge"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, temperature_edge) - 4usize];
    ["Offset of field: gpu_metrics_v1_1::temperature_hotspot"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, temperature_hotspot) - 6usize];
    ["Offset of field: gpu_metrics_v1_1::temperature_mem"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, temperature_mem) - 8usize];
    ["Offset of field: gpu_metrics_v1_1::temperature_vrgfx"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, temperature_vrgfx) - 10usize];
    ["Offset of field: gpu_metrics_v1_1::temperature_vrsoc"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, temperature_vrsoc) - 12usize];
    ["Offset of field: gpu_metrics_v1_1::temperature_vrmem"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, temperature_vrmem) - 14usize];
    ["Offset of field: gpu_metrics_v1_1::average_gfx_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, average_gfx_activity) - 16usize];
    ["Offset of field: gpu_metrics_v1_1::average_umc_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, average_umc_activity) - 18usize];
    ["Offset of field: gpu_metrics_v1_1::average_mm_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, average_mm_activity) - 20usize];
    ["Offset of field: gpu_metrics_v1_1::average_socket_power"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, average_socket_power) - 22usize];
    ["Offset of field: gpu_metrics_v1_1::energy_accumulator"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, energy_accumulator) - 24usize];
    ["Offset of field: gpu_metrics_v1_1::system_clock_counter"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, system_clock_counter) - 32usize];
    ["Offset of field: gpu_metrics_v1_1::average_gfxclk_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, average_gfxclk_frequency) - 40usize];
    ["Offset of field: gpu_metrics_v1_1::average_socclk_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, average_socclk_frequency) - 42usize];
    ["Offset of field: gpu_metrics_v1_1::average_uclk_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, average_uclk_frequency) - 44usize];
    ["Offset of field: gpu_metrics_v1_1::average_vclk0_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, average_vclk0_frequency) - 46usize];
    ["Offset of field: gpu_metrics_v1_1::average_dclk0_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, average_dclk0_frequency) - 48usize];
    ["Offset of field: gpu_metrics_v1_1::average_vclk1_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, average_vclk1_frequency) - 50usize];
    ["Offset of field: gpu_metrics_v1_1::average_dclk1_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, average_dclk1_frequency) - 52usize];
    ["Offset of field: gpu_metrics_v1_1::current_gfxclk"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, current_gfxclk) - 54usize];
    ["Offset of field: gpu_metrics_v1_1::current_socclk"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, current_socclk) - 56usize];
    ["Offset of field: gpu_metrics_v1_1::current_uclk"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, current_uclk) - 58usize];
    ["Offset of field: gpu_metrics_v1_1::current_vclk0"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, current_vclk0) - 60usize];
    ["Offset of field: gpu_metrics_v1_1::current_dclk0"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, current_dclk0) - 62usize];
    ["Offset of field: gpu_metrics_v1_1::current_vclk1"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, current_vclk1) - 64usize];
    ["Offset of field: gpu_metrics_v1_1::current_dclk1"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, current_dclk1) - 66usize];
    ["Offset of field: gpu_metrics_v1_1::throttle_status"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, throttle_status) - 68usize];
    ["Offset of field: gpu_metrics_v1_1::current_fan_speed"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, current_fan_speed) - 72usize];
    ["Offset of field: gpu_metrics_v1_1::pcie_link_width"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, pcie_link_width) - 74usize];
    ["Offset of field: gpu_metrics_v1_1::pcie_link_speed"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, pcie_link_speed) - 76usize];
    ["Offset of field: gpu_metrics_v1_1::padding"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, padding) - 78usize];
    ["Offset of field: gpu_metrics_v1_1::gfx_activity_acc"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, gfx_activity_acc) - 80usize];
    ["Offset of field: gpu_metrics_v1_1::mem_activity_acc"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, mem_activity_acc) - 84usize];
    ["Offset of field: gpu_metrics_v1_1::temperature_hbm"]
        [::core::mem::offset_of!(gpu_metrics_v1_1, temperature_hbm) - 88usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v1_2 {
    pub common_header: metrics_table_header,
    pub temperature_edge: u16,
    pub temperature_hotspot: u16,
    pub temperature_mem: u16,
    pub temperature_vrgfx: u16,
    pub temperature_vrsoc: u16,
    pub temperature_vrmem: u16,
    pub average_gfx_activity: u16,
    pub average_umc_activity: u16,
    pub average_mm_activity: u16,
    pub average_socket_power: u16,
    pub energy_accumulator: u64,
    pub system_clock_counter: u64,
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_vclk0_frequency: u16,
    pub average_dclk0_frequency: u16,
    pub average_vclk1_frequency: u16,
    pub average_dclk1_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_vclk0: u16,
    pub current_dclk0: u16,
    pub current_vclk1: u16,
    pub current_dclk1: u16,
    pub throttle_status: u32,
    pub current_fan_speed: u16,
    pub pcie_link_width: u16,
    pub pcie_link_speed: u16,
    pub padding: u16,
    pub gfx_activity_acc: u32,
    pub mem_activity_acc: u32,
    pub temperature_hbm: [u16; 4usize],
    pub firmware_timestamp: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of gpu_metrics_v1_2"][::core::mem::size_of::<gpu_metrics_v1_2>() - 104usize];
    ["Alignment of gpu_metrics_v1_2"][::core::mem::align_of::<gpu_metrics_v1_2>() - 8usize];
    ["Offset of field: gpu_metrics_v1_2::common_header"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, common_header) - 0usize];
    ["Offset of field: gpu_metrics_v1_2::temperature_edge"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, temperature_edge) - 4usize];
    ["Offset of field: gpu_metrics_v1_2::temperature_hotspot"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, temperature_hotspot) - 6usize];
    ["Offset of field: gpu_metrics_v1_2::temperature_mem"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, temperature_mem) - 8usize];
    ["Offset of field: gpu_metrics_v1_2::temperature_vrgfx"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, temperature_vrgfx) - 10usize];
    ["Offset of field: gpu_metrics_v1_2::temperature_vrsoc"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, temperature_vrsoc) - 12usize];
    ["Offset of field: gpu_metrics_v1_2::temperature_vrmem"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, temperature_vrmem) - 14usize];
    ["Offset of field: gpu_metrics_v1_2::average_gfx_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, average_gfx_activity) - 16usize];
    ["Offset of field: gpu_metrics_v1_2::average_umc_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, average_umc_activity) - 18usize];
    ["Offset of field: gpu_metrics_v1_2::average_mm_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, average_mm_activity) - 20usize];
    ["Offset of field: gpu_metrics_v1_2::average_socket_power"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, average_socket_power) - 22usize];
    ["Offset of field: gpu_metrics_v1_2::energy_accumulator"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, energy_accumulator) - 24usize];
    ["Offset of field: gpu_metrics_v1_2::system_clock_counter"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, system_clock_counter) - 32usize];
    ["Offset of field: gpu_metrics_v1_2::average_gfxclk_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, average_gfxclk_frequency) - 40usize];
    ["Offset of field: gpu_metrics_v1_2::average_socclk_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, average_socclk_frequency) - 42usize];
    ["Offset of field: gpu_metrics_v1_2::average_uclk_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, average_uclk_frequency) - 44usize];
    ["Offset of field: gpu_metrics_v1_2::average_vclk0_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, average_vclk0_frequency) - 46usize];
    ["Offset of field: gpu_metrics_v1_2::average_dclk0_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, average_dclk0_frequency) - 48usize];
    ["Offset of field: gpu_metrics_v1_2::average_vclk1_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, average_vclk1_frequency) - 50usize];
    ["Offset of field: gpu_metrics_v1_2::average_dclk1_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, average_dclk1_frequency) - 52usize];
    ["Offset of field: gpu_metrics_v1_2::current_gfxclk"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, current_gfxclk) - 54usize];
    ["Offset of field: gpu_metrics_v1_2::current_socclk"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, current_socclk) - 56usize];
    ["Offset of field: gpu_metrics_v1_2::current_uclk"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, current_uclk) - 58usize];
    ["Offset of field: gpu_metrics_v1_2::current_vclk0"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, current_vclk0) - 60usize];
    ["Offset of field: gpu_metrics_v1_2::current_dclk0"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, current_dclk0) - 62usize];
    ["Offset of field: gpu_metrics_v1_2::current_vclk1"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, current_vclk1) - 64usize];
    ["Offset of field: gpu_metrics_v1_2::current_dclk1"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, current_dclk1) - 66usize];
    ["Offset of field: gpu_metrics_v1_2::throttle_status"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, throttle_status) - 68usize];
    ["Offset of field: gpu_metrics_v1_2::current_fan_speed"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, current_fan_speed) - 72usize];
    ["Offset of field: gpu_metrics_v1_2::pcie_link_width"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, pcie_link_width) - 74usize];
    ["Offset of field: gpu_metrics_v1_2::pcie_link_speed"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, pcie_link_speed) - 76usize];
    ["Offset of field: gpu_metrics_v1_2::padding"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, padding) - 78usize];
    ["Offset of field: gpu_metrics_v1_2::gfx_activity_acc"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, gfx_activity_acc) - 80usize];
    ["Offset of field: gpu_metrics_v1_2::mem_activity_acc"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, mem_activity_acc) - 84usize];
    ["Offset of field: gpu_metrics_v1_2::temperature_hbm"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, temperature_hbm) - 88usize];
    ["Offset of field: gpu_metrics_v1_2::firmware_timestamp"]
        [::core::mem::offset_of!(gpu_metrics_v1_2, firmware_timestamp) - 96usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v1_3 {
    pub common_header: metrics_table_header,
    pub temperature_edge: u16,
    pub temperature_hotspot: u16,
    pub temperature_mem: u16,
    pub temperature_vrgfx: u16,
    pub temperature_vrsoc: u16,
    pub temperature_vrmem: u16,
    pub average_gfx_activity: u16,
    pub average_umc_activity: u16,
    pub average_mm_activity: u16,
    pub average_socket_power: u16,
    pub energy_accumulator: u64,
    pub system_clock_counter: u64,
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_vclk0_frequency: u16,
    pub average_dclk0_frequency: u16,
    pub average_vclk1_frequency: u16,
    pub average_dclk1_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_vclk0: u16,
    pub current_dclk0: u16,
    pub current_vclk1: u16,
    pub current_dclk1: u16,
    pub throttle_status: u32,
    pub current_fan_speed: u16,
    pub pcie_link_width: u16,
    pub pcie_link_speed: u16,
    pub padding: u16,
    pub gfx_activity_acc: u32,
    pub mem_activity_acc: u32,
    pub temperature_hbm: [u16; 4usize],
    pub firmware_timestamp: u64,
    pub voltage_soc: u16,
    pub voltage_gfx: u16,
    pub voltage_mem: u16,
    pub padding1: u16,
    pub indep_throttle_status: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of gpu_metrics_v1_3"][::core::mem::size_of::<gpu_metrics_v1_3>() - 120usize];
    ["Alignment of gpu_metrics_v1_3"][::core::mem::align_of::<gpu_metrics_v1_3>() - 8usize];
    ["Offset of field: gpu_metrics_v1_3::common_header"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, common_header) - 0usize];
    ["Offset of field: gpu_metrics_v1_3::temperature_edge"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, temperature_edge) - 4usize];
    ["Offset of field: gpu_metrics_v1_3::temperature_hotspot"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, temperature_hotspot) - 6usize];
    ["Offset of field: gpu_metrics_v1_3::temperature_mem"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, temperature_mem) - 8usize];
    ["Offset of field: gpu_metrics_v1_3::temperature_vrgfx"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, temperature_vrgfx) - 10usize];
    ["Offset of field: gpu_metrics_v1_3::temperature_vrsoc"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, temperature_vrsoc) - 12usize];
    ["Offset of field: gpu_metrics_v1_3::temperature_vrmem"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, temperature_vrmem) - 14usize];
    ["Offset of field: gpu_metrics_v1_3::average_gfx_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, average_gfx_activity) - 16usize];
    ["Offset of field: gpu_metrics_v1_3::average_umc_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, average_umc_activity) - 18usize];
    ["Offset of field: gpu_metrics_v1_3::average_mm_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, average_mm_activity) - 20usize];
    ["Offset of field: gpu_metrics_v1_3::average_socket_power"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, average_socket_power) - 22usize];
    ["Offset of field: gpu_metrics_v1_3::energy_accumulator"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, energy_accumulator) - 24usize];
    ["Offset of field: gpu_metrics_v1_3::system_clock_counter"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, system_clock_counter) - 32usize];
    ["Offset of field: gpu_metrics_v1_3::average_gfxclk_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, average_gfxclk_frequency) - 40usize];
    ["Offset of field: gpu_metrics_v1_3::average_socclk_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, average_socclk_frequency) - 42usize];
    ["Offset of field: gpu_metrics_v1_3::average_uclk_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, average_uclk_frequency) - 44usize];
    ["Offset of field: gpu_metrics_v1_3::average_vclk0_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, average_vclk0_frequency) - 46usize];
    ["Offset of field: gpu_metrics_v1_3::average_dclk0_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, average_dclk0_frequency) - 48usize];
    ["Offset of field: gpu_metrics_v1_3::average_vclk1_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, average_vclk1_frequency) - 50usize];
    ["Offset of field: gpu_metrics_v1_3::average_dclk1_frequency"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, average_dclk1_frequency) - 52usize];
    ["Offset of field: gpu_metrics_v1_3::current_gfxclk"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, current_gfxclk) - 54usize];
    ["Offset of field: gpu_metrics_v1_3::current_socclk"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, current_socclk) - 56usize];
    ["Offset of field: gpu_metrics_v1_3::current_uclk"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, current_uclk) - 58usize];
    ["Offset of field: gpu_metrics_v1_3::current_vclk0"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, current_vclk0) - 60usize];
    ["Offset of field: gpu_metrics_v1_3::current_dclk0"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, current_dclk0) - 62usize];
    ["Offset of field: gpu_metrics_v1_3::current_vclk1"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, current_vclk1) - 64usize];
    ["Offset of field: gpu_metrics_v1_3::current_dclk1"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, current_dclk1) - 66usize];
    ["Offset of field: gpu_metrics_v1_3::throttle_status"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, throttle_status) - 68usize];
    ["Offset of field: gpu_metrics_v1_3::current_fan_speed"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, current_fan_speed) - 72usize];
    ["Offset of field: gpu_metrics_v1_3::pcie_link_width"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, pcie_link_width) - 74usize];
    ["Offset of field: gpu_metrics_v1_3::pcie_link_speed"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, pcie_link_speed) - 76usize];
    ["Offset of field: gpu_metrics_v1_3::padding"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, padding) - 78usize];
    ["Offset of field: gpu_metrics_v1_3::gfx_activity_acc"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, gfx_activity_acc) - 80usize];
    ["Offset of field: gpu_metrics_v1_3::mem_activity_acc"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, mem_activity_acc) - 84usize];
    ["Offset of field: gpu_metrics_v1_3::temperature_hbm"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, temperature_hbm) - 88usize];
    ["Offset of field: gpu_metrics_v1_3::firmware_timestamp"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, firmware_timestamp) - 96usize];
    ["Offset of field: gpu_metrics_v1_3::voltage_soc"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, voltage_soc) - 104usize];
    ["Offset of field: gpu_metrics_v1_3::voltage_gfx"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, voltage_gfx) - 106usize];
    ["Offset of field: gpu_metrics_v1_3::voltage_mem"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, voltage_mem) - 108usize];
    ["Offset of field: gpu_metrics_v1_3::padding1"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, padding1) - 110usize];
    ["Offset of field: gpu_metrics_v1_3::indep_throttle_status"]
        [::core::mem::offset_of!(gpu_metrics_v1_3, indep_throttle_status) - 112usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpu_metrics_v1_4 {
    pub common_header: metrics_table_header,
    pub temperature_hotspot: u16,
    pub temperature_mem: u16,
    pub temperature_vrsoc: u16,
    pub curr_socket_power: u16,
    pub average_gfx_activity: u16,
    pub average_umc_activity: u16,
    pub vcn_activity: [u16; 4usize],
    pub energy_accumulator: u64,
    pub system_clock_counter: u64,
    pub throttle_status: u32,
    pub gfxclk_lock_status: u32,
    pub pcie_link_width: u16,
    pub pcie_link_speed: u16,
    pub xgmi_link_width: u16,
    pub xgmi_link_speed: u16,
    pub gfx_activity_acc: u32,
    pub mem_activity_acc: u32,
    pub pcie_bandwidth_acc: u64,
    pub pcie_bandwidth_inst: u64,
    pub pcie_l0_to_recov_count_acc: u64,
    pub pcie_replay_count_acc: u64,
    pub pcie_replay_rover_count_acc: u64,
    pub xgmi_read_data_acc: [u64; 8usize],
    pub xgmi_write_data_acc: [u64; 8usize],
    pub firmware_timestamp: u64,
    pub current_gfxclk: [u16; 8usize],
    pub current_socclk: [u16; 4usize],
    pub current_vclk0: [u16; 4usize],
    pub current_dclk0: [u16; 4usize],
    pub current_uclk: u16,
    pub padding: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of gpu_metrics_v1_4"][::core::mem::size_of::<gpu_metrics_v1_4>() - 288usize];
    ["Alignment of gpu_metrics_v1_4"][::core::mem::align_of::<gpu_metrics_v1_4>() - 8usize];
    ["Offset of field: gpu_metrics_v1_4::common_header"]
        [::core::mem::offset_of!(gpu_metrics_v1_4, common_header) - 0usize];
    ["Offset of field: gpu_metrics_v1_4::temperature_hotspot"]
        [::core::mem::offset_of!(gpu_metrics_v1_4, temperature_hotspot) - 4usize];
    ["Offset of field: gpu_metrics_v1_4::temperature_mem"]
        [::core::mem::offset_of!(gpu_metrics_v1_4, temperature_mem) - 6usize];
    ["Offset of field: gpu_metrics_v1_4::temperature_vrsoc"]
        [::core::mem::offset_of!(gpu_metrics_v1_4, temperature_vrsoc) - 8usize];
    ["Offset of field: gpu_metrics_v1_4::curr_socket_power"]
        [::core::mem::offset_of!(gpu_metrics_v1_4, curr_socket_power) - 10usize];
    ["Offset of field: gpu_metrics_v1_4::average_gfx_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_4, average_gfx_activity) - 12usize];
    ["Offset of field: gpu_metrics_v1_4::average_umc_activity"]
        [::core::mem::offset_of!(gpu_metrics_v1_4, average_umc_activity) - 14usize];
    ["Offset of field: gpu_metrics_v1_4::vcn_activity"]
        [::core::mem::offset_of!(gpu_metri