/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.grpc.SynthesizeServerGrpc;
import org.languagetool.grpc.Synthesizer;
import org.languagetool.rules.GRPCUtils;
import org.languagetool.rules.ml.MLServerProto;
import org.languagetool.synthesis.Synthesizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSynthesizer
extends SynthesizeServerGrpc.SynthesizeServerImplBase {
    private static final Logger log = LoggerFactory.getLogger(RemoteSynthesizer.class);

    protected List<String> synthesize(String languageCode, String lemma, String postag, boolean postagRegexp) throws IOException {
        Language lang = Languages.getLanguageForShortCode((String)languageCode);
        Synthesizer synth = lang.getSynthesizer();
        AnalyzedToken at = new AnalyzedToken(lemma, postag, lemma);
        String[] synthesizedForms = synth.synthesize(at, postag, postagRegexp);
        return this.removeDuplicates(synthesizedForms);
    }

    protected List<String> synthesize(String languageCode, AnalyzedTokenReadings atrs, boolean postagRegexp, String postagSelect, String postagReplace, String lemmaReplace) throws IOException {
        if (!postagRegexp) {
            return this.synthesize(languageCode, lemmaReplace, postagReplace, false);
        }
        AnalyzedToken atr = atrs.readingWithTagRegex(postagSelect);
        if (atr == null) {
            log.error("AnalyzedToken is null. Language: " + languageCode + ", Token:" + atrs + ", postagSelect: " + postagSelect);
            return null;
        }
        if (lemmaReplace != null & !lemmaReplace.isEmpty()) {
            atr = new AnalyzedToken(atr.getToken(), atr.getPOSTag(), lemmaReplace);
        }
        String postagReplaceFinal = null;
        try {
            Pattern p = Pattern.compile(postagSelect);
            Matcher m = p.matcher(atr.getPOSTag());
            postagReplaceFinal = m.replaceAll(postagReplace);
        }
        catch (IndexOutOfBoundsException | PatternSyntaxException e) {
            log.error("Exception: error in regular expressions. Language: " + languageCode + ", Token:" + atrs, (Throwable)e);
            return null;
        }
        Language lang = Languages.getLanguageForShortCode((String)languageCode);
        Synthesizer synth = lang.getSynthesizer();
        String[] synthesizedForms = synth.synthesize(atr, postagReplaceFinal, true);
        return this.removeDuplicates(synthesizedForms);
    }

    private List<String> removeDuplicates(String[] forms) {
        ArrayList<String> results = new ArrayList<String>();
        for (String s : forms) {
            if (results.contains(s)) continue;
            results.add(s);
        }
        return results;
    }

    public void synthesize(Synthesizer.SynthesizeRequest request, StreamObserver<Synthesizer.SynthesizeResponse> responseObserver) {
        try {
            ArrayList<Synthesizer.SynthesizeResponseItem> items = new ArrayList<Synthesizer.SynthesizeResponseItem>();
            for (Synthesizer.SynthesizeRequestItem item : request.getItemsList()) {
                AnalyzedTokenReadings tokens = null;
                if (item.getPostagRegexp()) {
                    tokens = GRPCUtils.fromGRPC((MLServerProto.AnalyzedTokenReadings)item.getTokens());
                }
                List<String> forms = this.synthesize(request.getLanguageCode(), tokens, item.getPostagRegexp(), item.getPostag(), item.getPostagReplace(), item.getLemma());
                items.add(Synthesizer.SynthesizeResponseItem.newBuilder().addAllForms(forms).build());
            }
            responseObserver.onNext((Object)Synthesizer.SynthesizeResponse.newBuilder().addAllItems(items).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            log.warn("Synthesize request failed", (Throwable)e);
            responseObserver.onError((Throwable)e);
        }
    }

    private Options getCommandLineOptions() {
        Options options = new Options();
        options.addOption(Option.builder().longOpt("port").hasArg().build());
        options.addOption(Option.builder().longOpt("cert").hasArg().build());
        options.addOption(Option.builder().longOpt("key").hasArg().build());
        return options;
    }

    private CommandLine parseCommandLine(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        return parser.parse(this.getCommandLineOptions(), args);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        int port = 8080;
        File cert = null;
        File key = null;
        RemoteSynthesizer instance = new RemoteSynthesizer();
        try {
            CommandLine cli = instance.parseCommandLine(args);
            String certPath = cli.getOptionValue("cert");
            String keyPath = cli.getOptionValue("key");
            if (certPath != null && keyPath != null) {
                cert = new File(certPath);
                key = new File(keyPath);
            }
            if (cli.hasOption("port")) {
                port = Integer.parseInt(cli.getOptionValue("port"));
            }
        }
        catch (Exception e) {
            HelpFormatter help = new HelpFormatter();
            help.printHelp("RemoteSynthesizer", instance.getCommandLineOptions());
            System.exit(1);
            return;
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        ServerBuilder builder = ServerBuilder.forPort((int)port).addService((BindableService)instance).executor((Executor)executor);
        if (cert != null && key != null) {
            builder = builder.useTransportSecurity(cert, key);
        }
        Server server = builder.build();
        server.start();
        log.info("Server listening on port {}", (Object)port);
        server.awaitTermination();
    }
}

