package smarthosting

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListManagedRacks invokes the smarthosting.ListManagedRacks API synchronously
// api document: https://help.aliyun.com/api/smarthosting/listmanagedracks.html
func (client *Client) ListManagedRacks(request *ListManagedRacksRequest) (response *ListManagedRacksResponse, err error) {
	response = CreateListManagedRacksResponse()
	err = client.DoAction(request, response)
	return
}

// ListManagedRacksWithChan invokes the smarthosting.ListManagedRacks API asynchronously
// api document: https://help.aliyun.com/api/smarthosting/listmanagedracks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListManagedRacksWithChan(request *ListManagedRacksRequest) (<-chan *ListManagedRacksResponse, <-chan error) {
	responseChan := make(chan *ListManagedRacksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListManagedRacks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListManagedRacksWithCallback invokes the smarthosting.ListManagedRacks API asynchronously
// api document: https://help.aliyun.com/api/smarthosting/listmanagedracks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListManagedRacksWithCallback(request *ListManagedRacksRequest, callback func(response *ListManagedRacksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListManagedRacksResponse
		var err error
		defer close(result)
		response, err = client.ListManagedRacks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListManagedRacksRequest is the request struct for api ListManagedRacks
type ListManagedRacksRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostType              string           `position:"Query" name:"HostType"`
	NextToken             string           `position:"Query" name:"NextToken"`
	ManagedRackId         *[]string        `position:"Query" name:"ManagedRackId"  type:"Repeated"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	ManagedPrivateSpaceId string           `position:"Query" name:"ManagedPrivateSpaceId"`
	ZoneId                string           `position:"Query" name:"ZoneId"`
	MaxResults            requests.Integer `position:"Query" name:"MaxResults"`
}

// ListManagedRacksResponse is the response struct for api ListManagedRacks
type ListManagedRacksResponse struct {
	*responses.BaseResponse
	NextToken        string           `json:"NextToken" xml:"NextToken"`
	PageSize         int              `json:"PageSize" xml:"PageSize"`
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	TotalCount       int              `json:"TotalCount" xml:"TotalCount"`
	ManagedRacksSets ManagedRacksSets `json:"ManagedRacksSets" xml:"ManagedRacksSets"`
}

// CreateListManagedRacksRequest creates a request to invoke ListManagedRacks API
func CreateListManagedRacksRequest() (request *ListManagedRacksRequest) {
	request = &ListManagedRacksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SmartHosting", "2020-08-01", "ListManagedRacks", "smarthosting", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListManagedRacksResponse creates a response to parse from ListManagedRacks response
func CreateListManagedRacksResponse() (response *ListManagedRacksResponse) {
	response = &ListManagedRacksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
