package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySagManagementPort invokes the smartag.ModifySagManagementPort API synchronously
func (client *Client) ModifySagManagementPort(request *ModifySagManagementPortRequest) (response *ModifySagManagementPortResponse, err error) {
	response = CreateModifySagManagementPortResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySagManagementPortWithChan invokes the smartag.ModifySagManagementPort API asynchronously
func (client *Client) ModifySagManagementPortWithChan(request *ModifySagManagementPortRequest) (<-chan *ModifySagManagementPortResponse, <-chan error) {
	responseChan := make(chan *ModifySagManagementPortResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySagManagementPort(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySagManagementPortWithCallback invokes the smartag.ModifySagManagementPort API asynchronously
func (client *Client) ModifySagManagementPortWithCallback(request *ModifySagManagementPortRequest, callback func(response *ModifySagManagementPortResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySagManagementPortResponse
		var err error
		defer close(result)
		response, err = client.ModifySagManagementPort(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySagManagementPortRequest is the request struct for api ModifySagManagementPort
type ModifySagManagementPortRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Mask                 string           `position:"Query" name:"Mask"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	IP                   string           `position:"Query" name:"IP"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
	Gateway              string           `position:"Query" name:"Gateway"`
}

// ModifySagManagementPortResponse is the response struct for api ModifySagManagementPort
type ModifySagManagementPortResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySagManagementPortRequest creates a request to invoke ModifySagManagementPort API
func CreateModifySagManagementPortRequest() (request *ModifySagManagementPortRequest) {
	request = &ModifySagManagementPortRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySagManagementPort", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySagManagementPortResponse creates a response to parse from ModifySagManagementPort response
func CreateModifySagManagementPortResponse() (response *ModifySagManagementPortResponse) {
	response = &ModifySagManagementPortResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
