package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindVbr invokes the smartag.BindVbr API synchronously
func (client *Client) BindVbr(request *BindVbrRequest) (response *BindVbrResponse, err error) {
	response = CreateBindVbrResponse()
	err = client.DoAction(request, response)
	return
}

// BindVbrWithChan invokes the smartag.BindVbr API asynchronously
func (client *Client) BindVbrWithChan(request *BindVbrRequest) (<-chan *BindVbrResponse, <-chan error) {
	responseChan := make(chan *BindVbrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindVbr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindVbrWithCallback invokes the smartag.BindVbr API asynchronously
func (client *Client) BindVbrWithCallback(request *BindVbrRequest, callback func(response *BindVbrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindVbrResponse
		var err error
		defer close(result)
		response, err = client.BindVbr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindVbrRequest is the request struct for api BindVbr
type BindVbrRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	VbrId                string           `position:"Query" name:"VbrId"`
	VbrRegionId          string           `position:"Query" name:"VbrRegionId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGUid           requests.Integer `position:"Query" name:"SmartAGUid"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// BindVbrResponse is the response struct for api BindVbr
type BindVbrResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBindVbrRequest creates a request to invoke BindVbr API
func CreateBindVbrRequest() (request *BindVbrRequest) {
	request = &BindVbrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "BindVbr", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindVbrResponse creates a response to parse from BindVbr response
func CreateBindVbrResponse() (response *BindVbrResponse) {
	response = &BindVbrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
