package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveTagsFromGateway invokes the sgw.RemoveTagsFromGateway API synchronously
func (client *Client) RemoveTagsFromGateway(request *RemoveTagsFromGatewayRequest) (response *RemoveTagsFromGatewayResponse, err error) {
	response = CreateRemoveTagsFromGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveTagsFromGatewayWithChan invokes the sgw.RemoveTagsFromGateway API asynchronously
func (client *Client) RemoveTagsFromGatewayWithChan(request *RemoveTagsFromGatewayRequest) (<-chan *RemoveTagsFromGatewayResponse, <-chan error) {
	responseChan := make(chan *RemoveTagsFromGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveTagsFromGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveTagsFromGatewayWithCallback invokes the sgw.RemoveTagsFromGateway API asynchronously
func (client *Client) RemoveTagsFromGatewayWithCallback(request *RemoveTagsFromGatewayRequest, callback func(response *RemoveTagsFromGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveTagsFromGatewayResponse
		var err error
		defer close(result)
		response, err = client.RemoveTagsFromGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveTagsFromGatewayRequest is the request struct for api RemoveTagsFromGateway
type RemoveTagsFromGatewayRequest struct {
	*requests.RpcRequest
	Tags          string `position:"Query" name:"Tags"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// RemoveTagsFromGatewayResponse is the response struct for api RemoveTagsFromGateway
type RemoveTagsFromGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateRemoveTagsFromGatewayRequest creates a request to invoke RemoveTagsFromGateway API
func CreateRemoveTagsFromGatewayRequest() (request *RemoveTagsFromGatewayRequest) {
	request = &RemoveTagsFromGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "RemoveTagsFromGateway", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveTagsFromGatewayResponse creates a response to parse from RemoveTagsFromGateway response
func CreateRemoveTagsFromGatewayResponse() (response *RemoveTagsFromGatewayResponse) {
	response = &RemoveTagsFromGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
