package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeServiceMeshKubeconfig invokes the servicemesh.DescribeServiceMeshKubeconfig API synchronously
func (client *Client) DescribeServiceMeshKubeconfig(request *DescribeServiceMeshKubeconfigRequest) (response *DescribeServiceMeshKubeconfigResponse, err error) {
	response = CreateDescribeServiceMeshKubeconfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeServiceMeshKubeconfigWithChan invokes the servicemesh.DescribeServiceMeshKubeconfig API asynchronously
func (client *Client) DescribeServiceMeshKubeconfigWithChan(request *DescribeServiceMeshKubeconfigRequest) (<-chan *DescribeServiceMeshKubeconfigResponse, <-chan error) {
	responseChan := make(chan *DescribeServiceMeshKubeconfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeServiceMeshKubeconfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeServiceMeshKubeconfigWithCallback invokes the servicemesh.DescribeServiceMeshKubeconfig API asynchronously
func (client *Client) DescribeServiceMeshKubeconfigWithCallback(request *DescribeServiceMeshKubeconfigRequest, callback func(response *DescribeServiceMeshKubeconfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeServiceMeshKubeconfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeServiceMeshKubeconfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeServiceMeshKubeconfigRequest is the request struct for api DescribeServiceMeshKubeconfig
type DescribeServiceMeshKubeconfigRequest struct {
	*requests.RpcRequest
	PrivateIpAddress requests.Boolean `position:"Query" name:"PrivateIpAddress"`
	ServiceMeshId    string           `position:"Query" name:"ServiceMeshId"`
}

// DescribeServiceMeshKubeconfigResponse is the response struct for api DescribeServiceMeshKubeconfig
type DescribeServiceMeshKubeconfigResponse struct {
	*responses.BaseResponse
	Kubeconfig string `json:"Kubeconfig" xml:"Kubeconfig"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeServiceMeshKubeconfigRequest creates a request to invoke DescribeServiceMeshKubeconfig API
func CreateDescribeServiceMeshKubeconfigRequest() (request *DescribeServiceMeshKubeconfigRequest) {
	request = &DescribeServiceMeshKubeconfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "DescribeServiceMeshKubeconfig", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeServiceMeshKubeconfigResponse creates a response to parse from DescribeServiceMeshKubeconfig response
func CreateDescribeServiceMeshKubeconfigResponse() (response *DescribeServiceMeshKubeconfigResponse) {
	response = &DescribeServiceMeshKubeconfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
