package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHotlineRecord invokes the scsp.ListHotlineRecord API synchronously
func (client *Client) ListHotlineRecord(request *ListHotlineRecordRequest) (response *ListHotlineRecordResponse, err error) {
	response = CreateListHotlineRecordResponse()
	err = client.DoAction(request, response)
	return
}

// ListHotlineRecordWithChan invokes the scsp.ListHotlineRecord API asynchronously
func (client *Client) ListHotlineRecordWithChan(request *ListHotlineRecordRequest) (<-chan *ListHotlineRecordResponse, <-chan error) {
	responseChan := make(chan *ListHotlineRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHotlineRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHotlineRecordWithCallback invokes the scsp.ListHotlineRecord API asynchronously
func (client *Client) ListHotlineRecordWithCallback(request *ListHotlineRecordRequest, callback func(response *ListHotlineRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHotlineRecordResponse
		var err error
		defer close(result)
		response, err = client.ListHotlineRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHotlineRecordRequest is the request struct for api ListHotlineRecord
type ListHotlineRecordRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query"`
	InstanceId  string `position:"Query"`
	CallId      string `position:"Query"`
}

// ListHotlineRecordResponse is the response struct for api ListHotlineRecord
type ListHotlineRecordResponse struct {
	*responses.BaseResponse
	Message        string     `json:"Message" xml:"Message"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Code           string     `json:"Code" xml:"Code"`
	Success        bool       `json:"Success" xml:"Success"`
	HttpStatusCode int64      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateListHotlineRecordRequest creates a request to invoke ListHotlineRecord API
func CreateListHotlineRecordRequest() (request *ListHotlineRecordRequest) {
	request = &ListHotlineRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "ListHotlineRecord", "", "")
	request.Method = requests.GET
	return
}

// CreateListHotlineRecordResponse creates a response to parse from ListHotlineRecord response
func CreateListHotlineRecordResponse() (response *ListHotlineRecordResponse) {
	response = &ListHotlineRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
