package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEventSubscribe invokes the rtc.DeleteEventSubscribe API synchronously
func (client *Client) DeleteEventSubscribe(request *DeleteEventSubscribeRequest) (response *DeleteEventSubscribeResponse, err error) {
	response = CreateDeleteEventSubscribeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEventSubscribeWithChan invokes the rtc.DeleteEventSubscribe API asynchronously
func (client *Client) DeleteEventSubscribeWithChan(request *DeleteEventSubscribeRequest) (<-chan *DeleteEventSubscribeResponse, <-chan error) {
	responseChan := make(chan *DeleteEventSubscribeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEventSubscribe(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEventSubscribeWithCallback invokes the rtc.DeleteEventSubscribe API asynchronously
func (client *Client) DeleteEventSubscribeWithCallback(request *DeleteEventSubscribeRequest, callback func(response *DeleteEventSubscribeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEventSubscribeResponse
		var err error
		defer close(result)
		response, err = client.DeleteEventSubscribe(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEventSubscribeRequest is the request struct for api DeleteEventSubscribe
type DeleteEventSubscribeRequest struct {
	*requests.RpcRequest
	SubscribeId string           `position:"Query" name:"SubscribeId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	AppId       string           `position:"Query" name:"AppId"`
}

// DeleteEventSubscribeResponse is the response struct for api DeleteEventSubscribe
type DeleteEventSubscribeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteEventSubscribeRequest creates a request to invoke DeleteEventSubscribe API
func CreateDeleteEventSubscribeRequest() (request *DeleteEventSubscribeRequest) {
	request = &DeleteEventSubscribeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DeleteEventSubscribe", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteEventSubscribeResponse creates a response to parse from DeleteEventSubscribe response
func CreateDeleteEventSubscribeResponse() (response *DeleteEventSubscribeResponse) {
	response = &DeleteEventSubscribeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
