package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGlobalDatabaseNetwork invokes the polardb.DeleteGlobalDatabaseNetwork API synchronously
func (client *Client) DeleteGlobalDatabaseNetwork(request *DeleteGlobalDatabaseNetworkRequest) (response *DeleteGlobalDatabaseNetworkResponse, err error) {
	response = CreateDeleteGlobalDatabaseNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGlobalDatabaseNetworkWithChan invokes the polardb.DeleteGlobalDatabaseNetwork API asynchronously
func (client *Client) DeleteGlobalDatabaseNetworkWithChan(request *DeleteGlobalDatabaseNetworkRequest) (<-chan *DeleteGlobalDatabaseNetworkResponse, <-chan error) {
	responseChan := make(chan *DeleteGlobalDatabaseNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGlobalDatabaseNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGlobalDatabaseNetworkWithCallback invokes the polardb.DeleteGlobalDatabaseNetwork API asynchronously
func (client *Client) DeleteGlobalDatabaseNetworkWithCallback(request *DeleteGlobalDatabaseNetworkRequest, callback func(response *DeleteGlobalDatabaseNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGlobalDatabaseNetworkResponse
		var err error
		defer close(result)
		response, err = client.DeleteGlobalDatabaseNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGlobalDatabaseNetworkRequest is the request struct for api DeleteGlobalDatabaseNetwork
type DeleteGlobalDatabaseNetworkRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	GDNId                string           `position:"Query" name:"GDNId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteGlobalDatabaseNetworkResponse is the response struct for api DeleteGlobalDatabaseNetwork
type DeleteGlobalDatabaseNetworkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteGlobalDatabaseNetworkRequest creates a request to invoke DeleteGlobalDatabaseNetwork API
func CreateDeleteGlobalDatabaseNetworkRequest() (request *DeleteGlobalDatabaseNetworkRequest) {
	request = &DeleteGlobalDatabaseNetworkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DeleteGlobalDatabaseNetwork", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteGlobalDatabaseNetworkResponse creates a response to parse from DeleteGlobalDatabaseNetwork response
func CreateDeleteGlobalDatabaseNetworkResponse() (response *DeleteGlobalDatabaseNetworkResponse) {
	response = &DeleteGlobalDatabaseNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
