package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserAnalyzer invokes the opensearch.DescribeUserAnalyzer API synchronously
func (client *Client) DescribeUserAnalyzer(request *DescribeUserAnalyzerRequest) (response *DescribeUserAnalyzerResponse, err error) {
	response = CreateDescribeUserAnalyzerResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserAnalyzerWithChan invokes the opensearch.DescribeUserAnalyzer API asynchronously
func (client *Client) DescribeUserAnalyzerWithChan(request *DescribeUserAnalyzerRequest) (<-chan *DescribeUserAnalyzerResponse, <-chan error) {
	responseChan := make(chan *DescribeUserAnalyzerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserAnalyzer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserAnalyzerWithCallback invokes the opensearch.DescribeUserAnalyzer API asynchronously
func (client *Client) DescribeUserAnalyzerWithCallback(request *DescribeUserAnalyzerRequest, callback func(response *DescribeUserAnalyzerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserAnalyzerResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserAnalyzer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserAnalyzerRequest is the request struct for api DescribeUserAnalyzer
type DescribeUserAnalyzerRequest struct {
	*requests.RoaRequest
	With string `position:"Query" name:"with"`
	Name string `position:"Path" name:"name"`
}

// DescribeUserAnalyzerResponse is the response struct for api DescribeUserAnalyzer
type DescribeUserAnalyzerResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"requestId" xml:"requestId"`
	Result    map[string]interface{} `json:"result" xml:"result"`
}

// CreateDescribeUserAnalyzerRequest creates a request to invoke DescribeUserAnalyzer API
func CreateDescribeUserAnalyzerRequest() (request *DescribeUserAnalyzerRequest) {
	request = &DescribeUserAnalyzerRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "DescribeUserAnalyzer", "/v4/openapi/user-analyzers/[name]", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeUserAnalyzerResponse creates a response to parse from DescribeUserAnalyzer response
func CreateDescribeUserAnalyzerResponse() (response *DescribeUserAnalyzerResponse) {
	response = &DescribeUserAnalyzerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
