package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLifecycleRetrieveJob invokes the nas.CreateLifecycleRetrieveJob API synchronously
func (client *Client) CreateLifecycleRetrieveJob(request *CreateLifecycleRetrieveJobRequest) (response *CreateLifecycleRetrieveJobResponse, err error) {
	response = CreateCreateLifecycleRetrieveJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLifecycleRetrieveJobWithChan invokes the nas.CreateLifecycleRetrieveJob API asynchronously
func (client *Client) CreateLifecycleRetrieveJobWithChan(request *CreateLifecycleRetrieveJobRequest) (<-chan *CreateLifecycleRetrieveJobResponse, <-chan error) {
	responseChan := make(chan *CreateLifecycleRetrieveJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLifecycleRetrieveJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLifecycleRetrieveJobWithCallback invokes the nas.CreateLifecycleRetrieveJob API asynchronously
func (client *Client) CreateLifecycleRetrieveJobWithCallback(request *CreateLifecycleRetrieveJobRequest, callback func(response *CreateLifecycleRetrieveJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLifecycleRetrieveJobResponse
		var err error
		defer close(result)
		response, err = client.CreateLifecycleRetrieveJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLifecycleRetrieveJobRequest is the request struct for api CreateLifecycleRetrieveJob
type CreateLifecycleRetrieveJobRequest struct {
	*requests.RpcRequest
	FileSystemId string    `position:"Query" name:"FileSystemId"`
	Paths        *[]string `position:"Query" name:"Paths"  type:"Repeated"`
}

// CreateLifecycleRetrieveJobResponse is the response struct for api CreateLifecycleRetrieveJob
type CreateLifecycleRetrieveJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateCreateLifecycleRetrieveJobRequest creates a request to invoke CreateLifecycleRetrieveJob API
func CreateCreateLifecycleRetrieveJobRequest() (request *CreateLifecycleRetrieveJobRequest) {
	request = &CreateLifecycleRetrieveJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "CreateLifecycleRetrieveJob", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateLifecycleRetrieveJobResponse creates a response to parse from CreateLifecycleRetrieveJob response
func CreateCreateLifecycleRetrieveJobResponse() (response *CreateLifecycleRetrieveJobResponse) {
	response = &CreateLifecycleRetrieveJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
