package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitComplexJob invokes the mts.SubmitComplexJob API synchronously
func (client *Client) SubmitComplexJob(request *SubmitComplexJobRequest) (response *SubmitComplexJobResponse, err error) {
	response = CreateSubmitComplexJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitComplexJobWithChan invokes the mts.SubmitComplexJob API asynchronously
func (client *Client) SubmitComplexJobWithChan(request *SubmitComplexJobRequest) (<-chan *SubmitComplexJobResponse, <-chan error) {
	responseChan := make(chan *SubmitComplexJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitComplexJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitComplexJobWithCallback invokes the mts.SubmitComplexJob API asynchronously
func (client *Client) SubmitComplexJobWithCallback(request *SubmitComplexJobRequest, callback func(response *SubmitComplexJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitComplexJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitComplexJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitComplexJobRequest is the request struct for api SubmitComplexJob
type SubmitComplexJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TranscodeOutput      string           `position:"Query" name:"TranscodeOutput"`
	Inputs               string           `position:"Query" name:"Inputs"`
	OutputLocation       string           `position:"Query" name:"OutputLocation"`
	UserData             string           `position:"Query" name:"UserData"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
	OutputBucket         string           `position:"Query" name:"OutputBucket"`
	ComplexConfigs       string           `position:"Query" name:"ComplexConfigs"`
}

// SubmitComplexJobResponse is the response struct for api SubmitComplexJob
type SubmitComplexJobResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	ComplexJob ComplexJob `json:"ComplexJob" xml:"ComplexJob"`
}

// CreateSubmitComplexJobRequest creates a request to invoke SubmitComplexJob API
func CreateSubmitComplexJobRequest() (request *SubmitComplexJobRequest) {
	request = &SubmitComplexJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitComplexJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitComplexJobResponse creates a response to parse from SubmitComplexJob response
func CreateSubmitComplexJobResponse() (response *SubmitComplexJobResponse) {
	response = &SubmitComplexJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
