package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGatewayDomain invokes the mse.UpdateGatewayDomain API synchronously
func (client *Client) UpdateGatewayDomain(request *UpdateGatewayDomainRequest) (response *UpdateGatewayDomainResponse, err error) {
	response = CreateUpdateGatewayDomainResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayDomainWithChan invokes the mse.UpdateGatewayDomain API asynchronously
func (client *Client) UpdateGatewayDomainWithChan(request *UpdateGatewayDomainRequest) (<-chan *UpdateGatewayDomainResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGatewayDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayDomainWithCallback invokes the mse.UpdateGatewayDomain API asynchronously
func (client *Client) UpdateGatewayDomainWithCallback(request *UpdateGatewayDomainRequest, callback func(response *UpdateGatewayDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayDomainResponse
		var err error
		defer close(result)
		response, err = client.UpdateGatewayDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayDomainRequest is the request struct for api UpdateGatewayDomain
type UpdateGatewayDomainRequest struct {
	*requests.RpcRequest
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	Protocol        string           `position:"Query" name:"Protocol"`
	MustHttps       requests.Boolean `position:"Query" name:"MustHttps"`
	Id              requests.Integer `position:"Query" name:"Id"`
	CertIdentifier  string           `position:"Query" name:"CertIdentifier"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// UpdateGatewayDomainResponse is the response struct for api UpdateGatewayDomain
type UpdateGatewayDomainResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateUpdateGatewayDomainRequest creates a request to invoke UpdateGatewayDomain API
func CreateUpdateGatewayDomainRequest() (request *UpdateGatewayDomainRequest) {
	request = &UpdateGatewayDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateGatewayDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayDomainResponse creates a response to parse from UpdateGatewayDomain response
func CreateUpdateGatewayDomainResponse() (response *UpdateGatewayDomainResponse) {
	response = &UpdateGatewayDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
