package mopen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MopenCreateGroup invokes the mopen.MopenCreateGroup API synchronously
// api document: https://help.aliyun.com/api/mopen/mopencreategroup.html
func (client *Client) MopenCreateGroup(request *MopenCreateGroupRequest) (response *MopenCreateGroupResponse, err error) {
	response = CreateMopenCreateGroupResponse()
	err = client.DoAction(request, response)
	return
}

// MopenCreateGroupWithChan invokes the mopen.MopenCreateGroup API asynchronously
// api document: https://help.aliyun.com/api/mopen/mopencreategroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MopenCreateGroupWithChan(request *MopenCreateGroupRequest) (<-chan *MopenCreateGroupResponse, <-chan error) {
	responseChan := make(chan *MopenCreateGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MopenCreateGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MopenCreateGroupWithCallback invokes the mopen.MopenCreateGroup API asynchronously
// api document: https://help.aliyun.com/api/mopen/mopencreategroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MopenCreateGroupWithCallback(request *MopenCreateGroupRequest, callback func(response *MopenCreateGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MopenCreateGroupResponse
		var err error
		defer close(result)
		response, err = client.MopenCreateGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MopenCreateGroupRequest is the request struct for api MopenCreateGroup
type MopenCreateGroupRequest struct {
	*requests.RpcRequest
	Creator string `position:"Body" name:"Creator"`
}

// MopenCreateGroupResponse is the response struct for api MopenCreateGroup
type MopenCreateGroupResponse struct {
	*responses.BaseResponse
	Code        int    `json:"Code" xml:"Code"`
	Success     string `json:"Success" xml:"Success"`
	Description string `json:"Description" xml:"Description"`
	Message     string `json:"Message" xml:"Message"`
	ResqusetId  string `json:"ResqusetId" xml:"ResqusetId"`
	Data        Data   `json:"Data" xml:"Data"`
}

// CreateMopenCreateGroupRequest creates a request to invoke MopenCreateGroup API
func CreateMopenCreateGroupRequest() (request *MopenCreateGroupRequest) {
	request = &MopenCreateGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("MoPen", "2018-02-11", "MopenCreateGroup", "mopen", "openAPI")
	return
}

// CreateMopenCreateGroupResponse creates a response to parse from MopenCreateGroup response
func CreateMopenCreateGroupResponse() (response *MopenCreateGroupResponse) {
	response = &MopenCreateGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
