package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RollbackLiveStagingConfig invokes the live.RollbackLiveStagingConfig API synchronously
func (client *Client) RollbackLiveStagingConfig(request *RollbackLiveStagingConfigRequest) (response *RollbackLiveStagingConfigResponse, err error) {
	response = CreateRollbackLiveStagingConfigResponse()
	err = client.DoAction(request, response)
	return
}

// RollbackLiveStagingConfigWithChan invokes the live.RollbackLiveStagingConfig API asynchronously
func (client *Client) RollbackLiveStagingConfigWithChan(request *RollbackLiveStagingConfigRequest) (<-chan *RollbackLiveStagingConfigResponse, <-chan error) {
	responseChan := make(chan *RollbackLiveStagingConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RollbackLiveStagingConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RollbackLiveStagingConfigWithCallback invokes the live.RollbackLiveStagingConfig API asynchronously
func (client *Client) RollbackLiveStagingConfigWithCallback(request *RollbackLiveStagingConfigRequest, callback func(response *RollbackLiveStagingConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RollbackLiveStagingConfigResponse
		var err error
		defer close(result)
		response, err = client.RollbackLiveStagingConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RollbackLiveStagingConfigRequest is the request struct for api RollbackLiveStagingConfig
type RollbackLiveStagingConfigRequest struct {
	*requests.RpcRequest
	FunctionName string           `position:"Query" name:"FunctionName"`
	DomainName   string           `position:"Query" name:"DomainName"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
}

// RollbackLiveStagingConfigResponse is the response struct for api RollbackLiveStagingConfig
type RollbackLiveStagingConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRollbackLiveStagingConfigRequest creates a request to invoke RollbackLiveStagingConfig API
func CreateRollbackLiveStagingConfigRequest() (request *RollbackLiveStagingConfigRequest) {
	request = &RollbackLiveStagingConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "RollbackLiveStagingConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRollbackLiveStagingConfigResponse creates a response to parse from RollbackLiveStagingConfig response
func CreateRollbackLiveStagingConfigResponse() (response *RollbackLiveStagingConfigResponse) {
	response = &RollbackLiveStagingConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
