package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetTransferCalleePoolConfig invokes the dyvmsapi.SetTransferCalleePoolConfig API synchronously
func (client *Client) SetTransferCalleePoolConfig(request *SetTransferCalleePoolConfigRequest) (response *SetTransferCalleePoolConfigResponse, err error) {
	response = CreateSetTransferCalleePoolConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SetTransferCalleePoolConfigWithChan invokes the dyvmsapi.SetTransferCalleePoolConfig API asynchronously
func (client *Client) SetTransferCalleePoolConfigWithChan(request *SetTransferCalleePoolConfigRequest) (<-chan *SetTransferCalleePoolConfigResponse, <-chan error) {
	responseChan := make(chan *SetTransferCalleePoolConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetTransferCalleePoolConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetTransferCalleePoolConfigWithCallback invokes the dyvmsapi.SetTransferCalleePoolConfig API asynchronously
func (client *Client) SetTransferCalleePoolConfigWithCallback(request *SetTransferCalleePoolConfigRequest, callback func(response *SetTransferCalleePoolConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetTransferCalleePoolConfigResponse
		var err error
		defer close(result)
		response, err = client.SetTransferCalleePoolConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetTransferCalleePoolConfigRequest is the request struct for api SetTransferCalleePoolConfig
type SetTransferCalleePoolConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer                      `position:"Query" name:"ResourceOwnerId"`
	PhoneNumber          string                                `position:"Query" name:"PhoneNumber"`
	Details              *[]SetTransferCalleePoolConfigDetails `position:"Query" name:"Details"  type:"Repeated"`
	CalledRouteMode      string                                `position:"Query" name:"CalledRouteMode"`
	QualificationId      string                                `position:"Query" name:"QualificationId"`
	ResourceOwnerAccount string                                `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer                      `position:"Query" name:"OwnerId"`
}

// SetTransferCalleePoolConfigDetails is a repeated param struct in SetTransferCalleePoolConfigRequest
type SetTransferCalleePoolConfigDetails struct {
	Caller string `name:"Caller"`
	Called string `name:"Called"`
}

// SetTransferCalleePoolConfigResponse is the response struct for api SetTransferCalleePoolConfig
type SetTransferCalleePoolConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateSetTransferCalleePoolConfigRequest creates a request to invoke SetTransferCalleePoolConfig API
func CreateSetTransferCalleePoolConfigRequest() (request *SetTransferCalleePoolConfigRequest) {
	request = &SetTransferCalleePoolConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "SetTransferCalleePoolConfig", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetTransferCalleePoolConfigResponse creates a response to parse from SetTransferCalleePoolConfig response
func CreateSetTransferCalleePoolConfigResponse() (response *SetTransferCalleePoolConfigResponse) {
	response = &SetTransferCalleePoolConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
