package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDtsEtlJobVersionInfo invokes the dts.DescribeDtsEtlJobVersionInfo API synchronously
func (client *Client) DescribeDtsEtlJobVersionInfo(request *DescribeDtsEtlJobVersionInfoRequest) (response *DescribeDtsEtlJobVersionInfoResponse, err error) {
	response = CreateDescribeDtsEtlJobVersionInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDtsEtlJobVersionInfoWithChan invokes the dts.DescribeDtsEtlJobVersionInfo API asynchronously
func (client *Client) DescribeDtsEtlJobVersionInfoWithChan(request *DescribeDtsEtlJobVersionInfoRequest) (<-chan *DescribeDtsEtlJobVersionInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDtsEtlJobVersionInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDtsEtlJobVersionInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDtsEtlJobVersionInfoWithCallback invokes the dts.DescribeDtsEtlJobVersionInfo API asynchronously
func (client *Client) DescribeDtsEtlJobVersionInfoWithCallback(request *DescribeDtsEtlJobVersionInfoRequest, callback func(response *DescribeDtsEtlJobVersionInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDtsEtlJobVersionInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDtsEtlJobVersionInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDtsEtlJobVersionInfoRequest is the request struct for api DescribeDtsEtlJobVersionInfo
type DescribeDtsEtlJobVersionInfoRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	DtsJobId      string           `position:"Query" name:"DtsJobId"`
	DtsInstanceId string           `position:"Query" name:"DtsInstanceId"`
}

// DescribeDtsEtlJobVersionInfoResponse is the response struct for api DescribeDtsEtlJobVersionInfo
type DescribeDtsEtlJobVersionInfoResponse struct {
	*responses.BaseResponse
	RequestId             string                 `json:"RequestId" xml:"RequestId"`
	Success               bool                   `json:"Success" xml:"Success"`
	ErrCode               string                 `json:"ErrCode" xml:"ErrCode"`
	PageNumber            int                    `json:"PageNumber" xml:"PageNumber"`
	PageRecordCount       int                    `json:"PageRecordCount" xml:"PageRecordCount"`
	TotalRecordCount      int                    `json:"TotalRecordCount" xml:"TotalRecordCount"`
	ErrMessage            string                 `json:"ErrMessage" xml:"ErrMessage"`
	HttpStatusCode        string                 `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode           string                 `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage        string                 `json:"DynamicMessage" xml:"DynamicMessage"`
	DtsEtlJobVersionInfos []DtsEtlJobVersionInfo `json:"DtsEtlJobVersionInfos" xml:"DtsEtlJobVersionInfos"`
}

// CreateDescribeDtsEtlJobVersionInfoRequest creates a request to invoke DescribeDtsEtlJobVersionInfo API
func CreateDescribeDtsEtlJobVersionInfoRequest() (request *DescribeDtsEtlJobVersionInfoRequest) {
	request = &DescribeDtsEtlJobVersionInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeDtsEtlJobVersionInfo", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDtsEtlJobVersionInfoResponse creates a response to parse from DescribeDtsEtlJobVersionInfo response
func CreateDescribeDtsEtlJobVersionInfoResponse() (response *DescribeDtsEtlJobVersionInfoResponse) {
	response = &DescribeDtsEtlJobVersionInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
