package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckExpandStatus invokes the drds.CheckExpandStatus API synchronously
func (client *Client) CheckExpandStatus(request *CheckExpandStatusRequest) (response *CheckExpandStatusResponse, err error) {
	response = CreateCheckExpandStatusResponse()
	err = client.DoAction(request, response)
	return
}

// CheckExpandStatusWithChan invokes the drds.CheckExpandStatus API asynchronously
func (client *Client) CheckExpandStatusWithChan(request *CheckExpandStatusRequest) (<-chan *CheckExpandStatusResponse, <-chan error) {
	responseChan := make(chan *CheckExpandStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckExpandStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckExpandStatusWithCallback invokes the drds.CheckExpandStatus API asynchronously
func (client *Client) CheckExpandStatusWithCallback(request *CheckExpandStatusRequest, callback func(response *CheckExpandStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckExpandStatusResponse
		var err error
		defer close(result)
		response, err = client.CheckExpandStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckExpandStatusRequest is the request struct for api CheckExpandStatus
type CheckExpandStatusRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
}

// CheckExpandStatusResponse is the response struct for api CheckExpandStatus
type CheckExpandStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCheckExpandStatusRequest creates a request to invoke CheckExpandStatus API
func CreateCheckExpandStatusRequest() (request *CheckExpandStatusRequest) {
	request = &CheckExpandStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "CheckExpandStatus", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckExpandStatusResponse creates a response to parse from CheckExpandStatus response
func CreateCheckExpandStatusResponse() (response *CheckExpandStatusResponse) {
	response = &CheckExpandStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
