package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTableDBTopology invokes the dms_enterprise.GetTableDBTopology API synchronously
func (client *Client) GetTableDBTopology(request *GetTableDBTopologyRequest) (response *GetTableDBTopologyResponse, err error) {
	response = CreateGetTableDBTopologyResponse()
	err = client.DoAction(request, response)
	return
}

// GetTableDBTopologyWithChan invokes the dms_enterprise.GetTableDBTopology API asynchronously
func (client *Client) GetTableDBTopologyWithChan(request *GetTableDBTopologyRequest) (<-chan *GetTableDBTopologyResponse, <-chan error) {
	responseChan := make(chan *GetTableDBTopologyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTableDBTopology(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTableDBTopologyWithCallback invokes the dms_enterprise.GetTableDBTopology API asynchronously
func (client *Client) GetTableDBTopologyWithCallback(request *GetTableDBTopologyRequest, callback func(response *GetTableDBTopologyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTableDBTopologyResponse
		var err error
		defer close(result)
		response, err = client.GetTableDBTopology(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTableDBTopologyRequest is the request struct for api GetTableDBTopology
type GetTableDBTopologyRequest struct {
	*requests.RpcRequest
	TableGuid string           `position:"Query" name:"TableGuid"`
	Tid       requests.Integer `position:"Query" name:"Tid"`
}

// GetTableDBTopologyResponse is the response struct for api GetTableDBTopology
type GetTableDBTopologyResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	ErrorCode    string     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string     `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool       `json:"Success" xml:"Success"`
	DBTopology   DBTopology `json:"DBTopology" xml:"DBTopology"`
}

// CreateGetTableDBTopologyRequest creates a request to invoke GetTableDBTopology API
func CreateGetTableDBTopologyRequest() (request *GetTableDBTopologyRequest) {
	request = &GetTableDBTopologyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetTableDBTopology", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetTableDBTopologyResponse creates a response to parse from GetTableDBTopology response
func CreateGetTableDBTopologyResponse() (response *GetTableDBTopologyResponse) {
	response = &GetTableDBTopologyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
