package dg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDatabaseAccessPoint invokes the dg.ListDatabaseAccessPoint API synchronously
func (client *Client) ListDatabaseAccessPoint(request *ListDatabaseAccessPointRequest) (response *ListDatabaseAccessPointResponse, err error) {
	response = CreateListDatabaseAccessPointResponse()
	err = client.DoAction(request, response)
	return
}

// ListDatabaseAccessPointWithChan invokes the dg.ListDatabaseAccessPoint API asynchronously
func (client *Client) ListDatabaseAccessPointWithChan(request *ListDatabaseAccessPointRequest) (<-chan *ListDatabaseAccessPointResponse, <-chan error) {
	responseChan := make(chan *ListDatabaseAccessPointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDatabaseAccessPoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDatabaseAccessPointWithCallback invokes the dg.ListDatabaseAccessPoint API asynchronously
func (client *Client) ListDatabaseAccessPointWithCallback(request *ListDatabaseAccessPointRequest, callback func(response *ListDatabaseAccessPointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDatabaseAccessPointResponse
		var err error
		defer close(result)
		response, err = client.ListDatabaseAccessPoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDatabaseAccessPointRequest is the request struct for api ListDatabaseAccessPoint
type ListDatabaseAccessPointRequest struct {
	*requests.RpcRequest
	SearchKey    string           `position:"Body" name:"SearchKey"`
	PageNumber   string           `position:"Body" name:"PageNumber"`
	PageSize     string           `position:"Body" name:"PageSize"`
	Host         string           `position:"Body" name:"Host"`
	DbInstanceId string           `position:"Body" name:"DbInstanceId"`
	GatewayId    string           `position:"Body" name:"GatewayId"`
	Port         requests.Integer `position:"Body" name:"Port"`
	VpcId        string           `position:"Body" name:"VpcId"`
}

// ListDatabaseAccessPointResponse is the response struct for api ListDatabaseAccessPoint
type ListDatabaseAccessPointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	Data      string `json:"Data" xml:"Data"`
	Count     int    `json:"Count" xml:"Count"`
}

// CreateListDatabaseAccessPointRequest creates a request to invoke ListDatabaseAccessPoint API
func CreateListDatabaseAccessPointRequest() (request *ListDatabaseAccessPointRequest) {
	request = &ListDatabaseAccessPointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dg", "2019-03-27", "ListDatabaseAccessPoint", "dg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDatabaseAccessPointResponse creates a response to parse from ListDatabaseAccessPoint response
func CreateListDatabaseAccessPointResponse() (response *ListDatabaseAccessPointResponse) {
	response = &ListDatabaseAccessPointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
