package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCredential invokes the devops_rdc.CreateCredential API synchronously
func (client *Client) CreateCredential(request *CreateCredentialRequest) (response *CreateCredentialResponse, err error) {
	response = CreateCreateCredentialResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCredentialWithChan invokes the devops_rdc.CreateCredential API asynchronously
func (client *Client) CreateCredentialWithChan(request *CreateCredentialRequest) (<-chan *CreateCredentialResponse, <-chan error) {
	responseChan := make(chan *CreateCredentialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCredential(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCredentialWithCallback invokes the devops_rdc.CreateCredential API asynchronously
func (client *Client) CreateCredentialWithCallback(request *CreateCredentialRequest, callback func(response *CreateCredentialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCredentialResponse
		var err error
		defer close(result)
		response, err = client.CreateCredential(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCredentialRequest is the request struct for api CreateCredential
type CreateCredentialRequest struct {
	*requests.RpcRequest
	Type     string `position:"Body" name:"Type"`
	UserPk   string `position:"Body" name:"UserPk"`
	OrgId    string `position:"Body" name:"OrgId"`
	Password string `position:"Body" name:"Password"`
	Name     string `position:"Body" name:"Name"`
	UserName string `position:"Body" name:"UserName"`
}

// CreateCredentialResponse is the response struct for api CreateCredential
type CreateCredentialResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Object       int64  `json:"Object" xml:"Object"`
}

// CreateCreateCredentialRequest creates a request to invoke CreateCredential API
func CreateCreateCredentialRequest() (request *CreateCredentialRequest) {
	request = &CreateCredentialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "CreateCredential", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCredentialResponse creates a response to parse from CreateCredential response
func CreateCreateCredentialResponse() (response *CreateCredentialResponse) {
	response = &CreateCredentialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
