package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigLayer4RuleAttribute invokes the ddoscoo.ConfigLayer4RuleAttribute API synchronously
func (client *Client) ConfigLayer4RuleAttribute(request *ConfigLayer4RuleAttributeRequest) (response *ConfigLayer4RuleAttributeResponse, err error) {
	response = CreateConfigLayer4RuleAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigLayer4RuleAttributeWithChan invokes the ddoscoo.ConfigLayer4RuleAttribute API asynchronously
func (client *Client) ConfigLayer4RuleAttributeWithChan(request *ConfigLayer4RuleAttributeRequest) (<-chan *ConfigLayer4RuleAttributeResponse, <-chan error) {
	responseChan := make(chan *ConfigLayer4RuleAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigLayer4RuleAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigLayer4RuleAttributeWithCallback invokes the ddoscoo.ConfigLayer4RuleAttribute API asynchronously
func (client *Client) ConfigLayer4RuleAttributeWithCallback(request *ConfigLayer4RuleAttributeRequest, callback func(response *ConfigLayer4RuleAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigLayer4RuleAttributeResponse
		var err error
		defer close(result)
		response, err = client.ConfigLayer4RuleAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigLayer4RuleAttributeRequest is the request struct for api ConfigLayer4RuleAttribute
type ConfigLayer4RuleAttributeRequest struct {
	*requests.RpcRequest
	InstanceId      string           `position:"Query" name:"InstanceId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	FrontendPort    requests.Integer `position:"Query" name:"FrontendPort"`
	ForwardProtocol string           `position:"Query" name:"ForwardProtocol"`
	Config          string           `position:"Query" name:"Config"`
}

// ConfigLayer4RuleAttributeResponse is the response struct for api ConfigLayer4RuleAttribute
type ConfigLayer4RuleAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigLayer4RuleAttributeRequest creates a request to invoke ConfigLayer4RuleAttribute API
func CreateConfigLayer4RuleAttributeRequest() (request *ConfigLayer4RuleAttributeRequest) {
	request = &ConfigLayer4RuleAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "ConfigLayer4RuleAttribute", "", "")
	request.Method = requests.POST
	return
}

// CreateConfigLayer4RuleAttributeResponse creates a response to parse from ConfigLayer4RuleAttribute response
func CreateConfigLayer4RuleAttributeResponse() (response *ConfigLayer4RuleAttributeResponse) {
	response = &ConfigLayer4RuleAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
