package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainUvData invokes the dcdn.DescribeDcdnDomainUvData API synchronously
func (client *Client) DescribeDcdnDomainUvData(request *DescribeDcdnDomainUvDataRequest) (response *DescribeDcdnDomainUvDataResponse, err error) {
	response = CreateDescribeDcdnDomainUvDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainUvDataWithChan invokes the dcdn.DescribeDcdnDomainUvData API asynchronously
func (client *Client) DescribeDcdnDomainUvDataWithChan(request *DescribeDcdnDomainUvDataRequest) (<-chan *DescribeDcdnDomainUvDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainUvDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainUvData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainUvDataWithCallback invokes the dcdn.DescribeDcdnDomainUvData API asynchronously
func (client *Client) DescribeDcdnDomainUvDataWithCallback(request *DescribeDcdnDomainUvDataRequest, callback func(response *DescribeDcdnDomainUvDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainUvDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainUvData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainUvDataRequest is the request struct for api DescribeDcdnDomainUvData
type DescribeDcdnDomainUvDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDcdnDomainUvDataResponse is the response struct for api DescribeDcdnDomainUvData
type DescribeDcdnDomainUvDataResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	DomainName     string         `json:"DomainName" xml:"DomainName"`
	StartTime      string         `json:"StartTime" xml:"StartTime"`
	EndTime        string         `json:"EndTime" xml:"EndTime"`
	DataInterval   string         `json:"DataInterval" xml:"DataInterval"`
	UvDataInterval UvDataInterval `json:"UvDataInterval" xml:"UvDataInterval"`
}

// CreateDescribeDcdnDomainUvDataRequest creates a request to invoke DescribeDcdnDomainUvData API
func CreateDescribeDcdnDomainUvDataRequest() (request *DescribeDcdnDomainUvDataRequest) {
	request = &DescribeDcdnDomainUvDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainUvData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainUvDataResponse creates a response to parse from DescribeDcdnDomainUvData response
func CreateDescribeDcdnDomainUvDataResponse() (response *DescribeDcdnDomainUvDataResponse) {
	response = &DescribeDcdnDomainUvDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
