package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceConsumeTimeRank invokes the dataworks_public.GetInstanceConsumeTimeRank API synchronously
func (client *Client) GetInstanceConsumeTimeRank(request *GetInstanceConsumeTimeRankRequest) (response *GetInstanceConsumeTimeRankResponse, err error) {
	response = CreateGetInstanceConsumeTimeRankResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceConsumeTimeRankWithChan invokes the dataworks_public.GetInstanceConsumeTimeRank API asynchronously
func (client *Client) GetInstanceConsumeTimeRankWithChan(request *GetInstanceConsumeTimeRankRequest) (<-chan *GetInstanceConsumeTimeRankResponse, <-chan error) {
	responseChan := make(chan *GetInstanceConsumeTimeRankResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceConsumeTimeRank(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceConsumeTimeRankWithCallback invokes the dataworks_public.GetInstanceConsumeTimeRank API asynchronously
func (client *Client) GetInstanceConsumeTimeRankWithCallback(request *GetInstanceConsumeTimeRankRequest, callback func(response *GetInstanceConsumeTimeRankResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceConsumeTimeRankResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceConsumeTimeRank(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceConsumeTimeRankRequest is the request struct for api GetInstanceConsumeTimeRank
type GetInstanceConsumeTimeRankRequest struct {
	*requests.RpcRequest
	Bizdate   string           `position:"Body" name:"Bizdate"`
	ProjectId requests.Integer `position:"Body" name:"ProjectId"`
}

// GetInstanceConsumeTimeRankResponse is the response struct for api GetInstanceConsumeTimeRank
type GetInstanceConsumeTimeRankResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	InstanceConsumeTimeRank InstanceConsumeTimeRank `json:"InstanceConsumeTimeRank" xml:"InstanceConsumeTimeRank"`
}

// CreateGetInstanceConsumeTimeRankRequest creates a request to invoke GetInstanceConsumeTimeRank API
func CreateGetInstanceConsumeTimeRankRequest() (request *GetInstanceConsumeTimeRankRequest) {
	request = &GetInstanceConsumeTimeRankRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetInstanceConsumeTimeRank", "", "")
	request.Method = requests.POST
	return
}

// CreateGetInstanceConsumeTimeRankResponse creates a response to parse from GetInstanceConsumeTimeRank response
func CreateGetInstanceConsumeTimeRankResponse() (response *GetInstanceConsumeTimeRankResponse) {
	response = &GetInstanceConsumeTimeRankResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
