package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindServiceCredentialStatisticalData invokes the csb.FindServiceCredentialStatisticalData API synchronously
// api document: https://help.aliyun.com/api/csb/findservicecredentialstatisticaldata.html
func (client *Client) FindServiceCredentialStatisticalData(request *FindServiceCredentialStatisticalDataRequest) (response *FindServiceCredentialStatisticalDataResponse, err error) {
	response = CreateFindServiceCredentialStatisticalDataResponse()
	err = client.DoAction(request, response)
	return
}

// FindServiceCredentialStatisticalDataWithChan invokes the csb.FindServiceCredentialStatisticalData API asynchronously
// api document: https://help.aliyun.com/api/csb/findservicecredentialstatisticaldata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindServiceCredentialStatisticalDataWithChan(request *FindServiceCredentialStatisticalDataRequest) (<-chan *FindServiceCredentialStatisticalDataResponse, <-chan error) {
	responseChan := make(chan *FindServiceCredentialStatisticalDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindServiceCredentialStatisticalData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindServiceCredentialStatisticalDataWithCallback invokes the csb.FindServiceCredentialStatisticalData API asynchronously
// api document: https://help.aliyun.com/api/csb/findservicecredentialstatisticaldata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindServiceCredentialStatisticalDataWithCallback(request *FindServiceCredentialStatisticalDataRequest, callback func(response *FindServiceCredentialStatisticalDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindServiceCredentialStatisticalDataResponse
		var err error
		defer close(result)
		response, err = client.FindServiceCredentialStatisticalData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindServiceCredentialStatisticalDataRequest is the request struct for api FindServiceCredentialStatisticalData
type FindServiceCredentialStatisticalDataRequest struct {
	*requests.RpcRequest
	CsbId              requests.Integer `position:"Query" name:"CsbId"`
	EndTime            requests.Integer `position:"Query" name:"EndTime"`
	StartTime          requests.Integer `position:"Query" name:"StartTime"`
	CredentialName     string           `position:"Query" name:"CredentialName"`
	ServiceNameVersion string           `position:"Query" name:"ServiceNameVersion"`
}

// FindServiceCredentialStatisticalDataResponse is the response struct for api FindServiceCredentialStatisticalData
type FindServiceCredentialStatisticalDataResponse struct {
	*responses.BaseResponse
	Code      int                                        `json:"Code" xml:"Code"`
	Message   string                                     `json:"Message" xml:"Message"`
	RequestId string                                     `json:"RequestId" xml:"RequestId"`
	Data      DataInFindServiceCredentialStatisticalData `json:"Data" xml:"Data"`
}

// CreateFindServiceCredentialStatisticalDataRequest creates a request to invoke FindServiceCredentialStatisticalData API
func CreateFindServiceCredentialStatisticalDataRequest() (request *FindServiceCredentialStatisticalDataRequest) {
	request = &FindServiceCredentialStatisticalDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "FindServiceCredentialStatisticalData", "", "")
	request.Method = requests.GET
	return
}

// CreateFindServiceCredentialStatisticalDataResponse creates a response to parse from FindServiceCredentialStatisticalData response
func CreateFindServiceCredentialStatisticalDataResponse() (response *FindServiceCredentialStatisticalDataResponse) {
	response = &FindServiceCredentialStatisticalDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
