package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCompliancePacks invokes the config.ListCompliancePacks API synchronously
func (client *Client) ListCompliancePacks(request *ListCompliancePacksRequest) (response *ListCompliancePacksResponse, err error) {
	response = CreateListCompliancePacksResponse()
	err = client.DoAction(request, response)
	return
}

// ListCompliancePacksWithChan invokes the config.ListCompliancePacks API asynchronously
func (client *Client) ListCompliancePacksWithChan(request *ListCompliancePacksRequest) (<-chan *ListCompliancePacksResponse, <-chan error) {
	responseChan := make(chan *ListCompliancePacksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCompliancePacks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCompliancePacksWithCallback invokes the config.ListCompliancePacks API asynchronously
func (client *Client) ListCompliancePacksWithCallback(request *ListCompliancePacksRequest, callback func(response *ListCompliancePacksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCompliancePacksResponse
		var err error
		defer close(result)
		response, err = client.ListCompliancePacks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCompliancePacksRequest is the request struct for api ListCompliancePacks
type ListCompliancePacksRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Status     string           `position:"Query" name:"Status"`
}

// ListCompliancePacksResponse is the response struct for api ListCompliancePacks
type ListCompliancePacksResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	CompliancePacksResult CompliancePacksResult `json:"CompliancePacksResult" xml:"CompliancePacksResult"`
}

// CreateListCompliancePacksRequest creates a request to invoke ListCompliancePacks API
func CreateListCompliancePacksRequest() (request *ListCompliancePacksRequest) {
	request = &ListCompliancePacksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListCompliancePacks", "", "")
	request.Method = requests.GET
	return
}

// CreateListCompliancePacksResponse creates a response to parse from ListCompliancePacks response
func CreateListCompliancePacksResponse() (response *ListCompliancePacksResponse) {
	response = &ListCompliancePacksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
