package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVnPublishHistories invokes the cloudcallcenter.ListVnPublishHistories API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listvnpublishhistories.html
func (client *Client) ListVnPublishHistories(request *ListVnPublishHistoriesRequest) (response *ListVnPublishHistoriesResponse, err error) {
	response = CreateListVnPublishHistoriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListVnPublishHistoriesWithChan invokes the cloudcallcenter.ListVnPublishHistories API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listvnpublishhistories.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVnPublishHistoriesWithChan(request *ListVnPublishHistoriesRequest) (<-chan *ListVnPublishHistoriesResponse, <-chan error) {
	responseChan := make(chan *ListVnPublishHistoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVnPublishHistories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVnPublishHistoriesWithCallback invokes the cloudcallcenter.ListVnPublishHistories API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listvnpublishhistories.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVnPublishHistoriesWithCallback(request *ListVnPublishHistoriesRequest, callback func(response *ListVnPublishHistoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVnPublishHistoriesResponse
		var err error
		defer close(result)
		response, err = client.ListVnPublishHistories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVnPublishHistoriesRequest is the request struct for api ListVnPublishHistories
type ListVnPublishHistoriesRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListVnPublishHistoriesResponse is the response struct for api ListVnPublishHistories
type ListVnPublishHistoriesResponse struct {
	*responses.BaseResponse
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	TotalCount       int                    `json:"TotalCount" xml:"TotalCount"`
	PageNumber       int                    `json:"PageNumber" xml:"PageNumber"`
	PageSize         int                    `json:"PageSize" xml:"PageSize"`
	PublishHistories []PublishHistoriesItem `json:"PublishHistories" xml:"PublishHistories"`
}

// CreateListVnPublishHistoriesRequest creates a request to invoke ListVnPublishHistories API
func CreateListVnPublishHistoriesRequest() (request *ListVnPublishHistoriesRequest) {
	request = &ListVnPublishHistoriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListVnPublishHistories", "", "")
	request.Method = requests.GET
	return
}

// CreateListVnPublishHistoriesResponse creates a response to parse from ListVnPublishHistories response
func CreateListVnPublishHistoriesResponse() (response *ListVnPublishHistoriesResponse) {
	response = &ListVnPublishHistoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
