package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSkillGroupData invokes the cloudcallcenter.ListSkillGroupData API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listskillgroupdata.html
func (client *Client) ListSkillGroupData(request *ListSkillGroupDataRequest) (response *ListSkillGroupDataResponse, err error) {
	response = CreateListSkillGroupDataResponse()
	err = client.DoAction(request, response)
	return
}

// ListSkillGroupDataWithChan invokes the cloudcallcenter.ListSkillGroupData API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listskillgroupdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSkillGroupDataWithChan(request *ListSkillGroupDataRequest) (<-chan *ListSkillGroupDataResponse, <-chan error) {
	responseChan := make(chan *ListSkillGroupDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSkillGroupData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSkillGroupDataWithCallback invokes the cloudcallcenter.ListSkillGroupData API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listskillgroupdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSkillGroupDataWithCallback(request *ListSkillGroupDataRequest, callback func(response *ListSkillGroupDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSkillGroupDataResponse
		var err error
		defer close(result)
		response, err = client.ListSkillGroupData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSkillGroupDataRequest is the request struct for api ListSkillGroupData
type ListSkillGroupDataRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	StartDay   string           `position:"Query" name:"StartDay"`
	EndDay     string           `position:"Query" name:"EndDay"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListSkillGroupDataResponse is the response struct for api ListSkillGroupData
type ListSkillGroupDataResponse struct {
	*responses.BaseResponse
	RequestId      string                       `json:"RequestId" xml:"RequestId"`
	Success        bool                         `json:"Success" xml:"Success"`
	Code           string                       `json:"Code" xml:"Code"`
	Message        string                       `json:"Message" xml:"Message"`
	HttpStatusCode int                          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DataList       DataListInListSkillGroupData `json:"DataList" xml:"DataList"`
}

// CreateListSkillGroupDataRequest creates a request to invoke ListSkillGroupData API
func CreateListSkillGroupDataRequest() (request *ListSkillGroupDataRequest) {
	request = &ListSkillGroupDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListSkillGroupData", "", "")
	request.Method = requests.POST
	return
}

// CreateListSkillGroupDataResponse creates a response to parse from ListSkillGroupData response
func CreateListSkillGroupDataResponse() (response *ListSkillGroupDataResponse) {
	response = &ListSkillGroupDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
