package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRecords invokes the cloudcallcenter.ListRecords API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listrecords.html
func (client *Client) ListRecords(request *ListRecordsRequest) (response *ListRecordsResponse, err error) {
	response = CreateListRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// ListRecordsWithChan invokes the cloudcallcenter.ListRecords API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listrecords.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRecordsWithChan(request *ListRecordsRequest) (<-chan *ListRecordsResponse, <-chan error) {
	responseChan := make(chan *ListRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRecordsWithCallback invokes the cloudcallcenter.ListRecords API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listrecords.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRecordsWithCallback(request *ListRecordsRequest, callback func(response *ListRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRecordsResponse
		var err error
		defer close(result)
		response, err = client.ListRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRecordsRequest is the request struct for api ListRecords
type ListRecordsRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	QueryParam string           `position:"Query" name:"QueryParam"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListRecordsResponse is the response struct for api ListRecords
type ListRecordsResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	Code           string         `json:"Code" xml:"Code"`
	Message        string         `json:"Message" xml:"Message"`
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RecordFileList RecordFileList `json:"RecordFileList" xml:"RecordFileList"`
}

// CreateListRecordsRequest creates a request to invoke ListRecords API
func CreateListRecordsRequest() (request *ListRecordsRequest) {
	request = &ListRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListRecords", "", "")
	request.Method = requests.POST
	return
}

// CreateListRecordsResponse creates a response to parse from ListRecords response
func CreateListRecordsResponse() (response *ListRecordsResponse) {
	response = &ListRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
